/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import org.olsr.v1.info.api.util.CompareUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class JsonInfoLinksEntry
implements Comparable<JsonInfoLinksEntry> {
    private String localIP = "";
    private String remoteIP = "";
    private String olsrInterface = "";
    private String ifName = "";
    private long validityTime = 0L;
    private long symmetryTime = 0L;
    private long asymmetryTime = 0L;
    private long vtime = 0L;
    private String currentLinkStatus = "";
    private String previousLinkStatus = "";
    private double hysteresis = 0.0;
    private boolean pending = false;
    private long lostLinkTime = 0L;
    private long helloTime = 0L;
    private long lastHelloTime = 0L;
    private boolean seqnoValid = false;
    private int seqno = 0;
    private long lossHelloInterval = 0L;
    private long lossTime = 0L;
    private long lossMultiplier = 0L;
    private double linkCost = Double.POSITIVE_INFINITY;
    private double linkQuality = 0.0;
    private double neighborLinkQuality = 0.0;

    public String getLocalIP() {
        return this.localIP;
    }

    @JsonProperty(value="localIP")
    public void setLocalIP(InetAddress localIP) {
        this.localIP = localIP == null ? "" : localIP.getHostAddress();
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    @JsonProperty(value="remoteIP")
    public void setRemoteIP(InetAddress remoteIP) {
        this.remoteIP = remoteIP == null ? "" : remoteIP.getHostAddress();
    }

    public String getOlsrInterface() {
        return this.olsrInterface;
    }

    @JsonProperty(value="olsrInterface")
    public void setOlsrInterface(String olsrInterface) {
        this.olsrInterface = olsrInterface == null ? "" : olsrInterface;
    }

    public String getIfName() {
        return this.ifName;
    }

    @JsonProperty(value="ifName")
    public void setIfName(String ifName) {
        this.ifName = ifName == null ? "" : ifName;
    }

    public long getValidityTime() {
        return this.validityTime;
    }

    @JsonProperty(value="validityTime")
    public void setValidityTime(long validityTime) {
        this.validityTime = validityTime;
    }

    public long getSymmetryTime() {
        return this.symmetryTime;
    }

    @JsonProperty(value="symmetryTime")
    public void setSymmetryTime(long symmetryTime) {
        this.symmetryTime = symmetryTime;
    }

    public long getAsymmetryTime() {
        return this.asymmetryTime;
    }

    @JsonProperty(value="asymmetryTime")
    public void setAsymmetryTime(long asymmetryTime) {
        this.asymmetryTime = asymmetryTime;
    }

    public long getVtime() {
        return this.vtime;
    }

    @JsonProperty(value="vtime")
    public void setVtime(long vtime) {
        this.vtime = vtime;
    }

    public String getCurrentLinkStatus() {
        return this.currentLinkStatus;
    }

    @JsonProperty(value="currentLinkStatus")
    public void setCurrentLinkStatus(String currentLinkStatus) {
        this.currentLinkStatus = currentLinkStatus == null ? "" : currentLinkStatus;
    }

    public String getPreviousLinkStatus() {
        return this.previousLinkStatus;
    }

    @JsonProperty(value="previousLinkStatus")
    public void setPreviousLinkStatus(String previousLinkStatus) {
        this.previousLinkStatus = previousLinkStatus == null ? "" : previousLinkStatus;
    }

    public double getHysteresis() {
        return this.hysteresis;
    }

    @JsonProperty(value="hysteresis")
    public void setHysteresis(double hysteresis) {
        this.hysteresis = hysteresis;
    }

    public boolean getPending() {
        return this.pending;
    }

    @JsonProperty(value="pending")
    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public long getLostLinkTime() {
        return this.lostLinkTime;
    }

    @JsonProperty(value="lostLinkTime")
    public void setLostLinkTime(long lostLinkTime) {
        this.lostLinkTime = lostLinkTime;
    }

    public long getHelloTime() {
        return this.helloTime;
    }

    @JsonProperty(value="helloTime")
    public void setHelloTime(long helloTime) {
        this.helloTime = helloTime;
    }

    public long getLastHelloTime() {
        return this.lastHelloTime;
    }

    @JsonProperty(value="lastHelloTime")
    public void setLastHelloTime(long lastHelloTime) {
        this.lastHelloTime = lastHelloTime;
    }

    public boolean getSeqnoValid() {
        return this.seqnoValid;
    }

    @JsonProperty(value="seqnoValid")
    public void setSeqnoValid(boolean seqnoValid) {
        this.seqnoValid = seqnoValid;
    }

    public int getSeqno() {
        return this.seqno;
    }

    @JsonProperty(value="seqno")
    public void setSeqno(int seqno) {
        this.seqno = seqno;
    }

    public long getLossHelloInterval() {
        return this.lossHelloInterval;
    }

    @JsonProperty(value="lossHelloInterval")
    public void setLossHelloInterval(long lossHelloInterval) {
        this.lossHelloInterval = lossHelloInterval;
    }

    public long getLossTime() {
        return this.lossTime;
    }

    @JsonProperty(value="lossTime")
    public void setLossTime(long lossTime) {
        this.lossTime = lossTime;
    }

    public long getLossMultiplier() {
        return this.lossMultiplier;
    }

    @JsonProperty(value="lossMultiplier")
    public void setLossMultiplier(long lossMultiplier) {
        this.lossMultiplier = lossMultiplier;
    }

    public double getLinkCost() {
        return this.linkCost;
    }

    @JsonProperty(value="linkCost")
    public void setLinkCost(double linkCost) {
        this.linkCost = Double.compare(linkCost, 4194304.0) >= 0 ? Double.POSITIVE_INFINITY : linkCost;
    }

    public double getLinkQuality() {
        return this.linkQuality;
    }

    @JsonProperty(value="linkQuality")
    public void setLinkQuality(double linkQuality) {
        this.linkQuality = linkQuality;
    }

    public double getNeighborLinkQuality() {
        return this.neighborLinkQuality;
    }

    @JsonProperty(value="neighborLinkQuality")
    public void setNeighborLinkQuality(double neighborLinkQuality) {
        this.neighborLinkQuality = neighborLinkQuality;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.localIP.hashCode();
        result = 31 * result + this.remoteIP.hashCode();
        result = 31 * result + this.olsrInterface.hashCode();
        result = 31 * result + this.ifName.hashCode();
        result = 31 * result + (int)(this.validityTime ^ this.validityTime >>> 32);
        result = 31 * result + (int)(this.symmetryTime ^ this.symmetryTime >>> 32);
        result = 31 * result + (int)(this.asymmetryTime ^ this.asymmetryTime >>> 32);
        result = 31 * result + (int)(this.vtime ^ this.vtime >>> 32);
        result = 31 * result + this.currentLinkStatus.hashCode();
        result = 31 * result + this.previousLinkStatus.hashCode();
        long temp = Double.doubleToLongBits(this.hysteresis);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.pending ? 1231 : 1237);
        result = 31 * result + (int)(this.lostLinkTime ^ this.lostLinkTime >>> 32);
        result = 31 * result + (int)(this.helloTime ^ this.helloTime >>> 32);
        result = 31 * result + (int)(this.lastHelloTime ^ this.lastHelloTime >>> 32);
        result = 31 * result + (this.seqnoValid ? 1231 : 1237);
        result = 31 * result + this.seqno;
        result = 31 * result + (int)(this.lossHelloInterval ^ this.lossHelloInterval >>> 32);
        result = 31 * result + (int)(this.lossTime ^ this.lossTime >>> 32);
        result = 31 * result + (int)(this.lossMultiplier ^ this.lossMultiplier >>> 32);
        temp = Double.doubleToLongBits(this.linkCost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.linkQuality);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.neighborLinkQuality);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((JsonInfoLinksEntry)other) == 0;
    }

    @Override
    public int compareTo(JsonInfoLinksEntry other) {
        if (other == null) {
            return -1;
        }
        int result = this.olsrInterface.compareTo(other.olsrInterface);
        if (result != 0) {
            return result;
        }
        result = this.ifName.compareTo(other.ifName);
        if (result != 0) {
            return result;
        }
        result = this.localIP.compareTo(other.localIP);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = this.remoteIP.compareTo(other.remoteIP);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = this.currentLinkStatus.compareTo(other.currentLinkStatus);
        if (result != 0) {
            return result;
        }
        result = this.previousLinkStatus.compareTo(other.previousLinkStatus);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.validityTime, other.validityTime);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.symmetryTime, other.symmetryTime);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.asymmetryTime, other.asymmetryTime);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.vtime, other.vtime);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.hysteresis, other.hysteresis);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.pending, other.pending);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.lostLinkTime, other.lostLinkTime);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.helloTime, other.helloTime);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.lastHelloTime, other.lastHelloTime);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.seqnoValid, other.seqnoValid);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.seqno, other.seqno);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.lossHelloInterval, other.lossHelloInterval);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.lossTime, other.lossTime);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.lossMultiplier, other.lossMultiplier);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.linkCost, other.linkCost);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.linkQuality, other.linkQuality);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.neighborLinkQuality, other.neighborLinkQuality);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JsonInfoLinksEntry [localIP=");
        builder.append(this.localIP);
        builder.append(", remoteIP=");
        builder.append(this.remoteIP);
        builder.append(", olsrInterface=");
        builder.append(this.olsrInterface);
        builder.append(", ifName=");
        builder.append(this.ifName);
        builder.append(", validityTime=");
        builder.append(this.validityTime);
        builder.append(", symmetryTime=");
        builder.append(this.symmetryTime);
        builder.append(", asymmetryTime=");
        builder.append(this.asymmetryTime);
        builder.append(", vtime=");
        builder.append(this.vtime);
        builder.append(", currentLinkStatus=");
        builder.append(this.currentLinkStatus);
        builder.append(", previousLinkStatus=");
        builder.append(this.previousLinkStatus);
        builder.append(", hysteresis=");
        builder.append(this.hysteresis);
        builder.append(", pending=");
        builder.append(this.pending);
        builder.append(", lostLinkTime=");
        builder.append(this.lostLinkTime);
        builder.append(", helloTime=");
        builder.append(this.helloTime);
        builder.append(", lastHelloTime=");
        builder.append(this.lastHelloTime);
        builder.append(", seqnoValid=");
        builder.append(this.seqnoValid);
        builder.append(", seqno=");
        builder.append(this.seqno);
        builder.append(", lossHelloInterval=");
        builder.append(this.lossHelloInterval);
        builder.append(", lossTime=");
        builder.append(this.lossTime);
        builder.append(", lossMultiplier=");
        builder.append(this.lossMultiplier);
        builder.append(", linkCost=");
        builder.append(this.linkCost);
        builder.append(", linkQuality=");
        builder.append(this.linkQuality);
        builder.append(", neighborLinkQuality=");
        builder.append(this.neighborLinkQuality);
        builder.append("]");
        return builder.toString();
    }
}

