/******************************************************************************
 *
 * error.c - part of smap
 *
 * $Id: error.c,v 1.2 2006-07-03 16:58:16 hscholz Exp $
 *****************************************************************************/

#ifndef _ERROR_C
#define _ERROR_C
#include "config.h"

/*****************************************************************************
 *
 * error()
 *
 * print error message and exit if needed
 *
 ****************************************************************************/

void error(int level, char *msg, ... )
{
	extern struct config_t config;
	va_list arguments;
	static char buffer[ERRBUF];

	va_start(arguments, msg);
	vsnprintf(buffer, sizeof(buffer)-1, msg, arguments);

	fflush(stdout);

	switch (level) {
		case ERR_DEBUG:
			if (config.debug > 0)
				fprintf(stderr, "DEBUG: ");
			break;
		case ERR_NOTICE:
			fprintf(stderr, "NOTICE: ");
			break;
		case ERR_ERROR:
			fprintf(stderr, "ERROR: ");
			break;
		case ERR_FATAL:
			fprintf(stderr, "FATAL: ");
			break;
	}
	if  (((config.debug > 0) && level == ERR_DEBUG) || (level != ERR_DEBUG)) {
		fprintf(stderr, "%s", buffer);
		va_end(arguments);
		fprintf(stderr, "\n");
	}
	if (level == ERR_FATAL)
		exit(1);

	fflush(stderr);

	return;
}
#endif
