/******************************************************************************
 *
 * results.c - part of smap
 * 
 * $Id: results.c,v 1.1 2007-10-07 10:15:11 hscholz Exp $
 *****************************************************************************/

#ifndef _RESULTS_C
#define _RESULTS_C

#include "config.h"

/******************************************************************************
 *
 * results_print()
 *
 * print smap results for a single task
 *
 *****************************************************************************/

void results_print(task_t *task) {
	extern pthread_mutex_t scrlock;

	FUNCTION(__FILE__, __FUNCTION__);
	pthread_mutex_lock(&scrlock);

	switch (task->scan_type) {
	case SCAN_ENABLED:
		printf("%s: ICMP %s, SIP %s\n",
			inet_ntoa(task->target),
			(config.flags & FLAG_NOICMPPING) ? "not tested" :
			(task->results & RES_ICMP_REACH) ? "reachable" : "unreachable",
			(task->results & RES_SIP_ENABLED) ? "enabled" : "disabled");
		break;
	case SCAN_FINGERPRINT:
		printf("%s: ICMP %s, SIP %s\n",
			inet_ntoa(task->target),
			(config.flags & FLAG_NOICMPPING) ? "not tested" :
			(task->results & RES_ICMP_REACH) ? "reachable" : "unreachable",
			(task->results & RES_SIP_ENABLED) ? "enabled" : "disabled");
		if (task->results & RES_SIP_ENABLED)
			fingerprint_lookup(*task->fp);
		break;
	default:
		error(ERR_ERROR, "unsupported scan_type");
		break;
	}
	pthread_mutex_unlock(&scrlock);
}

#endif /* _RESULTS_C */
