/******************************************************************************
 *
 * test_supported.c - part of smap
 * 
 * $Id: test_supported.c,v 1.6 2007-05-24 19:34:53 hscholz Exp $
 *****************************************************************************/
#ifndef _TEST_SUPPORTED_C
#define _TEST_SUPPORTED_C

#include "config.h"

/******************************************************************************
 *
 * Support header fingerprint meta database
 *
 * this list contains all different types of Support header combinations
 * found in live-traffic.
 *
 * How to add more?
 * - extend support_headers[], don't forget new int (third param)
 * - add param to fingerprint database where appropriate
 *
 *****************************************************************************/

#define SUPPORTED_LEN		256
#define SUPPORTED_DESCR		256
struct supported_header_t {
	char header[SUPPORTED_LEN];
	unsigned int class;
};

struct supported_header_t supported_headers[] = {
	{"Supported: 100rel, timer, replaces", 1},
	{"Supported: 100rel,replaces,timer", 2},
	{"Supported: 100rel, replaces", 3},
	{"Supported: 100rel", 4},
	{"Supported: com.microsoft.autoextend", 5},
	{"Supported: timer, 100rel, replaces", 6},
	{"Supported: timer,replaces", 7},
	/* Cisco 79x0 */
	{"Supported: replaces", 8},
	{"Supported: x-sipura", 9},
	{"Supported: gruu", 10},
	/* Thomson Speedtouch 780 */
	{"Supported: replaces,100rel", 11},
	/* TRACER 3.95 */
	{"Supported: replaces, timer", 12},
	/* Snom 360 */
	{"Supported: timer, 100rel, replaces, callerid", 13},
	/* Cisco 79x0 */
	{"Supported: replaces,join,norefersub", 14},
	{"", 0}
};

/******************************************************************************
 *
 * test_supported()
 *
 * Locate and analyze the Support-Header inside the passed SIP message
 *
 *****************************************************************************/

int test_supported(int *res, char *buf) {

	char *p, *n;
	struct supported_header_t hdr;
	int line, end;
	FUNCTION(__FILE__, __FUNCTION__);

	p = strcasestr(buf, "\r\nSupported:");
	if (p == NULL) {
		error(ERR_DEBUG, "message does not contain Supported header");
		return 0;
	}
	p += 2; /* skip leading \r\n */
	n = strstr(p, "\r\n");
	if (n == NULL) {
		error(ERR_DEBUG, "cannot locate end of Supported header");
		return 0;
	}
	if (IS_LEARNING || DEBUG)
		error(ERR_NOTICE, "test_supported: \"%.*s\"", (int) (n-p), p);
	line = 0;
	end = 0;
	hdr = supported_headers[line];
	while ((hdr.header[0] != 0) && !end) {
		if ((strlen(hdr.header) == (n-p)) &&
			!strncmp(hdr.header, p, (n-p))) {

			end++;	/* correct line found */
			*res = hdr.class;
		}
		hdr = supported_headers[++line];
	}
	if (!end && IS_LEARNING)
		error(ERR_NOTICE, "%s: Please add Supported: header", __FUNCTION__);
	return end? 1 : 0;
}

#endif /* _TEST_SUPPORTED_C */
