/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterSignature {
    private static final Map<Class<?>, Class<?>> CONVERTABLE_TYPES_MAP = ParameterSignature.buildConvertableTypesMap();
    private final Class<?> type;
    private final Annotation[] annotations;

    private static Map<Class<?>, Class<?>> buildConvertableTypesMap() {
        HashMap hashMap = new HashMap();
        ParameterSignature.putSymmetrically(hashMap, Boolean.TYPE, Boolean.class);
        ParameterSignature.putSymmetrically(hashMap, Byte.TYPE, Byte.class);
        ParameterSignature.putSymmetrically(hashMap, Short.TYPE, Short.class);
        ParameterSignature.putSymmetrically(hashMap, Character.TYPE, Character.class);
        ParameterSignature.putSymmetrically(hashMap, Integer.TYPE, Integer.class);
        ParameterSignature.putSymmetrically(hashMap, Long.TYPE, Long.class);
        ParameterSignature.putSymmetrically(hashMap, Float.TYPE, Float.class);
        ParameterSignature.putSymmetrically(hashMap, Double.TYPE, Double.class);
        return Collections.unmodifiableMap(hashMap);
    }

    private static <T> void putSymmetrically(Map<T, T> map, T t, T t2) {
        map.put(t, t2);
        map.put(t2, t);
    }

    public static ArrayList<ParameterSignature> signatures(Method method) {
        return ParameterSignature.signatures(method.getParameterTypes(), method.getParameterAnnotations());
    }

    public static List<ParameterSignature> signatures(Constructor<?> constructor) {
        return ParameterSignature.signatures(constructor.getParameterTypes(), constructor.getParameterAnnotations());
    }

    private static ArrayList<ParameterSignature> signatures(Class<?>[] classArray, Annotation[][] annotationArray) {
        ArrayList<ParameterSignature> arrayList = new ArrayList<ParameterSignature>();
        for (int i = 0; i < classArray.length; ++i) {
            arrayList.add(new ParameterSignature(classArray[i], annotationArray[i]));
        }
        return arrayList;
    }

    private ParameterSignature(Class<?> clazz, Annotation[] annotationArray) {
        this.type = clazz;
        this.annotations = annotationArray;
    }

    public boolean canAcceptValue(Object object) {
        return object == null ? !this.type.isPrimitive() : this.canAcceptType(object.getClass());
    }

    public boolean canAcceptType(Class<?> clazz) {
        return this.type.isAssignableFrom(clazz) || this.isAssignableViaTypeConversion(this.type, clazz);
    }

    public boolean canPotentiallyAcceptType(Class<?> clazz) {
        return clazz.isAssignableFrom(this.type) || this.isAssignableViaTypeConversion(clazz, this.type) || this.canAcceptType(clazz);
    }

    private boolean isAssignableViaTypeConversion(Class<?> clazz, Class<?> clazz2) {
        if (CONVERTABLE_TYPES_MAP.containsKey(clazz2)) {
            Class<?> clazz3 = CONVERTABLE_TYPES_MAP.get(clazz2);
            return clazz.isAssignableFrom(clazz3);
        }
        return false;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<Annotation> getAnnotations() {
        return Arrays.asList(this.annotations);
    }

    public boolean hasAnnotation(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }

    public <T extends Annotation> T findDeepAnnotation(Class<T> clazz) {
        Annotation[] annotationArray = this.annotations;
        return this.findDeepAnnotation(annotationArray, clazz, 3);
    }

    private <T extends Annotation> T findDeepAnnotation(Annotation[] annotationArray, Class<T> clazz, int n) {
        if (n == 0) {
            return null;
        }
        for (Annotation annotation : annotationArray) {
            if (clazz.isInstance(annotation)) {
                return (T)((Annotation)clazz.cast(annotation));
            }
            T t = this.findDeepAnnotation(annotation.annotationType().getAnnotations(), clazz, n - 1);
            if (t == null) continue;
            return (T)((Annotation)clazz.cast(t));
        }
        return null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!clazz.isInstance(annotation)) continue;
            return (T)((Annotation)clazz.cast(annotation));
        }
        return null;
    }
}

