/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import java.util.ArrayList;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class RunAfters
extends Statement {
    private final Statement next;
    private final Object target;
    private final List<FrameworkMethod> afters;

    public RunAfters(Statement statement, List<FrameworkMethod> list, Object object) {
        this.next = statement;
        this.afters = list;
        this.target = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate() throws Throwable {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            this.next.evaluate();
        }
        catch (Throwable throwable) {
            arrayList.add(throwable);
        }
        finally {
            for (FrameworkMethod frameworkMethod : this.afters) {
                try {
                    frameworkMethod.invokeExplosively(this.target, new Object[0]);
                }
                catch (Throwable throwable) {
                    arrayList.add(throwable);
                }
            }
        }
        MultipleFailureException.assertEmpty(arrayList);
    }
}

