/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.parameterized;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runners.model.TestClass;

public class TestWithParameters {
    private final String name;
    private final TestClass testClass;
    private final List<Object> parameters;

    public TestWithParameters(String string, TestClass testClass, List<Object> list) {
        TestWithParameters.notNull(string, "The name is missing.");
        TestWithParameters.notNull(testClass, "The test class is missing.");
        TestWithParameters.notNull(list, "The parameters are missing.");
        this.name = string;
        this.testClass = testClass;
        this.parameters = Collections.unmodifiableList(new ArrayList<Object>(list));
    }

    public String getName() {
        return this.name;
    }

    public TestClass getTestClass() {
        return this.testClass;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        int n = 14747;
        int n2 = n + this.name.hashCode();
        n2 = n * n2 + this.testClass.hashCode();
        return n * n2 + this.parameters.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TestWithParameters testWithParameters = (TestWithParameters)object;
        return this.name.equals(testWithParameters.name) && this.parameters.equals(testWithParameters.parameters) && this.testClass.equals(testWithParameters.testClass);
    }

    public String toString() {
        return this.testClass.getName() + " '" + this.name + "' with parameters " + this.parameters;
    }

    private static void notNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }
}

