/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ComparisonFailure;
import org.junit.internal.ArrayComparisonFailure;
import org.junit.internal.ExactComparisonCriteria;
import org.junit.internal.InexactComparisonCriteria;

public class Assert {
    protected Assert() {
    }

    public static void assertTrue(String string, boolean bl) {
        if (!bl) {
            Assert.fail(string);
        }
    }

    public static void assertTrue(boolean bl) {
        Assert.assertTrue(null, bl);
    }

    public static void assertFalse(String string, boolean bl) {
        Assert.assertTrue(string, !bl);
    }

    public static void assertFalse(boolean bl) {
        Assert.assertFalse(null, bl);
    }

    public static void fail(String string) {
        if (string == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)string);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(String string, Object object, Object object2) {
        if (Assert.equalsRegardingNull(object, object2)) {
            return;
        }
        if (object instanceof String && object2 instanceof String) {
            String string2 = string == null ? "" : string;
            throw new ComparisonFailure(string2, (String)object, (String)object2);
        }
        Assert.failNotEquals(string, object, object2);
    }

    private static boolean equalsRegardingNull(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return Assert.isEquals(object, object2);
    }

    private static boolean isEquals(Object object, Object object2) {
        return object.equals(object2);
    }

    public static void assertEquals(Object object, Object object2) {
        Assert.assertEquals(null, object, object2);
    }

    public static void assertNotEquals(String string, Object object, Object object2) {
        if (Assert.equalsRegardingNull(object, object2)) {
            Assert.failEquals(string, object2);
        }
    }

    public static void assertNotEquals(Object object, Object object2) {
        Assert.assertNotEquals(null, object, object2);
    }

    private static void failEquals(String string, Object object) {
        String string2 = "Values should be different. ";
        if (string != null) {
            string2 = string + ". ";
        }
        string2 = string2 + "Actual: " + object;
        Assert.fail(string2);
    }

    public static void assertNotEquals(String string, long l, long l2) {
        if (l == l2) {
            Assert.failEquals(string, l2);
        }
    }

    public static void assertNotEquals(long l, long l2) {
        Assert.assertNotEquals(null, l, l2);
    }

    public static void assertNotEquals(String string, double d, double d2, double d3) {
        if (!Assert.doubleIsDifferent(d, d2, d3)) {
            Assert.failEquals(string, d2);
        }
    }

    public static void assertNotEquals(double d, double d2, double d3) {
        Assert.assertNotEquals(null, d, d2, d3);
    }

    public static void assertNotEquals(float f, float f2, float f3) {
        Assert.assertNotEquals(null, f, f2, f3);
    }

    public static void assertArrayEquals(String string, Object[] objectArray, Object[] objectArray2) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(string, objectArray, objectArray2);
    }

    public static void assertArrayEquals(Object[] objectArray, Object[] objectArray2) {
        Assert.assertArrayEquals(null, objectArray, objectArray2);
    }

    public static void assertArrayEquals(String string, boolean[] blArray, boolean[] blArray2) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(string, blArray, blArray2);
    }

    public static void assertArrayEquals(boolean[] blArray, boolean[] blArray2) {
        Assert.assertArrayEquals(null, blArray, blArray2);
    }

    public static void assertArrayEquals(String string, byte[] byArray, byte[] byArray2) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(string, byArray, byArray2);
    }

    public static void assertArrayEquals(byte[] byArray, byte[] byArray2) {
        Assert.assertArrayEquals(null, byArray, byArray2);
    }

    public static void assertArrayEquals(String string, char[] cArray, char[] cArray2) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(string, cArray, cArray2);
    }

    public static void assertArrayEquals(char[] cArray, char[] cArray2) {
        Assert.assertArrayEquals(null, cArray, cArray2);
    }

    public static void assertArrayEquals(String string, short[] sArray, short[] sArray2) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(string, sArray, sArray2);
    }

    public static void assertArrayEquals(short[] sArray, short[] sArray2) {
        Assert.assertArrayEquals(null, sArray, sArray2);
    }

    public static void assertArrayEquals(String string, int[] nArray, int[] nArray2) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(string, nArray, nArray2);
    }

    public static void assertArrayEquals(int[] nArray, int[] nArray2) {
        Assert.assertArrayEquals(null, nArray, nArray2);
    }

    public static void assertArrayEquals(String string, long[] lArray, long[] lArray2) throws ArrayComparisonFailure {
        Assert.internalArrayEquals(string, lArray, lArray2);
    }

    public static void assertArrayEquals(long[] lArray, long[] lArray2) {
        Assert.assertArrayEquals(null, lArray, lArray2);
    }

    public static void assertArrayEquals(String string, double[] dArray, double[] dArray2, double d) throws ArrayComparisonFailure {
        new InexactComparisonCriteria(d).arrayEquals(string, dArray, dArray2);
    }

    public static void assertArrayEquals(double[] dArray, double[] dArray2, double d) {
        Assert.assertArrayEquals(null, dArray, dArray2, d);
    }

    public static void assertArrayEquals(String string, float[] fArray, float[] fArray2, float f) throws ArrayComparisonFailure {
        new InexactComparisonCriteria(f).arrayEquals(string, fArray, fArray2);
    }

    public static void assertArrayEquals(float[] fArray, float[] fArray2, float f) {
        Assert.assertArrayEquals(null, fArray, fArray2, f);
    }

    private static void internalArrayEquals(String string, Object object, Object object2) throws ArrayComparisonFailure {
        new ExactComparisonCriteria().arrayEquals(string, object, object2);
    }

    public static void assertEquals(String string, double d, double d2, double d3) {
        if (Assert.doubleIsDifferent(d, d2, d3)) {
            Assert.failNotEquals(string, d, d2);
        }
    }

    public static void assertEquals(String string, float f, float f2, float f3) {
        if (Assert.floatIsDifferent(f, f2, f3)) {
            Assert.failNotEquals(string, Float.valueOf(f), Float.valueOf(f2));
        }
    }

    public static void assertNotEquals(String string, float f, float f2, float f3) {
        if (!Assert.floatIsDifferent(f, f2, f3)) {
            Assert.failEquals(string, Float.valueOf(f2));
        }
    }

    private static boolean doubleIsDifferent(double d, double d2, double d3) {
        if (Double.compare(d, d2) == 0) {
            return false;
        }
        return !(Math.abs(d - d2) <= d3);
    }

    private static boolean floatIsDifferent(float f, float f2, float f3) {
        if (Float.compare(f, f2) == 0) {
            return false;
        }
        return !(Math.abs(f - f2) <= f3);
    }

    public static void assertEquals(long l, long l2) {
        Assert.assertEquals(null, l, l2);
    }

    public static void assertEquals(String string, long l, long l2) {
        if (l != l2) {
            Assert.failNotEquals(string, l, l2);
        }
    }

    @Deprecated
    public static void assertEquals(double d, double d2) {
        Assert.assertEquals(null, d, d2);
    }

    @Deprecated
    public static void assertEquals(String string, double d, double d2) {
        Assert.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public static void assertEquals(double d, double d2, double d3) {
        Assert.assertEquals(null, d, d2, d3);
    }

    public static void assertEquals(float f, float f2, float f3) {
        Assert.assertEquals(null, f, f2, f3);
    }

    public static void assertNotNull(String string, Object object) {
        Assert.assertTrue(string, object != null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static void assertNull(String string, Object object) {
        if (object == null) {
            return;
        }
        Assert.failNotNull(string, object);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    private static void failNotNull(String string, Object object) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Assert.fail(string2 + "expected null, but was:<" + object + ">");
    }

    public static void assertSame(String string, Object object, Object object2) {
        if (object == object2) {
            return;
        }
        Assert.failNotSame(string, object, object2);
    }

    public static void assertSame(Object object, Object object2) {
        Assert.assertSame(null, object, object2);
    }

    public static void assertNotSame(String string, Object object, Object object2) {
        if (object == object2) {
            Assert.failSame(string);
        }
    }

    public static void assertNotSame(Object object, Object object2) {
        Assert.assertNotSame(null, object, object2);
    }

    private static void failSame(String string) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Assert.fail(string2 + "expected not same");
    }

    private static void failNotSame(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = string + " ";
        }
        Assert.fail(string2 + "expected same:<" + object + "> was not:<" + object2 + ">");
    }

    private static void failNotEquals(String string, Object object, Object object2) {
        Assert.fail(Assert.format(string, object, object2));
    }

    static String format(String string, Object object, Object object2) {
        String string2;
        String string3;
        String string4 = "";
        if (string != null && !string.equals("")) {
            string4 = string + " ";
        }
        if ((string3 = String.valueOf(object)).equals(string2 = String.valueOf(object2))) {
            return string4 + "expected: " + Assert.formatClassAndValue(object, string3) + " but was: " + Assert.formatClassAndValue(object2, string2);
        }
        return string4 + "expected:<" + string3 + "> but was:<" + string2 + ">";
    }

    private static String formatClassAndValue(Object object, String string) {
        String string2 = object == null ? "null" : object.getClass().getName();
        return string2 + "<" + string + ">";
    }

    @Deprecated
    public static void assertEquals(String string, Object[] objectArray, Object[] objectArray2) {
        Assert.assertArrayEquals(string, objectArray, objectArray2);
    }

    @Deprecated
    public static void assertEquals(Object[] objectArray, Object[] objectArray2) {
        Assert.assertArrayEquals(objectArray, objectArray2);
    }

    public static <T> void assertThat(T t, Matcher<? super T> matcher) {
        Assert.assertThat("", t, matcher);
    }

    public static <T> void assertThat(String string, T t, Matcher<? super T> matcher) {
        MatcherAssert.assertThat((String)string, t, matcher);
    }
}

