/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RuleChain
implements TestRule {
    private static final RuleChain EMPTY_CHAIN = new RuleChain(Collections.<TestRule>emptyList());
    private List<TestRule> rulesStartingWithInnerMost;

    public static RuleChain emptyRuleChain() {
        return EMPTY_CHAIN;
    }

    public static RuleChain outerRule(TestRule testRule) {
        return RuleChain.emptyRuleChain().around(testRule);
    }

    private RuleChain(List<TestRule> list) {
        this.rulesStartingWithInnerMost = list;
    }

    public RuleChain around(TestRule testRule) {
        ArrayList<TestRule> arrayList = new ArrayList<TestRule>();
        arrayList.add(testRule);
        arrayList.addAll(this.rulesStartingWithInnerMost);
        return new RuleChain(arrayList);
    }

    @Override
    public Statement apply(Statement statement, Description description) {
        for (TestRule testRule : this.rulesStartingWithInnerMost) {
            statement = testRule.apply(statement, description);
        }
        return statement;
    }
}

