# How to Contribute

The Tvheadend project welcomes all submissions from the community. Without them the project couldn't hope to thrive.

We want to ensure that the process of submitting code is as simple as possible whilst ensuring that the project has the necessary provisions to fully utilise and handle all submissions. Therefore some short guidelines are provided here for reference.

For further info, please see https://tvheadend.org/projects/tvheadend/wiki/Contributors.

## Before you start

* Make sure you have a [GitHub account](https://github.com/signup/free)
* Make sure you have a [Redmine account](https://tvheadend.org)
* Log on to the IRC channel (#hts on freenode), this is the best place to discussion development work.
* Sign the [Contributor License Agreement](https://www.clahub.com/agreements/tvheadend/tvheadend)
* Fork the repository on Github

## Making Changes

* If unsure, discuss any potential work on IRC channel to avoid duplicate work.
* Create a branch to put your changes. Use a sensible name, i.e. feature/whizzbanger, or bugfix/redmine-1234.
  * It's strongly recommend you create one branch per feature/bugfix/etc..
* Make commits, try and keep commits to sensible units.
* Use sensible commit messages, prefix with subsystem, summary on first line, more detail on following lines and include reference to any related issue numbers in redmine.

````
mpegts dvb: Add foo feature to the DVB system.

Some more detail description of what has been done.

This fixes #1234.
````
* Submit a Pull Request on Github.

# Additional Resources

* [More information on contributing](https://tvheadend.org/projects/tvheadend/wiki/Contributors)
* [Bug tracker (Redmine)](https://tvheadend.org)
* [Contributor License Agreement](https://tvheadend.org/projects/tvheadend/wiki/Contributors)
* [General GitHub documentation](http://help.github.com/)
* [GitHub pull request documentation](http://help.github.com/send-pull-requests/)
* #hts IRC channel on freenode.org

