/*
* Copyright (C) 2016 Freescale Semiconductor Inc.
*
* SPDX-License-Identifier:GPL-2.0+
*/
#ifndef _MAC_HASH_H_
#define _MAC_HASH_H_

#define MAC_HASH_REQ1_BASE_ADDR		(MAC_HASH_BASE_ADDR + 0x000)
#define MAC_HASH_REQ2_BASE_ADDR		(MAC_HASH_BASE_ADDR + 0x020)
#define MAC_HASH_REQ3_BASE_ADDR		(MAC_HASH_BASE_ADDR + 0x040)
#define MAC_HASH_REQ4_BASE_ADDR		(MAC_HASH_BASE_ADDR + 0x060)
#define MAC_HASH_REQ5_BASE_ADDR		(MAC_HASH_BASE_ADDR + 0x080)
#define MAC_HASH_REQ6_BASE_ADDR		(MAC_HASH_BASE_ADDR + 0x0a0)
#define MAC_HASH_REQ7_BASE_ADDR		(MAC_HASH_BASE_ADDR + 0x0c0)
#define MAC_HASH_REQ8_BASE_ADDR		(MAC_HASH_BASE_ADDR + 0x0e0)

#define MAC_HASH_REQ_CMD(i)		(MAC_HASH_REQ##i##_BASE_ADDR + 0x000)
#define MAC_HASH_REQ_MAC1_ADDR(i)	(MAC_HASH_REQ##i##_BASE_ADDR + 0x004)
#define MAC_HASH_REQ_MAC2_ADDR(i)	(MAC_HASH_REQ##i##_BASE_ADDR + 0x008)
#define MAC_HASH_REQ_MASK1_ADDR(i)	(MAC_HASH_REQ##i##_BASE_ADDR + 0x00c)
#define MAC_HASH_REQ_MASK2_ADDR(i)	(MAC_HASH_REQ##i##_BASE_ADDR + 0x010)
#define MAC_HASH_REQ_ENTRY(i)		(MAC_HASH_REQ##i##_BASE_ADDR + 0x014)
#define MAC_HASH_REQ_STATUS(i)		(MAC_HASH_REQ##i##_BASE_ADDR + 0x018)
#define MAC_HASH_REQ_ENTRY_MAYCH(i)	(MAC_HASH_REQ##i##_BASE_ADDR + 0x01c)


#define MAC_HASH_FREELIST_PTR_HEAD	(MAC_HASH_BASE_ADDR + 0x100)
#define MAC_HASH_FREELIST_PTR_TAIL	(MAC_HASH_BASE_ADDR + 0x104)
#define MAC_HASH_FREELIST_ENTRIES_ADDR	(MAC_HASH_BASE_ADDR + 0x108)

#endif /* _MAC_HASH_H_ */

