/*
 * Copyright (C) 2017 Jianhui Zhao <jianhuizhao329@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <sys/sysinfo.h>
#include <uhttpd/uhttpd.h>
#include <libubox/ulog.h>

#include "http.h"
#include "config.h"

static time_t start_time;

static void ping_cb(void *data, char *body)
{
    if (!body || strcmp(body, "Pong"))
        ULOG_INFO("Auth server did NOT say Pong\n");
}

static void ping(struct uloop_timeout *t)
{
    struct config *conf = get_config();
    struct sysinfo info;

    uloop_timeout_set(t, 1000 * conf->checkinterval);

    memset(&info, 0, sizeof(info));
    
    if (sysinfo(&info) < 0) {
        ULOG_ERR("sysinfo:%s\n", strerror(errno));
        return;
    }

    httpget(ping_cb, NULL, "%s&sys_uptime=%ld&sys_memfree=%lu&sys_load=%lu&wifidog_uptime=%lu",
        conf->ping_url, info.uptime, info.freeram * info.mem_unit, info.loads[0], time(NULL) - start_time);
}

static struct uloop_timeout timeout = {
    .cb = ping
};

void start_heartbeat()
{
    if (start_time == 0)
        time(&start_time);
    
    uloop_timeout_set(&timeout, 0);
}

void stop_heartbeat()
{
    uloop_timeout_cancel(&timeout);
}
