//[File]            : conn_cfg.h
//[Revision time]   : Thu Apr 29 14:31:09 2021
//[Description]     : This file is auto generated by CODA
//[Copyright]       : Copyright (C) 2021 Mediatek Incorportion. All rights reserved.

#ifndef __CONN_CFG_REGS_H__
#define __CONN_CFG_REGS_H__

#include "hal_common.h"

#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************************
//
//                     CONN_CFG CR Definitions                     
//
//****************************************************************************

#define CONN_CFG_BASE                                          (0x18001000 + CONN_INFRA_REMAPPING_OFFSET)

#define CONN_CFG_IP_VERSION_ADDR                               (CONN_CFG_BASE + 0x000) // 1000
#define CONN_CFG_CFG_VERSION_ADDR                              (CONN_CFG_BASE + 0x004) // 1004
#define CONN_CFG_STRAP_STATUS_ADDR                             (CONN_CFG_BASE + 0x010) // 1010
#define CONN_CFG_BOOT_ADDR                                     (CONN_CFG_BASE + 0x014) // 1014
#define CONN_CFG_EFUSE_ADDR                                    (CONN_CFG_BASE + 0x020) // 1020
#define CONN_CFG_ADIE_CTL_ADDR                                 (CONN_CFG_BASE + 0x030) // 1030
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_ADDR                   (CONN_CFG_BASE + 0x0A0) // 10A0
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_ADDR            (CONN_CFG_BASE + 0x0B0) // 10B0
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_ADDR                 (CONN_CFG_BASE + 0x0C8) // 10C8
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_ADDR                (CONN_CFG_BASE + 0x0D8) // 10D8
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_ADDR                (CONN_CFG_BASE + 0x0DC) // 10DC
#define CONN_CFG_CONN_INFRA_SLP_TIMER_ADDR                     (CONN_CFG_BASE + 0x0E0) // 10E0
#define CONN_CFG_CONN_INFRA_SLP_COUNTER_ADDR                   (CONN_CFG_BASE + 0x0E4) // 10E4
#define CONN_CFG_CONN_INFRA_CFG_CONN2AP_MAILBOX_ADDR           (CONN_CFG_BASE + 0x100) // 1100
#define CONN_CFG_CONN_INFRA_CFG_AP2CONN_MAILBOX_ADDR           (CONN_CFG_BASE + 0x104) // 1104
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_ADDR            (CONN_CFG_BASE + 0x108) // 1108
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR           (CONN_CFG_BASE + 0x10C) // 110C
#define CONN_CFG_BGF_DUMMY_CR_0_ADDR                           (CONN_CFG_BASE + 0x140) // 1140
#define CONN_CFG_BGF_DUMMY_CR_1_ADDR                           (CONN_CFG_BASE + 0x144) // 1144
#define CONN_CFG_BGF_DUMMY_CR_2_ADDR                           (CONN_CFG_BASE + 0x148) // 1148
#define CONN_CFG_BGF_DUMMY_CR_3_ADDR                           (CONN_CFG_BASE + 0x14C) // 114C
#define CONN_CFG_WF_DUMMY_CR_0_ADDR                            (CONN_CFG_BASE + 0x160) // 1160
#define CONN_CFG_WF_DUMMY_CR_1_ADDR                            (CONN_CFG_BASE + 0x164) // 1164
#define CONN_CFG_WF_DUMMY_CR_2_ADDR                            (CONN_CFG_BASE + 0x168) // 1168
#define CONN_CFG_WF_DUMMY_CR_3_ADDR                            (CONN_CFG_BASE + 0x16C) // 116C
#define CONN_CFG_CONN_FPGA_DUMMY0_ADDR                         (CONN_CFG_BASE + 0x1C0) // 11C0
#define CONN_CFG_CONN_FPGA_DUMMY1_ADDR                         (CONN_CFG_BASE + 0x1C4) // 11C4
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR                  (CONN_CFG_BASE + 0x200) // 1200
#define CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_ADDR               (CONN_CFG_BASE + 0x204) // 1204
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_ADDR               (CONN_CFG_BASE + 0x208) // 1208
#define CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_ADDR              (CONN_CFG_BASE + 0x20C) // 120C
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_ADDR                 (CONN_CFG_BASE + 0x240) // 1240
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR                 (CONN_CFG_BASE + 0x244) // 1244
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_2_ADDR                 (CONN_CFG_BASE + 0x248) // 1248
#define CONN_CFG_OSC_CTL_0_ADDR                                (CONN_CFG_BASE + 0x300) // 1300
#define CONN_CFG_OSC_CTL_1_ADDR                                (CONN_CFG_BASE + 0x304) // 1304
#define CONN_CFG_OSC_MASK_ADDR                                 (CONN_CFG_BASE + 0x308) // 1308
#define CONN_CFG_OSC_STATUS_ADDR                               (CONN_CFG_BASE + 0x30C) // 130C
#define CONN_CFG_OSC_2X_CTL_0_ADDR                             (CONN_CFG_BASE + 0x310) // 1310
#define CONN_CFG_OSC_2X_CTL_1_ADDR                             (CONN_CFG_BASE + 0x314) // 1314
#define CONN_CFG_OSC_2X_MASK_ADDR                              (CONN_CFG_BASE + 0x318) // 1318
#define CONN_CFG_OSC_2X_STATUS_ADDR                            (CONN_CFG_BASE + 0x31C) // 131C
#define CONN_CFG_PLL_STATUS_ADDR                               (CONN_CFG_BASE + 0x320) // 1320
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR                  (CONN_CFG_BASE + 0x380) // 1380
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR                 (CONN_CFG_BASE + 0x384) // 1384
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_ADDR                  (CONN_CFG_BASE + 0x388) // 1388
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR              (CONN_CFG_BASE + 0x390) // 1390
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_ADDR              (CONN_CFG_BASE + 0x394) // 1394
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR               (CONN_CFG_BASE + 0x3A0) // 13A0
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_ADDR               (CONN_CFG_BASE + 0x3A4) // 13A4
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR               (CONN_CFG_BASE + 0x3B0) // 13B0
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_ADDR               (CONN_CFG_BASE + 0x3B4) // 13B4
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR              (CONN_CFG_BASE + 0x3C0) // 13C0
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_ADDR              (CONN_CFG_BASE + 0x3C4) // 13C4
#define CONN_CFG_EMI_CTL_0_ADDR                                (CONN_CFG_BASE + 0x400) // 1400
#define CONN_CFG_EMI_CTL_1_ADDR                                (CONN_CFG_BASE + 0x404) // 1404
#define CONN_CFG_EMI_CTL_TOP_ADDR                              (CONN_CFG_BASE + 0x410) // 1410
#define CONN_CFG_EMI_CTL_WF_ADDR                               (CONN_CFG_BASE + 0x414) // 1414
#define CONN_CFG_EMI_CTL_BT_ADDR                               (CONN_CFG_BASE + 0x418) // 1418
#define CONN_CFG_EMI_CTL_GPS_ADDR                              (CONN_CFG_BASE + 0x41C) // 141C
#define CONN_CFG_EMI_CTL_GPS_L1_ADDR                           (CONN_CFG_BASE + 0X420) // 1420
#define CONN_CFG_EMI_CTL_GPS_L5_ADDR                           (CONN_CFG_BASE + 0X424) // 1424
#define CONN_CFG_EMI_PROBE_ADDR                                (CONN_CFG_BASE + 0x480) // 1480
#define CONN_CFG_EMI_PROBE_1_ADDR                              (CONN_CFG_BASE + 0x484) // 1484
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR              (CONN_CFG_BASE + 0x500) // 1500
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR            (CONN_CFG_BASE + 0x504) // 1504
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR              (CONN_CFG_BASE + 0x510) // 1510
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_ADDR            (CONN_CFG_BASE + 0x514) // 1514
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_ADDR               (CONN_CFG_BASE + 0x520) // 1520
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_STATUS_ADDR             (CONN_CFG_BASE + 0x524) // 1524
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_ADDR              (CONN_CFG_BASE + 0x530) // 1530
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_STATUS_ADDR            (CONN_CFG_BASE + 0x534) // 1534
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_ADDR                   (CONN_CFG_BASE + 0x540) // 1540
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR                 (CONN_CFG_BASE + 0x544) // 1544
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR              (CONN_CFG_BASE + 0x550) // 1550
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR                  (CONN_CFG_BASE + 0x554) // 1554
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR              (CONN_CFG_BASE + 0x560) // 1560
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR                  (CONN_CFG_BASE + 0x564) // 1564
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR             (CONN_CFG_BASE + 0x570) // 1570
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR                 (CONN_CFG_BASE + 0x574) // 1574
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR             (CONN_CFG_BASE + 0x580) // 1580
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR                 (CONN_CFG_BASE + 0x584) // 1584
#define CONN_CFG_HOST_CSR_IRQ_EN_ADDR                          (CONN_CFG_BASE + 0x600) // 1600
#define CONN_CFG_CSR_BGF_ON_FW_OWN_IRQ_ADDR                    (CONN_CFG_BASE + 0x604) // 1604
#define CONN_CFG_CSR_MD_ON_IRQ_STATUS_ADDR                     (CONN_CFG_BASE + 0x610) // 1610
#define CONN_CFG_CSR_MD_ON_HOST_CSR_MISC_ADDR                  (CONN_CFG_BASE + 0x614) // 1614
#define CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_ADDR                  (CONN_CFG_BASE + 0x620) // 1620
#define CONN_CFG_CSR_WF_B0_ON_HOST_CSR_MISC_ADDR               (CONN_CFG_BASE + 0x624) // 1624
#define CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_ADDR                  (CONN_CFG_BASE + 0x630) // 1630
#define CONN_CFG_CSR_WF_B1_ON_HOST_CSR_MISC_ADDR               (CONN_CFG_BASE + 0x634) // 1634
#define CONN_CFG_CSR_BGF_ON_IRQ_STATUS_ADDR                    (CONN_CFG_BASE + 0x640) // 1640
#define CONN_CFG_CSR_BGF_ON_HOST_CSR_MISC_ADDR                 (CONN_CFG_BASE + 0x644) // 1644
#define CONN_CFG_CSR_GPS_ON_IRQ_STATUS_ADDR                    (CONN_CFG_BASE + 0x650) // 1650
#define CONN_CFG_CSR_GPS_ON_HOST_CSR_MISC_ADDR                 (CONN_CFG_BASE + 0x654) // 1654




/* =====================================================================================

  ---IP_VERSION (0x18001000 + 0x000)---

    IP_VERSION[31..0]            - (RO) IP_VERSION

 =====================================================================================*/
#define CONN_CFG_IP_VERSION_IP_VERSION_ADDR                    CONN_CFG_IP_VERSION_ADDR
#define CONN_CFG_IP_VERSION_IP_VERSION_MASK                    0xFFFFFFFF                // IP_VERSION[31..0]
#define CONN_CFG_IP_VERSION_IP_VERSION_SHFT                    0

/* =====================================================================================

  ---CFG_VERSION (0x18001000 + 0x004)---

    CFG_VERSION[31..0]           - (RO) CFG_VERSION

 =====================================================================================*/
#define CONN_CFG_CFG_VERSION_CFG_VERSION_ADDR                  CONN_CFG_CFG_VERSION_ADDR
#define CONN_CFG_CFG_VERSION_CFG_VERSION_MASK                  0xFFFFFFFF                // CFG_VERSION[31..0]
#define CONN_CFG_CFG_VERSION_CFG_VERSION_SHFT                  0

/* =====================================================================================

  ---STRAP_STATUS (0x18001000 + 0x010)---

    OSC_IS_20M[0]                - (RO) OSC is 20MHz strap status (active-high)
    OSC_IS_24M[1]                - (RO) OSC is 24MHz strap status (active-high)
    OSC_IS_25M[2]                - (RO) OSC is 25MHz strap status (active-high)
    OSC_IS_26M[3]                - (RO) OSC is 26MHz strap status (active-high)
    OSC_IS_40M[4]                - (RO) OSC is 40MHz strap status (active-high)
    OSC_IS_52M[5]                - (RO) OSC is 52MHz strap status (active-high)
    RESERVED6[7..6]              - (RO) Reserved bits
    OLT_BLT_MODE[8]              - (RO) OLT BLT mode strap status (active-high)
    SYSSTRAP_MODE[9]             - (RO) conn_infra system debug mode strap status (active-high)
    WFSYSSTRAP_MODE[10]          - (RO) wfsys system debug mode strap status (active-high)
    BGFSYSSTRAP_MODE[11]         - (RO) bgfsys system debug mode strap status (active-high)
    RBIST_MODE[12]               - (RO) connsys RBIST mode strap status (active-high)
    CONN_SPI2AHB_MODE[13]        - (RO) connsys SPI to AHB mode strap status (active-high)
    CONN_TEST_MODE[14]           - (RO) connsys test mode strap status, which indicates SPI2AHB, RBIST, ATPG mode (active-high)
    CONN_FORCE_PWR_ON_MODE[15]   - (RO) force connsys MTCMOS and memory all on mode strap status (active-high)
    CONN_EXTCK_MODE[16]          - (RO) connsys external clock mode strap status (active-high)
    CONN_BYPASS_ROM_MODE[17]     - (RO) connsys bypass rom code mode strap status (active-high)
    CONN_SPEEDUP_OSC_STABLE_MODE[18] - (RO) connsys speedup OSC stable mode strap status (active-high)
    RESERVED19[31..19]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_STRAP_STATUS_CONN_SPEEDUP_OSC_STABLE_MODE_ADDR CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_CONN_SPEEDUP_OSC_STABLE_MODE_MASK 0x00040000                // CONN_SPEEDUP_OSC_STABLE_MODE[18]
#define CONN_CFG_STRAP_STATUS_CONN_SPEEDUP_OSC_STABLE_MODE_SHFT 18
#define CONN_CFG_STRAP_STATUS_CONN_BYPASS_ROM_MODE_ADDR        CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_CONN_BYPASS_ROM_MODE_MASK        0x00020000                // CONN_BYPASS_ROM_MODE[17]
#define CONN_CFG_STRAP_STATUS_CONN_BYPASS_ROM_MODE_SHFT        17
#define CONN_CFG_STRAP_STATUS_CONN_EXTCK_MODE_ADDR             CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_CONN_EXTCK_MODE_MASK             0x00010000                // CONN_EXTCK_MODE[16]
#define CONN_CFG_STRAP_STATUS_CONN_EXTCK_MODE_SHFT             16
#define CONN_CFG_STRAP_STATUS_CONN_FORCE_PWR_ON_MODE_ADDR      CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_CONN_FORCE_PWR_ON_MODE_MASK      0x00008000                // CONN_FORCE_PWR_ON_MODE[15]
#define CONN_CFG_STRAP_STATUS_CONN_FORCE_PWR_ON_MODE_SHFT      15
#define CONN_CFG_STRAP_STATUS_CONN_TEST_MODE_ADDR              CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_CONN_TEST_MODE_MASK              0x00004000                // CONN_TEST_MODE[14]
#define CONN_CFG_STRAP_STATUS_CONN_TEST_MODE_SHFT              14
#define CONN_CFG_STRAP_STATUS_CONN_SPI2AHB_MODE_ADDR           CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_CONN_SPI2AHB_MODE_MASK           0x00002000                // CONN_SPI2AHB_MODE[13]
#define CONN_CFG_STRAP_STATUS_CONN_SPI2AHB_MODE_SHFT           13
#define CONN_CFG_STRAP_STATUS_RBIST_MODE_ADDR                  CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_RBIST_MODE_MASK                  0x00001000                // RBIST_MODE[12]
#define CONN_CFG_STRAP_STATUS_RBIST_MODE_SHFT                  12
#define CONN_CFG_STRAP_STATUS_BGFSYSSTRAP_MODE_ADDR            CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_BGFSYSSTRAP_MODE_MASK            0x00000800                // BGFSYSSTRAP_MODE[11]
#define CONN_CFG_STRAP_STATUS_BGFSYSSTRAP_MODE_SHFT            11
#define CONN_CFG_STRAP_STATUS_WFSYSSTRAP_MODE_ADDR             CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_WFSYSSTRAP_MODE_MASK             0x00000400                // WFSYSSTRAP_MODE[10]
#define CONN_CFG_STRAP_STATUS_WFSYSSTRAP_MODE_SHFT             10
#define CONN_CFG_STRAP_STATUS_SYSSTRAP_MODE_ADDR               CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_SYSSTRAP_MODE_MASK               0x00000200                // SYSSTRAP_MODE[9]
#define CONN_CFG_STRAP_STATUS_SYSSTRAP_MODE_SHFT               9
#define CONN_CFG_STRAP_STATUS_OLT_BLT_MODE_ADDR                CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_OLT_BLT_MODE_MASK                0x00000100                // OLT_BLT_MODE[8]
#define CONN_CFG_STRAP_STATUS_OLT_BLT_MODE_SHFT                8
#define CONN_CFG_STRAP_STATUS_OSC_IS_52M_ADDR                  CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_OSC_IS_52M_MASK                  0x00000020                // OSC_IS_52M[5]
#define CONN_CFG_STRAP_STATUS_OSC_IS_52M_SHFT                  5
#define CONN_CFG_STRAP_STATUS_OSC_IS_40M_ADDR                  CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_OSC_IS_40M_MASK                  0x00000010                // OSC_IS_40M[4]
#define CONN_CFG_STRAP_STATUS_OSC_IS_40M_SHFT                  4
#define CONN_CFG_STRAP_STATUS_OSC_IS_26M_ADDR                  CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_OSC_IS_26M_MASK                  0x00000008                // OSC_IS_26M[3]
#define CONN_CFG_STRAP_STATUS_OSC_IS_26M_SHFT                  3
#define CONN_CFG_STRAP_STATUS_OSC_IS_25M_ADDR                  CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_OSC_IS_25M_MASK                  0x00000004                // OSC_IS_25M[2]
#define CONN_CFG_STRAP_STATUS_OSC_IS_25M_SHFT                  2
#define CONN_CFG_STRAP_STATUS_OSC_IS_24M_ADDR                  CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_OSC_IS_24M_MASK                  0x00000002                // OSC_IS_24M[1]
#define CONN_CFG_STRAP_STATUS_OSC_IS_24M_SHFT                  1
#define CONN_CFG_STRAP_STATUS_OSC_IS_20M_ADDR                  CONN_CFG_STRAP_STATUS_ADDR
#define CONN_CFG_STRAP_STATUS_OSC_IS_20M_MASK                  0x00000001                // OSC_IS_20M[0]
#define CONN_CFG_STRAP_STATUS_OSC_IS_20M_SHFT                  0

/* =====================================================================================

  ---BOOT (0x18001000 + 0x014)---

    AP2CONN_BOOT_CPU_SEL[0]      - (RO) connsys boot by wfsys or bgfsys cpu selection
                                     1'h0: connsys is booted by wfsys cpu
                                     1'h1: connsys is booted by bgfsys cpu
    RESERVED1[29..1]             - (RO) Reserved bits
    BGF_CPU_BOOT_DONE[30]        - (RW) bgfsys cpu boot done, this bit should be set to 1 by bgfsys cpu when connsys boot is completed by bgfsys cpu
                                     1'h0: not done
                                     1'h1: done
    WF_CPU_BOOT_DONE[31]         - (RW) wfsys cpu boot done, this bit should be set to 1 by wfsys cpu when connsys boot is completed by wfsys cpu
                                     1'h0: not done
                                     1'h1: done

 =====================================================================================*/
#define CONN_CFG_BOOT_WF_CPU_BOOT_DONE_ADDR                    CONN_CFG_BOOT_ADDR
#define CONN_CFG_BOOT_WF_CPU_BOOT_DONE_MASK                    0x80000000                // WF_CPU_BOOT_DONE[31]
#define CONN_CFG_BOOT_WF_CPU_BOOT_DONE_SHFT                    31
#define CONN_CFG_BOOT_BGF_CPU_BOOT_DONE_ADDR                   CONN_CFG_BOOT_ADDR
#define CONN_CFG_BOOT_BGF_CPU_BOOT_DONE_MASK                   0x40000000                // BGF_CPU_BOOT_DONE[30]
#define CONN_CFG_BOOT_BGF_CPU_BOOT_DONE_SHFT                   30
#define CONN_CFG_BOOT_AP2CONN_BOOT_CPU_SEL_ADDR                CONN_CFG_BOOT_ADDR
#define CONN_CFG_BOOT_AP2CONN_BOOT_CPU_SEL_MASK                0x00000001                // AP2CONN_BOOT_CPU_SEL[0]
#define CONN_CFG_BOOT_AP2CONN_BOOT_CPU_SEL_SHFT                0

/* =====================================================================================

  ---EFUSE (0x18001000 + 0x020)---

    AP2CONN_EFUSE_DATA[15..0]    - (RO) efuse data
    AP2CONN_EFUSE_DATA_SECURITY[25..16] - (RO) efuse data
    RESERVED26[31..26]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_EFUSE_AP2CONN_EFUSE_DATA_SECURITY_ADDR        CONN_CFG_EFUSE_ADDR
#define CONN_CFG_EFUSE_AP2CONN_EFUSE_DATA_SECURITY_MASK        0x03FF0000                // AP2CONN_EFUSE_DATA_SECURITY[25..16]
#define CONN_CFG_EFUSE_AP2CONN_EFUSE_DATA_SECURITY_SHFT        16
#define CONN_CFG_EFUSE_AP2CONN_EFUSE_DATA_ADDR                 CONN_CFG_EFUSE_ADDR
#define CONN_CFG_EFUSE_AP2CONN_EFUSE_DATA_MASK                 0x0000FFFF                // AP2CONN_EFUSE_DATA[15..0]
#define CONN_CFG_EFUSE_AP2CONN_EFUSE_DATA_SHFT                 0

/* =====================================================================================

  ---ADIE_CTL (0x18001000 + 0x030)---

    ADIE_RSTB[0]                 - (RW) a-die reset (active-low)
                                     1'h0: reset
                                     1'h1: not reset
    ADIE_TOP_CKEN[1]             - (RW) a-die top clock enable
                                     1'h0: disable
                                     1'h1: enable
    INST2_ADIE_RSTB[2]           - (RW) a-die reset (active-low)
                                     1'h0: reset
                                     1'h1: not reset
    INST2_ADIE_TOP_CKEN[3]       - (RW) a-die top clock enable
                                     1'h0: disable
                                     1'h1: enable
    INST2_ADIE_BN_SEL[4]         - (RW)  xxx 
    RESERVED5[31..5]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_ADIE_CTL_INST2_ADIE_BN_SEL_ADDR               CONN_CFG_ADIE_CTL_ADDR
#define CONN_CFG_ADIE_CTL_INST2_ADIE_BN_SEL_MASK               0x00000010                // INST2_ADIE_BN_SEL[4]
#define CONN_CFG_ADIE_CTL_INST2_ADIE_BN_SEL_SHFT               4
#define CONN_CFG_ADIE_CTL_INST2_ADIE_TOP_CKEN_ADDR             CONN_CFG_ADIE_CTL_ADDR
#define CONN_CFG_ADIE_CTL_INST2_ADIE_TOP_CKEN_MASK             0x00000008                // INST2_ADIE_TOP_CKEN[3]
#define CONN_CFG_ADIE_CTL_INST2_ADIE_TOP_CKEN_SHFT             3
#define CONN_CFG_ADIE_CTL_INST2_ADIE_RSTB_ADDR                 CONN_CFG_ADIE_CTL_ADDR
#define CONN_CFG_ADIE_CTL_INST2_ADIE_RSTB_MASK                 0x00000004                // INST2_ADIE_RSTB[2]
#define CONN_CFG_ADIE_CTL_INST2_ADIE_RSTB_SHFT                 2
#define CONN_CFG_ADIE_CTL_ADIE_TOP_CKEN_ADDR                   CONN_CFG_ADIE_CTL_ADDR
#define CONN_CFG_ADIE_CTL_ADIE_TOP_CKEN_MASK                   0x00000002                // ADIE_TOP_CKEN[1]
#define CONN_CFG_ADIE_CTL_ADIE_TOP_CKEN_SHFT                   1
#define CONN_CFG_ADIE_CTL_ADIE_RSTB_ADDR                       CONN_CFG_ADIE_CTL_ADDR
#define CONN_CFG_ADIE_CTL_ADIE_RSTB_MASK                       0x00000001                // ADIE_RSTB[0]
#define CONN_CFG_ADIE_CTL_ADIE_RSTB_SHFT                       0

/* =====================================================================================

  ---CONN_INFRA_SLP_CNT_CTL (0x18001000 + 0x0A0)---

    SLP_COUNTER_EN[0]            - (RW) Sleep counter enable:
                                     1'h0: Disable
                                     1'h1: Enable
    SLP_COUNTER_SEL[3..1]        - (RW) Select sleep counter type:
                                     3'h0: conn_infra sleep counter
                                     3'h1: wfsys sleep counter
                                     3'h2: bgfsys sleep counter
                                     3'h3: gpssys sleep counter
    SLP_COUNTER_RD_TRIGGER[4]    - (RW) Trigger sleep counter update to CONN_INFRA_SLP_COUNTER/CONN_INFRA_SLP_TIMER(positive edge):
                                     First: Write 1'h0
                                     Then: Write 1'h1
    RESERVED5[31..5]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_RD_TRIGGER_ADDR CONN_CFG_CONN_INFRA_SLP_CNT_CTL_ADDR
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_RD_TRIGGER_MASK 0x00000010                // SLP_COUNTER_RD_TRIGGER[4]
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_RD_TRIGGER_SHFT 4
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_SEL_ADDR   CONN_CFG_CONN_INFRA_SLP_CNT_CTL_ADDR
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_SEL_MASK   0x0000000E                // SLP_COUNTER_SEL[3..1]
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_SEL_SHFT   1
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_EN_ADDR    CONN_CFG_CONN_INFRA_SLP_CNT_CTL_ADDR
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_EN_MASK    0x00000001                // SLP_COUNTER_EN[0]
#define CONN_CFG_CONN_INFRA_SLP_CNT_CTL_SLP_COUNTER_EN_SHFT    0

/* =====================================================================================

  ---CONN_INFRA_CONN_INFRA_SLP_CNT (0x18001000 + 0x0B0)---

    CONN_INFRA_SLP_COUNTER_STOP[0] - (RW) Sleep counter stop:
                                     1'h1: Stop
                                     1'h0: Keep going
    CONN_INFRA_SLP_COUNTER_CLR[1] - (RW) Sleep counter clear:
                                     1'h1: Clean to 0
                                     1'h0: Keep going
    CONN_INFRA_IN_SLEEP[2]       - (RO) CONN_INFRA is in sleeping
    RESERVED3[31..3]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_IN_SLEEP_ADDR CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_IN_SLEEP_MASK 0x00000004                // CONN_INFRA_IN_SLEEP[2]
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_IN_SLEEP_SHFT 2
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_SLP_COUNTER_CLR_ADDR CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_SLP_COUNTER_CLR_MASK 0x00000002                // CONN_INFRA_SLP_COUNTER_CLR[1]
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_SLP_COUNTER_CLR_SHFT 1
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_SLP_COUNTER_STOP_ADDR CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_SLP_COUNTER_STOP_MASK 0x00000001                // CONN_INFRA_SLP_COUNTER_STOP[0]
#define CONN_CFG_CONN_INFRA_CONN_INFRA_SLP_CNT_CONN_INFRA_SLP_COUNTER_STOP_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_WFSYS_SLP_CNT (0x18001000 + 0x0C8)---

    WFSYS_SLP_COUNTER_STOP[0]    - (RW) Sleep counter stop:
                                     1'h1: Stop
                                     1'h0: Keep going
    WFSYS_SLP_COUNTER_CLR[1]     - (RW) Sleep counter clear:
                                     1'h1: Clean to 0
                                     1'h0: Keep going
    WFSYS_IN_SLEEP[2]            - (RO) WFSYS is in sleeping
    RESERVED3[31..3]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_IN_SLEEP_ADDR  CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_IN_SLEEP_MASK  0x00000004                // WFSYS_IN_SLEEP[2]
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_IN_SLEEP_SHFT  2
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_SLP_COUNTER_CLR_ADDR CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_SLP_COUNTER_CLR_MASK 0x00000002                // WFSYS_SLP_COUNTER_CLR[1]
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_SLP_COUNTER_CLR_SHFT 1
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_SLP_COUNTER_STOP_ADDR CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_SLP_COUNTER_STOP_MASK 0x00000001                // WFSYS_SLP_COUNTER_STOP[0]
#define CONN_CFG_CONN_INFRA_WFSYS_SLP_CNT_WFSYS_SLP_COUNTER_STOP_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_BGFSYS_SLP_CNT (0x18001000 + 0x0D8)---

    BGFSYS_SLP_COUNTER_STOP[0]   - (RW) Sleep counter stop:
                                     1'h1: Stop
                                     1'h0: Keep going
    BGFSYS_SLP_COUNTER_CLR[1]    - (RW) Sleep counter clear:
                                     1'h1: Clean to 0
                                     1'h0: Keep going
    BGFSYS_IN_SLEEP[2]           - (RO) BGFSYS is in sleeping
    RESERVED3[31..3]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_IN_SLEEP_ADDR CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_IN_SLEEP_MASK 0x00000004                // BGFSYS_IN_SLEEP[2]
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_IN_SLEEP_SHFT 2
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_SLP_COUNTER_CLR_ADDR CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_SLP_COUNTER_CLR_MASK 0x00000002                // BGFSYS_SLP_COUNTER_CLR[1]
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_SLP_COUNTER_CLR_SHFT 1
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_SLP_COUNTER_STOP_ADDR CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_SLP_COUNTER_STOP_MASK 0x00000001                // BGFSYS_SLP_COUNTER_STOP[0]
#define CONN_CFG_CONN_INFRA_BGFSYS_SLP_CNT_BGFSYS_SLP_COUNTER_STOP_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_GPSSYS_SLP_CNT (0x18001000 + 0x0DC)---

    GPSSYS_SLP_COUNTER_STOP[0]   - (RW) Sleep counter stop:
                                     1'h1: Stop
                                     1'h0: Keep going
    GPSSYS_SLP_COUNTER_CLR[1]    - (RW) Sleep counter clear:
                                     1'h1: Clean to 0
                                     1'h0: Keep going
    GPSSYS_IN_SLEEP[2]           - (RO) GPSSYS is in sleeping
    RESERVED3[31..3]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_IN_SLEEP_ADDR CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_IN_SLEEP_MASK 0x00000004                // GPSSYS_IN_SLEEP[2]
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_IN_SLEEP_SHFT 2
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_SLP_COUNTER_CLR_ADDR CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_SLP_COUNTER_CLR_MASK 0x00000002                // GPSSYS_SLP_COUNTER_CLR[1]
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_SLP_COUNTER_CLR_SHFT 1
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_SLP_COUNTER_STOP_ADDR CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_ADDR
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_SLP_COUNTER_STOP_MASK 0x00000001                // GPSSYS_SLP_COUNTER_STOP[0]
#define CONN_CFG_CONN_INFRA_GPSSYS_SLP_CNT_GPSSYS_SLP_COUNTER_STOP_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SLP_TIMER (0x18001000 + 0x0E0)---

    SLP_TIMER[31..0]             - (RO) Setected sleep timer result

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_SLP_TIMER_SLP_TIMER_ADDR           CONN_CFG_CONN_INFRA_SLP_TIMER_ADDR
#define CONN_CFG_CONN_INFRA_SLP_TIMER_SLP_TIMER_MASK           0xFFFFFFFF                // SLP_TIMER[31..0]
#define CONN_CFG_CONN_INFRA_SLP_TIMER_SLP_TIMER_SHFT           0

/* =====================================================================================

  ---CONN_INFRA_SLP_COUNTER (0x18001000 + 0x0E4)---

    SLP_COUNTER[31..0]           - (RO) Setected sleep counter result

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_SLP_COUNTER_SLP_COUNTER_ADDR       CONN_CFG_CONN_INFRA_SLP_COUNTER_ADDR
#define CONN_CFG_CONN_INFRA_SLP_COUNTER_SLP_COUNTER_MASK       0xFFFFFFFF                // SLP_COUNTER[31..0]
#define CONN_CFG_CONN_INFRA_SLP_COUNTER_SLP_COUNTER_SHFT       0

/* =====================================================================================

  ---CONN_INFRA_CFG_CONN2AP_MAILBOX (0x18001000 + 0x100)---

    CONN2AP_MAILBOX[31..0]       - (RW) conn2ap mailbox

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_CONN2AP_MAILBOX_CONN2AP_MAILBOX_ADDR CONN_CFG_CONN_INFRA_CFG_CONN2AP_MAILBOX_ADDR
#define CONN_CFG_CONN_INFRA_CFG_CONN2AP_MAILBOX_CONN2AP_MAILBOX_MASK 0xFFFFFFFF                // CONN2AP_MAILBOX[31..0]
#define CONN_CFG_CONN_INFRA_CFG_CONN2AP_MAILBOX_CONN2AP_MAILBOX_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_AP2CONN_MAILBOX (0x18001000 + 0x104)---

    AP2CONN_MAILBOX[31..0]       - (RO) ap2conn mailbox

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_AP2CONN_MAILBOX_AP2CONN_MAILBOX_ADDR CONN_CFG_CONN_INFRA_CFG_AP2CONN_MAILBOX_ADDR
#define CONN_CFG_CONN_INFRA_CFG_AP2CONN_MAILBOX_AP2CONN_MAILBOX_MASK 0xFFFFFFFF                // AP2CONN_MAILBOX[31..0]
#define CONN_CFG_CONN_INFRA_CFG_AP2CONN_MAILBOX_AP2CONN_MAILBOX_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_BT_MANUAL_CTRL (0x18001000 + 0x108)---

    BT_MANUAL_CTRL_RESERVED[25..0] - (RW) btsys manual control cr(reserved)
    SW_BT_OSC2X_RDY[26]          - (RW) 1'b1:force bt_osc2x_rdy = 1
    SW_CINF_BT_MTCMOS_PWR_ACK_MASK[27] - (RW)  xxx 
    SW_BT_OSC_ON[28]             - (RW) 1'b1:force bt_osc_on = 1, require osc clock
    HOST2BT_SEL_TOP_MANUAL_CTRL[29] - (RW)  xxx 
    HOST2BT_SEL_MONFLG_ON_CTRL[30] - (RW)  xxx 
    SW_BT_OSC_RDY[31]            - (RW) 1'b1:force bt_osc_rdy = 1

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC_RDY_ADDR CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC_RDY_MASK 0x80000000                // SW_BT_OSC_RDY[31]
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC_RDY_SHFT 31
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_HOST2BT_SEL_MONFLG_ON_CTRL_ADDR CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_HOST2BT_SEL_MONFLG_ON_CTRL_MASK 0x40000000                // HOST2BT_SEL_MONFLG_ON_CTRL[30]
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_HOST2BT_SEL_MONFLG_ON_CTRL_SHFT 30
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_HOST2BT_SEL_TOP_MANUAL_CTRL_ADDR CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_HOST2BT_SEL_TOP_MANUAL_CTRL_MASK 0x20000000                // HOST2BT_SEL_TOP_MANUAL_CTRL[29]
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_HOST2BT_SEL_TOP_MANUAL_CTRL_SHFT 29
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC_ON_ADDR CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC_ON_MASK 0x10000000                // SW_BT_OSC_ON[28]
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC_ON_SHFT 28
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_CINF_BT_MTCMOS_PWR_ACK_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_CINF_BT_MTCMOS_PWR_ACK_MASK_MASK 0x08000000                // SW_CINF_BT_MTCMOS_PWR_ACK_MASK[27]
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_CINF_BT_MTCMOS_PWR_ACK_MASK_SHFT 27
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC2X_RDY_ADDR CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC2X_RDY_MASK 0x04000000                // SW_BT_OSC2X_RDY[26]
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_SW_BT_OSC2X_RDY_SHFT 26
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_BT_MANUAL_CTRL_RESERVED_ADDR CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_BT_MANUAL_CTRL_RESERVED_MASK 0x03FFFFFF                // BT_MANUAL_CTRL_RESERVED[25..0]
#define CONN_CFG_CONN_INFRA_CFG_BT_MANUAL_CTRL_BT_MANUAL_CTRL_RESERVED_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_GPS_MANUAL_CTRL (0x18001000 + 0x10C)---

    GPS_MANUAL_CTRL[22..0]       - (RW) gpssys manual control cr(reserved)
    FORCE_GPS_BUS_CLK_EN[23]     - (RW) 1'b1: enable gps bus clk
    SW_GPS_HW_CONTROL_CLR[24]    - (RW) 1'b1: force clear gps_hw_control
    SW_GPS_OSC_EN_ALL[25]        - (RW) 1'b1: force keep gps_osc_en_all
    SW_GPS_TOP_OFF_PWR_CTL[26]   - (RW) 1'b1:force gps top off pwr ctl fsm jump from state SLEEP to state PWR3
    SW_GPS_OSC_STL[27]           - (RW) 1'b1:force gps osc ctl fsm jump from state ST3 to state ST4
    SW_GPS_L5_SLP_CTL[28]        - (RW) 1'b1:force gps l5 slp_ctl fsm jump from state SLEEP to state PON1
    SW_GPS_L1_SLP_CTL[29]        - (RW) 1'b1:force gps l1 slp_ctl fsm jump from state SLEEP to state PON1
    SW_GPS_OSC_ON[30]            - (RW) 1'b1:force gps_osc_on = 1, require osc clock
    SW_GPS_OSC_RDY[31]           - (RW) 1'b1:force gps_osc_rdy = 1

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_RDY_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_RDY_MASK 0x80000000                // SW_GPS_OSC_RDY[31]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_RDY_SHFT 31
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_ON_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_ON_MASK 0x40000000                // SW_GPS_OSC_ON[30]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_ON_SHFT 30
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_L1_SLP_CTL_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_L1_SLP_CTL_MASK 0x20000000                // SW_GPS_L1_SLP_CTL[29]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_L1_SLP_CTL_SHFT 29
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_L5_SLP_CTL_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_L5_SLP_CTL_MASK 0x10000000                // SW_GPS_L5_SLP_CTL[28]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_L5_SLP_CTL_SHFT 28
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_STL_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_STL_MASK 0x08000000                // SW_GPS_OSC_STL[27]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_STL_SHFT 27
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_TOP_OFF_PWR_CTL_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_TOP_OFF_PWR_CTL_MASK 0x04000000                // SW_GPS_TOP_OFF_PWR_CTL[26]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_TOP_OFF_PWR_CTL_SHFT 26
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_EN_ALL_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_EN_ALL_MASK 0x02000000                // SW_GPS_OSC_EN_ALL[25]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_OSC_EN_ALL_SHFT 25
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_HW_CONTROL_CLR_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_HW_CONTROL_CLR_MASK 0x01000000                // SW_GPS_HW_CONTROL_CLR[24]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_SW_GPS_HW_CONTROL_CLR_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_FORCE_GPS_BUS_CLK_EN_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_FORCE_GPS_BUS_CLK_EN_MASK 0x00800000                // FORCE_GPS_BUS_CLK_EN[23]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_FORCE_GPS_BUS_CLK_EN_SHFT 23
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_GPS_MANUAL_CTRL_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_GPS_MANUAL_CTRL_MASK 0x007FFFFF                // GPS_MANUAL_CTRL[22..0]
#define CONN_CFG_CONN_INFRA_CFG_GPS_MANUAL_CTRL_GPS_MANUAL_CTRL_SHFT 0

/* =====================================================================================

  ---BGF_DUMMY_CR_0 (0x18001000 + 0x140)---

    BGF_DUMMY_0[31..0]           - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_BGF_DUMMY_CR_0_BGF_DUMMY_0_ADDR               CONN_CFG_BGF_DUMMY_CR_0_ADDR
#define CONN_CFG_BGF_DUMMY_CR_0_BGF_DUMMY_0_MASK               0xFFFFFFFF                // BGF_DUMMY_0[31..0]
#define CONN_CFG_BGF_DUMMY_CR_0_BGF_DUMMY_0_SHFT               0

/* =====================================================================================

  ---BGF_DUMMY_CR_1 (0x18001000 + 0x144)---

    BGF_DUMMY_1[31..0]           - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_BGF_DUMMY_CR_1_BGF_DUMMY_1_ADDR               CONN_CFG_BGF_DUMMY_CR_1_ADDR
#define CONN_CFG_BGF_DUMMY_CR_1_BGF_DUMMY_1_MASK               0xFFFFFFFF                // BGF_DUMMY_1[31..0]
#define CONN_CFG_BGF_DUMMY_CR_1_BGF_DUMMY_1_SHFT               0

/* =====================================================================================

  ---BGF_DUMMY_CR_2 (0x18001000 + 0x148)---

    BGF_DUMMY_2[31..0]           - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_BGF_DUMMY_CR_2_BGF_DUMMY_2_ADDR               CONN_CFG_BGF_DUMMY_CR_2_ADDR
#define CONN_CFG_BGF_DUMMY_CR_2_BGF_DUMMY_2_MASK               0xFFFFFFFF                // BGF_DUMMY_2[31..0]
#define CONN_CFG_BGF_DUMMY_CR_2_BGF_DUMMY_2_SHFT               0

/* =====================================================================================

  ---BGF_DUMMY_CR_3 (0x18001000 + 0x14C)---

    BGF_DUMMY_3[31..0]           - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_BGF_DUMMY_CR_3_BGF_DUMMY_3_ADDR               CONN_CFG_BGF_DUMMY_CR_3_ADDR
#define CONN_CFG_BGF_DUMMY_CR_3_BGF_DUMMY_3_MASK               0xFFFFFFFF                // BGF_DUMMY_3[31..0]
#define CONN_CFG_BGF_DUMMY_CR_3_BGF_DUMMY_3_SHFT               0

/* =====================================================================================

  ---WF_DUMMY_CR_0 (0x18001000 + 0x160)---

    WF_DUMMY_0[31..0]            - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_WF_DUMMY_CR_0_WF_DUMMY_0_ADDR                 CONN_CFG_WF_DUMMY_CR_0_ADDR
#define CONN_CFG_WF_DUMMY_CR_0_WF_DUMMY_0_MASK                 0xFFFFFFFF                // WF_DUMMY_0[31..0]
#define CONN_CFG_WF_DUMMY_CR_0_WF_DUMMY_0_SHFT                 0

/* =====================================================================================

  ---WF_DUMMY_CR_1 (0x18001000 + 0x164)---

    WF_DUMMY_1[31..0]            - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_WF_DUMMY_CR_1_WF_DUMMY_1_ADDR                 CONN_CFG_WF_DUMMY_CR_1_ADDR
#define CONN_CFG_WF_DUMMY_CR_1_WF_DUMMY_1_MASK                 0xFFFFFFFF                // WF_DUMMY_1[31..0]
#define CONN_CFG_WF_DUMMY_CR_1_WF_DUMMY_1_SHFT                 0

/* =====================================================================================

  ---WF_DUMMY_CR_2 (0x18001000 + 0x168)---

    WF_DUMMY_2[31..0]            - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_WF_DUMMY_CR_2_WF_DUMMY_2_ADDR                 CONN_CFG_WF_DUMMY_CR_2_ADDR
#define CONN_CFG_WF_DUMMY_CR_2_WF_DUMMY_2_MASK                 0xFFFFFFFF                // WF_DUMMY_2[31..0]
#define CONN_CFG_WF_DUMMY_CR_2_WF_DUMMY_2_SHFT                 0

/* =====================================================================================

  ---WF_DUMMY_CR_3 (0x18001000 + 0x16C)---

    WF_DUMMY_3[31..0]            - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_WF_DUMMY_CR_3_WF_DUMMY_3_ADDR                 CONN_CFG_WF_DUMMY_CR_3_ADDR
#define CONN_CFG_WF_DUMMY_CR_3_WF_DUMMY_3_MASK                 0xFFFFFFFF                // WF_DUMMY_3[31..0]
#define CONN_CFG_WF_DUMMY_CR_3_WF_DUMMY_3_SHFT                 0

/* =====================================================================================

  ---CONN_FPGA_DUMMY0 (0x18001000 + 0x1C0)---

    R_CONN_FPGA_DUMMY0[31..0]    - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_FPGA_DUMMY0_R_CONN_FPGA_DUMMY0_ADDR      CONN_CFG_CONN_FPGA_DUMMY0_ADDR
#define CONN_CFG_CONN_FPGA_DUMMY0_R_CONN_FPGA_DUMMY0_MASK      0xFFFFFFFF                // R_CONN_FPGA_DUMMY0[31..0]
#define CONN_CFG_CONN_FPGA_DUMMY0_R_CONN_FPGA_DUMMY0_SHFT      0

/* =====================================================================================

  ---CONN_FPGA_DUMMY1 (0x18001000 + 0x1C4)---

    R_CONN_FPGA_DUMMY1[31..0]    - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_FPGA_DUMMY1_R_CONN_FPGA_DUMMY1_ADDR      CONN_CFG_CONN_FPGA_DUMMY1_ADDR
#define CONN_CFG_CONN_FPGA_DUMMY1_R_CONN_FPGA_DUMMY1_MASK      0xFFFFFFFF                // R_CONN_FPGA_DUMMY1[31..0]
#define CONN_CFG_CONN_FPGA_DUMMY1_R_CONN_FPGA_DUMMY1_SHFT      0

/* =====================================================================================

  ---CONN_INFRA_CFG_PWRCTRL0 (0x18001000 + 0x200)---

    HW_CONTROL[0]                - (RW) conn_infra_off power control by hw
    RESERVED1[3..1]              - (RO) Reserved bits
    CONN_INFRA_PWR_STAT[8..4]    - (RO) conn_infra_off power state indicator
    HWCTL_OSC_ON_CHECK_TOP_PWR_EN[9] - (RW) hwctl_osc_on control check with top_pwr_enable_d1 from conn_infra_rgu
                                     1'b0: diable
                                     1'b1:enable
    CONN_INFRA_CFG_PWRCTRL0_RSV_0[11..10] - (RW) reserved CR
    CONN_INFRA_CFG_SLP_RDY_MASK[15..12] - (RW) conn_infra_bus_slp_rdy(low -> high) mask for conn_infra_cfg_slp_ctl
                                     1'b0: no mask
                                     1'b1: mask
    CONN_INFRA_CFG_SLP_RDY_DIS_MASK[19..16] - (RW) conn_infra_bus_slp_rdy(high -> low) mask for conn_infra_cfg_slp_ctl
                                     1'b0: no mask
                                     1'b1: mask
    CONN_INFRA_CFG_SLP_RDY_CONN2AP_DIS_MASK[23..20] - (RW) conn2ap slp protect rdy tx and rx (high -> low) mask for conn_infra_cfg_slp_ctl
                                     bit-20: if 1'b1, on2off disable rdy  mask
                                     bit-21: if 1'b1, off2on disable rdy  mask
                                     bit-22: if 1'b1, conn2ap tx disable rdy  mask
                                     bit-23: if 1'b1, conn2ap tx disable rdy  mask
    CONN_INFRA_CFG_SLP_AP2CONN_EN_MASK[26..24] - (RW) conn_infra sleep protect enable by ap2conn rx en mask
                                     bit-24: if 1'b1, conn2ap tx and rx control by ap2conn rx en mask
                                     bit-25:  if 1'b1, on2off control by ap2conn rx en mask
                                     bit-26:  if 1'b1,  off2on control by ap2conn rx en mask
    CONN_INFRA_CFG_PWRCTRL0_RSV_1[31..27] - (RW) reserved CR

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_PWRCTRL0_RSV_1_ADDR CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_PWRCTRL0_RSV_1_MASK 0xF8000000                // CONN_INFRA_CFG_PWRCTRL0_RSV_1[31..27]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_PWRCTRL0_RSV_1_SHFT 27
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_AP2CONN_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_AP2CONN_EN_MASK_MASK 0x07000000                // CONN_INFRA_CFG_SLP_AP2CONN_EN_MASK[26..24]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_AP2CONN_EN_MASK_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_CONN2AP_DIS_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_CONN2AP_DIS_MASK_MASK 0x00F00000                // CONN_INFRA_CFG_SLP_RDY_CONN2AP_DIS_MASK[23..20]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_CONN2AP_DIS_MASK_SHFT 20
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_DIS_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_DIS_MASK_MASK 0x000F0000                // CONN_INFRA_CFG_SLP_RDY_DIS_MASK[19..16]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_DIS_MASK_SHFT 16
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_MASK_MASK 0x0000F000                // CONN_INFRA_CFG_SLP_RDY_MASK[15..12]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_SLP_RDY_MASK_SHFT 12
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_PWRCTRL0_RSV_0_ADDR CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_PWRCTRL0_RSV_0_MASK 0x00000C00                // CONN_INFRA_CFG_PWRCTRL0_RSV_0[11..10]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_CFG_PWRCTRL0_RSV_0_SHFT 10
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_HWCTL_OSC_ON_CHECK_TOP_PWR_EN_ADDR CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_HWCTL_OSC_ON_CHECK_TOP_PWR_EN_MASK 0x00000200                // HWCTL_OSC_ON_CHECK_TOP_PWR_EN[9]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_HWCTL_OSC_ON_CHECK_TOP_PWR_EN_SHFT 9
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_PWR_STAT_ADDR CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_PWR_STAT_MASK 0x000001F0                // CONN_INFRA_PWR_STAT[8..4]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_CONN_INFRA_PWR_STAT_SHFT 4
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_HW_CONTROL_ADDR       CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_HW_CONTROL_MASK       0x00000001                // HW_CONTROL[0]
#define CONN_CFG_CONN_INFRA_CFG_PWRCTRL0_HW_CONTROL_SHFT       0

/* =====================================================================================

  ---CONN_INFRA_CFG_FM_PWRCTRL0 (0x18001000 + 0x204)---

    FMSYS_OSC_EN[0]              - (RW) fmsys osc enable
    RESERVED1[7..1]              - (RO) Reserved bits
    CONN_INFRA_CFG_FM_PWRCTRL0_RSV[31..8] - (RW) reserved CR

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_CONN_INFRA_CFG_FM_PWRCTRL0_RSV_ADDR CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_CONN_INFRA_CFG_FM_PWRCTRL0_RSV_MASK 0xFFFFFF00                // CONN_INFRA_CFG_FM_PWRCTRL0_RSV[31..8]
#define CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_CONN_INFRA_CFG_FM_PWRCTRL0_RSV_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_FMSYS_OSC_EN_ADDR  CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_FMSYS_OSC_EN_MASK  0x00000001                // FMSYS_OSC_EN[0]
#define CONN_CFG_CONN_INFRA_CFG_FM_PWRCTRL0_FMSYS_OSC_EN_SHFT  0

/* =====================================================================================

  ---CONN_INFRA_CFG_BT_PWRCTRL0 (0x18001000 + 0x208)---

    BT_FUNCTION_EN[0]            - (RW) btsys function enable -> release reset
    BT1_FUNCTION_EN[1]           - (RW) btsys1 function enable -> release reset
    RESERVED2[7..2]              - (RO) Reserved bits
    CONN_INFRA_CFG_BT_PWRCTRL0_RSV[31..8] - (RW) reserved CR

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_CONN_INFRA_CFG_BT_PWRCTRL0_RSV_ADDR CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_CONN_INFRA_CFG_BT_PWRCTRL0_RSV_MASK 0xFFFFFF00                // CONN_INFRA_CFG_BT_PWRCTRL0_RSV[31..8]
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_CONN_INFRA_CFG_BT_PWRCTRL0_RSV_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_BT1_FUNCTION_EN_ADDR CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_BT1_FUNCTION_EN_MASK 0x00000002                // BT1_FUNCTION_EN[1]
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_BT1_FUNCTION_EN_SHFT 1
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_BT_FUNCTION_EN_ADDR CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_BT_FUNCTION_EN_MASK 0x00000001                // BT_FUNCTION_EN[0]
#define CONN_CFG_CONN_INFRA_CFG_BT_PWRCTRL0_BT_FUNCTION_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_GPS_PWRCTRL0 (0x18001000 + 0x20C)---

    GPS_FUNCTION_EN[0]           - (RW) gpssys function enable -> release reset
    RESERVED1[7..1]              - (RO) Reserved bits
    CONN_INFRA_CFG_GPS_PWRCTRL0_RSV[31..8] - (RW) reserved CR

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_CONN_INFRA_CFG_GPS_PWRCTRL0_RSV_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_CONN_INFRA_CFG_GPS_PWRCTRL0_RSV_MASK 0xFFFFFF00                // CONN_INFRA_CFG_GPS_PWRCTRL0_RSV[31..8]
#define CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_CONN_INFRA_CFG_GPS_PWRCTRL0_RSV_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_GPS_FUNCTION_EN_ADDR CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_GPS_FUNCTION_EN_MASK 0x00000001                // GPS_FUNCTION_EN[0]
#define CONN_CFG_CONN_INFRA_CFG_GPS_PWRCTRL0_GPS_FUNCTION_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SYSRAM_CTRL_0 (0x18001000 + 0x240)---

    CONN_INFRA_SYSRAM_DELSEL_UMS[19..0] - (RW)  xxx 
    CONN_INFRA_SYSRAM_MBIST_USE_DEFAULT_DESEL[20] - (RW)  xxx 
    CONN_INFRA_SYSRAM_HDEN[21]   - (RW)  xxx 
    RESERVED22[31..22]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_HDEN_ADDR CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_ADDR
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_HDEN_MASK 0x00200000                // CONN_INFRA_SYSRAM_HDEN[21]
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_HDEN_SHFT 21
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_MBIST_USE_DEFAULT_DESEL_ADDR CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_ADDR
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_MBIST_USE_DEFAULT_DESEL_MASK 0x00100000                // CONN_INFRA_SYSRAM_MBIST_USE_DEFAULT_DESEL[20]
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_MBIST_USE_DEFAULT_DESEL_SHFT 20
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_DELSEL_UMS_ADDR CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_ADDR
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_DELSEL_UMS_MASK 0x000FFFFF                // CONN_INFRA_SYSRAM_DELSEL_UMS[19..0]
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_0_CONN_INFRA_SYSRAM_DELSEL_UMS_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SYSRAM_CTRL_1 (0x18001000 + 0x244)---

    CONN_INFRA_SYSRAM_PD_SEL_SCAN[3..0] - (RW)  xxx 
    CONN_INFRA_SYSRAM_AWT[4]     - (RW)  xxx 
    RESERVED5[7..5]              - (RO) Reserved bits
    CONN_INFRA_SYSRAM_ERR_CLR[8] - (RW)  xxx 
    CONN_INFRA_SYSRAM_ERR_ADR[24..9] - (RO)  xxx 
    RESERVED25[31..25]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_ERR_ADR_ADDR CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_ERR_ADR_MASK 0x01FFFE00                // CONN_INFRA_SYSRAM_ERR_ADR[24..9]
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_ERR_ADR_SHFT 9
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_ERR_CLR_ADDR CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_ERR_CLR_MASK 0x00000100                // CONN_INFRA_SYSRAM_ERR_CLR[8]
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_ERR_CLR_SHFT 8
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_AWT_ADDR CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_AWT_MASK 0x00000010                // CONN_INFRA_SYSRAM_AWT[4]
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_AWT_SHFT 4
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_PD_SEL_SCAN_ADDR CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_ADDR
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_PD_SEL_SCAN_MASK 0x0000000F                // CONN_INFRA_SYSRAM_PD_SEL_SCAN[3..0]
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_1_CONN_INFRA_SYSRAM_PD_SEL_SCAN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_SYSRAM_CTRL_2 (0x18001000 + 0x248)---

    CONN_INFRA_SYSRAM_ERROR_INFO[31..0] - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_2_CONN_INFRA_SYSRAM_ERROR_INFO_ADDR CONN_CFG_CONN_INFRA_SYSRAM_CTRL_2_ADDR
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_2_CONN_INFRA_SYSRAM_ERROR_INFO_MASK 0xFFFFFFFF                // CONN_INFRA_SYSRAM_ERROR_INFO[31..0]
#define CONN_CFG_CONN_INFRA_SYSRAM_CTRL_2_CONN_INFRA_SYSRAM_ERROR_INFO_SHFT 0

/* =====================================================================================

  ---OSC_CTL_0 (0x18001000 + 0x300)---

    XO_VCORE_RDY_STABLE_TIME[7..0] - (RW) vcore ready stable time counter (40 x 1/32kHz)
                                     this stable time is for fake "source clock enable acknowledgement" information masking
    XO_INI_STABLE_TIME[15..8]    - (RW) OSC clock source stable time counter (150 x 1/32KHz)
    XO_BG_STABLE_TIME[23..16]    - (RW) bandgap stable time counter (151 x 1/32KHz)
    RESERVED24[31..24]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_OSC_CTL_0_XO_BG_STABLE_TIME_ADDR              CONN_CFG_OSC_CTL_0_ADDR
#define CONN_CFG_OSC_CTL_0_XO_BG_STABLE_TIME_MASK              0x00FF0000                // XO_BG_STABLE_TIME[23..16]
#define CONN_CFG_OSC_CTL_0_XO_BG_STABLE_TIME_SHFT              16
#define CONN_CFG_OSC_CTL_0_XO_INI_STABLE_TIME_ADDR             CONN_CFG_OSC_CTL_0_ADDR
#define CONN_CFG_OSC_CTL_0_XO_INI_STABLE_TIME_MASK             0x0000FF00                // XO_INI_STABLE_TIME[15..8]
#define CONN_CFG_OSC_CTL_0_XO_INI_STABLE_TIME_SHFT             8
#define CONN_CFG_OSC_CTL_0_XO_VCORE_RDY_STABLE_TIME_ADDR       CONN_CFG_OSC_CTL_0_ADDR
#define CONN_CFG_OSC_CTL_0_XO_VCORE_RDY_STABLE_TIME_MASK       0x000000FF                // XO_VCORE_RDY_STABLE_TIME[7..0]
#define CONN_CFG_OSC_CTL_0_XO_VCORE_RDY_STABLE_TIME_SHFT       0

/* =====================================================================================

  ---OSC_CTL_1 (0x18001000 + 0x304)---

    SWCTL_SRCCLKENA[0]           - (RW) Manual control conn_srcclkena (request osc clock source)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_SRCCLKENA
    SWCTL_EN_BG[1]               - (RW) Manual control da_wbg_en_bg (connsys bandgap enable siganl)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_EN_BG
    SWCTL_EN_XBUF[2]             - (RW) Manual control da_wbg_en_xbuf (connsys xtal buffer enable signal)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_EN_XBUF
    SWCTL_VCORE_RDY[3]           - (RW) Manual control osc_rdy (connsys vcore ready signal)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_VCORE_RDY
    SWCTL_OSC_RDY[4]             - (RW) Manual control osc_rdy (connsys osc ready signal)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_OSC_RDY
    RESERVED5[7..5]              - (RO) Reserved bits
    SW_SRCCLKENA[8]              - (RW) Request osc source clock
                                     1'b0: disable
                                     1'b1: enable
    SW_EN_BG[9]                  - (RW) Enable bandgap
                                     1'b0: disable
                                     1'b1: enable
    SW_EN_XBUF[10]               - (RW) Enable xtal buffer
                                     1'b0: disable
                                     1'b1: enable
    SW_VCORE_RDY[11]             - (RW) Enable vcore reay
                                     1'b0: disable
                                     1'b1: enable
    SW_OSC_RDY[12]               - (RW) Enable osc reay
                                     1'b0: disable
                                     1'b1: enable
    RESERVED13[15..13]           - (RO) Reserved bits
    ACK_FOR_XO_STATE_MASK[16]    - (RW) mask source clock enable ack to OSC FSM operation
                                     1'h0: un-mask (speed-up sleep-wakeup time when co-clock)
                                     1'h1: mask
    RESERVED17[30..17]           - (RO) Reserved bits
    XO_NO_OFF[31]                - (RW) it's a option that not turn-off OSC
                                     1'h0: not force OSC turn-on, OSC turn-on/-off is controlled by normal OSC enable H/W procedure
                                     1'h1: force OSC turn-on

 =====================================================================================*/
#define CONN_CFG_OSC_CTL_1_XO_NO_OFF_ADDR                      CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_XO_NO_OFF_MASK                      0x80000000                // XO_NO_OFF[31]
#define CONN_CFG_OSC_CTL_1_XO_NO_OFF_SHFT                      31
#define CONN_CFG_OSC_CTL_1_ACK_FOR_XO_STATE_MASK_ADDR          CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_ACK_FOR_XO_STATE_MASK_MASK          0x00010000                // ACK_FOR_XO_STATE_MASK[16]
#define CONN_CFG_OSC_CTL_1_ACK_FOR_XO_STATE_MASK_SHFT          16
#define CONN_CFG_OSC_CTL_1_SW_OSC_RDY_ADDR                     CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SW_OSC_RDY_MASK                     0x00001000                // SW_OSC_RDY[12]
#define CONN_CFG_OSC_CTL_1_SW_OSC_RDY_SHFT                     12
#define CONN_CFG_OSC_CTL_1_SW_VCORE_RDY_ADDR                   CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SW_VCORE_RDY_MASK                   0x00000800                // SW_VCORE_RDY[11]
#define CONN_CFG_OSC_CTL_1_SW_VCORE_RDY_SHFT                   11
#define CONN_CFG_OSC_CTL_1_SW_EN_XBUF_ADDR                     CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SW_EN_XBUF_MASK                     0x00000400                // SW_EN_XBUF[10]
#define CONN_CFG_OSC_CTL_1_SW_EN_XBUF_SHFT                     10
#define CONN_CFG_OSC_CTL_1_SW_EN_BG_ADDR                       CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SW_EN_BG_MASK                       0x00000200                // SW_EN_BG[9]
#define CONN_CFG_OSC_CTL_1_SW_EN_BG_SHFT                       9
#define CONN_CFG_OSC_CTL_1_SW_SRCCLKENA_ADDR                   CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SW_SRCCLKENA_MASK                   0x00000100                // SW_SRCCLKENA[8]
#define CONN_CFG_OSC_CTL_1_SW_SRCCLKENA_SHFT                   8
#define CONN_CFG_OSC_CTL_1_SWCTL_OSC_RDY_ADDR                  CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SWCTL_OSC_RDY_MASK                  0x00000010                // SWCTL_OSC_RDY[4]
#define CONN_CFG_OSC_CTL_1_SWCTL_OSC_RDY_SHFT                  4
#define CONN_CFG_OSC_CTL_1_SWCTL_VCORE_RDY_ADDR                CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SWCTL_VCORE_RDY_MASK                0x00000008                // SWCTL_VCORE_RDY[3]
#define CONN_CFG_OSC_CTL_1_SWCTL_VCORE_RDY_SHFT                3
#define CONN_CFG_OSC_CTL_1_SWCTL_EN_XBUF_ADDR                  CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SWCTL_EN_XBUF_MASK                  0x00000004                // SWCTL_EN_XBUF[2]
#define CONN_CFG_OSC_CTL_1_SWCTL_EN_XBUF_SHFT                  2
#define CONN_CFG_OSC_CTL_1_SWCTL_EN_BG_ADDR                    CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SWCTL_EN_BG_MASK                    0x00000002                // SWCTL_EN_BG[1]
#define CONN_CFG_OSC_CTL_1_SWCTL_EN_BG_SHFT                    1
#define CONN_CFG_OSC_CTL_1_SWCTL_SRCCLKENA_ADDR                CONN_CFG_OSC_CTL_1_ADDR
#define CONN_CFG_OSC_CTL_1_SWCTL_SRCCLKENA_MASK                0x00000001                // SWCTL_SRCCLKENA[0]
#define CONN_CFG_OSC_CTL_1_SWCTL_SRCCLKENA_SHFT                0

/* =====================================================================================

  ---OSC_MASK (0x18001000 + 0x308)---

    OSC_EN_MASK_7_0[7..0]        - (RW) mask OSC enable request
                                     OSC_EN_MASK[7]: set 1'b1 to mask "AP2CONN_OSC_EN" (from TOP)
                                     OSC_EN_MASK[6]: set 1'b1 to mask "CONN_THM_OSC_EN" (from conn_therm_ctl)
                                     OSC_EN_MASK[5]: set 1'b1 to mask "CONN_PTA_OSC_EN" (from conn_pta6)
                                     OSC_EN_MASK[4]: set 1'b1 to mask "CONN_INFRA_BUS_OSC_EN" (from conn_infra bus)
                                     OSC_EN_MASK[3]: set 1'b1 to mask "FMSYS_OSC_ON" (from conn_infra_cfg_reg)
                                     OSC_EN_MASK[2]: set 1'b1 to mask "GPSSYS_OSC_ON" (from gpssys)
                                     OSC_EN_MASK[1]: set 1'b1 to mask "BGFSYS_OSC_ON" (from bgfsys)
                                     OSC_EN_MASK[0]: set 1'b1 to mask "WFSYS_OSC_ON" (from wfsys)
    WFSYS_OSC_ON[8]              - (RO) indicator: "WFSYS_OSC_ON" (from wfsys)
    BGFSYS_OSC_ON[9]             - (RO) indicator: "BGFSYS_OSC_ON" (from bgfsys)
    GPFSYS_OSC_ON[10]            - (RO) indicator: "GPSSYS_OSC_ON" (from gpssys)
    FMSYS_OSC_ON[11]             - (RO) indicator: "FMSYS_OSC_ON" (from conn_infra_cfg_reg)
    CONN_INFRA_BUS_OSC_EN[12]    - (RO) indicator: "CONN_INFRA_BUS_OSC_EN" (from conn_infra bus)
    CONN_PTA_OSC_EN[13]          - (RO) indicator: "CONN_PTA_OSC_EN" (from conn_pta6)
    CONN_THM_OSC_EN[14]          - (RO) indicator: "CONN_THM_OSC_EN" (from conn_therm_ctl)
    AP2CONN_OSC_EN[15]           - (RO) indicator: "AP2CONN_OSC_EN" (from TOP)
    OSC_EN_MASK_12_8[20..16]     - (RW) mask OSC enable request
                                     OSC_EN_MASK[12]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for FM driver (from conn_host_csr_top)
                                     OSC_EN_MASK[11]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for GPS driver (from conn_host_csr_top)
                                     OSC_EN_MASK[10]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for BT driver (from conn_host_csr_top)
                                     OSC_EN_MASK[9]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for WF driver (from conn_host_csr_top)
                                     OSC_EN_MASK[8]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for TOP driver (from conn_host_csr_top)
    RESERVED21[27..21]           - (RO) Reserved bits
    FUNC_REQ_MASK[28]            - (RW) func_req mask
                                     [0]: conn_pta
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_OSC_MASK_FUNC_REQ_MASK_ADDR                   CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_FUNC_REQ_MASK_MASK                   0x10000000                // FUNC_REQ_MASK[28]
#define CONN_CFG_OSC_MASK_FUNC_REQ_MASK_SHFT                   28
#define CONN_CFG_OSC_MASK_OSC_EN_MASK_12_8_ADDR                CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_OSC_EN_MASK_12_8_MASK                0x001F0000                // OSC_EN_MASK_12_8[20..16]
#define CONN_CFG_OSC_MASK_OSC_EN_MASK_12_8_SHFT                16
#define CONN_CFG_OSC_MASK_AP2CONN_OSC_EN_ADDR                  CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_AP2CONN_OSC_EN_MASK                  0x00008000                // AP2CONN_OSC_EN[15]
#define CONN_CFG_OSC_MASK_AP2CONN_OSC_EN_SHFT                  15
#define CONN_CFG_OSC_MASK_CONN_THM_OSC_EN_ADDR                 CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_CONN_THM_OSC_EN_MASK                 0x00004000                // CONN_THM_OSC_EN[14]
#define CONN_CFG_OSC_MASK_CONN_THM_OSC_EN_SHFT                 14
#define CONN_CFG_OSC_MASK_CONN_PTA_OSC_EN_ADDR                 CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_CONN_PTA_OSC_EN_MASK                 0x00002000                // CONN_PTA_OSC_EN[13]
#define CONN_CFG_OSC_MASK_CONN_PTA_OSC_EN_SHFT                 13
#define CONN_CFG_OSC_MASK_CONN_INFRA_BUS_OSC_EN_ADDR           CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_CONN_INFRA_BUS_OSC_EN_MASK           0x00001000                // CONN_INFRA_BUS_OSC_EN[12]
#define CONN_CFG_OSC_MASK_CONN_INFRA_BUS_OSC_EN_SHFT           12
#define CONN_CFG_OSC_MASK_FMSYS_OSC_ON_ADDR                    CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_FMSYS_OSC_ON_MASK                    0x00000800                // FMSYS_OSC_ON[11]
#define CONN_CFG_OSC_MASK_FMSYS_OSC_ON_SHFT                    11
#define CONN_CFG_OSC_MASK_GPFSYS_OSC_ON_ADDR                   CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_GPFSYS_OSC_ON_MASK                   0x00000400                // GPFSYS_OSC_ON[10]
#define CONN_CFG_OSC_MASK_GPFSYS_OSC_ON_SHFT                   10
#define CONN_CFG_OSC_MASK_BGFSYS_OSC_ON_ADDR                   CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_BGFSYS_OSC_ON_MASK                   0x00000200                // BGFSYS_OSC_ON[9]
#define CONN_CFG_OSC_MASK_BGFSYS_OSC_ON_SHFT                   9
#define CONN_CFG_OSC_MASK_WFSYS_OSC_ON_ADDR                    CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_WFSYS_OSC_ON_MASK                    0x00000100                // WFSYS_OSC_ON[8]
#define CONN_CFG_OSC_MASK_WFSYS_OSC_ON_SHFT                    8
#define CONN_CFG_OSC_MASK_OSC_EN_MASK_7_0_ADDR                 CONN_CFG_OSC_MASK_ADDR
#define CONN_CFG_OSC_MASK_OSC_EN_MASK_7_0_MASK                 0x000000FF                // OSC_EN_MASK_7_0[7..0]
#define CONN_CFG_OSC_MASK_OSC_EN_MASK_7_0_SHFT                 0

/* =====================================================================================

  ---OSC_STATUS (0x18001000 + 0x30C)---

    BUS_OSC_SW_RDY[0]            - (RO) conn_infra BUS clock switch to OSC clock ready indicator
                                     1'h0: not ready
                                     1'h1: ready
    BUS_32K_SW_RDY[1]            - (RO) conn_infra BUS clock switch to 32KHz clock ready indicator
                                     1'h0: not ready
                                     1'h1: ready
    BUS_BGFSYS_CK_SW_RDY[2]      - (RO) conn_infra BUS clock switch to bgfsys BUS clock ready indicator
                                     1'h0: not ready
                                     1'h1: ready
    BUS_WFSYS_CK_SW_RDY[3]       - (RO) conn_infra BUS clock switch to wfsys BUS clock ready indicator
                                     1'h0: not ready
                                     1'h1: ready
    RESERVED4[7..4]              - (RO) Reserved bits
    XO_STATE[10..8]              - (RO) OSC FSM state
                                     3'h0: XO_VCORE_RDY
                                     3'h1: XO_INI
                                     3'h2: XO_PON_BG
                                     3'h3: XO_PON_XBUF
                                     3'h4: XO_POWERON
                                     3'h5: XO_POFF_RDY
                                     3'h6: XO_POFF_BG
                                     3'h7: XO_POWEROFF
    XO_EN[11]                    - (RO) OSC FSM enable
                                     1'h0: disable
                                     1'h1: enable
    HW_OSC_RDY[12]               - (RO) OSC FSM: osc ready
                                     1'h0: not ready
                                     1'h1: ready
    HW_DA_WBG_EN_XBUF[13]        - (RO) OSC FSM: wbg xtal buf enable
                                     1'h0: disable
                                     1'h1: enable
    HW_DA_WBG_EN_BG[14]          - (RO) OSC FSM: wbg bandgap enable
                                     1'h0: disable
                                     1'h1: enable
    HW_VCORE_RDY[15]             - (RO) OSC FSM: vcore ready
                                     1'h0: not ready
                                     1'h1: ready
    HW_CONNSRCCLKENA[16]         - (RO) OSC FSM: srcclkena
                                     1'h0: disable
                                     1'h1: enable
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_OSC_STATUS_HW_CONNSRCCLKENA_ADDR              CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_HW_CONNSRCCLKENA_MASK              0x00010000                // HW_CONNSRCCLKENA[16]
#define CONN_CFG_OSC_STATUS_HW_CONNSRCCLKENA_SHFT              16
#define CONN_CFG_OSC_STATUS_HW_VCORE_RDY_ADDR                  CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_HW_VCORE_RDY_MASK                  0x00008000                // HW_VCORE_RDY[15]
#define CONN_CFG_OSC_STATUS_HW_VCORE_RDY_SHFT                  15
#define CONN_CFG_OSC_STATUS_HW_DA_WBG_EN_BG_ADDR               CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_HW_DA_WBG_EN_BG_MASK               0x00004000                // HW_DA_WBG_EN_BG[14]
#define CONN_CFG_OSC_STATUS_HW_DA_WBG_EN_BG_SHFT               14
#define CONN_CFG_OSC_STATUS_HW_DA_WBG_EN_XBUF_ADDR             CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_HW_DA_WBG_EN_XBUF_MASK             0x00002000                // HW_DA_WBG_EN_XBUF[13]
#define CONN_CFG_OSC_STATUS_HW_DA_WBG_EN_XBUF_SHFT             13
#define CONN_CFG_OSC_STATUS_HW_OSC_RDY_ADDR                    CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_HW_OSC_RDY_MASK                    0x00001000                // HW_OSC_RDY[12]
#define CONN_CFG_OSC_STATUS_HW_OSC_RDY_SHFT                    12
#define CONN_CFG_OSC_STATUS_XO_EN_ADDR                         CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_XO_EN_MASK                         0x00000800                // XO_EN[11]
#define CONN_CFG_OSC_STATUS_XO_EN_SHFT                         11
#define CONN_CFG_OSC_STATUS_XO_STATE_ADDR                      CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_XO_STATE_MASK                      0x00000700                // XO_STATE[10..8]
#define CONN_CFG_OSC_STATUS_XO_STATE_SHFT                      8
#define CONN_CFG_OSC_STATUS_BUS_WFSYS_CK_SW_RDY_ADDR           CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_BUS_WFSYS_CK_SW_RDY_MASK           0x00000008                // BUS_WFSYS_CK_SW_RDY[3]
#define CONN_CFG_OSC_STATUS_BUS_WFSYS_CK_SW_RDY_SHFT           3
#define CONN_CFG_OSC_STATUS_BUS_BGFSYS_CK_SW_RDY_ADDR          CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_BUS_BGFSYS_CK_SW_RDY_MASK          0x00000004                // BUS_BGFSYS_CK_SW_RDY[2]
#define CONN_CFG_OSC_STATUS_BUS_BGFSYS_CK_SW_RDY_SHFT          2
#define CONN_CFG_OSC_STATUS_BUS_32K_SW_RDY_ADDR                CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_BUS_32K_SW_RDY_MASK                0x00000002                // BUS_32K_SW_RDY[1]
#define CONN_CFG_OSC_STATUS_BUS_32K_SW_RDY_SHFT                1
#define CONN_CFG_OSC_STATUS_BUS_OSC_SW_RDY_ADDR                CONN_CFG_OSC_STATUS_ADDR
#define CONN_CFG_OSC_STATUS_BUS_OSC_SW_RDY_MASK                0x00000001                // BUS_OSC_SW_RDY[0]
#define CONN_CFG_OSC_STATUS_BUS_OSC_SW_RDY_SHFT                0

/* =====================================================================================

  ---OSC_2X_CTL_0 (0x18001000 + 0x310)---

    XO_VCORE_RDY_STABLE_TIME[7..0] - (RW) vcore ready stable time counter (40 x 1/32kHz)
                                     this stable time is for fake "source clock enable acknowledgement" information masking
    XO_INI_STABLE_TIME[15..8]    - (RW) OSC clock source stable time counter (150 x 1/32KHz)
    XO_BG_STABLE_TIME[23..16]    - (RW) bandgap stable time counter (151 x 1/32KHz)
    RESERVED24[31..24]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_OSC_2X_CTL_0_XO_BG_STABLE_TIME_ADDR           CONN_CFG_OSC_2X_CTL_0_ADDR
#define CONN_CFG_OSC_2X_CTL_0_XO_BG_STABLE_TIME_MASK           0x00FF0000                // XO_BG_STABLE_TIME[23..16]
#define CONN_CFG_OSC_2X_CTL_0_XO_BG_STABLE_TIME_SHFT           16
#define CONN_CFG_OSC_2X_CTL_0_XO_INI_STABLE_TIME_ADDR          CONN_CFG_OSC_2X_CTL_0_ADDR
#define CONN_CFG_OSC_2X_CTL_0_XO_INI_STABLE_TIME_MASK          0x0000FF00                // XO_INI_STABLE_TIME[15..8]
#define CONN_CFG_OSC_2X_CTL_0_XO_INI_STABLE_TIME_SHFT          8
#define CONN_CFG_OSC_2X_CTL_0_XO_VCORE_RDY_STABLE_TIME_ADDR    CONN_CFG_OSC_2X_CTL_0_ADDR
#define CONN_CFG_OSC_2X_CTL_0_XO_VCORE_RDY_STABLE_TIME_MASK    0x000000FF                // XO_VCORE_RDY_STABLE_TIME[7..0]
#define CONN_CFG_OSC_2X_CTL_0_XO_VCORE_RDY_STABLE_TIME_SHFT    0

/* =====================================================================================

  ---OSC_2X_CTL_1 (0x18001000 + 0x314)---

    SWCTL_SRCCLKENA[0]           - (RW) Manual control conn_srcclkena (request osc clock source)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_SRCCLKENA
    SWCTL_EN_BG[1]               - (RW) Manual control da_wbg_en_bg (connsys bandgap enable siganl)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_EN_BG
    SWCTL_EN_XBUF[2]             - (RW) Manual control da_wbg_en_xbuf (connsys xtal buffer enable signal)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_EN_XBUF
    SWCTL_VCORE_RDY[3]           - (RW) Manual control osc_rdy (connsys vcore ready signal)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_VCORE_RDY
    SWCTL_OSC_RDY[4]             - (RW) Manual control osc_rdy (connsys osc ready signal)
                                     1'h0: HW control mode
                                     1'h1: manual mode, value is set by SW_OSC_RDY
    RESERVED5[7..5]              - (RO) Reserved bits
    SW_SRCCLKENA[8]              - (RW) Request osc source clock
                                     1'b0: disable
                                     1'b1: enable
    SW_EN_BG[9]                  - (RW) Enable bandgap
                                     1'b0: disable
                                     1'b1: enable
    SW_EN_XBUF[10]               - (RW) Enable xtal buffer
                                     1'b0: disable
                                     1'b1: enable
    SW_VCORE_RDY[11]             - (RW) Enable vcore reay
                                     1'b0: disable
                                     1'b1: enable
    SW_OSC_RDY[12]               - (RW) Enable osc reay
                                     1'b0: disable
                                     1'b1: enable
    RESERVED13[15..13]           - (RO) Reserved bits
    ACK_FOR_XO_STATE_MASK[16]    - (RW) mask source clock enable ack to OSC FSM operation
                                     1'h0: un-mask (speed-up sleep-wakeup time when co-clock)
                                     1'h1: mask
    RESERVED17[30..17]           - (RO) Reserved bits
    XO_NO_OFF[31]                - (RW) it's a option that not turn-off OSC
                                     1'h0: not force OSC turn-on, OSC turn-on/-off is controlled by normal OSC enable H/W procedure
                                     1'h1: force OSC turn-on

 =====================================================================================*/
#define CONN_CFG_OSC_2X_CTL_1_XO_NO_OFF_ADDR                   CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_XO_NO_OFF_MASK                   0x80000000                // XO_NO_OFF[31]
#define CONN_CFG_OSC_2X_CTL_1_XO_NO_OFF_SHFT                   31
#define CONN_CFG_OSC_2X_CTL_1_ACK_FOR_XO_STATE_MASK_ADDR       CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_ACK_FOR_XO_STATE_MASK_MASK       0x00010000                // ACK_FOR_XO_STATE_MASK[16]
#define CONN_CFG_OSC_2X_CTL_1_ACK_FOR_XO_STATE_MASK_SHFT       16
#define CONN_CFG_OSC_2X_CTL_1_SW_OSC_RDY_ADDR                  CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SW_OSC_RDY_MASK                  0x00001000                // SW_OSC_RDY[12]
#define CONN_CFG_OSC_2X_CTL_1_SW_OSC_RDY_SHFT                  12
#define CONN_CFG_OSC_2X_CTL_1_SW_VCORE_RDY_ADDR                CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SW_VCORE_RDY_MASK                0x00000800                // SW_VCORE_RDY[11]
#define CONN_CFG_OSC_2X_CTL_1_SW_VCORE_RDY_SHFT                11
#define CONN_CFG_OSC_2X_CTL_1_SW_EN_XBUF_ADDR                  CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SW_EN_XBUF_MASK                  0x00000400                // SW_EN_XBUF[10]
#define CONN_CFG_OSC_2X_CTL_1_SW_EN_XBUF_SHFT                  10
#define CONN_CFG_OSC_2X_CTL_1_SW_EN_BG_ADDR                    CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SW_EN_BG_MASK                    0x00000200                // SW_EN_BG[9]
#define CONN_CFG_OSC_2X_CTL_1_SW_EN_BG_SHFT                    9
#define CONN_CFG_OSC_2X_CTL_1_SW_SRCCLKENA_ADDR                CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SW_SRCCLKENA_MASK                0x00000100                // SW_SRCCLKENA[8]
#define CONN_CFG_OSC_2X_CTL_1_SW_SRCCLKENA_SHFT                8
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_OSC_RDY_ADDR               CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_OSC_RDY_MASK               0x00000010                // SWCTL_OSC_RDY[4]
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_OSC_RDY_SHFT               4
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_VCORE_RDY_ADDR             CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_VCORE_RDY_MASK             0x00000008                // SWCTL_VCORE_RDY[3]
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_VCORE_RDY_SHFT             3
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_EN_XBUF_ADDR               CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_EN_XBUF_MASK               0x00000004                // SWCTL_EN_XBUF[2]
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_EN_XBUF_SHFT               2
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_EN_BG_ADDR                 CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_EN_BG_MASK                 0x00000002                // SWCTL_EN_BG[1]
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_EN_BG_SHFT                 1
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_SRCCLKENA_ADDR             CONN_CFG_OSC_2X_CTL_1_ADDR
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_SRCCLKENA_MASK             0x00000001                // SWCTL_SRCCLKENA[0]
#define CONN_CFG_OSC_2X_CTL_1_SWCTL_SRCCLKENA_SHFT             0

/* =====================================================================================

  ---OSC_2X_MASK (0x18001000 + 0x318)---

    OSC_2X_EN_MASK_7_0[7..0]     - (RW) mask OSC_2X enable request
                                     OSC_EN_MASK[7]: set 1'b1 to mask "AP2CONN_OSC_EN" (from TOP)
                                     OSC_EN_MASK[6]: set 1'b1 to mask "CONN_THM_OSC_EN" (from conn_therm_ctl)
                                     OSC_EN_MASK[5]: set 1'b1 to mask "CONN_PTA_OSC_EN" (from conn_pta6)
                                     OSC_EN_MASK[4]: set 1'b1 to mask "CONN_INFRA_BUS_OSC_EN" (from conn_infra bus)
                                     OSC_EN_MASK[3]: set 1'b1 to mask "FMSYS_OSC_ON" (from conn_infra_cfg_reg)
                                     OSC_EN_MASK[2]: set 1'b1 to mask "GPSSYS_OSC_ON" (from gpssys)
                                     OSC_EN_MASK[1]: set 1'b1 to mask "BGFSYS_OSC_ON" (from bgfsys)
                                     OSC_EN_MASK[0]: set 1'b1 to mask "WFSYS_OSC_ON" (from wfsys)
    RESERVED8[15..8]             - (RO) Reserved bits
    OSC_2X_EN_MASK_12_8[20..16]  - (RW) mask OSC_2X enable request
                                     OSC_EN_MASK[12]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for FM driver (from conn_host_csr_top)
                                     OSC_EN_MASK[11]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for GPS driver (from conn_host_csr_top)
                                     OSC_EN_MASK[10]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for BT driver (from conn_host_csr_top)
                                     OSC_EN_MASK[9]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for WF driver (from conn_host_csr_top)
                                     OSC_EN_MASK[8]: set 1'b1 to mask "cr_wakeup_conn_infra_off" used for TOP driver (from conn_host_csr_top)
    OSC_2X_EN_MASK_13[21]        - (RW) mask OSC_2X enable request
                                     OSC_EN_MASK[13]: set 1'b1 to mask "BGFSYS_OSC_2X_ON" (from bgfsys)
    RESERVED22[31..22]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_13_ADDR            CONN_CFG_OSC_2X_MASK_ADDR
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_13_MASK            0x00200000                // OSC_2X_EN_MASK_13[21]
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_13_SHFT            21
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_12_8_ADDR          CONN_CFG_OSC_2X_MASK_ADDR
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_12_8_MASK          0x001F0000                // OSC_2X_EN_MASK_12_8[20..16]
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_12_8_SHFT          16
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_7_0_ADDR           CONN_CFG_OSC_2X_MASK_ADDR
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_7_0_MASK           0x000000FF                // OSC_2X_EN_MASK_7_0[7..0]
#define CONN_CFG_OSC_2X_MASK_OSC_2X_EN_MASK_7_0_SHFT           0

/* =====================================================================================

  ---OSC_2X_STATUS (0x18001000 + 0x31C)---

    BUS_OSC_SW_RDY[0]            - (RO) conn_infra BUS clock switch to OSC clock ready indicator
                                     1'h0: not ready
                                     1'h1: ready
    BUS_32K_SW_RDY[1]            - (RO) conn_infra BUS clock switch to 32KHz clock ready indicator
                                     1'h0: not ready
                                     1'h1: ready
    BUS_BGFSYS_CK_SW_RDY[2]      - (RO) conn_infra BUS clock switch to bgfsys BUS clock ready indicator
                                     1'h0: not ready
                                     1'h1: ready
    BUS_WFSYS_CK_SW_RDY[3]       - (RO) conn_infra BUS clock switch to wfsys BUS clock ready indicator
                                     1'h0: not ready
                                     1'h1: ready
    RESERVED4[7..4]              - (RO) Reserved bits
    XO_STATE[10..8]              - (RO) OSC FSM state
                                     3'h0: XO_VCORE_RDY
                                     3'h1: XO_INI
                                     3'h2: XO_PON_BG
                                     3'h3: XO_PON_XBUF
                                     3'h4: XO_POWERON
                                     3'h5: XO_POFF_RDY
                                     3'h6: XO_POFF_BG
                                     3'h7: XO_POWEROFF
    XO_EN[11]                    - (RO) OSC FSM enable
                                     1'h0: disable
                                     1'h1: enable
    HW_OSC_RDY[12]               - (RO) OSC FSM: osc ready
                                     1'h0: not ready
                                     1'h1: ready
    HW_DA_WBG_EN_XBUF[13]        - (RO) OSC FSM: wbg xtal buf enable
                                     1'h0: disable
                                     1'h1: enable
    HW_DA_WBG_EN_BG[14]          - (RO) OSC FSM: wbg bandgap enable
                                     1'h0: disable
                                     1'h1: enable
    HW_VCORE_RDY[15]             - (RO) OSC FSM: vcore ready
                                     1'h0: not ready
                                     1'h1: ready
    HW_CONNSRCCLKENA[16]         - (RO) OSC FSM: srcclkena
                                     1'h0: disable
                                     1'h1: enable
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_OSC_2X_STATUS_HW_CONNSRCCLKENA_ADDR           CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_HW_CONNSRCCLKENA_MASK           0x00010000                // HW_CONNSRCCLKENA[16]
#define CONN_CFG_OSC_2X_STATUS_HW_CONNSRCCLKENA_SHFT           16
#define CONN_CFG_OSC_2X_STATUS_HW_VCORE_RDY_ADDR               CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_HW_VCORE_RDY_MASK               0x00008000                // HW_VCORE_RDY[15]
#define CONN_CFG_OSC_2X_STATUS_HW_VCORE_RDY_SHFT               15
#define CONN_CFG_OSC_2X_STATUS_HW_DA_WBG_EN_BG_ADDR            CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_HW_DA_WBG_EN_BG_MASK            0x00004000                // HW_DA_WBG_EN_BG[14]
#define CONN_CFG_OSC_2X_STATUS_HW_DA_WBG_EN_BG_SHFT            14
#define CONN_CFG_OSC_2X_STATUS_HW_DA_WBG_EN_XBUF_ADDR          CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_HW_DA_WBG_EN_XBUF_MASK          0x00002000                // HW_DA_WBG_EN_XBUF[13]
#define CONN_CFG_OSC_2X_STATUS_HW_DA_WBG_EN_XBUF_SHFT          13
#define CONN_CFG_OSC_2X_STATUS_HW_OSC_RDY_ADDR                 CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_HW_OSC_RDY_MASK                 0x00001000                // HW_OSC_RDY[12]
#define CONN_CFG_OSC_2X_STATUS_HW_OSC_RDY_SHFT                 12
#define CONN_CFG_OSC_2X_STATUS_XO_EN_ADDR                      CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_XO_EN_MASK                      0x00000800                // XO_EN[11]
#define CONN_CFG_OSC_2X_STATUS_XO_EN_SHFT                      11
#define CONN_CFG_OSC_2X_STATUS_XO_STATE_ADDR                   CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_XO_STATE_MASK                   0x00000700                // XO_STATE[10..8]
#define CONN_CFG_OSC_2X_STATUS_XO_STATE_SHFT                   8
#define CONN_CFG_OSC_2X_STATUS_BUS_WFSYS_CK_SW_RDY_ADDR        CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_BUS_WFSYS_CK_SW_RDY_MASK        0x00000008                // BUS_WFSYS_CK_SW_RDY[3]
#define CONN_CFG_OSC_2X_STATUS_BUS_WFSYS_CK_SW_RDY_SHFT        3
#define CONN_CFG_OSC_2X_STATUS_BUS_BGFSYS_CK_SW_RDY_ADDR       CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_BUS_BGFSYS_CK_SW_RDY_MASK       0x00000004                // BUS_BGFSYS_CK_SW_RDY[2]
#define CONN_CFG_OSC_2X_STATUS_BUS_BGFSYS_CK_SW_RDY_SHFT       2
#define CONN_CFG_OSC_2X_STATUS_BUS_32K_SW_RDY_ADDR             CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_BUS_32K_SW_RDY_MASK             0x00000002                // BUS_32K_SW_RDY[1]
#define CONN_CFG_OSC_2X_STATUS_BUS_32K_SW_RDY_SHFT             1
#define CONN_CFG_OSC_2X_STATUS_BUS_OSC_SW_RDY_ADDR             CONN_CFG_OSC_2X_STATUS_ADDR
#define CONN_CFG_OSC_2X_STATUS_BUS_OSC_SW_RDY_MASK             0x00000001                // BUS_OSC_SW_RDY[0]
#define CONN_CFG_OSC_2X_STATUS_BUS_OSC_SW_RDY_SHFT             0

/* =====================================================================================

  ---PLL_STATUS (0x18001000 + 0x320)---

    WPLL_RDY[0]                  - (RO) WPLL ready
                                     1'h0: not ready
                                     1'h1: ready
    BPLL_RDY[1]                  - (RO) BPLL ready
                                     1'h0: not ready
                                     1'h1: ready
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_PLL_STATUS_BPLL_RDY_ADDR                      CONN_CFG_PLL_STATUS_ADDR
#define CONN_CFG_PLL_STATUS_BPLL_RDY_MASK                      0x00000002                // BPLL_RDY[1]
#define CONN_CFG_PLL_STATUS_BPLL_RDY_SHFT                      1
#define CONN_CFG_PLL_STATUS_WPLL_RDY_ADDR                      CONN_CFG_PLL_STATUS_ADDR
#define CONN_CFG_PLL_STATUS_WPLL_RDY_MASK                      0x00000001                // WPLL_RDY[0]
#define CONN_CFG_PLL_STATUS_WPLL_RDY_SHFT                      0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_0 (0x18001000 + 0x380)---

    OSC_LEGACY_EN[0]             - (RW) connsys osc legacy control enable
    SW_OSC_ON_ALL[1]             - (RW) sw control osc_on_all (with OSC_LEGACY_EN = 1'b0)
    SW_OSC2X_ON_ALL[2]           - (RW) sw control osc2x_on_all (with OSC2X_LEGACY_EN = 1'b0)
    OSC_LEGACY_EN_2X[3]          - (RW) connsys osc_2x legacy control enable
    GPSSYS_OSC_RC_EN[4]          - (RW) gpssys osc RC control enable
    BTSYS_OSC_RC_EN[5]           - (RW) btsys osc RC control enable
    WFSYS_OSC_RC_EN[6]           - (RW) wfsys osc RC control enable
    CONN_INFRA_OSC_RC_EN[7]      - (RW) conn_infra osc RC control enable
    SW_GPSSYS_OSC_ON_RC[8]       - (RW) sw control gpssys_osc_on(with gpssys_osc_rc_en = 1'b0)
    SW_BTSYS_OSC_ON_RC[9]        - (RW) sw control btsys_osc_on(with btsys_osc_rc_en = 1'b0)
    SW_WFSYS_OSC_ON_RC[10]       - (RW) sw control wfsys_osc_on(with wfsys_osc_rc_en = 1'b0)
    SW_CONN_INFRA_OSC_ON_RC[11]  - (RW) sw control conn_infra_osc_on(with conn_infra_osc_rc_en = 1'b0)
    GPSSYS_BBLPM_EN[12]          - (RW) conn_srcclkena_3_fpm/bblpm selection
                                     1'b0: control srcclkena_3_fpm
                                     1'b1: control srcclkena_3_bblpm
    BTSYS_BBLPM_EN[13]           - (RW) conn_srcclkena_3_fpm/bblpm selection
                                     1'b0: control srcclkena_3_fpm
                                     1'b1: control srcclkena_3_bblpm
    WFSYS_BBLPM_EN[14]           - (RW) conn_srcclkena_3_fpm/bblpm selection
                                     1'b0: control srcclkena_3_fpm
                                     1'b1: control srcclkena_3_bblpm
    CONN_INFRA_BBLPM_EN[15]      - (RW) conn_srcclkena_3_fpm/bblpm selection
                                     1'b0: control srcclkena_3_fpm
                                     1'b1: control srcclkena_3_bblpm
    GPSSYS_OSC_RST_B_SEL[16]     - (RW) gpssys_osc_on_ack Flip-Flop reset selection
                                     1'b0: gpssys_osc_on_ack reset with gpssys_osc_on/rgu_conn_infra_mem_rst_b/conn_infra_off_active
                                     1'b1: gpssys_osc_on_ack reset without gpssys_osc_on/rgu_conn_infra_mem_rst_b/conn_infra_off_active
    BTSYS_OSC_RST_B_SEL[17]      - (RW) btsys_osc_on_ack Flip-Flop reset selection
                                     1'b0: btsys_osc_on_ack reset with btsys_osc_on/rgu_conn_infra_mem_rst_b/conn_infra_off_active
                                     1'b1: btsys_osc_on_ack reset without btsys_osc_on/rgu_conn_infra_mem_rst_b/conn_infra_off_active
    WFSYS_OSC_RST_B_SEL[18]      - (RW) wfsys_osc_on_ack Flip-Flop reset selection
                                     1'b0: wfsys_osc_on_ack reset with wfsys_osc_on/rgu_conn_infra_mem_rst_b/conn_infra_off_active
                                     1'b1: wfsys_osc_on_ack reset without wfsys_osc_on/rgu_conn_infra_mem_rst_b/conn_infra_off_active
    CONN_INFRA_OSC_RST_B_SEL[19] - (RW) conn_infra_osc_on_ack Flip-Flop reset selection (no used)
                                     1'b0: conn_infra_osc_on_ack reset with conn_infra_osc_on/rgu_conn_infra_mem_rst_b/conn_infra_off_active
                                     1'b1: conn_infra_osc_on_ack reset without conn_infra_osc_on/rgu_conn_infra_mem_rst_b/conn_infra_off_active
    CONN_BT_ONLY_RC_EN[20]       - (RW) conn_infra_osc_ctl configure as conn_bt_only mode
                                     conn_srcclkena_1 enable by conn_infra_osc_on
    GPSSYS_VCORE_RST_B_SEL[21]   - (RW) gpssys_vcore_rdy Flip-Flop reset selection
                                     1'b0: gpssys_vcore_rdy reset with gpssys_osc_on
                                     1'b1: gpssys_vcore_rdy reset without gpssys_osc_on
    BTSYS_VCORE_RST_B_SEL[22]    - (RW) btsys_vcore_rdy Flip-Flop reset selection
                                     1'b0: btsys_vcore_rdy reset with btsys_osc_on
                                     1'b1: btsys_vcore_rdy reset without btsys_osc_on
    WFSYS_VCORE_RST_B_SEL[23]    - (RW) wfsys_vcore_rdy Flip-Flop reset selection
                                     1'b0: wfsys_vcore_rdy reset with wfsys_osc_on
                                     1'b1: wfsys_vcore_rdy reset without wfsys_osc_on
    CONN_INFRA_VCORE_RST_B_SEL[24] - (RW) conn_infra_vcore_rdy Flip-Flop reset selection (no used)
                                     1'b0: conn_infra_vcore_rdy reset with conn_infra_osc_on
                                     1'b1: conn_infra_vcore_rdy reset without conn_infra_osc_on
    CONN_BT_ONLY_WGF_RC_EN[25]   - (RW) conn_infra_osc_ctl configure as conn_bt_only mode
                                     conn_srcclkena enable by wgf_osc_en(wf/gps/fm)
    CONN_RC1_SEL[26]             - (RW) conn_srcclkena_1  source selection
                                     1'b0: conn_srcclkena_1
                                     1'b1: conn_srcclkena_3
    CONN_RC3_SEL[27]             - (RW) conn_srcclkena_3  source selection
                                     1'b0: conn_srcclkena_3
                                     1'b1: conn_srcclkena_1
    CONN_BT_ONLY_RC_OUT_EN[28]   - (RW) conn_infra_osc_ctl configure as conn_bt_only mode
                                     1'b1: osc_ack_xxx/vcore_rdy_xxx source is osc_ack_1/vcore_rdy_1
    OSC_EN_SLP_CTL_MASK[29]      - (RW) osc_en_slp_ctl mask for vcore_rdy/osc_on_ack reset
                                     1'b0: unmask; conn_infra_cfg_slp osc_en will be the reset signal for vcore_rdy/osc_on_ack
                                     1'b1: mask;
    RC_BK_EN[30]                 - (RW) conn_infra_osc_ctl configure as rc_backup mode
    OSC_LEGACY_OUT_EN[31]        - (RW) osc legacy control output enable

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_OUT_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_OUT_EN_MASK 0x80000000                // OSC_LEGACY_OUT_EN[31]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_OUT_EN_SHFT 31
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_RC_BK_EN_ADDR         CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_RC_BK_EN_MASK         0x40000000                // RC_BK_EN[30]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_RC_BK_EN_SHFT         30
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_EN_SLP_CTL_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_EN_SLP_CTL_MASK_MASK 0x20000000                // OSC_EN_SLP_CTL_MASK[29]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_EN_SLP_CTL_MASK_SHFT 29
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_RC_OUT_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_RC_OUT_EN_MASK 0x10000000                // CONN_BT_ONLY_RC_OUT_EN[28]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_RC_OUT_EN_SHFT 28
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_RC3_SEL_ADDR     CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_RC3_SEL_MASK     0x08000000                // CONN_RC3_SEL[27]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_RC3_SEL_SHFT     27
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_RC1_SEL_ADDR     CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_RC1_SEL_MASK     0x04000000                // CONN_RC1_SEL[26]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_RC1_SEL_SHFT     26
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_WGF_RC_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_WGF_RC_EN_MASK 0x02000000                // CONN_BT_ONLY_WGF_RC_EN[25]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_WGF_RC_EN_SHFT 25
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_VCORE_RST_B_SEL_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_VCORE_RST_B_SEL_MASK 0x01000000                // CONN_INFRA_VCORE_RST_B_SEL[24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_VCORE_RST_B_SEL_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_VCORE_RST_B_SEL_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_VCORE_RST_B_SEL_MASK 0x00800000                // WFSYS_VCORE_RST_B_SEL[23]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_VCORE_RST_B_SEL_SHFT 23
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_VCORE_RST_B_SEL_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_VCORE_RST_B_SEL_MASK 0x00400000                // BTSYS_VCORE_RST_B_SEL[22]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_VCORE_RST_B_SEL_SHFT 22
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_VCORE_RST_B_SEL_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_VCORE_RST_B_SEL_MASK 0x00200000                // GPSSYS_VCORE_RST_B_SEL[21]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_VCORE_RST_B_SEL_SHFT 21
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_RC_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_RC_EN_MASK 0x00100000                // CONN_BT_ONLY_RC_EN[20]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_BT_ONLY_RC_EN_SHFT 20
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_OSC_RST_B_SEL_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_OSC_RST_B_SEL_MASK 0x00080000                // CONN_INFRA_OSC_RST_B_SEL[19]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_OSC_RST_B_SEL_SHFT 19
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_OSC_RST_B_SEL_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_OSC_RST_B_SEL_MASK 0x00040000                // WFSYS_OSC_RST_B_SEL[18]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_OSC_RST_B_SEL_SHFT 18
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_OSC_RST_B_SEL_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_OSC_RST_B_SEL_MASK 0x00020000                // BTSYS_OSC_RST_B_SEL[17]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_OSC_RST_B_SEL_SHFT 17
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_OSC_RST_B_SEL_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_OSC_RST_B_SEL_MASK 0x00010000                // GPSSYS_OSC_RST_B_SEL[16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_OSC_RST_B_SEL_SHFT 16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_BBLPM_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_BBLPM_EN_MASK 0x00008000                // CONN_INFRA_BBLPM_EN[15]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_BBLPM_EN_SHFT 15
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_BBLPM_EN_ADDR   CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_BBLPM_EN_MASK   0x00004000                // WFSYS_BBLPM_EN[14]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_BBLPM_EN_SHFT   14
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_BBLPM_EN_ADDR   CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_BBLPM_EN_MASK   0x00002000                // BTSYS_BBLPM_EN[13]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_BBLPM_EN_SHFT   13
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_BBLPM_EN_ADDR  CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_BBLPM_EN_MASK  0x00001000                // GPSSYS_BBLPM_EN[12]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_BBLPM_EN_SHFT  12
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_CONN_INFRA_OSC_ON_RC_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_CONN_INFRA_OSC_ON_RC_MASK 0x00000800                // SW_CONN_INFRA_OSC_ON_RC[11]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_CONN_INFRA_OSC_ON_RC_SHFT 11
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_WFSYS_OSC_ON_RC_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_WFSYS_OSC_ON_RC_MASK 0x00000400                // SW_WFSYS_OSC_ON_RC[10]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_WFSYS_OSC_ON_RC_SHFT 10
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_BTSYS_OSC_ON_RC_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_BTSYS_OSC_ON_RC_MASK 0x00000200                // SW_BTSYS_OSC_ON_RC[9]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_BTSYS_OSC_ON_RC_SHFT 9
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_GPSSYS_OSC_ON_RC_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_GPSSYS_OSC_ON_RC_MASK 0x00000100                // SW_GPSSYS_OSC_ON_RC[8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_GPSSYS_OSC_ON_RC_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_OSC_RC_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_OSC_RC_EN_MASK 0x00000080                // CONN_INFRA_OSC_RC_EN[7]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_CONN_INFRA_OSC_RC_EN_SHFT 7
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_OSC_RC_EN_ADDR  CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_OSC_RC_EN_MASK  0x00000040                // WFSYS_OSC_RC_EN[6]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WFSYS_OSC_RC_EN_SHFT  6
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_OSC_RC_EN_ADDR  CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_OSC_RC_EN_MASK  0x00000020                // BTSYS_OSC_RC_EN[5]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BTSYS_OSC_RC_EN_SHFT  5
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_OSC_RC_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_OSC_RC_EN_MASK 0x00000010                // GPSSYS_OSC_RC_EN[4]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPSSYS_OSC_RC_EN_SHFT 4
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_EN_2X_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_EN_2X_MASK 0x00000008                // OSC_LEGACY_EN_2X[3]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_EN_2X_SHFT 3
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_OSC2X_ON_ALL_ADDR  CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_OSC2X_ON_ALL_MASK  0x00000004                // SW_OSC2X_ON_ALL[2]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_OSC2X_ON_ALL_SHFT  2
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_OSC_ON_ALL_ADDR    CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_OSC_ON_ALL_MASK    0x00000002                // SW_OSC_ON_ALL[1]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_SW_OSC_ON_ALL_SHFT    1
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_EN_ADDR    CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_EN_MASK    0x00000001                // OSC_LEGACY_EN[0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_OSC_LEGACY_EN_SHFT    0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_STATUS (0x18001000 + 0x384)---

    GPSSYS_OSC_ON_D1[0]          - (RO)  xxx 
    BTSYS_OSC_ON_D1[1]           - (RO)  xxx 
    WFSYS_OSC_ON_D1[2]           - (RO)  xxx 
    CONN_INFRA_OSC_ON_D1[3]      - (RO)  xxx 
    CONN_SRCCLKENA_0_BBLPM[4]    - (RO)  xxx 
    CONN_SRCCLKENA_0_FPM[5]      - (RO)  xxx 
    CONN_SRCCLKENA_0_BBLPM_ACK[6] - (RO)  xxx 
    CONN_SRCCLKENA_0_FPM_ACK[7]  - (RO)  xxx 
    CONN_SRCCLKENA_1_BBLPM[8]    - (RO)  xxx 
    CONN_SRCCLKENA_1_FPM[9]      - (RO)  xxx 
    CONN_SRCCLKENA_1_BBLPM_ACK[10] - (RO)  xxx 
    CONN_SRCCLKENA_1_FPM_ACK[11] - (RO)  xxx 
    CONN_SRCCLKENA_2_BBLPM[12]   - (RO)  xxx 
    CONN_SRCCLKENA_2_FPM[13]     - (RO)  xxx 
    CONN_SRCCLKENA_2_BBLPM_ACK[14] - (RO)  xxx 
    CONN_SRCCLKENA_2_FPM_ACK[15] - (RO)  xxx 
    CONN_SRCCLKENA_3_BBLPM[16]   - (RO)  xxx 
    CONN_SRCCLKENA_3_FPM[17]     - (RO)  xxx 
    CONN_SRCCLKENA_3_BBLPM_ACK[18] - (RO)  xxx 
    CONN_SRCCLKENA_3_FPM_ACK[19] - (RO)  xxx 
    GPSSYS_OSC_ON_ACK[20]        - (RO)  xxx 
    GPSSYS_VCORE_RDY[21]         - (RO)  xxx 
    BTSYS_OSC_ON_ACK[22]         - (RO)  xxx 
    BTSYS_VCORE_RDY[23]          - (RO)  xxx 
    WFSYS_OSC_ON_ACK[24]         - (RO)  xxx 
    WFSYS_VCORE_RDY[25]          - (RO)  xxx 
    CONN_INFRA_OSC_ON_ACK[26]    - (RO)  xxx 
    CONN_INFRA_VCORE_RDY[27]     - (RO)  xxx 
    CONN_INFRA_OSC_RDY[28]       - (RO)  xxx 
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_RDY_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_RDY_MASK 0x10000000                // CONN_INFRA_OSC_RDY[28]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_RDY_SHFT 28
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_VCORE_RDY_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_VCORE_RDY_MASK 0x08000000                // CONN_INFRA_VCORE_RDY[27]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_VCORE_RDY_SHFT 27
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_ON_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_ON_ACK_MASK 0x04000000                // CONN_INFRA_OSC_ON_ACK[26]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_ON_ACK_SHFT 26
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_VCORE_RDY_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_VCORE_RDY_MASK 0x02000000                // WFSYS_VCORE_RDY[25]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_VCORE_RDY_SHFT 25
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_OSC_ON_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_OSC_ON_ACK_MASK 0x01000000                // WFSYS_OSC_ON_ACK[24]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_OSC_ON_ACK_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_VCORE_RDY_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_VCORE_RDY_MASK 0x00800000                // BTSYS_VCORE_RDY[23]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_VCORE_RDY_SHFT 23
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_OSC_ON_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_OSC_ON_ACK_MASK 0x00400000                // BTSYS_OSC_ON_ACK[22]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_OSC_ON_ACK_SHFT 22
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_VCORE_RDY_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_VCORE_RDY_MASK 0x00200000                // GPSSYS_VCORE_RDY[21]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_VCORE_RDY_SHFT 21
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_OSC_ON_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_OSC_ON_ACK_MASK 0x00100000                // GPSSYS_OSC_ON_ACK[20]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_OSC_ON_ACK_SHFT 20
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_FPM_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_FPM_ACK_MASK 0x00080000                // CONN_SRCCLKENA_3_FPM_ACK[19]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_FPM_ACK_SHFT 19
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_BBLPM_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_BBLPM_ACK_MASK 0x00040000                // CONN_SRCCLKENA_3_BBLPM_ACK[18]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_BBLPM_ACK_SHFT 18
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_FPM_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_FPM_MASK 0x00020000                // CONN_SRCCLKENA_3_FPM[17]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_FPM_SHFT 17
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_BBLPM_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_BBLPM_MASK 0x00010000                // CONN_SRCCLKENA_3_BBLPM[16]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_3_BBLPM_SHFT 16
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_FPM_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_FPM_ACK_MASK 0x00008000                // CONN_SRCCLKENA_2_FPM_ACK[15]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_FPM_ACK_SHFT 15
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_BBLPM_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_BBLPM_ACK_MASK 0x00004000                // CONN_SRCCLKENA_2_BBLPM_ACK[14]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_BBLPM_ACK_SHFT 14
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_FPM_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_FPM_MASK 0x00002000                // CONN_SRCCLKENA_2_FPM[13]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_FPM_SHFT 13
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_BBLPM_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_BBLPM_MASK 0x00001000                // CONN_SRCCLKENA_2_BBLPM[12]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_2_BBLPM_SHFT 12
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_FPM_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_FPM_ACK_MASK 0x00000800                // CONN_SRCCLKENA_1_FPM_ACK[11]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_FPM_ACK_SHFT 11
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_BBLPM_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_BBLPM_ACK_MASK 0x00000400                // CONN_SRCCLKENA_1_BBLPM_ACK[10]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_BBLPM_ACK_SHFT 10
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_FPM_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_FPM_MASK 0x00000200                // CONN_SRCCLKENA_1_FPM[9]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_FPM_SHFT 9
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_BBLPM_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_BBLPM_MASK 0x00000100                // CONN_SRCCLKENA_1_BBLPM[8]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_1_BBLPM_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_FPM_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_FPM_ACK_MASK 0x00000080                // CONN_SRCCLKENA_0_FPM_ACK[7]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_FPM_ACK_SHFT 7
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_BBLPM_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_BBLPM_ACK_MASK 0x00000040                // CONN_SRCCLKENA_0_BBLPM_ACK[6]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_BBLPM_ACK_SHFT 6
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_FPM_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_FPM_MASK 0x00000020                // CONN_SRCCLKENA_0_FPM[5]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_FPM_SHFT 5
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_BBLPM_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_BBLPM_MASK 0x00000010                // CONN_SRCCLKENA_0_BBLPM[4]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_SRCCLKENA_0_BBLPM_SHFT 4
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_ON_D1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_ON_D1_MASK 0x00000008                // CONN_INFRA_OSC_ON_D1[3]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_CONN_INFRA_OSC_ON_D1_SHFT 3
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_OSC_ON_D1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_OSC_ON_D1_MASK 0x00000004                // WFSYS_OSC_ON_D1[2]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_WFSYS_OSC_ON_D1_SHFT 2
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_OSC_ON_D1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_OSC_ON_D1_MASK 0x00000002                // BTSYS_OSC_ON_D1[1]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_BTSYS_OSC_ON_D1_SHFT 1
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_OSC_ON_D1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_OSC_ON_D1_MASK 0x00000001                // GPSSYS_OSC_ON_D1[0]
#define CONN_CFG_CONN_INFRA_CFG_RC_STATUS_GPSSYS_OSC_ON_D1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_1 (0x18001000 + 0x388)---

    GPSSYS_OSC_RC_OUT_EN[0]      - (RW) gpssys osc RC control output enable
    BTSYS_OSC_RC_OUT_EN[1]       - (RW) btsys osc RC control output enable
    WFSYS_OSC_RC_OUT_EN[2]       - (RW) wfsys osc RC control output enable
    CONN_INFRA_OSC_RC_OUT_EN[3]  - (RW) conn_infra osc RC control output enable
    OSC_EN_MASK_RC_BK[7..4]      - (RW) OSC_EN_MASK_RC_BK[3]: set 1'b1 to mask "FMSYS_OSC_ON" (from conn_infra_cfg_reg)
                                     OSC_EN_MASK_RC_BK[2]: set 1'b1 to mask "GPSSYS_OSC_ON" (from gpssys)
                                     OSC_EN_MASK_RC_BK[1]: set 1'b1 to mask "BGFSYS_OSC_ON" (from bgfsys)
                                     OSC_EN_MASK_RC_BK[0]: set 1'b1 to mask "WFSYS_OSC_ON" (from wfsys)
    RC_RSV[15..8]                - (RW) reserved CR for RC_CTL
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_RC_RSV_ADDR           CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_RC_RSV_MASK           0x0000FF00                // RC_RSV[15..8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_RC_RSV_SHFT           8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_OSC_EN_MASK_RC_BK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_OSC_EN_MASK_RC_BK_MASK 0x000000F0                // OSC_EN_MASK_RC_BK[7..4]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_OSC_EN_MASK_RC_BK_SHFT 4
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_CONN_INFRA_OSC_RC_OUT_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_CONN_INFRA_OSC_RC_OUT_EN_MASK 0x00000008                // CONN_INFRA_OSC_RC_OUT_EN[3]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_CONN_INFRA_OSC_RC_OUT_EN_SHFT 3
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WFSYS_OSC_RC_OUT_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WFSYS_OSC_RC_OUT_EN_MASK 0x00000004                // WFSYS_OSC_RC_OUT_EN[2]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WFSYS_OSC_RC_OUT_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BTSYS_OSC_RC_OUT_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BTSYS_OSC_RC_OUT_EN_MASK 0x00000002                // BTSYS_OSC_RC_OUT_EN[1]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BTSYS_OSC_RC_OUT_EN_SHFT 1
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPSSYS_OSC_RC_OUT_EN_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPSSYS_OSC_RC_OUT_EN_MASK 0x00000001                // GPSSYS_OSC_RC_OUT_EN[0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPSSYS_OSC_RC_OUT_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_0_GPS (0x18001000 + 0x390)---

    SWCTL_CONN_SRCCLKENA_0[0]    - (RW) conn_srcclkena_0 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_DA_WBG_EN_BG_0[1]      - (RW) da_wbg_en_bg_0 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_DA_WBG_EN_XBUF_0[2]    - (RW) da_wbg_en_xbuf_0 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_VCORE_RDY_0[3]         - (RW) vcore_rdy_0 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_OSC_RDY_0[4]           - (RW) osc_rdy_0 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    RC_GPS_RSV[7..5]             - (RW) reserved CR for RC_GPS
    SW_CONN_SRCCLKENA_0[8]       - (RW) sw control conn_srcclkena_0
    SW_DA_WBG_EN_BG_0[9]         - (RW) sw control da_wbg_en_bg_0
    SW_DA_WBG_EN_XBUF_0[10]      - (RW) sw control da_wbg_en_xbuf_0
    SW_VCORE_RDY_0[11]           - (RW) sw control vcore_rdy_0
    SW_OSC_RDY_0[12]             - (RW) sw control osc_rdy_0
    GPS_VCORE_RDY_EN_MASK[13]    - (RW) osc_on_ack gps fake ack filter mask
                                     1'b0: osc_on_ack filter by gps fake ack filter
                                     1'b1: osc_on_ack bypass gps fake ack filter
    GPS_OSC_ON_ACK_EN_MASK[14]   - (RW) vcore_rdy gps fake ack filter mask
                                     1'b0: vcore_rdy filter by gps fake ack filter
                                     1'b1: vcore_rdy bypass gps fake ack filter
    ACK_FOR_XO_STATE_MASK_0[15]  - (RW) mask conn_srcclkena_0_bblpm/fpm_ack for xo_state
                                     1'b0: check conn_srcclkena_0_bblpm/fpm_ack
                                     1'b1: mask conn_srcclkena_0_bblpm/fpm_ack
    XO_EN_0[16]                  - (RO)  xxx 
    XO_STATE_0[20..17]           - (RO)  xxx 
    HW_CONN_SRCCLKENA_0[21]      - (RO)  xxx 
    HW_VCORE_RDY_0[22]           - (RO)  xxx 
    HW_DA_WBG_EN_BG_0[23]        - (RO)  xxx 
    HW_DA_WBG_EN_XBUF_0[24]      - (RO)  xxx 
    HW_OSC_RDY_0[25]             - (RO)  xxx 
    GPS_OSC_ACK_BP_PWR_ACK[26]   - (RW) gpsys_osc_on_ack Flip-Flop reset bypass conn_infra_off_active
                                     1'b0:  check conn_infra_off_active
                                     1'b1: bypass conn_infra_off_active
    GPS_OSC_ACK_BP_MEM_PON[27]   - (RW) gpsys_osc_on_ack Flip-Flop reset bypass conn_infra_mem_rst_b
                                     1'b0:  check conn_infra_mem_rst_b
                                     1'b1: bypass conn_infra_mem_rst_b
    GPS_VCORE_FILTER_TIMEOUT[31..28] - (RW) gps fake ack filter timeout value

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_VCORE_FILTER_TIMEOUT_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_VCORE_FILTER_TIMEOUT_MASK 0xF0000000                // GPS_VCORE_FILTER_TIMEOUT[31..28]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_VCORE_FILTER_TIMEOUT_SHFT 28
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ACK_BP_MEM_PON_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ACK_BP_MEM_PON_MASK 0x08000000                // GPS_OSC_ACK_BP_MEM_PON[27]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ACK_BP_MEM_PON_SHFT 27
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ACK_BP_PWR_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ACK_BP_PWR_ACK_MASK 0x04000000                // GPS_OSC_ACK_BP_PWR_ACK[26]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ACK_BP_PWR_ACK_SHFT 26
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_OSC_RDY_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_OSC_RDY_0_MASK 0x02000000                // HW_OSC_RDY_0[25]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_OSC_RDY_0_SHFT 25
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_DA_WBG_EN_XBUF_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_DA_WBG_EN_XBUF_0_MASK 0x01000000                // HW_DA_WBG_EN_XBUF_0[24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_DA_WBG_EN_XBUF_0_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_DA_WBG_EN_BG_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_DA_WBG_EN_BG_0_MASK 0x00800000                // HW_DA_WBG_EN_BG_0[23]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_DA_WBG_EN_BG_0_SHFT 23
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_VCORE_RDY_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_VCORE_RDY_0_MASK 0x00400000                // HW_VCORE_RDY_0[22]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_VCORE_RDY_0_SHFT 22
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_CONN_SRCCLKENA_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_CONN_SRCCLKENA_0_MASK 0x00200000                // HW_CONN_SRCCLKENA_0[21]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_HW_CONN_SRCCLKENA_0_SHFT 21
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_XO_STATE_0_ADDR   CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_XO_STATE_0_MASK   0x001E0000                // XO_STATE_0[20..17]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_XO_STATE_0_SHFT   17
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_XO_EN_0_ADDR      CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_XO_EN_0_MASK      0x00010000                // XO_EN_0[16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_XO_EN_0_SHFT      16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ACK_FOR_XO_STATE_MASK_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ACK_FOR_XO_STATE_MASK_0_MASK 0x00008000                // ACK_FOR_XO_STATE_MASK_0[15]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ACK_FOR_XO_STATE_MASK_0_SHFT 15
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ON_ACK_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ON_ACK_EN_MASK_MASK 0x00004000                // GPS_OSC_ON_ACK_EN_MASK[14]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_OSC_ON_ACK_EN_MASK_SHFT 14
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_VCORE_RDY_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_VCORE_RDY_EN_MASK_MASK 0x00002000                // GPS_VCORE_RDY_EN_MASK[13]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_GPS_VCORE_RDY_EN_MASK_SHFT 13
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_OSC_RDY_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_OSC_RDY_0_MASK 0x00001000                // SW_OSC_RDY_0[12]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_OSC_RDY_0_SHFT 12
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_VCORE_RDY_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_VCORE_RDY_0_MASK 0x00000800                // SW_VCORE_RDY_0[11]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_VCORE_RDY_0_SHFT 11
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_DA_WBG_EN_XBUF_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_DA_WBG_EN_XBUF_0_MASK 0x00000400                // SW_DA_WBG_EN_XBUF_0[10]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_DA_WBG_EN_XBUF_0_SHFT 10
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_DA_WBG_EN_BG_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_DA_WBG_EN_BG_0_MASK 0x00000200                // SW_DA_WBG_EN_BG_0[9]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_DA_WBG_EN_BG_0_SHFT 9
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_CONN_SRCCLKENA_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_CONN_SRCCLKENA_0_MASK 0x00000100                // SW_CONN_SRCCLKENA_0[8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SW_CONN_SRCCLKENA_0_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_RC_GPS_RSV_ADDR   CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_RC_GPS_RSV_MASK   0x000000E0                // RC_GPS_RSV[7..5]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_RC_GPS_RSV_SHFT   5
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_OSC_RDY_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_OSC_RDY_0_MASK 0x00000010                // SWCTL_OSC_RDY_0[4]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_OSC_RDY_0_SHFT 4
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_VCORE_RDY_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_VCORE_RDY_0_MASK 0x00000008                // SWCTL_VCORE_RDY_0[3]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_VCORE_RDY_0_SHFT 3
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_DA_WBG_EN_XBUF_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_DA_WBG_EN_XBUF_0_MASK 0x00000004                // SWCTL_DA_WBG_EN_XBUF_0[2]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_DA_WBG_EN_XBUF_0_SHFT 2
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_DA_WBG_EN_BG_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_DA_WBG_EN_BG_0_MASK 0x00000002                // SWCTL_DA_WBG_EN_BG_0[1]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_DA_WBG_EN_BG_0_SHFT 1
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_CONN_SRCCLKENA_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_CONN_SRCCLKENA_0_MASK 0x00000001                // SWCTL_CONN_SRCCLKENA_0[0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_GPS_SWCTL_CONN_SRCCLKENA_0_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_1_GPS (0x18001000 + 0x394)---

    XO_VCORE_RDY_STABLE_TIME_0[7..0] - (RW) xo_vcore_rdy_stable_time_0 for conn_srcclkena_0_ack valid
    XO_INI_STABLE_TIME_0[15..8]  - (RW) xo_ini_stable_time_0 for xo_ini stable
    XO_BG_STABLE_TIME_0[23..16]  - (RW) xo_bg_stable_time_0 for xo_bg stable
    XO_VCORE_OFF_STABLE_TIME_0[31..24] - (RW) xo_vcroe_off_stable_time_0 for conn_srcclkena_0_ack high to low

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_VCORE_OFF_STABLE_TIME_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_VCORE_OFF_STABLE_TIME_0_MASK 0xFF000000                // XO_VCORE_OFF_STABLE_TIME_0[31..24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_VCORE_OFF_STABLE_TIME_0_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_BG_STABLE_TIME_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_BG_STABLE_TIME_0_MASK 0x00FF0000                // XO_BG_STABLE_TIME_0[23..16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_BG_STABLE_TIME_0_SHFT 16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_INI_STABLE_TIME_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_INI_STABLE_TIME_0_MASK 0x0000FF00                // XO_INI_STABLE_TIME_0[15..8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_INI_STABLE_TIME_0_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_VCORE_RDY_STABLE_TIME_0_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_VCORE_RDY_STABLE_TIME_0_MASK 0x000000FF                // XO_VCORE_RDY_STABLE_TIME_0[7..0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_GPS_XO_VCORE_RDY_STABLE_TIME_0_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_0_BT (0x18001000 + 0x3A0)---

    SWCTL_CONN_SRCCLKENA_1[0]    - (RW) conn_srcclkena_1 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_DA_WBG_EN_BG_1[1]      - (RW) da_wbg_en_bg_1 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_DA_WBG_EN_XBUF_1[2]    - (RW) da_wbg_en_xbuf_1 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_VCORE_RDY_1[3]         - (RW) vcore_rdy_1 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_OSC_RDY_1[4]           - (RW) osc_rdy_1 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    RC_BT_RSV[7..5]              - (RW) reserved CR for RC_BT
    SW_CONN_SRCCLKENA_1[8]       - (RW) sw control conn_srcclkena_1
    SW_DA_WBG_EN_BG_1[9]         - (RW) sw control da_wbg_en_bg_1
    SW_DA_WBG_EN_XBUF_1[10]      - (RW) sw control da_wbg_en_xbuf_1
    SW_VCORE_RDY_1[11]           - (RW) sw control vcore_rdy_1
    SW_OSC_RDY_1[12]             - (RW) sw control osc_rdy_1
    BT_VCORE_RDY_EN_MASK[13]     - (RW) osc_on_ack bt fake ack filter mask
                                     1'b0: osc_on_ack filter by bt fake ack filter
                                     1'b1: osc_on_ack bypass bt fake ack filter
    BT_OSC_ON_ACK_EN_MASK[14]    - (RW) vcore_rdy bt fake ack filter mask
                                     1'b0: vcore_rdy filter by bt fake ack filter
                                     1'b1: vcore_rdy bypass bt fake ack filter
    ACK_FOR_XO_STATE_MASK_1[15]  - (RW) mask conn_srcclkena_1_bblpm/fpm_ack for xo_state
                                     1'b0: check conn_srcclkena_1_bblpm/fpm_ack
                                     1'b1: mask conn_srcclkena_1_bblpm/fpm_ack
    XO_EN_1[16]                  - (RO)  xxx 
    XO_STATE_1[20..17]           - (RO)  xxx 
    HW_CONN_SRCCLKENA_1[21]      - (RO)  xxx 
    HW_VCORE_RDY_1[22]           - (RO)  xxx 
    HW_DA_WBG_EN_BG_1[23]        - (RO)  xxx 
    HW_DA_WBG_EN_XBUF_1[24]      - (RO)  xxx 
    HW_OSC_RDY_1[25]             - (RO)  xxx 
    BT_OSC_ACK_BP_PWR_ACK[26]    - (RW) btsys_osc_on_ack Flip-Flop reset bypass conn_infra_off_active
                                     1'b0:  check conn_infra_off_active
                                     1'b1: bypass conn_infra_off_active
    BT_OSC_ACK_BP_MEM_PON[27]    - (RW) btsys_osc_on_ack Flip-Flop reset bypass conn_infra_mem_rst_b
                                     1'b0:  check conn_infra_mem_rst_b
                                     1'b1: bypass conn_infra_mem_rst_b
    BT_VCORE_FILTER_TIMEOUT[31..28] - (RW) bt fake ack filter timeout value

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_VCORE_FILTER_TIMEOUT_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_VCORE_FILTER_TIMEOUT_MASK 0xF0000000                // BT_VCORE_FILTER_TIMEOUT[31..28]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_VCORE_FILTER_TIMEOUT_SHFT 28
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ACK_BP_MEM_PON_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ACK_BP_MEM_PON_MASK 0x08000000                // BT_OSC_ACK_BP_MEM_PON[27]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ACK_BP_MEM_PON_SHFT 27
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ACK_BP_PWR_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ACK_BP_PWR_ACK_MASK 0x04000000                // BT_OSC_ACK_BP_PWR_ACK[26]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ACK_BP_PWR_ACK_SHFT 26
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_OSC_RDY_1_ADDR  CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_OSC_RDY_1_MASK  0x02000000                // HW_OSC_RDY_1[25]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_OSC_RDY_1_SHFT  25
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_DA_WBG_EN_XBUF_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_DA_WBG_EN_XBUF_1_MASK 0x01000000                // HW_DA_WBG_EN_XBUF_1[24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_DA_WBG_EN_XBUF_1_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_DA_WBG_EN_BG_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_DA_WBG_EN_BG_1_MASK 0x00800000                // HW_DA_WBG_EN_BG_1[23]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_DA_WBG_EN_BG_1_SHFT 23
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_VCORE_RDY_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_VCORE_RDY_1_MASK 0x00400000                // HW_VCORE_RDY_1[22]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_VCORE_RDY_1_SHFT 22
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_CONN_SRCCLKENA_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_CONN_SRCCLKENA_1_MASK 0x00200000                // HW_CONN_SRCCLKENA_1[21]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_HW_CONN_SRCCLKENA_1_SHFT 21
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_XO_STATE_1_ADDR    CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_XO_STATE_1_MASK    0x001E0000                // XO_STATE_1[20..17]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_XO_STATE_1_SHFT    17
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_XO_EN_1_ADDR       CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_XO_EN_1_MASK       0x00010000                // XO_EN_1[16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_XO_EN_1_SHFT       16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ACK_FOR_XO_STATE_MASK_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ACK_FOR_XO_STATE_MASK_1_MASK 0x00008000                // ACK_FOR_XO_STATE_MASK_1[15]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ACK_FOR_XO_STATE_MASK_1_SHFT 15
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ON_ACK_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ON_ACK_EN_MASK_MASK 0x00004000                // BT_OSC_ON_ACK_EN_MASK[14]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_OSC_ON_ACK_EN_MASK_SHFT 14
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_VCORE_RDY_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_VCORE_RDY_EN_MASK_MASK 0x00002000                // BT_VCORE_RDY_EN_MASK[13]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_BT_VCORE_RDY_EN_MASK_SHFT 13
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_OSC_RDY_1_ADDR  CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_OSC_RDY_1_MASK  0x00001000                // SW_OSC_RDY_1[12]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_OSC_RDY_1_SHFT  12
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_VCORE_RDY_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_VCORE_RDY_1_MASK 0x00000800                // SW_VCORE_RDY_1[11]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_VCORE_RDY_1_SHFT 11
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_DA_WBG_EN_XBUF_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_DA_WBG_EN_XBUF_1_MASK 0x00000400                // SW_DA_WBG_EN_XBUF_1[10]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_DA_WBG_EN_XBUF_1_SHFT 10
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_DA_WBG_EN_BG_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_DA_WBG_EN_BG_1_MASK 0x00000200                // SW_DA_WBG_EN_BG_1[9]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_DA_WBG_EN_BG_1_SHFT 9
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_CONN_SRCCLKENA_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_CONN_SRCCLKENA_1_MASK 0x00000100                // SW_CONN_SRCCLKENA_1[8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SW_CONN_SRCCLKENA_1_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_RC_BT_RSV_ADDR     CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_RC_BT_RSV_MASK     0x000000E0                // RC_BT_RSV[7..5]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_RC_BT_RSV_SHFT     5
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_OSC_RDY_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_OSC_RDY_1_MASK 0x00000010                // SWCTL_OSC_RDY_1[4]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_OSC_RDY_1_SHFT 4
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_VCORE_RDY_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_VCORE_RDY_1_MASK 0x00000008                // SWCTL_VCORE_RDY_1[3]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_VCORE_RDY_1_SHFT 3
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_DA_WBG_EN_XBUF_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_DA_WBG_EN_XBUF_1_MASK 0x00000004                // SWCTL_DA_WBG_EN_XBUF_1[2]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_DA_WBG_EN_XBUF_1_SHFT 2
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_DA_WBG_EN_BG_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_DA_WBG_EN_BG_1_MASK 0x00000002                // SWCTL_DA_WBG_EN_BG_1[1]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_DA_WBG_EN_BG_1_SHFT 1
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_CONN_SRCCLKENA_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_CONN_SRCCLKENA_1_MASK 0x00000001                // SWCTL_CONN_SRCCLKENA_1[0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_BT_SWCTL_CONN_SRCCLKENA_1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_1_BT (0x18001000 + 0x3A4)---

    XO_VCORE_RDY_STABLE_TIME_1[7..0] - (RW) xo_vcore_rdy_stable_time_1 for conn_srcclkena_1_ack valid
    XO_INI_STABLE_TIME_1[15..8]  - (RW) xo_ini_stable_time_1 for xo_ini stable
    XO_BG_STABLE_TIME_1[23..16]  - (RW) xo_bg_stable_time_1 for xo_bg stable
    XO_VCORE_OFF_STABLE_TIME_1[31..24] - (RW) xo_vcroe_off_stable_time_1 for conn_srcclkena_1_ack high to low

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_VCORE_OFF_STABLE_TIME_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_VCORE_OFF_STABLE_TIME_1_MASK 0xFF000000                // XO_VCORE_OFF_STABLE_TIME_1[31..24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_VCORE_OFF_STABLE_TIME_1_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_BG_STABLE_TIME_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_BG_STABLE_TIME_1_MASK 0x00FF0000                // XO_BG_STABLE_TIME_1[23..16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_BG_STABLE_TIME_1_SHFT 16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_INI_STABLE_TIME_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_INI_STABLE_TIME_1_MASK 0x0000FF00                // XO_INI_STABLE_TIME_1[15..8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_INI_STABLE_TIME_1_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_VCORE_RDY_STABLE_TIME_1_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_VCORE_RDY_STABLE_TIME_1_MASK 0x000000FF                // XO_VCORE_RDY_STABLE_TIME_1[7..0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_BT_XO_VCORE_RDY_STABLE_TIME_1_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_0_WF (0x18001000 + 0x3B0)---

    SWCTL_CONN_SRCCLKENA_2[0]    - (RW) conn_srcclkena_2 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_DA_WBG_EN_BG_2[1]      - (RW) da_wbg_en_bg_2 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_DA_WBG_EN_XBUF_2[2]    - (RW) da_wbg_en_xbuf_2 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_VCORE_RDY_2[3]         - (RW) vcore_rdy_2 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_OSC_RDY_2[4]           - (RW) osc_rdy_2 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    RC_WF_RSV[7..5]              - (RW) reserved CR for RC_WF
    SW_CONN_SRCCLKENA_2[8]       - (RW) sw control conn_srcclkena_2
    SW_DA_WBG_EN_BG_2[9]         - (RW) sw control da_wbg_en_bg_2
    SW_DA_WBG_EN_XBUF_2[10]      - (RW) sw control da_wbg_en_xbuf_2
    SW_VCORE_RDY_2[11]           - (RW) sw control vcore_rdy_2
    SW_OSC_RDY_2[12]             - (RW) sw control osc_rdy_2
    WF_VCORE_RDY_EN_MASK[13]     - (RW) osc_on_ack wf fake ack filter mask
                                     1'b0: osc_on_ack filter by wf fake ack filter
                                     1'b1: osc_on_ack bypass wf fake ack filter
    WF_OSC_ON_ACK_EN_MASK[14]    - (RW) vcore_rdy wf fake ack filter mask
                                     1'b0: vcore_rdy filter by wf fake ack filter
                                     1'b1: vcore_rdy bypass wf fake ack filter
    ACK_FOR_XO_STATE_MASK_2[15]  - (RW) mask conn_srcclkena_2_bblpm/fpm_ack for xo_state
                                     1'b0: check conn_srcclkena_2_bblpm/fpm_ack
                                     1'b1: mask conn_srcclkena_2_bblpm/fpm_ack
    XO_EN_2[16]                  - (RO)  xxx 
    XO_STATE_2[20..17]           - (RO)  xxx 
    HW_CONN_SRCCLKENA_2[21]      - (RO)  xxx 
    HW_VCORE_RDY_2[22]           - (RO)  xxx 
    HW_DA_WBG_EN_BG_2[23]        - (RO)  xxx 
    HW_DA_WBG_EN_XBUF_2[24]      - (RO)  xxx 
    HW_OSC_RDY_2[25]             - (RO)  xxx 
    WF_OSC_ACK_BP_PWR_ACK[26]    - (RW) wfsys_osc_on_ack Flip-Flop reset bypass conn_infra_off_active
                                     1'b0:  check conn_infra_off_active
                                     1'b1: bypass conn_infra_off_active
    WF_OSC_ACK_BP_MEM_PON[27]    - (RW) wfsys_osc_on_ack Flip-Flop reset bypass conn_infra_mem_rst_b
                                     1'b0:  check conn_infra_mem_rst_b
                                     1'b1: bypass conn_infra_mem_rst_b
    WF_VCORE_FILTER_TIMEOUT[31..28] - (RW) wf fake ack filter timeout value

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_VCORE_FILTER_TIMEOUT_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_VCORE_FILTER_TIMEOUT_MASK 0xF0000000                // WF_VCORE_FILTER_TIMEOUT[31..28]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_VCORE_FILTER_TIMEOUT_SHFT 28
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ACK_BP_MEM_PON_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ACK_BP_MEM_PON_MASK 0x08000000                // WF_OSC_ACK_BP_MEM_PON[27]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ACK_BP_MEM_PON_SHFT 27
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ACK_BP_PWR_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ACK_BP_PWR_ACK_MASK 0x04000000                // WF_OSC_ACK_BP_PWR_ACK[26]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ACK_BP_PWR_ACK_SHFT 26
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_OSC_RDY_2_ADDR  CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_OSC_RDY_2_MASK  0x02000000                // HW_OSC_RDY_2[25]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_OSC_RDY_2_SHFT  25
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_DA_WBG_EN_XBUF_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_DA_WBG_EN_XBUF_2_MASK 0x01000000                // HW_DA_WBG_EN_XBUF_2[24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_DA_WBG_EN_XBUF_2_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_DA_WBG_EN_BG_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_DA_WBG_EN_BG_2_MASK 0x00800000                // HW_DA_WBG_EN_BG_2[23]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_DA_WBG_EN_BG_2_SHFT 23
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_VCORE_RDY_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_VCORE_RDY_2_MASK 0x00400000                // HW_VCORE_RDY_2[22]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_VCORE_RDY_2_SHFT 22
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_CONN_SRCCLKENA_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_CONN_SRCCLKENA_2_MASK 0x00200000                // HW_CONN_SRCCLKENA_2[21]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_HW_CONN_SRCCLKENA_2_SHFT 21
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_XO_STATE_2_ADDR    CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_XO_STATE_2_MASK    0x001E0000                // XO_STATE_2[20..17]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_XO_STATE_2_SHFT    17
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_XO_EN_2_ADDR       CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_XO_EN_2_MASK       0x00010000                // XO_EN_2[16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_XO_EN_2_SHFT       16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ACK_FOR_XO_STATE_MASK_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ACK_FOR_XO_STATE_MASK_2_MASK 0x00008000                // ACK_FOR_XO_STATE_MASK_2[15]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ACK_FOR_XO_STATE_MASK_2_SHFT 15
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ON_ACK_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ON_ACK_EN_MASK_MASK 0x00004000                // WF_OSC_ON_ACK_EN_MASK[14]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_OSC_ON_ACK_EN_MASK_SHFT 14
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_VCORE_RDY_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_VCORE_RDY_EN_MASK_MASK 0x00002000                // WF_VCORE_RDY_EN_MASK[13]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_WF_VCORE_RDY_EN_MASK_SHFT 13
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_OSC_RDY_2_ADDR  CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_OSC_RDY_2_MASK  0x00001000                // SW_OSC_RDY_2[12]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_OSC_RDY_2_SHFT  12
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_VCORE_RDY_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_VCORE_RDY_2_MASK 0x00000800                // SW_VCORE_RDY_2[11]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_VCORE_RDY_2_SHFT 11
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_DA_WBG_EN_XBUF_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_DA_WBG_EN_XBUF_2_MASK 0x00000400                // SW_DA_WBG_EN_XBUF_2[10]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_DA_WBG_EN_XBUF_2_SHFT 10
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_DA_WBG_EN_BG_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_DA_WBG_EN_BG_2_MASK 0x00000200                // SW_DA_WBG_EN_BG_2[9]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_DA_WBG_EN_BG_2_SHFT 9
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_CONN_SRCCLKENA_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_CONN_SRCCLKENA_2_MASK 0x00000100                // SW_CONN_SRCCLKENA_2[8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SW_CONN_SRCCLKENA_2_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_RC_WF_RSV_ADDR     CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_RC_WF_RSV_MASK     0x000000E0                // RC_WF_RSV[7..5]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_RC_WF_RSV_SHFT     5
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_OSC_RDY_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_OSC_RDY_2_MASK 0x00000010                // SWCTL_OSC_RDY_2[4]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_OSC_RDY_2_SHFT 4
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_VCORE_RDY_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_VCORE_RDY_2_MASK 0x00000008                // SWCTL_VCORE_RDY_2[3]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_VCORE_RDY_2_SHFT 3
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_DA_WBG_EN_XBUF_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_DA_WBG_EN_XBUF_2_MASK 0x00000004                // SWCTL_DA_WBG_EN_XBUF_2[2]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_DA_WBG_EN_XBUF_2_SHFT 2
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_DA_WBG_EN_BG_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_DA_WBG_EN_BG_2_MASK 0x00000002                // SWCTL_DA_WBG_EN_BG_2[1]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_DA_WBG_EN_BG_2_SHFT 1
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_CONN_SRCCLKENA_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_CONN_SRCCLKENA_2_MASK 0x00000001                // SWCTL_CONN_SRCCLKENA_2[0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_WF_SWCTL_CONN_SRCCLKENA_2_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_1_WF (0x18001000 + 0x3B4)---

    XO_VCORE_RDY_STABLE_TIME_2[7..0] - (RW) xo_vcore_rdy_stable_time_2 for conn_srcclkena_2_ack valid
    XO_INI_STABLE_TIME_2[15..8]  - (RW) xo_ini_stable_time_2 for xo_ini stable
    XO_BG_STABLE_TIME_2[23..16]  - (RW) xo_bg_stable_time_2 for xo_bg stable
    XO_VCORE_OFF_STABLE_TIME_2[31..24] - (RW) xo_vcroe_off_stable_time_2 for conn_srcclkena_2_ack high to low

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_VCORE_OFF_STABLE_TIME_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_VCORE_OFF_STABLE_TIME_2_MASK 0xFF000000                // XO_VCORE_OFF_STABLE_TIME_2[31..24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_VCORE_OFF_STABLE_TIME_2_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_BG_STABLE_TIME_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_BG_STABLE_TIME_2_MASK 0x00FF0000                // XO_BG_STABLE_TIME_2[23..16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_BG_STABLE_TIME_2_SHFT 16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_INI_STABLE_TIME_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_INI_STABLE_TIME_2_MASK 0x0000FF00                // XO_INI_STABLE_TIME_2[15..8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_INI_STABLE_TIME_2_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_VCORE_RDY_STABLE_TIME_2_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_VCORE_RDY_STABLE_TIME_2_MASK 0x000000FF                // XO_VCORE_RDY_STABLE_TIME_2[7..0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_WF_XO_VCORE_RDY_STABLE_TIME_2_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_0_TOP (0x18001000 + 0x3C0)---

    SWCTL_CONN_SRCCLKENA_3[0]    - (RW) conn_srcclkena_3 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_DA_WBG_EN_BG_3[1]      - (RW) da_wbg_en_bg_3 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_DA_WBG_EN_XBUF_3[2]    - (RW) da_wbg_en_xbuf_3 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_VCORE_RDY_3[3]         - (RW) vcore_rdy_3 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    SWCTL_OSC_RDY_3[4]           - (RW) osc_rdy_3 control selection
                                     1'b0: hw control
                                     1'b1: sw control
    RC_TOP_RSV[7..5]             - (RW) reserved CR for RC_TOP
    SW_CONN_SRCCLKENA_3[8]       - (RW) sw control conn_srcclkena_3
    SW_DA_WBG_EN_BG_3[9]         - (RW) sw control da_wbg_en_bg_3
    SW_DA_WBG_EN_XBUF_3[10]      - (RW) sw control da_wbg_en_xbuf_3
    SW_VCORE_RDY_3[11]           - (RW) sw control vcore_rdy_3
    SW_OSC_RDY_3[12]             - (RW) sw control osc_rdy_3
    TOP_VCORE_RDY_EN_MASK[13]    - (RW) osc_on_ack conn_infra fake ack filter mask
                                     1'b0: osc_on_ack filter by conn_infra fake ack filter
                                     1'b1: osc_on_ack bypass conn_infra fake ack filter
    TOP_OSC_ON_ACK_EN_MASK[14]   - (RW) vcore_rdy conn_infra fake ack filter mask
                                     1'b0: vcore_rdy filter by conn_infra fake ack filter
                                     1'b1: vcore_rdy bypass conn_infra fake ack filter
    ACK_FOR_XO_STATE_MASK_3[15]  - (RW) mask conn_srcclkena_3_bblpm/fpm_ack for xo_state
                                     1'b0: check conn_srcclkena_3_bblpm/fpm_ack
                                     1'b1: mask conn_srcclkena_3_bblpm/fpm_ack
    XO_EN_3[16]                  - (RO)  xxx 
    XO_STATE_3[20..17]           - (RO)  xxx 
    HW_CONN_SRCCLKENA_3[21]      - (RO)  xxx 
    HW_VCORE_RDY_3[22]           - (RO)  xxx 
    HW_DA_WBG_EN_BG_3[23]        - (RO)  xxx 
    HW_DA_WBG_EN_XBUF_3[24]      - (RO)  xxx 
    HW_OSC_RDY_3[25]             - (RO)  xxx 
    TOP_OSC_ACK_BP_PWR_ACK[26]   - (RW) conn_infra_osc_on_ack Flip-Flop reset bypass conn_infra_off_active
                                     1'b0:  check conn_infra_off_active
                                     1'b1: bypass conn_infra_off_active
    TOP_OSC_ACK_BP_MEM_PON[27]   - (RW) conn_infra_osc_on_ack Flip-Flop reset bypass conn_infra_mem_rst_b
                                     1'b0:  check conn_infra_mem_rst_b
                                     1'b1: bypass conn_infra_mem_rst_b
    TOP_VCORE_FILTER_TIMEOUT[31..28] - (RW) conn_infra fake ack filter timeout value

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_VCORE_FILTER_TIMEOUT_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_VCORE_FILTER_TIMEOUT_MASK 0xF0000000                // TOP_VCORE_FILTER_TIMEOUT[31..28]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_VCORE_FILTER_TIMEOUT_SHFT 28
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ACK_BP_MEM_PON_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ACK_BP_MEM_PON_MASK 0x08000000                // TOP_OSC_ACK_BP_MEM_PON[27]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ACK_BP_MEM_PON_SHFT 27
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ACK_BP_PWR_ACK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ACK_BP_PWR_ACK_MASK 0x04000000                // TOP_OSC_ACK_BP_PWR_ACK[26]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ACK_BP_PWR_ACK_SHFT 26
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_OSC_RDY_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_OSC_RDY_3_MASK 0x02000000                // HW_OSC_RDY_3[25]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_OSC_RDY_3_SHFT 25
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_DA_WBG_EN_XBUF_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_DA_WBG_EN_XBUF_3_MASK 0x01000000                // HW_DA_WBG_EN_XBUF_3[24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_DA_WBG_EN_XBUF_3_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_DA_WBG_EN_BG_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_DA_WBG_EN_BG_3_MASK 0x00800000                // HW_DA_WBG_EN_BG_3[23]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_DA_WBG_EN_BG_3_SHFT 23
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_VCORE_RDY_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_VCORE_RDY_3_MASK 0x00400000                // HW_VCORE_RDY_3[22]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_VCORE_RDY_3_SHFT 22
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_CONN_SRCCLKENA_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_CONN_SRCCLKENA_3_MASK 0x00200000                // HW_CONN_SRCCLKENA_3[21]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_HW_CONN_SRCCLKENA_3_SHFT 21
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_XO_STATE_3_ADDR   CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_XO_STATE_3_MASK   0x001E0000                // XO_STATE_3[20..17]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_XO_STATE_3_SHFT   17
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_XO_EN_3_ADDR      CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_XO_EN_3_MASK      0x00010000                // XO_EN_3[16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_XO_EN_3_SHFT      16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ACK_FOR_XO_STATE_MASK_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ACK_FOR_XO_STATE_MASK_3_MASK 0x00008000                // ACK_FOR_XO_STATE_MASK_3[15]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ACK_FOR_XO_STATE_MASK_3_SHFT 15
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ON_ACK_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ON_ACK_EN_MASK_MASK 0x00004000                // TOP_OSC_ON_ACK_EN_MASK[14]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_OSC_ON_ACK_EN_MASK_SHFT 14
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_VCORE_RDY_EN_MASK_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_VCORE_RDY_EN_MASK_MASK 0x00002000                // TOP_VCORE_RDY_EN_MASK[13]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_TOP_VCORE_RDY_EN_MASK_SHFT 13
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_OSC_RDY_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_OSC_RDY_3_MASK 0x00001000                // SW_OSC_RDY_3[12]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_OSC_RDY_3_SHFT 12
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_VCORE_RDY_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_VCORE_RDY_3_MASK 0x00000800                // SW_VCORE_RDY_3[11]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_VCORE_RDY_3_SHFT 11
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_DA_WBG_EN_XBUF_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_DA_WBG_EN_XBUF_3_MASK 0x00000400                // SW_DA_WBG_EN_XBUF_3[10]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_DA_WBG_EN_XBUF_3_SHFT 10
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_DA_WBG_EN_BG_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_DA_WBG_EN_BG_3_MASK 0x00000200                // SW_DA_WBG_EN_BG_3[9]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_DA_WBG_EN_BG_3_SHFT 9
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_CONN_SRCCLKENA_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_CONN_SRCCLKENA_3_MASK 0x00000100                // SW_CONN_SRCCLKENA_3[8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SW_CONN_SRCCLKENA_3_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_RC_TOP_RSV_ADDR   CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_RC_TOP_RSV_MASK   0x000000E0                // RC_TOP_RSV[7..5]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_RC_TOP_RSV_SHFT   5
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_OSC_RDY_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_OSC_RDY_3_MASK 0x00000010                // SWCTL_OSC_RDY_3[4]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_OSC_RDY_3_SHFT 4
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_VCORE_RDY_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_VCORE_RDY_3_MASK 0x00000008                // SWCTL_VCORE_RDY_3[3]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_VCORE_RDY_3_SHFT 3
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_DA_WBG_EN_XBUF_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_DA_WBG_EN_XBUF_3_MASK 0x00000004                // SWCTL_DA_WBG_EN_XBUF_3[2]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_DA_WBG_EN_XBUF_3_SHFT 2
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_DA_WBG_EN_BG_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_DA_WBG_EN_BG_3_MASK 0x00000002                // SWCTL_DA_WBG_EN_BG_3[1]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_DA_WBG_EN_BG_3_SHFT 1
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_CONN_SRCCLKENA_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_CONN_SRCCLKENA_3_MASK 0x00000001                // SWCTL_CONN_SRCCLKENA_3[0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_0_TOP_SWCTL_CONN_SRCCLKENA_3_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CFG_RC_CTL_1_TOP (0x18001000 + 0x3C4)---

    XO_VCORE_RDY_STABLE_TIME_3[7..0] - (RW) xo_vcore_rdy_stable_time_3 for conn_srcclkena_3_ack valid
    XO_INI_STABLE_TIME_3[15..8]  - (RW) xo_ini_stable_time_3 for xo_ini stable
    XO_BG_STABLE_TIME_3[23..16]  - (RW) xo_bg_stable_time_3 for xo_bg stable
    XO_VCORE_OFF_STABLE_TIME_3[31..24] - (RW) xo_vcroe_off_stable_time_3 for conn_srcclkena_3_ack high to low

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_VCORE_OFF_STABLE_TIME_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_VCORE_OFF_STABLE_TIME_3_MASK 0xFF000000                // XO_VCORE_OFF_STABLE_TIME_3[31..24]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_VCORE_OFF_STABLE_TIME_3_SHFT 24
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_BG_STABLE_TIME_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_BG_STABLE_TIME_3_MASK 0x00FF0000                // XO_BG_STABLE_TIME_3[23..16]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_BG_STABLE_TIME_3_SHFT 16
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_INI_STABLE_TIME_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_INI_STABLE_TIME_3_MASK 0x0000FF00                // XO_INI_STABLE_TIME_3[15..8]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_INI_STABLE_TIME_3_SHFT 8
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_VCORE_RDY_STABLE_TIME_3_ADDR CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_ADDR
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_VCORE_RDY_STABLE_TIME_3_MASK 0x000000FF                // XO_VCORE_RDY_STABLE_TIME_3[7..0]
#define CONN_CFG_CONN_INFRA_CFG_RC_CTL_1_TOP_XO_VCORE_RDY_STABLE_TIME_3_SHFT 0

/* =====================================================================================

  ---EMI_CTL_0 (0x18001000 + 0x400)---

    CONN_EMI_RC_EN[0]            - (RW) conn_srcclkena control select
                                     1'b0: control by conn_infra_cfg
                                     1'b1: control by conn_infra_emi_ctl
    EMI_CONN2AP_BUS_SLPPROT_BYPASS[1] - (RW) bypass CONN2AP bus slpprotect rdy check 
                                     1'b0: emi control signal deassert after conn2ap_bus_slpprot_rdy = 1
                                     1'b1: emi control signal deassert don't need check conn2ap_bus_slpprot_rdy
    CONN2AP_EMI_REQ[2]           - (RO) conn2ap BUS request
    CONN2AP_EMI_ONLY_REQ[3]      - (RO) conn2emi BUS request
    DDR_CNT_LIMIT[14..4]         - (RW) counter limit for ddr_en auto timeout 
                                     set 0, ddr_en auto turn off function is disable
                                     set others: ddr_en is auto turn off when ddr_cnt is count to ddr_cnt_limit
    DDR_EN_CNT_UPDATE[15]        - (RW) counter limit for ddr_en timeout update signal
                                     1'b1: ddr_en timeout value = CR value(need set low after value has updated)
                                     1'b0: ddr_em timeout value don't update
    CONN_EMI_BT_ONLY_RC_EN[16]   - (RW) conn_srcclkena control select for conn_bt_only
                                     1'b0: control by conn_srcclkena_rc
                                     1'b1: control by (conn_infra_emi_ctl | conn_ingra_cfg)
    DDR_EN_BP_PROT[17]           - (RW) ddr_en sw control bypass cr_emi_req limitation
                                     1'b0: When cr_emi_req_xxx high , ddr_en can't be disable by sw control
                                     1'b1: When cr_emi_req_xxx high , ddr_en can be disable by sw control
    EMI_SLPPROT_BP_DDR_EN[18]    - (RW) sleep protect control bypass ddr_en
                                     1'b0: ddr_en_ack  = low  -> sleep protect enable
                                     1'b1: sleep protect control bypass ddr_en_ack status
    EMI_SLPPROT_BP_APSRC_REQ[19] - (RW) sleep protect control bypass apsrc_req
                                     1'b0:apsrc_ack = low  -> sleep protect enable
                                     1'b1: sleep protect control bypass apsrc_ack status
    INFRA_ONLY_MODE[20]          - (RW) emi_ctl infra only mode
                                     1'b0: conn2infra request will turn on emi
                                     1'b1: conn2infra request wiill only turon infra bus, emi keep power off
    EMI_CTL_DEBUG_1_SEL[22..21]  - (RW) conn_infra_emi_ctl_1 debug selection
    CONN_INFRA_OFF2ON_REQ_MASK[23] - (RW) conn_infra off2on req mask
                                     1'b0: unmask, conn_infra bus off2on request will trigger emi_ctl enable infra mtcmos
                                     1'b1: mask
    CONN_INFRA_OFF2ON_REQ[24]    - (RO) conn_infra off2on BUS request
    EMI_CTL_RSV_0[25]            - (RW) Reserved CR
    CR_PATH_SLP_PROT_DIS_BP[26]  - (RW) bypass check conn2ap cr path sleep protect disable
    EMI_PATH_SLP_PROT_DIS_BP[27] - (RW) bypass check conn2ap emi path sleep protect disable
    EMI_PATH_SLP_PROT_EN_BP[28]  - (RW) bypass check conn2ap emi path sleep protect enable
    EMI_CTL_RSV_1[31..29]        - (RW) Reserved CR

 =====================================================================================*/
#define CONN_CFG_EMI_CTL_0_EMI_CTL_RSV_1_ADDR                  CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_EMI_CTL_RSV_1_MASK                  0xE0000000                // EMI_CTL_RSV_1[31..29]
#define CONN_CFG_EMI_CTL_0_EMI_CTL_RSV_1_SHFT                  29
#define CONN_CFG_EMI_CTL_0_EMI_PATH_SLP_PROT_EN_BP_ADDR        CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_EMI_PATH_SLP_PROT_EN_BP_MASK        0x10000000                // EMI_PATH_SLP_PROT_EN_BP[28]
#define CONN_CFG_EMI_CTL_0_EMI_PATH_SLP_PROT_EN_BP_SHFT        28
#define CONN_CFG_EMI_CTL_0_EMI_PATH_SLP_PROT_DIS_BP_ADDR       CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_EMI_PATH_SLP_PROT_DIS_BP_MASK       0x08000000                // EMI_PATH_SLP_PROT_DIS_BP[27]
#define CONN_CFG_EMI_CTL_0_EMI_PATH_SLP_PROT_DIS_BP_SHFT       27
#define CONN_CFG_EMI_CTL_0_CR_PATH_SLP_PROT_DIS_BP_ADDR        CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_CR_PATH_SLP_PROT_DIS_BP_MASK        0x04000000                // CR_PATH_SLP_PROT_DIS_BP[26]
#define CONN_CFG_EMI_CTL_0_CR_PATH_SLP_PROT_DIS_BP_SHFT        26
#define CONN_CFG_EMI_CTL_0_EMI_CTL_RSV_0_ADDR                  CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_EMI_CTL_RSV_0_MASK                  0x02000000                // EMI_CTL_RSV_0[25]
#define CONN_CFG_EMI_CTL_0_EMI_CTL_RSV_0_SHFT                  25
#define CONN_CFG_EMI_CTL_0_CONN_INFRA_OFF2ON_REQ_ADDR          CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_CONN_INFRA_OFF2ON_REQ_MASK          0x01000000                // CONN_INFRA_OFF2ON_REQ[24]
#define CONN_CFG_EMI_CTL_0_CONN_INFRA_OFF2ON_REQ_SHFT          24
#define CONN_CFG_EMI_CTL_0_CONN_INFRA_OFF2ON_REQ_MASK_ADDR     CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_CONN_INFRA_OFF2ON_REQ_MASK_MASK     0x00800000                // CONN_INFRA_OFF2ON_REQ_MASK[23]
#define CONN_CFG_EMI_CTL_0_CONN_INFRA_OFF2ON_REQ_MASK_SHFT     23
#define CONN_CFG_EMI_CTL_0_EMI_CTL_DEBUG_1_SEL_ADDR            CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_EMI_CTL_DEBUG_1_SEL_MASK            0x00600000                // EMI_CTL_DEBUG_1_SEL[22..21]
#define CONN_CFG_EMI_CTL_0_EMI_CTL_DEBUG_1_SEL_SHFT            21
#define CONN_CFG_EMI_CTL_0_INFRA_ONLY_MODE_ADDR                CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_INFRA_ONLY_MODE_MASK                0x00100000                // INFRA_ONLY_MODE[20]
#define CONN_CFG_EMI_CTL_0_INFRA_ONLY_MODE_SHFT                20
#define CONN_CFG_EMI_CTL_0_EMI_SLPPROT_BP_APSRC_REQ_ADDR       CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_EMI_SLPPROT_BP_APSRC_REQ_MASK       0x00080000                // EMI_SLPPROT_BP_APSRC_REQ[19]
#define CONN_CFG_EMI_CTL_0_EMI_SLPPROT_BP_APSRC_REQ_SHFT       19
#define CONN_CFG_EMI_CTL_0_EMI_SLPPROT_BP_DDR_EN_ADDR          CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_EMI_SLPPROT_BP_DDR_EN_MASK          0x00040000                // EMI_SLPPROT_BP_DDR_EN[18]
#define CONN_CFG_EMI_CTL_0_EMI_SLPPROT_BP_DDR_EN_SHFT          18
#define CONN_CFG_EMI_CTL_0_DDR_EN_BP_PROT_ADDR                 CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_DDR_EN_BP_PROT_MASK                 0x00020000                // DDR_EN_BP_PROT[17]
#define CONN_CFG_EMI_CTL_0_DDR_EN_BP_PROT_SHFT                 17
#define CONN_CFG_EMI_CTL_0_CONN_EMI_BT_ONLY_RC_EN_ADDR         CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_CONN_EMI_BT_ONLY_RC_EN_MASK         0x00010000                // CONN_EMI_BT_ONLY_RC_EN[16]
#define CONN_CFG_EMI_CTL_0_CONN_EMI_BT_ONLY_RC_EN_SHFT         16
#define CONN_CFG_EMI_CTL_0_DDR_EN_CNT_UPDATE_ADDR              CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_DDR_EN_CNT_UPDATE_MASK              0x00008000                // DDR_EN_CNT_UPDATE[15]
#define CONN_CFG_EMI_CTL_0_DDR_EN_CNT_UPDATE_SHFT              15
#define CONN_CFG_EMI_CTL_0_DDR_CNT_LIMIT_ADDR                  CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_DDR_CNT_LIMIT_MASK                  0x00007FF0                // DDR_CNT_LIMIT[14..4]
#define CONN_CFG_EMI_CTL_0_DDR_CNT_LIMIT_SHFT                  4
#define CONN_CFG_EMI_CTL_0_CONN2AP_EMI_ONLY_REQ_ADDR           CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_CONN2AP_EMI_ONLY_REQ_MASK           0x00000008                // CONN2AP_EMI_ONLY_REQ[3]
#define CONN_CFG_EMI_CTL_0_CONN2AP_EMI_ONLY_REQ_SHFT           3
#define CONN_CFG_EMI_CTL_0_CONN2AP_EMI_REQ_ADDR                CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_CONN2AP_EMI_REQ_MASK                0x00000004                // CONN2AP_EMI_REQ[2]
#define CONN_CFG_EMI_CTL_0_CONN2AP_EMI_REQ_SHFT                2
#define CONN_CFG_EMI_CTL_0_EMI_CONN2AP_BUS_SLPPROT_BYPASS_ADDR CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_EMI_CONN2AP_BUS_SLPPROT_BYPASS_MASK 0x00000002                // EMI_CONN2AP_BUS_SLPPROT_BYPASS[1]
#define CONN_CFG_EMI_CTL_0_EMI_CONN2AP_BUS_SLPPROT_BYPASS_SHFT 1
#define CONN_CFG_EMI_CTL_0_CONN_EMI_RC_EN_ADDR                 CONN_CFG_EMI_CTL_0_ADDR
#define CONN_CFG_EMI_CTL_0_CONN_EMI_RC_EN_MASK                 0x00000001                // CONN_EMI_RC_EN[0]
#define CONN_CFG_EMI_CTL_0_CONN_EMI_RC_EN_SHFT                 0

/* =====================================================================================

  ---EMI_CTL_1 (0x18001000 + 0x404)---

    SRCCLKENA_PROT_EN[0]         - (RW) enable srcclkena protect for conn_ddr_en
    SRCCLKENA_ACK_BYPASS[1]      - (RW) bypass srcclkena_ack check for conn2ap bus sleep protect
    SRCCLKENA_ACK[2]             - (RO) srcclkena_ack
    SRCCLKENA_ACK_ERR[3]         - (RO) SRCCLKENA ACK error drop low when request is active
    SRCCLKENA_PROT_LIMIT[7..4]   - (RW) srcclkena prortect cycles to avoid using ack signal  after ddr_req is rising (unit xtal clock), because spm is under metastable
    AP_BUS_PROT_EN[8]            - (RW) enable ap_bus protect for conn_ddr_en
    AP_BUS_ACK_BYPASS[9]         - (RW) bypass ap_bus_ack check for conn2ap bus sleep protect
    AP_BUS_ACK[10]               - (RO) ap_bus_ack
    AP_BUS_ACK_ERR[11]           - (RO) AP_BUS_ACK error drop low when request is active
    AP_BUS_PROT_LIMIT[15..12]    - (RW) AP BUS prortect cycles to avoid using ack signal  after ddr_req is rising (unit xtal clock), because spm is under metastable
    APSRC_PROT_EN[16]            - (RW) enable ddr protect for apsrc_en
    APSRC_ACK_BYPASS[17]         - (RW) bypass apsrc_ack check for conn2ap bus sleep protect
    APSRC_ACK[18]                - (RO) apsrc_ack
    APSRC_ACK_ERR[19]            - (RO) APSRC ACK error drop low when request is active
    APSRC_PROT_LIMIT[23..20]     - (RW) APSRC prortect cycles to avoid using ack signal  after ddr_req is rising (unit xtal clock), because spm is under metastable
    DDR_PROT_EN[24]              - (RW) enable ddr protect for conn_ddr_en
    DDR_EN_ACK_BYPASS[25]        - (RW) bypass ddr_en_ack check for conn2ap bus sleep protect
    DDR_EN_ACK[26]               - (RO) ddr_en_ack
    DDR_EN_ACK_ERR[27]           - (RO) DDR ACK error drop low when request is active
    DDR_PROT_LIMIT[31..28]       - (RW) ddr prortect cycles to avoid using ack signal  after ddr_req is rising (unit xtal clock), because spm is under metastable

 =====================================================================================*/
#define CONN_CFG_EMI_CTL_1_DDR_PROT_LIMIT_ADDR                 CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_DDR_PROT_LIMIT_MASK                 0xF0000000                // DDR_PROT_LIMIT[31..28]
#define CONN_CFG_EMI_CTL_1_DDR_PROT_LIMIT_SHFT                 28
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_ERR_ADDR                 CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_ERR_MASK                 0x08000000                // DDR_EN_ACK_ERR[27]
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_ERR_SHFT                 27
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_ADDR                     CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_MASK                     0x04000000                // DDR_EN_ACK[26]
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_SHFT                     26
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_BYPASS_ADDR              CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_BYPASS_MASK              0x02000000                // DDR_EN_ACK_BYPASS[25]
#define CONN_CFG_EMI_CTL_1_DDR_EN_ACK_BYPASS_SHFT              25
#define CONN_CFG_EMI_CTL_1_DDR_PROT_EN_ADDR                    CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_DDR_PROT_EN_MASK                    0x01000000                // DDR_PROT_EN[24]
#define CONN_CFG_EMI_CTL_1_DDR_PROT_EN_SHFT                    24
#define CONN_CFG_EMI_CTL_1_APSRC_PROT_LIMIT_ADDR               CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_APSRC_PROT_LIMIT_MASK               0x00F00000                // APSRC_PROT_LIMIT[23..20]
#define CONN_CFG_EMI_CTL_1_APSRC_PROT_LIMIT_SHFT               20
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_ERR_ADDR                  CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_ERR_MASK                  0x00080000                // APSRC_ACK_ERR[19]
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_ERR_SHFT                  19
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_ADDR                      CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_MASK                      0x00040000                // APSRC_ACK[18]
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_SHFT                      18
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_BYPASS_ADDR               CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_BYPASS_MASK               0x00020000                // APSRC_ACK_BYPASS[17]
#define CONN_CFG_EMI_CTL_1_APSRC_ACK_BYPASS_SHFT               17
#define CONN_CFG_EMI_CTL_1_APSRC_PROT_EN_ADDR                  CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_APSRC_PROT_EN_MASK                  0x00010000                // APSRC_PROT_EN[16]
#define CONN_CFG_EMI_CTL_1_APSRC_PROT_EN_SHFT                  16
#define CONN_CFG_EMI_CTL_1_AP_BUS_PROT_LIMIT_ADDR              CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_AP_BUS_PROT_LIMIT_MASK              0x0000F000                // AP_BUS_PROT_LIMIT[15..12]
#define CONN_CFG_EMI_CTL_1_AP_BUS_PROT_LIMIT_SHFT              12
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_ERR_ADDR                 CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_ERR_MASK                 0x00000800                // AP_BUS_ACK_ERR[11]
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_ERR_SHFT                 11
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_ADDR                     CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_MASK                     0x00000400                // AP_BUS_ACK[10]
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_SHFT                     10
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_BYPASS_ADDR              CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_BYPASS_MASK              0x00000200                // AP_BUS_ACK_BYPASS[9]
#define CONN_CFG_EMI_CTL_1_AP_BUS_ACK_BYPASS_SHFT              9
#define CONN_CFG_EMI_CTL_1_AP_BUS_PROT_EN_ADDR                 CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_AP_BUS_PROT_EN_MASK                 0x00000100                // AP_BUS_PROT_EN[8]
#define CONN_CFG_EMI_CTL_1_AP_BUS_PROT_EN_SHFT                 8
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_PROT_LIMIT_ADDR           CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_PROT_LIMIT_MASK           0x000000F0                // SRCCLKENA_PROT_LIMIT[7..4]
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_PROT_LIMIT_SHFT           4
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_ERR_ADDR              CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_ERR_MASK              0x00000008                // SRCCLKENA_ACK_ERR[3]
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_ERR_SHFT              3
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_ADDR                  CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_MASK                  0x00000004                // SRCCLKENA_ACK[2]
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_SHFT                  2
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_BYPASS_ADDR           CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_BYPASS_MASK           0x00000002                // SRCCLKENA_ACK_BYPASS[1]
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_ACK_BYPASS_SHFT           1
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_PROT_EN_ADDR              CONN_CFG_EMI_CTL_1_ADDR
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_PROT_EN_MASK              0x00000001                // SRCCLKENA_PROT_EN[0]
#define CONN_CFG_EMI_CTL_1_SRCCLKENA_PROT_EN_SHFT              0

/* =====================================================================================

  ---EMI_CTL_TOP (0x18001000 + 0x410)---

    EMI_REQ_TOP[0]               - (RW) TOP emi request
                                     1'b1: need use EMI
                                     1'b0: don't need use EMI, and disable emi
    SW_CONN_SRCCLKENA_TOP[1]     - (RW) software srcclkena control by top
    SW_CONN_AP_BUS_REQ_TOP[2]    - (RW) software ap_bus_req control by top
    SW_CONN_APSRC_REQ_TOP[3]     - (RW) software apsrc_req control by top
    SW_CONN_DDR_EN_TOP[4]        - (RW) software ddr_en control by top
    INFRA_REQ_TOP[5]             - (RW) TOP infra request
                                     1'b1: need use INFRA
                                     1'b0: don't need use INFRA, and disable INFRA
    EMI_CTL_RSV_TOP[15..6]       - (RW) reserved CR
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_EMI_CTL_TOP_EMI_CTL_RSV_TOP_ADDR              CONN_CFG_EMI_CTL_TOP_ADDR
#define CONN_CFG_EMI_CTL_TOP_EMI_CTL_RSV_TOP_MASK              0x0000FFC0                // EMI_CTL_RSV_TOP[15..6]
#define CONN_CFG_EMI_CTL_TOP_EMI_CTL_RSV_TOP_SHFT              6
#define CONN_CFG_EMI_CTL_TOP_INFRA_REQ_TOP_ADDR                CONN_CFG_EMI_CTL_TOP_ADDR
#define CONN_CFG_EMI_CTL_TOP_INFRA_REQ_TOP_MASK                0x00000020                // INFRA_REQ_TOP[5]
#define CONN_CFG_EMI_CTL_TOP_INFRA_REQ_TOP_SHFT                5
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_DDR_EN_TOP_ADDR           CONN_CFG_EMI_CTL_TOP_ADDR
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_DDR_EN_TOP_MASK           0x00000010                // SW_CONN_DDR_EN_TOP[4]
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_DDR_EN_TOP_SHFT           4
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_APSRC_REQ_TOP_ADDR        CONN_CFG_EMI_CTL_TOP_ADDR
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_APSRC_REQ_TOP_MASK        0x00000008                // SW_CONN_APSRC_REQ_TOP[3]
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_APSRC_REQ_TOP_SHFT        3
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_AP_BUS_REQ_TOP_ADDR       CONN_CFG_EMI_CTL_TOP_ADDR
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_AP_BUS_REQ_TOP_MASK       0x00000004                // SW_CONN_AP_BUS_REQ_TOP[2]
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_AP_BUS_REQ_TOP_SHFT       2
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_SRCCLKENA_TOP_ADDR        CONN_CFG_EMI_CTL_TOP_ADDR
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_SRCCLKENA_TOP_MASK        0x00000002                // SW_CONN_SRCCLKENA_TOP[1]
#define CONN_CFG_EMI_CTL_TOP_SW_CONN_SRCCLKENA_TOP_SHFT        1
#define CONN_CFG_EMI_CTL_TOP_EMI_REQ_TOP_ADDR                  CONN_CFG_EMI_CTL_TOP_ADDR
#define CONN_CFG_EMI_CTL_TOP_EMI_REQ_TOP_MASK                  0x00000001                // EMI_REQ_TOP[0]
#define CONN_CFG_EMI_CTL_TOP_EMI_REQ_TOP_SHFT                  0

/* =====================================================================================

  ---EMI_CTL_WF (0x18001000 + 0x414)---

    EMI_REQ_WF[0]                - (RW) wf emi request
                                     1'b1: need use EMI
                                     1'b0: don't need use EMI, and disable emi
    SW_CONN_SRCCLKENA_WF[1]      - (RW) software srcclkena control by wf
    SW_CONN_AP_BUS_REQ_WF[2]     - (RW) software ap_bus_req control by wf
    SW_CONN_APSRC_REQ_WF[3]      - (RW) software apsrc_req control by wf
    SW_CONN_DDR_EN_WF[4]         - (RW) software ddr_en control by wf
    INFRA_REQ_WF[5]              - (RW) WF infra request
                                     1'b1: need use INFRA
                                     1'b0: don't need use INFRA, and disable INFRA
    EMI_CTL_RSV_WF[15..6]        - (RW) reserved CR
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_EMI_CTL_WF_EMI_CTL_RSV_WF_ADDR                CONN_CFG_EMI_CTL_WF_ADDR
#define CONN_CFG_EMI_CTL_WF_EMI_CTL_RSV_WF_MASK                0x0000FFC0                // EMI_CTL_RSV_WF[15..6]
#define CONN_CFG_EMI_CTL_WF_EMI_CTL_RSV_WF_SHFT                6
#define CONN_CFG_EMI_CTL_WF_INFRA_REQ_WF_ADDR                  CONN_CFG_EMI_CTL_WF_ADDR
#define CONN_CFG_EMI_CTL_WF_INFRA_REQ_WF_MASK                  0x00000020                // INFRA_REQ_WF[5]
#define CONN_CFG_EMI_CTL_WF_INFRA_REQ_WF_SHFT                  5
#define CONN_CFG_EMI_CTL_WF_SW_CONN_DDR_EN_WF_ADDR             CONN_CFG_EMI_CTL_WF_ADDR
#define CONN_CFG_EMI_CTL_WF_SW_CONN_DDR_EN_WF_MASK             0x00000010                // SW_CONN_DDR_EN_WF[4]
#define CONN_CFG_EMI_CTL_WF_SW_CONN_DDR_EN_WF_SHFT             4
#define CONN_CFG_EMI_CTL_WF_SW_CONN_APSRC_REQ_WF_ADDR          CONN_CFG_EMI_CTL_WF_ADDR
#define CONN_CFG_EMI_CTL_WF_SW_CONN_APSRC_REQ_WF_MASK          0x00000008                // SW_CONN_APSRC_REQ_WF[3]
#define CONN_CFG_EMI_CTL_WF_SW_CONN_APSRC_REQ_WF_SHFT          3
#define CONN_CFG_EMI_CTL_WF_SW_CONN_AP_BUS_REQ_WF_ADDR         CONN_CFG_EMI_CTL_WF_ADDR
#define CONN_CFG_EMI_CTL_WF_SW_CONN_AP_BUS_REQ_WF_MASK         0x00000004                // SW_CONN_AP_BUS_REQ_WF[2]
#define CONN_CFG_EMI_CTL_WF_SW_CONN_AP_BUS_REQ_WF_SHFT         2
#define CONN_CFG_EMI_CTL_WF_SW_CONN_SRCCLKENA_WF_ADDR          CONN_CFG_EMI_CTL_WF_ADDR
#define CONN_CFG_EMI_CTL_WF_SW_CONN_SRCCLKENA_WF_MASK          0x00000002                // SW_CONN_SRCCLKENA_WF[1]
#define CONN_CFG_EMI_CTL_WF_SW_CONN_SRCCLKENA_WF_SHFT          1
#define CONN_CFG_EMI_CTL_WF_EMI_REQ_WF_ADDR                    CONN_CFG_EMI_CTL_WF_ADDR
#define CONN_CFG_EMI_CTL_WF_EMI_REQ_WF_MASK                    0x00000001                // EMI_REQ_WF[0]
#define CONN_CFG_EMI_CTL_WF_EMI_REQ_WF_SHFT                    0

/* =====================================================================================

  ---EMI_CTL_BT (0x18001000 + 0x418)---

    EMI_REQ_BT[0]                - (RW) bt emi request
                                     1'b1: need use EMI
                                     1'b0: don't need use EMI, and disable emi
    SW_CONN_SRCCLKENA_BT[1]      - (RW) software srcclkena control by bt
    SW_CONN_AP_BUS_REQ_BT[2]     - (RW) software ap_bus_req control by bt
    SW_CONN_APSRC_REQ_BT[3]      - (RW) software apsrc_req control by bt
    SW_CONN_DDR_EN_BT[4]         - (RW) software ddr_en control by bt
    INFRA_REQ_BT[5]              - (RW) BT infra request
                                     1'b1: need use INFRA
                                     1'b0: don't need use INFRA, and disable INFRA
    EMI_CTL_RSV_BT[15..6]        - (RW) reserved CR
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_EMI_CTL_BT_EMI_CTL_RSV_BT_ADDR                CONN_CFG_EMI_CTL_BT_ADDR
#define CONN_CFG_EMI_CTL_BT_EMI_CTL_RSV_BT_MASK                0x0000FFC0                // EMI_CTL_RSV_BT[15..6]
#define CONN_CFG_EMI_CTL_BT_EMI_CTL_RSV_BT_SHFT                6
#define CONN_CFG_EMI_CTL_BT_INFRA_REQ_BT_ADDR                  CONN_CFG_EMI_CTL_BT_ADDR
#define CONN_CFG_EMI_CTL_BT_INFRA_REQ_BT_MASK                  0x00000020                // INFRA_REQ_BT[5]
#define CONN_CFG_EMI_CTL_BT_INFRA_REQ_BT_SHFT                  5
#define CONN_CFG_EMI_CTL_BT_SW_CONN_DDR_EN_BT_ADDR             CONN_CFG_EMI_CTL_BT_ADDR
#define CONN_CFG_EMI_CTL_BT_SW_CONN_DDR_EN_BT_MASK             0x00000010                // SW_CONN_DDR_EN_BT[4]
#define CONN_CFG_EMI_CTL_BT_SW_CONN_DDR_EN_BT_SHFT             4
#define CONN_CFG_EMI_CTL_BT_SW_CONN_APSRC_REQ_BT_ADDR          CONN_CFG_EMI_CTL_BT_ADDR
#define CONN_CFG_EMI_CTL_BT_SW_CONN_APSRC_REQ_BT_MASK          0x00000008                // SW_CONN_APSRC_REQ_BT[3]
#define CONN_CFG_EMI_CTL_BT_SW_CONN_APSRC_REQ_BT_SHFT          3
#define CONN_CFG_EMI_CTL_BT_SW_CONN_AP_BUS_REQ_BT_ADDR         CONN_CFG_EMI_CTL_BT_ADDR
#define CONN_CFG_EMI_CTL_BT_SW_CONN_AP_BUS_REQ_BT_MASK         0x00000004                // SW_CONN_AP_BUS_REQ_BT[2]
#define CONN_CFG_EMI_CTL_BT_SW_CONN_AP_BUS_REQ_BT_SHFT         2
#define CONN_CFG_EMI_CTL_BT_SW_CONN_SRCCLKENA_BT_ADDR          CONN_CFG_EMI_CTL_BT_ADDR
#define CONN_CFG_EMI_CTL_BT_SW_CONN_SRCCLKENA_BT_MASK          0x00000002                // SW_CONN_SRCCLKENA_BT[1]
#define CONN_CFG_EMI_CTL_BT_SW_CONN_SRCCLKENA_BT_SHFT          1
#define CONN_CFG_EMI_CTL_BT_EMI_REQ_BT_ADDR                    CONN_CFG_EMI_CTL_BT_ADDR
#define CONN_CFG_EMI_CTL_BT_EMI_REQ_BT_MASK                    0x00000001                // EMI_REQ_BT[0]
#define CONN_CFG_EMI_CTL_BT_EMI_REQ_BT_SHFT                    0

/* =====================================================================================

  ---EMI_CTL_GPS (0x18001000 + 0x41C)---

    EMI_REQ_GPS[0]               - (RW) gps emi request
                                     1'b1: need use EMI
                                     1'b0: don't need use EMI, and disable emi
    SW_CONN_SRCCLKENA_GPS[1]     - (RW) software srcclkena control by gps
    SW_CONN_AP_BUS_REQ_GPS[2]    - (RW) software ap_bus_req control by gps
    SW_CONN_APSRC_REQ_GPS[3]     - (RW) software apsrc_req control by gps
    SW_CONN_DDR_EN_GPS[4]        - (RW) software ddr_en control by gps
    INFRA_REQ_GPS[5]             - (RW) GPS infra request
                                     1'b1: need use INFRA
                                     1'b0: don't need use INFRA, and disable INFRA
    EMI_CTL_RSV_GPS[15..6]       - (RW) reserved CR
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_EMI_CTL_GPS_EMI_CTL_RSV_GPS_ADDR              CONN_CFG_EMI_CTL_GPS_ADDR
#define CONN_CFG_EMI_CTL_GPS_EMI_CTL_RSV_GPS_MASK              0x0000FFC0                // EMI_CTL_RSV_GPS[15..6]
#define CONN_CFG_EMI_CTL_GPS_EMI_CTL_RSV_GPS_SHFT              6
#define CONN_CFG_EMI_CTL_GPS_INFRA_REQ_GPS_ADDR                CONN_CFG_EMI_CTL_GPS_ADDR
#define CONN_CFG_EMI_CTL_GPS_INFRA_REQ_GPS_MASK                0x00000020                // INFRA_REQ_GPS[5]
#define CONN_CFG_EMI_CTL_GPS_INFRA_REQ_GPS_SHFT                5
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_DDR_EN_GPS_ADDR           CONN_CFG_EMI_CTL_GPS_ADDR
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_DDR_EN_GPS_MASK           0x00000010                // SW_CONN_DDR_EN_GPS[4]
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_DDR_EN_GPS_SHFT           4
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_APSRC_REQ_GPS_ADDR        CONN_CFG_EMI_CTL_GPS_ADDR
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_APSRC_REQ_GPS_MASK        0x00000008                // SW_CONN_APSRC_REQ_GPS[3]
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_APSRC_REQ_GPS_SHFT        3
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_AP_BUS_REQ_GPS_ADDR       CONN_CFG_EMI_CTL_GPS_ADDR
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_AP_BUS_REQ_GPS_MASK       0x00000004                // SW_CONN_AP_BUS_REQ_GPS[2]
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_AP_BUS_REQ_GPS_SHFT       2
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_SRCCLKENA_GPS_ADDR        CONN_CFG_EMI_CTL_GPS_ADDR
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_SRCCLKENA_GPS_MASK        0x00000002                // SW_CONN_SRCCLKENA_GPS[1]
#define CONN_CFG_EMI_CTL_GPS_SW_CONN_SRCCLKENA_GPS_SHFT        1
#define CONN_CFG_EMI_CTL_GPS_EMI_REQ_GPS_ADDR                  CONN_CFG_EMI_CTL_GPS_ADDR
#define CONN_CFG_EMI_CTL_GPS_EMI_REQ_GPS_MASK                  0x00000001                // EMI_REQ_GPS[0]
#define CONN_CFG_EMI_CTL_GPS_EMI_REQ_GPS_SHFT                  0

/* =====================================================================================

  ---EMI_CTL_GPS_L1 (0x18001000 + 0X420)---

    EMI_REQ_GPS_L1[0]            - (RW) GPS_L1 emi request
                                     1'b1: need use EMI
                                     1'b0: don't need use EMI, and disable emi
    SW_CONN_SRCCLKENA_GPS_L1[1]  - (RW) software srcclkena control by GPS_L1
    SW_CONN_AP_BUS_REQ_GPS_L1[2] - (RW) software ap_bus_req control by GPS_L1
    SW_CONN_APSRC_REQ_GPS_L1[3]  - (RW) software apsrc_req control by GPS_L1
    SW_CONN_DDR_EN_GPS_L1[4]     - (RW) software ddr_en control by GPS_L1
    INFRA_REQ_GPS_L1[5]          - (RW) GPS_L1 infra request
                                     1'b1: need use INFRA
                                     1'b0: don't need use INFRA, and disable INFRA
    EMI_CTL_RSV_GPS_L1[15..6]    - (RW) reserved CR
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_EMI_CTL_GPS_L1_EMI_CTL_RSV_GPS_L1_ADDR        CONN_CFG_EMI_CTL_GPS_L1_ADDR
#define CONN_CFG_EMI_CTL_GPS_L1_EMI_CTL_RSV_GPS_L1_MASK        0x0000FFC0                // EMI_CTL_RSV_GPS_L1[15..6]
#define CONN_CFG_EMI_CTL_GPS_L1_EMI_CTL_RSV_GPS_L1_SHFT        6
#define CONN_CFG_EMI_CTL_GPS_L1_INFRA_REQ_GPS_L1_ADDR          CONN_CFG_EMI_CTL_GPS_L1_ADDR
#define CONN_CFG_EMI_CTL_GPS_L1_INFRA_REQ_GPS_L1_MASK          0x00000020                // INFRA_REQ_GPS_L1[5]
#define CONN_CFG_EMI_CTL_GPS_L1_INFRA_REQ_GPS_L1_SHFT          5
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_DDR_EN_GPS_L1_ADDR     CONN_CFG_EMI_CTL_GPS_L1_ADDR
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_DDR_EN_GPS_L1_MASK     0x00000010                // SW_CONN_DDR_EN_GPS_L1[4]
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_DDR_EN_GPS_L1_SHFT     4
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_APSRC_REQ_GPS_L1_ADDR  CONN_CFG_EMI_CTL_GPS_L1_ADDR
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_APSRC_REQ_GPS_L1_MASK  0x00000008                // SW_CONN_APSRC_REQ_GPS_L1[3]
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_APSRC_REQ_GPS_L1_SHFT  3
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_AP_BUS_REQ_GPS_L1_ADDR CONN_CFG_EMI_CTL_GPS_L1_ADDR
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_AP_BUS_REQ_GPS_L1_MASK 0x00000004                // SW_CONN_AP_BUS_REQ_GPS_L1[2]
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_AP_BUS_REQ_GPS_L1_SHFT 2
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_SRCCLKENA_GPS_L1_ADDR  CONN_CFG_EMI_CTL_GPS_L1_ADDR
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_SRCCLKENA_GPS_L1_MASK  0x00000002                // SW_CONN_SRCCLKENA_GPS_L1[1]
#define CONN_CFG_EMI_CTL_GPS_L1_SW_CONN_SRCCLKENA_GPS_L1_SHFT  1
#define CONN_CFG_EMI_CTL_GPS_L1_EMI_REQ_GPS_L1_ADDR            CONN_CFG_EMI_CTL_GPS_L1_ADDR
#define CONN_CFG_EMI_CTL_GPS_L1_EMI_REQ_GPS_L1_MASK            0x00000001                // EMI_REQ_GPS_L1[0]
#define CONN_CFG_EMI_CTL_GPS_L1_EMI_REQ_GPS_L1_SHFT            0

/* =====================================================================================

  ---EMI_CTL_GPS_L5 (0x18001000 + 0X424)---

    EMI_REQ_GPS_L5[0]            - (RW) GPS_L5 emi request
                                     1'b1: need use EMI
                                     1'b0: don't need use EMI, and disable emi
    SW_CONN_SRCCLKENA_GPS_L5[1]  - (RW) software srcclkena control by GPS_L5
    SW_CONN_AP_BUS_REQ_GPS_L5[2] - (RW) software ap_bus_req control by GPS_L5
    SW_CONN_APSRC_REQ_GPS_L5[3]  - (RW) software apsrc_req control by GPS_L5
    SW_CONN_DDR_EN_GPS_L5[4]     - (RW) software ddr_en control by GPS_L5
    INFRA_REQ_GPS_L5[5]          - (RW) GPS_L5 infra request
                                     1'b1: need use INFRA
                                     1'b0: don't need use INFRA, and disable INFRA
    EMI_CTL_RSV_GPS_L5[15..6]    - (RW) reserved CR
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_EMI_CTL_GPS_L5_EMI_CTL_RSV_GPS_L5_ADDR        CONN_CFG_EMI_CTL_GPS_L5_ADDR
#define CONN_CFG_EMI_CTL_GPS_L5_EMI_CTL_RSV_GPS_L5_MASK        0x0000FFC0                // EMI_CTL_RSV_GPS_L5[15..6]
#define CONN_CFG_EMI_CTL_GPS_L5_EMI_CTL_RSV_GPS_L5_SHFT        6
#define CONN_CFG_EMI_CTL_GPS_L5_INFRA_REQ_GPS_L5_ADDR          CONN_CFG_EMI_CTL_GPS_L5_ADDR
#define CONN_CFG_EMI_CTL_GPS_L5_INFRA_REQ_GPS_L5_MASK          0x00000020                // INFRA_REQ_GPS_L5[5]
#define CONN_CFG_EMI_CTL_GPS_L5_INFRA_REQ_GPS_L5_SHFT          5
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_DDR_EN_GPS_L5_ADDR     CONN_CFG_EMI_CTL_GPS_L5_ADDR
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_DDR_EN_GPS_L5_MASK     0x00000010                // SW_CONN_DDR_EN_GPS_L5[4]
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_DDR_EN_GPS_L5_SHFT     4
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_APSRC_REQ_GPS_L5_ADDR  CONN_CFG_EMI_CTL_GPS_L5_ADDR
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_APSRC_REQ_GPS_L5_MASK  0x00000008                // SW_CONN_APSRC_REQ_GPS_L5[3]
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_APSRC_REQ_GPS_L5_SHFT  3
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_AP_BUS_REQ_GPS_L5_ADDR CONN_CFG_EMI_CTL_GPS_L5_ADDR
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_AP_BUS_REQ_GPS_L5_MASK 0x00000004                // SW_CONN_AP_BUS_REQ_GPS_L5[2]
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_AP_BUS_REQ_GPS_L5_SHFT 2
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_SRCCLKENA_GPS_L5_ADDR  CONN_CFG_EMI_CTL_GPS_L5_ADDR
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_SRCCLKENA_GPS_L5_MASK  0x00000002                // SW_CONN_SRCCLKENA_GPS_L5[1]
#define CONN_CFG_EMI_CTL_GPS_L5_SW_CONN_SRCCLKENA_GPS_L5_SHFT  1
#define CONN_CFG_EMI_CTL_GPS_L5_EMI_REQ_GPS_L5_ADDR            CONN_CFG_EMI_CTL_GPS_L5_ADDR
#define CONN_CFG_EMI_CTL_GPS_L5_EMI_REQ_GPS_L5_MASK            0x00000001                // EMI_REQ_GPS_L5[0]
#define CONN_CFG_EMI_CTL_GPS_L5_EMI_REQ_GPS_L5_SHFT            0

/* =====================================================================================

  ---EMI_PROBE (0x18001000 + 0x480)---

    CONN_SRCCCLKENA[0]           - (RO)  xxx 
    CONN_AP_BUS[1]               - (RO)  xxx 
    CONN_APSRC[2]                - (RO)  xxx 
    CONN_DDR_EN[3]               - (RO)  xxx 
    CONN_SRCCCLKENA_ACK[4]       - (RO)  xxx 
    CONN_AP_BUS_ACK[5]           - (RO)  xxx 
    CONN_APSRC_ACK[6]            - (RO)  xxx 
    CONN_DDR_EN_ACK[7]           - (RO)  xxx 
    SRCCLKENA_ACK_SYNC[8]        - (RO)  xxx 
    AP_BUS_ACK_SYNC[9]           - (RO)  xxx 
    APSRC_ACK_SYNC[10]           - (RO)  xxx 
    DDR_EN_ACK_SYNC[11]          - (RO)  xxx 
    CONN2AP_BUS_IDLE[12]         - (RO)  xxx 
    CONN2AP_EMI_REQ[13]          - (RO)  xxx 
    CONN2AP_BUS_SLPPORT_RDY[14]  - (RO)  xxx 
    CONN2AP_BUS_SLPPROT_EN[15]   - (RO)  xxx 
    SRCCLKENA_STABLE_REG[16]     - (RO)  xxx 
    APSRC_STABLE_REG[17]         - (RO)  xxx 
    AP_BUS_STABLE_REG[18]        - (RO)  xxx 
    DDR_EN_STABLE_REG[19]        - (RO)  xxx 
    SRCCLKENA_STABLE[20]         - (RO)  xxx 
    APSRC_STABLE[21]             - (RO)  xxx 
    AP_BUS_STABLE[22]            - (RO)  xxx 
    DDR_EN_STABLE[23]            - (RO)  xxx 
    EMI_REQ_ALL[24]              - (RO)  xxx 
    EMI_REQ_DIS[25]              - (RO)  xxx 
    DDR_TIMEOUT[26]              - (RO)  xxx 
    CONN_SRCCLKENA_PRE[27]       - (RO)  xxx 
    HW_CONN_SRCCLKENA_EMI_DIS[28] - (RO)  xxx 
    HW_CONN_AP_BUS_REQ_DIS[29]   - (RO)  xxx 
    HW_CONN_APSRC_REQ_DIS[30]    - (RO)  xxx 
    HW_CONN_DDR_EN_DIS[31]       - (RO)  xxx 

 =====================================================================================*/
#define CONN_CFG_EMI_PROBE_HW_CONN_DDR_EN_DIS_ADDR             CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_HW_CONN_DDR_EN_DIS_MASK             0x80000000                // HW_CONN_DDR_EN_DIS[31]
#define CONN_CFG_EMI_PROBE_HW_CONN_DDR_EN_DIS_SHFT             31
#define CONN_CFG_EMI_PROBE_HW_CONN_APSRC_REQ_DIS_ADDR          CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_HW_CONN_APSRC_REQ_DIS_MASK          0x40000000                // HW_CONN_APSRC_REQ_DIS[30]
#define CONN_CFG_EMI_PROBE_HW_CONN_APSRC_REQ_DIS_SHFT          30
#define CONN_CFG_EMI_PROBE_HW_CONN_AP_BUS_REQ_DIS_ADDR         CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_HW_CONN_AP_BUS_REQ_DIS_MASK         0x20000000                // HW_CONN_AP_BUS_REQ_DIS[29]
#define CONN_CFG_EMI_PROBE_HW_CONN_AP_BUS_REQ_DIS_SHFT         29
#define CONN_CFG_EMI_PROBE_HW_CONN_SRCCLKENA_EMI_DIS_ADDR      CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_HW_CONN_SRCCLKENA_EMI_DIS_MASK      0x10000000                // HW_CONN_SRCCLKENA_EMI_DIS[28]
#define CONN_CFG_EMI_PROBE_HW_CONN_SRCCLKENA_EMI_DIS_SHFT      28
#define CONN_CFG_EMI_PROBE_CONN_SRCCLKENA_PRE_ADDR             CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_SRCCLKENA_PRE_MASK             0x08000000                // CONN_SRCCLKENA_PRE[27]
#define CONN_CFG_EMI_PROBE_CONN_SRCCLKENA_PRE_SHFT             27
#define CONN_CFG_EMI_PROBE_DDR_TIMEOUT_ADDR                    CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_DDR_TIMEOUT_MASK                    0x04000000                // DDR_TIMEOUT[26]
#define CONN_CFG_EMI_PROBE_DDR_TIMEOUT_SHFT                    26
#define CONN_CFG_EMI_PROBE_EMI_REQ_DIS_ADDR                    CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_EMI_REQ_DIS_MASK                    0x02000000                // EMI_REQ_DIS[25]
#define CONN_CFG_EMI_PROBE_EMI_REQ_DIS_SHFT                    25
#define CONN_CFG_EMI_PROBE_EMI_REQ_ALL_ADDR                    CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_EMI_REQ_ALL_MASK                    0x01000000                // EMI_REQ_ALL[24]
#define CONN_CFG_EMI_PROBE_EMI_REQ_ALL_SHFT                    24
#define CONN_CFG_EMI_PROBE_DDR_EN_STABLE_ADDR                  CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_DDR_EN_STABLE_MASK                  0x00800000                // DDR_EN_STABLE[23]
#define CONN_CFG_EMI_PROBE_DDR_EN_STABLE_SHFT                  23
#define CONN_CFG_EMI_PROBE_AP_BUS_STABLE_ADDR                  CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_AP_BUS_STABLE_MASK                  0x00400000                // AP_BUS_STABLE[22]
#define CONN_CFG_EMI_PROBE_AP_BUS_STABLE_SHFT                  22
#define CONN_CFG_EMI_PROBE_APSRC_STABLE_ADDR                   CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_APSRC_STABLE_MASK                   0x00200000                // APSRC_STABLE[21]
#define CONN_CFG_EMI_PROBE_APSRC_STABLE_SHFT                   21
#define CONN_CFG_EMI_PROBE_SRCCLKENA_STABLE_ADDR               CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_SRCCLKENA_STABLE_MASK               0x00100000                // SRCCLKENA_STABLE[20]
#define CONN_CFG_EMI_PROBE_SRCCLKENA_STABLE_SHFT               20
#define CONN_CFG_EMI_PROBE_DDR_EN_STABLE_REG_ADDR              CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_DDR_EN_STABLE_REG_MASK              0x00080000                // DDR_EN_STABLE_REG[19]
#define CONN_CFG_EMI_PROBE_DDR_EN_STABLE_REG_SHFT              19
#define CONN_CFG_EMI_PROBE_AP_BUS_STABLE_REG_ADDR              CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_AP_BUS_STABLE_REG_MASK              0x00040000                // AP_BUS_STABLE_REG[18]
#define CONN_CFG_EMI_PROBE_AP_BUS_STABLE_REG_SHFT              18
#define CONN_CFG_EMI_PROBE_APSRC_STABLE_REG_ADDR               CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_APSRC_STABLE_REG_MASK               0x00020000                // APSRC_STABLE_REG[17]
#define CONN_CFG_EMI_PROBE_APSRC_STABLE_REG_SHFT               17
#define CONN_CFG_EMI_PROBE_SRCCLKENA_STABLE_REG_ADDR           CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_SRCCLKENA_STABLE_REG_MASK           0x00010000                // SRCCLKENA_STABLE_REG[16]
#define CONN_CFG_EMI_PROBE_SRCCLKENA_STABLE_REG_SHFT           16
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_SLPPROT_EN_ADDR         CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_SLPPROT_EN_MASK         0x00008000                // CONN2AP_BUS_SLPPROT_EN[15]
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_SLPPROT_EN_SHFT         15
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_SLPPORT_RDY_ADDR        CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_SLPPORT_RDY_MASK        0x00004000                // CONN2AP_BUS_SLPPORT_RDY[14]
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_SLPPORT_RDY_SHFT        14
#define CONN_CFG_EMI_PROBE_CONN2AP_EMI_REQ_ADDR                CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN2AP_EMI_REQ_MASK                0x00002000                // CONN2AP_EMI_REQ[13]
#define CONN_CFG_EMI_PROBE_CONN2AP_EMI_REQ_SHFT                13
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_IDLE_ADDR               CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_IDLE_MASK               0x00001000                // CONN2AP_BUS_IDLE[12]
#define CONN_CFG_EMI_PROBE_CONN2AP_BUS_IDLE_SHFT               12
#define CONN_CFG_EMI_PROBE_DDR_EN_ACK_SYNC_ADDR                CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_DDR_EN_ACK_SYNC_MASK                0x00000800                // DDR_EN_ACK_SYNC[11]
#define CONN_CFG_EMI_PROBE_DDR_EN_ACK_SYNC_SHFT                11
#define CONN_CFG_EMI_PROBE_APSRC_ACK_SYNC_ADDR                 CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_APSRC_ACK_SYNC_MASK                 0x00000400                // APSRC_ACK_SYNC[10]
#define CONN_CFG_EMI_PROBE_APSRC_ACK_SYNC_SHFT                 10
#define CONN_CFG_EMI_PROBE_AP_BUS_ACK_SYNC_ADDR                CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_AP_BUS_ACK_SYNC_MASK                0x00000200                // AP_BUS_ACK_SYNC[9]
#define CONN_CFG_EMI_PROBE_AP_BUS_ACK_SYNC_SHFT                9
#define CONN_CFG_EMI_PROBE_SRCCLKENA_ACK_SYNC_ADDR             CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_SRCCLKENA_ACK_SYNC_MASK             0x00000100                // SRCCLKENA_ACK_SYNC[8]
#define CONN_CFG_EMI_PROBE_SRCCLKENA_ACK_SYNC_SHFT             8
#define CONN_CFG_EMI_PROBE_CONN_DDR_EN_ACK_ADDR                CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_DDR_EN_ACK_MASK                0x00000080                // CONN_DDR_EN_ACK[7]
#define CONN_CFG_EMI_PROBE_CONN_DDR_EN_ACK_SHFT                7
#define CONN_CFG_EMI_PROBE_CONN_APSRC_ACK_ADDR                 CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_APSRC_ACK_MASK                 0x00000040                // CONN_APSRC_ACK[6]
#define CONN_CFG_EMI_PROBE_CONN_APSRC_ACK_SHFT                 6
#define CONN_CFG_EMI_PROBE_CONN_AP_BUS_ACK_ADDR                CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_AP_BUS_ACK_MASK                0x00000020                // CONN_AP_BUS_ACK[5]
#define CONN_CFG_EMI_PROBE_CONN_AP_BUS_ACK_SHFT                5
#define CONN_CFG_EMI_PROBE_CONN_SRCCCLKENA_ACK_ADDR            CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_SRCCCLKENA_ACK_MASK            0x00000010                // CONN_SRCCCLKENA_ACK[4]
#define CONN_CFG_EMI_PROBE_CONN_SRCCCLKENA_ACK_SHFT            4
#define CONN_CFG_EMI_PROBE_CONN_DDR_EN_ADDR                    CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_DDR_EN_MASK                    0x00000008                // CONN_DDR_EN[3]
#define CONN_CFG_EMI_PROBE_CONN_DDR_EN_SHFT                    3
#define CONN_CFG_EMI_PROBE_CONN_APSRC_ADDR                     CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_APSRC_MASK                     0x00000004                // CONN_APSRC[2]
#define CONN_CFG_EMI_PROBE_CONN_APSRC_SHFT                     2
#define CONN_CFG_EMI_PROBE_CONN_AP_BUS_ADDR                    CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_AP_BUS_MASK                    0x00000002                // CONN_AP_BUS[1]
#define CONN_CFG_EMI_PROBE_CONN_AP_BUS_SHFT                    1
#define CONN_CFG_EMI_PROBE_CONN_SRCCCLKENA_ADDR                CONN_CFG_EMI_PROBE_ADDR
#define CONN_CFG_EMI_PROBE_CONN_SRCCCLKENA_MASK                0x00000001                // CONN_SRCCCLKENA[0]
#define CONN_CFG_EMI_PROBE_CONN_SRCCCLKENA_SHFT                0

/* =====================================================================================

  ---EMI_PROBE_1 (0x18001000 + 0x484)---

    EMI_PROBE_1[31..0]           - (RO)  xxx 

 =====================================================================================*/
#define CONN_CFG_EMI_PROBE_1_EMI_PROBE_1_ADDR                  CONN_CFG_EMI_PROBE_1_ADDR
#define CONN_CFG_EMI_PROBE_1_EMI_PROBE_1_MASK                  0xFFFFFFFF                // EMI_PROBE_1[31..0]
#define CONN_CFG_EMI_PROBE_1_EMI_PROBE_1_SHFT                  0

/* =====================================================================================

  ---CONN_INFRA_CONN2AP_SLP_CTRL (0x18001000 + 0x500)---

    CFG_CONN2AP_GALS_TX_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_gals_conn2ap_tx sleep protect en
                                     0: conn_infra_gals_conn2ap_tx sleep protect en depends on disable control or hardware
    CFG_CONN2AP_GALS_TX_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2ap_tx sleep protect disable
                                     0: conn_infra_gals_conn2ap_tx  sleep protect will control by hardware
    CSR_CONN2AP_GALS_TX_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_gals_conn2ap_tx sleep protect en
                                     0: conn_infra_gals_conn2ap_tx sleep protect en depends on disable control or hardware
    CSR_CONN2AP_GALS_TX_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2ap_tx sleep protect disable
                                     0: conn_infra_gals_conn2ap_tx  sleep protect will control by hardware
    CFG_CONN2AP_GALS_RX_SLP_PROT_SW_EN[4] - (RW) 1: force conn_infra_gals_conn2ap_rx sleep protect en
                                     0: conn_infra_gals_conn2ap_rx sleep protect en depends on disable control or hardware
    CFG_CONN2AP_GALS_RX_SLP_PROT_SW_DIS[5] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2ap_rx sleep protect disable
                                     0: conn_infra_gals_conn2ap_rx  sleep protect will control by hardware
    CSR_CONN2AP_GALS_RX_SLP_PROT_SW_EN[6] - (RO) 1: force conn_infra_gals_conn2ap_rx sleep protect en
                                     0: conn_infra_gals_conn2ap_rx sleep protect en depends on disable control or hardware
    CSR_CONN2AP_GALS_RX_SLP_PROT_SW_DIS[7] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2ap_rx sleep protect disable
                                     0: conn_infra_gals_conn2ap_rx  sleep protect will control by hardware
    CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_EN[8] - (RW) timeout function enable
                                     1: enable
                                     0: disable
    CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9] - (RW) clear timeout irq, write 1 to clear, and need to write 0 after write 1
    CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10] - (RW) timeout timing set, count with 32k clock
    CONN2AP_GALS_SLPPROT_CTRL_FSM_RST[16] - (RW) fsm_reset, 1:reset, 0: release
    CONN2AP_GALS_SLPPROT_CTRL_TX_EN_MODE[17] - (RW) tx sleep protect en mode, 1: sw mode, 0: hw mode
    CONN2AP_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18] - (RW) tx sleep protect sw ctrl
    CONN2AP_GALS_SLPPROT_CTRL_RX_EN_MODE[19] - (RW) rx sleep protect en mode, 1: sw mode, 0: hw mode
    CONN2AP_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20] - (RW) rx sleep protect sw ctrl
    CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MODE[21] - (RW) tx sleep protect rdy mode, 1: sw mode, 0: hw mode
    CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22] - (RW) tx sleep protect rdy sw ctrl
    CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MASK[23] - (RW) tx sleep protect rdy mask
    CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MODE[24] - (RW) rx sleep protect rdy mode, 1: sw mode, 0: hw mode
    CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25] - (RW) rx sleep protect rdy sw ctrl
    CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MASK[26] - (RW) rx sleep protect rdy mask
    CONN2AP_GALS_SLPPROT_CTRL_MODE[27] - (RW) gals sleep protect mode, 1: sw, 0: hw
    CONN2AP_GALS_SLPPROT_CTRL_SW_EN[28] - (RW) sleep protect sw en
    CONN2AP_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29] - (RW) hw enable signal  0 mask
    CONN2AP_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30] - (RW) hw enable signal  1 mask
    CONN2AP_GALS_SLPPROT_CTRL_DUMMY[31] - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_DUMMY_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_DUMMY_MASK 0x80000000                // CONN2AP_GALS_SLPPROT_CTRL_DUMMY[31]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_DUMMY_SHFT 31
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_HW_EN_1_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_HW_EN_1_MASK_MASK 0x40000000                // CONN2AP_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_HW_EN_1_MASK_SHFT 30
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_HW_EN_0_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_HW_EN_0_MASK_MASK 0x20000000                // CONN2AP_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_HW_EN_0_MASK_SHFT 29
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_SW_EN_MASK 0x10000000                // CONN2AP_GALS_SLPPROT_CTRL_SW_EN[28]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_SW_EN_SHFT 28
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_MODE_MASK 0x08000000                // CONN2AP_GALS_SLPPROT_CTRL_MODE[27]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_MODE_SHFT 27
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MASK_MASK 0x04000000                // CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MASK[26]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MASK_SHFT 26
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_MASK 0x02000000                // CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_SHFT 25
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MODE_MASK 0x01000000                // CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MODE[24]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_RDY_MODE_SHFT 24
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MASK_MASK 0x00800000                // CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MASK[23]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MASK_SHFT 23
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_MASK 0x00400000                // CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_SHFT 22
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MODE_MASK 0x00200000                // CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MODE[21]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_RDY_MODE_SHFT 21
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_MASK 0x00100000                // CONN2AP_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_SHFT 20
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_EN_MODE_MASK 0x00080000                // CONN2AP_GALS_SLPPROT_CTRL_RX_EN_MODE[19]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_RX_EN_MODE_SHFT 19
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_MASK 0x00040000                // CONN2AP_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_SHFT 18
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_EN_MODE_MASK 0x00020000                // CONN2AP_GALS_SLPPROT_CTRL_TX_EN_MODE[17]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TX_EN_MODE_SHFT 17
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_FSM_RST_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_FSM_RST_MASK 0x00010000                // CONN2AP_GALS_SLPPROT_CTRL_FSM_RST[16]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_FSM_RST_SHFT 16
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_TIME_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_TIME_MASK 0x0000FC00                // CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_TIME_SHFT 10
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_CLR_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_CLR_MASK 0x00000200                // CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_CLR_SHFT 9
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_EN_MASK 0x00000100                // CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_EN[8]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CONN2AP_GALS_SLPPROT_CTRL_TIMEOUT_EN_SHFT 8
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000080                // CSR_CONN2AP_GALS_RX_SLP_PROT_SW_DIS[7]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_RX_SLP_PROT_SW_DIS_SHFT 7
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000040                // CSR_CONN2AP_GALS_RX_SLP_PROT_SW_EN[6]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_RX_SLP_PROT_SW_EN_SHFT 6
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000020                // CFG_CONN2AP_GALS_RX_SLP_PROT_SW_DIS[5]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_RX_SLP_PROT_SW_DIS_SHFT 5
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000010                // CFG_CONN2AP_GALS_RX_SLP_PROT_SW_EN[4]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_RX_SLP_PROT_SW_EN_SHFT 4
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_CONN2AP_GALS_TX_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_TX_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_CONN2AP_GALS_TX_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CSR_CONN2AP_GALS_TX_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_CONN2AP_GALS_TX_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_TX_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_CONN2AP_GALS_TX_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_CTRL_CFG_CONN2AP_GALS_TX_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_CONN2AP_SLP_STATUS (0x18001000 + 0x504)---

    RESERVED0[11..0]             - (RO) Reserved bits
    CONN2AP_GALS_CTRL_DIS_TIMEOUT[12] - (RO) conn2ap gals sleep protect contorol sleep protect disable timeout
    CONN2AP_GALS_CTRL_EN_TIMEOUT[13] - (RO) conn2ap gals sleep protect contorol sleep protect enable timeout
    RESERVED14[14]               - (RO) Reserved bits
    CONN2AP_GALS_CTRL_TIMEOUT[15] - (RO) conn2ap gals sleep protect contorol timeout
    RESERVED16[18..16]           - (RO) Reserved bits
    CONN2AP_GALS_CTRL_PROT_RDY_OUT[19] - (RO) conn2ap gals sleep protect control protect ready
    RESERVED20[21..20]           - (RO) Reserved bits
    CONN2AP_GALS_CTRL_PROT_RX_RDY[22] - (RO) conn2ap gals sleep protect rx ready
    CONN2AP_GALS_CTRL_PROT_TX_RDY[23] - (RO) conn2ap gals sleep protect tx ready
    RESERVED24[27..24]           - (RO) Reserved bits
    CONN2AP_GALS_CTRL_PROT_RX_EN[28] - (RO) conn2ap gals sleep protect control sleep protect rx enable
    CONN2AP_GALS_CTRL_PROT_TX_EN[29] - (RO) conn2ap gals sleep protect control sleep protect tx enable
    RESERVED30[30]               - (RO) Reserved bits
    CONN2AP_GALS_CTRL_PROT_EN[31] - (RO) conn2ap gals sleep protect control sleep protect enable

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_EN_MASK 0x80000000                // CONN2AP_GALS_CTRL_PROT_EN[31]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_EN_SHFT 31
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_TX_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_TX_EN_MASK 0x20000000                // CONN2AP_GALS_CTRL_PROT_TX_EN[29]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_TX_EN_SHFT 29
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RX_EN_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RX_EN_MASK 0x10000000                // CONN2AP_GALS_CTRL_PROT_RX_EN[28]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RX_EN_SHFT 28
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_TX_RDY_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_TX_RDY_MASK 0x00800000                // CONN2AP_GALS_CTRL_PROT_TX_RDY[23]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_TX_RDY_SHFT 23
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RX_RDY_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RX_RDY_MASK 0x00400000                // CONN2AP_GALS_CTRL_PROT_RX_RDY[22]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RX_RDY_SHFT 22
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RDY_OUT_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RDY_OUT_MASK 0x00080000                // CONN2AP_GALS_CTRL_PROT_RDY_OUT[19]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_PROT_RDY_OUT_SHFT 19
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_TIMEOUT_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_TIMEOUT_MASK 0x00008000                // CONN2AP_GALS_CTRL_TIMEOUT[15]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_TIMEOUT_SHFT 15
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_EN_TIMEOUT_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_EN_TIMEOUT_MASK 0x00002000                // CONN2AP_GALS_CTRL_EN_TIMEOUT[13]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_EN_TIMEOUT_SHFT 13
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_DIS_TIMEOUT_ADDR CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_DIS_TIMEOUT_MASK 0x00001000                // CONN2AP_GALS_CTRL_DIS_TIMEOUT[12]
#define CONN_CFG_CONN_INFRA_CONN2AP_SLP_STATUS_CONN2AP_GALS_CTRL_DIS_TIMEOUT_SHFT 12

/* =====================================================================================

  ---CONN_INFRA_AP2CONN_SLP_CTRL (0x18001000 + 0x510)---

    CFG_AP2CONN_GALS_TX_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_gals_ap2conn_tx sleep protect en
                                     0: conn_infra_gals_ap2conn_tx sleep protect en depends on disable control or hardware
    CFG_AP2CONN_GALS_TX_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_ap2conn_tx sleep protect disable
                                     0: conn_infra_gals_ap2conn_tx  sleep protect will control by hardware
    CSR_AP2CONN_GALS_TX_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_gals_ap2conn_tx sleep protect en
                                     0: conn_infra_gals_ap2conn_tx sleep protect en depends on disable control or hardware
    CSR_AP2CONN_GALS_TX_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_ap2conn_tx sleep protect disable
                                     0: conn_infra_gals_ap2conn_tx  sleep protect will control by hardware
    CFG_AP2CONN_GALS_RX_SLP_PROT_SW_EN[4] - (RW) 1: force conn_infra_gals_ap2conn_rx sleep protect en
                                     0: conn_infra_gals_ap2conn_rx sleep protect en depends on disable control or hardware
    CFG_AP2CONN_GALS_RX_SLP_PROT_SW_DIS[5] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_ap2conn_rx sleep protect disable
                                     0: conn_infra_gals_ap2conn_rx  sleep protect will control by hardware
    CSR_AP2CONN_GALS_RX_SLP_PROT_SW_EN[6] - (RO) 1: force conn_infra_gals_ap2conn_rx sleep protect en
                                     0: conn_infra_gals_ap2conn_rx sleep protect en depends on disable control or hardware
    CSR_AP2CONN_GALS_RX_SLP_PROT_SW_DIS[7] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_ap2conn_rx sleep protect disable
                                     0: conn_infra_gals_ap2conn_rx  sleep protect will control by hardware
    RESERVED8[31..8]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000080                // CSR_AP2CONN_GALS_RX_SLP_PROT_SW_DIS[7]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_RX_SLP_PROT_SW_DIS_SHFT 7
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000040                // CSR_AP2CONN_GALS_RX_SLP_PROT_SW_EN[6]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_RX_SLP_PROT_SW_EN_SHFT 6
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000020                // CFG_AP2CONN_GALS_RX_SLP_PROT_SW_DIS[5]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_RX_SLP_PROT_SW_DIS_SHFT 5
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000010                // CFG_AP2CONN_GALS_RX_SLP_PROT_SW_EN[4]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_RX_SLP_PROT_SW_EN_SHFT 4
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_AP2CONN_GALS_TX_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_TX_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_AP2CONN_GALS_TX_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CSR_AP2CONN_GALS_TX_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_AP2CONN_GALS_TX_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_TX_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_AP2CONN_GALS_TX_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_CTRL_CFG_AP2CONN_GALS_TX_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_AP2CONN_SLP_STATUS (0x18001000 + 0x514)---

    RESERVED0[28..0]             - (RO) Reserved bits
    AP2CONN_GALS_RX_SLP_PROT_RDY[29] - (RO) ap2conn gals rx sleep protect ready
    AP2CONN_GALS_RX_SLP_PROT_HW_EN[30] - (RO) ap2conn gals rx sleep protect enable from top
    AP2CONN_GALS_TX_SLP_PROT_RDY[31] - (RO) ap2conn gals tx sleep protect ready

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_TX_SLP_PROT_RDY_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_TX_SLP_PROT_RDY_MASK 0x80000000                // AP2CONN_GALS_TX_SLP_PROT_RDY[31]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_TX_SLP_PROT_RDY_SHFT 31
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_RX_SLP_PROT_HW_EN_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_RX_SLP_PROT_HW_EN_MASK 0x40000000                // AP2CONN_GALS_RX_SLP_PROT_HW_EN[30]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_RX_SLP_PROT_HW_EN_SHFT 30
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_RX_SLP_PROT_RDY_ADDR CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_RX_SLP_PROT_RDY_MASK 0x20000000                // AP2CONN_GALS_RX_SLP_PROT_RDY[29]
#define CONN_CFG_CONN_INFRA_AP2CONN_SLP_STATUS_AP2CONN_GALS_RX_SLP_PROT_RDY_SHFT 29

/* =====================================================================================

  ---CONN_INFRA_ON_BUS_SLP_CTRL (0x18001000 + 0x520)---

    CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_on2off sleep protect en
                                     0: conn_infra_on2off sleep protect en depends on disable control or hardware
    CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_on2off sleep protect disable
                                     0: conn_infra_on2off  sleep protect will control by hardware
    CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_on2off sleep protect en
                                     0: conn_infra_on2off sleep protect en depends on disable control or hardware
    CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_on2off sleep protect disable
                                     0: conn_infra_on2off  sleep protect will control by hardware
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CSR_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_CTRL_CFG_CONN_INFRA_ON2OFF_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_ON_BUS_SLP_STATUS (0x18001000 + 0x524)---

    R_CONN_INFRA_ON_BUS_SLP_STATUS[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_STATUS_R_CONN_INFRA_ON_BUS_SLP_STATUS_ADDR CONN_CFG_CONN_INFRA_ON_BUS_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_STATUS_R_CONN_INFRA_ON_BUS_SLP_STATUS_MASK 0xFFFFFFFF                // R_CONN_INFRA_ON_BUS_SLP_STATUS[31..0]
#define CONN_CFG_CONN_INFRA_ON_BUS_SLP_STATUS_R_CONN_INFRA_ON_BUS_SLP_STATUS_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_OFF_BUS_SLP_CTRL (0x18001000 + 0x530)---

    CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_off2on sleep protect en
                                     0: conn_infra_off2on sleep protect en depends on disable control or hardware
    CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_off2on sleep protect disable
                                     0: conn_infra_off2on  sleep protect will control by hardware
    CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_off2on sleep protect en
                                     0: conn_infra_off2on sleep protect en depends on disable control or hardware
    CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_off2on sleep protect disable
                                     0: conn_infra_off2on  sleep protect will control by hardware
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CSR_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_CTRL_CFG_CONN_INFRA_OFF2ON_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_OFF_BUS_SLP_STATUS (0x18001000 + 0x534)---

    R_CONN_INFRA_OFF_BUS_SLP_STATUS[31..0] - (RO)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_STATUS_R_CONN_INFRA_OFF_BUS_SLP_STATUS_ADDR CONN_CFG_CONN_INFRA_OFF_BUS_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_STATUS_R_CONN_INFRA_OFF_BUS_SLP_STATUS_MASK 0xFFFFFFFF                // R_CONN_INFRA_OFF_BUS_SLP_STATUS[31..0]
#define CONN_CFG_CONN_INFRA_OFF_BUS_SLP_STATUS_R_CONN_INFRA_OFF_BUS_SLP_STATUS_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_WF_SLP_CTRL (0x18001000 + 0x540)---

    CFG_CONN_WF_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_wf sleep protect en
                                     0: conn_infra_wf sleep protect en depends on disable control or hardware
    CFG_CONN_WF_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_wf sleep protect disable
                                     0: conn_infra_wf  sleep protect will control by hardware
    CSR_CONN_WF_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_wf sleep protect en
                                     0: conn_infra_wf sleep protect en depends on disable control or hardware
    CSR_CONN_WF_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_wf sleep protect disable
                                     0: conn_infra_wf  sleep protect will control by hardware
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CSR_CONN_WF_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_WF_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CSR_CONN_WF_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_CONN_WF_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CSR_CONN_WF_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CSR_CONN_WF_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_WF_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CSR_CONN_WF_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_CONN_WF_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CSR_CONN_WF_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CFG_CONN_WF_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_WF_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CFG_CONN_WF_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_CONN_WF_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CFG_CONN_WF_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CFG_CONN_WF_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_WF_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CFG_CONN_WF_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_CONN_WF_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_WF_SLP_CTRL_CFG_CONN_WF_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---CONN_INFRA_WF_SLP_STATUS (0x18001000 + 0x544)---

    RESERVED0[23..0]             - (RO) Reserved bits
    WFDMA2CONN_SLP_PROT_HW_EN[24] - (RO)  xxx 
    WFDMA2CONN_SLP_PROT_RDY[25]  - (RO)  xxx 
    WF_ICAP2CONN_SLP_PROT_HW_EN[26] - (RO)  xxx 
    WF_ICAP2CONN_SLP_PROT_RDY[27] - (RO)  xxx 
    CONN2WF_SLP_PROT_HW_EN[28]   - (RO)  xxx 
    CONN2WF_SLP_PROT_RDY[29]     - (RO)  xxx 
    WF2CONN_SLP_PROT_HW_EN[30]   - (RO)  xxx 
    WF2CONN_SLP_PROT_RDY[31]     - (RO)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF2CONN_SLP_PROT_RDY_ADDR CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF2CONN_SLP_PROT_RDY_MASK 0x80000000                // WF2CONN_SLP_PROT_RDY[31]
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF2CONN_SLP_PROT_RDY_SHFT 31
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF2CONN_SLP_PROT_HW_EN_ADDR CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF2CONN_SLP_PROT_HW_EN_MASK 0x40000000                // WF2CONN_SLP_PROT_HW_EN[30]
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF2CONN_SLP_PROT_HW_EN_SHFT 30
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_CONN2WF_SLP_PROT_RDY_ADDR CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_CONN2WF_SLP_PROT_RDY_MASK 0x20000000                // CONN2WF_SLP_PROT_RDY[29]
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_CONN2WF_SLP_PROT_RDY_SHFT 29
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_CONN2WF_SLP_PROT_HW_EN_ADDR CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_CONN2WF_SLP_PROT_HW_EN_MASK 0x10000000                // CONN2WF_SLP_PROT_HW_EN[28]
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_CONN2WF_SLP_PROT_HW_EN_SHFT 28
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF_ICAP2CONN_SLP_PROT_RDY_ADDR CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF_ICAP2CONN_SLP_PROT_RDY_MASK 0x08000000                // WF_ICAP2CONN_SLP_PROT_RDY[27]
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF_ICAP2CONN_SLP_PROT_RDY_SHFT 27
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF_ICAP2CONN_SLP_PROT_HW_EN_ADDR CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF_ICAP2CONN_SLP_PROT_HW_EN_MASK 0x04000000                // WF_ICAP2CONN_SLP_PROT_HW_EN[26]
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WF_ICAP2CONN_SLP_PROT_HW_EN_SHFT 26
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WFDMA2CONN_SLP_PROT_RDY_ADDR CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WFDMA2CONN_SLP_PROT_RDY_MASK 0x02000000                // WFDMA2CONN_SLP_PROT_RDY[25]
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WFDMA2CONN_SLP_PROT_RDY_SHFT 25
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WFDMA2CONN_SLP_PROT_HW_EN_ADDR CONN_CFG_CONN_INFRA_WF_SLP_STATUS_ADDR
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WFDMA2CONN_SLP_PROT_HW_EN_MASK 0x01000000                // WFDMA2CONN_SLP_PROT_HW_EN[24]
#define CONN_CFG_CONN_INFRA_WF_SLP_STATUS_WFDMA2CONN_SLP_PROT_HW_EN_SHFT 24

/* =====================================================================================

  ---CONN_INFRA_CONN2BT_SLP_CTRL (0x18001000 + 0x550)---

    CFG_CONN2BT_GALS_TX_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_gals_conn2bt_tx sleep protect en
                                     0: conn_infra_gals_conn2bt_tx sleep protect en depends on disable control or hardware
    CFG_CONN2BT_GALS_TX_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2bt_tx sleep protect disable
                                     0: conn_infra_gals_conn2bt_tx  sleep protect will control by hardware
    CSR_CONN2BT_GALS_TX_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_gals_conn2bt_tx sleep protect en
                                     0: conn_infra_gals_conn2bt_tx sleep protect en depends on disable control or hardware
    CSR_CONN2BT_GALS_TX_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2bt_tx sleep protect disable
                                     0: conn_infra_gals_conn2bt_tx  sleep protect will control by hardware
    CFG_CONN2BT_GALS_RX_SLP_PROT_SW_EN[4] - (RW) 1: force conn_infra_gals_conn2bt_rx sleep protect en
                                     0: conn_infra_gals_conn2bt_rx sleep protect en depends on disable control or hardware
    CFG_CONN2BT_GALS_RX_SLP_PROT_SW_DIS[5] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2bt_rx sleep protect disable
                                     0: conn_infra_gals_conn2bt_rx  sleep protect will control by hardware
    CSR_CONN2BT_GALS_RX_SLP_PROT_SW_EN[6] - (RO) 1: force conn_infra_gals_conn2bt_rx sleep protect en
                                     0: conn_infra_gals_conn2bt_rx sleep protect en depends on disable control or hardware
    CSR_CONN2BT_GALS_RX_SLP_PROT_SW_DIS[7] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2bt_rx sleep protect disable
                                     0: conn_infra_gals_conn2bt_rx  sleep protect will control by hardware
    CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_EN[8] - (RW) timeout function enable
                                     1: enable
                                     0: disable
    CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9] - (RW) clear timeout irq, write 1 to clear, and need to write 0 after write 1
    CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10] - (RW) timeout timing set, count with 32k clock
    CONN2BT_GALS_SLPPROT_CTRL_FSM_RST[16] - (RW) fsm_reset, 1:reset, 0: release
    CONN2BT_GALS_SLPPROT_CTRL_TX_EN_MODE[17] - (RW) tx sleep protect en mode, 1: sw mode, 0: hw mode
    CONN2BT_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18] - (RW) tx sleep protect sw ctrl
    CONN2BT_GALS_SLPPROT_CTRL_RX_EN_MODE[19] - (RW) rx sleep protect en mode, 1: sw mode, 0: hw mode
    CONN2BT_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20] - (RW) rx sleep protect sw ctrl
    CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MODE[21] - (RW) tx sleep protect rdy mode, 1: sw mode, 0: hw mode
    CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22] - (RW) tx sleep protect rdy sw ctrl
    CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MASK[23] - (RW) tx sleep protect rdy mask
    CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MODE[24] - (RW) rx sleep protect rdy mode, 1: sw mode, 0: hw mode
    CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25] - (RW) rx sleep protect rdy sw ctrl
    CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MASK[26] - (RW) rx sleep protect rdy mask
    CONN2BT_GALS_SLPPROT_CTRL_MODE[27] - (RW) gals sleep protect mode, 1: sw, 0: hw
    CONN2BT_GALS_SLPPROT_CTRL_SW_EN[28] - (RW) sleep protect sw en
    CONN2BT_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29] - (RW) hw enable signal  0 mask
    CONN2BT_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30] - (RW) hw enable signal  1 mask
    CONN2BT_GALS_SLPPROT_CTRL_DUMMY[31] - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_DUMMY_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_DUMMY_MASK 0x80000000                // CONN2BT_GALS_SLPPROT_CTRL_DUMMY[31]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_DUMMY_SHFT 31
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_HW_EN_1_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_HW_EN_1_MASK_MASK 0x40000000                // CONN2BT_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_HW_EN_1_MASK_SHFT 30
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_HW_EN_0_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_HW_EN_0_MASK_MASK 0x20000000                // CONN2BT_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_HW_EN_0_MASK_SHFT 29
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_SW_EN_MASK 0x10000000                // CONN2BT_GALS_SLPPROT_CTRL_SW_EN[28]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_SW_EN_SHFT 28
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_MODE_MASK 0x08000000                // CONN2BT_GALS_SLPPROT_CTRL_MODE[27]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_MODE_SHFT 27
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MASK_MASK 0x04000000                // CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MASK[26]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MASK_SHFT 26
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_MASK 0x02000000                // CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_SHFT 25
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MODE_MASK 0x01000000                // CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MODE[24]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_RDY_MODE_SHFT 24
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MASK_MASK 0x00800000                // CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MASK[23]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MASK_SHFT 23
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_MASK 0x00400000                // CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_SHFT 22
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MODE_MASK 0x00200000                // CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MODE[21]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_RDY_MODE_SHFT 21
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_MASK 0x00100000                // CONN2BT_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_SHFT 20
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_EN_MODE_MASK 0x00080000                // CONN2BT_GALS_SLPPROT_CTRL_RX_EN_MODE[19]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_RX_EN_MODE_SHFT 19
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_MASK 0x00040000                // CONN2BT_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_SHFT 18
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_EN_MODE_MASK 0x00020000                // CONN2BT_GALS_SLPPROT_CTRL_TX_EN_MODE[17]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TX_EN_MODE_SHFT 17
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_FSM_RST_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_FSM_RST_MASK 0x00010000                // CONN2BT_GALS_SLPPROT_CTRL_FSM_RST[16]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_FSM_RST_SHFT 16
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_TIME_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_TIME_MASK 0x0000FC00                // CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_TIME_SHFT 10
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_CLR_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_CLR_MASK 0x00000200                // CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_CLR_SHFT 9
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_EN_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_EN_MASK 0x00000100                // CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_EN[8]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CONN2BT_GALS_SLPPROT_CTRL_TIMEOUT_EN_SHFT 8
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000080                // CSR_CONN2BT_GALS_RX_SLP_PROT_SW_DIS[7]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_RX_SLP_PROT_SW_DIS_SHFT 7
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000040                // CSR_CONN2BT_GALS_RX_SLP_PROT_SW_EN[6]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_RX_SLP_PROT_SW_EN_SHFT 6
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000020                // CFG_CONN2BT_GALS_RX_SLP_PROT_SW_DIS[5]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_RX_SLP_PROT_SW_DIS_SHFT 5
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000010                // CFG_CONN2BT_GALS_RX_SLP_PROT_SW_EN[4]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_RX_SLP_PROT_SW_EN_SHFT 4
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_CONN2BT_GALS_TX_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_TX_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_CONN2BT_GALS_TX_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CSR_CONN2BT_GALS_TX_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_CONN2BT_GALS_TX_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_TX_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_CONN2BT_GALS_TX_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_CONN2BT_SLP_CTRL_CFG_CONN2BT_GALS_TX_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---GALS_CONN2BT_SLP_STATUS (0x18001000 + 0x554)---

    RESERVED0[11..0]             - (RO) Reserved bits
    CONN2BT_GALS_CTRL_DIS_TIMEOUT[12] - (RO) conn2bt gals sleep protect contorol sleep protect disable timeout
    CONN2BT_GALS_CTRL_EN_TIMEOUT[13] - (RO) conn2bt gals sleep protect contorol sleep protect enable timeout
    RESERVED14[14]               - (RO) Reserved bits
    CONN2BT_GALS_CTRL_TIMEOUT[15] - (RO) conn2bt gals sleep protect contorol timeout
    RESERVED16[18..16]           - (RO) Reserved bits
    CONN2BT_GALS_CTRL_PROT_RDY_OUT[19] - (RO) conn2bt gals sleep protect control protect ready
    RESERVED20[21..20]           - (RO) Reserved bits
    CONN2BT_GALS_CTRL_PROT_RX_RDY[22] - (RO) conn2bt gals sleep protect rx ready
    CONN2BT_GALS_CTRL_PROT_TX_RDY[23] - (RO) conn2bt gals sleep protect tx ready
    RESERVED24[27..24]           - (RO) Reserved bits
    CONN2BT_GALS_CTRL_PROT_RX_EN[28] - (RO) conn2bt gals sleep protect control sleep protect rx enable
    CONN2BT_GALS_CTRL_PROT_TX_EN[29] - (RO) conn2bt gals sleep protect control sleep protect tx enable
    RESERVED30[30]               - (RO) Reserved bits
    CONN2BT_GALS_CTRL_PROT_EN[31] - (RO) conn2bt gals sleep protect control sleep protect enable

 =====================================================================================*/
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_EN_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_EN_MASK 0x80000000                // CONN2BT_GALS_CTRL_PROT_EN[31]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_EN_SHFT 31
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_TX_EN_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_TX_EN_MASK 0x20000000                // CONN2BT_GALS_CTRL_PROT_TX_EN[29]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_TX_EN_SHFT 29
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RX_EN_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RX_EN_MASK 0x10000000                // CONN2BT_GALS_CTRL_PROT_RX_EN[28]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RX_EN_SHFT 28
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_TX_RDY_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_TX_RDY_MASK 0x00800000                // CONN2BT_GALS_CTRL_PROT_TX_RDY[23]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_TX_RDY_SHFT 23
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RX_RDY_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RX_RDY_MASK 0x00400000                // CONN2BT_GALS_CTRL_PROT_RX_RDY[22]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RX_RDY_SHFT 22
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RDY_OUT_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RDY_OUT_MASK 0x00080000                // CONN2BT_GALS_CTRL_PROT_RDY_OUT[19]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_PROT_RDY_OUT_SHFT 19
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_TIMEOUT_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_TIMEOUT_MASK 0x00008000                // CONN2BT_GALS_CTRL_TIMEOUT[15]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_TIMEOUT_SHFT 15
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_EN_TIMEOUT_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_EN_TIMEOUT_MASK 0x00002000                // CONN2BT_GALS_CTRL_EN_TIMEOUT[13]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_EN_TIMEOUT_SHFT 13
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_DIS_TIMEOUT_ADDR CONN_CFG_GALS_CONN2BT_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_DIS_TIMEOUT_MASK 0x00001000                // CONN2BT_GALS_CTRL_DIS_TIMEOUT[12]
#define CONN_CFG_GALS_CONN2BT_SLP_STATUS_CONN2BT_GALS_CTRL_DIS_TIMEOUT_SHFT 12

/* =====================================================================================

  ---CONN_INFRA_BT2CONN_SLP_CTRL (0x18001000 + 0x560)---

    CFG_BT2CONN_GALS_TX_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_gals_bt2conn_tx sleep protect en
                                     0: conn_infra_gals_bt2conn_tx sleep protect en depends on disable control or hardware
    CFG_BT2CONN_GALS_TX_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_bt2conn_tx sleep protect disable
                                     0: conn_infra_gals_bt2conn_tx  sleep protect will control by hardware
    CSR_BT2CONN_GALS_TX_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_gals_bt2conn_tx sleep protect en
                                     0: conn_infra_gals_bt2conn_tx sleep protect en depends on disable control or hardware
    CSR_BT2CONN_GALS_TX_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_bt2conn_tx sleep protect disable
                                     0: conn_infra_gals_bt2conn_tx  sleep protect will control by hardware
    CFG_BT2CONN_GALS_RX_SLP_PROT_SW_EN[4] - (RW) 1: force conn_infra_gals_bt2conn_rx sleep protect en
                                     0: conn_infra_gals_bt2conn_rx sleep protect en depends on disable control or hardware
    CFG_BT2CONN_GALS_RX_SLP_PROT_SW_DIS[5] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_bt2conn_rx sleep protect disable
                                     0: conn_infra_gals_bt2conn_rx  sleep protect will control by hardware
    CSR_BT2CONN_GALS_RX_SLP_PROT_SW_EN[6] - (RO) 1: force conn_infra_gals_bt2conn_rx sleep protect en
                                     0: conn_infra_gals_bt2conn_rx sleep protect en depends on disable control or hardware
    CSR_BT2CONN_GALS_RX_SLP_PROT_SW_DIS[7] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_bt2conn_rx sleep protect disable
                                     0: conn_infra_gals_bt2conn_rx  sleep protect will control by hardware
    BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN[8] - (RW) timeout function enable
                                     1: enable
                                     0: disable
    BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9] - (RW) clear timeout irq, write 1 to clear, and need to write 0 after write 1
    BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10] - (RW) timeout timing set, count with 32k clock
    BT2CONN_GALS_SLPPROT_CTRL_FSM_RST[16] - (RW) fsm_reset, 1:reset, 0: release
    BT2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE[17] - (RW) tx sleep protect en mode, 1: sw mode, 0: hw mode
    BT2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18] - (RW) tx sleep protect sw ctrl
    BT2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE[19] - (RW) rx sleep protect en mode, 1: sw mode, 0: hw mode
    BT2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20] - (RW) rx sleep protect sw ctrl
    BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE[21] - (RW) tx sleep protect rdy mode, 1: sw mode, 0: hw mode
    BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22] - (RW) tx sleep protect rdy sw ctrl
    BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK[23] - (RW) tx sleep protect rdy mask
    BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE[24] - (RW) rx sleep protect rdy mode, 1: sw mode, 0: hw mode
    BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25] - (RW) rx sleep protect rdy sw ctrl
    BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK[26] - (RW) rx sleep protect rdy mask
    BT2CONN_GALS_SLPPROT_CTRL_MODE[27] - (RW) gals sleep protect mode, 1: sw, 0: hw
    BT2CONN_GALS_SLPPROT_CTRL_SW_EN[28] - (RW) sleep protect sw en
    BT2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29] - (RW) hw enable signal  0 mask
    BT2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30] - (RW) hw enable signal  1 mask
    BT2CONN_GALS_SLPPROT_CTRL_DUMMY[31] - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_DUMMY_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_DUMMY_MASK 0x80000000                // BT2CONN_GALS_SLPPROT_CTRL_DUMMY[31]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_DUMMY_SHFT 31
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK_MASK 0x40000000                // BT2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK_SHFT 30
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK_MASK 0x20000000                // BT2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK_SHFT 29
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_SW_EN_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_SW_EN_MASK 0x10000000                // BT2CONN_GALS_SLPPROT_CTRL_SW_EN[28]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_SW_EN_SHFT 28
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_MODE_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_MODE_MASK 0x08000000                // BT2CONN_GALS_SLPPROT_CTRL_MODE[27]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_MODE_SHFT 27
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK_MASK 0x04000000                // BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK[26]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK_SHFT 26
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_MASK 0x02000000                // BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_SHFT 25
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE_MASK 0x01000000                // BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE[24]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE_SHFT 24
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK_MASK 0x00800000                // BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK[23]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK_SHFT 23
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_MASK 0x00400000                // BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_SHFT 22
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE_MASK 0x00200000                // BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE[21]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE_SHFT 21
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_MASK 0x00100000                // BT2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_SHFT 20
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE_MASK 0x00080000                // BT2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE[19]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE_SHFT 19
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_MASK 0x00040000                // BT2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_SHFT 18
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE_MASK 0x00020000                // BT2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE[17]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE_SHFT 17
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_FSM_RST_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_FSM_RST_MASK 0x00010000                // BT2CONN_GALS_SLPPROT_CTRL_FSM_RST[16]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_FSM_RST_SHFT 16
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME_MASK 0x0000FC00                // BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME_SHFT 10
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR_MASK 0x00000200                // BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR_SHFT 9
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN_MASK 0x00000100                // BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN[8]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_BT2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN_SHFT 8
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000080                // CSR_BT2CONN_GALS_RX_SLP_PROT_SW_DIS[7]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_RX_SLP_PROT_SW_DIS_SHFT 7
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000040                // CSR_BT2CONN_GALS_RX_SLP_PROT_SW_EN[6]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_RX_SLP_PROT_SW_EN_SHFT 6
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000020                // CFG_BT2CONN_GALS_RX_SLP_PROT_SW_DIS[5]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_RX_SLP_PROT_SW_DIS_SHFT 5
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000010                // CFG_BT2CONN_GALS_RX_SLP_PROT_SW_EN[4]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_RX_SLP_PROT_SW_EN_SHFT 4
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_BT2CONN_GALS_TX_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_TX_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_BT2CONN_GALS_TX_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CSR_BT2CONN_GALS_TX_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_BT2CONN_GALS_TX_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_TX_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_BT2CONN_GALS_TX_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_BT2CONN_SLP_CTRL_CFG_BT2CONN_GALS_TX_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---GALS_BT2CONN_SLP_STATUS (0x18001000 + 0x564)---

    RESERVED0[11..0]             - (RO) Reserved bits
    BT2CONN_GALS_CTRL_DIS_TIMEOUT[12] - (RO) bt2conn gals sleep protect contorol sleep protect disable timeout
    BT2CONN_GALS_CTRL_EN_TIMEOUT[13] - (RO) bt2conn gals sleep protect contorol sleep protect enable timeout
    RESERVED14[14]               - (RO) Reserved bits
    BT2CONN_GALS_CTRL_TIMEOUT[15] - (RO) bt2conn gals sleep protect contorol timeout
    RESERVED16[18..16]           - (RO) Reserved bits
    BT2CONN_GALS_CTRL_PROT_RDY_OUT[19] - (RO) bt2conn gals sleep protect control protect ready
    RESERVED20[21..20]           - (RO) Reserved bits
    BT2CONN_GALS_CTRL_PROT_RX_RDY[22] - (RO) bt2conn gals sleep protect rx ready
    BT2CONN_GALS_CTRL_PROT_TX_RDY[23] - (RO) bt2conn gals sleep protect tx ready
    RESERVED24[27..24]           - (RO) Reserved bits
    BT2CONN_GALS_CTRL_PROT_RX_EN[28] - (RO) bt2conn gals sleep protect control sleep protect rx enable
    BT2CONN_GALS_CTRL_PROT_TX_EN[29] - (RO) bt2conn gals sleep protect control sleep protect tx enable
    RESERVED30[30]               - (RO) Reserved bits
    BT2CONN_GALS_CTRL_PROT_EN[31] - (RO) bt2conn gals sleep protect control sleep protect enable

 =====================================================================================*/
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_EN_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_EN_MASK 0x80000000                // BT2CONN_GALS_CTRL_PROT_EN[31]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_EN_SHFT 31
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_TX_EN_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_TX_EN_MASK 0x20000000                // BT2CONN_GALS_CTRL_PROT_TX_EN[29]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_TX_EN_SHFT 29
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RX_EN_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RX_EN_MASK 0x10000000                // BT2CONN_GALS_CTRL_PROT_RX_EN[28]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RX_EN_SHFT 28
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_TX_RDY_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_TX_RDY_MASK 0x00800000                // BT2CONN_GALS_CTRL_PROT_TX_RDY[23]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_TX_RDY_SHFT 23
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RX_RDY_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RX_RDY_MASK 0x00400000                // BT2CONN_GALS_CTRL_PROT_RX_RDY[22]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RX_RDY_SHFT 22
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RDY_OUT_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RDY_OUT_MASK 0x00080000                // BT2CONN_GALS_CTRL_PROT_RDY_OUT[19]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_PROT_RDY_OUT_SHFT 19
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_TIMEOUT_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_TIMEOUT_MASK 0x00008000                // BT2CONN_GALS_CTRL_TIMEOUT[15]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_TIMEOUT_SHFT 15
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_EN_TIMEOUT_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_EN_TIMEOUT_MASK 0x00002000                // BT2CONN_GALS_CTRL_EN_TIMEOUT[13]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_EN_TIMEOUT_SHFT 13
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_DIS_TIMEOUT_ADDR CONN_CFG_GALS_BT2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_DIS_TIMEOUT_MASK 0x00001000                // BT2CONN_GALS_CTRL_DIS_TIMEOUT[12]
#define CONN_CFG_GALS_BT2CONN_SLP_STATUS_BT2CONN_GALS_CTRL_DIS_TIMEOUT_SHFT 12

/* =====================================================================================

  ---CONN_INFRA_CONN2GPS_SLP_CTRL (0x18001000 + 0x570)---

    CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_gals_conn2gps_tx sleep protect en
                                     0: conn_infra_gals_conn2gps_tx sleep protect en depends on disable control or hardware
    CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2gps_tx sleep protect disable
                                     0: conn_infra_gals_conn2gps_tx  sleep protect will control by hardware
    CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_gals_conn2gps_tx sleep protect en
                                     0: conn_infra_gals_conn2gps_tx sleep protect en depends on disable control or hardware
    CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2gps_tx sleep protect disable
                                     0: conn_infra_gals_conn2gps_tx  sleep protect will control by hardware
    CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_EN[4] - (RW) 1: force conn_infra_gals_conn2gps_rx sleep protect en
                                     0: conn_infra_gals_conn2gps_rx sleep protect en depends on disable control or hardware
    CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS[5] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2gps_rx sleep protect disable
                                     0: conn_infra_gals_conn2gps_rx  sleep protect will control by hardware
    CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_EN[6] - (RO) 1: force conn_infra_gals_conn2gps_rx sleep protect en
                                     0: conn_infra_gals_conn2gps_rx sleep protect en depends on disable control or hardware
    CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS[7] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_conn2gps_rx sleep protect disable
                                     0: conn_infra_gals_conn2gps_rx  sleep protect will control by hardware
    CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_EN[8] - (RW) timeout function enable
                                     1: enable
                                     0: disable
    CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9] - (RW) clear timeout irq, write 1 to clear, and need to write 0 after write 1
    CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10] - (RW) timeout timing set, count with 32k clock
    CONN2GPS_GALS_SLPPROT_CTRL_FSM_RST[16] - (RW) fsm_reset, 1:reset, 0: release
    CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_MODE[17] - (RW) tx sleep protect en mode, 1: sw mode, 0: hw mode
    CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18] - (RW) tx sleep protect sw ctrl
    CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_MODE[19] - (RW) rx sleep protect en mode, 1: sw mode, 0: hw mode
    CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20] - (RW) rx sleep protect sw ctrl
    CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MODE[21] - (RW) tx sleep protect rdy mode, 1: sw mode, 0: hw mode
    CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22] - (RW) tx sleep protect rdy sw ctrl
    CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MASK[23] - (RW) tx sleep protect rdy mask
    CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MODE[24] - (RW) rx sleep protect rdy mode, 1: sw mode, 0: hw mode
    CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25] - (RW) rx sleep protect rdy sw ctrl
    CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MASK[26] - (RW) rx sleep protect rdy mask
    CONN2GPS_GALS_SLPPROT_CTRL_MODE[27] - (RW) gals sleep protect mode, 1: sw, 0: hw
    CONN2GPS_GALS_SLPPROT_CTRL_SW_EN[28] - (RW) sleep protect sw en
    CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29] - (RW) hw enable signal  0 mask
    CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30] - (RW) hw enable signal  1 mask
    CONN2GPS_GALS_SLPPROT_CTRL_DUMMY[31] - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_DUMMY_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_DUMMY_MASK 0x80000000                // CONN2GPS_GALS_SLPPROT_CTRL_DUMMY[31]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_DUMMY_SHFT 31
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_1_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_1_MASK_MASK 0x40000000                // CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_1_MASK_SHFT 30
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_0_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_0_MASK_MASK 0x20000000                // CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_HW_EN_0_MASK_SHFT 29
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_SW_EN_MASK 0x10000000                // CONN2GPS_GALS_SLPPROT_CTRL_SW_EN[28]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_SW_EN_SHFT 28
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_MODE_MASK 0x08000000                // CONN2GPS_GALS_SLPPROT_CTRL_MODE[27]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_MODE_SHFT 27
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MASK_MASK 0x04000000                // CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MASK[26]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MASK_SHFT 26
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_MASK 0x02000000                // CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_SHFT 25
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MODE_MASK 0x01000000                // CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MODE[24]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_RDY_MODE_SHFT 24
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MASK_MASK 0x00800000                // CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MASK[23]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MASK_SHFT 23
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_MASK 0x00400000                // CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_SHFT 22
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MODE_MASK 0x00200000                // CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MODE[21]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_RDY_MODE_SHFT 21
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_MASK 0x00100000                // CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_SHFT 20
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_MODE_MASK 0x00080000                // CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_MODE[19]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_RX_EN_MODE_SHFT 19
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_MASK 0x00040000                // CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_SHFT 18
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_MODE_MASK 0x00020000                // CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_MODE[17]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TX_EN_MODE_SHFT 17
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_FSM_RST_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_FSM_RST_MASK 0x00010000                // CONN2GPS_GALS_SLPPROT_CTRL_FSM_RST[16]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_FSM_RST_SHFT 16
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_TIME_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_TIME_MASK 0x0000FC00                // CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_TIME_SHFT 10
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_CLR_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_CLR_MASK 0x00000200                // CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_CLR_SHFT 9
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_EN_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_EN_MASK 0x00000100                // CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_EN[8]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CONN2GPS_GALS_SLPPROT_CTRL_TIMEOUT_EN_SHFT 8
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000080                // CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS[7]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS_SHFT 7
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000040                // CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_EN[6]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_RX_SLP_PROT_SW_EN_SHFT 6
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000020                // CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS[5]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_DIS_SHFT 5
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000010                // CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_EN[4]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_EN_SHFT 4
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CSR_CONN2GPS_GALS_TX_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---GALS_CONN2GPS_SLP_STATUS (0x18001000 + 0x574)---

    RESERVED0[11..0]             - (RO) Reserved bits
    CONN2GPS_GALS_CTRL_DIS_TIMEOUT[12] - (RO) conn2gps gals sleep protect contorol sleep protect disable timeout
    CONN2GPS_GALS_CTRL_EN_TIMEOUT[13] - (RO) conn2gps gals sleep protect contorol sleep protect enable timeout
    RESERVED14[14]               - (RO) Reserved bits
    CONN2GPS_GALS_CTRL_TIMEOUT[15] - (RO) conn2gps gals sleep protect contorol timeout
    RESERVED16[18..16]           - (RO) Reserved bits
    CONN2GPS_GALS_CTRL_PROT_RDY_OUT[19] - (RO) conn2gps gals sleep protect control protect ready
    RESERVED20[21..20]           - (RO) Reserved bits
    CONN2GPS_GALS_CTRL_PROT_RX_RDY[22] - (RO) conn2gps gals sleep protect rx ready
    CONN2GPS_GALS_CTRL_PROT_TX_RDY[23] - (RO) conn2gps gals sleep protect tx ready
    RESERVED24[27..24]           - (RO) Reserved bits
    CONN2GPS_GALS_CTRL_PROT_RX_EN[28] - (RO) conn2gps gals sleep protect control sleep protect rx enable
    CONN2GPS_GALS_CTRL_PROT_TX_EN[29] - (RO) conn2gps gals sleep protect control sleep protect tx enable
    RESERVED30[30]               - (RO) Reserved bits
    CONN2GPS_GALS_CTRL_PROT_EN[31] - (RO) conn2gps gals sleep protect control sleep protect enable

 =====================================================================================*/
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_EN_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_EN_MASK 0x80000000                // CONN2GPS_GALS_CTRL_PROT_EN[31]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_EN_SHFT 31
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_TX_EN_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_TX_EN_MASK 0x20000000                // CONN2GPS_GALS_CTRL_PROT_TX_EN[29]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_TX_EN_SHFT 29
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RX_EN_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RX_EN_MASK 0x10000000                // CONN2GPS_GALS_CTRL_PROT_RX_EN[28]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RX_EN_SHFT 28
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_TX_RDY_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_TX_RDY_MASK 0x00800000                // CONN2GPS_GALS_CTRL_PROT_TX_RDY[23]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_TX_RDY_SHFT 23
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RX_RDY_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RX_RDY_MASK 0x00400000                // CONN2GPS_GALS_CTRL_PROT_RX_RDY[22]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RX_RDY_SHFT 22
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RDY_OUT_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RDY_OUT_MASK 0x00080000                // CONN2GPS_GALS_CTRL_PROT_RDY_OUT[19]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_PROT_RDY_OUT_SHFT 19
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_TIMEOUT_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_TIMEOUT_MASK 0x00008000                // CONN2GPS_GALS_CTRL_TIMEOUT[15]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_TIMEOUT_SHFT 15
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_EN_TIMEOUT_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_EN_TIMEOUT_MASK 0x00002000                // CONN2GPS_GALS_CTRL_EN_TIMEOUT[13]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_EN_TIMEOUT_SHFT 13
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_DIS_TIMEOUT_ADDR CONN_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_DIS_TIMEOUT_MASK 0x00001000                // CONN2GPS_GALS_CTRL_DIS_TIMEOUT[12]
#define CONN_CFG_GALS_CONN2GPS_SLP_STATUS_CONN2GPS_GALS_CTRL_DIS_TIMEOUT_SHFT 12

/* =====================================================================================

  ---CONN_INFRA_GPS2CONN_SLP_CTRL (0x18001000 + 0x580)---

    CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_EN[0] - (RW) 1: force conn_infra_gals_gps2conn_tx sleep protect en
                                     0: conn_infra_gals_gps2conn_tx sleep protect en depends on disable control or hardware
    CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS[1] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_gps2conn_tx sleep protect disable
                                     0: conn_infra_gals_gps2conn_tx  sleep protect will control by hardware
    CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_EN[2] - (RO) 1: force conn_infra_gals_gps2conn_tx sleep protect en
                                     0: conn_infra_gals_gps2conn_tx sleep protect en depends on disable control or hardware
    CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS[3] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_gps2conn_tx sleep protect disable
                                     0: conn_infra_gals_gps2conn_tx  sleep protect will control by hardware
    CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_EN[4] - (RW) 1: force conn_infra_gals_gps2conn_rx sleep protect en
                                     0: conn_infra_gals_gps2conn_rx sleep protect en depends on disable control or hardware
    CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS[5] - (RW) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_gps2conn_rx sleep protect disable
                                     0: conn_infra_gals_gps2conn_rx  sleep protect will control by hardware
    CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_EN[6] - (RO) 1: force conn_infra_gals_gps2conn_rx sleep protect en
                                     0: conn_infra_gals_gps2conn_rx sleep protect en depends on disable control or hardware
    CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS[7] - (RO) if force en == 1'b0 (SE_EN == 1'b0)
                                     1: conn_infra_gals_gps2conn_rx sleep protect disable
                                     0: conn_infra_gals_gps2conn_rx  sleep protect will control by hardware
    GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN[8] - (RW) timeout function enable
                                     1: enable
                                     0: disable
    GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9] - (RW) clear timeout irq, write 1 to clear, and need to write 0 after write 1
    GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10] - (RW) timeout timing set, count with 32k clock
    GPS2CONN_GALS_SLPPROT_CTRL_FSM_RST[16] - (RW) fsm_reset, 1:reset, 0: release
    GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE[17] - (RW) tx sleep protect en mode, 1: sw mode, 0: hw mode
    GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18] - (RW) tx sleep protect sw ctrl
    GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE[19] - (RW) rx sleep protect en mode, 1: sw mode, 0: hw mode
    GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20] - (RW) rx sleep protect sw ctrl
    GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE[21] - (RW) tx sleep protect rdy mode, 1: sw mode, 0: hw mode
    GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22] - (RW) tx sleep protect rdy sw ctrl
    GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK[23] - (RW) tx sleep protect rdy mask
    GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE[24] - (RW) rx sleep protect rdy mode, 1: sw mode, 0: hw mode
    GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25] - (RW) rx sleep protect rdy sw ctrl
    GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK[26] - (RW) rx sleep protect rdy mask
    GPS2CONN_GALS_SLPPROT_CTRL_MODE[27] - (RW) gals sleep protect mode, 1: sw, 0: hw
    GPS2CONN_GALS_SLPPROT_CTRL_SW_EN[28] - (RW) sleep protect sw en
    GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29] - (RW) hw enable signal  0 mask
    GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30] - (RW) hw enable signal  1 mask
    GPS2CONN_GALS_SLPPROT_CTRL_DUMMY[31] - (RW)  xxx 

 =====================================================================================*/
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_DUMMY_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_DUMMY_MASK 0x80000000                // GPS2CONN_GALS_SLPPROT_CTRL_DUMMY[31]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_DUMMY_SHFT 31
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK_MASK 0x40000000                // GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK[30]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_1_MASK_SHFT 30
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK_MASK 0x20000000                // GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK[29]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_HW_EN_0_MASK_SHFT 29
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_SW_EN_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_SW_EN_MASK 0x10000000                // GPS2CONN_GALS_SLPPROT_CTRL_SW_EN[28]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_SW_EN_SHFT 28
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_MODE_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_MODE_MASK 0x08000000                // GPS2CONN_GALS_SLPPROT_CTRL_MODE[27]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_MODE_SHFT 27
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK_MASK 0x04000000                // GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK[26]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MASK_SHFT 26
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_MASK 0x02000000                // GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL[25]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_SW_CTRL_SHFT 25
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE_MASK 0x01000000                // GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE[24]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_RDY_MODE_SHFT 24
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK_MASK 0x00800000                // GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK[23]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MASK_SHFT 23
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_MASK 0x00400000                // GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL[22]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_SW_CTRL_SHFT 22
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE_MASK 0x00200000                // GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE[21]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_RDY_MODE_SHFT 21
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_MASK 0x00100000                // GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL[20]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_SW_CTRL_SHFT 20
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE_MASK 0x00080000                // GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE[19]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_RX_EN_MODE_SHFT 19
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_MASK 0x00040000                // GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL[18]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_SW_CTRL_SHFT 18
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE_MASK 0x00020000                // GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE[17]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TX_EN_MODE_SHFT 17
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_FSM_RST_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_FSM_RST_MASK 0x00010000                // GPS2CONN_GALS_SLPPROT_CTRL_FSM_RST[16]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_FSM_RST_SHFT 16
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME_MASK 0x0000FC00                // GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME[15..10]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_TIME_SHFT 10
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR_MASK 0x00000200                // GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR[9]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_CLR_SHFT 9
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN_MASK 0x00000100                // GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN[8]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_GPS2CONN_GALS_SLPPROT_CTRL_TIMEOUT_EN_SHFT 8
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000080                // CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS[7]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS_SHFT 7
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000040                // CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_EN[6]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_RX_SLP_PROT_SW_EN_SHFT 6
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS_MASK 0x00000020                // CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS[5]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_DIS_SHFT 5
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_EN_MASK 0x00000010                // CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_EN[4]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_EN_SHFT 4
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000008                // CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS[3]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS_SHFT 3
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000004                // CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_EN[2]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CSR_GPS2CONN_GALS_TX_SLP_PROT_SW_EN_SHFT 2
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS_MASK 0x00000002                // CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS[1]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_DIS_SHFT 1
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_EN_ADDR CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_EN_MASK 0x00000001                // CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_EN[0]
#define CONN_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_EN_SHFT 0

/* =====================================================================================

  ---GALS_GPS2CONN_SLP_STATUS (0x18001000 + 0x584)---

    RESERVED0[11..0]             - (RO) Reserved bits
    GPS2CONN_GALS_CTRL_DIS_TIMEOUT[12] - (RO) gps2conn gals sleep protect contorol sleep protect disable timeout
    GPS2CONN_GALS_CTRL_EN_TIMEOUT[13] - (RO) gps2conn gals sleep protect contorol sleep protect enable timeout
    RESERVED14[14]               - (RO) Reserved bits
    GPS2CONN_GALS_CTRL_TIMEOUT[15] - (RO) gps2conn gals sleep protect contorol timeout
    RESERVED16[18..16]           - (RO) Reserved bits
    GPS2CONN_GALS_CTRL_PROT_RDY_OUT[19] - (RO) gps2conn gals sleep protect control protect ready
    RESERVED20[21..20]           - (RO) Reserved bits
    GPS2CONN_GALS_CTRL_PROT_RX_RDY[22] - (RO) gps2conn gals sleep protect rx ready
    GPS2CONN_GALS_CTRL_PROT_TX_RDY[23] - (RO) gps2conn gals sleep protect tx ready
    RESERVED24[27..24]           - (RO) Reserved bits
    GPS2CONN_GALS_CTRL_PROT_RX_EN[28] - (RO) gps2conn gals sleep protect control sleep protect rx enable
    GPS2CONN_GALS_CTRL_PROT_TX_EN[29] - (RO) gps2conn gals sleep protect control sleep protect tx enable
    RESERVED30[30]               - (RO) Reserved bits
    GPS2CONN_GALS_CTRL_PROT_EN[31] - (RO) gps2conn gals sleep protect control sleep protect enable

 =====================================================================================*/
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_EN_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_EN_MASK 0x80000000                // GPS2CONN_GALS_CTRL_PROT_EN[31]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_EN_SHFT 31
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_TX_EN_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_TX_EN_MASK 0x20000000                // GPS2CONN_GALS_CTRL_PROT_TX_EN[29]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_TX_EN_SHFT 29
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RX_EN_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RX_EN_MASK 0x10000000                // GPS2CONN_GALS_CTRL_PROT_RX_EN[28]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RX_EN_SHFT 28
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_TX_RDY_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_TX_RDY_MASK 0x00800000                // GPS2CONN_GALS_CTRL_PROT_TX_RDY[23]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_TX_RDY_SHFT 23
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RX_RDY_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RX_RDY_MASK 0x00400000                // GPS2CONN_GALS_CTRL_PROT_RX_RDY[22]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RX_RDY_SHFT 22
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RDY_OUT_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RDY_OUT_MASK 0x00080000                // GPS2CONN_GALS_CTRL_PROT_RDY_OUT[19]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_PROT_RDY_OUT_SHFT 19
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_TIMEOUT_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_TIMEOUT_MASK 0x00008000                // GPS2CONN_GALS_CTRL_TIMEOUT[15]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_TIMEOUT_SHFT 15
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_EN_TIMEOUT_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_EN_TIMEOUT_MASK 0x00002000                // GPS2CONN_GALS_CTRL_EN_TIMEOUT[13]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_EN_TIMEOUT_SHFT 13
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_DIS_TIMEOUT_ADDR CONN_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_DIS_TIMEOUT_MASK 0x00001000                // GPS2CONN_GALS_CTRL_DIS_TIMEOUT[12]
#define CONN_CFG_GALS_GPS2CONN_SLP_STATUS_GPS2CONN_GALS_CTRL_DIS_TIMEOUT_SHFT 12

/* =====================================================================================

  ---HOST_CSR_IRQ_EN (0x18001000 + 0x600)---

    CONN_WF_B0_CR_HOST_SET_FW_OWN_IRQ_EN[0] - (RW) 1'b0 : Host set fw own irq to wf band0 disable
                                     1'b1 : Host set fw own irq to wf band0 enable
    CONN_WF_B0_CR_HOST_CLR_FW_OWN_IRQ_EN[1] - (RW) 1'b0 : Host clear fw own irq to wf band0 disable
                                     1'b1 : Host clear fw own irq to wf band0 enable
    CONN_WF_B1_CR_HOST_SET_FW_OWN_IRQ_EN[2] - (RW) 1'b0 : Host set fw own irq to wf band1 disable
                                     1'b1 : Host set fw own irq to wf band1 enable
    CONN_WF_B1_CR_HOST_CLR_FW_OWN_IRQ_EN[3] - (RW) 1'b0 : Host clear fw own irq to wf band1 disable
                                     1'b1 : Host clear fw own irq to wf band1 enable
    CONN_CR_MD_SET_FW_OWN_IRQ_EN[4] - (RW)  xxx 
    CONN_CR_MD_CLR_FW_OWN_IRQ_EN[5] - (RW)  xxx 
    CONN_BGF_CR_HOST_SET_FW_OWN_IRQ_EN[6] - (RW) 1'b0 : Host set fw own irq to bgf disable
                                     1'b1 : Host set fw own irq to bgf enable
    CONN_BGF_CR_HOST_CLR_FW_OWN_IRQ_EN[7] - (RW) 1'b0 : Host clear fw own irq to bgf disable
                                     1'b1 : Host clear fw own irq to bgf enable
    CONN_GPS_CR_HOST_SET_FW_OWN_IRQ_EN[8] - (RW) 1'b0 : Host set fw own irq to wf1 band0 disable
                                     1'b1 : Host set fw own irq to wf1 band0 enable
    CONN_GPS_CR_HOST_CLR_FW_OWN_IRQ_EN[9] - (RW) 1'b0 : Host clear fw own irq to wf1 band0 disable
                                     1'b1 : Host clear fw own irq to wf1 band0 enable
    RESERVED10[31..10]           - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_GPS_CR_HOST_CLR_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_GPS_CR_HOST_CLR_FW_OWN_IRQ_EN_MASK 0x00000200                // CONN_GPS_CR_HOST_CLR_FW_OWN_IRQ_EN[9]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_GPS_CR_HOST_CLR_FW_OWN_IRQ_EN_SHFT 9
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_GPS_CR_HOST_SET_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_GPS_CR_HOST_SET_FW_OWN_IRQ_EN_MASK 0x00000100                // CONN_GPS_CR_HOST_SET_FW_OWN_IRQ_EN[8]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_GPS_CR_HOST_SET_FW_OWN_IRQ_EN_SHFT 8
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_BGF_CR_HOST_CLR_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_BGF_CR_HOST_CLR_FW_OWN_IRQ_EN_MASK 0x00000080                // CONN_BGF_CR_HOST_CLR_FW_OWN_IRQ_EN[7]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_BGF_CR_HOST_CLR_FW_OWN_IRQ_EN_SHFT 7
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_BGF_CR_HOST_SET_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_BGF_CR_HOST_SET_FW_OWN_IRQ_EN_MASK 0x00000040                // CONN_BGF_CR_HOST_SET_FW_OWN_IRQ_EN[6]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_BGF_CR_HOST_SET_FW_OWN_IRQ_EN_SHFT 6
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_CR_MD_CLR_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_CR_MD_CLR_FW_OWN_IRQ_EN_MASK 0x00000020                // CONN_CR_MD_CLR_FW_OWN_IRQ_EN[5]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_CR_MD_CLR_FW_OWN_IRQ_EN_SHFT 5
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_CR_MD_SET_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_CR_MD_SET_FW_OWN_IRQ_EN_MASK 0x00000010                // CONN_CR_MD_SET_FW_OWN_IRQ_EN[4]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_CR_MD_SET_FW_OWN_IRQ_EN_SHFT 4
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B1_CR_HOST_CLR_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B1_CR_HOST_CLR_FW_OWN_IRQ_EN_MASK 0x00000008                // CONN_WF_B1_CR_HOST_CLR_FW_OWN_IRQ_EN[3]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B1_CR_HOST_CLR_FW_OWN_IRQ_EN_SHFT 3
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B1_CR_HOST_SET_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B1_CR_HOST_SET_FW_OWN_IRQ_EN_MASK 0x00000004                // CONN_WF_B1_CR_HOST_SET_FW_OWN_IRQ_EN[2]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B1_CR_HOST_SET_FW_OWN_IRQ_EN_SHFT 2
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B0_CR_HOST_CLR_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B0_CR_HOST_CLR_FW_OWN_IRQ_EN_MASK 0x00000002                // CONN_WF_B0_CR_HOST_CLR_FW_OWN_IRQ_EN[1]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B0_CR_HOST_CLR_FW_OWN_IRQ_EN_SHFT 1
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B0_CR_HOST_SET_FW_OWN_IRQ_EN_ADDR CONN_CFG_HOST_CSR_IRQ_EN_ADDR
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B0_CR_HOST_SET_FW_OWN_IRQ_EN_MASK 0x00000001                // CONN_WF_B0_CR_HOST_SET_FW_OWN_IRQ_EN[0]
#define CONN_CFG_HOST_CSR_IRQ_EN_CONN_WF_B0_CR_HOST_SET_FW_OWN_IRQ_EN_SHFT 0

/* =====================================================================================

  ---CSR_BGF_ON_FW_OWN_IRQ (0x18001000 + 0x604)---

    CSR_BGF_ON_FW_OWN_IRQ[0]     - (W1C) Fw write 1 to generate irq to host (bgf)
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_BGF_ON_FW_OWN_IRQ_CSR_BGF_ON_FW_OWN_IRQ_ADDR CONN_CFG_CSR_BGF_ON_FW_OWN_IRQ_ADDR
#define CONN_CFG_CSR_BGF_ON_FW_OWN_IRQ_CSR_BGF_ON_FW_OWN_IRQ_MASK 0x00000001                // CSR_BGF_ON_FW_OWN_IRQ[0]
#define CONN_CFG_CSR_BGF_ON_FW_OWN_IRQ_CSR_BGF_ON_FW_OWN_IRQ_SHFT 0

/* =====================================================================================

  ---CSR_MD_ON_IRQ_STATUS (0x18001000 + 0x610)---

    CONN_MD_HOST_SET_FW_OWN_STS[0] - (W1C)  xxx 
    CONN_MD_HOST_CLR_FW_OWN_STS[1] - (W1C)  xxx 
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_MD_ON_IRQ_STATUS_CONN_MD_HOST_CLR_FW_OWN_STS_ADDR CONN_CFG_CSR_MD_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_MD_ON_IRQ_STATUS_CONN_MD_HOST_CLR_FW_OWN_STS_MASK 0x00000002                // CONN_MD_HOST_CLR_FW_OWN_STS[1]
#define CONN_CFG_CSR_MD_ON_IRQ_STATUS_CONN_MD_HOST_CLR_FW_OWN_STS_SHFT 1
#define CONN_CFG_CSR_MD_ON_IRQ_STATUS_CONN_MD_HOST_SET_FW_OWN_STS_ADDR CONN_CFG_CSR_MD_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_MD_ON_IRQ_STATUS_CONN_MD_HOST_SET_FW_OWN_STS_MASK 0x00000001                // CONN_MD_HOST_SET_FW_OWN_STS[0]
#define CONN_CFG_CSR_MD_ON_IRQ_STATUS_CONN_MD_HOST_SET_FW_OWN_STS_SHFT 0

/* =====================================================================================

  ---CSR_MD_ON_HOST_CSR_MISC (0x18001000 + 0x614)---

    CONN_MD_HOST_LPCR_FW_OWN[0]  - (W1C)  xxx 
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_MD_ON_HOST_CSR_MISC_CONN_MD_HOST_LPCR_FW_OWN_ADDR CONN_CFG_CSR_MD_ON_HOST_CSR_MISC_ADDR
#define CONN_CFG_CSR_MD_ON_HOST_CSR_MISC_CONN_MD_HOST_LPCR_FW_OWN_MASK 0x00000001                // CONN_MD_HOST_LPCR_FW_OWN[0]
#define CONN_CFG_CSR_MD_ON_HOST_CSR_MISC_CONN_MD_HOST_LPCR_FW_OWN_SHFT 0

/* =====================================================================================

  ---CSR_WF_B0_ON_IRQ_STATUS (0x18001000 + 0x620)---

    CONN_WF_B0_HOST_SET_FW_OWN_STS[0] - (W1C) Fw write 1 to clr irq which cause by host set fw own to wf band0
    CONN_WF_B0_HOST_CLR_FW_OWN_STS[1] - (W1C) Fw write 1 to clr irq which cause by host clr fw own to wf band0
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_CONN_WF_B0_HOST_CLR_FW_OWN_STS_ADDR CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_CONN_WF_B0_HOST_CLR_FW_OWN_STS_MASK 0x00000002                // CONN_WF_B0_HOST_CLR_FW_OWN_STS[1]
#define CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_CONN_WF_B0_HOST_CLR_FW_OWN_STS_SHFT 1
#define CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_CONN_WF_B0_HOST_SET_FW_OWN_STS_ADDR CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_CONN_WF_B0_HOST_SET_FW_OWN_STS_MASK 0x00000001                // CONN_WF_B0_HOST_SET_FW_OWN_STS[0]
#define CONN_CFG_CSR_WF_B0_ON_IRQ_STATUS_CONN_WF_B0_HOST_SET_FW_OWN_STS_SHFT 0

/* =====================================================================================

  ---CSR_WF_B0_ON_HOST_CSR_MISC (0x18001000 + 0x624)---

    CONN_WF_B0_HOST_LPCR_FW_OWN[0] - (W1C) Fw write 1 to set driver own state cr (band0) and generate irq to host
                                     Fw could read this cr to check state
                                     1'b0:Driver own
                                     1'b1:Fw own
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_WF_B0_ON_HOST_CSR_MISC_CONN_WF_B0_HOST_LPCR_FW_OWN_ADDR CONN_CFG_CSR_WF_B0_ON_HOST_CSR_MISC_ADDR
#define CONN_CFG_CSR_WF_B0_ON_HOST_CSR_MISC_CONN_WF_B0_HOST_LPCR_FW_OWN_MASK 0x00000001                // CONN_WF_B0_HOST_LPCR_FW_OWN[0]
#define CONN_CFG_CSR_WF_B0_ON_HOST_CSR_MISC_CONN_WF_B0_HOST_LPCR_FW_OWN_SHFT 0

/* =====================================================================================

  ---CSR_WF_B1_ON_IRQ_STATUS (0x18001000 + 0x630)---

    CONN_WF_B1_HOST_SET_FW_OWN_STS[0] - (W1C) Fw write 1 to clr irq which cause by host set fw own to wf band1
    CONN_WF_B1_HOST_CLR_FW_OWN_STS[1] - (W1C) Fw write 1 to clr irq which cause by host clr fw own to wf band1
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_CONN_WF_B1_HOST_CLR_FW_OWN_STS_ADDR CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_CONN_WF_B1_HOST_CLR_FW_OWN_STS_MASK 0x00000002                // CONN_WF_B1_HOST_CLR_FW_OWN_STS[1]
#define CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_CONN_WF_B1_HOST_CLR_FW_OWN_STS_SHFT 1
#define CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_CONN_WF_B1_HOST_SET_FW_OWN_STS_ADDR CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_CONN_WF_B1_HOST_SET_FW_OWN_STS_MASK 0x00000001                // CONN_WF_B1_HOST_SET_FW_OWN_STS[0]
#define CONN_CFG_CSR_WF_B1_ON_IRQ_STATUS_CONN_WF_B1_HOST_SET_FW_OWN_STS_SHFT 0

/* =====================================================================================

  ---CSR_WF_B1_ON_HOST_CSR_MISC (0x18001000 + 0x634)---

    CONN_WF_B1_HOST_LPCR_FW_OWN[0] - (W1C) Fw write 1 to set driver own state cr (band1) and generate irq to host
                                     Fw could read this cr to check state
                                     1'b0:Driver own
                                     1'b1:Fw own
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_WF_B1_ON_HOST_CSR_MISC_CONN_WF_B1_HOST_LPCR_FW_OWN_ADDR CONN_CFG_CSR_WF_B1_ON_HOST_CSR_MISC_ADDR
#define CONN_CFG_CSR_WF_B1_ON_HOST_CSR_MISC_CONN_WF_B1_HOST_LPCR_FW_OWN_MASK 0x00000001                // CONN_WF_B1_HOST_LPCR_FW_OWN[0]
#define CONN_CFG_CSR_WF_B1_ON_HOST_CSR_MISC_CONN_WF_B1_HOST_LPCR_FW_OWN_SHFT 0

/* =====================================================================================

  ---CSR_BGF_ON_IRQ_STATUS (0x18001000 + 0x640)---

    CONN_BGF_HOST_SET_FW_OWN_STS[0] - (W1C) Fw write 1 to clr irq which cause by host set fw own to bgf
    CONN_BGF_HOST_CLR_FW_OWN_STS[1] - (W1C) Fw write 1 to clr irq which cause by host clr fw own to bgf
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_BGF_ON_IRQ_STATUS_CONN_BGF_HOST_CLR_FW_OWN_STS_ADDR CONN_CFG_CSR_BGF_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_BGF_ON_IRQ_STATUS_CONN_BGF_HOST_CLR_FW_OWN_STS_MASK 0x00000002                // CONN_BGF_HOST_CLR_FW_OWN_STS[1]
#define CONN_CFG_CSR_BGF_ON_IRQ_STATUS_CONN_BGF_HOST_CLR_FW_OWN_STS_SHFT 1
#define CONN_CFG_CSR_BGF_ON_IRQ_STATUS_CONN_BGF_HOST_SET_FW_OWN_STS_ADDR CONN_CFG_CSR_BGF_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_BGF_ON_IRQ_STATUS_CONN_BGF_HOST_SET_FW_OWN_STS_MASK 0x00000001                // CONN_BGF_HOST_SET_FW_OWN_STS[0]
#define CONN_CFG_CSR_BGF_ON_IRQ_STATUS_CONN_BGF_HOST_SET_FW_OWN_STS_SHFT 0

/* =====================================================================================

  ---CSR_BGF_ON_HOST_CSR_MISC (0x18001000 + 0x644)---

    CONN_BGF_HOST_LPCR_FW_OWN[0] - (W1C) Fw write 1 to set driver own state cr (bgf) and generate irq to host
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_BGF_ON_HOST_CSR_MISC_CONN_BGF_HOST_LPCR_FW_OWN_ADDR CONN_CFG_CSR_BGF_ON_HOST_CSR_MISC_ADDR
#define CONN_CFG_CSR_BGF_ON_HOST_CSR_MISC_CONN_BGF_HOST_LPCR_FW_OWN_MASK 0x00000001                // CONN_BGF_HOST_LPCR_FW_OWN[0]
#define CONN_CFG_CSR_BGF_ON_HOST_CSR_MISC_CONN_BGF_HOST_LPCR_FW_OWN_SHFT 0

/* =====================================================================================

  ---CSR_GPS_ON_IRQ_STATUS (0x18001000 + 0x650)---

    CONN_GPS_HOST_SET_FW_OWN_STS[0] - (W1C) Fw write 1 to clr irq which cause by host set fw own to gps
    CONN_GPS_HOST_CLR_FW_OWN_STS[1] - (W1C) Fw write 1 to clr irq which cause by host clr fw own to gps
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_GPS_ON_IRQ_STATUS_CONN_GPS_HOST_CLR_FW_OWN_STS_ADDR CONN_CFG_CSR_GPS_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_GPS_ON_IRQ_STATUS_CONN_GPS_HOST_CLR_FW_OWN_STS_MASK 0x00000002                // CONN_GPS_HOST_CLR_FW_OWN_STS[1]
#define CONN_CFG_CSR_GPS_ON_IRQ_STATUS_CONN_GPS_HOST_CLR_FW_OWN_STS_SHFT 1
#define CONN_CFG_CSR_GPS_ON_IRQ_STATUS_CONN_GPS_HOST_SET_FW_OWN_STS_ADDR CONN_CFG_CSR_GPS_ON_IRQ_STATUS_ADDR
#define CONN_CFG_CSR_GPS_ON_IRQ_STATUS_CONN_GPS_HOST_SET_FW_OWN_STS_MASK 0x00000001                // CONN_GPS_HOST_SET_FW_OWN_STS[0]
#define CONN_CFG_CSR_GPS_ON_IRQ_STATUS_CONN_GPS_HOST_SET_FW_OWN_STS_SHFT 0

/* =====================================================================================

  ---CSR_GPS_ON_HOST_CSR_MISC (0x18001000 + 0x654)---

    CONN_GPS_HOST_LPCR_FW_OWN[0] - (W1C) Fw write 1 to set driver own state cr (gps) and generate irq to host
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define CONN_CFG_CSR_GPS_ON_HOST_CSR_MISC_CONN_GPS_HOST_LPCR_FW_OWN_ADDR CONN_CFG_CSR_GPS_ON_HOST_CSR_MISC_ADDR
#define CONN_CFG_CSR_GPS_ON_HOST_CSR_MISC_CONN_GPS_HOST_LPCR_FW_OWN_MASK 0x00000001                // CONN_GPS_HOST_LPCR_FW_OWN[0]
#define CONN_CFG_CSR_GPS_ON_HOST_CSR_MISC_CONN_GPS_HOST_LPCR_FW_OWN_SHFT 0

#ifdef __cplusplus
}
#endif

#endif // __CONN_CFG_REGS_H__
