/*
 * Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws.
 * The information contained herein is confidential and proprietary to
 * MediaTek Inc. and/or its licensors.
 * Except as otherwise provided in the applicable licensing terms with
 * MediaTek Inc. and/or its licensors, any reproduction, modification, use or
 * disclosure of MediaTek Software, and information contained herein, in whole
 * or in part, shall be strictly prohibited.
*/
//[File]            : wf_hif_dmashdl_top.h
//[Revision time]   : Mon Jul 16 10:12:38 2018
//[Description]     : This file is auto generated by CODA
//[Copyright]       : Copyright (C) 2018 Mediatek Incorportion. All rights reserved.

#ifndef __WF_HIF_DMASHDL_TOP_REGS_H__
#define __WF_HIF_DMASHDL_TOP_REGS_H__

#include "hal_common.h"

#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************************
//
//                     WF_HIF_DMASHDL_TOP CR Definitions                     
//
//****************************************************************************

#define WF_HIF_DMASHDL_TOP_BASE                                0x7C026000

#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_ADDR                   (WF_HIF_DMASHDL_TOP_BASE + 0x00) // 6000
#define WF_HIF_DMASHDL_TOP_SW_CONTROL_ADDR                     (WF_HIF_DMASHDL_TOP_BASE + 0x04) // 6004
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_ADDR               (WF_HIF_DMASHDL_TOP_BASE + 0x08) // 6008
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR                   (WF_HIF_DMASHDL_TOP_BASE + 0x0C) // 600C
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x10) // 6010
#define WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_ADDR        (WF_HIF_DMASHDL_TOP_BASE + 0x14) // 6014
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x18) // 6018
#define WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x1c) // 601C
#define WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x20) // 6020
#define WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x24) // 6024
#define WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x28) // 6028
#define WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x2C) // 602C
#define WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x30) // 6030
#define WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x34) // 6034
#define WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x38) // 6038
#define WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x3C) // 603C
#define WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x40) // 6040
#define WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x44) // 6044
#define WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x48) // 6048
#define WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x4C) // 604C
#define WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x50) // 6050
#define WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x54) // 6054
#define WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x58) // 6058
#define WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x5C) // 605C
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_ADDR                     (WF_HIF_DMASHDL_TOP_BASE + 0x70) // 6070
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_ADDR                   (WF_HIF_DMASHDL_TOP_BASE + 0x80) // 6080
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_ADDR                   (WF_HIF_DMASHDL_TOP_BASE + 0x84) // 6084
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_ADDR                    (WF_HIF_DMASHDL_TOP_BASE + 0x88) // 6088
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x8C) // 608C
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x90) // 6090
#define WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_ADDR             (WF_HIF_DMASHDL_TOP_BASE + 0x94) // 6094
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x98) // 6098
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR                (WF_HIF_DMASHDL_TOP_BASE + 0x9c) // 609C
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR         (WF_HIF_DMASHDL_TOP_BASE + 0xB0) // 60B0
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR         (WF_HIF_DMASHDL_TOP_BASE + 0xB4) // 60B4
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0xC4) // 60C4
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0xC8) // 60C8
#define WF_HIF_DMASHDL_TOP_SLOT_PERIOD_ADDR                    (WF_HIF_DMASHDL_TOP_BASE + 0xCC) // 60CC
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0xd0) // 60D0
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0xd4) // 60D4
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0xd8) // 60D8
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0xdc) // 60DC
#define WF_HIF_DMASHDL_TOP_STATUS_RD_ADDR                      (WF_HIF_DMASHDL_TOP_BASE + 0x100) // 6100
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x140) // 6140
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x144) // 6144
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x148) // 6148
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x14c) // 614C
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x150) // 6150
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x154) // 6154
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x158) // 6158
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x15C) // 615C
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x160) // 6160
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_ADDR                  (WF_HIF_DMASHDL_TOP_BASE + 0x164) // 6164
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x168) // 6168
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x16c) // 616C
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x170) // 6170
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x174) // 6174
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x178) // 6178
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_ADDR                 (WF_HIF_DMASHDL_TOP_BASE + 0x17C) // 617C
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_ADDR              (WF_HIF_DMASHDL_TOP_BASE + 0x180) // 6180
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_ADDR              (WF_HIF_DMASHDL_TOP_BASE + 0x184) // 6184
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_ADDR              (WF_HIF_DMASHDL_TOP_BASE + 0x188) // 6188
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_ADDR              (WF_HIF_DMASHDL_TOP_BASE + 0x18c) // 618C
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_ADDR              (WF_HIF_DMASHDL_TOP_BASE + 0x190) // 6190
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_ADDR              (WF_HIF_DMASHDL_TOP_BASE + 0x194) // 6194
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_ADDR              (WF_HIF_DMASHDL_TOP_BASE + 0x198) // 6198
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_ADDR              (WF_HIF_DMASHDL_TOP_BASE + 0x19c) // 619C




/* =====================================================================================

  ---WACPU_REFILL (0x7C026000 + 0x00)---

    WACPU_RETURN_PAGE_CNT[11..0] - (RW) WACPU refill page count
    RESERVED12[15..12]           - (RO) Reserved bits
    WACPU_RETRUN_QID[20..16]     - (RW) WACPU refill queue ID
    RESERVED21[23..21]           - (RO) Reserved bits
    WACPU_RETRUN_MODE[25..24]    - (RW) WACPU refill mode selection
                                     2'b00  : Return mode
                                     2'b01 : Add reservation mode(initial quota setting)
                                     2'b10 : Substrate source mode
                                     2'b11 : Add source mode
    RESERVED26[30..26]           - (RO) Reserved bits
    WACPU_EXCUTE[31]             - (WO) Excute this CR action

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_EXCUTE_ADDR      WF_HIF_DMASHDL_TOP_WACPU_REFILL_ADDR
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_EXCUTE_MASK      0x80000000                // WACPU_EXCUTE[31]
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_EXCUTE_SHFT      31
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETRUN_MODE_ADDR WF_HIF_DMASHDL_TOP_WACPU_REFILL_ADDR
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETRUN_MODE_MASK 0x03000000                // WACPU_RETRUN_MODE[25..24]
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETRUN_MODE_SHFT 24
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETRUN_QID_ADDR  WF_HIF_DMASHDL_TOP_WACPU_REFILL_ADDR
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETRUN_QID_MASK  0x001F0000                // WACPU_RETRUN_QID[20..16]
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETRUN_QID_SHFT  16
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETURN_PAGE_CNT_ADDR WF_HIF_DMASHDL_TOP_WACPU_REFILL_ADDR
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETURN_PAGE_CNT_MASK 0x00000FFF                // WACPU_RETURN_PAGE_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_WACPU_REFILL_WACPU_RETURN_PAGE_CNT_SHFT 0

/* =====================================================================================

  ---SW_CONTROL (0x7C026000 + 0x04)---

    SW_LOG_RESET[0]              - (RW) SW reset logic function action
    RESERVED1[27..1]             - (RO) Reserved bits
    DMASHDL_BYPASS[28]           - (RW) DMASHDL host ask and quota control function bypass
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_SW_CONTROL_DMASHDL_BYPASS_ADDR      WF_HIF_DMASHDL_TOP_SW_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_SW_CONTROL_DMASHDL_BYPASS_MASK      0x10000000                // DMASHDL_BYPASS[28]
#define WF_HIF_DMASHDL_TOP_SW_CONTROL_DMASHDL_BYPASS_SHFT      28
#define WF_HIF_DMASHDL_TOP_SW_CONTROL_SW_LOG_RESET_ADDR        WF_HIF_DMASHDL_TOP_SW_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_SW_CONTROL_SW_LOG_RESET_MASK        0x00000001                // SW_LOG_RESET[0]
#define WF_HIF_DMASHDL_TOP_SW_CONTROL_SW_LOG_RESET_SHFT        0

/* =====================================================================================

  ---OPTIONAL_CONTROL (0x7C026000 + 0x08)---

    CR_HIF_GUP_ACT_MAP[15..0]    - (RW) Group active mapping to joint the hif ask round robin setting in hif_ack_cnt_th period.
                                     Bit 0: group 0 joint active setting (1: joint, 0: disjoint)
                                     Bit 1: group 1 joint active setting (1: joint, 0: disjoint)
                                     Bit 2: group 2 joint active setting (1: joint, 0: disjoint)
                                     Bit 3: group 3 joint active setting (1: joint, 0: disjoint)
                                     Bit 4: group 4 joint active setting (1: joint, 0: disjoint)
                                     Bit 5: group 5 joint active setting (1: joint, 0: disjoint)
                                     Bit 6: group 6 joint active setting (1: joint, 0: disjoint)
                                     Bit 7: group 7 joint active setting (1: joint, 0: disjoint)
                                     Bit 8: group 8 joint active setting (1: joint, 0: disjoint)
                                     Bit 9: group 9 joint active setting (1: joint, 0: disjoint)
                                     ......
                                     Bit 15: group 15 joint active setting (1: joint, 0: disjoint)
    CR_HIF_ACK_CNT_TH[23..16]    - (RW) Host ask success count threshold setting to reset initial for round robin period
    RESERVED24[27..24]           - (RO) Reserved bits
    CR_HIF_ASK_RR_ENA[28]        - (RW) HIF ask round robin like arbiter enable
    CR_HIF_ASK_MIN_RR_ENA[29]    - (RW) Source count below minimum quota check enable by round robin like arbitration
    CR_PSEBF_BL_TH2_NOBMIN_RASIGN_ENA[30] - (RW) Assignment when all TXD groups great or equal minimum quota
    CR_PSEBF_BL_TH2_CHK_DISABLE[31] - (RW) Disable PSE buffer Threshold 2 check and assignment

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_PSEBF_BL_TH2_CHK_DISABLE_ADDR WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_PSEBF_BL_TH2_CHK_DISABLE_MASK 0x80000000                // CR_PSEBF_BL_TH2_CHK_DISABLE[31]
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_PSEBF_BL_TH2_CHK_DISABLE_SHFT 31
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_PSEBF_BL_TH2_NOBMIN_RASIGN_ENA_ADDR WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_PSEBF_BL_TH2_NOBMIN_RASIGN_ENA_MASK 0x40000000                // CR_PSEBF_BL_TH2_NOBMIN_RASIGN_ENA[30]
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_PSEBF_BL_TH2_NOBMIN_RASIGN_ENA_SHFT 30
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ASK_MIN_RR_ENA_ADDR WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ASK_MIN_RR_ENA_MASK 0x20000000                // CR_HIF_ASK_MIN_RR_ENA[29]
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ASK_MIN_RR_ENA_SHFT 29
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ASK_RR_ENA_ADDR WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ASK_RR_ENA_MASK 0x10000000                // CR_HIF_ASK_RR_ENA[28]
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ASK_RR_ENA_SHFT 28
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ACK_CNT_TH_ADDR WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ACK_CNT_TH_MASK 0x00FF0000                // CR_HIF_ACK_CNT_TH[23..16]
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_ACK_CNT_TH_SHFT 16
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_GUP_ACT_MAP_ADDR WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_GUP_ACT_MAP_MASK 0x0000FFFF                // CR_HIF_GUP_ACT_MAP[15..0]
#define WF_HIF_DMASHDL_TOP_OPTIONAL_CONTROL_CR_HIF_GUP_ACT_MAP_SHFT 0

/* =====================================================================================

  ---PAGE_SETTING (0x7C026000 + 0x0C)---

    PSE_ADD_BSIZE[9..0]          - (RW) PSE(command)  packet size add extra byte count
    RESERVED10[11..10]           - (RO) Reserved bits
    PP_OFFSET_ADD_ENA[12]        - (RW) PSE(command) packet size add offset enable from packet processor
    RESERVED13[15..13]           - (RO) Reserved bits
    GROUP_SEQUENCE_ORDER_TYPE[16] - (RW) User program group sequence type control
    SLOT_TYPE_ARBITER_CONTROL[17] - (RW) Slot type arbiter control
    DUMMY_00[18]                 - (RW) Dummy_00 bit
    DUMMY_01[19]                 - (RW) Dummy_01 bit
    SRC_CNT_PRI_EN[20]           - (RW) Source count below min quota first priority check enable
    QUP_ACL_SLOT_CG_EN[21]       - (RW) Group ack then slot ID change function enable
    RESERVED22[31..22]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_QUP_ACL_SLOT_CG_EN_ADDR WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_QUP_ACL_SLOT_CG_EN_MASK 0x00200000                // QUP_ACL_SLOT_CG_EN[21]
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_QUP_ACL_SLOT_CG_EN_SHFT 21
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_SRC_CNT_PRI_EN_ADDR    WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_SRC_CNT_PRI_EN_MASK    0x00100000                // SRC_CNT_PRI_EN[20]
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_SRC_CNT_PRI_EN_SHFT    20
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_DUMMY_01_ADDR          WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_DUMMY_01_MASK          0x00080000                // DUMMY_01[19]
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_DUMMY_01_SHFT          19
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_DUMMY_00_ADDR          WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_DUMMY_00_MASK          0x00040000                // DUMMY_00[18]
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_DUMMY_00_SHFT          18
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_SLOT_TYPE_ARBITER_CONTROL_ADDR WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_SLOT_TYPE_ARBITER_CONTROL_MASK 0x00020000                // SLOT_TYPE_ARBITER_CONTROL[17]
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_SLOT_TYPE_ARBITER_CONTROL_SHFT 17
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_GROUP_SEQUENCE_ORDER_TYPE_ADDR WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_GROUP_SEQUENCE_ORDER_TYPE_MASK 0x00010000                // GROUP_SEQUENCE_ORDER_TYPE[16]
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_GROUP_SEQUENCE_ORDER_TYPE_SHFT 16
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_PP_OFFSET_ADD_ENA_ADDR WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_PP_OFFSET_ADD_ENA_MASK 0x00001000                // PP_OFFSET_ADD_ENA[12]
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_PP_OFFSET_ADD_ENA_SHFT 12
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_PSE_ADD_BSIZE_ADDR     WF_HIF_DMASHDL_TOP_PAGE_SETTING_ADDR
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_PSE_ADD_BSIZE_MASK     0x000003FF                // PSE_ADD_BSIZE[9..0]
#define WF_HIF_DMASHDL_TOP_PAGE_SETTING_PSE_ADD_BSIZE_SHFT     0

/* =====================================================================================

  ---REFILL_CONTROL (0x7C026000 + 0x10)---

    GROUP0_REFILL_PRIORITY[0]    - (RW) Group0 refill priority
    GROUP1_REFILL_PRIORITY[1]    - (RW) Group1 refill priority
    GROUP2_REFILL_PRIORITY[2]    - (RW) Group2 refill priority
    GROUP3_REFILL_PRIORITY[3]    - (RW) Group3 refill priority
    GROUP4_REFILL_PRIORITY[4]    - (RW) Group4 refill priority
    GROUP5_REFILL_PRIORITY[5]    - (RW) Group5 refill priority
    GROUP6_REFILL_PRIORITY[6]    - (RW) Group6 refill priority
    GROUP7_REFILL_PRIORITY[7]    - (RW) Group7 refill priority
    GROUP8_REFILL_PRIORITY[8]    - (RW) Group8 refill priority
    GROUP9_REFILL_PRIORITY[9]    - (RW) Group9 refill priority
    GROUP10_REFILL_PRIORITY[10]  - (RW) Group10 refill priority
    GROUP11_REFILL_PRIORITY[11]  - (RW) Group11 refill priority
    GROUP12_REFILL_PRIORITY[12]  - (RW) Group12 refill priority
    GROUP13_REFILL_PRIORITY[13]  - (RW) Group13 refill priority
    GROUP14_REFILL_PRIORITY[14]  - (RW) Group14 refill priority
    GROUP15_REFILL_PRIORITY[15]  - (RW) Group15 refill priority
    GROUP0_REFILL_DISABLE[16]    - (RW) Group0 refill control
    GROUP1_REFILL_DISABLE[17]    - (RW) Group1 refill control
    GROUP2_REFILL_DISABLE[18]    - (RW) Group2 refill control
    GROUP3_REFILL_DISABLE[19]    - (RW) Group3 refill control
    GROUP4_REFILL_DISABLE[20]    - (RW) Group4 refill control
    GROUP5_REFILL_DISABLE[21]    - (RW) Group5 refill control
    GROUP6_REFILL_DISABLE[22]    - (RW) Group6 refill control
    GROUP7_REFILL_DISABLE[23]    - (RW) Group7 refill control
    GROUP8_REFILL_DISABLE[24]    - (RW) Group8 refill control
    GROUP9_REFILL_DISABLE[25]    - (RW) Group9 refill control
    GROUP10_REFILL_DISABLE[26]   - (RW) Group10 refill control
    GROUP11_REFILL_DISABLE[27]   - (RW) Group11 refill control
    GROUP12_REFILL_DISABLE[28]   - (RW) Group12 refill control
    GROUP13_REFILL_DISABLE[29]   - (RW) Group13 refill control
    GROUP14_REFILL_DISABLE[30]   - (RW) Group14 refill control
    GROUP15_REFILL_DISABLE[31]   - (RW) Group15 refill control

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP15_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP15_REFILL_DISABLE_MASK 0x80000000                // GROUP15_REFILL_DISABLE[31]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP15_REFILL_DISABLE_SHFT 31
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP14_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP14_REFILL_DISABLE_MASK 0x40000000                // GROUP14_REFILL_DISABLE[30]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP14_REFILL_DISABLE_SHFT 30
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP13_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP13_REFILL_DISABLE_MASK 0x20000000                // GROUP13_REFILL_DISABLE[29]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP13_REFILL_DISABLE_SHFT 29
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP12_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP12_REFILL_DISABLE_MASK 0x10000000                // GROUP12_REFILL_DISABLE[28]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP12_REFILL_DISABLE_SHFT 28
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP11_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP11_REFILL_DISABLE_MASK 0x08000000                // GROUP11_REFILL_DISABLE[27]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP11_REFILL_DISABLE_SHFT 27
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP10_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP10_REFILL_DISABLE_MASK 0x04000000                // GROUP10_REFILL_DISABLE[26]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP10_REFILL_DISABLE_SHFT 26
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP9_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP9_REFILL_DISABLE_MASK 0x02000000                // GROUP9_REFILL_DISABLE[25]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP9_REFILL_DISABLE_SHFT 25
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP8_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP8_REFILL_DISABLE_MASK 0x01000000                // GROUP8_REFILL_DISABLE[24]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP8_REFILL_DISABLE_SHFT 24
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP7_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP7_REFILL_DISABLE_MASK 0x00800000                // GROUP7_REFILL_DISABLE[23]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP7_REFILL_DISABLE_SHFT 23
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP6_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP6_REFILL_DISABLE_MASK 0x00400000                // GROUP6_REFILL_DISABLE[22]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP6_REFILL_DISABLE_SHFT 22
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP5_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP5_REFILL_DISABLE_MASK 0x00200000                // GROUP5_REFILL_DISABLE[21]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP5_REFILL_DISABLE_SHFT 21
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP4_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP4_REFILL_DISABLE_MASK 0x00100000                // GROUP4_REFILL_DISABLE[20]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP4_REFILL_DISABLE_SHFT 20
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP3_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP3_REFILL_DISABLE_MASK 0x00080000                // GROUP3_REFILL_DISABLE[19]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP3_REFILL_DISABLE_SHFT 19
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP2_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP2_REFILL_DISABLE_MASK 0x00040000                // GROUP2_REFILL_DISABLE[18]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP2_REFILL_DISABLE_SHFT 18
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP1_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP1_REFILL_DISABLE_MASK 0x00020000                // GROUP1_REFILL_DISABLE[17]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP1_REFILL_DISABLE_SHFT 17
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP0_REFILL_DISABLE_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP0_REFILL_DISABLE_MASK 0x00010000                // GROUP0_REFILL_DISABLE[16]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP0_REFILL_DISABLE_SHFT 16
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP15_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP15_REFILL_PRIORITY_MASK 0x00008000                // GROUP15_REFILL_PRIORITY[15]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP15_REFILL_PRIORITY_SHFT 15
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP14_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP14_REFILL_PRIORITY_MASK 0x00004000                // GROUP14_REFILL_PRIORITY[14]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP14_REFILL_PRIORITY_SHFT 14
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP13_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP13_REFILL_PRIORITY_MASK 0x00002000                // GROUP13_REFILL_PRIORITY[13]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP13_REFILL_PRIORITY_SHFT 13
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP12_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP12_REFILL_PRIORITY_MASK 0x00001000                // GROUP12_REFILL_PRIORITY[12]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP12_REFILL_PRIORITY_SHFT 12
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP11_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP11_REFILL_PRIORITY_MASK 0x00000800                // GROUP11_REFILL_PRIORITY[11]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP11_REFILL_PRIORITY_SHFT 11
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP10_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP10_REFILL_PRIORITY_MASK 0x00000400                // GROUP10_REFILL_PRIORITY[10]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP10_REFILL_PRIORITY_SHFT 10
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP9_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP9_REFILL_PRIORITY_MASK 0x00000200                // GROUP9_REFILL_PRIORITY[9]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP9_REFILL_PRIORITY_SHFT 9
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP8_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP8_REFILL_PRIORITY_MASK 0x00000100                // GROUP8_REFILL_PRIORITY[8]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP8_REFILL_PRIORITY_SHFT 8
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP7_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP7_REFILL_PRIORITY_MASK 0x00000080                // GROUP7_REFILL_PRIORITY[7]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP7_REFILL_PRIORITY_SHFT 7
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP6_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP6_REFILL_PRIORITY_MASK 0x00000040                // GROUP6_REFILL_PRIORITY[6]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP6_REFILL_PRIORITY_SHFT 6
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP5_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP5_REFILL_PRIORITY_MASK 0x00000020                // GROUP5_REFILL_PRIORITY[5]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP5_REFILL_PRIORITY_SHFT 5
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP4_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP4_REFILL_PRIORITY_MASK 0x00000010                // GROUP4_REFILL_PRIORITY[4]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP4_REFILL_PRIORITY_SHFT 4
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP3_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP3_REFILL_PRIORITY_MASK 0x00000008                // GROUP3_REFILL_PRIORITY[3]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP3_REFILL_PRIORITY_SHFT 3
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP2_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP2_REFILL_PRIORITY_MASK 0x00000004                // GROUP2_REFILL_PRIORITY[2]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP2_REFILL_PRIORITY_SHFT 2
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP1_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP1_REFILL_PRIORITY_MASK 0x00000002                // GROUP1_REFILL_PRIORITY[1]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP1_REFILL_PRIORITY_SHFT 1
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP0_REFILL_PRIORITY_ADDR WF_HIF_DMASHDL_TOP_REFILL_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP0_REFILL_PRIORITY_MASK 0x00000001                // GROUP0_REFILL_PRIORITY[0]
#define WF_HIF_DMASHDL_TOP_REFILL_CONTROL_GROUP0_REFILL_PRIORITY_SHFT 0

/* =====================================================================================

  ---TX_PACKET_SIZE_PAGE_MAP (0x7C026000 + 0x14)---

    PACKET_SIZE_PAGE_MAP[7..0]   - (RW) PSE Packet size page map
                                     8'bxxxx_xxx1 : 32 bytes
                                     8'bxxxx_xx10 : 64 bytes
                                     8'bxxxx_x100 : 128 bytes
                                     8'bxxxx_1000 : 256 bytes
                                     8'bxxx1_0000 : 512 bytes
                                     8'bxx10_0000 : 1024 bytes
                                     8'bx100_0000 : 2048 bytes
                                     8'b1000_0000 : 4096 bytes
    CR_PSE_LEN_MAP_SEL[8]        - (RW) Enable pse packet length page mapping by CR Packet size page map or not
    RESERVED9[31..9]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_CR_PSE_LEN_MAP_SEL_ADDR WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_ADDR
#define WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_CR_PSE_LEN_MAP_SEL_MASK 0x00000100                // CR_PSE_LEN_MAP_SEL[8]
#define WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_CR_PSE_LEN_MAP_SEL_SHFT 8
#define WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_PACKET_SIZE_PAGE_MAP_ADDR WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_ADDR
#define WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_PACKET_SIZE_PAGE_MAP_MASK 0x000000FF                // PACKET_SIZE_PAGE_MAP[7..0]
#define WF_HIF_DMASHDL_TOP_TX_PACKET_SIZE_PAGE_MAP_PACKET_SIZE_PAGE_MAP_SHFT 0

/* =====================================================================================

  ---CONTROL_SIGNAL (0x7C026000 + 0x18)---

    CR_WACPU_MODE_EN[0]          - (RW) Enable to WACPU mode for store forward packet to DLM
    RESERVED1[3..1]              - (RO) Reserved bits
    WACPU_CMD_RET_PAGE_CNT[7..4] - (RW) WACPU mode, each packet in the CMD return the page count
    WACPU_TXD_RET_PAGE_CNT[11..8] - (RW) WACPU mode, each packet in the TXD return the page count
    WACPU_CMD_ASK_MAX_PAGE_CNT[15..12] - (RW) WACPU mode, CMD ask to require the maximum page count
    CR_HIF_ASK_SUB_ENA[16]       - (RW) Enable packet in substration action from HIF ask period
    CR_PLE_SUB_ENA[17]           - (RW) Enable packet in substration action from PLE
    RESERVED18[19..18]           - (RO) Reserved bits
    WACPU_TXD_ASK_MAX_PAGE_CNT[23..20] - (RW) WACPU mode, TXD ask to require the maximum page count
    WACPU_SUB_SRC_REFILL_ENA[24] - (RW) Enable terminate refill period when WACPU substrate source count to do refill action.
    WACPU_ADD_SRC_REFILL_ENA[25] - (RW) Enable terminate refill period when WACPU add source count to do refill action.
    WACPU_ADD_RES_REFILL_ENA[26] - (RW) Enable terminate refill period when WACPU add reserve count to do refill action.
    WACPU_RET_REFILL_ENA[27]     - (RW) Enable terminate refill period when WACPU release packet to do refill action.
    RESERVED28[28]               - (RO) Reserved bits
    CR_PLE_ADD_INT_REFILL_ENA[29] - (RW) Enable terminate refill period when PLE release packet to do addition.
    CR_PDMA_ADD_INT_REFILL_ENA[30] - (RW) Enable terminate refill period when packet in to do addition.
    CR_PKTIN_INT_REFILL_ENA[31]  - (RW) Enable terminate refill period when packet in to do substration.

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PKTIN_INT_REFILL_ENA_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PKTIN_INT_REFILL_ENA_MASK 0x80000000                // CR_PKTIN_INT_REFILL_ENA[31]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PKTIN_INT_REFILL_ENA_SHFT 31
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PDMA_ADD_INT_REFILL_ENA_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PDMA_ADD_INT_REFILL_ENA_MASK 0x40000000                // CR_PDMA_ADD_INT_REFILL_ENA[30]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PDMA_ADD_INT_REFILL_ENA_SHFT 30
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PLE_ADD_INT_REFILL_ENA_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PLE_ADD_INT_REFILL_ENA_MASK 0x20000000                // CR_PLE_ADD_INT_REFILL_ENA[29]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PLE_ADD_INT_REFILL_ENA_SHFT 29
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_RET_REFILL_ENA_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_RET_REFILL_ENA_MASK 0x08000000                // WACPU_RET_REFILL_ENA[27]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_RET_REFILL_ENA_SHFT 27
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_ADD_RES_REFILL_ENA_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_ADD_RES_REFILL_ENA_MASK 0x04000000                // WACPU_ADD_RES_REFILL_ENA[26]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_ADD_RES_REFILL_ENA_SHFT 26
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_ADD_SRC_REFILL_ENA_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_ADD_SRC_REFILL_ENA_MASK 0x02000000                // WACPU_ADD_SRC_REFILL_ENA[25]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_ADD_SRC_REFILL_ENA_SHFT 25
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_SUB_SRC_REFILL_ENA_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_SUB_SRC_REFILL_ENA_MASK 0x01000000                // WACPU_SUB_SRC_REFILL_ENA[24]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_SUB_SRC_REFILL_ENA_SHFT 24
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_TXD_ASK_MAX_PAGE_CNT_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_TXD_ASK_MAX_PAGE_CNT_MASK 0x00F00000                // WACPU_TXD_ASK_MAX_PAGE_CNT[23..20]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_TXD_ASK_MAX_PAGE_CNT_SHFT 20
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PLE_SUB_ENA_ADDR  WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PLE_SUB_ENA_MASK  0x00020000                // CR_PLE_SUB_ENA[17]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_PLE_SUB_ENA_SHFT  17
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_HIF_ASK_SUB_ENA_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_HIF_ASK_SUB_ENA_MASK 0x00010000                // CR_HIF_ASK_SUB_ENA[16]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_HIF_ASK_SUB_ENA_SHFT 16
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_CMD_ASK_MAX_PAGE_CNT_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_CMD_ASK_MAX_PAGE_CNT_MASK 0x0000F000                // WACPU_CMD_ASK_MAX_PAGE_CNT[15..12]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_CMD_ASK_MAX_PAGE_CNT_SHFT 12
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_TXD_RET_PAGE_CNT_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_TXD_RET_PAGE_CNT_MASK 0x00000F00                // WACPU_TXD_RET_PAGE_CNT[11..8]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_TXD_RET_PAGE_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_CMD_RET_PAGE_CNT_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_CMD_RET_PAGE_CNT_MASK 0x000000F0                // WACPU_CMD_RET_PAGE_CNT[7..4]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_WACPU_CMD_RET_PAGE_CNT_SHFT 4
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_WACPU_MODE_EN_ADDR WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_ADDR
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_WACPU_MODE_EN_MASK 0x00000001                // CR_WACPU_MODE_EN[0]
#define WF_HIF_DMASHDL_TOP_CONTROL_SIGNAL_CR_WACPU_MODE_EN_SHFT 0

/* =====================================================================================

  ---PACKET_MAX_SIZE (0x7C026000 + 0x1c)---

    PLE_PACKET_MAX_SIZE[11..0]   - (RW) PLE packet maximum page size (group 0 ~ 11)
    RESERVED12[15..12]           - (RO) Reserved bits
    PSE_PACKET_MAX_SIZE[27..16]  - (RW) PSE packet maximum page size (group 15)
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_PSE_PACKET_MAX_SIZE_ADDR WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_ADDR
#define WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_PSE_PACKET_MAX_SIZE_MASK 0x0FFF0000                // PSE_PACKET_MAX_SIZE[27..16]
#define WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_PSE_PACKET_MAX_SIZE_SHFT 16
#define WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_PLE_PACKET_MAX_SIZE_ADDR WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_ADDR
#define WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_PLE_PACKET_MAX_SIZE_MASK 0x00000FFF                // PLE_PACKET_MAX_SIZE[11..0]
#define WF_HIF_DMASHDL_TOP_PACKET_MAX_SIZE_PLE_PACKET_MAX_SIZE_SHFT 0

/* =====================================================================================

  ---GROUP0_CONTROL (0x7C026000 + 0x20)---

    GROUP0_MIN_QUOTA[11..0]      - (RW) Group0  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP0_MAX_QUOTA[27..16]     - (RW) Group0  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_GROUP0_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_GROUP0_MAX_QUOTA_MASK 0x0FFF0000                // GROUP0_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_GROUP0_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_GROUP0_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_GROUP0_MIN_QUOTA_MASK 0x00000FFF                // GROUP0_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP0_CONTROL_GROUP0_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP1_CONTROL (0x7C026000 + 0x24)---

    GROUP1_MIN_QUOTA[11..0]      - (RW) Group1  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP1_MAX_QUOTA[27..16]     - (RW) Group1  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_GROUP1_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_GROUP1_MAX_QUOTA_MASK 0x0FFF0000                // GROUP1_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_GROUP1_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_GROUP1_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_GROUP1_MIN_QUOTA_MASK 0x00000FFF                // GROUP1_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP1_CONTROL_GROUP1_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP2_CONTROL (0x7C026000 + 0x28)---

    GROUP2_MIN_QUOTA[11..0]      - (RW) Group2  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP2_MAX_QUOTA[27..16]     - (RW) Group2  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_GROUP2_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_GROUP2_MAX_QUOTA_MASK 0x0FFF0000                // GROUP2_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_GROUP2_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_GROUP2_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_GROUP2_MIN_QUOTA_MASK 0x00000FFF                // GROUP2_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP2_CONTROL_GROUP2_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP3_CONTROL (0x7C026000 + 0x2C)---

    GROUP3_MIN_QUOTA[11..0]      - (RW) Group3  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP3_MAX_QUOTA[27..16]     - (RW) Group3  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_GROUP3_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_GROUP3_MAX_QUOTA_MASK 0x0FFF0000                // GROUP3_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_GROUP3_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_GROUP3_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_GROUP3_MIN_QUOTA_MASK 0x00000FFF                // GROUP3_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP3_CONTROL_GROUP3_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP4_CONTROL (0x7C026000 + 0x30)---

    GROUP4_MIN_QUOTA[11..0]      - (RW) Group4  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP4_MAX_QUOTA[27..16]     - (RW) Group4  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_GROUP4_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_GROUP4_MAX_QUOTA_MASK 0x0FFF0000                // GROUP4_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_GROUP4_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_GROUP4_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_GROUP4_MIN_QUOTA_MASK 0x00000FFF                // GROUP4_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP4_CONTROL_GROUP4_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP5_CONTROL (0x7C026000 + 0x34)---

    GROUP5_MIN_QUOTA[11..0]      - (RW) Group5  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP5_MAX_QUOTA[27..16]     - (RW) Group5  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_GROUP5_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_GROUP5_MAX_QUOTA_MASK 0x0FFF0000                // GROUP5_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_GROUP5_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_GROUP5_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_GROUP5_MIN_QUOTA_MASK 0x00000FFF                // GROUP5_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP5_CONTROL_GROUP5_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP6_CONTROL (0x7C026000 + 0x38)---

    GROUP6_MIN_QUOTA[11..0]      - (RW) Group6  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP6_MAX_QUOTA[27..16]     - (RW) Group6  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_GROUP6_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_GROUP6_MAX_QUOTA_MASK 0x0FFF0000                // GROUP6_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_GROUP6_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_GROUP6_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_GROUP6_MIN_QUOTA_MASK 0x00000FFF                // GROUP6_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP6_CONTROL_GROUP6_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP7_CONTROL (0x7C026000 + 0x3C)---

    GROUP7_MIN_QUOTA[11..0]      - (RW) Group7  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP7_MAX_QUOTA[27..16]     - (RW) Group7  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_GROUP7_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_GROUP7_MAX_QUOTA_MASK 0x0FFF0000                // GROUP7_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_GROUP7_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_GROUP7_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_GROUP7_MIN_QUOTA_MASK 0x00000FFF                // GROUP7_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP7_CONTROL_GROUP7_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP8_CONTROL (0x7C026000 + 0x40)---

    GROUP8_MIN_QUOTA[11..0]      - (RW) Group8  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP8_MAX_QUOTA[27..16]     - (RW) Group8  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_GROUP8_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_GROUP8_MAX_QUOTA_MASK 0x0FFF0000                // GROUP8_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_GROUP8_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_GROUP8_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_GROUP8_MIN_QUOTA_MASK 0x00000FFF                // GROUP8_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP8_CONTROL_GROUP8_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP9_CONTROL (0x7C026000 + 0x44)---

    GROUP9_MIN_QUOTA[11..0]      - (RW) Group9  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP9_MAX_QUOTA[27..16]     - (RW) Group9  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_GROUP9_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_GROUP9_MAX_QUOTA_MASK 0x0FFF0000                // GROUP9_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_GROUP9_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_GROUP9_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_GROUP9_MIN_QUOTA_MASK 0x00000FFF                // GROUP9_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP9_CONTROL_GROUP9_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP10_CONTROL (0x7C026000 + 0x48)---

    GROUP10_MIN_QUOTA[11..0]     - (RW) Group10  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP10_MAX_QUOTA[27..16]    - (RW) Group10  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_GROUP10_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_GROUP10_MAX_QUOTA_MASK 0x0FFF0000                // GROUP10_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_GROUP10_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_GROUP10_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_GROUP10_MIN_QUOTA_MASK 0x00000FFF                // GROUP10_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP10_CONTROL_GROUP10_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP11_CONTROL (0x7C026000 + 0x4C)---

    GROUP11_MIN_QUOTA[11..0]     - (RW) Group11  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP11_MAX_QUOTA[27..16]    - (RW) Group11  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_GROUP11_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_GROUP11_MAX_QUOTA_MASK 0x0FFF0000                // GROUP11_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_GROUP11_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_GROUP11_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_GROUP11_MIN_QUOTA_MASK 0x00000FFF                // GROUP11_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP11_CONTROL_GROUP11_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP12_CONTROL (0x7C026000 + 0x50)---

    GROUP12_MIN_QUOTA[11..0]     - (RW) Group12  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP12_MAX_QUOTA[27..16]    - (RW) Group12  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_GROUP12_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_GROUP12_MAX_QUOTA_MASK 0x0FFF0000                // GROUP12_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_GROUP12_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_GROUP12_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_GROUP12_MIN_QUOTA_MASK 0x00000FFF                // GROUP12_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP12_CONTROL_GROUP12_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP13_CONTROL (0x7C026000 + 0x54)---

    GROUP13_MIN_QUOTA[11..0]     - (RW) Group13  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP13_MAX_QUOTA[27..16]    - (RW) Group13  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_GROUP13_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_GROUP13_MAX_QUOTA_MASK 0x0FFF0000                // GROUP13_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_GROUP13_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_GROUP13_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_GROUP13_MIN_QUOTA_MASK 0x00000FFF                // GROUP13_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP13_CONTROL_GROUP13_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP14_CONTROL (0x7C026000 + 0x58)---

    GROUP14_MIN_QUOTA[11..0]     - (RW) Group14  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP14_MAX_QUOTA[27..16]    - (RW) Group14  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_GROUP14_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_GROUP14_MAX_QUOTA_MASK 0x0FFF0000                // GROUP14_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_GROUP14_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_GROUP14_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_GROUP14_MIN_QUOTA_MASK 0x00000FFF                // GROUP14_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP14_CONTROL_GROUP14_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---GROUP15_CONTROL (0x7C026000 + 0x5C)---

    GROUP15_MIN_QUOTA[11..0]     - (RW) Group15  Minimum Quota
    RESERVED12[15..12]           - (RO) Reserved bits
    GROUP15_MAX_QUOTA[27..16]    - (RW) Group15  Maximum Quota
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_GROUP15_MAX_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_GROUP15_MAX_QUOTA_MASK 0x0FFF0000                // GROUP15_MAX_QUOTA[27..16]
#define WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_GROUP15_MAX_QUOTA_SHFT 16
#define WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_GROUP15_MIN_QUOTA_ADDR WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_ADDR
#define WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_GROUP15_MIN_QUOTA_MASK 0x00000FFF                // GROUP15_MIN_QUOTA[11..0]
#define WF_HIF_DMASHDL_TOP_GROUP15_CONTROL_GROUP15_MIN_QUOTA_SHFT 0

/* =====================================================================================

  ---STATUS_RD0 (0x7C026000 + 0x70)---

    PLE_TXD_QID_MAX2_NZERO_CNT[3..0] - (RO) Number of TXD QID[6:5] not equal zero counter from PLE return.
    HOST_TXD_QID_MAX2_NZERO_CNT[7..4] - (RO) Number of TXD QID[6:5] not equal zero counter from host send.
    CURR_TXD_CTXD_FLAG[8]        - (RO) Current TXD is cascade TXD format or not
    RESERVED9[31..9]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_CURR_TXD_CTXD_FLAG_ADDR  WF_HIF_DMASHDL_TOP_STATUS_RD0_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_CURR_TXD_CTXD_FLAG_MASK  0x00000100                // CURR_TXD_CTXD_FLAG[8]
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_CURR_TXD_CTXD_FLAG_SHFT  8
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_HOST_TXD_QID_MAX2_NZERO_CNT_ADDR WF_HIF_DMASHDL_TOP_STATUS_RD0_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_HOST_TXD_QID_MAX2_NZERO_CNT_MASK 0x000000F0                // HOST_TXD_QID_MAX2_NZERO_CNT[7..4]
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_HOST_TXD_QID_MAX2_NZERO_CNT_SHFT 4
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_PLE_TXD_QID_MAX2_NZERO_CNT_ADDR WF_HIF_DMASHDL_TOP_STATUS_RD0_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_PLE_TXD_QID_MAX2_NZERO_CNT_MASK 0x0000000F                // PLE_TXD_QID_MAX2_NZERO_CNT[3..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD0_PLE_TXD_QID_MAX2_NZERO_CNT_SHFT 0

/* =====================================================================================

  ---DEBUG_PORT00 (0x7C026000 + 0x80)---

    DEBUG_N0_SEL[0]              - (RW) Debug port n0 enable
    DEBUG_N1_SEL[1]              - (RW) Debug port n1 enable
    DEBUG_N2_SEL[2]              - (RW) Debug port n2 enable
    DEBUG_N3_SEL[3]              - (RW) Debug port n3 enable
    RESERVED4[31..4]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N3_SEL_ADDR      WF_HIF_DMASHDL_TOP_DEBUG_PORT00_ADDR
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N3_SEL_MASK      0x00000008                // DEBUG_N3_SEL[3]
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N3_SEL_SHFT      3
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N2_SEL_ADDR      WF_HIF_DMASHDL_TOP_DEBUG_PORT00_ADDR
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N2_SEL_MASK      0x00000004                // DEBUG_N2_SEL[2]
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N2_SEL_SHFT      2
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N1_SEL_ADDR      WF_HIF_DMASHDL_TOP_DEBUG_PORT00_ADDR
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N1_SEL_MASK      0x00000002                // DEBUG_N1_SEL[1]
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N1_SEL_SHFT      1
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N0_SEL_ADDR      WF_HIF_DMASHDL_TOP_DEBUG_PORT00_ADDR
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N0_SEL_MASK      0x00000001                // DEBUG_N0_SEL[0]
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT00_DEBUG_N0_SEL_SHFT      0

/* =====================================================================================

  ---DEBUG_PORT01 (0x7C026000 + 0x84)---

    DEBUG_FLAG_N0_SEL[7..0]      - (RW) Debug port n0 select
    DEBUG_FLAG_N1_SEL[15..8]     - (RW) Debug port n1 select
    DEBUG_FLAG_N2_SEL[23..16]    - (RW) Debug port n2 select
    DEBUG_FLAG_N3_SEL[31..24]    - (RW) Debug port n3 select

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N3_SEL_ADDR WF_HIF_DMASHDL_TOP_DEBUG_PORT01_ADDR
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N3_SEL_MASK 0xFF000000                // DEBUG_FLAG_N3_SEL[31..24]
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N3_SEL_SHFT 24
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N2_SEL_ADDR WF_HIF_DMASHDL_TOP_DEBUG_PORT01_ADDR
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N2_SEL_MASK 0x00FF0000                // DEBUG_FLAG_N2_SEL[23..16]
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N2_SEL_SHFT 16
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N1_SEL_ADDR WF_HIF_DMASHDL_TOP_DEBUG_PORT01_ADDR
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N1_SEL_MASK 0x0000FF00                // DEBUG_FLAG_N1_SEL[15..8]
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N1_SEL_SHFT 8
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N0_SEL_ADDR WF_HIF_DMASHDL_TOP_DEBUG_PORT01_ADDR
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N0_SEL_MASK 0x000000FF                // DEBUG_FLAG_N0_SEL[7..0]
#define WF_HIF_DMASHDL_TOP_DEBUG_PORT01_DEBUG_FLAG_N0_SEL_SHFT 0

/* =====================================================================================

  ---STATUS_RD02 (0x7C026000 + 0x88)---

    REFILL_CS[3..0]              - (RO) Refill state machine for current state
    REFILL_NS[7..4]              - (RO) Refill state machine for next state
    DMASHDL_CS[10..8]            - (RO) DMASHDL state machine for current state
    RESERVED11[11]               - (RO) Reserved bits
    DMASHDL_NS[14..12]           - (RO) DMASHDL state machine for next state
    RESERVED15[15]               - (RO) Reserved bits
    HIF_DMASHDL_DEBUG_PORT[31..16] - (RO) DMASHDL debug port signals

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_HIF_DMASHDL_DEBUG_PORT_ADDR WF_HIF_DMASHDL_TOP_STATUS_RD02_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_HIF_DMASHDL_DEBUG_PORT_MASK 0xFFFF0000                // HIF_DMASHDL_DEBUG_PORT[31..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_HIF_DMASHDL_DEBUG_PORT_SHFT 16
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_DMASHDL_NS_ADDR         WF_HIF_DMASHDL_TOP_STATUS_RD02_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_DMASHDL_NS_MASK         0x00007000                // DMASHDL_NS[14..12]
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_DMASHDL_NS_SHFT         12
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_DMASHDL_CS_ADDR         WF_HIF_DMASHDL_TOP_STATUS_RD02_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_DMASHDL_CS_MASK         0x00000700                // DMASHDL_CS[10..8]
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_DMASHDL_CS_SHFT         8
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_REFILL_NS_ADDR          WF_HIF_DMASHDL_TOP_STATUS_RD02_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_REFILL_NS_MASK          0x000000F0                // REFILL_NS[7..4]
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_REFILL_NS_SHFT          4
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_REFILL_CS_ADDR          WF_HIF_DMASHDL_TOP_STATUS_RD02_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_REFILL_CS_MASK          0x0000000F                // REFILL_CS[3..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD02_REFILL_CS_SHFT          0

/* =====================================================================================

  ---COUNTER_UDF_CLR (0x7C026000 + 0x8C)---

    FREEPG_CNT_UDF_CLR[0]        - (RW) Clear freepage count underflow flag
    FFA_CNT_UDF_CLR[1]           - (RW) Clear FFA count underflow flag
    SRC_SUB_CUR_UDF_CLR[2]       - (RW) Clear PLE return stage source count underflow flag
    REFILL_MAX1_UDF_CLR[3]       - (RW) Clear pktin return stage source count underflow flag
    REFILL_MAX0_UDF_CLR[4]       - (RW) Clear RSV add SRC count greater than maximum quota
    RSV_SUB_CURR_UDF_CLR[5]      - (RW) Clear reservation count underflow flag
    PLE_TXD_GT_MAX_SIZE_FLAG_CLR[6] - (RW) Clear PLE TXD size greater than max PLE TXD size flag
    PSE_SIZE_GT_MAX_SIZE_FLAG_CLR[7] - (RW) Clear PSE packet size greater than max packet size flag
    HIF_ASK_LONG_FLAG_CLR[8]     - (RW) Clear the HIF ask after long time period to grant flag
    PSE_RSV_UDF_CLR[9]           - (RW) Clear the HIF ask to let reservation count underflow flag
    PSE_SRC_PSERET_UDF_CLR[10]   - (RW) Clear the PSE source count PSE module return underflow flag
    PSE_SRC_PKTRET_UDF_CLR[11]   - (RW) Clear the PSE source count packet in return underflow flag
    RESERVED12[15..12]           - (RO) Reserved bits
    HIF_ASK_PKTIN_CNT_CLR[16]    - (RW) Clear the ask counters and pktin return counters for all groups
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_HIF_ASK_PKTIN_CNT_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_HIF_ASK_PKTIN_CNT_CLR_MASK 0x00010000                // HIF_ASK_PKTIN_CNT_CLR[16]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_HIF_ASK_PKTIN_CNT_CLR_SHFT 16
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SRC_PKTRET_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SRC_PKTRET_UDF_CLR_MASK 0x00000800                // PSE_SRC_PKTRET_UDF_CLR[11]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SRC_PKTRET_UDF_CLR_SHFT 11
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SRC_PSERET_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SRC_PSERET_UDF_CLR_MASK 0x00000400                // PSE_SRC_PSERET_UDF_CLR[10]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SRC_PSERET_UDF_CLR_SHFT 10
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_RSV_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_RSV_UDF_CLR_MASK 0x00000200                // PSE_RSV_UDF_CLR[9]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_RSV_UDF_CLR_SHFT 9
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_HIF_ASK_LONG_FLAG_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_HIF_ASK_LONG_FLAG_CLR_MASK 0x00000100                // HIF_ASK_LONG_FLAG_CLR[8]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_HIF_ASK_LONG_FLAG_CLR_SHFT 8
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SIZE_GT_MAX_SIZE_FLAG_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SIZE_GT_MAX_SIZE_FLAG_CLR_MASK 0x00000080                // PSE_SIZE_GT_MAX_SIZE_FLAG_CLR[7]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PSE_SIZE_GT_MAX_SIZE_FLAG_CLR_SHFT 7
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PLE_TXD_GT_MAX_SIZE_FLAG_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PLE_TXD_GT_MAX_SIZE_FLAG_CLR_MASK 0x00000040                // PLE_TXD_GT_MAX_SIZE_FLAG_CLR[6]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_PLE_TXD_GT_MAX_SIZE_FLAG_CLR_SHFT 6
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_RSV_SUB_CURR_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_RSV_SUB_CURR_UDF_CLR_MASK 0x00000020                // RSV_SUB_CURR_UDF_CLR[5]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_RSV_SUB_CURR_UDF_CLR_SHFT 5
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_REFILL_MAX0_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_REFILL_MAX0_UDF_CLR_MASK 0x00000010                // REFILL_MAX0_UDF_CLR[4]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_REFILL_MAX0_UDF_CLR_SHFT 4
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_REFILL_MAX1_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_REFILL_MAX1_UDF_CLR_MASK 0x00000008                // REFILL_MAX1_UDF_CLR[3]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_REFILL_MAX1_UDF_CLR_SHFT 3
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_SRC_SUB_CUR_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_SRC_SUB_CUR_UDF_CLR_MASK 0x00000004                // SRC_SUB_CUR_UDF_CLR[2]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_SRC_SUB_CUR_UDF_CLR_SHFT 2
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_FFA_CNT_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_FFA_CNT_UDF_CLR_MASK 0x00000002                // FFA_CNT_UDF_CLR[1]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_FFA_CNT_UDF_CLR_SHFT 1
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_FREEPG_CNT_UDF_CLR_ADDR WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_ADDR
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_FREEPG_CNT_UDF_CLR_MASK 0x00000001                // FREEPG_CNT_UDF_CLR[0]
#define WF_HIF_DMASHDL_TOP_COUNTER_UDF_CLR_FREEPG_CNT_UDF_CLR_SHFT 0

/* =====================================================================================

  ---PKT_IN_CNT_CTRL (0x7C026000 + 0x90)---

    CNT1_RET_CNT_ENA[0]          - (RW) Counter1 PLE/PSE return count enable
    CNT1_PKTIN_RET_CNT_ENA[1]    - (RW) Counter1 pktin return count enable
    CNT1_PKTIN_CNT_ENA[2]        - (RW) Counter1 pktin(ask) substrate count enable
    CNT0_RET_CNT_ENA[3]          - (RW) Counter0 PLE/PSE return count enable
    CNT0_PKTIN_RET_CNT_ENA[4]    - (RW) Counter0 pktin return count enable
    CNT0_PKTIN_CNT_ENA[5]        - (RW) Counter0 pktin(ask) substrate count enable
    RESERVED6[31..6]             - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_PKTIN_CNT_ENA_ADDR WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_PKTIN_CNT_ENA_MASK 0x00000020                // CNT0_PKTIN_CNT_ENA[5]
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_PKTIN_CNT_ENA_SHFT 5
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_PKTIN_RET_CNT_ENA_ADDR WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_PKTIN_RET_CNT_ENA_MASK 0x00000010                // CNT0_PKTIN_RET_CNT_ENA[4]
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_PKTIN_RET_CNT_ENA_SHFT 4
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_RET_CNT_ENA_ADDR WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_RET_CNT_ENA_MASK 0x00000008                // CNT0_RET_CNT_ENA[3]
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT0_RET_CNT_ENA_SHFT 3
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_PKTIN_CNT_ENA_ADDR WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_PKTIN_CNT_ENA_MASK 0x00000004                // CNT1_PKTIN_CNT_ENA[2]
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_PKTIN_CNT_ENA_SHFT 2
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_PKTIN_RET_CNT_ENA_ADDR WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_PKTIN_RET_CNT_ENA_MASK 0x00000002                // CNT1_PKTIN_RET_CNT_ENA[1]
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_PKTIN_RET_CNT_ENA_SHFT 1
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_RET_CNT_ENA_ADDR WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_RET_CNT_ENA_MASK 0x00000001                // CNT1_RET_CNT_ENA[0]
#define WF_HIF_DMASHDL_TOP_PKT_IN_CNT_CTRL_CNT1_RET_CNT_ENA_SHFT 0

/* =====================================================================================

  ---HIF_ASK_LONG_CHECK (0x7C026000 + 0x94)---

    HIF_ASK_TICK_CNT[15..0]      - (RO) HIF request ask wait period count.
    HIF_ASK_LONG_CNT_TH[31..16]  - (RW) HIF request ask wait period threshold. (unit = 32us, wf_aon_32us_tick)

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_HIF_ASK_LONG_CNT_TH_ADDR WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_HIF_ASK_LONG_CNT_TH_MASK 0xFFFF0000                // HIF_ASK_LONG_CNT_TH[31..16]
#define WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_HIF_ASK_LONG_CNT_TH_SHFT 16
#define WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_HIF_ASK_TICK_CNT_ADDR WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_HIF_ASK_TICK_CNT_MASK 0x0000FFFF                // HIF_ASK_TICK_CNT[15..0]
#define WF_HIF_DMASHDL_TOP_HIF_ASK_LONG_CHECK_HIF_ASK_TICK_CNT_SHFT 0

/* =====================================================================================

  ---CPU_QUOTA_SET (0x7C026000 + 0x98)---

    RETURN_PAGE_CNT[11..0]       - (RW) CPU refill page count
    RESERVED12[15..12]           - (RO) Reserved bits
    CPU_RETRUN_GID[19..16]       - (RW) CPU refill group's ID
    RESERVED20[23..20]           - (RO) Reserved bits
    CPU_RETRUN_MODE[25..24]      - (RW) CPU refill mode selection
                                     2'b00 : Substrate source mode
                                     2'b01  : Return mode
                                     2'b10 : Add source mode
                                     2'b11 : Substrate reservation mode
    RESERVED26[30..26]           - (RO) Reserved bits
    EXCUTE[31]                   - (WO) Excute this CR action

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_EXCUTE_ADDR           WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_ADDR
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_EXCUTE_MASK           0x80000000                // EXCUTE[31]
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_EXCUTE_SHFT           31
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_CPU_RETRUN_MODE_ADDR  WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_ADDR
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_CPU_RETRUN_MODE_MASK  0x03000000                // CPU_RETRUN_MODE[25..24]
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_CPU_RETRUN_MODE_SHFT  24
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_CPU_RETRUN_GID_ADDR   WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_ADDR
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_CPU_RETRUN_GID_MASK   0x000F0000                // CPU_RETRUN_GID[19..16]
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_CPU_RETRUN_GID_SHFT   16
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_RETURN_PAGE_CNT_ADDR  WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_ADDR
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_RETURN_PAGE_CNT_MASK  0x00000FFF                // RETURN_PAGE_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_CPU_QUOTA_SET_RETURN_PAGE_CNT_SHFT  0

/* =====================================================================================

  ---ERROR_FLAG_CTRL (0x7C026000 + 0x9c)---

    CNT_UDF_INT_DMASK[15..0]     - (RW) Underflow flag interrupt disable mask control:
                                     
                                     bit[11] : pse_src_pktret_udf_flag
                                     bit[10] : pse_src_pseret_udf_flag
                                     bit[9]   : pse_rsv_udf_flag
                                     bit[8]   : hif_ask_long_flag_flag
                                     bit[7]   : pse_size_gt_max_size_flag
                                     bit[6]   : ple_txd_gt_max_size_flag
                                     bit[5]   : rsv_sub_curr_udf_flag
                                     bit[4]   : refill_max0_udf_flag
                                     bit[3]   : refill_max1_udf_flag
                                     bit[2]   : src_sub_cur_udf_flag
                                     bit[1]   : ffa_cnt_udf_flag
                                     bit[0]   : freepg_cnt_udf_flag
    FREEPG_CNT_UDF_FLAG[16]      - (RO) Freepage count underflow flag
    FFA_CNT_UDF_FLAG[17]         - (RO) FFA count underflow flag
    SRC_SUB_CUR_UDF_FLAG[18]     - (RO) PLE return stage source count underflow flag
    REFILL_MAX1_UDF_FLAG[19]     - (RO) Pktin return stage source count underflow flag
    REFILL_MAX0_UDF_FLAG[20]     - (RO) RSV add SRC count greater than maximum quota
    RSV_SUB_CURR_UDF_FLAG[21]    - (RO) Reservation count underflow flag
    PLE_TXD_GT_MAX_SIZE_FLAG[22] - (RO) PLE txd size greater than max PLE txd size flag
    PSE_SIZE_GT_MAX_SIZE_FLAG[23] - (RO) PSE packet size greater than max packet size flag
    HIF_ASK_LONG_FLAG[24]        - (RO) The HIF ask after long time period to grant flag
    PSE_RSV_UDF_FLAG[25]         - (RO) The HIF ask to let reservation count underflow flag
    PSE_SRC_PSERET_UDF_FLAG[26]  - (RO) The PSE source count PSE module return underflow flag
    PSE_SRC_PKTRET_UDF_FLAG[27]  - (RO) The PSE source count packet in return underflow flag
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SRC_PKTRET_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SRC_PKTRET_UDF_FLAG_MASK 0x08000000                // PSE_SRC_PKTRET_UDF_FLAG[27]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SRC_PKTRET_UDF_FLAG_SHFT 27
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SRC_PSERET_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SRC_PSERET_UDF_FLAG_MASK 0x04000000                // PSE_SRC_PSERET_UDF_FLAG[26]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SRC_PSERET_UDF_FLAG_SHFT 26
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_RSV_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_RSV_UDF_FLAG_MASK 0x02000000                // PSE_RSV_UDF_FLAG[25]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_RSV_UDF_FLAG_SHFT 25
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_HIF_ASK_LONG_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_HIF_ASK_LONG_FLAG_MASK 0x01000000                // HIF_ASK_LONG_FLAG[24]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_HIF_ASK_LONG_FLAG_SHFT 24
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SIZE_GT_MAX_SIZE_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SIZE_GT_MAX_SIZE_FLAG_MASK 0x00800000                // PSE_SIZE_GT_MAX_SIZE_FLAG[23]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PSE_SIZE_GT_MAX_SIZE_FLAG_SHFT 23
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PLE_TXD_GT_MAX_SIZE_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PLE_TXD_GT_MAX_SIZE_FLAG_MASK 0x00400000                // PLE_TXD_GT_MAX_SIZE_FLAG[22]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_PLE_TXD_GT_MAX_SIZE_FLAG_SHFT 22
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_RSV_SUB_CURR_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_RSV_SUB_CURR_UDF_FLAG_MASK 0x00200000                // RSV_SUB_CURR_UDF_FLAG[21]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_RSV_SUB_CURR_UDF_FLAG_SHFT 21
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_REFILL_MAX0_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_REFILL_MAX0_UDF_FLAG_MASK 0x00100000                // REFILL_MAX0_UDF_FLAG[20]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_REFILL_MAX0_UDF_FLAG_SHFT 20
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_REFILL_MAX1_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_REFILL_MAX1_UDF_FLAG_MASK 0x00080000                // REFILL_MAX1_UDF_FLAG[19]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_REFILL_MAX1_UDF_FLAG_SHFT 19
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_SRC_SUB_CUR_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_SRC_SUB_CUR_UDF_FLAG_MASK 0x00040000                // SRC_SUB_CUR_UDF_FLAG[18]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_SRC_SUB_CUR_UDF_FLAG_SHFT 18
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_FFA_CNT_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_FFA_CNT_UDF_FLAG_MASK 0x00020000                // FFA_CNT_UDF_FLAG[17]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_FFA_CNT_UDF_FLAG_SHFT 17
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_FREEPG_CNT_UDF_FLAG_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_FREEPG_CNT_UDF_FLAG_MASK 0x00010000                // FREEPG_CNT_UDF_FLAG[16]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_FREEPG_CNT_UDF_FLAG_SHFT 16
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_CNT_UDF_INT_DMASK_ADDR WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_ADDR
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_CNT_UDF_INT_DMASK_MASK 0x0000FFFF                // CNT_UDF_INT_DMASK[15..0]
#define WF_HIF_DMASHDL_TOP_ERROR_FLAG_CTRL_CNT_UDF_INT_DMASK_SHFT 0

/* =====================================================================================

  ---HIF_SCHEDULER_SETTING0 (0x7C026000 + 0xB0)---

    PRIORITY0_GROUP[3..0]        - (RW) Which group is priority 0, this group is highest priority
    PRIORITY1_GROUP[7..4]        - (RW) Which group is priority 1
    PRIORITY2_GROUP[11..8]       - (RW) Which group is priority 2
    PRIORITY3_GROUP[15..12]      - (RW) Which group is priority 3
    PRIORITY4_GROUP[19..16]      - (RW) Which group is priority 4
    PRIORITY5_GROUP[23..20]      - (RW) Which group is priority 5
    PRIORITY6_GROUP[27..24]      - (RW) Which group is priority 6
    PRIORITY7_GROUP[31..28]      - (RW) Which group is priority 7

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY7_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY7_GROUP_MASK 0xF0000000                // PRIORITY7_GROUP[31..28]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY7_GROUP_SHFT 28
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY6_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY6_GROUP_MASK 0x0F000000                // PRIORITY6_GROUP[27..24]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY6_GROUP_SHFT 24
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY5_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY5_GROUP_MASK 0x00F00000                // PRIORITY5_GROUP[23..20]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY5_GROUP_SHFT 20
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY4_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY4_GROUP_MASK 0x000F0000                // PRIORITY4_GROUP[19..16]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY4_GROUP_SHFT 16
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY3_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY3_GROUP_MASK 0x0000F000                // PRIORITY3_GROUP[15..12]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY3_GROUP_SHFT 12
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY2_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY2_GROUP_MASK 0x00000F00                // PRIORITY2_GROUP[11..8]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY2_GROUP_SHFT 8
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY1_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY1_GROUP_MASK 0x000000F0                // PRIORITY1_GROUP[7..4]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY1_GROUP_SHFT 4
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY0_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY0_GROUP_MASK 0x0000000F                // PRIORITY0_GROUP[3..0]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING0_PRIORITY0_GROUP_SHFT 0

/* =====================================================================================

  ---HIF_SCHEDULER_SETTING1 (0x7C026000 + 0xB4)---

    PRIORITY8_GROUP[3..0]        - (RW) Which group is priority 8
    PRIORITY9_GROUP[7..4]        - (RW) Which group is priority 9
    PRIORITY10_GROUP[11..8]      - (RW) Which group is priority 10
    PRIORITY11_GROUP[15..12]     - (RW) Which group is priority 11
    PRIORITY12_GROUP[19..16]     - (RW) Which group is priority 12
    PRIORITY13_GROUP[23..20]     - (RW) Which group is priority 13
    PRIORITY14_GROUP[27..24]     - (RW) Which group is priority 14
    PRIORITY15_GROUP[31..28]     - (RW) Which group is priority 15, this group is last priority

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY15_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY15_GROUP_MASK 0xF0000000                // PRIORITY15_GROUP[31..28]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY15_GROUP_SHFT 28
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY14_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY14_GROUP_MASK 0x0F000000                // PRIORITY14_GROUP[27..24]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY14_GROUP_SHFT 24
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY13_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY13_GROUP_MASK 0x00F00000                // PRIORITY13_GROUP[23..20]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY13_GROUP_SHFT 20
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY12_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY12_GROUP_MASK 0x000F0000                // PRIORITY12_GROUP[19..16]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY12_GROUP_SHFT 16
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY11_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY11_GROUP_MASK 0x0000F000                // PRIORITY11_GROUP[15..12]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY11_GROUP_SHFT 12
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY10_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY10_GROUP_MASK 0x00000F00                // PRIORITY10_GROUP[11..8]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY10_GROUP_SHFT 8
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY9_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY9_GROUP_MASK 0x000000F0                // PRIORITY9_GROUP[7..4]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY9_GROUP_SHFT 4
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY8_GROUP_ADDR WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY8_GROUP_MASK 0x0000000F                // PRIORITY8_GROUP[3..0]
#define WF_HIF_DMASHDL_TOP_HIF_SCHEDULER_SETTING1_PRIORITY8_GROUP_SHFT 0

/* =====================================================================================

  ---SLOT_SETTING0 (0x7C026000 + 0xC4)---

    SLOT_0_SETTING[3..0]         - (RW) Slot0 priority setting
    SLOT_1_SETTING[7..4]         - (RW) Slot1 priority setting
    SLOT_2_SETTING[11..8]        - (RW) Slot2 priority setting
    SLOT_3_SETTING[15..12]       - (RW) Slot3 priority setting
    SLOT_4_SETTING[19..16]       - (RW) Slot4 priority setting
    SLOT_5_SETTING[23..20]       - (RW) Slot5 priority setting
    SLOT_6_SETTING[27..24]       - (RW) Slot6 priority setting
    SLOT_7_SETTING[31..28]       - (RW) Slot7 priority setting(which group ID)

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_7_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_7_SETTING_MASK   0xF0000000                // SLOT_7_SETTING[31..28]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_7_SETTING_SHFT   28
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_6_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_6_SETTING_MASK   0x0F000000                // SLOT_6_SETTING[27..24]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_6_SETTING_SHFT   24
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_5_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_5_SETTING_MASK   0x00F00000                // SLOT_5_SETTING[23..20]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_5_SETTING_SHFT   20
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_4_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_4_SETTING_MASK   0x000F0000                // SLOT_4_SETTING[19..16]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_4_SETTING_SHFT   16
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_3_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_3_SETTING_MASK   0x0000F000                // SLOT_3_SETTING[15..12]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_3_SETTING_SHFT   12
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_2_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_2_SETTING_MASK   0x00000F00                // SLOT_2_SETTING[11..8]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_2_SETTING_SHFT   8
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_1_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_1_SETTING_MASK   0x000000F0                // SLOT_1_SETTING[7..4]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_1_SETTING_SHFT   4
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_0_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING0_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_0_SETTING_MASK   0x0000000F                // SLOT_0_SETTING[3..0]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING0_SLOT_0_SETTING_SHFT   0

/* =====================================================================================

  ---SLOT_SETTING1 (0x7C026000 + 0xC8)---

    SLOT_8_SETTING[3..0]         - (RW) Slot8 priority setting
    SLOT_9_SETTING[7..4]         - (RW) Slot9 priority setting
    SLOT_10_SETTING[11..8]       - (RW) Slot10 priority setting
    SLOT_11_SETTING[15..12]      - (RW) Slo11 priority setting
    SLOT_12_SETTING[19..16]      - (RW) Slot12 priority setting
    SLOT_13_SETTING[23..20]      - (RW) Slot13 priority setting
    SLOT_14_SETTING[27..24]      - (RW) Slot14 priority setting
    SLOT_15_SETTING[31..28]      - (RW) Slot15 priority setting(which group ID)

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_15_SETTING_ADDR  WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_15_SETTING_MASK  0xF0000000                // SLOT_15_SETTING[31..28]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_15_SETTING_SHFT  28
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_14_SETTING_ADDR  WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_14_SETTING_MASK  0x0F000000                // SLOT_14_SETTING[27..24]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_14_SETTING_SHFT  24
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_13_SETTING_ADDR  WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_13_SETTING_MASK  0x00F00000                // SLOT_13_SETTING[23..20]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_13_SETTING_SHFT  20
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_12_SETTING_ADDR  WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_12_SETTING_MASK  0x000F0000                // SLOT_12_SETTING[19..16]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_12_SETTING_SHFT  16
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_11_SETTING_ADDR  WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_11_SETTING_MASK  0x0000F000                // SLOT_11_SETTING[15..12]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_11_SETTING_SHFT  12
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_10_SETTING_ADDR  WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_10_SETTING_MASK  0x00000F00                // SLOT_10_SETTING[11..8]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_10_SETTING_SHFT  8
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_9_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_9_SETTING_MASK   0x000000F0                // SLOT_9_SETTING[7..4]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_9_SETTING_SHFT   4
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_8_SETTING_ADDR   WF_HIF_DMASHDL_TOP_SLOT_SETTING1_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_8_SETTING_MASK   0x0000000F                // SLOT_8_SETTING[3..0]
#define WF_HIF_DMASHDL_TOP_SLOT_SETTING1_SLOT_8_SETTING_SHFT   0

/* =====================================================================================

  ---SLOT_PERIOD (0x7C026000 + 0xCC)---

    SLOT_PERIOD[15..0]           - (RW) Slot Period (clock periods)
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_SLOT_PERIOD_SLOT_PERIOD_ADDR        WF_HIF_DMASHDL_TOP_SLOT_PERIOD_ADDR
#define WF_HIF_DMASHDL_TOP_SLOT_PERIOD_SLOT_PERIOD_MASK        0x0000FFFF                // SLOT_PERIOD[15..0]
#define WF_HIF_DMASHDL_TOP_SLOT_PERIOD_SLOT_PERIOD_SHFT        0

/* =====================================================================================

  ---QUEUE_MAPPING0 (0x7C026000 + 0xd0)---

    QUEUE0_MAPPING[3..0]         - (RW) Queue 0 use which group ID
    QUEUE1_MAPPING[7..4]         - (RW) Queue 1 use which group ID
    QUEUE2_MAPPING[11..8]        - (RW) Queue 2 use which group ID
    QUEUE3_MAPPING[15..12]       - (RW) Queue 3 use which group ID
    QUEUE4_MAPPING[19..16]       - (RW) Queue 4 use which group ID
    QUEUE5_MAPPING[23..20]       - (RW) Queue 5 use which group ID
    QUEUE6_MAPPING[27..24]       - (RW) Queue 6 use which group ID
    QUEUE7_MAPPING[31..28]       - (RW) Queue 7 use which group ID

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE7_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE7_MAPPING_MASK  0xF0000000                // QUEUE7_MAPPING[31..28]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE7_MAPPING_SHFT  28
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE6_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE6_MAPPING_MASK  0x0F000000                // QUEUE6_MAPPING[27..24]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE6_MAPPING_SHFT  24
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE5_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE5_MAPPING_MASK  0x00F00000                // QUEUE5_MAPPING[23..20]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE5_MAPPING_SHFT  20
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE4_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE4_MAPPING_MASK  0x000F0000                // QUEUE4_MAPPING[19..16]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE4_MAPPING_SHFT  16
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE3_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE3_MAPPING_MASK  0x0000F000                // QUEUE3_MAPPING[15..12]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE3_MAPPING_SHFT  12
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE2_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE2_MAPPING_MASK  0x00000F00                // QUEUE2_MAPPING[11..8]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE2_MAPPING_SHFT  8
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE1_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE1_MAPPING_MASK  0x000000F0                // QUEUE1_MAPPING[7..4]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE1_MAPPING_SHFT  4
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE0_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE0_MAPPING_MASK  0x0000000F                // QUEUE0_MAPPING[3..0]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING0_QUEUE0_MAPPING_SHFT  0

/* =====================================================================================

  ---QUEUE_MAPPING1 (0x7C026000 + 0xd4)---

    QUEUE8_MAPPING[3..0]         - (RW) Queue 8 use which group ID
    QUEUE9_MAPPING[7..4]         - (RW) Queue 9 use which group ID
    QUEUE10_MAPPING[11..8]       - (RW) Queue 10 use which group ID
    QUEUE11_MAPPING[15..12]      - (RW) Queue 11 use which group ID
    QUEUE12_MAPPING[19..16]      - (RW) Queue 12 use which group ID
    QUEUE13_MAPPING[23..20]      - (RW) Queue 13 use which group ID
    QUEUE14_MAPPING[27..24]      - (RW) Queue 14 use which group ID
    QUEUE15_MAPPING[31..28]      - (RW) Queue 15 use which group ID

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE15_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE15_MAPPING_MASK 0xF0000000                // QUEUE15_MAPPING[31..28]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE15_MAPPING_SHFT 28
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE14_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE14_MAPPING_MASK 0x0F000000                // QUEUE14_MAPPING[27..24]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE14_MAPPING_SHFT 24
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE13_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE13_MAPPING_MASK 0x00F00000                // QUEUE13_MAPPING[23..20]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE13_MAPPING_SHFT 20
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE12_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE12_MAPPING_MASK 0x000F0000                // QUEUE12_MAPPING[19..16]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE12_MAPPING_SHFT 16
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE11_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE11_MAPPING_MASK 0x0000F000                // QUEUE11_MAPPING[15..12]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE11_MAPPING_SHFT 12
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE10_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE10_MAPPING_MASK 0x00000F00                // QUEUE10_MAPPING[11..8]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE10_MAPPING_SHFT 8
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE9_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE9_MAPPING_MASK  0x000000F0                // QUEUE9_MAPPING[7..4]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE9_MAPPING_SHFT  4
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE8_MAPPING_ADDR  WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE8_MAPPING_MASK  0x0000000F                // QUEUE8_MAPPING[3..0]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING1_QUEUE8_MAPPING_SHFT  0

/* =====================================================================================

  ---QUEUE_MAPPING2 (0x7C026000 + 0xd8)---

    QUEUE16_MAPPING[3..0]        - (RW) Queue 16 use which group ID
    QUEUE17_MAPPING[7..4]        - (RW) Queue 17 use which group ID
    QUEUE18_MAPPING[11..8]       - (RW) Queue 18 use which group ID
    QUEUE19_MAPPING[15..12]      - (RW) Queue 19 use which group ID
    QUEUE20_MAPPING[19..16]      - (RW) Queue 20 use which group ID
    QUEUE21_MAPPING[23..20]      - (RW) Queue 21 use which group ID
    QUEUE22_MAPPING[27..24]      - (RW) Queue 22 use which group ID
    QUEUE23_MAPPING[31..28]      - (RW) Queue 23 use which group ID

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE23_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE23_MAPPING_MASK 0xF0000000                // QUEUE23_MAPPING[31..28]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE23_MAPPING_SHFT 28
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE22_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE22_MAPPING_MASK 0x0F000000                // QUEUE22_MAPPING[27..24]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE22_MAPPING_SHFT 24
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE21_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE21_MAPPING_MASK 0x00F00000                // QUEUE21_MAPPING[23..20]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE21_MAPPING_SHFT 20
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE20_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE20_MAPPING_MASK 0x000F0000                // QUEUE20_MAPPING[19..16]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE20_MAPPING_SHFT 16
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE19_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE19_MAPPING_MASK 0x0000F000                // QUEUE19_MAPPING[15..12]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE19_MAPPING_SHFT 12
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE18_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE18_MAPPING_MASK 0x00000F00                // QUEUE18_MAPPING[11..8]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE18_MAPPING_SHFT 8
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE17_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE17_MAPPING_MASK 0x000000F0                // QUEUE17_MAPPING[7..4]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE17_MAPPING_SHFT 4
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE16_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE16_MAPPING_MASK 0x0000000F                // QUEUE16_MAPPING[3..0]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING2_QUEUE16_MAPPING_SHFT 0

/* =====================================================================================

  ---QUEUE_MAPPING3 (0x7C026000 + 0xdc)---

    QUEUE24_MAPPING[3..0]        - (RW) Queue 24 use which group ID
    QUEUE25_MAPPING[7..4]        - (RW) Queue 25 use which group ID
    QUEUE26_MAPPING[11..8]       - (RW) Queue 26 use which group ID
    QUEUE27_MAPPING[15..12]      - (RW) Queue 27 use which group ID
    QUEUE28_MAPPING[19..16]      - (RW) Queue 28 use which group ID
    QUEUE29_MAPPING[23..20]      - (RW) Queue 29 use which group ID
    QUEUE30_MAPPING[27..24]      - (RW) Queue 30 use which group ID
    QUEUE31_MAPPING[31..28]      - (RW) Queue 31 use which group ID

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE31_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE31_MAPPING_MASK 0xF0000000                // QUEUE31_MAPPING[31..28]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE31_MAPPING_SHFT 28
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE30_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE30_MAPPING_MASK 0x0F000000                // QUEUE30_MAPPING[27..24]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE30_MAPPING_SHFT 24
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE29_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE29_MAPPING_MASK 0x00F00000                // QUEUE29_MAPPING[23..20]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE29_MAPPING_SHFT 20
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE28_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE28_MAPPING_MASK 0x000F0000                // QUEUE28_MAPPING[19..16]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE28_MAPPING_SHFT 16
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE27_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE27_MAPPING_MASK 0x0000F000                // QUEUE27_MAPPING[15..12]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE27_MAPPING_SHFT 12
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE26_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE26_MAPPING_MASK 0x00000F00                // QUEUE26_MAPPING[11..8]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE26_MAPPING_SHFT 8
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE25_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE25_MAPPING_MASK 0x000000F0                // QUEUE25_MAPPING[7..4]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE25_MAPPING_SHFT 4
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE24_MAPPING_ADDR WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_ADDR
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE24_MAPPING_MASK 0x0000000F                // QUEUE24_MAPPING[3..0]
#define WF_HIF_DMASHDL_TOP_QUEUE_MAPPING3_QUEUE24_MAPPING_SHFT 0

/* =====================================================================================

  ---STATUS_RD (0x7C026000 + 0x100)---

    FFA_CNT[11..0]               - (RO) Free for all (FFA) count
    RESERVED12[15..12]           - (RO) Reserved bits
    FREE_PAGE_CNT[27..16]        - (RO) Free page count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_FREE_PAGE_CNT_ADDR        WF_HIF_DMASHDL_TOP_STATUS_RD_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_FREE_PAGE_CNT_MASK        0x0FFF0000                // FREE_PAGE_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_FREE_PAGE_CNT_SHFT        16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_FFA_CNT_ADDR              WF_HIF_DMASHDL_TOP_STATUS_RD_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_FFA_CNT_MASK              0x00000FFF                // FFA_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_FFA_CNT_SHFT              0

/* =====================================================================================

  ---STATUS_RD_GP0 (0x7C026000 + 0x140)---

    G0_SRC_CNT[11..0]            - (RO) Group0 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G0_RSV_CNT[27..16]           - (RO) Group0 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_G0_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_G0_RSV_CNT_MASK       0x0FFF0000                // G0_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_G0_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_G0_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_G0_SRC_CNT_MASK       0x00000FFF                // G0_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP0_G0_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP1 (0x7C026000 + 0x144)---

    G1_SRC_CNT[11..0]            - (RO) Group1 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G1_RSV_CNT[27..16]           - (RO) Group1 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_G1_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_G1_RSV_CNT_MASK       0x0FFF0000                // G1_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_G1_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_G1_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_G1_SRC_CNT_MASK       0x00000FFF                // G1_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP1_G1_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP2 (0x7C026000 + 0x148)---

    G2_SRC_CNT[11..0]            - (RO) Group2 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G2_RSV_CNT[27..16]           - (RO) Group2 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_G2_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_G2_RSV_CNT_MASK       0x0FFF0000                // G2_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_G2_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_G2_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_G2_SRC_CNT_MASK       0x00000FFF                // G2_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP2_G2_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP3 (0x7C026000 + 0x14c)---

    G3_SRC_CNT[11..0]            - (RO) Group3 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G3_RSV_CNT[27..16]           - (RO) Group3 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_G3_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_G3_RSV_CNT_MASK       0x0FFF0000                // G3_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_G3_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_G3_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_G3_SRC_CNT_MASK       0x00000FFF                // G3_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP3_G3_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP4 (0x7C026000 + 0x150)---

    G4_SRC_CNT[11..0]            - (RO) Group4 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G4_RSV_CNT[27..16]           - (RO) Group4 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_G4_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_G4_RSV_CNT_MASK       0x0FFF0000                // G4_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_G4_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_G4_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_G4_SRC_CNT_MASK       0x00000FFF                // G4_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP4_G4_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP5 (0x7C026000 + 0x154)---

    G5_SRC_CNT[11..0]            - (RO) Group5 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G5_RSV_CNT[27..16]           - (RO) Group5 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_G5_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_G5_RSV_CNT_MASK       0x0FFF0000                // G5_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_G5_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_G5_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_G5_SRC_CNT_MASK       0x00000FFF                // G5_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP5_G5_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP6 (0x7C026000 + 0x158)---

    G6_SRC_CNT[11..0]            - (RO) Group6 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G6_RSV_CNT[27..16]           - (RO) Group6 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_G6_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_G6_RSV_CNT_MASK       0x0FFF0000                // G6_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_G6_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_G6_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_G6_SRC_CNT_MASK       0x00000FFF                // G6_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP6_G6_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP7 (0x7C026000 + 0x15C)---

    G7_SRC_CNT[11..0]            - (RO) Group7 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G7_RSV_CNT[27..16]           - (RO) Group7 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_G7_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_G7_RSV_CNT_MASK       0x0FFF0000                // G7_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_G7_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_G7_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_G7_SRC_CNT_MASK       0x00000FFF                // G7_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP7_G7_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP8 (0x7C026000 + 0x160)---

    G8_SRC_CNT[11..0]            - (RO) Group8 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G8_RSV_CNT[27..16]           - (RO) Group8 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_G8_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_G8_RSV_CNT_MASK       0x0FFF0000                // G8_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_G8_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_G8_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_G8_SRC_CNT_MASK       0x00000FFF                // G8_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP8_G8_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP9 (0x7C026000 + 0x164)---

    G9_SRC_CNT[11..0]            - (RO) Group9 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G9_RSV_CNT[27..16]           - (RO) Group9 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_G9_RSV_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_G9_RSV_CNT_MASK       0x0FFF0000                // G9_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_G9_RSV_CNT_SHFT       16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_G9_SRC_CNT_ADDR       WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_G9_SRC_CNT_MASK       0x00000FFF                // G9_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP9_G9_SRC_CNT_SHFT       0

/* =====================================================================================

  ---STATUS_RD_GP10 (0x7C026000 + 0x168)---

    G10_SRC_CNT[11..0]           - (RO) Group10 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G10_RSV_CNT[27..16]          - (RO) Group10 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_G10_RSV_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_G10_RSV_CNT_MASK     0x0FFF0000                // G10_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_G10_RSV_CNT_SHFT     16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_G10_SRC_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_G10_SRC_CNT_MASK     0x00000FFF                // G10_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP10_G10_SRC_CNT_SHFT     0

/* =====================================================================================

  ---STATUS_RD_GP11 (0x7C026000 + 0x16c)---

    G11_SRC_CNT[11..0]           - (RO) Group11 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G11_RSV_CNT[27..16]          - (RO) Group11 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_G11_RSV_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_G11_RSV_CNT_MASK     0x0FFF0000                // G11_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_G11_RSV_CNT_SHFT     16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_G11_SRC_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_G11_SRC_CNT_MASK     0x00000FFF                // G11_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP11_G11_SRC_CNT_SHFT     0

/* =====================================================================================

  ---STATUS_RD_GP12 (0x7C026000 + 0x170)---

    G12_SRC_CNT[11..0]           - (RO) Group12 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G12_RSV_CNT[27..16]          - (RO) Group12 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_G12_RSV_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_G12_RSV_CNT_MASK     0x0FFF0000                // G12_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_G12_RSV_CNT_SHFT     16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_G12_SRC_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_G12_SRC_CNT_MASK     0x00000FFF                // G12_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP12_G12_SRC_CNT_SHFT     0

/* =====================================================================================

  ---STATUS_RD_GP13 (0x7C026000 + 0x174)---

    G13_SRC_CNT[11..0]           - (RO) Group13 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G13_RSV_CNT[27..16]          - (RO) Group13 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_G13_RSV_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_G13_RSV_CNT_MASK     0x0FFF0000                // G13_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_G13_RSV_CNT_SHFT     16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_G13_SRC_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_G13_SRC_CNT_MASK     0x00000FFF                // G13_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP13_G13_SRC_CNT_SHFT     0

/* =====================================================================================

  ---STATUS_RD_GP14 (0x7C026000 + 0x178)---

    G14_SRC_CNT[11..0]           - (RO) Group14 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G14_RSV_CNT[27..16]          - (RO) Group14 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_G14_RSV_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_G14_RSV_CNT_MASK     0x0FFF0000                // G14_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_G14_RSV_CNT_SHFT     16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_G14_SRC_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_G14_SRC_CNT_MASK     0x00000FFF                // G14_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP14_G14_SRC_CNT_SHFT     0

/* =====================================================================================

  ---STATUS_RD_GP15 (0x7C026000 + 0x17C)---

    G15_SRC_CNT[11..0]           - (RO) Group15 source count
    RESERVED12[15..12]           - (RO) Reserved bits
    G15_RSV_CNT[27..16]          - (RO) Group15 reservation count
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_G15_RSV_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_G15_RSV_CNT_MASK     0x0FFF0000                // G15_RSV_CNT[27..16]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_G15_RSV_CNT_SHFT     16
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_G15_SRC_CNT_ADDR     WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_ADDR
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_G15_SRC_CNT_MASK     0x00000FFF                // G15_SRC_CNT[11..0]
#define WF_HIF_DMASHDL_TOP_STATUS_RD_GP15_G15_SRC_CNT_SHFT     0

/* =====================================================================================

  ---RD_GROUP_PKT_CNT0 (0x7C026000 + 0x180)---

    GP0_ASK_CNT[7..0]            - (RO) Group0 ask count
    GP0_PKTIN_CNT[15..8]         - (RO) Group0 packet in count
    GP1_ASK_CNT[23..16]          - (RO) Group1 ask count
    GP1_PKTIN_CNT[31..24]        - (RO) Group1 packet in count

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP1_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP1_PKTIN_CNT_MASK 0xFF000000                // GP1_PKTIN_CNT[31..24]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP1_PKTIN_CNT_SHFT 24
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP1_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP1_ASK_CNT_MASK  0x00FF0000                // GP1_ASK_CNT[23..16]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP1_ASK_CNT_SHFT  16
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP0_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP0_PKTIN_CNT_MASK 0x0000FF00                // GP0_PKTIN_CNT[15..8]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP0_PKTIN_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP0_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP0_ASK_CNT_MASK  0x000000FF                // GP0_ASK_CNT[7..0]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT0_GP0_ASK_CNT_SHFT  0

/* =====================================================================================

  ---RD_GROUP_PKT_CNT1 (0x7C026000 + 0x184)---

    GP2_ASK_CNT[7..0]            - (RO) Group2 ask count
    GP2_PKTIN_CNT[15..8]         - (RO) Group2 packet in count
    GP3_ASK_CNT[23..16]          - (RO) Group3 ask count
    GP3_PKTIN_CNT[31..24]        - (RO) Group3 packet in count

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP3_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP3_PKTIN_CNT_MASK 0xFF000000                // GP3_PKTIN_CNT[31..24]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP3_PKTIN_CNT_SHFT 24
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP3_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP3_ASK_CNT_MASK  0x00FF0000                // GP3_ASK_CNT[23..16]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP3_ASK_CNT_SHFT  16
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP2_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP2_PKTIN_CNT_MASK 0x0000FF00                // GP2_PKTIN_CNT[15..8]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP2_PKTIN_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP2_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP2_ASK_CNT_MASK  0x000000FF                // GP2_ASK_CNT[7..0]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT1_GP2_ASK_CNT_SHFT  0

/* =====================================================================================

  ---RD_GROUP_PKT_CNT2 (0x7C026000 + 0x188)---

    GP4_ASK_CNT[7..0]            - (RO) Group4 ask count
    GP4_PKTIN_CNT[15..8]         - (RO) Group4 packet in count
    GP5_ASK_CNT[23..16]          - (RO) Group5 ask count
    GP5_PKTIN_CNT[31..24]        - (RO) Group5 packet in count

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP5_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP5_PKTIN_CNT_MASK 0xFF000000                // GP5_PKTIN_CNT[31..24]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP5_PKTIN_CNT_SHFT 24
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP5_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP5_ASK_CNT_MASK  0x00FF0000                // GP5_ASK_CNT[23..16]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP5_ASK_CNT_SHFT  16
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP4_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP4_PKTIN_CNT_MASK 0x0000FF00                // GP4_PKTIN_CNT[15..8]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP4_PKTIN_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP4_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP4_ASK_CNT_MASK  0x000000FF                // GP4_ASK_CNT[7..0]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT2_GP4_ASK_CNT_SHFT  0

/* =====================================================================================

  ---RD_GROUP_PKT_CNT3 (0x7C026000 + 0x18c)---

    GP6_ASK_CNT[7..0]            - (RO) Group6 ask count
    GP6_PKTIN_CNT[15..8]         - (RO) Group6 packet in count
    GP7_ASK_CNT[23..16]          - (RO) Group7 ask count
    GP7_PKTIN_CNT[31..24]        - (RO) Group7 packet in count

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP7_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP7_PKTIN_CNT_MASK 0xFF000000                // GP7_PKTIN_CNT[31..24]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP7_PKTIN_CNT_SHFT 24
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP7_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP7_ASK_CNT_MASK  0x00FF0000                // GP7_ASK_CNT[23..16]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP7_ASK_CNT_SHFT  16
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP6_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP6_PKTIN_CNT_MASK 0x0000FF00                // GP6_PKTIN_CNT[15..8]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP6_PKTIN_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP6_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP6_ASK_CNT_MASK  0x000000FF                // GP6_ASK_CNT[7..0]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT3_GP6_ASK_CNT_SHFT  0

/* =====================================================================================

  ---RD_GROUP_PKT_CNT4 (0x7C026000 + 0x190)---

    GP8_ASK_CNT[7..0]            - (RO) Group8 ask count
    GP8_PKTIN_CNT[15..8]         - (RO) Group8 packet in count
    GP9_ASK_CNT[23..16]          - (RO) Group9 ask count
    GP9_PKTIN_CNT[31..24]        - (RO) Group9 packet in count

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP9_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP9_PKTIN_CNT_MASK 0xFF000000                // GP9_PKTIN_CNT[31..24]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP9_PKTIN_CNT_SHFT 24
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP9_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP9_ASK_CNT_MASK  0x00FF0000                // GP9_ASK_CNT[23..16]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP9_ASK_CNT_SHFT  16
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP8_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP8_PKTIN_CNT_MASK 0x0000FF00                // GP8_PKTIN_CNT[15..8]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP8_PKTIN_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP8_ASK_CNT_ADDR  WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP8_ASK_CNT_MASK  0x000000FF                // GP8_ASK_CNT[7..0]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT4_GP8_ASK_CNT_SHFT  0

/* =====================================================================================

  ---RD_GROUP_PKT_CNT5 (0x7C026000 + 0x194)---

    GP10_ASK_CNT[7..0]           - (RO) Group10 ask count
    GP10_PKTIN_CNT[15..8]        - (RO) Group10 packet in count
    GP11_ASK_CNT[23..16]         - (RO) Group11 ask count
    GP11_PKTIN_CNT[31..24]       - (RO) Group11 packet in count

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP11_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP11_PKTIN_CNT_MASK 0xFF000000                // GP11_PKTIN_CNT[31..24]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP11_PKTIN_CNT_SHFT 24
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP11_ASK_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP11_ASK_CNT_MASK 0x00FF0000                // GP11_ASK_CNT[23..16]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP11_ASK_CNT_SHFT 16
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP10_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP10_PKTIN_CNT_MASK 0x0000FF00                // GP10_PKTIN_CNT[15..8]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP10_PKTIN_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP10_ASK_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP10_ASK_CNT_MASK 0x000000FF                // GP10_ASK_CNT[7..0]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT5_GP10_ASK_CNT_SHFT 0

/* =====================================================================================

  ---RD_GROUP_PKT_CNT6 (0x7C026000 + 0x198)---

    GP12_ASK_CNT[7..0]           - (RO) Group12 ask count
    GP12_PKTIN_CNT[15..8]        - (RO) Group12 packet in count
    GP13_ASK_CNT[23..16]         - (RO) Group13 ask count
    GP13_PKTIN_CNT[31..24]       - (RO) Group13 packet in count

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP13_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP13_PKTIN_CNT_MASK 0xFF000000                // GP13_PKTIN_CNT[31..24]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP13_PKTIN_CNT_SHFT 24
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP13_ASK_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP13_ASK_CNT_MASK 0x00FF0000                // GP13_ASK_CNT[23..16]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP13_ASK_CNT_SHFT 16
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP12_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP12_PKTIN_CNT_MASK 0x0000FF00                // GP12_PKTIN_CNT[15..8]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP12_PKTIN_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP12_ASK_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP12_ASK_CNT_MASK 0x000000FF                // GP12_ASK_CNT[7..0]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT6_GP12_ASK_CNT_SHFT 0

/* =====================================================================================

  ---RD_GROUP_PKT_CNT7 (0x7C026000 + 0x19c)---

    GP14_ASK_CNT[7..0]           - (RO) Group14 ask count
    GP14_PKTIN_CNT[15..8]        - (RO) Group14 packet in count
    GP15_ASK_CNT[23..16]         - (RO) Group15 ask count
    GP15_PKTIN_CNT[31..24]       - (RO) Group15 packet in count

 =====================================================================================*/
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP15_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP15_PKTIN_CNT_MASK 0xFF000000                // GP15_PKTIN_CNT[31..24]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP15_PKTIN_CNT_SHFT 24
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP15_ASK_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP15_ASK_CNT_MASK 0x00FF0000                // GP15_ASK_CNT[23..16]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP15_ASK_CNT_SHFT 16
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP14_PKTIN_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP14_PKTIN_CNT_MASK 0x0000FF00                // GP14_PKTIN_CNT[15..8]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP14_PKTIN_CNT_SHFT 8
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP14_ASK_CNT_ADDR WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_ADDR
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP14_ASK_CNT_MASK 0x000000FF                // GP14_ASK_CNT[7..0]
#define WF_HIF_DMASHDL_TOP_RD_GROUP_PKT_CNT7_GP14_ASK_CNT_SHFT 0

#ifdef __cplusplus
}
#endif

#endif // __WF_HIF_DMASHDL_TOP_REGS_H__
