#ifndef __MT7916_CR_H__
#define __MT7916_CR_H__
/*
	Please don't include this header outside of per chip scope
*/

#include "mt7916_coda/conn_host_csr_top.h"
#include "mt7916_coda/wf_wfdma_host_dma0.h"
#include "mt7916_coda/wf_wfdma_host_dma0_pcie1.h"
#include "mt7916_coda/wf_wfdma_mcu_dma0.h"
#include "mt7916_coda/wf_wfdma_mem_dma.h"
#include "mt7916_coda/wf_wfdma_ext_wrap_csr.h"
#include "mt7916_coda/wf_pse_top.h"
#include "mt7916_coda/wf_ple_top.h"
#include "mt7916_coda/wf_hif_dmashdl_top.h"
#include "mt7916_coda/wf_uwtbl_top.h"
#include "mt7916_coda/wf_wtblon_top.h"
#include "mt7916_coda/conn_cfg.h"
#include "mt7916_coda/wf_cr_sw_def.h"
#include "mt7916_coda/conn_bus_cr.h"
#include "mt7916_coda/conn_mcu_bus_cr.h"
#include "mt7916_coda/bn0_wf_mib_top.h"
#include "mt7916_coda/bn1_wf_mib_top.h"
#include "mt7916_coda/bn0_wf_agg_top.h"
#include "mt7916_coda/bn1_wf_agg_top.h"
#include "mt7916_coda/bn0_wf_lpon_top.h"
#include "mt7916_coda/bn1_wf_lpon_top.h"
#include "mt7916_coda/bn0_wf_arb_top.h"
#include "mt7916_coda/bn1_wf_arb_top.h"
#include "mt7916_coda/bn0_wf_tmac_top.h"
#include "mt7916_coda/bn1_wf_tmac_top.h"
#include "mt7916_coda/bn0_wf_rmac_top.h"
#include "mt7916_coda/bn1_wf_rmac_top.h"
#include "mt7916_coda/bn0_wf_dma_top.h"
#include "mt7916_coda/bn1_wf_dma_top.h"
#include "mt7916_coda/bn0_phydfe_ctrl.h"
#include "mt7916_coda/bn1_phydfe_ctrl.h"
#include "mt7916_coda/wf_pp_top.h"
#include "common_cr.h"
/* #ifdef CONFIG_WTBL_MISS_DVT */
#include "mt7916_coda/bn0_wf_int_wakeup_top.h"
#include "mt7916_coda/bn1_wf_int_wakeup_top.h"
/* #endif */

#define CONN_INFRA_BASE_ADDR						0x18000000
#define CONN_INFRA_WIFISYS_MAC_OFFSET				0x400000
#define GET_CONN_INFRA_ADDR_OFFSET(p)				((p) - CONN_INFRA_BASE_ADDR)
#define GET_CONN_INFRA_WIFISYS_MAC_OFFSET			(CONN_INFRA_WIFISYS_MAC_OFFSET)
#define GET_CONN_INFRA_WIFISYS_MAC_BASE_ADDR 		(CONN_INFRA_BASE_ADDR + CONN_INFRA_WIFISYS_MAC_OFFSET)

/* remap CR */
#define HIF_ADDR_L1_REMAP_0_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_0_ADDR
#define HIF_ADDR_L1_REMAP_1_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_0_ADDR
#define HIF_ADDR_L1_REMAP_2_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_1_ADDR
#define HIF_ADDR_L1_REMAP_3_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_1_ADDR
#define HIF_ADDR_L1_REMAP_4_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_2_ADDR
#define HIF_ADDR_L1_REMAP_5_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_2_ADDR
#define HIF_ADDR_L1_REMAP_6_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_3_ADDR
#define HIF_ADDR_L1_REMAP_7_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_3_ADDR
#define HIF_ADDR_L1_REMAP_8_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_4_ADDR
#define HIF_ADDR_L1_REMAP_9_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_4_ADDR
#define HIF_ADDR_L1_REMAP_A_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_5_ADDR
#define HIF_ADDR_L1_REMAP_B_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_5_ADDR
#define HIF_ADDR_L1_REMAP_C_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_6_ADDR
#define HIF_ADDR_L1_REMAP_D_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_6_ADDR
#define HIF_ADDR_L1_REMAP_E_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_7_ADDR
#define HIF_ADDR_L1_REMAP_F_ADDR 	CONN_BUS_CR_PCIE2AP_REMAP_7_ADDR
#define HIF_ADDR_L1_REMAP_MASK_L 	(0xffff)
#define HIF_ADDR_L1_REMAP_MASK_H 	(0xffff << 16)

#define HIF_ADDR_L1_REMAP_BASE_ADDR	0xe0000
#define HIF_ADDR_L1_REMAP_ADDR		HIF_ADDR_L1_REMAP_E_ADDR
#define HIF_ADDR_L1_REMAP_MASK 		CONN_BUS_CR_PCIE2AP_REMAP_7_R_PCIE2AP_PUBLIC_REMAPPING_E_MASK
#define HIF_ADDR_L1_REMAP_SHFT 		CONN_BUS_CR_PCIE2AP_REMAP_7_R_PCIE2AP_PUBLIC_REMAPPING_E_SHFT
#define L1_REMAP_OFFSET_MASK 		(0xffff)
#define GET_L1_REMAP_OFFSET(p) 		(((p) & L1_REMAP_OFFSET_MASK))
#define L1_REMAP_BASE_MASK 			(0xffff << 16)
#define GET_L1_REMAP_BASE(p) 		(((p) & L1_REMAP_BASE_MASK) >> 16)

/* Use WF_PHY_MAP0 as L2 remapping */
#define GET_HIF_ADDR_L2_REMAP_BASE_ADDR		0x00000 /* mapping to 0x18400000 */
#define GET_HIF_ADDR_L2_REMAP_PHY_ADDR		0x40000 /* mapping to 0x18440000 */

#define HIF_ADDR_L2_REMAP_ADDR 	CONN_MCU_BUS_CR_LEGACY_REMAP_CTRL_2_R_CONNAC_LEGACY_AP2WF_ADDR_MAP3_ADDR
#define HIF_ADDR_L2_REMAP_MASK 	CONN_MCU_BUS_CR_LEGACY_REMAP_CTRL_2_R_CONNAC_LEGACY_AP2WF_ADDR_MAP3_MASK
#define HIF_ADDR_L2_REMAP_SHFT 	CONN_MCU_BUS_CR_LEGACY_REMAP_CTRL_2_R_CONNAC_LEGACY_AP2WF_ADDR_MAP3_SHFT
#define GET_HIF_ADDR_L2_REMAP_OFFSET(p) ((p) - CONN_MCU_BUS_CR_BASE)

#define L2_REMAP_OFFSET_MASK 	(0xffff)
#define GET_L2_REMAP_OFFSET(p) 	(((p) & L2_REMAP_OFFSET_MASK))
#define L2_REMAP_BASE_MASK 		(0xffff << 16)
#define GET_L2_REMAP_BASE(p) 	(((p) & L2_REMAP_BASE_MASK) >> 16)

#define CONN_INFRA_PHY_ADDR_START	0x18000000
#define CONN_INFRA_PHY_ADDR_END		0x183fffff
#define WFSYS0_PHY_ADDR_START		0x18400000
#define WFSYS0_PHY_ADDR_END			0x187fffff
#define WFSYS1_PHY_ADDR_START		0x18800000
#define WFSYS1_PHY_ADDR_END			0x18Bfffff
#define CBTOP1_PHY_ADDR_START		0x70000000
#define CBTOP1_PHY_ADDR_END			0x7fffffff
#define CBTOP2_PHY_ADDR_START		0xf0000000
#define CBTOP2_PHY_ADDR_END			0xffffffff
#define CONN_INFRA_MCU_ADDR_START	0x7c000000
#define CONN_INFRA_MCU_ADDR_END		0x7c085fff
#define GET_PHY_CONN_INFRA_ADDR(_reg)	(((_reg) - CONN_INFRA_MCU_ADDR_START) + CONN_INFRA_BASE_ADDR)

#define IS_CONN_INFRA_PHY_ADDR(_reg)	((_reg) >= CONN_INFRA_PHY_ADDR_START && (_reg) <= CONN_INFRA_PHY_ADDR_END)
#define IS_WFSYS0_PHY_ADDR(_reg)		((_reg) >= WFSYS0_PHY_ADDR_START && (_reg) <= WFSYS0_PHY_ADDR_END)
#define IS_WFSYS1_PHY_ADDR(_reg)		((_reg) >= WFSYS1_PHY_ADDR_START && (_reg) <= WFSYS1_PHY_ADDR_END)
#define IS_CBTOP_PHY_ADDR(_reg)			(((_reg) >= CBTOP1_PHY_ADDR_START && (_reg) <= CBTOP1_PHY_ADDR_END) || \
										((_reg) >= CBTOP2_PHY_ADDR_START && (_reg) <= CBTOP2_PHY_ADDR_END))
#define IS_CONN_INFRA_MCU_ADDR(_reg)	((_reg) >= CONN_INFRA_MCU_ADDR_START && (_reg) <= CONN_INFRA_MCU_ADDR_END)

#define IS_PHY_ADDR(_reg)	(IS_CONN_INFRA_PHY_ADDR(_reg) || IS_WFSYS0_PHY_ADDR(_reg) || IS_WFSYS1_PHY_ADDR(_reg) || \
								IS_CBTOP_PHY_ADDR(_reg))

#define WF_PP_TOP_BASE_ADDR             (0x820CC000)
#define WF_PP_TOP_RXQ_WFDMA_CF_5		(WF_PP_TOP_BASE_ADDR + 0x00E8)
#define WF_PP_TOP_RXQ_WFDMA_CF_5_RXQ_QID6_WFDMA_HIF_SEL_MASK		BIT(6)

/* ----------------- For PCIE0 -----------------*/
#define MT_PCIE_MAC_BASE_ADDR   		(0x74030000)
#define MT_PCIE_MAC_INT_ENABLE_ADDR   	(MT_PCIE_MAC_BASE_ADDR + 0x188)
#define MT_PCIE_MAC_LOW_POWER_ADDR   	(MT_PCIE_MAC_BASE_ADDR + 0x194)
#define MT_PCIE1_MAC_BASE_ADDR   		(0x74090000)
#define MT_PCIE1_MAC_INT_ENABLE_ADDR   	(MT_PCIE1_MAC_BASE_ADDR + 0x188)
#define MT_PCIE1_MAC_LOW_POWER_ADDR   	(MT_PCIE1_MAC_BASE_ADDR + 0x194)

#define MT_MCU_INT_EVENT 	WF_WFDMA_MCU_DMA0_HOST2MCU_SW_INT_SET_ADDR
#define MT_SW_INT_DRV_OWN	WF_WFDMA_HOST_DMA0_MCU2HOST_SW_INT_STA_mcu2host_sw_int_0_MASK

#ifdef WF_RESET_SUPPORT
#define MT_WM_WDT_INT       WF_WFDMA_HOST_DMA0_MCU2HOST_SW_INT_STA_mcu2host_wmcpu_wdt_MASK
#define MT_WA_WDT_INT       WF_WFDMA_HOST_DMA0_MCU2HOST_SW_INT_STA_mcu2host_wacpu_wdt_MASK
#endif

/* Usd HIF IO APIs for Read/Write directly */
#define WF_WFDMA_HOST_DMA0_PCI_OFFSET(p) 	((p) - (WF_WFDMA_HOST_DMA0_BASE))
#define WF_WFDMA_HOST_DMA0_PCI_BASE(p)		(WF_WFDMA_HOST_DMA0_PCI_OFFSET(p) + 0xd4000)
#define WF_WFDMA_MCU_DMA0_PCI_BASE(addr)	(addr - WF_WFDMA_MCU_DMA0_BASE + 0x2000)
#define WF_WFDMA_EXT_WRAP_CSR_PCI_BASE(p)	(p - WF_WFDMA_EXT_WRAP_CSR_BASE + 0xd7000)

/* interrupt pcie 0 */
#ifdef WFDMA_WED_COMPATIBLE
#define MT_INT_SOURCE_CSR	WF_WFDMA_EXT_WRAP_CSR_PCI_BASE(WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_ADDR)
#define MT_INT_MASK_CSR		WF_WFDMA_EXT_WRAP_CSR_PCI_BASE(WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_ENA_ADDR)
#else
#define MT_INT_SOURCE_CSR	WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_HOST_INT_STA_ADDR)
#define MT_INT_MASK_CSR		WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_HOST_INT_ENA_ADDR)
#endif

#ifdef CONFIG_WIFI_MSI_SUPPORT
#define MT_INT_MASK_CSR_W1C_DMA0_PCIE0	WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_HOST_INT_ENA_CLR_ADDR)
#define MT_INT_MASK_CSR_W1S_DMA0_PCIE0	WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_HOST_INT_ENA_SET_ADDR)
#endif

#ifdef WFDMA_WED_COMPATIBLE
#define MT_INT_DMA0_R0_DONE		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_rx_done_int_sts_0_MASK
#define MT_INT_DMA0_R1_DONE		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_wacpu_evt_int_sts_MASK
#define MT_INT_DMA0_R2_DONE		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_rx_done_int_sts_1_MASK
#define MT_INT_DMA0_R3_DONE		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_rx_done_int_sts_3_MASK
#define MT_INT_DMA0_R4_DONE		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_rx_done_int_sts_4_MASK
#define MT_INT_DMA0_R5_DONE		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_rx_done_int_sts_5_MASK

#define MT_INT_DMA0_T16_DONE	WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_tx_done_int_sts_16_MASK
#define MT_INT_DMA0_T17_DONE	WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_tx_done_int_sts_17_MASK
#define MT_INT_DMA0_T18_DONE	WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_tx_done_int_sts_0_MASK
#define MT_INT_DMA0_T19_DONE	WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_tx_done_int_sts_1_MASK
#define MT_INT_DMA0_T20_DONE	WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_tx_done_int_sts_20_MASK

#define MT_INT_DMA0_RX_COHE		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_rx_coherent_int_sts_MASK
#define MT_INT_DMA0_TX_COHE		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_tx_coherent_int_sts_MASK

#define MT_INT_SUBSYS_INT_STS		WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_subsys_int_sts_MASK
#define MT_INT_MCU2HOST_SW_INT_STS	WF_WFDMA_EXT_WRAP_CSR_WED_HOST_INT_STA_host_dma_mcu2host_sw_int_sts_MASK

#else

#define MT_INT_DMA0_R0_DONE		WF_WFDMA_HOST_DMA0_HOST_INT_STA_rx_done_int_sts_0_MASK
#define MT_INT_DMA0_R1_DONE		WF_WFDMA_HOST_DMA0_HOST_INT_STA_rx_done_int_sts_1_MASK
#define MT_INT_DMA0_R2_DONE		WF_WFDMA_HOST_DMA0_HOST_INT_STA_rx_done_int_sts_2_MASK
#define MT_INT_DMA0_R3_DONE		WF_WFDMA_HOST_DMA0_HOST_INT_STA_rx_done_int_sts_3_MASK
#define MT_INT_DMA0_R4_DONE		WF_WFDMA_HOST_DMA0_HOST_INT_STA_rx_done_int_sts_4_MASK
#define MT_INT_DMA0_R5_DONE		WF_WFDMA_HOST_DMA0_HOST_INT_STA_rx_done_int_sts_5_MASK

#define MT_INT_DMA0_T16_DONE	WF_WFDMA_HOST_DMA0_HOST_INT_STA_tx_done_int_sts_16_MASK
#define MT_INT_DMA0_T17_DONE	WF_WFDMA_HOST_DMA0_HOST_INT_STA_tx_done_int_sts_17_MASK
#define MT_INT_DMA0_T18_DONE	WF_WFDMA_HOST_DMA0_HOST_INT_STA_tx_done_int_sts_18_MASK
#define MT_INT_DMA0_T19_DONE	WF_WFDMA_HOST_DMA0_HOST_INT_STA_tx_done_int_sts_19_MASK
#define MT_INT_DMA0_T20_DONE	WF_WFDMA_HOST_DMA0_HOST_INT_STA_tx_done_int_sts_20_MASK

#define MT_INT_DMA0_RX_COHE		WF_WFDMA_HOST_DMA0_HOST_INT_STA_rx_coherent_int_sts_MASK
#define MT_INT_DMA0_TX_COHE		WF_WFDMA_HOST_DMA0_HOST_INT_STA_tx_coherent_int_sts_MASK

#define MT_INT_SUBSYS_INT_STS		WF_WFDMA_HOST_DMA0_HOST_INT_STA_subsys_int_sts_MASK
#define MT_INT_MCU2HOST_SW_INT_STS	WF_WFDMA_HOST_DMA0_HOST_INT_STA_mcu2host_sw_int_sts_MASK
#endif

#define MT_INT_TX_DONE (MT_INT_DMA0_T16_DONE | MT_INT_DMA0_T17_DONE | \
						MT_INT_DMA0_T18_DONE | MT_INT_DMA0_T19_DONE | MT_INT_DMA0_T20_DONE)

#define MT_INT_TxCoherent		(MT_INT_DMA0_TX_COHE)
#define MT_INT_RxCoherent		(MT_INT_DMA0_RX_COHE)
#define MT_INT_CoherentInt		(MT_INT_TxCoherent | MT_INT_RxCoherent)

#define MT_INT_RX_DATA		(MT_INT_DMA0_R4_DONE | MT_INT_DMA0_R5_DONE)
#define MT_INT_RX_CMD		(MT_INT_DMA0_R0_DONE | MT_INT_DMA0_R1_DONE | MT_INT_DMA0_R2_DONE | MT_INT_DMA0_R3_DONE)

#define MT_INT_RX			(MT_INT_RX_DATA | MT_INT_RX_CMD)

#define MT_INT_CMD			(MT_INT_DMA0_T17_DONE | MT_INT_DMA0_T20_DONE)

#define MT_DMA0_T16_RING_BASE 	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_TX_RING16_CTRL0_ADDR)
#define MT_DMA0_T17_RING_BASE 	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_TX_RING17_CTRL0_ADDR)
#ifdef WFDMA_WED_COMPATIBLE
#define MT_DMA0_T18_RING_BASE	WF_WFDMA_EXT_WRAP_CSR_PCI_BASE(WF_WFDMA_EXT_WRAP_CSR_WED_TX0_CTRL0_ADDR)
#define MT_DMA0_T19_RING_BASE	WF_WFDMA_EXT_WRAP_CSR_PCI_BASE(WF_WFDMA_EXT_WRAP_CSR_WED_TX1_CTRL0_ADDR)
#else
#define MT_DMA0_T18_RING_BASE 	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_TX_RING18_CTRL0_ADDR)
#define MT_DMA0_T19_RING_BASE 	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_TX_RING19_CTRL0_ADDR)
#endif
#define MT_DMA0_T20_RING_BASE 	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_TX_RING20_CTRL0_ADDR)

#define MT_DMA0_R0_RING_BASE	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_RX_RING0_CTRL0_ADDR)
#define MT_DMA0_R1_RING_BASE	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_RX_RING1_CTRL0_ADDR)

#ifdef WFDMA_WED_COMPATIBLE
#define MT_DMA0_R2_RING_BASE	 WF_WFDMA_EXT_WRAP_CSR_PCI_BASE(WF_WFDMA_EXT_WRAP_CSR_WED_RX1_CTRL0_ADDR)
#else
#define MT_DMA0_R2_RING_BASE	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_RX_RING2_CTRL0_ADDR)
#endif
#define MT_DMA0_R3_RING_BASE	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_RX_RING3_CTRL0_ADDR)
#define MT_DMA0_R4_RING_BASE	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_RX_RING4_CTRL0_ADDR)
#define MT_DMA0_R5_RING_BASE	 WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_WPDMA_RX_RING5_CTRL0_ADDR)

/* ----------------- For PCIE1 -----------------*/
#define MT_PCIE1_MAC_BASE_ADDR   		(0x74090000)
#define MT_PCIE1_MAC_INT_ENABLE_ADDR   	(MT_PCIE1_MAC_BASE_ADDR + 0x188)

#define MT_MCU_INT1_EVENT 	WF_WFDMA_HOST_DMA0_PCIE1_HOST2MCU_SW_INT_SET_ADDR
#define MT_SW_INT1_DRV_OWN	WF_WFDMA_HOST_DMA0_PCIE1_MCU2HOST_SW_INT_STA_mcu2host_sw_int_0_MASK

/* Usd HIF IO APIs for Read/Write directly */
#define WF_WFDMA_HOST_DMA0_PCI1_OFFSET(p) 	((p) - (WF_WFDMA_HOST_DMA0_PCIE1_BASE))
#define WF_WFDMA_HOST_DMA0_PCI1_BASE(p)		(WF_WFDMA_HOST_DMA0_PCI1_OFFSET(p) + 0xd8000)

#define MT_INT1_SOURCE_CSR		WF_WFDMA_HOST_DMA0_PCI1_BASE(WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_STA_ADDR)
#define MT_INT1_MASK_CSR		WF_WFDMA_HOST_DMA0_PCI1_BASE(WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_ENA_ADDR)
#ifdef CONFIG_WIFI_MSI_SUPPORT
#define MT_INT_MASK_CSR_W1C_DMA0_PCIE1	WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_ENA_CLR_ADDR)
#define MT_INT_MASK_CSR_W1S_DMA0_PCIE1	WF_WFDMA_HOST_DMA0_PCI_BASE(WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_ENA_SET_ADDR)
#endif

#define MT_INT1_DMA0_R3_DONE	WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_STA_rx_done_int_sts_3_MASK
#define MT_INT1_DMA0_R5_DONE	WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_STA_rx_done_int_sts_5_MASK

#define MT_INT1_DMA0_T19_DONE	WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_STA_tx_done_int_sts_19_MASK

#define MT_INT1_DMA0_RX_COHE		WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_STA_rx_coherent_int_sts_MASK
#define MT_INT1_DMA0_TX_COHE		WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_STA_tx_coherent_int_sts_MASK

#define MT_INT1_SUBSYS_INT_STS		WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_STA_subsys_int_sts_MASK
#define MT_INT1_MCU2HOST_SW_INT_STS	WF_WFDMA_HOST_DMA0_PCIE1_HOST_INT_STA_mcu2host_sw_int_sts_MASK

#define MT_INT1_TX_DONE 			(MT_INT1_DMA0_T19_DONE)

#define MT_INT1_TxCoherent		(MT_INT1_DMA0_TX_COHE)
#define MT_INT1_RxCoherent		(MT_INT1_DMA0_RX_COHE)
#define MT_INT1_CoherentInt		(MT_INT1_TxCoherent | MT_INT1_RxCoherent)

#define MT_INT1_RX_DATA		(MT_INT1_DMA0_R5_DONE)
#define MT_INT1_RX_CMD		(MT_INT1_DMA0_R3_DONE)

#define MT_INT1_RX			(MT_INT1_RX_DATA | MT_INT1_RX_CMD)

#define MT_INT1_CMD			(0)

#define MT_DMA0_T19_PCI1_RING_BASE 	 WF_WFDMA_HOST_DMA0_PCI1_BASE(WF_WFDMA_HOST_DMA0_PCIE1_WPDMA_TX_RING19_CTRL0_ADDR)

#define MT_DMA0_R3_PCI1_RING_BASE	 WF_WFDMA_HOST_DMA0_PCI1_BASE(WF_WFDMA_HOST_DMA0_PCIE1_WPDMA_RX_RING3_CTRL0_ADDR)
#define MT_DMA0_R5_PCI1_RING_BASE	 WF_WFDMA_HOST_DMA0_PCI1_BASE(WF_WFDMA_HOST_DMA0_PCIE1_WPDMA_RX_RING5_CTRL0_ADDR)

/* onwership control */
#define MT_HOST_SET_OWN				(1<<0)
#define MT_HOST_CLR_OWN				(1<<1)
#define HOST_SET_FW_OWN_MASK		CONN_HOST_CSR_TOP_WF_BAND0_LPCTL_WF_B0_AP_HOST_SET_FW_OWN_HS_PULSE_MASK
#define HOST_CLR_FW_OWN_MASK		CONN_HOST_CSR_TOP_WF_BAND0_LPCTL_WF_B0_AP_HOST_CLR_FW_OWN_HS_PULSE_MASK
#define HOST_FW_OWN_SYNC_MASK		CONN_HOST_CSR_TOP_WF_BAND0_LPCTL_WF_B0_AP_HOST_OWNER_STATE_SYNC_MASK
#define HOST_FW_OWN_CLR_STAT_MASK	CONN_HOST_CSR_TOP_WF_BAND0_IRQ_STAT_WF_B0_HOST_LPCR_FW_OWN_CLR_STAT_MASK

struct _RTMP_ADAPTER;

#define EEPROM_DBDC_ANTENNA_CFG_OFFSET_B0   0x190
#define DBDC_BAND0_RX_MASK                  BITS(3, 5)
#define DBDC_BAND0_RX_OFFSET                3
#define DBDC_BAND0_TX_MASK                  BITS(0, 2)
#define DBDC_BAND0_TX_OFFSET                0
#define DBDC_BAND0_SELECT_MASK				BITS(6, 7)
#define DBDC_BAND0_SELECT_OFFSET            6
#define EEPROM_DBDC_ANTENNA_CFG_OFFSET_B1   0x191
#define DBDC_BAND1_RX_MASK                  BITS(3, 5)
#define DBDC_BAND1_RX_OFFSET                3
#define DBDC_BAND1_TX_MASK                  BITS(0, 2)
#define DBDC_BAND1_TX_OFFSET                0
#define DBDC_BAND1_SELECT_MASK				BITS(6, 7)
#define DBDC_BAND1_SELECT_OFFSET            6

#define EEPROM_DBDC_G_ANTENNA_CFG_OFFSET_B0     0x192
#define DBDC_BAND0_CCK_TX_MASK                  BITS(0, 1)
#define DBDC_BAND0_CCK_TX_OFFSET                0
#define DBDC_BAND0_OFDM_TX_MASK                 BITS(2, 4)
#define DBDC_BAND0_OFDM_TX_OFFSET               2
#define DBDC_BAND0_STREAM_MASK                  BITS(5, 7)
#define DBDC_BAND0_STREAM_OFFSET                5
#define EEPROM_DBDC_G_ANTENNA_CFG_OFFSET_B1     0x193
#define DBDC_BAND1_CCK_TX_MASK                  BITS(0, 1)
#define DBDC_BAND1_CCK_TX_OFFSET                0
#define DBDC_BAND1_OFDM_TX_MASK                 BITS(2, 4)
#define DBDC_BAND1_OFDM_TX_OFFSET               2
#define DBDC_BAND1_STREAM_MASK                  BITS(5, 7)
#define DBDC_BAND1_STREAM_OFFSET                5


#endif /* __AXE_CR_H__ */
