#ifndef __MT7986_H__
#define __MT7986_H__

struct _RTMP_ADAPTER;
struct _RTMP_CHIP_DBG;

#define DEFAULT_RID 0
#define WFSYS_MAC0_ID 0xa0
#define	FAKE_PCIE1_CHIP_ID 0x7987

#define OF_WIFI_MT7986_ADIE "mediatek,rebb-mt7986-adie"

#define MT7986_BIN_FILE_NAME_E1_MT7975 "WIFI_RAM_CODE_MT7986_MT7975.bin"
#define MT7986_BIN_FILE_NAME_E1_MT7976 "WIFI_RAM_CODE_MT7986.bin"
#define MT7986_ROM_PATCH_BIN_FILE_NAME_E1_MT7975 "mt7986_patch_e1_hdr_mt7975.bin"
#define MT7986_ROM_PATCH_BIN_FILE_NAME_E1_MT7976 "mt7986_patch_e1_hdr.bin"
#define MT7986_WA_BIN_FILE_NAME "7986_WACPU_RAM_CODE_release.bin"
#define MT7986_EEPROM_BIN_FILE_NAME_AX5400_MT7975 "MT7986_iPAiLNA_EEPROM_AX5400.bin"
#define MT7986_EEPROM_BIN_FILE_NAME_AX6000_MT7975 "MT7986_iPAiLNA_EEPROM_AX6000.bin"
#define MT7986_EEPROM_BIN_FILE_NAME_AX7800_MT7975 "MT7986_iPAiLNA_EEPROM_AX7800.bin"
#define MT7986_EEPROM_BIN_FILE_NAME_AX6000_MT7976 "MT7986_ePAeLNA_EEPROM_AX6000.bin"
#define MT7986_EEPROM_BIN_FILE_NAME_AX5400_MT7976 "MT7986_ePAeLNA_EEPROM_AX5400.bin"
#define MT7986_EEPROM_BIN_FILE_NAME_AX7800_MT7976 "MT7986_ePAeLNA_EEPROM_AX7800.bin"
#define MT7986_EEPROM_BIN_FILE_NAME_AX8400_MT7976 "MT7986_ePAeLNA_EEPROM_AX8400.bin"
#define MT7986_EEPROM_BIN_FILE_NAME_ONE_ADIE_DBDC_MT7976_EPA "MT7986_ePAeLNA_EEPROM_ONEADIE_DBDC.bin"

#define MT7986_ROM_PATCH_START_ADDRESS	0x900000

#define CONNINFRA_SKU_DECISION_ADDRESS  0x18050000
#define MT7986_ADIE_MT7976_TYPE_MASK  BIT(1)

#define MT7986_ADIE1_EFUSE_OFFSET	0x1000


enum {
	ENUM_MT7976_ONE_ADIE_DBDC		= 0x7, 
	ENUM_MT7975_ONE_ADIE_SINGLE_BAND	= 0x8, /* AX7800 */
	ENUM_MT7976_ONE_ADIE_SINGLE_BAND	= 0xa, /* AX7800 */
	ENUM_MT7975_DUAL_ADIE_DBDC		= 0xd, /* AX6000 */
	ENUM_MT7976_DUAL_ADIE_DBDC		= 0xf, /* AX6000 */	
};


#define MT7986_MT_WTBL_SIZE         544
#define MAX_INBAND_WTBL_NUM         150

#define WTBL_MASK_UPDATE_MAX_RETRY	64000

#ifdef DOT11_HE_AX
#ifdef WIFI_TWT_SUPPORT
#ifdef DYNAMIC_TWT_NODE_SUPPORT
#define MT7986_TWT_HW_AGRT_MAX_NUM 100
#else
#define MT7986_TWT_HW_AGRT_MAX_NUM TWT_HW_AGRT_MAX_NUM
#endif /* DYNAMIC_TWT_NODE_SUPPORT */
#define MT7986_TWT_HW_BTWT_MAX_NUM TWT_HW_BTWT_MAX_NUM
#define MT7986_TWT_HW_GRP_MAX_NUM  TWT_HW_GRP_MAX_NUM
#define MT7986_TWT_SP_DURATION_MIN_NUM TWT_MIN_SP_DURATION
#endif /* WIFI_TWT_SUPPORT */
#endif /* DOT11_HE_AX */

/* rxv dara word */
#define E1_RXV_PACKET_HEADER_DW_NUM    2
#define E1_RXV_ENTRY_HEADER_DW_NUM    2
#define E1_CMN_RXV1_DW_NUM    18
#define E1_CMN_RXV2_DW_NUM    26
#define E1_USR_RXV1_DW_NUM    2
#define E1_USR_RXV2_DW_NUM    4

#define RX_GAIN_CAL_EEPROM_OFST_7975_A5_E  0x5BF
#define RX_GAIN_CAL_EEPROM_OFST_7975_A5_S  0x600

#ifdef DATA_TXPWR_CTRL
#define DATA_TXPOWER_MAX_BW_NUM 4
#define DATA_TXPOWER_MAX_MCS_NUM 12
#endif

/*
 * Used for DNL + TSSI Calibration happen in MP-Line state
 * 3 Channel for G-band L/M/H channel
 * 16 Channel for A-band L/H channel
 */
extern UINT16 MT7986_DNL_CAL_GBAND_BW20_FREQ[];
extern UINT16 MT7986_DNL_CAL_ABAND_BW20_FREQ[];
extern UINT16 MT7986_DNL_CAL_BW20_FREQ[];

extern UINT16 MT7986_DNL_CAL_GBAND_BW20_CH[];
extern UINT16 MT7986_DNL_CAL_ABAND_BW20_CH[];
extern UINT16 MT7986_DNL_CAL_BW20_CH[];

extern UINT16 MT7986_DNL_CAL_GBAND_BW20_SIZE;
extern UINT16 MT7986_DNL_CAL_ABAND_BW20_SIZE;
extern UINT16 MT7986_DNL_CAL_BW20_FREQ_SIZE;

extern UINT16 MT7986_DNL_CAL_GBAND_BW20_CH_SIZE;
extern UINT16 MT7986_DNL_CAL_ABAND_BW20_CH_SIZE;
extern UINT16 MT7986_DNL_CAL_B20_CH_SIZE;

void mt7986_init(struct _RTMP_ADAPTER *pAd);
VOID mt7986_chip_dbg_init(struct _RTMP_CHIP_DBG *dbg_ops);
INT mt7986AsicArchOpsInit(struct _RTMP_ADAPTER *pAd);
VOID mt7986_hif_ctrl_chip_init(VOID *hif_chip);
VOID mt7986_hif_ctrl_chip_pcie1_init(VOID *hif_chip);
UINT32 MT7986_get_rid_value(VOID);

#ifdef PRE_CAL_MT7986_SUPPORT

#ifdef RTMP_FLASH_SUPPORT
#define PRECAL_INDICATION_BYTE 0x19A

#define CAL_PRE_CAL_SIZE_OFFSET  4096	/* DW0 : 0xE00 ~ 0xE03 Used for save total pre-cal size
										*  DW1 : reserved
										*  DW2 : reserved
										*  DW3 : reserved
										*/
#define CAL_FLASH_OFFSET         (4096+16)  /* 0xE10 ~ 0x5780 Used for save Group calibration data */
#else
#define CAL_FLASH_OFFSET         0
#endif

extern UINT16 MT7986_PER_CH_A5_BW20_BW160_FREQ[];
extern UINT16 MT7986_PER_CH_A5_BW20_BW160[];
extern UINT16 MT7986_PER_CH_A6_BW20_BW160_FREQ[];
extern UINT16 MT7986_PER_CH_A6_BW20_BW160[];
extern UINT16 MT7986_PER_CH_G_BW20_FREQ[];
extern UINT16 MT7986_PER_CH_G_BW20[];

extern UINT16 MT7986_PER_CH_A5_BW20_BW160_FREQ_SIZE;
extern UINT16 MT7986_PER_CH_A6_BW20_BW160_FREQ_SIZE;
extern UINT16 MT7986_PER_CH_G_BW20_FREQ_SIZE;
extern UINT16 MT7986_PER_CH_A5_BW20_BW160_SIZE;
extern UINT16 MT7986_PER_CH_A6_BW20_BW160_SIZE;
extern UINT16 MT7986_PER_CH_G_BW20_SIZE;

extern UINT16 MT7986_PER_CH_A5_BW20[];
extern UINT16 MT7986_PER_CH_A5_BW160[];
extern UINT16 MT7986_PER_CH_A6_BW20[];
extern UINT16 MT7986_PER_CH_A6_BW160[];
extern UINT16 MT7986_PER_CH_G_BW20[];
extern UINT16 MT7986_PER_CH_A5_BW20_SIZE;
extern UINT16 MT7986_PER_CH_A6_BW20_SIZE;

#endif /*PRE_CAL_MT7986_SUPPORT*/





#endif /* __MT7986_H__ */

