/* Copyright Statement:
 *
 * (C) 2022  Airoha Technology Corp. All rights reserved.
 *
 * This software/firmware and related documentation ("Airoha Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to Airoha Technology Corp. ("Airoha") and/or its licensors.
 * Without the prior written permission of Airoha and/or its licensors,
 * any reproduction, modification, use or disclosure of Airoha Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 * You may only use, reproduce, modify, or distribute (as applicable) Airoha Software
 * if you have agreed to and been bound by the applicable license agreement with
 * Airoha ("License Agreement") and been granted explicit permission to do so within
 * the License Agreement ("Permitted User").  If you are not a Permitted User,
 * please cease any access or use of Airoha Software immediately.
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT AIROHA SOFTWARE RECEIVED FROM AIROHA AND/OR ITS REPRESENTATIVES
 * ARE PROVIDED TO RECEIVER ON AN "AS-IS" BASIS ONLY. AIROHA EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES AIROHA PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH AIROHA SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN AIROHA SOFTWARE. AIROHA SHALL ALSO NOT BE RESPONSIBLE FOR ANY AIROHA
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND AIROHA'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO AIROHA SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT AIROHA'S OPTION, TO REVISE OR REPLACE AIROHA SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * AIROHA FOR SUCH AIROHA SOFTWARE AT ISSUE.
*/
#ifndef _CONFIG_H_
#define _CONFIG_H_

#include <stdbool.h>
#include <stdint.h>
#include "location_config.h"

typedef enum {
    CHIP_AG3335 = 0,
    CHIP_AG3352,
} HDL_SLAVE_CHIP;

typedef enum {
    SLAVE_UART = 0,
    SLAVE_SPI, // FOR AG3335,AG3352
	SLAVE_I2C, // FOR AG3335
} HDL_SLAVE_PHY;

typedef struct
{
	HDL_SLAVE_CHIP chip;
    HDL_SLAVE_PHY dl_slave_phy;
	bool dl_da_support_921600;
    uint32_t dl_flash_baudrate;
    uint32_t clock_frequency;
    char da_path[128];
    char image_path[256];
    char io_path[128];
}HDL_CONFIG;

//#define HOST_SPI_LOG_ENABLE

// If your host support flow ctrl, you can enable the feature
//#define FLOW_CTRL_OPEN

#define HDL_ON_LINUX

#define PACKET_SIZE 			(4096)
#define RACE_MAX_SIZE    		(PACKET_SIZE+16)
#define POOL_BUF_SIZE       	(RACE_MAX_SIZE*4)
#define FLOW_CTRL_BUF_MAX_SIZE 	(RACE_MAX_SIZE*2)

// #ifdef HDL_ON_LINUX
// #define UART_PORT_PATH "/dev/ttyS1"; //"/dev/ttyUSB0";
// #else
// #define UART_PORT_PATH "\\\\.\\COM14";
// #endif

typedef enum
{ 
	FC_NONE = 0, 
	FC_SOFTWARE = 1, 
	FC_HARDWARE = 2 
}FlowControl;


#endif //_CONFIG_H_
