#!/bin/bash
source ./autobuild/lede-build-sanity.sh

#get the brach_name
temp=${0%/*}
branch_name=${temp##*/}
cfg80211_on=1
kasan=0
onepcie=0
sku_type=0
args=

# Copy Jaguar+Eagle's package, target and tools temporarily
MT7990_BDIR=${BUILD_DIR}/./autobuild/mt7988-mt7990-BE19000
MT7992_BDIR=${BUILD_DIR}/./autobuild/mt7988-mt7992-BE7200

if [ -d "${MT7992_BDIR}/package" ]; then
	rm -rf ${MT7992_BDIR}/package/
fi

if [ -d "${MT7992_BDIR}/target" ]; then
	rm -rf ${MT7992_BDIR}/target/
fi

if [ -d "${MT7992_BDIR}/tools" ]; then
	rm -rf ${MT7992_BDIR}/tools/
fi

cp -fpR ${MT7990_BDIR}/package ${MT7992_BDIR}
cp -fpR ${MT7990_BDIR}/target ${MT7992_BDIR}
cp -fpR ${MT7990_BDIR}/tools ${MT7992_BDIR}
# End of Copy Jaguar+Eagle's package, target and tools temporarily

#handle release & releease build
if [ -n ${1} ]; then
	if [ "${1}" = "release" ] || [ "${1}" = "release_build" ]; then
		rel_conf=${BUILD_DIR}/../tools/release_conf/${branch_name}/release.conf
		package_conf=${BUILD_DIR}/../tools/release_conf/${branch_name}/package.conf

		if [ ! -f ${rel_conf} ] || [ ! -f ${package_conf} ]; then
			echo "no release or pakcage config. release terminated"
		else
			source ${rel_conf}
			source ${package_conf}
			source ${BUILD_DIR}/../tools/release.sh
		fi
		exit 0;
	fi
fi

# Remove cfg80211_off from input parameters
for arg in $*; do
	case "$arg" in
	"cfg80211_off")
		cfg80211_on=0
		;;
	"kasan")
		kasan=1
		;;
	"1pcie")
		onepcie=1
		;;
	"6500")
		sku_type=1
		;;
	"5040")
		sku_type=2
		;;
	*)
		args="$args $arg"
		;;
	esac
done
set -- $args

rm -rf ${BUILD_DIR}/package/network/services/hostapd
rm -rf ${BUILD_DIR}/package/kernel/mac80211

rm -rf ${BUILD_DIR}/package/libs/libnl-tiny
cp -fpR ${BUILD_DIR}/./../mac80211_package/package/libs/libnl-tiny ${BUILD_DIR}/package/libs

rm -rf ${BUILD_DIR}/package/network/utils/iw
cp -fpR ${BUILD_DIR}/./../mac80211_package/package/network/utils/iw ${BUILD_DIR}/package/network/utils

rm -rf ${BUILD_DIR}/package/network/utils/iwinfo
cp -fpR ${BUILD_DIR}/./../mac80211_package/package/network/utils/iwinfo ${BUILD_DIR}/package/network/utils

#use hostapd master package revision, remove hostapd 2102 patches
find ../mtk-openwrt-feeds/openwrt_patches-21.02 -name "*-2102-hostapd-*.patch" -delete
find ../mtk-openwrt-feeds/openwrt_patches-21.02 -name "*-master-hostapd-*.patch" -delete
#use mt7986_dev2 branch, remove mt76 master patches
find ../mtk-openwrt-feeds/openwrt_patches-21.02 -name "*-master-mt76-*.patch" -delete

[ "$cfg80211_on" = "1" ] && {
	sed -i 's/$(LN) iwconfig $(1)\/usr\/sbin\/iwpriv/$(LN) mwctl $(1)\/usr\/sbin\/iwpriv/g' ${BUILD_DIR}/package/network/utils/wireless-tools/Makefile
}


sed -i '/^[\t ]*\[[ ]*![ ]*-f[ ]*\/etc\/config\/wireless[ ]*\]/a \\t\t\/sbin\/wifi detect' ${BUILD_DIR}/package/base-files/files/etc/init.d/boot

change_config_after_defconfig() {
	[ "$cfg80211_on" = "1" ] || {
		sed -i 's/CONFIG_PACKAGE_mwctl=y/# CONFIG_PACKAGE_mwctl is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_PACKAGE_kmod-cfg80211=y/# CONFIG_PACKAGE_kmod-cfg80211 is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_PACKAGE_kmod-mt_cfg80211=y/# CONFIG_PACKAGE_kmod-mt_cfg80211 is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_MTK_WIFI7_CFG80211_SUPPORT=y/# CONFIG_MTK_WIFI7_CFG80211_SUPPORT is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_PACKAGE_hostapd-common=y/# CONFIG_PACKAGE_hostapd-common is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_PACKAGE_wpad-openssl=y/# CONFIG_PACKAGE_wpad-openssl is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_PACKAGE_hostapd-utils=y/# CONFIG_PACKAGE_hostapd-utils is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_PACKAGE_wpa-cli=y/# CONFIG_PACKAGE_wpa-cli is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_WPA_MSG_MIN_PRIORITY=0/# CONFIG_WPA_MSG_MIN_PRIORITY is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_MTK_WIFI7_HOSTAPD_MBSS_SUPPORT=y/# CONFIG_MTK_WIFI7_HOSTAPD_MBSS_SUPPORT is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_MTK_WIFI7_APCLI_SUPPLICANT_SUPPORT=y/# CONFIG_MTK_WIFI7_APCLI_SUPPLICANT_SUPPORT is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_PACKAGE_libwpactrl=y/# CONFIG_PACKAGE_libwpactrl is not set/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_WAPP_WPACTRL_SUPPORT=y/# CONFIG_WAPP_WPACTRL_SUPPORT is not set/g' ${BUILD_DIR}/.config
	}

	[ "$kasan" = "1" ] && {
		sed -i 's/# CONFIG_KERNEL_KASAN is not set/CONFIG_KERNEL_KASAN=y/g' ${BUILD_DIR}/.config
		sed -i 's/# CONFIG_KERNEL_KALLSYMS is not set/CONFIG_KERNEL_KALLSYMS=y/g' ${BUILD_DIR}/.config
		echo "CONFIG_KERNEL_KASAN_OUTLINE=y" >> ${BUILD_DIR}/.config
#		sed -i 's/CONFIG_PACKAGE_kmod-ufsd_driver=y/# CONFIG_PACKAGE_kmod-ufsd_driver is not set/g' ${BUILD_DIR}/.config
		echo "CONFIG_DEBUG_KMEMLEAK=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_DEBUG_KMEMLEAK_AUTO_SCAN=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "# CONFIG_DEBUG_KMEMLEAK_DEFAULT_OFF is not set" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_DEBUG_KMEMLEAK_MEM_POOL_SIZE=16000" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_DEBUG_KMEMLEAK_TEST=m" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KALLSYMS=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KASAN=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KASAN_GENERIC=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "# CONFIG_KASAN_INLINE is not set" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KASAN_OUTLINE=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KASAN_SHADOW_OFFSET=0xdfffffd000000000" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "# CONFIG_TEST_KASAN is not set" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_SLUB_DEBUG=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_FRAME_WARN=4096" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
	}

	[ "$onepcie" = "1" ] && {
		echo "1pcie"
		sed -i 's/CONFIG_MTK_HWIFI_MT7992_RRO_SUPPORT="Y"/CONFIG_MTK_HWIFI_MT7992_RRO_SUPPORT="N"/g' ${BUILD_DIR}/.config
		sed -i 's/CONFIG_MTK_HWIFI_MT7992_OPTION_TYPE=1/CONFIG_MTK_HWIFI_MT7992_OPTION_TYPE=0/g' ${BUILD_DIR}/.config
	}

	[ "$sku_type" = "1" ] && {
		echo "SKU 6500"
		sed -i 's/CONFIG_MTK_WIFI7_SKU_TYPE2="BE7200"/CONFIG_MTK_WIFI7_SKU_TYPE2="BE6500"/g' ${BUILD_DIR}/.config
	}

	[ "$sku_type" = "2" ] && {
		echo "SKU 5040"
		sed -i 's/CONFIG_MTK_WIFI7_SKU_TYPE2="BE7200"/CONFIG_MTK_WIFI7_SKU_TYPE2="BE5040"/g' ${BUILD_DIR}/.config
	}

}

#do prepare stuff
prepare

sed -i 's/# CONFIG_AQUANTIA_PHY_FW_DOWNLOAD_SINGLE is not set/CONFIG_AQUANTIA_PHY_FW_DOWNLOAD_SINGLE=y/g' ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
sed -i 's/CONFIG_AQUANTIA_PHY_FW_DOWNLOAD_GANG=y/# CONFIG_AQUANTIA_PHY_FW_DOWNLOAD_GANG is not set/g' ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4

#prepare mtk jedi wifi stuff
prepare_mtwifi ${branch_name}

prepare_final ${branch_name}


#step2 build
build ${branch_name} -pb || [ "$LOCAL" != "1" ]
