#!/bin/bash
source ./autobuild/lede-build-sanity.sh

#get the brach_name
temp=${0%/*}
branch_name=${temp##*/}
swpath=0
backport_new=1
hostapd_new=1
release=0
kite=0
release_folder=${BUILD_DIR}/feeds/mtk_openwrt_feed/autobuild_mac80211_release
args=

for arg in $*; do
	case "$arg" in
	"swpath")
		swpath=1
		;;
	"kasan")
		kasan=1
		;;
	"release")
		release=1
		;;
	"kite")
		kite=1
		;;
	*)
		args="$args $arg"
		;;
	esac
done
set -- $args

change_dot_config() {
	[ "$swpath" = "1" ] && {
		echo "==========SW PATH========="
		sed -i 's/CONFIG_BRIDGE_NETFILTER=y/# CONFIG_BRIDGE_NETFILTER is not set/g' ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		sed -i 's/CONFIG_NETFILTER_FAMILY_BRIDGE=y/# CONFIG_NETFILTER_FAMILY_BRIDGE is not set/g' ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		sed -i 's/CONFIG_SKB_EXTENSIONS=y/# CONFIG_SKB_EXTENSIONS is not set/g' ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		sed -i '/AUTOLOAD:=$(call AutoProbe,mt7996e)/a\  MODPARAMS.mt7996e:=wed_enable=0' ${BUILD_DIR}/package/kernel/mt76/Makefile
	}
	[ "$backport_new" = "1" ] && {
		rm -rf ${BUILD_DIR}/package/kernel/mt76/patches/*revert-for-backports*.patch
	}
	[ "$kasan" = "1" ] && {
		sed -i 's/# CONFIG_KERNEL_KASAN is not set/CONFIG_KERNEL_KASAN=y/g' ${BUILD_DIR}/.config
		sed -i 's/# CONFIG_KERNEL_KALLSYMS is not set/CONFIG_KERNEL_KALLSYMS=y/g' ${BUILD_DIR}/.config
		echo "CONFIG_KERNEL_KASAN_OUTLINE=y" >> ${BUILD_DIR}/.config
		echo "CONFIG_DEBUG_KMEMLEAK=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_DEBUG_KMEMLEAK_AUTO_SCAN=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "# CONFIG_DEBUG_KMEMLEAK_DEFAULT_OFF is not set" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_DEBUG_KMEMLEAK_MEM_POOL_SIZE=16000" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_DEBUG_KMEMLEAK_TEST=m" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KALLSYMS=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KASAN=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KASAN_GENERIC=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "# CONFIG_KASAN_INLINE is not set" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KASAN_OUTLINE=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_KASAN_SHADOW_OFFSET=0xdfffffd000000000" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "# CONFIG_TEST_KASAN is not set" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_SLUB_DEBUG=y" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		echo "CONFIG_FRAME_WARN=4096" >> ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
	}
	[ "$release" = "1" ] && {
		cp -rfa ${release_folder}/package/kernel/mt76/src/firmware ${BUILD_DIR}/package/kernel/mt76/src
	}
}

#step1 clean
#clean
#do prepare stuff
prepare

prepare_flowoffload

#prepare mac80211 mt76 wifi stuff
prepare_mac80211 ${backport_new} ${hostapd_new}

#hack mt76 firmware/eeprom
#===================firmware bin name format=========================
#define MT7915_FIRMWARE_WA		"mediatek/mt7915_wa.bin"
#define MT7915_FIRMWARE_WM		"mediatek/mt7915_wm.bin"
#define MT7915_ROM_PATCH		"mediatek/mt7915_rom_patch.bin"
#define MT7916_FIRMWARE_WA		"mediatek/mt7916_wa.bin"
#define MT7916_FIRMWARE_WM		"mediatek/mt7916_wm.bin"
#define MT7916_ROM_PATCH		"mediatek/mt7916_rom_patch.bin"
#define MT7996_FIRMWARE_WA		"mediatek/mt7996/mt7996_wa.bin"
#define MT7996_FIRMWARE_WM		"mediatek/mt7996/mt7996_wm.bin"
#define MT7996_ROM_PATCH		"mediatek/mt7996/mt7996_rom_patch.bin"
#define MT7996_FIRMWARE_WM_TM		"mediatek/mt7996/mt7996_wm_tm.bin"

FW_SOURCE_DIR=${BUILD_DIR}/package/kernel/mt76
mkdir -p ${FW_SOURCE_DIR}/src/firmware/mt7996
cp -rf ${FW_SOURCE_DIR}/firmware/mt7916/rebb/7916_WACPU_RAM_CODE_release.bin ${FW_SOURCE_DIR}/src/firmware/mt7916_wa.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7916/rebb/WIFI_RAM_CODE_MT7916.bin ${FW_SOURCE_DIR}/src/firmware/mt7916_wm.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7916/rebb/mt7916_patch_e1_hdr.bin ${FW_SOURCE_DIR}/src/firmware/mt7916_rom_patch.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7915/rebb/7915_WACPU_RAM_CODE_release.bin ${FW_SOURCE_DIR}/src/firmware/mt7915_wa.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7915/rebb/WIFI_RAM_CODE_7915_E2.bin ${FW_SOURCE_DIR}/src/firmware/mt7915_wm.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7915/rebb/mt7915_patch_e2_hdr.bin ${FW_SOURCE_DIR}/src/firmware/mt7915_rom_patch.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_MT7990_WACPU_RAM_CODE_1_1.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_wa.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_RAM_CODE_MT7990_1_1.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_wm.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_MT7990_PATCH_MCU_1_1_hdr.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_rom_patch.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_MT7990_PHY_RAM_CODE_1_1.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_dsp.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_RAM_CODE_MT7990_1_1_TESTMODE.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_wm_tm.bin

# find ${BUILD_DIR}/package/kernel/mt76/patches -name "*-mt76-*.patch" -delete
rm -rf ${BUILD_DIR}/package/kernel/mt76/patches/*

# copy from mt7988-mt7996-mac80211
cp -rf ${BUILD_DIR}/autobuild/mt7988-mt7996-mac80211/package/* ${BUILD_DIR}/package/
cp -rf ${BUILD_DIR}/autobuild/mt7988-mt7996-mac80211/target/* ${BUILD_DIR}/target/

# ========== specific modification on mt7996 autobuild for EHT support ==========
# patch hostapd to use latest version and add 11BE config
patch -p1 < ${release_folder}/mt7988_mt7996_mac80211/0002-add-EHT-config-for-hostapd.patch || exit 1
# patch hostapd to add phy mode and BW configuration for 11s
patch -p1 < ${BUILD_DIR}/autobuild/mt7988-mt7996-mac80211-11s/0004-append-phy-mode-and-bw-configuration.patch || exit 1

# remove some iw patches to let EHT work normally
rm -rf ${BUILD_DIR}/package/network/utils/iw/patches/001-nl80211_h_sync.patch
rm -rf ${BUILD_DIR}/package/network/utils/iw/patches/120-antenna_gain.patch
# ===========================================================

if [ "$release" = '1' ]; then
	# ========== follow mt7988_mt7996_mac80211 git01 patches ========================
	rm -rf ${BUILD_DIR}/autobuild/${branch_name}/package
	cp -rf ${release_folder}/mt7988_mt7996_mac80211/package/* ${BUILD_DIR}/package/
	# ===========================================================
fi

prepare_final ${branch_name}

if [ "$kite" = '0' ]; then
	rm -f ${BUILD_DIR}/package/kernel/mt76/patches/4*.patch
fi

change_dot_config

#step2 build
if [ -z ${1} ]; then
	build_log ${branch_name} -j1 || [ "$LOCAL" != "1" ]
fi
