#!/bin/bash
source ./autobuild/lede-build-sanity.sh

#get the brach_name
temp=${0%/*}
branch_name=${temp##*/}
bellwether=0
hwpath=0
backport_new=1
args=

for arg in $*; do
	case "$arg" in
	"bellwether")
		bellwether=1
		;;
	"hwpath")
		hwpath=1
		;;
	*)
		args="$args $arg"
		;;
	esac
done
set -- $args

change_dot_config() {
	[ "$hwpath" = "0" ] && {
		echo "==========SW PATH========="
		sed -i 's/CONFIG_BRIDGE_NETFILTER=y/# CONFIG_BRIDGE_NETFILTER is not set/g' ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		sed -i 's/CONFIG_NETFILTER_FAMILY_BRIDGE=y/# CONFIG_NETFILTER_FAMILY_BRIDGE is not set/g' ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		sed -i 's/CONFIG_SKB_EXTENSIONS=y/# CONFIG_SKB_EXTENSIONS is not set/g' ${BUILD_DIR}/target/linux/mediatek/mt7988/config-5.4
		sed -i '/AUTOLOAD:=$(call AutoProbe,mt7996e)/a\  MODPARAMS.mt7996e:=wed_enable=0' ${BUILD_DIR}/package/kernel/mt76/Makefile
	}
	[ "$backport_new" = "1" ] && {
		rm -rf ${BUILD_DIR}/package/kernel/mt76/patches/*revert-for-backports*.patch
	}
}

#step1 clean
#clean
#do prepare stuff
prepare

prepare_flowoffload

#prepare mac80211 mt76 wifi stuff
prepare_mac80211 ${backport_new}

#hack mt76 firmware/eeprom
#===================firmware bin name format=========================
#define MT7915_FIRMWARE_WA		"mediatek/mt7915_wa.bin"
#define MT7915_FIRMWARE_WM		"mediatek/mt7915_wm.bin"
#define MT7915_ROM_PATCH		"mediatek/mt7915_rom_patch.bin"
#define MT7916_FIRMWARE_WA		"mediatek/mt7916_wa.bin"
#define MT7916_FIRMWARE_WM		"mediatek/mt7916_wm.bin"
#define MT7916_ROM_PATCH		"mediatek/mt7916_rom_patch.bin"
#define MT7996_FIRMWARE_WA		"mediatek/mt7996/mt7996_wa.bin"
#define MT7996_FIRMWARE_WM		"mediatek/mt7996/mt7996_wm.bin"
#define MT7996_ROM_PATCH		"mediatek/mt7996/mt7996_rom_patch.bin"

FW_SOURCE_DIR=${BUILD_DIR}/package/kernel/mt76
mkdir -p ${FW_SOURCE_DIR}/src/firmware/mt7996
cp -rf ${FW_SOURCE_DIR}/firmware/mt7916/rebb/7916_WACPU_RAM_CODE_release.bin ${FW_SOURCE_DIR}/src/firmware/mt7916_wa.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7916/rebb/WIFI_RAM_CODE_MT7916.bin ${FW_SOURCE_DIR}/src/firmware/mt7916_wm.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7916/rebb/mt7916_patch_e1_hdr.bin ${FW_SOURCE_DIR}/src/firmware/mt7916_rom_patch.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7915/rebb/7915_WACPU_RAM_CODE_release.bin ${FW_SOURCE_DIR}/src/firmware/mt7915_wa.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7915/rebb/WIFI_RAM_CODE_7915_E2.bin ${FW_SOURCE_DIR}/src/firmware/mt7915_wm.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7915/rebb/mt7915_patch_e2_hdr.bin ${FW_SOURCE_DIR}/src/firmware/mt7915_rom_patch.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_MT7990_WACPU_RAM_CODE_1_1.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_wa.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_RAM_CODE_MT7990_1_1.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_wm.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_MT7990_PATCH_MCU_1_1_hdr.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_rom_patch.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_MT7990_PHY_RAM_CODE_1_1.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_dsp.bin
cp -rf ${FW_SOURCE_DIR}/firmware/mt7990/rebb/WIFI_RAM_CODE_MT7990_1_1_TESTMODE.bin ${FW_SOURCE_DIR}/src/firmware/mt7996/mt7996_wm_tm.bin

# ========== specific modification on mt7996 autobuild for EHT support ==========
# remove hostapd openwrt and mtk internal patches
rm -rf ${BUILD_DIR}/package/network/services/hostapd/patches/*.patch

# remove all mac80211 patches of openwrt and mtk internal, this autobuild will maintain all of them
rm -rf ${BUILD_DIR}/package/kernel/mac80211/patches/*

# find ${BUILD_DIR}/package/kernel/mt76/patches -name "*-mt76-*.patch" -delete
rm -rf ${BUILD_DIR}/package/kernel/mt76/patches/*

# patch hostapd to use latest version and add 11BE config
patch -p1 < ${BUILD_DIR}/autobuild/${branch_name}/0002-add-EHT-config-for-hostapd.patch || exit 1

# copy DSP & testmode firmware
patch -p1 < ${release_folder}/mt7988_mt7996_mac80211/0003-mt76-mt7996-copy-dsp-and-testmode-firmware.patch

# remove some iw patches to let EHT work normally
rm -rf ${BUILD_DIR}/package/network/utils/iw/patches/001-nl80211_h_sync.patch
rm -rf ${BUILD_DIR}/package/network/utils/iw/patches/120-antenna_gain.patch
# ===========================================================

prepare_final ${branch_name}

change_dot_config

#step2 build
if [ -z ${1} ]; then
	build_log ${branch_name} -j1 || [ "$LOCAL" != "1" ]
fi
