#!/bin/sh

cmd="$1"
if [ -z "$cmd" ]; then
    cmd="init"
fi

operator=`cat /etc/productInfo | grep operator= | cut -d '=' -f2`

#
# init switch chip basic config
#
init()
{
    ifconfig lan1 up
    switch vlan pvid 0 2
    switch vlan pvid 5 2
    switch vlan set 0 1 01110010
    switch vlan set 0 2 10000100
    switch reg w 2004 202403
    switch reg w 2010 810000100
    switch reg w 2104 4c2401
    switch reg w 2204 4a2401
    switch reg w 2304 462401
    switch reg w 2504 10403
    switch reg w 2510 100
    switch reg w 2604 e0400
    echo 2 > /sys/kernel/debug/hnat/qos_toggle #enable PPPQ mode

    # mesh topo checker need enable port 0 mac learning
    meshTopoChecker=`uci get easyMesh.checker.enable 2>/dev/null`
    if [ "X$meshTopoChecker" == "X1" ]; then
        echo "[jcg]enable port 0 mac learning"  > /dev/console
    else
        echo "[jcg]disable port 0 mac learning" > /dev/console
        switch reg w 200c fff10  # disable port0 mac learning
    fi

    switch reg w 250c fff10  # disable port5 mac learning
    switch reg w 260c fff10  # disable port6 mac learning

    # temp for china unicomm beijing test
    switch reg w 260c fff00   # enable port6 mac learning
    switch reg w 2104 4c2400  # port1 - port matrix mode
    switch reg w 2204 4a2400  # port2 - port matrix mode
    switch reg w 2304 462400  # port3 - port matrix mode

    boardModel=`cat /etc/productInfo | grep boardModel | cut -d '=' -f 2`
    if [ "$boardModel" != "PK968M" ]; then
        switch reg w 50ec 500
    fi
    switch reg w 10 FF61FFFF
}

#
# enable or disable wan's port mac learning
# $1 INPUT 0-disable wan port mac learning
#
enable_wan_port_mac_learning()
{
    local enable="$1"

    if [ "$enable" == "0" ]; then
        switch reg w 200c fff10      # disable
    elif [ "$enable" == "1" ]; then
        switch reg w 200c fff00      # enable
    fi
}

#
# main
#
echo "====$0 $cmd begining====" > /dev/console
if [ "$cmd" == "init" ];then
    init
elif [ "$cmd" == "disable_wan_learn_mac" ];then
    enable_wan_port_mac_learning 0
elif [ "$cmd" == "enable_wan_learn_mac" ];then
    enable_wan_port_mac_learning 1
else
    echo "$0 usage:"
    echo "  init                    : init swich basic config"
    echo "  disable_wan_learn_mac   : disable wan port learning mac"
    echo "  enable_wan_learn_mac    : enable wan port learning mac"
fi
echo "====$0 $cmd done====" > /dev/console
