/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein is
* confidential and proprietary to MediaTek Inc. and/or its licensors. Without
* the prior written permission of MediaTek inc. and/or its licensors, any
* reproduction, modification, use or disclosure of MediaTek Software, and
* information contained herein, in whole or in part, shall be strictly
* prohibited.
*
* Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
* ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
* WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
* NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
* RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
* INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
* TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
* RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
* OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
* SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
* RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
* ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
* RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
* MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
* CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
* The following software/firmware and/or related documentation ("MediaTek
* Software") have been modified by MediaTek Inc. All revisions are subject to
* any receiver's applicable license agreements with MediaTek Inc.
*/

#include "afc.h"
#include "Debug.h"
#include "afc_driver_intf.h"
#include "driver.h"

#define HTTP_TIMEOUT               60
#define SKIP_HOSTNAME_VERIFICATION 1
#define SKIP_PEER_VERIFICATION     1

int DebugLevel =         DEBUG_TRACE;
pthread_t readerthreads;
UINT8 afc_state =        AFC_HOLD;
UINT8 response_status =  RESPONSE_INITIAL;

extern char *pafcUrl;
extern char *pbearertoken;

struct MemoryStruct {
	char *memory;
	size_t size;
};


static size_t
WriteMemoryCallback(void *contents, size_t size, size_t nmemb, void *userp)
{
	size_t realsize = size * nmemb;
	struct MemoryStruct *mem = (struct MemoryStruct *)userp;

	char *ptr = realloc(mem->memory, mem->size + realsize + 1);
	if(!ptr) {
        	/* out of memory! */
		DBGPRINT(DEBUG_TRACE, "not enough memory (realloc returned NULL)\n");
		return 0;
	}

	mem->memory = ptr;
	memcpy(&(mem->memory[mem->size]), contents, realsize);
	mem->size += realsize;
	mem->memory[mem->size] = 0;

	return realsize;

}

void trigger_afc()
{
	afc_state = AFC_ASI_REQ_SEND;
	/* Creater HTTP Client thread */
	DBGPRINT(DEBUG_TRACE, "Tx ASI Requect : create thread\n");
	if (pthread_create(&readerthreads, NULL, send_afc_request, NULL)!= 0){
		/* Error in creating thread */
		DBGPRINT(DEBUG_TRACE, "Failed to create thread\n");
	}

}

void * send_afc_request(void * param)
{
	CURL *curl;
	CURLcode res;
	json_object *json_obj;

	struct MemoryStruct chunk;
	/* will be grown as needed by the realloc above */
	chunk.memory = malloc(1);
	/* no data at this point */
	chunk.size = 0;    /* no data at this point */

	/* In windows, this will init the winsock stuff */
	curl_global_init(CURL_GLOBAL_ALL);

	/* get a curl handle */
	curl = curl_easy_init();

	if(curl) {
		struct curl_slist *headers = NULL;
		headers  = curl_slist_append(headers, "Accept: application/json");
		headers  = curl_slist_append(headers, "Content-Type: application/json");
		headers  = curl_slist_append(headers, "charset: utf-8");

		curl_easy_setopt(curl, CURLOPT_URL, pafcUrl);
		curl_easy_setopt(curl, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);

		curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);

		DBGPRINT(DEBUG_TRACE, "build payload\n");
		json_obj = build_request();
		/* Now specify the POST data */
		curl_easy_setopt(curl, CURLOPT_POSTFIELDS,
				json_object_to_json_string(json_obj));
		/* send all data to this function  */
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteMemoryCallback);
        /* we pass our 'chunk' struct to the callback function */
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, (void *)&chunk);
        curl_easy_setopt(curl, CURLOPT_USERAGENT, "libcrp/0.1");

		/* ask libcurl to use TLS version 1.2 or later */
		if (httpTimeout)
			curl_easy_setopt(curl, CURLOPT_TIMEOUT, httpTimeout);
		else
			curl_easy_setopt(curl, CURLOPT_TIMEOUT, HTTP_TIMEOUT);

        curl_easy_setopt(curl, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);

		/* curl_easy_setopt(curl, CURLOPT_DEBUGFUNCTION, my_trace); */

		/* the DEBUGFUNCTION has no effect until we enable VERBOSE */
		curl_easy_setopt(curl, CURLOPT_VERBOSE, 1L);

		curl_easy_setopt(curl, CURLOPT_XOAUTH2_BEARER, pbearertoken);
		curl_easy_setopt(curl, CURLOPT_HTTPAUTH, CURLAUTH_BEARER);

#ifdef SKIP_PEER_VERIFICATION
		/*
		* If you want to connect to a site who is not using a certificate
		* that is signed by one of the certs in the CA bundle you have, you
		* can skip the verification of the server's certificate. This makes
		* the connection A LOT LESS SECURE.
		*
		* If you have a CA cert for the server stored someplace else than
		* in the default bundle, then the CURLOPT_CAPATH option might come
		* handy for you.
		*/
		curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 1L);
#endif
#ifdef SKIP_HOSTNAME_VERIFICATION
		/*
		* If the site you are connecting to uses a different host name that
         	* what they have mentioned in their server certificate's commonName
         	* (or subjectAltName) fields, libcurl will refuse to connect. You
         	* can skip this check, but this will make the connection less secure.
     	 	*/
		curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 1L);
#endif
		curl_easy_setopt(curl, CURLOPT_SSL_VERIFYSTATUS, statusCheck);
#ifdef SKIP_HTTPAUTH
		/* tell libcurl we can use "any" auth, which lets the lib pick one, but it
		also costs one extra round-trip and possibly sending of all the PUT
		data twice!!! */
		curl_easy_setopt(curl, CURLOPT_HTTPAUTH, (long)CURLAUTH_ANY);

		/* set user name and password for the authentication */
		curl_easy_setopt(curl, CURLOPT_USERPWD, "mtkuser:password123");
#endif
		DBGPRINT(DEBUG_TRACE, "Send HTTPs request\n");
		/* Perform the request, res will get the return code */
		res = curl_easy_perform(curl);

		/* Check for errors */
		if (afc_state == AFC_ASI_REQ_SEND) {
#ifndef DUMMY_RESPONSE
			if(res != CURLE_OK) {
				fprintf(stderr, "curl_easy_perform() failed: %s %d\n",
				curl_easy_strerror(res), res);

				afc_state = AFC_ASI_NO_RESPONSE;
				memset(glbl_afc_res_data, 0, MAX_RES_BUFFER_SIZE);
				*(UINT16 *)glbl_afc_res_data = RESPONSE_INVALID;
				counter = sizeof(struct afc_response);
			} else 
#endif//DUMMY_RESPONSE
			{
				DBGPRINT(DEBUG_TRACE, "%lu bytes retrieved\n", 
							(unsigned long)chunk.size);
				DBGPRINT(DEBUG_TRACE, "AFC system response : %s\n", chunk.memory);

				if (parse_afc_response_payload(chunk.memory))
					response_status = RESPONSE_INVALID; /* common timer for bootup and renewal */
				else
					response_status = RESPONSE_VALID;
				if (!MASK_REQUEST(query_type))
					afc_state = AFC_ASI_RES_RECEIVED;
			}
		}
		json_object_put(json_obj);
		free(chunk.memory);
		/* always cleanup */
		curl_easy_cleanup(curl);
	}

	curl_global_cleanup();
	pthread_exit(NULL);

	return NULL;

}

void delete_timers()
{
	expiry_epoch_time = 0;
	afc_req_trigger_time = 0;
}

void start_afc_daemon(int nl_socket, const char *intf)
{
	fd_set rfds;
	struct timeval timeout;
	int retval_select;
	time_t now = 0, afc_retry_time = 0;
	time_t pre_expiry_time = 0, expiry_time = 0;

	while (1)
	{
		FD_ZERO (&rfds);
		FD_SET (nl_socket, &rfds);

		timeout.tv_sec = 0;
		timeout.tv_usec = 10000;

		retval_select = select (nl_socket + 1, &rfds, NULL, NULL, &timeout);

		if (retval_select < 0 && errno != EINTR && errno != 0) {
			DBGPRINT(DEBUG_ERROR, "Error in select() \n");
			return;
		}
		else if (retval_select)
		{
			read_event (nl_socket);
		}

		if (afc_state == AFC_RECEIVED_INQ_EVENT) {
			delete_timers();//check
			trigger_afc();
		}
		else if (afc_state == AFC_STOP) {
			delete_timers();
		}
		else if((afc_state == AFC_ASI_RES_RECEIVED) &&
						(response_status == RESPONSE_VALID)) {
			afc_state = AFC_SET_RES_PARAMS;
                    DBGPRINT(DEBUG_ERROR, "afc_state AFC_SET_RES_PARAMS= %d, %d, %d\n",afc_state, counter, *(UINT16 *)glbl_afc_res_data);

#ifdef SKU_BE19000
			int drv_mode = NL80211;
			int opmode = OPMODE_AP;
			struct afc_app *afc, afc_nl;

			afc = &afc_nl;
			int ret = 0;
			ret = afc_socket_and_ctrl_inf_init(afc, drv_mode, opmode);
			ret = set_afc_param(afc, intf, (char *)glbl_afc_res_data, counter);
			if (ret < 0) {
				DBGPRINT(DEBUG_ERROR, "\n%s, returned Falied\n", __FUNCTION__);
				return;
			}
#else
			if (trigger_ioctl(intf, OID_SET_AFC_CONFIG, (char *)glbl_afc_res_data, counter) < 0) {
				DBGPRINT(DEBUG_ERROR, "\n%s, returned Falied\n", __FUNCTION__);
				return;
			}
#endif
			afc_state = AFC_TIMER_WAIT;
			response_status = RETRY_WAIT;
			pre_expiry_time = afc_req_trigger_time;
			expiry_time = expiry_epoch_time;
		}
		else if(afc_state == AFC_TIMER_WAIT) {
			time(&now);

			if (now >= pre_expiry_time) {
				DBGPRINT(DEBUG_OFF, "afc_req_trigger_time expired \n");
				pre_expiry_time = 0;
				requestId_operation();
				trigger_afc();
			}
		}
		else if ((response_status == RESPONSE_INVALID) ||
									(afc_state == AFC_ASI_NO_RESPONSE)) {
			if ((expiry_time && (now >= expiry_time)) ||
									(!afc_retry_time && !expiry_time)) {
				DBGPRINT(DEBUG_OFF,
					"Report Response failure to Driver %lu \n", expiry_time);
				expiry_time = 0;
				delete_timers();

#ifdef SKU_BE19000

			int drv_mode = NL80211;
			int opmode = OPMODE_AP;
			struct afc_app *afc, afc_nl;

			afc = &afc_nl;
			int ret = 0;
			ret = afc_socket_and_ctrl_inf_init(afc, drv_mode, opmode);

			ret = set_afc_param(afc, intf, (char *)glbl_afc_res_data, counter);
			if (ret < 0) {
				DBGPRINT(DEBUG_ERROR, "\n%s, returned Falied\n", __FUNCTION__);
				return;
			}
#else
			if (trigger_ioctl(intf, OID_SET_AFC_CONFIG, (char *)glbl_afc_res_data, counter) < 0) {
				DBGPRINT(DEBUG_ERROR, "\n%s, returned Falied\n", __FUNCTION__);
				return;
			}
#endif

			}
			time(&now);
			afc_state = AFC_REQ_RETRY;

			/* initializing retry timer to 1 min at bootup time */
			if (response_status == RESPONSE_INITIAL)
				afc_retry_time = now + RETRY_TIMER_BOOTUP;

			/* initializing retry timer to 1 min, if received invalid response*/
			else if (response_status == RESPONSE_INVALID)
				afc_retry_time = now + RETRY_TIMER_AFC_INVALID_RESPONSE;

			/* initializing retry timer to 1 min, if no response received while renewing*/
			else
				afc_retry_time = now + RETRY_TIMER_AFC_RENEWAL;

			/* In case if retry time is greater than the expiry time set retry to Expiry Time */
			if (expiry_time && (afc_retry_time > expiry_time))
				afc_retry_time = expiry_time;

			response_status = RETRY_WAIT;
			DBGPRINT(DEBUG_OFF, "SET retry Timer to %lu \n",afc_retry_time);
		}
		else if (afc_state == AFC_REQ_RETRY) {
			time(&now);

			if (now >= afc_retry_time) {
				DBGPRINT(DEBUG_OFF, "afc_state AFC_REQ_RETRY= %d\n",afc_state);
				trigger_afc();
			}
		}
	}
}

int main(int argc, char *argv[])
{
	int nl_socket = -1;
	int Status = -1;

	if (read_config() != 0) {
		goto error;
	}
	nl_socket = open_netlink_socket();
	if (nl_socket < 0) {
		goto error;
	}
	DBGPRINT(DEBUG_ERROR, "--> %s\n", argv[1]);
	if (argc > 1) {
		get_device_data(argv[1]);
	} else {
		get_device_data(INTF);
	}

	print_AFC_config_data();
	if (afc_state != AFC_READY_REQ_DATA) {
		DBGPRINT(DEBUG_ERROR, "Wrong AFC state !\n");
		return Status;
	}
	start_afc_daemon(nl_socket, argv[1]);

error:
	afc_free(nl_socket);

	return Status;
}
