/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein is
* confidential and proprietary to MediaTek Inc. and/or its licensors. Without
* the prior written permission of MediaTek inc. and/or its licensors, any
* reproduction, modification, use or disclosure of MediaTek Software, and
* information contained herein, in whole or in part, shall be strictly
* prohibited.
*
* Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
* ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
* WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
* NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
* RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
* INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
* TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
* RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
* OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
* SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
* RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
* ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
* RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
* MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
* CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
* The following software/firmware and/or related documentation ("MediaTek
* Software") have been modified by MediaTek Inc. All revisions are subject to
* any receiver's applicable license agreements with MediaTek Inc.
*/

#ifndef __AFC_H__
#define __AFC_H__

#include <asm/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <net/if.h>
#include <netinet/in.h>
#include <linux/netlink.h>
#include <linux/rtnetlink.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <curl/curl.h>
#include<json-c/json.h>
#include <pthread.h>
#include <sys/ioctl.h>
#include <linux/wireless.h>
#include <inttypes.h>
#include <fcntl.h>
#include <sys/time.h>

#define UINT8 unsigned char
#define UINT16 unsigned short
#define UINT32 unsigned long

//#define DUMMY_RESPONSE

#define OPMODE_STA 0
#define OPMODE_AP 1

#define FALSE 0
#define TRUE 1
#define TLV_HEADER 3

#define MAX_URL_LEN         256
#define MAX_VERSION_LEN		8
#define MAX_REQUEST_ID_LEN	24
#define MAX_RULESET_ID_LEN	48
//#define MAX_NRA_LEN			6
#define MAX_CERT_ID_LEN		10
#define MAX_VECTOR_LENGTH_LEN	12
#define MAX_VECTOR_ANGLE_LEN	12
#define MAX_LONGITUDE_LEN	12
#define MAX_LATITUDE_LEN	12
#define MAX_NUM_OF_VECTOR	15
#define MAX_NUM_OF_POINTS	15
#define MAX_NUM_OF_OPCLS	6

#define RETRY_TIMER_BOOTUP 30
#define RETRY_TIMER_AFC_RENEWAL 60
#define RETRY_TIMER_AFC_INVALID_RESPONSE 90

#define MAX_RES_BUFFER_SIZE 2048

UINT8 read_config(void);
void afc_free(int nl_socket);
void print_TLV(UINT8 tag);
void print_AFC_config_data(void);
void get_device_data(const char *intf);
void trigger_afc(void);
void * send_afc_request(void * param);
struct json_object  *build_request(void);
int read_event (int sockint);
int open_netlink_socket (void);
int trigger_ioctl(const char *intf, int oid, char *pdatay, int len);
UINT16 parse_afc_response_payload(char *payload);

extern UINT8 glbl_afc_res_data[];
extern UINT8 afc_state;
extern UINT8 response_status;
extern UINT8 query_type;
extern unsigned short counter;
extern struct AFC_request glbl_afc_req_data;
extern time_t expiry_epoch_time;
extern time_t afc_req_trigger_time;
extern UINT16 httpTimeout;
extern UINT8 Empty_request;
extern UINT32 statusCheck;


#define MASK_REQUEST(a) (a & 0xF0)
#define MASK_PRIORITY(a) (a & 0x0F)
#define RESPONSE_FILLED(b) ((b == 0xc0) || (b == 0x00))
#define MASK_FREQ_BIT (0x80)
#define MASK_OPCLASS_BIT (0x40)
#define DEFAULT_REQUEST (0x00)
#define TWO_REQ_RESP_FQ_OP (0x01)
#define TWO_REQ_RESP_OP_FQ (0x02)
#define ONLY_FREQ_RANGE (0x03)
#define ONLY_OPCLASS (0x04)

enum afcState
{
	AFC_HOLD,
	AFC_INIT_DONE,
	AFC_READY_REQ_DATA,
	AFC_RECEIVED_INQ_EVENT,
	AFC_ASI_REQ_SEND,
	AFC_ASI_RES_WAIT,
	AFC_ASI_RES_RECEIVED,
	AFC_SET_RES_PARAMS,
	AFC_TIMER_WAIT,
	AFC_TIMER_EXPIRED,
	AFC_REQ_RETRY,
	AFC_ASI_RES_FAILED,
	AFC_ASI_NO_RESPONSE,
	AFC_STOP
};

enum responseStatus
{
	RESPONSE_VALID,
	RESPONSE_INVALID,
	RETRY_WAIT,
	CONNECTION_ERROR = 7,
	RESPONSE_TIMEOUT = 28,
	RESPONSE_EMPTY = 52,
	RESPONSE_INITIAL = 0xFF,
};

struct inquiredFrequencyRange
{
	UINT16 lowFrequency;
	UINT16 highFrequency;
};

struct inquiredChannels
{
	UINT8 globalOperatingClass;
	UINT8 NumofChannels;
	UINT8 ChannelList[59];
};

struct point
{
	char longitude[MAX_LONGITUDE_LEN];
	char latitude[MAX_LATITUDE_LEN];
};

struct linearPolygon
{
	UINT8 NumOfPoints;
	struct point linerPoint[MAX_NUM_OF_POINTS];
};

struct vector
{
	char length[MAX_VECTOR_LENGTH_LEN];
	char angle[MAX_VECTOR_ANGLE_LEN];
};

struct radialPolygon
{
	UINT8 NumOfVectors;
	struct point Centre;
	struct vector Vector[MAX_NUM_OF_VECTOR];
};

struct elevation
{
	char *height;
	char *heightType;
	UINT8 verticalUncertainty;
};

struct ellipse
{
	struct point Centre;
	UINT8 majorAxis;
	UINT8 minorAxis;
	UINT8 orientation;
};

union Locationtype {
	struct ellipse ellip;
	struct linearPolygon lin_polygon;
	struct radialPolygon radi_polygon;
};

struct location
{
	UINT8 LocationMethod;
	union Locationtype locationData;
	struct elevation Elevation;
	UINT16 indoorDeployment;
};

struct certificationId
{
//	char nra[MAX_NRA_LEN];
	struct rulesetId *rulesetIds;
	char *id;
};

struct rulesetId
{
	char rSetId[MAX_RULESET_ID_LEN];
	struct rulesetId *next;
};

struct deviceDescriptor
{
	char *serialNumber;
	struct certificationId CertID ;
};

struct AvailableSpectrumInquiryRequest
{
	char requestId[MAX_REQUEST_ID_LEN];
	struct deviceDescriptor Descriptor;
	struct location GeoLocation;
	UINT32 NumOfOpFreqRange;
	struct inquiredFrequencyRange * freqRange;
	UINT8 NumOfOpClass;
	struct inquiredChannels Channels[MAX_NUM_OF_OPCLS];
	short minDesiredPower;
};

struct AFC_request
{
	UINT8 version[MAX_VERSION_LEN];
	struct AvailableSpectrumInquiryRequest ASI_request;
};

struct afc_response
{
	UINT16 status;
	UINT8 Resv[2];
	UINT8 data[0];
};

#endif /* __AFC_H__ */

