/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein is
* confidential and proprietary to MediaTek Inc. and/or its licensors. Without
* the prior written permission of MediaTek inc. and/or its licensors, any
* reproduction, modification, use or disclosure of MediaTek Software, and
* information contained herein, in whole or in part, shall be strictly
* prohibited.
*
* Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
* ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
* WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
* NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
* RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
* INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
* TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
* RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
* OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
* SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
* RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
* ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
* RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
* MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
* CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
* The following software/firmware and/or related documentation ("MediaTek
* Software") have been modified by MediaTek Inc. All revisions are subject to
* any receiver's applicable license agreements with MediaTek Inc.
*/

#include "afc.h"
#include "Debug.h"
#include "afc_driver_intf.h"

#define MINIMUM_DESIRED_POWER_ENABLED 1
#define FREQUENCY_RANGE_ENABLED 1

time_t expiry_epoch_time, afc_req_trigger_time;
UINT8 glbl_afc_res_data[MAX_RES_BUFFER_SIZE];
UINT16 counter;
UINT8 query_type;

void print_json_object(struct json_object *jobj, const char *msg) {
	DBGPRINT(DEBUG_TRACE, "\n%s: \n", msg);
	DBGPRINT(DEBUG_TRACE, "---\n%s\n---\n", json_object_to_json_string(jobj));
}
void requestId_operation()
{
	char ch;
	int i;
	if (glbl_afc_req_data.ASI_request.requestId) {
		for (i = strlen(glbl_afc_req_data.ASI_request.requestId); i > 0; i--) {
		ch = glbl_afc_req_data.ASI_request.requestId[i - 1];
			if ((ch >= '0') && (ch <= '9')) {
				if (ch == '9')
					ch = 'A';
				else
					ch++;
			} else if (((ch >= 'A') && (ch <= 'Z')) ||
				((ch >= 'a') && (ch <= 'z'))) {

				if ((ch == 'z') || (ch == 'Z'))
					continue;
				else
					ch++;
			} else {
				continue;
			}
			break;
		}
		if (i <= 0) {
			for (i = strlen(glbl_afc_req_data.ASI_request.requestId); i > 0; i--) {
				ch = glbl_afc_req_data.ASI_request.requestId[i - 1];
				if ((ch == 'z') || (ch == 'Z'))
					continue;
				break;
			}
			ch = '0';
		}
		if (i <= 0)
			memset(glbl_afc_req_data.ASI_request.requestId, '0', strlen(glbl_afc_req_data.ASI_request.requestId));
		glbl_afc_req_data.ASI_request.requestId[i - 1] = ch;
	}
}


UINT8 is_freq_range()
{
	UINT8 Status = 0;
	UINT8 local = MASK_REQUEST(query_type);

	if (glbl_afc_req_data.ASI_request.NumOfOpFreqRange == 0)
		return Status;
	if ((local == MASK_FREQ_BIT) || (MASK_PRIORITY(query_type)  >= ONLY_OPCLASS))
		return Status;

	if ((query_type == TWO_REQ_RESP_FQ_OP) || (query_type == (MASK_OPCLASS_BIT | TWO_REQ_RESP_OP_FQ)))
		query_type |= MASK_FREQ_BIT;
	DBGPRINT(DEBUG_TRACE, "\nquery_type %x\n", query_type);
	return 1;
}

UINT8 is_op_class()
{
	UINT8 Status = 0;
	UINT8 local = MASK_REQUEST(query_type);

	if (glbl_afc_req_data.ASI_request.NumOfOpClass == 0)
		return Status;
	if ((local == MASK_OPCLASS_BIT) || (MASK_PRIORITY(query_type) == ONLY_FREQ_RANGE) )
		return Status;

	if ((query_type == TWO_REQ_RESP_OP_FQ) || (query_type == (MASK_FREQ_BIT | TWO_REQ_RESP_FQ_OP)))
		query_type |= MASK_OPCLASS_BIT;

	return 1;
}

/*
 * This function converts the AFC request
 * payload data into Json format using Json-c lib.
 */
struct json_object  *build_request() {
	struct json_object *json_obj, *json_obj2, *sub_obj2, *sub_obj3, *array_1, *array_2;
	struct rulesetId *temp;
	double longi = 0, height = 0;
	int i = 0;

	json_obj = json_object_new_object();

	if (Empty_request)
		goto EMPTY;
	json_obj2 = json_object_new_object();
	array_1 = json_object_new_array();
	array_2 = json_object_new_array();
	//array_3 = json_object_new_array();
	sub_obj2 = json_object_new_object();
	sub_obj3 = json_object_new_object();

	if (glbl_afc_req_data.version[0] != 0xFF)
		json_object_object_add(json_obj, "version", json_object_new_string((const char *)glbl_afc_req_data.version));

	if (glbl_afc_req_data.ASI_request.requestId[0] != 0xFF)
		json_object_object_add(json_obj2, "requestId", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.requestId));

	if ((UINT8)glbl_afc_req_data.ASI_request.Descriptor.serialNumber != 0xFF)
		json_object_object_add(sub_obj3, "serialNumber", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.Descriptor.serialNumber));

//	if (glbl_afc_req_data.ASI_request.Descriptor.CertID.nra[0] != 0xFF)
//		json_object_object_add(sub_obj2, "nra", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.nra));

	temp = glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds;
	while(temp && ((UINT8)temp != 0xFF)) {
		DBGPRINT(DEBUG_TRACE, "%s\n",temp->rSetId);
		json_object_object_add(sub_obj2, "rulesetId", json_object_new_string((const char *)temp->rSetId));
		temp = temp->next;
		DBGPRINT(DEBUG_TRACE, "%s done\n",temp->rSetId);
	}

	if ((UINT8)glbl_afc_req_data.ASI_request.Descriptor.CertID.id != 0xFF)
		json_object_object_add(sub_obj2, "id", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.id));

	json_object_array_add(array_2, sub_obj2);

	json_object_object_add(sub_obj3, "certificationId", array_2);

/*	temp = glbl_afc_req_data.ASI_request.Descriptor.rulesetIds;

	while(temp && ((UINT8)temp != 0xFF)) {
		DBGPRINT(DEBUG_TRACE, "%s\n",temp->rSetId);
		json_object_array_add(array_3, json_object_new_string((const char *)temp->rSetId));
		temp = temp->next;
	}
	json_object_object_add(sub_obj3, "rulesetIds", array_3);
*/
	json_object_object_add(json_obj2, "deviceDescriptor", sub_obj3);

	struct json_object *centr_obj, *ellipse_obj, *outerBoundary_obj, *elevation_obj, *location_obj, *freq_obj, *enqFreqRange, *opClass_obj, *inqCh_array, *chListarray;

	if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 0) {
		centr_obj = json_object_new_object();
#ifdef TEST_ERROR_CODE_103
		if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude[0] != 0xFF)
			json_object_object_add(centr_obj, "longitude", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude));

		if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude[0] != 0xFF)
			json_object_object_add(centr_obj, "latitude", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude));
#else
		if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude[0] != 0xFF)
			json_object_object_add(centr_obj, "longitude", json_object_new_double_s(longi,glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude));

		if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude[0] != 0xFF)
			json_object_object_add(centr_obj, "latitude", json_object_new_double_s(longi,glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude));
#endif
		ellipse_obj = json_object_new_object();
		json_object_object_add(ellipse_obj, "center", centr_obj);

		if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.majorAxis != 0xFF)
			json_object_object_add(ellipse_obj, "majorAxis", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.majorAxis));

		if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.minorAxis != 0xFF)
			json_object_object_add(ellipse_obj, "minorAxis", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.minorAxis));

		if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.orientation != 0xFF)
			json_object_object_add(ellipse_obj, "orientation", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.orientation));

		elevation_obj = json_object_new_object();
		if ((UINT8)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height != 0xFF)
			json_object_object_add(elevation_obj, "height", json_object_new_double_s(height,glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height));
		if ((UINT8)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType != 0xFF)
			json_object_object_add(elevation_obj, "heightType", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType));
		if ((UINT8)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty != 0xFF)
			json_object_object_add(elevation_obj, "verticalUncertainty", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty));

		location_obj = json_object_new_object();
		json_object_object_add(location_obj, "ellipse", ellipse_obj);
		json_object_object_add(location_obj, "elevation", elevation_obj);

		if (glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment!= 0xFFFF)
			json_object_object_add(location_obj, "indoorDeployment", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment));

		json_object_object_add(json_obj2, "location", location_obj);

	} else if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 1) {
		location_obj = json_object_new_object();
		ellipse_obj = json_object_new_array();
		outerBoundary_obj = json_object_new_object();

		for (i = 0; i < glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.NumOfPoints; i++) {
			centr_obj = json_object_new_object();
			json_object_object_add(centr_obj, "longitude", json_object_new_double_s(longi,glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[i].longitude));
			json_object_object_add(centr_obj, "latitude", json_object_new_double_s(longi,glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[i].latitude));
			json_object_array_add(ellipse_obj, centr_obj);
		}

		json_object_object_add(outerBoundary_obj, "outerBoundary", ellipse_obj);
		elevation_obj = json_object_new_object();
		json_object_object_add(elevation_obj, "height", json_object_new_double_s(height,glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height));
		json_object_object_add(elevation_obj, "heightType", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType));
		json_object_object_add(elevation_obj, "verticalUncertainty", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty));

		json_object_object_add(location_obj, "linearPolygon", outerBoundary_obj);
		json_object_object_add(location_obj, "elevation", elevation_obj);
		json_object_object_add(location_obj, "indoorDeployment", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment));
		json_object_object_add(json_obj2, "location", location_obj);

	} else if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 2) {
		centr_obj = json_object_new_object();
		location_obj = json_object_new_object();
		ellipse_obj = json_object_new_object();

		json_object_object_add(centr_obj, "longitude", json_object_new_double_s(longi,glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.longitude));
		json_object_object_add(centr_obj, "latitude", json_object_new_double_s(longi,glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.latitude));

		ellipse_obj = json_object_new_object();
		json_object_object_add(ellipse_obj, "center", centr_obj);

		outerBoundary_obj = json_object_new_array();
		for (i = 0; i < glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.NumOfVectors; i++) {
			centr_obj = json_object_new_object();
			json_object_object_add(centr_obj, "angle", json_object_new_double_s(longi,glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Vector[i].angle));
			json_object_object_add(centr_obj, "length", json_object_new_double_s(longi,glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Vector[i].length));
			json_object_array_add(outerBoundary_obj, centr_obj);
		}
		json_object_object_add(ellipse_obj, "outerBoundary", outerBoundary_obj);

		elevation_obj = json_object_new_object();
		json_object_object_add(elevation_obj, "height", json_object_new_double_s(height,glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height));
		json_object_object_add(elevation_obj, "heightType", json_object_new_string((const char *)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType));
		json_object_object_add(elevation_obj, "verticalUncertainty", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty));

		json_object_object_add(location_obj, "radialPolygon", ellipse_obj);
		json_object_object_add(location_obj, "elevation", elevation_obj);
		json_object_object_add(location_obj, "indoorDeployment", json_object_new_int(glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment));
		json_object_object_add(json_obj2, "location", location_obj);

	}
#ifdef FREQUENCY_RANGE_ENABLED
	if (is_freq_range() && (query_type != TWO_REQ_RESP_OP_FQ))
	{
		if (glbl_afc_req_data.ASI_request.freqRange != 0xFF)
		{
			enqFreqRange = json_object_new_array();

			for (i = 0; i < glbl_afc_req_data.ASI_request.NumOfOpFreqRange; i++) {
				freq_obj = json_object_new_object();
				json_object_object_add(freq_obj, "lowFrequency", json_object_new_int(glbl_afc_req_data.ASI_request.freqRange[i].lowFrequency));
				json_object_object_add(freq_obj, "highFrequency", json_object_new_int(glbl_afc_req_data.ASI_request.freqRange[i].highFrequency));
				json_object_array_add(enqFreqRange, freq_obj);
			}
			json_object_object_add(json_obj2, "inquiredFrequencyRange", enqFreqRange);
			if (MASK_REQUEST(query_type) != 0)
				goto skipOpclass;
		}
	}
#endif

	if (is_op_class()) {
		UINT8 j = 0;
		inqCh_array = json_object_new_array();
		for (i = 0; i < glbl_afc_req_data.ASI_request.NumOfOpClass; i++) {

			UINT8 *pchannel = &glbl_afc_req_data.ASI_request.Channels[i].NumofChannels;
			opClass_obj = json_object_new_object();
			json_object_object_add(opClass_obj, "globalOperatingClass", json_object_new_int(glbl_afc_req_data.ASI_request.Channels[i].globalOperatingClass));
			//pchannel = NULL;
			if (*pchannel) {
				chListarray = json_object_new_array();
				for(j = 1; j <= *pchannel; j++) {
					if(*(pchannel + j) <= 233 )
						json_object_array_add(chListarray, json_object_new_int(*(pchannel + j)));
				}
				json_object_object_add(opClass_obj, "channelCfi", chListarray);
			}
			json_object_array_add(inqCh_array, opClass_obj);
		}
		json_object_object_add(json_obj2, "inquiredChannels", inqCh_array);
	}

skipOpclass:

#ifdef MINIMUM_DESIRED_POWER_ENABLED
	if (glbl_afc_req_data.ASI_request.minDesiredPower != 0xFF){
		json_object_object_add(json_obj2, "minDesiredPower", json_object_new_int(glbl_afc_req_data.ASI_request.minDesiredPower));
	}
#endif
	json_object_array_add(array_1, json_obj2);

	json_object_object_add(json_obj, "availableSpectrumInquiryRequests", array_1);
	print_json_object(json_obj, "AFC request Payload");

	EMPTY:
	return json_obj;
}

void calculate_expiry_time(const char *expiry_str)
{
	char *token;
	struct tm expiry_time;
	unsigned char count = 0;
	unsigned short year = 0, mon = 0, date = 0, hour = 0, min = 0, sec = 0;
	token = strtok((char *)expiry_str, "-");
	time_t now;

	while(token) {
		switch (count)
		{
			case 0:
				year = strtol(token, NULL, 10);
				token = strtok(NULL, "-");
				break;

			case 1:
				mon = strtol(token, NULL, 10);
				token = strtok(NULL, "T");
				break;

			case 2:
				date= strtol(token, NULL, 10);
				token = strtok(NULL, ":");
				break;

			case 3:
				hour = strtol(token, NULL, 10);
				token = strtok(NULL, ":");
				break;
			case 4:

				min = strtol(token, NULL, 10);
				token = strtok(NULL, "Z");
				break;

			case 5:
				sec = strtol(token, NULL, 10);
				break;

		}
		count++;
		if (count > 5)
		break;

	}
	DBGPRINT(DEBUG_TRACE, "year = %d, Mon = %d, day = %d, hour = %d, min = %d, sec = %d\n",
						year, mon, date, hour, min, sec);

	expiry_time.tm_year = year - 1900;
	expiry_time.tm_mon = mon - 1;
	expiry_time.tm_mday = date;
	expiry_time.tm_hour = hour;
	expiry_time.tm_min = min;
	expiry_time.tm_sec = sec;
	expiry_time.tm_isdst = -1;
	expiry_epoch_time = mktime(&expiry_time);
	DBGPRINT(DEBUG_ERROR, "expiry_time = %lu\n",
						expiry_epoch_time);
	time(&now);
	if (expiry_epoch_time > now) {
		afc_req_trigger_time = now + (((expiry_epoch_time - now) * 80) / 100);
		DBGPRINT(DEBUG_TRACE, "now = %lu , afc_req_trigger_time = %lu\n",
							now, afc_req_trigger_time);
	} else {
		DBGPRINT(DEBUG_TRACE, "Expiry Time is Invalid: now = %lu , expiry_epoch_time = %lu\n",
							now, expiry_epoch_time);
		afc_req_trigger_time = expiry_epoch_time;
	}
}


void add_tag_length_value(UINT8 tag, UINT16 len, char *p_value)
{
	glbl_afc_res_data[counter++] = tag;
	*(UINT16 *)&glbl_afc_res_data[counter] = len;
	counter += sizeof(UINT16);
	if (p_value != NULL)
		strncpy((char *)&glbl_afc_res_data[counter], p_value, len);
	counter += len;
}

UINT16 parse_afc_response_payload(char *payload)
{
	struct json_object *parsed_json;
	struct json_object *version;
	struct json_object *afcResponse;
	struct json_object *response;
	struct json_object *json_obj1, *json_obj2, *json_obj3, *json_obj4, *json_obj5, *json_obj6, *json_obj7;
	struct json_object *temp;
	int n_Response = 0, n_frequency = 0, n_Channel = 0;
	int i = 0, j = 0, k = 0, len = 0, asi_len = 5;
	UINT16 status = RESPONSE_INVALID;
	UINT16 *pfreq_data = NULL;
	UINT8 local = MASK_REQUEST(query_type);

	if (!(local == (MASK_FREQ_BIT | MASK_OPCLASS_BIT))) {
		memset(glbl_afc_res_data, 0, MAX_RES_BUFFER_SIZE);
		*(UINT16 *)glbl_afc_res_data = RESPONSE_INVALID;
		counter = sizeof(struct afc_response);
	}
#ifdef DUMMY_RESPONSE
	char *tempPayload = "{\"availableSpectrumInquiryResponses\": [{\"availabilityExpireTime\": \"2022-08-23T12:53:18Z\", \"availableChannelInfo\": [{\"channelCfi\": [1, 5, 9, 13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69, 73, 77, 81, 85, 89, 93, 117, 121, 125, 129, 133, 137, 141, 145, 149, 153, 157, 161, 165, 169, 173, 177, 181], \"globalOperatingClass\": 131, \"maxEirp\": [5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5]}, {\"channelCfi\": [3, 11, 19, 27, 35, 43, 51, 59, 67, 75, 83, 91, 123, 131, 139, 147, 155, 163, 171, 179], \"globalOperatingClass\": 132, \"maxEirp\": [5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5]}, {\"channelCfi\": [7, 23, 39, 55, 71, 87, 135, 151, 167], \"globalOperatingClass\": 133, \"maxEirp\": [5, 5, 5, 5, 5, 5, 5, 5, 5]}, {\"channelCfi\": [15, 47, 79, 143], \"globalOperatingClass\": 134, \"maxEirp\": [5, 5, 5, 5]}, {\"channelCfi\": [], \"globalOperatingClass\": 135, \"maxEirp\": []}], \"availableFrequencyInfo\": [{\"frequencyRange\": {\"highFrequency\": 6425, \"lowFrequency\": 5925}, \"maxPSD\": 3.98970004336019}, {\"frequencyRange\": {\"highFrequency\": 6865, \"lowFrequency\": 6525}, \"maxPSD\": 3.98970004336019}], \"requestId\": \"11235814\", \"response\": {\"responseCode\": 0, \"shortDescription\": \"Success\"}, \"rulesetId\": \"US_47_CFR_PART_15_SUBPART_E\"}], \"version\": \"1.1\"}";
	//char *tempPayload = "{\"availableSpectrumInquiryResponses\": [{\"availabilityExpireTime\": \"2022-08-16T12:53:18Z\", \"availableChannelInfo\": [{\"channelCfi\": [1, 5, 9, 13, 17, 21, 25, 29, 33, 37, 41, 45, 49, 53, 57, 61, 65, 69, 73, 77, 81, 85, 89, 93, 117, 121, 125, 129, 133, 137, 141, 145, 149, 153, 157, 161, 165, 169, 173, 177, 181], \"globalOperatingClass\": 131, \"maxEirp\": [36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36]}, {\"channelCfi\": [3, 11, 19, 27, 35, 43, 51, 59, 67, 75, 83, 91, 123, 131, 139, 147, 155, 163, 171, 179], \"globalOperatingClass\": 132, \"maxEirp\": [36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36]}, {\"channelCfi\": [7, 23, 39, 55, 71, 87, 135, 151, 167], \"globalOperatingClass\": 133, \"maxEirp\": [36, 36, 36, 36, 36, 36, 36, 36, 36]}, {\"channelCfi\": [15, 47, 79, 143], \"globalOperatingClass\": 134, \"maxEirp\": [36, 36, 36, 36]}, {\"channelCfi\": [], \"globalOperatingClass\": 135, \"maxEirp\": []}], \"availableFrequencyInfo\": [{\"frequencyRange\": {\"highFrequency\": 6425, \"lowFrequency\": 5925}, \"maxPSD\": 22.98970004336019}, {\"frequencyRange\": {\"highFrequency\": 6865, \"lowFrequency\": 6525}, \"maxPSD\": 22.98970004336019}], \"requestId\": \"11235814\", \"response\": {\"responseCode\": 0, \"shortDescription\": \"Success\"}, \"rulesetId\": \"US_47_CFR_PART_15_SUBPART_E\"}], \"version\": \"1.1\"}";


	payload = malloc(strlen(tempPayload) + 1);
	strcpy(payload, tempPayload);
	payload[strlen(tempPayload)] = '\0';
	DBGPRINT(DEBUG_ERROR, "Response %sn",payload);
#endif
	parsed_json = json_tokener_parse(payload);

	if(!json_object_object_get_ex(parsed_json, "version", &version))
	{
		DBGPRINT(DEBUG_ERROR, "Required Key Version not avaliable\n");
		return status;
	}
	DBGPRINT(DEBUG_TRACE, "%d. version is %s\n",
						counter, json_object_get_string(version));

	if (strncmp((char *)glbl_afc_req_data.version, (char *)json_object_get_string(version), strlen((char *)glbl_afc_req_data.version)))
	{
		DBGPRINT(DEBUG_ERROR, "version mismatch\n");
		goto END;
	}

	if(!json_object_object_get_ex(parsed_json, "availableSpectrumInquiryResponses", &afcResponse))
	{
		DBGPRINT(DEBUG_ERROR, "Required Key availableSpectrumInquiryResponses not avaliable\n");
		return status;
	}

	n_Response = json_object_array_length(afcResponse);

	for(i=0; i < n_Response; i++) {
		DBGPRINT(DEBUG_TRACE, "Count=%d\n",counter);
		if (!(local == (MASK_FREQ_BIT | MASK_OPCLASS_BIT))) {
			add_tag_length_value(ASI_RESPONSE, 0, NULL);
          }
        response = json_object_array_get_idx(afcResponse, i);
        if(!json_object_object_get_ex(response, "requestId", &temp))
		{
			DBGPRINT(DEBUG_ERROR, "Required Key requestId not avaliable\n");
			goto END;
		}

		DBGPRINT(DEBUG_TRACE, "%d. requestId is %s\n",
							counter, json_object_get_string(temp));

		if (strncmp((char *)glbl_afc_req_data.ASI_request.requestId, (char *)json_object_get_string(temp), strlen(glbl_afc_req_data.ASI_request.requestId)))
		{
			DBGPRINT(DEBUG_ERROR, "requestId mismatch\n");
			goto END;
		}

		if(!json_object_object_get_ex(response, "rulesetId", &temp))
		{
			DBGPRINT(DEBUG_ERROR, "Required Key rulesetId not avaliable\n");
			goto END;
		}

		DBGPRINT(DEBUG_TRACE, "%d. rulesetId is %s\n",
							i+1, json_object_get_string(temp));

		if (strncmp((char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds, (char *)json_object_get_string(temp),
				strlen((char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds)))
		{
			DBGPRINT(DEBUG_ERROR, "rulesetId mismatch\n");
			goto END;
		}

		if (json_object_object_get_ex(response, "availableFrequencyInfo", &temp)) {

			n_frequency = json_object_array_length(temp);
			DBGPRINT(DEBUG_TRACE, "n_frequency=%d\n",
								n_frequency);

			for(j = 0; j < n_frequency; j++) {
				json_obj1 = json_object_array_get_idx(temp, j);

				if (!json_object_object_get_ex(json_obj1, "frequencyRange", &json_obj2)) {
					DBGPRINT(DEBUG_ERROR, "Required Key frequencyRange not avaliable\n");
					goto END;
				}

				if (!json_object_object_get_ex(json_obj2, "lowFrequency", &json_obj3)) {
					DBGPRINT(DEBUG_ERROR, "Required Key lowFrequency not avaliable\n");
					goto END;
				}
				if (!json_object_object_get_ex(json_obj2, "highFrequency", &json_obj4)) {
					DBGPRINT(DEBUG_ERROR, "Required Key highFrequency not avaliable\n");
					goto END;
				}

				if (json_object_object_get_ex(json_obj1, "maxPsd", &json_obj5) ||
							(json_object_object_get_ex(json_obj1, "maxPSD", &json_obj5))) {
					len = strlen(json_object_get_string(json_obj5)) + 1;
				} else {
					DBGPRINT(DEBUG_ERROR, "Required Key maxPsd not avaliable\n");
					goto END;
				}

				pfreq_data = malloc(len + 4);
				pfreq_data[0] = (UINT16)json_object_get_int(json_obj3);
				pfreq_data[1] = (UINT16)json_object_get_int(json_obj4);
				strncpy((char *)&pfreq_data[2], json_object_get_string(json_obj5), len);
				DBGPRINT(DEBUG_TRACE, "freq Range (%d, %d) MaxPsd = %s\n", pfreq_data[0], pfreq_data[1], (char *)&pfreq_data[2]);
				add_tag_length_value(FREQ_INFO, 4 + len, (char *)pfreq_data);
				free(pfreq_data);
			}
		}

		if(json_object_object_get_ex(response, "availableChannelInfo", &temp)) {

			UINT16 channel_info_len = 0;
			DBGPRINT(DEBUG_TRACE, "%d. availableChannelInfo\n",counter);
			n_frequency = json_object_array_length(temp);

			for(j = 0; j < n_frequency; j++) {
				channel_info_len = counter;
				add_tag_length_value(CHANNEL_INFO, 0, NULL);//handle freq_info_len
				json_obj1 = json_object_array_get_idx(temp, j);

				if (!json_object_object_get_ex(json_obj1, "globalOperatingClass", &json_obj3)) {
					DBGPRINT(DEBUG_ERROR, "Required Key globalOperatingClass not avaliable\n");
					goto END;
				}

				UINT8 opClass = (unsigned char)json_object_get_int(json_obj3);
				add_tag_length_value(OPER_CLASS, 1, (char *)&opClass);

				if (!json_object_object_get_ex(json_obj1, "channelCfi", &json_obj4)) {
					DBGPRINT(DEBUG_ERROR, "Required Key channelCfi not avaliable\n");
					goto END;
				}

				if (!json_object_object_get_ex(json_obj1, "maxEirp", &json_obj6)) {
					DBGPRINT(DEBUG_ERROR, "Required Key maxEirp not avaliable\n");
					goto END;
				}
				n_Channel = json_object_array_length(json_obj4);
				DBGPRINT(DEBUG_TRACE, "	Operating Class = %d\n", opClass);
				DBGPRINT(DEBUG_TRACE, "	Channel		Max EIRP\n");

				UINT8 *channel_list = NULL;
				for(k = 0; k < n_Channel; k++) {
					json_obj5 = json_object_array_get_idx(json_obj4, k);
					json_obj7 = json_object_array_get_idx(json_obj6, k);
					len = strlen(json_object_get_string(json_obj7)) + 1;
					channel_list = (UINT8 *)malloc(sizeof(*channel_list) + len);
					*channel_list = (UINT8)json_object_get_int(json_obj5);
					strncpy((char *)(channel_list + 1), json_object_get_string(json_obj7), len);
					DBGPRINT(DEBUG_TRACE, "	%d		%s\n", *channel_list, (char *)(channel_list + 1));
					add_tag_length_value(CHANNEL_LIST, sizeof(*channel_list) + len, (char *)channel_list);
					free(channel_list);
				}
				DBGPRINT(DEBUG_TRACE, "\n");
				DBGPRINT(DEBUG_TRACE, "channel info len = (%d, %d, %d,", counter, channel_info_len, *(UINT16 *)&glbl_afc_res_data[channel_info_len + 1]);
				*(UINT16 *)&glbl_afc_res_data[channel_info_len + 1] = counter - (channel_info_len + TLV_HEADER);
				DBGPRINT(DEBUG_TRACE, " %d)\n", *(UINT16 *)&glbl_afc_res_data[channel_info_len + 1]);
			}
		}

		if(!json_object_object_get_ex(response, "response", &temp)) {
			DBGPRINT(DEBUG_ERROR, "Required Key response not avaliable\n");
			goto END;
		} else {
			if (json_object_object_get_ex(temp, "responseCode", &json_obj1)) {
				status = (UINT16)json_object_get_int(json_obj1);
				DBGPRINT(DEBUG_TRACE, "%d. responseCode is %u\n",
													counter,status);
				if (RESPONSE_FILLED(local))
					add_tag_length_value(RESPONSE, sizeof(status), (char *)&status);
			}
			if(json_object_object_get_ex(temp, "shortDescription", &json_obj1)) {
				DBGPRINT(DEBUG_TRACE, "%d. responseCode is %s\n",
									counter,json_object_get_string(json_obj1));
			}
		}

		if(json_object_object_get_ex(response, "availabilityExpireTime", &temp)) {

			calculate_expiry_time(json_object_get_string(temp));
			if (RESPONSE_FILLED(local))
				add_tag_length_value(EXPIRY_TIME, sizeof(expiry_epoch_time), (char *)&expiry_epoch_time);

			if (expiry_epoch_time == afc_req_trigger_time)
				goto END;
		}
		if (RESPONSE_FILLED(local))
			*(UINT16 *)glbl_afc_res_data = (UINT16)RESPONSE_VALID;
END:
		if (RESPONSE_FILLED(local))
			*(UINT16 *)(glbl_afc_res_data + asi_len) = counter - asi_len - TLV_HEADER - 1;
	}

	if (!RESPONSE_FILLED(local)) {
		afc_state = AFC_ASI_RES_WAIT;
		trigger_afc();
	} else {
		query_type = MASK_PRIORITY(query_type);
	}
	return status;

}
