/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein is
* confidential and proprietary to MediaTek Inc. and/or its licensors. Without
* the prior written permission of MediaTek inc. and/or its licensors, any
* reproduction, modification, use or disclosure of MediaTek Software, and
* information contained herein, in whole or in part, shall be strictly
* prohibited.
*
* Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
* ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
* WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
* NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
* RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
* INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
* TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
* RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
* OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
* SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
* RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
* ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
* RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
* MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
* CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
* The following software/firmware and/or related documentation ("MediaTek
* Software") have been modified by MediaTek Inc. All revisions are subject to
* any receiver's applicable license agreements with MediaTek Inc.
*/

#include "afc.h"
#include "Debug.h"
#include "afc_driver_intf.h"


#define LOCATION_CONFIG "/etc/afc/location.cfg"

struct AFC_request glbl_afc_req_data;
UINT16 httpTimeout;
UINT8 Empty_request;
UINT32 statusCheck;

char *pafcUrl;
char *pbearertoken;


int newline_terminated(const char *buf, size_t buflen)
{
	size_t len = strlen(buf);
	if (len == 0)
		return 0;
	if (len == buflen - 1 && buf[buflen - 1] != '\r' &&
		buf[len - 1] != '\n')
		return 0;

	return 1;
}

void skip_line_end(FILE *stream)
{
	char buf[100];
	while (fgets(buf, sizeof(buf), stream)) {
		buf[sizeof(buf) - 1] = '\0';
		if (newline_terminated(buf, sizeof(buf)))
			return;
	}
}

char * mtk_config_get_line(char *s, int size, FILE *stream, int *line,
				  char **_pos)
{
	char *pos, *end, *sstart;

	while (fgets(s, size, stream)) {
		(*line)++;
		s[size - 1] = '\0';
		if (!newline_terminated(s, size)) {
			/*
			* The line was truncated - skip rest of it to avoid
			* confusing error messages.
			*/
			DBGPRINT(DEBUG_TRACE, "Long line in configuration file "
				   "truncated");
			skip_line_end(stream);
		}
		pos = s;

		/* Skip white space from the beginning of line. */
		while (*pos == ' ' || *pos == '\t' || *pos == '\r')
			pos++;

		/* Skip comment lines and empty lines */
		if (*pos == '#' || *pos == '\n' || *pos == '\0')
			continue;

		/*
		* Remove # comments unless they are within a double quoted
		* string.
		*/
		sstart = strchr(pos, '"');
		if (sstart)
			sstart = strrchr(sstart + 1, '"');
		if (!sstart)
			sstart = pos;
		end = strchr(sstart, '#');
		if (end)
			*end-- = '\0';
		else
			end = pos + strlen(pos) - 1;

		/* Remove trailing white space. */
		while (end > pos &&
			(*end == '\n' || *end == ' ' || *end == '\t' ||
			*end == '\r'))
			*end-- = '\0';

		if (*pos == '\0')
			continue;

		if (_pos)
			*_pos = pos;
		return pos;
	}

	if (_pos)
		*_pos = NULL;
	return NULL;
}

void fixed_decimal_place(char str[], int len)
{
	int i = 0;

	for (i = 0; str[i]; i++) {
		if (i > 4)
			return;

		if (str[i] == '.')
			break;
	}
	while ((i + 7) > len) {
		str[len++] = '0';
	}
	str[i+7] = '\0';
}

UINT8 read_config()
{
	FILE *fd = NULL;
	int line_size;
	char line_buf[256];
	char tmpbuf[256];
	char *token = NULL, *pos = NULL, *token1 = NULL;
	UINT8 len = 0;

	fd = fopen(LOCATION_CONFIG, "r");

	if (!fd) {
		DBGPRINT(DEBUG_ERROR, "Error opening file '%s'\n", LOCATION_CONFIG);
		goto END;
	}
	memset(line_buf, 0, 256);
	memset(tmpbuf, 0, 256);
	memset(&glbl_afc_req_data, 0xFF, sizeof(glbl_afc_req_data));
	//glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod = 0xFF;

	while (mtk_config_get_line(line_buf, sizeof(line_buf), fd, &line_size, &pos)) {
		strcpy(tmpbuf, pos);
		token = strtok(pos, "=");

		if (token != NULL) {

			if (strcmp(token, "afcServerUrl") == 0) {
				token = strtok(NULL, "");

				if(token){
					len = strlen(token) + 1;
					pafcUrl = malloc(len);

					if (!pafcUrl) {
						DBGPRINT(DEBUG_TRACE, "Memmory allocation Failure\n");
						goto END;
					}
					strncpy((char *)pafcUrl, token, len);
					pafcUrl[len - 1] = '\0';
					DBGPRINT(DEBUG_TRACE, "AFC url is %s\n",
										pafcUrl);
				}
			} else if (strcmp(token, "bearerToken") == 0) {
				token = strtok(NULL, "");

				if(token){
					len = strlen(token) +1;
					pbearertoken = malloc(len);

					if (!pbearertoken) {
						DBGPRINT(DEBUG_TRACE, "Memmory allocation Failure\n");
						goto END;
					}
					strncpy(pbearertoken, token, len);
					pbearertoken[len - 1] = '\0';
					DBGPRINT(DEBUG_TRACE, "bearerToken is %s\n",
										pbearertoken);
				}
			} else if (strcmp(token, "httpTimeout") == 0) {
				token = strtok(NULL, "");

				if(token){
					httpTimeout = strtol(token, NULL, 10);
					DBGPRINT(DEBUG_TRACE, "httptimeout is %d\n",
									httpTimeout);
				}
			} else if (strcmp(token, "emptyJson") == 0) {
				token = strtok(NULL, "");

				if(token){
					Empty_request = strtol(token, NULL, 10);
					DBGPRINT(DEBUG_TRACE, "Empty_request is %d\n",
									Empty_request);
				}
			} else if (strcmp(token, "version") == 0) {
				token = strtok(NULL, "");

				if(token){
					len = (strlen(token) +1) < MAX_VERSION_LEN ? strlen(token) +1: MAX_VERSION_LEN - 1;
					strncpy((char *)glbl_afc_req_data.version, token, len);
					glbl_afc_req_data.version[len] = '\0';
					DBGPRINT(DEBUG_TRACE, "version is %s\n",
										glbl_afc_req_data.version);
				}
			} else if (strcmp(token, "requestId") == 0) {
				token = strtok(NULL, "");

				if(token){
					len = (strlen(token) +1) < MAX_REQUEST_ID_LEN ? strlen(token) + 1: MAX_REQUEST_ID_LEN - 1;
					strncpy((char *)glbl_afc_req_data.ASI_request.requestId, token, len);
					DBGPRINT(DEBUG_TRACE, "requestId is %s\n",
										glbl_afc_req_data.ASI_request.requestId);
				}
			} else if (strcmp(token, "serialNumber") == 0) {
				token = strtok(NULL, "");

				if(token){
					len = strlen(token) + 1;
					glbl_afc_req_data.ASI_request.Descriptor.serialNumber = malloc(len);

					if (!glbl_afc_req_data.ASI_request.Descriptor.serialNumber){
						DBGPRINT(DEBUG_TRACE, "Memmory allocation Failure\n");
						goto END;
					}
					strncpy((char *)glbl_afc_req_data.ASI_request.Descriptor.serialNumber, token, len);
					DBGPRINT(DEBUG_TRACE, "serialNumber is %s\n",
										glbl_afc_req_data.ASI_request.Descriptor.serialNumber);
				}
			}/* else if (strcmp(token, "nra") == 0) {
				token = strtok(NULL, "");

				if(token){
					len = (strlen(token) +1) < MAX_NRA_LEN ? strlen(token) + 1: MAX_NRA_LEN - 1;
					strncpy((char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.nra, token, len);
					DBGPRINT(DEBUG_TRACE, "nra is %s\n",
										glbl_afc_req_data.ASI_request.Descriptor.CertID.nra);
				}
			}*/else if (strcmp(token, "rulesetId") == 0) {
				token = strtok(NULL, "");

				if(token){
					struct rulesetId *temp = NULL;
					token1 = strsep(&token, ",");
					glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds = NULL;

					do{
						len = strlen(token1) + 1;

						if (!glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds){
							glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds = malloc (sizeof (struct rulesetId));
							temp = glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds;
						}
						else {
							temp->next = malloc (sizeof (struct rulesetId));
							temp = temp->next;
						}
						if (!temp) {
							DBGPRINT(DEBUG_TRACE, "Memmory allocation Failure\n");
							goto END;
						}
						temp->next = NULL;
						memset(temp, 0 , sizeof (struct rulesetId));
						strncpy((char *)temp->rSetId, token1, len);
						DBGPRINT(DEBUG_TRACE, "rulesetId is %s\n",
											temp->rSetId);
					}while((token1 = strsep(&token, ",")) != NULL);
				}
			}  else if (strcmp(token, "id") == 0) {
				token = strtok(NULL, "");

				if(token){
					len = strlen(token) + 1;
					glbl_afc_req_data.ASI_request.Descriptor.CertID.id = malloc(len);
					strncpy((char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.id, token, len);
					DBGPRINT(DEBUG_TRACE, "id is %s\n",
										glbl_afc_req_data.ASI_request.Descriptor.CertID.id);
				}
			} else if (strcmp(token, "locationType") == 0) {
				token = strtok(NULL, "");

				if(token){
					glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod = strtol(token, NULL, 10);
					DBGPRINT(DEBUG_TRACE, "locationType is %d\n",
										glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod);
				}
			} else if (strcmp(token, "height") == 0) {
				token = strtok(NULL, "");

				if(token){
					glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height = malloc(strlen(token) +1);

					if (!glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height) {
						DBGPRINT(DEBUG_TRACE, "Memmory allocation Failure\n");
						goto END;
					}
					strcpy((char *)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height, token);
						DBGPRINT(DEBUG_TRACE, "height is %s\n",
					glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height);
				}
			} else if (strcmp(token, "heightType") == 0) {
				token = strtok(NULL, "");

				if(token){
					glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType = malloc(strlen(token) +1);

					if (!glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType) {
						DBGPRINT(DEBUG_TRACE, "Memmory allocation Failure\n");
						goto END;
					}
					strcpy((char *)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType, token);
					DBGPRINT(DEBUG_TRACE, "heightType is %s\n",
					glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType);
				}
			} else if (strcmp(token, "verticalUncertainty") == 0) {
				token = strtok(NULL, "");

				if(token){
					glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty = strtol(token, NULL, 10);
					DBGPRINT(DEBUG_TRACE, "verticalUncertainty is %d\n",
					glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty);
				}
			} else if (strcmp(token, "indoorDeployment") == 0) {
				token = strtok(NULL, "");

				if(token){
					glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment = strtol(token, NULL, 10);
					DBGPRINT(DEBUG_TRACE, "indoorDeployment is %d\n",
					glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment);
				}
			} else if (strcmp(token, "minPower") == 0) {
				token = strtok(NULL, "");

				if(token){
					glbl_afc_req_data.ASI_request.minDesiredPower = strtol(token, NULL, 10);
					DBGPRINT(DEBUG_TRACE, "minDesiredPower is %d\n",
								glbl_afc_req_data.ASI_request.minDesiredPower);
				}
			}else if (strcmp(token, "statusCheck") == 0) {
				token = strtok(NULL, "");

				if(token){
					statusCheck = strtol(token, NULL, 10);
					DBGPRINT(DEBUG_TRACE, "ocspStapling is %d\n",statusCheck);
				}
			}

			if(!token)
				continue;
			if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 0) {

				if (strcmp(token, "longitude") == 0) {
					token = strtok(NULL, "");

					if(token){
						token1 = strsep(&token, ",");
						len = (strlen(token1) +1) < MAX_LONGITUDE_LEN ? strlen(token1) + 1: MAX_LONGITUDE_LEN;
						strncpy((char *)glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude, token1, len);
						glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude[len-1] = '\0';
						fixed_decimal_place(glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude, strlen(token1));
						DBGPRINT(DEBUG_TRACE, "longitude is %s\n",
									glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude);
					}
				} else if (strcmp(token, "latitude") == 0) {
					token = strtok(NULL, "");

					if(token){
						token1 = strsep(&token, ",");
						len = (strlen(token1) +1) < MAX_LATITUDE_LEN ? strlen(token1) + 1: MAX_LATITUDE_LEN;
						strncpy((char *)glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude , token1, len);
						glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude[len-1] = '\0';
						fixed_decimal_place(glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude, strlen(token1));
						DBGPRINT(DEBUG_TRACE, "latitude is %s\n",
									glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude );
					}
				} else if (strcmp(token, "majorAxis") == 0) {
					token = strtok(NULL, "");

					if(token){

						glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.majorAxis = strtol(token, NULL, 10);
						DBGPRINT(DEBUG_TRACE, "majorAxis is %d\n",
									glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.majorAxis);
					}
				} else if (strcmp(token, "minorAxis") == 0) {
					token = strtok(NULL, "");

					if(token){
						glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.minorAxis = strtol(token, NULL, 10);
						DBGPRINT(DEBUG_TRACE, "minorAxis is %d\n",
									glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.minorAxis);
					}
				}else if (strcmp(token, "orientation") == 0) {
					token = strtok(NULL, "");

					if(token){
						glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.orientation = strtol(token, NULL, 10);
						DBGPRINT(DEBUG_TRACE, "orientation is %d\n",
									glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.orientation);
					}
				}
			} else if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 1) {
				int idx = 0;

				if (strcmp(token, "longitude") == 0) {
					token = strtok(NULL, "");

					if(token){
						while((token1 = strsep(&token, ",")) != NULL){
							if (idx >= 15) {
								DBGPRINT(DEBUG_TRACE, "Maximum number of points allowed are 15,  %d\n", idx);
								goto END;
							}
							strcpy(glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[idx].longitude, token1);
							fixed_decimal_place(glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[idx].longitude, strlen(token1));
							DBGPRINT(DEBUG_TRACE, "longitude is %s\n",
										glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[idx].longitude);
							idx++;
						}
						if (idx < 3) {
							DBGPRINT(DEBUG_TRACE, "Number of points must be more than 3,  %d\n", idx);
							goto END;
						}
						glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.NumOfPoints = idx;
					}
				} else if (strcmp(token, "latitude") == 0) {
					token = strtok(NULL, "");

					if(token){
						while((token1 = strsep(&token, ",")) != NULL){
							strcpy(glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[idx].latitude, token1);
							fixed_decimal_place(glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[idx].latitude, strlen(token1));
							DBGPRINT(DEBUG_TRACE, "latitude is %s\n",
										glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[idx].latitude);
							idx++;
						}
						if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.NumOfPoints != idx) {
							DBGPRINT(DEBUG_TRACE, "number longitude = %d & latitude = %d must be same\n",
										glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.NumOfPoints, idx);
							goto END;
						}
					}
				}
			}
			else if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 2) {

				if (strcmp(token, "longitude") == 0) {
					token = strtok(NULL, "");

					if(token){
						token1 = strsep(&token, ",");
						strcpy((char *)glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.longitude, token1);
						fixed_decimal_place(glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.longitude, strlen(token1));
						DBGPRINT(DEBUG_TRACE, "longitude is %s\n",
									glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.longitude);
					}
				} else if (strcmp(token, "latitude") == 0) {
					token = strtok(NULL, "");

					if(token){
						token1 = strsep(&token, ",");
						strcpy((char *)glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.latitude, token1);
						fixed_decimal_place(glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.latitude, strlen(token1));
						DBGPRINT(DEBUG_TRACE, "latitude is %s\n",
									glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.latitude );
					}
				} else if (strcmp(token, "length") == 0) {
					int idx = 0;
					token = strtok(NULL, "");

					if(token){
						while((token1 = strsep(&token, ",")) != NULL){
							if (idx >= 15) {
								DBGPRINT(DEBUG_TRACE, "Maximum number of points allowed are 15,  %d\n", idx);
								goto END;
							}
							strcpy(glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Vector[idx].length, token1);
							DBGPRINT(DEBUG_TRACE, "length is %s\n",
										glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Vector[idx].length);
							idx++;
						}
						if (idx < 3) {
							DBGPRINT(DEBUG_TRACE, "Number of points must be more than 3,  %d\n", idx);
							goto END;
						}
						glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.NumOfVectors = idx;
					}
				} else if (strcmp(token, "angle") == 0) {
					int idx = 0;
					token = strtok(NULL, "");

					if(token){
						while((token1 = strsep(&token, ",")) != NULL){
							strcpy(glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Vector[idx].angle, token1);
							DBGPRINT(DEBUG_TRACE, "angle is %s\n",
										glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Vector[idx].angle);
							idx++;
						}
						if (glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.NumOfVectors != idx) {
							DBGPRINT(DEBUG_TRACE, "number length = %d & angle = %d must be same\n",
										glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.NumOfVectors, idx);
							goto END;
						}
					}
				}
			}
			else if ((glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod > 2) &&
				glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod != 0xFF){
				DBGPRINT(DEBUG_TRACE, "Location type is not suppoted %d\n",
							glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod);
			}
		}
	}
	afc_state = AFC_INIT_DONE;
		return 0;
	END:
		return 1;
}

void afc_free(int nl_socket)
{
	if (nl_socket > 0)
		close(nl_socket);

	if (pafcUrl)
		free(pafcUrl);

	if (pbearertoken)
		free(pbearertoken);

	if (glbl_afc_req_data.ASI_request.Descriptor.serialNumber)
		free(glbl_afc_req_data.ASI_request.Descriptor.serialNumber);

	if (glbl_afc_req_data.ASI_request.Descriptor.CertID.id)
		free(glbl_afc_req_data.ASI_request.Descriptor.CertID.id);

	struct rulesetId *temp = glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds;
	while (temp) {
		free(temp);
		temp = temp->next;
	}

	if (glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height)
		free(glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height);

	if (glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType)
		free(glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType);

	if (glbl_afc_req_data.ASI_request.freqRange)
		free(glbl_afc_req_data.ASI_request.freqRange);

}

