
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * Copyright  (C) 2019-2020  MediaTek Inc. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifdef SKU_BE19000

#include "afc.h"
#include "afc_driver_intf.h"
#include "netlink.h"
#include "priv_netlink.h"
#include "driver.h"
#include "Debug.h"
#include "eloop.h"
#include "mtk_vendor_nl80211.h"
#include "os.h"

#define RT_DEBUG_OFF		0
#define RT_DEBUG_ERROR		1
#define RT_DEBUG_WARN		2
#define RT_DEBUG_TRACE		3
#define RT_DEBUG_INFO		4

extern void netlink_deinit(struct netlink_data *netlink);

static int driver_nl80211_set_msg(struct driver_nl80211_data *drv_data, const char *ifname, unsigned short cmd_id,
				  unsigned short sub_cmd_id, void *data, size_t len)
{
	struct nl_msg *msg;
	void *nl_data;
	int ret = -1;
        
	msg = unl_genl_msg(&drv_data->nl_handle, NL80211_CMD_VENDOR, FALSE);
	if (!msg) {
		DBGPRINT(RT_DEBUG_ERROR, "unl_genl_msg fail!!!\n");
		return ret;
	}

	if (nla_put_u32(msg, NL80211_ATTR_IFINDEX, if_nametoindex(ifname)) ||
	    nla_put_u32(msg, NL80211_ATTR_VENDOR_ID, MTK_NL80211_VENDOR_ID) ||
	    nla_put_u32(msg, NL80211_ATTR_VENDOR_SUBCMD, cmd_id)) {
		DBGPRINT(RT_DEBUG_ERROR, "nla_put_u32 fail!!!\n");
		goto out;
	}

	nl_data = nla_nest_start(msg, NL80211_ATTR_VENDOR_DATA);
	if (!nl_data)
		goto out;

	ret = nla_put(msg, sub_cmd_id, len, data);
	if (ret) {
		DBGPRINT(RT_DEBUG_ERROR, "nla_put fail: %s\n", strerror(-ret));
		goto out;
	}

	nla_nest_end(msg, nl_data);

	ret = unl_genl_request(&drv_data->nl_handle, msg, NULL, NULL);
	if (ret)
		DBGPRINT(RT_DEBUG_ERROR, "nl80211 call fail: %s\n", strerror(-ret));

	return ret;
out:
	nlmsg_free(msg);
	return ret;
}

static int driver_nl80211_set_afc_param(void *drv_data, const char *ifname, char *buf,
		size_t buf_len)
{
	int ret;
	struct driver_nl80211_data *drv_nl80211_data = (struct driver_nl80211_data *)drv_data;

	ret = driver_nl80211_set_msg(drv_nl80211_data, ifname, MTK_NL80211_VENDOR_SUBCMD_SET_AP_BSS,
			MTK_NL80211_VENDOR_ATTR_SET_AFC_PARAM, buf, buf_len);

	return ret;
}

static void nl80211_handle_wifi_afc_data(struct nlattr *attr)
{
	int ret;
	char *afc_data;
	struct device_info *dev_data;

	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);

	afc_data = nla_data(attr);
	dev_data = (struct device_info *)afc_data;
	ret = os_snprintf(afc_data, sizeof(struct device_info), "%s", dev_data);
	if (os_snprintf_error(sizeof(struct device_info), ret)) {
		DBGPRINT(RT_DEBUG_ERROR, "[%d]os_snprintf fail\n", __LINE__);
		return;
	}

	DBGPRINT(RT_DEBUG_ERROR, "\nafc_data=[%s]\n", afc_data);
}

static int nl80211_static_info_get_msg_cb(struct nl_msg *msg, void *arg)
{
	struct nlattr *tb[NL80211_ATTR_MAX + 1];
	struct nlattr *sub_tb[MTK_NL80211_VENDOR_ATTR_GET_STATIC_INFO_MAX + 1];
	struct genlmsghdr *gnlh = nlmsg_data(nlmsg_hdr(msg));
	struct driver_nl80211_data *drv_data = (struct driver_nl80211_data *)arg;
	struct afc_app *afc = (struct afc_app *)drv_data->priv;
	char *data;
	u32 data_len;
	int ret;

	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);

	if (gnlh->cmd != NL80211_CMD_VENDOR) {
		DBGPRINT(RT_DEBUG_ERROR, "%s: not mtk vendor msg\n", __func__);
		return NL_SKIP;
	}

	ret = nla_parse(tb, NL80211_ATTR_MAX, genlmsg_attrdata(gnlh, 0), genlmsg_attrlen(gnlh, 0), NULL);
	if (ret) {
		DBGPRINT(RT_DEBUG_ERROR, "%s: nla_parse fail!\n", __func__);
		return NL_SKIP;
	}

	if (!tb[NL80211_ATTR_VENDOR_DATA]) {
		DBGPRINT(RT_DEBUG_ERROR, "%s:NL80211_ATTR_VENDOR_DATA missing\n", __func__);
		return NL_SKIP;
	}

	ret = nla_parse_nested(sub_tb, MTK_NL80211_VENDOR_ATTR_GET_STATIC_INFO_MAX, tb[NL80211_ATTR_VENDOR_DATA], NULL);
	if (ret) {
		DBGPRINT(RT_DEBUG_ERROR, "%s: nla_parse_nested fail!\n", __func__);
		return NL_SKIP;
	}

	if (sub_tb[MTK_NL80211_VENDOR_ATTR_GET_STATIC_INFO_WIFI_AFC_DATA]) {
		data = nla_data(sub_tb[MTK_NL80211_VENDOR_ATTR_GET_STATIC_INFO_WIFI_AFC_DATA]);
		data_len = nla_len(sub_tb[MTK_NL80211_VENDOR_ATTR_GET_STATIC_INFO_WIFI_AFC_DATA]);
		os_memcpy(drv_data->get_data, data, data_len);
	}

	return NL_SKIP;
}

static int driver_nl80211_get_msg(struct driver_nl80211_data *drv_data, const char *ifname, unsigned short cmd_id,
		unsigned short sub_cmd_id, char *data, size_t *len)
{
	struct nl_msg *msg, msg_nl;
	void *attr;
	int ret = -1;

	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);
 
	drv_data->ifindex = if_nametoindex(ifname);
	if (data && len) {
		drv_data->get_data = data;
		drv_data->get_data_len = (u32 *)len;
	} else {
		DBGPRINT(RT_DEBUG_TRACE, "no data or len, driver_nl80211_get_msg fail!!!\n");
		return ret;
	}
	msg = unl_genl_msg(&drv_data->nl_handle, NL80211_CMD_VENDOR, FALSE);
	if (!msg) {
		DBGPRINT(RT_DEBUG_TRACE, "unl_genl_msg fail!!!\n");
		return ret;
	}
	if (nla_put_u32(msg, NL80211_ATTR_IFINDEX, if_nametoindex(ifname)) ||
			nla_put_u32(msg, NL80211_ATTR_VENDOR_ID, MTK_NL80211_VENDOR_ID) || nla_put_u32(msg, NL80211_ATTR_VENDOR_SUBCMD, cmd_id)) {
		DBGPRINT(RT_DEBUG_TRACE, "nla_put_u32 fail!!!\n");
		goto out;
	}
    
	attr = nla_nest_start(msg, NL80211_ATTR_VENDOR_DATA);
	if (!attr)
		goto out;
	if (nla_put(msg, sub_cmd_id, *len, data))
		goto out;
	nla_nest_end(msg, attr);
	switch (cmd_id) {
		case MTK_NL80211_VENDOR_SUBCMD_GET_STATIC_INFO:
			ret = unl_genl_request(&drv_data->nl_handle, msg, nl80211_static_info_get_msg_cb, drv_data);
                     break;
		default:
			DBGPRINT(RT_DEBUG_TRACE, "%s: invalid cmd_if = %d\n", __func__, cmd_id);
	}
	if (ret)
		DBGPRINT(RT_DEBUG_TRACE, "nl80211 call fail!!!\n");

	return ret;
out:
	nlmsg_free(msg);
	return ret;
}

/*
 * WiFi driver verion
 */
static int driver_nl80211_wifi_afc_data(void *drv_data, const char *ifname, char *afc_data, size_t *len)
{
	int ret;
	struct driver_nl80211_data *drv_nl80211_data = (struct driver_nl80211_data *)drv_data;
	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);

	ret = driver_nl80211_get_msg(drv_nl80211_data, ifname, MTK_NL80211_VENDOR_SUBCMD_GET_STATIC_INFO,
		MTK_NL80211_VENDOR_ATTR_GET_STATIC_INFO_WIFI_AFC_DATA, afc_data, len);
		
	if (ret != 0)
		DBGPRINT(RT_DEBUG_ERROR, "get driver wifi afc data fail, ret = %d \n", ret);

	return ret;
}

static int genl_event_handler(struct nl_msg *msg, void *arg)
{
	struct driver_nl80211_data *drv_data = (struct driver_nl80211_data *)arg;
	struct genlmsghdr *gnlh = nlmsg_data(nlmsg_hdr(msg));
	struct nlattr *tb[NL80211_ATTR_MAX + 1];
	struct afc_app *afc = (struct afc_app *)drv_data->priv;
	u32 vendor_id, vendor_event;
	int ret = NL_OK;
	
	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);
	
	if (gnlh->cmd != NL80211_CMD_VENDOR) {
		DBGPRINT(RT_DEBUG_ERROR, "%s: not vendor msg\n", __func__);
		return NL_SKIP;
	}
	unl_loop_done(&drv_data->nl_event);
	
	return ret;
}

static void nl80211_event_receive(int sock, void *eloop_ctx, void *handle)
{
	struct driver_nl80211_data *drv_data = (struct driver_nl80211_data *)eloop_ctx;
	DBGPRINT(RT_DEBUG_TRACE, "nl80211: Event message available\n");
	unl_loop(&drv_data->nl_event, genl_event_handler, drv_data);
}

static void *driver_nl80211_init(struct afc_app *afc,
		const int opmode, int drv_mode)
{
	struct driver_nl80211_data *drv_nl80211_data;
       int ret;

	drv_nl80211_data = calloc(1,sizeof(*drv_nl80211_data));

	if (!drv_nl80211_data) {
		printf("No avaliable memory for driver_nl80211_data\n");
		goto err1;

	}

	if (unl_genl_init(&drv_nl80211_data->nl_handle, "nl80211") < 0) {
		DBGPRINT(RT_DEBUG_ERROR, "failed to connect to nl80211 handle\n");
		goto err2;
	}

	if (unl_genl_init(&drv_nl80211_data->nl_event, "nl80211") < 0) {
		DBGPRINT(RT_DEBUG_ERROR, "failed to connect to nl80211 event\n");
		goto err2;
	}

	/* TODO: subscribe config/scan/regulatory/mlme event */

	ret = unl_genl_subscribe(&drv_nl80211_data->nl_event, "vendor");
	if (ret)
		DBGPRINT(RT_DEBUG_ERROR, "ret = %d, unl_genl_subscribe vendor fail!!!\n", ret);

	eloop_register_read_sock(nl_socket_get_fd(drv_nl80211_data->nl_event.sock), nl80211_event_receive, drv_nl80211_data, NULL);

	drv_nl80211_data->opmode = opmode;
	drv_nl80211_data->drv_mode = drv_mode;
	drv_nl80211_data->priv = (void *)afc;
	return (void *)drv_nl80211_data;
err2:
	free(drv_nl80211_data);
err1:
	return NULL;

}

static int driver_nl80211_exit(struct afc_app *afc)
{
	struct driver_nl80211_data *drv_nl80211_data;

	printf("%s\n", __FUNCTION__);

	netlink_deinit(drv_nl80211_data->netlink);
	nl_socket_free(drv_nl80211_data->nl_sock);
	drv_nl80211_data->nl_sock = 0;

	free(drv_nl80211_data);

	return 0;
}


const struct afc_drv_ops afc_drv_nl80211_ops = {
	.drv_inf_init = driver_nl80211_init,
	.drv_inf_exit = driver_nl80211_exit,
	.drv_wifi_afc_data = driver_nl80211_wifi_afc_data,
	.drv_set_afc_param = driver_nl80211_set_afc_param,
};
#endif /*  SKU_BE19000 */