
/* Copyright (c) 2020 Wi-Fi Alliance                                                */

/* Permission to use, copy, modify, and/or distribute this software for any         */
/* purpose with or without fee is hereby granted, provided that the above           */
/* copyright notice and this permission notice appear in all copies.                */

/* THE SOFTWARE IS PROVIDED 'AS IS' AND THE AUTHOR DISCLAIMS ALL                    */
/* WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED                    */
/* WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL                     */
/* THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR                       */
/* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING                        */
/* FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF                       */
/* CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT                       */
/* OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS                          */
/* SOFTWARE. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <arpa/inet.h>

#include "indigo_api.h"
#include "vendor_specific.h"
#include "utils.h"
#include "wpa_ctrl.h"
#include "indigo_api_callback.h"

#define MAX_URL_LEN         256
#define MAX_VERSION_LEN		8
#define MAX_REQUEST_ID_LEN	24
#define MAX_RULESET_ID_LEN	48
#define MAX_NRA_LEN			6
#define MAX_CERT_ID_LEN		10
#define MAX_VECTOR_LENGTH_LEN	12
#define MAX_VECTOR_ANGLE_LEN	12
#define MAX_LONGITUDE_LEN	12
#define MAX_LATITUDE_LEN	12

#define ELLIPSE 0
#define LINEARPOLYGON 1
#define RADIALPOLYGON 2
#define LOCATION_cfg "/etc/afc/location.cfg"
#ifdef SKU_AX8400
#define DAT_FILE "/etc/wireless/mediatek/mt7986-ax8400.dbdc.b1.dat"
#elif SKU_AX7800
#define DAT_FILE "/etc/wireless/mediatek/mt7916-ax7800.dbdc.b1.dat"
#elif SKU_BE19000
#define DAT_FILE "etc/wireless/mediatek/mt7990.b2.dat"
#define HOST_CONF_FILE "etc/wpad/template/hostapd_rax0_wpa3sae_6G.conf"
#else
#define DAT_FILE "etc/wireless/mediatek/mt7990.b2.dat"
#endif


/* Save TLVs in afcd_configure and Send in afcd_operation */
char ca_cert[S_BUFFER_LEN];
char server_url[128];
char bearer_token[32];
int  http_timeout=0;
char version[MAX_VERSION_LEN];
char requestId[MAX_REQUEST_ID_LEN];
char serialNumber[32];
char nra[MAX_NRA_LEN];
char cert_id[MAX_CERT_ID_LEN];
char rSetId[MAX_RULESET_ID_LEN];
char geo_area[8];
char longitude[128];
char latitude[128];
char major_axis[8];
char minor_axis[8];
char center[128];
char orientaion[8];
char height[16];
char heightType[8];
char verticalUncertainty[8];
char indoorDeployment[8];
char minPower[8];
char length[64];
char angle[64];
char ssid[32];
char security[8];
char pass_phrase[32];
char freq[32];
int freq_n;
char opclass[32];
int statusCheck=1;

void register_apis() {
    register_api(API_GET_CONTROL_APP_VERSION, NULL, get_control_app_handler);
    //register_api(API_AFC_GET_MAC_ADDR, NULL, afc_get_mac_addr_handler);
    register_api(API_AFCD_CONFIGURE, NULL, afcd_configure_handler);
    register_api(API_AFCD_OPERATION, NULL, afcd_operation_handler);
    register_api(API_AFCD_GET_INFO, NULL, afcd_get_info_handler);
}

static int get_control_app_handler(struct packet_wrapper *req, struct packet_wrapper *resp) {
    char buffer[S_BUFFER_LEN];
#ifdef _VERSION_
    snprintf(buffer, sizeof(buffer), "%s", _VERSION_);
#else
    snprintf(buffer, sizeof(buffer), "%s", TLV_VALUE_APP_VERSION);
#endif

    fill_wrapper_message_hdr(resp, API_CMD_RESPONSE, req->hdr.seq);
    fill_wrapper_tlv_byte(resp, TLV_STATUS, TLV_VALUE_STATUS_OK);
    fill_wrapper_tlv_bytes(resp, TLV_MESSAGE, strlen(TLV_VALUE_OK), TLV_VALUE_OK);
    fill_wrapper_tlv_bytes(resp, TLV_CONTROL_APP_VERSION, strlen(buffer), buffer);
    return 0;
}

static int afcd_get_info_handler(struct packet_wrapper *req, struct packet_wrapper *resp) {
    struct tlv_hdr *tlv;
    int freq , channel;
    char response[S_BUFFER_LEN];
	FILE *Channel_num = NULL;
	char *token;

#ifdef SKU_AX7800
	Channel_num = popen("iwconfig raix0 | grep Channel | awk '{print substr($2,9,4)}'", "r");
#else
	Channel_num = popen("iwconfig rax0 | grep Channel | awk '{print substr($2,9,4)}'", "r");
#endif

	if (Channel_num == NULL) {
		indigo_logger(LOG_LEVEL_ERROR, "Error opening Channel number file \n");
		}
	fgets(token, 4, Channel_num);
	channel = atoi(token);
	indigo_logger(LOG_LEVEL_ERROR, "Current Channel -->%d",channel);
	pclose(Channel_num);
    memset(response, 0, sizeof(response));
    /* Get current center channel */
    freq = 5950 + 5*channel;
    fill_wrapper_message_hdr(resp, API_CMD_RESPONSE, req->hdr.seq);
    fill_wrapper_tlv_byte(resp, TLV_STATUS, TLV_VALUE_STATUS_OK);
    fill_wrapper_tlv_bytes(resp, TLV_MESSAGE, strlen(TLV_VALUE_OK), TLV_VALUE_OK);
    snprintf(response, sizeof(response), "%d", freq);
    fill_wrapper_tlv_bytes(resp, TLV_AFC_OPER_FREQ, strlen(response), response);
    snprintf(response, sizeof(response), "%d", channel);
    fill_wrapper_tlv_bytes(resp, TLV_AFC_OPER_CHANNEL, strlen(response), response);
    return 0;
}

static int afcd_configure_handler(struct packet_wrapper *req, struct packet_wrapper *resp) {
    int status = TLV_VALUE_STATUS_OK;
    char *message = TLV_VALUE_OK;
    struct tlv_hdr *tlv;
    int i = 0, z = 0, y = 0;
	FILE *location_cfg= NULL;
	char cmd[128];
	char *token;
	char security[8];
	char rad_boun[64];
	char line_boun[256];
	char token2[64];
	char bw[8];

	location_cfg = fopen(LOCATION_cfg, "w");
	if (location_cfg == NULL) {
		indigo_logger(LOG_LEVEL_ERROR, "Error opening Location file");
		goto done;
	}

	/* Print all TLV */
	for (i = 0; i < req->tlv_num; i++) {
		struct indigo_tlv *i_tlv;
		char tlv_value[256];
		i_tlv = get_tlv_by_id(req->tlv[i]->id);
        if (i_tlv) {
			memset(tlv_value, 0, sizeof(tlv_value));
			memcpy(tlv_value, req->tlv[i]->value, req->tlv[i]->len);
			indigo_logger(LOG_LEVEL_DEBUG, "TLV: %s - %s", i_tlv->name, tlv_value);
		}
	}
	sleep(2);
	indigo_logger(LOG_LEVEL_ERROR, "+++++++  Location file editing started  +++++++");
	/* Server_URL */
	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_SERVER_URL);
	if (tlv) {
		memset(server_url, 0, sizeof(server_url));
		memcpy(server_url, tlv->value, tlv->len);
		fprintf(location_cfg, "afcServerUrl=%s/availableSpectrumInquiry\n", server_url);
    } else {
		indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_SERVER_URL");
		fprintf(location_cfg, "afcServerUrl=%s\n", server_url);
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_CA_CERT);
    if (tlv) {
        memset(ca_cert, 0, sizeof(ca_cert));
        memcpy(ca_cert, tlv->value, tlv->len);
        if (strlen(ca_cert) > 0) {
            indigo_logger(LOG_LEVEL_DEBUG, "Configure root certificate");
			system("cp /etc/controlappc/afc_ca.pem /etc/ssl/certs/ca-certificates.crt");
			system("cp /etc/controlappc/afc_ca.pem /etc/ssl/cert.pem");
        }
        else
            indigo_logger(LOG_LEVEL_DEBUG, "Do not configure root certificate !");
    } else {
        indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_CA_CERT");
        status = TLV_VALUE_STATUS_NOT_OK;
        message = TLV_VALUE_NOT_OK;
        goto done;
    }

	/* BSS Coopclassnfigurations: SSID, Security, Passphrase */
	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_TEST_SSID);
	if (tlv) {
		memset(ssid, 0, sizeof(ssid));
		memcpy(ssid, tlv->value, tlv->len);

#ifdef SKU_BE19000
		snprintf(cmd, 48, "hostapd_cli -i rax0 set ssid %s",ssid);
#else
		snprintf(cmd, 48, "sed -i 's/SSID1=.*/SSID1=%s/' ",ssid);
		strcat(cmd, DAT_FILE);
#endif
		system(cmd);
		memset(cmd, 0, sizeof(cmd));
	}

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_SECURITY_TYPE);
	if (tlv) {
		memset(security, 0, sizeof(security));
		memcpy(security, tlv->value, tlv->len);
		if (atoi(security) == 0) {
			indigo_logger(LOG_LEVEL_DEBUG, "Configure SAE");
#ifdef SKU_BE19000
			system("hostapd_cli -i rax0 set wpa_key_mgmt SAE");
			system("hostapd_cli -i rax0 set rsn_pairwise CCMP");
			system("hostapd_cli -i rax0 set ieee80211w 2");
#else
			strcpy(cmd, "sed -i 's/AuthMode=.*/AuthMode=WPA3PSK/' ");
			strcat(cmd, DAT_FILE);
			system(cmd);
			memset(cmd, 0, sizeof(cmd));
			strcpy(cmd, "sed -i 's/EncrypType=.*/EncrypType=AES/' ");
			strcat(cmd, DAT_FILE);
			system(cmd);
			memset(cmd, 0, sizeof(cmd));
			strcpy(cmd, "sed -i 's/PMFMFPC=.*/PMFMFPC=1/' ");
			strcat(cmd, DAT_FILE);
			system(cmd);
			memset(cmd, 0, sizeof(cmd));
			strcpy(cmd, "sed -i 's/PMFMFPR=.*/PMFMFPR=1/' ");
			strcat(cmd, DAT_FILE);
			system(cmd);
			memset(cmd, 0, sizeof(cmd));
#endif
		}
	}

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_WPA_PASSPHRASE);
	if (tlv) {
		memset(pass_phrase, 0, sizeof(pass_phrase));
		memcpy(pass_phrase, tlv->value, tlv->len);
#ifdef SKU_BE19000
		snprintf(cmd, 64, "hostapd_cli -i rax0 set wpa_passphrase %s",pass_phrase);
#else
		snprintf(cmd, 48, "sed -i 's/WPAPSK=.*/WPAPSK=%s/' ",pass_phrase);
		strcat(cmd, DAT_FILE);
#endif
		system(cmd);
		memset(cmd, 0, sizeof(cmd));
	}



#ifdef SKU_BE19000
	sleep(3);
	system("hostapd_cli -i rax0 disable");
	sleep(3);
	system("hostapd_cli -i rax0 enable");
	sleep(5);
#else
	sleep(3);
	system("wifi up");
	sleep(7);

#endif

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_BANDWIDTH);
	if (tlv) {
		memset(bw, 0, sizeof(bw));
		memcpy(bw, tlv->value, tlv->len);
		if (atoi(bw) == 0) {
			indigo_logger(LOG_LEVEL_DEBUG, "Configure DUT to 20MHz bandwidth");
		} else if (atoi(bw) == 1) {
			indigo_logger(LOG_LEVEL_DEBUG, "Configure DUT to 40MHz bandwidth");
		} else if (atoi(bw) == 2) {
			indigo_logger(LOG_LEVEL_DEBUG, "Configure DUT to 80MHz bandwidth");
		} else if (atoi(bw) == 3) {
			indigo_logger(LOG_LEVEL_DEBUG, "Configure DUT to 160MHz bandwidth");
		}
	}

	/* bearer token and http timeout*/
	fprintf(location_cfg, "bearerToken=%s\n", bearer_token);
	fprintf(location_cfg, "httpTimeout=%d\n", http_timeout);

	/* Version number, Req_ID, Serial number, NRA, ID, ruleset ID*/
	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_VERSION_NUMBER);
	if (tlv) {
		memset(version, 0, sizeof(version));
		memcpy(version, tlv->value, tlv->len);
	} else {
		indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_VERSION_NUMBER");
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}
	fprintf(location_cfg, "version=%s\n", version);

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_REQUEST_ID );
    if (tlv) {
        memset(requestId, 0, sizeof(requestId));
        memcpy(requestId, tlv->value, tlv->len);
    } else {
        indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_REQUEST_ID");
        status = TLV_VALUE_STATUS_NOT_OK;
        message = TLV_VALUE_NOT_OK;
        goto done;
    }
	fprintf(location_cfg, "requestId=%s\n", requestId);

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_SERIAL_NUMBER);
	if (tlv) {
		memset(serialNumber, 0, sizeof(serialNumber));
		memcpy(serialNumber, tlv->value, tlv->len);
	} else {
		indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_SERIAL_NUMBER");
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}
	fprintf(location_cfg, "serialNumber=%s\n", serialNumber);

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_RULE_SET_ID);
	if (tlv) {
		memset(rSetId, 0, sizeof(rSetId));
		memcpy(rSetId, tlv->value, tlv->len);
	} else {
		indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_RULE_SET_ID");
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}
	fprintf(location_cfg, "rulesetId=%s\n", rSetId);

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_CERT_ID);
	if (tlv) {
		memset(cert_id, 0, sizeof(cert_id));
		memcpy(cert_id, tlv->value, tlv->len);
	} else {
		indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_CERT_ID");
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}
	fprintf(location_cfg, "id=%s\n", cert_id);

	/*Mandatory Registration Configurations */
	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_LOCATION_GEO_AREA);
	if (tlv) {
		memset(geo_area, 0, sizeof(geo_area));
		memcpy(geo_area, tlv->value, tlv->len);
		fprintf(location_cfg, "locationType=%s\n", geo_area);
		if (atoi(geo_area) == ELLIPSE) {
			tlv = find_wrapper_tlv_by_id(req, TLV_AFC_ELLIPSE_CENTER);
			if (tlv) {
				memset(center, 0, sizeof(center));
				memcpy(center, tlv->value, tlv->len);
				while(center[z] != ',') {
					longitude[z]=center[z];
					z++;
				}
				z++;
				while(center[z] != NULL) {
					latitude[y]=center[z];
					y++;
					z++;
				}
				fprintf(location_cfg, "longitude=%s\n", longitude);
				fprintf(location_cfg, "latitude=%s\n", latitude);
			}
			tlv = find_wrapper_tlv_by_id(req, TLV_AFC_ELLIPSE_MAJOR_AXIS);
			if (tlv) {
				memset(major_axis, 0, sizeof(major_axis));
				memcpy(major_axis, tlv->value, tlv->len);
				fprintf(location_cfg, "majorAxis=%s\n", major_axis);
			}
			tlv = find_wrapper_tlv_by_id(req, TLV_AFC_ELLIPSE_MINOR_AXIS);
			if (tlv) {
				memset(minor_axis, 0, sizeof(minor_axis));
				memcpy(minor_axis, tlv->value, tlv->len);
				fprintf(location_cfg, "minorAxis=%s\n", minor_axis);
			}
			tlv = find_wrapper_tlv_by_id(req, TLV_AFC_ELLIPSE_ORIENTATION);
			if (tlv) {
				memset(orientaion, 0, sizeof(orientaion));
				memcpy(orientaion, tlv->value, tlv->len);
				fprintf(location_cfg, "orientaion=%s\n", orientaion);
			}
		}
		else if (atoi(geo_area) == LINEARPOLYGON) {
			y=0;
			z=0;
			tlv = find_wrapper_tlv_by_id(req, TLV_AFC_LINEARPOLY_BOUNDARY);
			if (tlv) {
				memset(line_boun, 0, sizeof(line_boun));
				memcpy(line_boun, tlv->value, tlv->len);
				token = strtok(line_boun," ");
				while(token != NULL){
					i=0;
					strcpy(token2, token);

					while(token2[i] != ','){
						longitude[y]=token2[i];
						i++;
						y++;
					}
					i++;
					while(token2[i] != NULL ){
						latitude[z]=token2[i];
						i++;
						z++;
					}
					token = strtok(NULL, " ");
					if(token != NULL){
						longitude[y]=',';
						latitude[z]=',';
					}
					y++;
					z++;
				}
				fprintf(location_cfg, "longitude=%s\n",longitude);
				fprintf(location_cfg, "latitude=%s\n", latitude);
			}
		}
		else if (atoi(geo_area) == RADIALPOLYGON){
			tlv = find_wrapper_tlv_by_id(req, TLV_AFC_RADIALPOLY_CENTER);
			if (tlv) {
				memset(center, 0, sizeof(center));
				memcpy(center, tlv->value, tlv->len);
				while(center[z] != ',') {
					longitude[z]=center[z];
					z++;
				}
				z++;
				while(center[z] != NULL) {
					latitude[y]=center[z];
					y++;
					z++;
				}
				fprintf(location_cfg, "longitude=%s\n", longitude);
				fprintf(location_cfg, "latitude=%s\n", latitude);
			}
			y=0;
			z=0;
			tlv = find_wrapper_tlv_by_id(req, TLV_AFC_RADIALPOLY_BOUNDARY);
			if (tlv) {
				memset(rad_boun, 0, sizeof(rad_boun));
				memcpy(rad_boun, tlv->value, tlv->len);
				token = strtok(rad_boun," ");
				while(token != NULL){
					i=0;
					strcpy(token2, token);
					while(token2[i] != ','){
						length[y]=token2[i];
						i++;
						y++;
					}
					i++;
					while(token2[i] != NULL ){
						angle[z]=token2[i];
						i++;
						z++;
					}
					token = strtok(NULL, " ");
					if(token != NULL){
						length[y]=',';
						angle[z]=',';
					}
					y++;
					z++;
				}
				fprintf(location_cfg, "length=%s\n",length);
				fprintf(location_cfg, "angle=%s\n", angle);
			}
		}
	}
	else {
		indigo_logger(LOG_LEVEL_DEBUG, "Missed TLV: TLV_AFC_LOCATION_GEO_AREA");
    }

	/*Height, height type, vertical uncertainity, indoor deployment */
	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_HEIGHT);
	if (tlv) {
		memset(height, 0, sizeof(height));
		memcpy(height, tlv->value, tlv->len);
    } else {
    	indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_HEIGHT");
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}
	fprintf(location_cfg, "height=%s\n", height);

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_HEIGHT_TYPE);
	if (tlv) {
		memset(heightType, 0, sizeof(heightType));
		memcpy(heightType, tlv->value, tlv->len);
	} else {
		indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_HEIGHT_TYPE");
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}
	fprintf(location_cfg, "heightType=%s\n", heightType);

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_VERTICAL_UNCERT);
	if (tlv) {
		memset(verticalUncertainty, 0, sizeof(verticalUncertainty));
		memcpy(verticalUncertainty, tlv->value, tlv->len);
	} else {
		indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_VERTICAL_UNCERT");
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}
	fprintf(location_cfg, "verticalUncertainty=%s\n", verticalUncertainty);

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_DEPLOYMENT);
	if (tlv) {
		memset(indoorDeployment, 0, sizeof(indoorDeployment));
		memcpy(indoorDeployment, tlv->value, tlv->len);
	} else {
		indigo_logger(LOG_LEVEL_ERROR, "Missed TLV: TLV_AFC_DEPLOYMENT");
		status = TLV_VALUE_STATUS_NOT_OK;
		message = TLV_VALUE_NOT_OK;
		goto done;
	}
	fprintf(location_cfg, "indoorDeployment=%s\n", indoorDeployment);

	/*min power */
	fprintf(location_cfg, "minPower=%s\n", minPower);
	fprintf(location_cfg, "statusCheck=%d\n", statusCheck);

	indigo_logger(LOG_LEVEL_ERROR, "+++++++  Location file editing done	+++++++");

	/*indigo_logger(LOG_LEVEL_ERROR, "+++++++  Dat file editing started	+++++++");*/

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_FREQ_RANGE);
	if (tlv) {
		memset(freq, 0, sizeof(freq));
		memcpy(freq, tlv->value, tlv->len);
		z=0;
		freq_n=0;
		while(z < tlv->len) {
			if(freq[z] == ','){
				freq_n++;
				freq[z]=':';
			}
			else if(freq[z] == ' ')
				freq[z]=':';

			z++;
			}
#ifdef SKU_AX7800
		snprintf(cmd,128,"iwpriv raix0 set AfcFreqrange=%d:%s",freq_n,freq);
#else
		snprintf(cmd,128,"iwpriv rax0 set AfcFreqrange=%d:%s",freq_n,freq);
#endif
		system(cmd);
		memset(cmd, 0, sizeof(cmd));
	}

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_GLOBAL_OPCL);

	if (tlv) {
		memset(opclass, 0, sizeof(opclass));
		memcpy(opclass, tlv->value, tlv->len);
		token = (char*) malloc(8);
		token = strtok(opclass, " ");
#ifdef SKU_AX7800
		while(token != NULL)
			{
				if(strcmp(token,"131")==0){
					system("iwpriv raix0 set AfcOpClass131=1");
				}
				else if (strcmp(token,"132")==0){
					system("iwpriv raix0 set AfcOpClass132=1");
					}
				else if (strcmp(token,"133")==0){
					system("iwpriv raix0 set AfcOpClass133=1");
					}
				else if (strcmp(token,"134")==0){
					system("iwpriv raix0 set AfcOpClass134=1");
					}
				else if (strcmp(token,"136")==0){
					system("iwpriv raix0 set AfcOpClass136=1");
					}
				token = strtok(NULL, " ");
			}
#else
		while(token != NULL)
			{
				if(strcmp(token,"131")==0){
					system("iwpriv rax0 set AfcOpClass131=1");
				}
				else if (strcmp(token,"132")==0){
					system("iwpriv rax0 set AfcOpClass132=1");
					}
				else if (strcmp(token,"133")==0){
					system("iwpriv rax0 set AfcOpClass133=1");
					}
				else if (strcmp(token,"134")==0){
					system("iwpriv rax0 set AfcOpClass134=1");
					}
				else if (strcmp(token,"136")==0){
					system("iwpriv rax0 set AfcOpClass136=1");
					}
				token = strtok(NULL, " ");
			}
#endif
		free(token);
	}

done:
	fill_wrapper_message_hdr(resp, API_CMD_RESPONSE, req->hdr.seq);
	fill_wrapper_tlv_byte(resp, TLV_STATUS, status);
	fill_wrapper_tlv_bytes(resp, TLV_MESSAGE, strlen(message), message);
	fclose(location_cfg);
	return 0;
}


static int afcd_operation_handler(struct packet_wrapper *req, struct packet_wrapper *resp) {
	struct tlv_hdr *tlv;
	char req_type[8];
	char cmd[128];
	char frame_bw[8];

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_DEVICE_RESET);
	if (tlv) {
		indigo_logger(LOG_LEVEL_DEBUG, "Device reset");
		system("killall AFC");
		system("wifi reload");
		sleep(10);
		system("cp /etc/ssl/temp.pem /etc/ssl/cert.pem");
		system("cp /etc/ssl/temp.pem /etc/ssl/certs/ca-certificates.crt");
#ifndef SKU_BE19000
		system("wifi down");
		sleep(3);
#endif
	}

	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_SEND_SPECTRUM_REQ);
	if (tlv) {
		memset(req_type, 0, sizeof(req_type));
		memcpy(req_type, tlv->value, tlv->len);
#ifdef SKU_AX7800
		if (atoi(req_type) == 0) {
			indigo_logger(LOG_LEVEL_DEBUG, "Send Spectrum request with Channel and Frequency based");
			system("iwpriv raix0 set AfcSpectrumType=0");
		} else if (atoi(req_type) == 1) {
			indigo_logger(LOG_LEVEL_DEBUG, "Send Spectrum request with Channel based");
			system("iwpriv raix0 set AfcSpectrumType=4");
		} else if (atoi(req_type) == 2) {
		indigo_logger(LOG_LEVEL_DEBUG, "Send Spectrum request with Frequency based");
			system("iwpriv raix0 set AfcSpectrumType=3");
		}
		system("iwpriv raix0 set AfcDeviceType=1");
		system("killall AFC");
		system("AFC raix0 &");
#else
		if (atoi(req_type) == 0) {
			indigo_logger(LOG_LEVEL_DEBUG, "Send Spectrum request with Channel and Frequency based");
			system("iwpriv rax0 set AfcSpectrumType=0");
		} else if (atoi(req_type) == 1) {
			indigo_logger(LOG_LEVEL_DEBUG, "Send Spectrum request with Channel based");
			system("iwpriv rax0 set AfcSpectrumType=4");
		} else if (atoi(req_type) == 2) {
		indigo_logger(LOG_LEVEL_DEBUG, "Send Spectrum request with Frequency based");
			system("iwpriv rax0 set AfcSpectrumType=3");
		}
		system("iwpriv rax0 set AfcDeviceType=1");
		system("killall AFC");
		system("AFC rax0 &");
#endif
		sleep(3);
	}
	tlv = find_wrapper_tlv_by_id(req, TLV_AFC_POWER_CYCLE);
	if (tlv) {
		indigo_logger(LOG_LEVEL_DEBUG, "Trigger power cycle");
		/* Vendor specific: add in vendor_specific_afc.c */
		system("killall AFC");
		system("wifi reload");
		sleep(12);
		system("cp /etc/ssl/temp.pem /etc/ssl/cert.pem");
		system("cp /etc/ssl/temp.pem /etc/ssl/certs/ca-certificates.crt");
#ifndef SKU_BE19000
		system("wifi down");
		sleep(3);
#endif
	}

    tlv = find_wrapper_tlv_by_id(req, TLV_AFC_SEND_TEST_FRAME);
    if (tlv) {
        memset(frame_bw, 0, sizeof(frame_bw));
        memcpy(frame_bw, tlv->value, tlv->len);
#ifdef SKU_AX7400
		if (atoi(frame_bw) == 0) {
			indigo_logger(LOG_LEVEL_DEBUG, "Trigger DUT to send test frames for 20MHz bandwidth");
			system("iwpriv raix0 set AFCbeaconBW=0");
		}
		else if (atoi(frame_bw) == 1) {
			indigo_logger(LOG_LEVEL_DEBUG, "Trigger DUT to send test frames for 40MHz bandwidth");
			system("iwpriv raix0 set AFCbeaconBW=1");
		}
		else if (atoi(frame_bw) == 2) {
			indigo_logger(LOG_LEVEL_DEBUG, "Trigger DUT to send test frames for 80MHz bandwidth");
			system("iwpriv raix0 set AFCbeaconBW=2");
		}
		else if (atoi(frame_bw) == 3) {
			indigo_logger(LOG_LEVEL_DEBUG, "Trigger DUT to send test frames for 160MHz bandwidth");
			system("iwpriv raix0 set AFCbeaconBW=3");
		}
#else
		if (atoi(frame_bw) == 0) {
			indigo_logger(LOG_LEVEL_DEBUG, "Trigger DUT to send test frames for 20MHz bandwidth");
			system("iwpriv rax0 set AFCbeaconBW=0");
		}
		else if (atoi(frame_bw) == 1) {
			indigo_logger(LOG_LEVEL_DEBUG, "Trigger DUT to send test frames for 40MHz bandwidth");
			system("iwpriv rax0 set AFCbeaconBW=1");
		}
		else if (atoi(frame_bw) == 2) {
			indigo_logger(LOG_LEVEL_DEBUG, "Trigger DUT to send test frames for 80MHz bandwidth");
			system("iwpriv rax0 set AFCbeaconBW=2");
		}
		else if (atoi(frame_bw) == 3) {
			indigo_logger(LOG_LEVEL_DEBUG, "Trigger DUT to send test frames for 160MHz bandwidth");
			system("iwpriv rax0 set AFCbeaconBW=3");
		}
#endif
    }

	fill_wrapper_message_hdr(resp, API_CMD_RESPONSE, req->hdr.seq);
	fill_wrapper_tlv_byte(resp, TLV_STATUS, TLV_VALUE_STATUS_OK);
	fill_wrapper_tlv_bytes(resp, TLV_MESSAGE, strlen(TLV_VALUE_OK), TLV_VALUE_OK);
	return 0;
}
