/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * Copyright  (C) 2020-2021  MediaTek Inc. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include <linux/list.h>


#ifndef _MT_QOS_H
#define _MT_QOS_H

#define QOS_R2 1
#define DSCP_TO_UP_OFFLOAD 1


#ifndef GNU_PACKED
#define GNU_PACKED  __attribute__ ((packed))
#endif /* GNU_PACKED */

#define DSCP_CS7	0x38 /*56*/
#define DSCP_CS6	0x30 /*48*/
#define DSCP_EF		0x2E /*46*/
#define DSCP_VA		0x2C /*44*/
#define DSCP_CS5	0x28 /*40*/
#define DSCP_CS4	0x20 /*32*/
#define DSCP_CS3	0x18 /*24*/

#define DSCP_MAX	64
#define MAX_FILTER_LEN	32
#define MAX_TCLAS_NUM  5
#define MAX_EXCEPT_CNT	21

#define bit(x) (1 << (x))

#define TYPE4_CS_MASK_VERSION	 1   /*(1 << 0)*/
#define	TYPE4_CS_MASK_SRC_IP	 2   /*(1 << 1)*/
#define	TYPE4_CS_MASK_DST_IP	 4   /*(1 << 2)*/
#define	TYPE4_CS_MASK_SRC_PORT	 8   /*(1 << 3)*/
#define	TYPE4_CS_MASK_DST_PORT	 16  /*(1 << 4)*/
#define	TYPE4_CS_MASK_DSCP	 32  /*(1 << 5)*/
#define	TYPE4_CS_MASK_PROTOCOL	 64  /*(1 << 6)*/
#define	TYPE4_CS_MASK_NXT_HEAD	 64  /*(1 << 6)*/
#define	TYPE4_CS_MASK_FLOW_LABEL 128 /*(1 << 7)*/


typedef unsigned char UINT8;
typedef unsigned char UCHAR;
typedef unsigned short UINT16;
typedef unsigned int UINT32;
typedef int INT32;
typedef unsigned long ULONG;

typedef char CHAR;

#define MAC_ADDR_LEN	6
#define IPV6_ADDR_LEN	16

#define DBG_LVL_OFF	0
#define DBG_LVL_ERROR	1
#define DBG_LVL_WARN	2
#define DBG_LVL_TRACE	3
#define DBG_LVL_INFO	4
#define DBG_LVL_LOUD	5

unsigned long dbg_level = DBG_LVL_ERROR;

#define DBGPRINT(Level, fmt, args...)	\
{					\
	if (Level <= dbg_level)	\
	{				\
		printk(fmt, ## args);	\
	}				\
}

enum {
	NL_SET_MSCS_CONFIG = 1,
	NL_SET_QOS_MAP,
	NL_SET_VEND_SPECIFIC_CONFIG,
	NL_VEND_SPECIFIC_CONFIG_EXPIRED,
	NL_RESET_QOS_CONFIG,
	NL_SET_SCS_CONFIG,
};

enum {
	REQUEST_TYPE_ADD = 0,
	REQUEST_TYPE_REMOVE = 1,
	REQUEST_TYPE_CHANGE = 2,
	REQUEST_TYPE_UNKNOWN
};

enum {
	CLASSIFIER_TYPE0 = 0,
	CLASSIFIER_TYPE1 = 1,
	CLASSIFIER_TYPE2 = 2,
	CLASSIFIER_TYPE3 = 3,
	CLASSIFIER_TYPE4 = 4,
	CLASSIFIER_TYPE5 = 5,
	CLASSIFIER_TYPE10 = 10,
};

enum {
	UP_0 = 0,
	UP_1,
	UP_2,
	UP_3,
	UP_4,
	UP_5,
	UP_6,
	UP_7,
	UP_MAX
};

enum {
	VER_IPV4 = 4,
	VER_IPV6 = 6,
};

enum {
	IP_TYPE_ICMP = 1,
	IP_TYPE_IGMP = 2,
	IP_TYPE_TCP = 6,
	IP_TYPE_UDP = 17,
	IP_TYPE_ESP = 50,
	IP_TYPE_IGRP = 88,
	IP_TYPE_OSPF = 89,
};

struct GNU_PACKED qos_netlink_message {
	unsigned char type;
	unsigned short len;
	unsigned char data[0];
};

struct GNU_PACKED classifier_header {
	UCHAR cs_type;	/*Classifier Type*/
	UCHAR cs_mask;	/*Classifier Mask*/
};

struct GNU_PACKED classifier_type3 {
	UCHAR cs_type;	/*Classifier Type*/
	UCHAR cs_mask;	/*Classifier Mask*/
	UINT16	filterOffset;
	UCHAR	filterlen;
	UCHAR	filterValue[MAX_FILTER_LEN];
	UCHAR	filterMask[MAX_FILTER_LEN];
};

struct GNU_PACKED classifier_type10 {
	UCHAR cs_type;	/*Classifier Type*/
	UCHAR	protocolInstance;
	union {
		UCHAR	protocol;
		UCHAR	nextheader;
	} u;
	UCHAR	filterlen;
	UCHAR	filterValue[MAX_FILTER_LEN];
	UCHAR	filterMask[MAX_FILTER_LEN];
};

struct GNU_PACKED classifier_type4 {
	UCHAR cs_type;	/*Classifier Type*/
	UCHAR cs_mask;	/*Classifier Mask*/
	UCHAR version;
	union {
		UINT32	ipv4;
		UINT16   ipv6[8];
	} srcIp;
	union {
		UINT32	ipv4;
		UINT16   ipv6[8];
	} destIp;
	UINT16	srcPort;
	UINT16	destPort;
	UCHAR	DSCP;
	union {
		UCHAR	protocol;
		UCHAR	nextheader;
	}u;
	UCHAR	flowLabel[3];
};

struct GNU_PACKED mirror_classifier_type4 {
	UCHAR cs_type;	/*Classifier Type*/
	UCHAR cs_mask;	/*Classifier Mask*/
	UCHAR version;
	union {
		UINT32	ipv4;
		UINT16   ipv6[8];
	} destIp;
	union {
		UINT32	ipv4;
		UINT16   ipv6[8];
	} srcIp;
	UINT16	destPort;
	UINT16	srcPort;
	UCHAR	DSCP;
	union {
		UCHAR	protocol;
		UCHAR	nextheader;
	}u;
	UCHAR	flowLabel[3];
};


struct GNU_PACKED classifier_parameter {
	UCHAR sta_mac[MAC_ADDR_LEN];
	UCHAR requet_type;
	UCHAR up_bitmap;
	UCHAR up_limit;
	UINT32 timeout;
	union {
		struct classifier_header header;
		struct classifier_type3 type3;
		struct classifier_type10 type10;
	} cs;
};

struct GNU_PACKED mscs_up_tuple {
	UCHAR sta_mac[MAC_ADDR_LEN];
	UCHAR up;
	UCHAR up_limit;
	UINT32 timeout;
	ULONG expired;

	union {
		struct classifier_header header;
		struct classifier_type4 type4;
		struct mirror_classifier_type4 mr_type4;
	} cs;
};

struct GNU_PACKED dscp_exception {
	UCHAR dscp;
	UCHAR up;
};

struct GNU_PACKED dscp_range {
	UCHAR low;
	UCHAR high;
};

struct GNU_PACKED qos_map {
	UCHAR num;
	struct dscp_exception dscp_ex[MAX_EXCEPT_CNT];
	struct dscp_range dscp_rg[UP_MAX];
};

struct GNU_PACKED wapp_vend_spec_classifier_para_report {
	UINT32 id;
	UCHAR sta_mac[MAC_ADDR_LEN];
	UCHAR requet_type;
	UCHAR up;
	UCHAR delay_bound;
	UCHAR protocol;
	UINT32 timeout;
	ULONG expired;
	UCHAR version;
	union {
		UINT32	ipv4;
		UCHAR	ipv6[16];
	} srcIp;
	union {
		UINT32	ipv4;
		UCHAR	ipv6[16];
	} destIp;
	UINT16	srcPort;
	UINT16	destPort;

	char	ifname[IFNAMSIZ];
};

struct mscs_config_entry {
	struct list_head list;
	struct rcu_head rcu;
	struct classifier_parameter cs_param;
};

struct mscs_up_tuple_entry {
	struct list_head list;
	struct rcu_head rcu;
	struct mscs_up_tuple mscstuple;
};

struct vendor_specific_up_entry {
	struct list_head list;
	struct rcu_head rcu;
	struct wapp_vend_spec_classifier_para_report vs_cs_param;
};

#ifdef QOS_R2
typedef union GNU_PACKED _tclas_element {
	struct classifier_header header;
	struct classifier_type4 type4;
	struct classifier_type10 type10;
} tclas_element, *ptclas_element;

struct GNU_PACKED scs_classifier_parameter {
	UCHAR sta_mac[MAC_ADDR_LEN];
	UCHAR scsid;
	UCHAR requet_type;
	UCHAR up;
	UCHAR alt_queue;
	UCHAR drop_elig;
	UCHAR processing;

	UCHAR tclas_num;
	tclas_element tclas_elem[MAX_TCLAS_NUM];
};

struct scs_up_tuple_entry {
	struct list_head list;
	struct rcu_head rcu;
	struct scs_classifier_parameter scs_param;
};
#endif

#endif /*_MT_QOS_H*/
