/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein is
* confidential and proprietary to MediaTek Inc. and/or its licensors. Without
* the prior written permission of MediaTek inc. and/or its licensors, any
* reproduction, modification, use or disclosure of MediaTek Software, and
* information contained herein, in whole or in part, shall be strictly
* prohibited.
*
* Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
* ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
* WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
* NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
* RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
* INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
* TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
* RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
* OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
* SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
* RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
* ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
* RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
* MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
* CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
* The following software/firmware and/or related documentation ("MediaTek
* Software") have been modified by MediaTek Inc. All revisions are subject to
* any receiver's applicable license agreements with MediaTek Inc.
*/

#include "afc.h"
#include "Debug.h"
#include "afc_driver_intf.h"

void print_AFC_config_data()
{
	struct rulesetId *temp = NULL;
	int i = 0;

	if (glbl_afc_req_data.version[0] != 0xFF)
		DBGPRINT(DEBUG_INFO, "version = %s\n", (const char *)glbl_afc_req_data.version);

	if (glbl_afc_req_data.ASI_request.requestId[0] != 0xFF)
		DBGPRINT(DEBUG_INFO, "requestId = %s\n", (const char *)glbl_afc_req_data.ASI_request.requestId);

	if ((UINT8)glbl_afc_req_data.ASI_request.Descriptor.serialNumber != 0xFF)
		DBGPRINT(DEBUG_INFO, "serialNumber = %s\n", (const char *)glbl_afc_req_data.ASI_request.Descriptor.serialNumber);

//	if (glbl_afc_req_data.ASI_request.Descriptor.CertID.nra[0] != 0xFF)
//		DBGPRINT(DEBUG_INFO, "nra = %s\n",(const char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.nra);

	if ((UINT8)glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds != 0xFF)
		temp = glbl_afc_req_data.ASI_request.Descriptor.CertID.rulesetIds;

	while(temp) {
		DBGPRINT(DEBUG_INFO, "%s\n",temp->rSetId);
		temp = temp->next;
	}

	if ((UINT8)glbl_afc_req_data.ASI_request.Descriptor.CertID.id != 0xFF)
		DBGPRINT(DEBUG_INFO, "id = %s\n", (const char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.id);

	if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 0) {

		DBGPRINT(DEBUG_INFO, "location Mathod is ellipse:\n");

		DBGPRINT(DEBUG_INFO, "center Point:\n");
		DBGPRINT(DEBUG_INFO, "longitude = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.longitude);
		DBGPRINT(DEBUG_INFO, "latitude = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.Centre.latitude);



		DBGPRINT(DEBUG_INFO, "majorAxis = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.majorAxis);
		DBGPRINT(DEBUG_INFO, "minorAxis = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.minorAxis);
		DBGPRINT(DEBUG_INFO, "orientation = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.ellip.orientation);

		DBGPRINT(DEBUG_INFO, "elevation:\n");
		if ((UINT8)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height != 0xFF)
			DBGPRINT(DEBUG_INFO, "height = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height);
		if ((UINT8)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType != 0xFF)
			DBGPRINT(DEBUG_INFO, "heightType = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType);
		DBGPRINT(DEBUG_INFO, "verticalUncertainty = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty);

		DBGPRINT(DEBUG_INFO, "indoorDeployment = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment);



	} else if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 1) {

		DBGPRINT(DEBUG_INFO, "location Mathod is linearPolygon:\n");
		DBGPRINT(DEBUG_INFO, "outerBoundary:\n");
		for (i = 0; i < glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.NumOfPoints; i++) {
			DBGPRINT(DEBUG_INFO, "longitude %s\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[i].longitude);
			DBGPRINT(DEBUG_INFO, "latitude %s\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.lin_polygon.linerPoint[i].latitude);
		}

		DBGPRINT(DEBUG_INFO, "elevation:\n");
		DBGPRINT(DEBUG_INFO, "height = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height);
		DBGPRINT(DEBUG_INFO, "heightType = %s\n", (const char *)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType);
		DBGPRINT(DEBUG_INFO, "verticalUncertainty = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty);


		DBGPRINT(DEBUG_INFO, "indoorDeployment = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment);

	} else if (glbl_afc_req_data.ASI_request.GeoLocation.LocationMethod == 2) {
		DBGPRINT(DEBUG_INFO, "location Mathod is radialPolygon:\n");
		DBGPRINT(DEBUG_INFO, "center:\n");

		DBGPRINT(DEBUG_INFO, "longitude = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.longitude);
		DBGPRINT(DEBUG_INFO, "latitude = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Centre.latitude);

		DBGPRINT(DEBUG_INFO, "outerBoundary:\n");
		for (i = 0; i < glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.NumOfVectors; i++) {
			DBGPRINT(DEBUG_INFO, "angle = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Vector[i].angle);
			DBGPRINT(DEBUG_INFO, "length = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.locationData.radi_polygon.Vector[i].length);
		}

		DBGPRINT(DEBUG_INFO, "elevation:\n");
		DBGPRINT(DEBUG_INFO, "height = %s\n", glbl_afc_req_data.ASI_request.GeoLocation.Elevation.height);
		DBGPRINT(DEBUG_INFO, "heightType = %s\n", (const char *)glbl_afc_req_data.ASI_request.GeoLocation.Elevation.heightType);
		DBGPRINT(DEBUG_INFO, "verticalUncertainty = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.Elevation.verticalUncertainty);

		DBGPRINT(DEBUG_INFO, "indoorDeployment = %u\n", glbl_afc_req_data.ASI_request.GeoLocation.indoorDeployment);

	}
#ifdef FREQUENCY_RANGE_ENABLED
	DBGPRINT(DEBUG_INFO, "inquiredFrequencyRange:\n");
	for (i = 0; i < glbl_afc_req_data.ASI_request.NumOfOpFreqRange; i++) {
		DBGPRINT(DEBUG_INFO, "lowFrequency = %s\n", glbl_afc_req_data.ASI_request.freqRange[i].lowFrequency);
		DBGPRINT(DEBUG_INFO, "highFrequency = %s\n", glbl_afc_req_data.ASI_request.freqRange[i].highFrequency);
	}
#endif

	DBGPRINT(DEBUG_INFO, "inquiredChannels:\n");
	for (i = 0; i < glbl_afc_req_data.ASI_request.NumOfOpClass; i++) {

		DBGPRINT(DEBUG_INFO, "globalOperatingClass = %u\n", glbl_afc_req_data.ASI_request.Channels[i].globalOperatingClass);
	}

#ifdef MINIMUM_DESIRED_POWER_ENABLED
	if ((UINT8)glbl_afc_req_data.ASI_request.minDesiredPower != 0xFF){
		DBGPRINT(DEBUG_INFO, "minDesiredPower = %d\n", glbl_afc_req_data.ASI_request.minDesiredPower);
	}
#endif
}
void print_TLV(UINT8 tag)
{
	UINT16 idx = 0;

	DBGPRINT(DEBUG_INFO, "Response Status = %d\n",
						*(UINT16 *)glbl_afc_res_data);
	idx += sizeof(struct afc_response);

	if (glbl_afc_res_data[idx] ==  ASI_RESPONSE) {
		idx++;
		DBGPRINT(DEBUG_INFO, "Length of ASI response = %d\n",
							*(UINT16 *)(glbl_afc_res_data + idx));
		idx +=sizeof(UINT16);
	}
	else {
		DBGPRINT(DEBUG_INFO, "Invalid Response TLV Buffer\n");
		return;
	}
	while(1){

		switch(glbl_afc_res_data[idx]) {
			case FREQ_INFO:
				idx += TLV_HEADER;
				DBGPRINT(DEBUG_INFO, "idx = %d, ",idx);
				DBGPRINT(DEBUG_INFO, "frequency Info: length: %d, low: %d, high: %d, ",
									*(UINT16 *)&glbl_afc_res_data[idx - 2], *(UINT16 *)(glbl_afc_res_data + idx),
									*(UINT16 *)(glbl_afc_res_data + idx + sizeof(UINT16)));
				DBGPRINT(DEBUG_INFO, "Max Psd = %s\n",
									(glbl_afc_res_data + idx + 4));
				idx += glbl_afc_res_data[idx - 2];
				break;

			case CHANNEL_INFO:
				DBGPRINT(DEBUG_INFO, "Channel Info: Length = %d\n",
									*(UINT16 *)&glbl_afc_res_data[idx + 1]);
				idx += TLV_HEADER;
				break;

			case OPER_CLASS:
				DBGPRINT(DEBUG_INFO, "Operating Class: length = %d,Value = %d\n",
									*(UINT16 *)&glbl_afc_res_data[idx+1], (glbl_afc_res_data[idx + 3]));
				idx += (TLV_HEADER + sizeof(UINT8));
				printf("1. idx= %d, value = %d",idx, glbl_afc_res_data[idx]);
				break;

			case CHANNEL_LIST:
				DBGPRINT(DEBUG_INFO, "Channel data: length = %d, Channel Num = %d Max Eirp = %s\n",
									*(UINT16 *)&glbl_afc_res_data[idx + 1], (glbl_afc_res_data[idx + 3]),
									&glbl_afc_res_data[idx + 4]);
				idx += TLV_HEADER + (*(UINT16 *)&glbl_afc_res_data[idx + 1]);
				break;

			case EXPIRY_TIME:
				printf("2. idx= %d, value = %d",idx, glbl_afc_res_data[idx]);
				DBGPRINT(DEBUG_INFO, "Expiry Time: length = %d, ",
									*(UINT16 *)&glbl_afc_res_data[idx+1]);
				DBGPRINT(DEBUG_INFO, "Value = %lu\n",
									*(UINT32 *)&glbl_afc_res_data[idx + 3]);
				idx +=(TLV_HEADER + *(UINT16 *)&glbl_afc_res_data[idx + 1]);
				break;

			case RESPONSE:
				idx += TLV_HEADER;
				DBGPRINT(DEBUG_INFO, "AFC System Response Status: %d\n",
									*(UINT16 *)(glbl_afc_res_data + idx));
				idx += *(UINT16 *)&glbl_afc_res_data[idx - 2];
				DBGPRINT(DEBUG_INFO, "Indx = %d\n", idx);
				break;
			default:
				return;
		}
	}	
}

/*int my_trace(CURL *handle, curl_infotype type,
	char *data, size_t size,
	void *userp)
{
	const char *text = NULL;
	(void)handle; /* prevent compiler warning
	(void)userp;
	
	switch (type) {
	case CURLINFO_TEXT:
		DBGPRINT(DEBUG_TRACE, "== Info: %s", data);
		break;
	case CURLINFO_HEADER_OUT:
		text = "=> Send header";
		break;
	case CURLINFO_DATA_OUT:
		text = "=> Send data";
		break;
	case CURLINFO_SSL_DATA_OUT:
		text = "=> Send SSL data";
		break;
	case CURLINFO_HEADER_IN:
		text = "<= Recv header";
		break;
	case CURLINFO_DATA_IN:
		text = "<= Recv data";
		break;
	case CURLINFO_SSL_DATA_IN:
		text = "<= Recv SSL data";
		break;
	default: /* in case a new one is introduced to shock us
		return 0;
	}
	DBGPRINT(DEBUG_TRACE, "\n");
	DBGPRINT(DEBUG_TRACE, "%s \n %s \n size : %lu\n",text, (unsigned char *)data, size);
	return 0;
}
*/
char* getFormattedTime(void) {

	time_t rawtime;
	struct tm* timeinfo;

	time(&rawtime);
	timeinfo = localtime(&rawtime);

	/*  Must be static, otherwise won't work  */
	static char _retval[24];
	strftime(_retval, sizeof(_retval), "%H:%M:%S", timeinfo);

	return _retval;
}
