/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein is
* confidential and proprietary to MediaTek Inc. and/or its licensors. Without
* the prior written permission of MediaTek inc. and/or its licensors, any
* reproduction, modification, use or disclosure of MediaTek Software, and
* information contained herein, in whole or in part, shall be strictly
* prohibited.
*
* Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
* ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
* WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
* NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
* RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
* INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
* TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
* RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
* OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
* SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
* RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
* ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
* RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
* MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
* CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
* The following software/firmware and/or related documentation ("MediaTek
* Software") have been modified by MediaTek Inc. All revisions are subject to
* any receiver's applicable license agreements with MediaTek Inc.
*/

#include "afc.h"
#include "Debug.h"
#include "afc_driver_intf.h"
#include "driver.h"
#include "netlink.h"
#include <sys/socket.h>


#define _GNU_SOURCE
#define RT_DEBUG_OFF		0
#define RT_DEBUG_ERROR		1
#define RT_DEBUG_WARN		2
#define RT_DEBUG_TRACE		3
#define RT_DEBUG_INFO		4

#define IW_EV_LCP_LEN	(sizeof(struct iw_event) - sizeof(union iwreq_data))

#define IW_EV_POINT_LEN	(IW_EV_LCP_LEN + sizeof(struct iw_point) - \
			 IW_EV_POINT_OFF)

struct sockaddr_nl src_addr, dest_addr;
extern struct afc_drv_ops afc_drv_nl80211_ops;


static void driver_wext_event_wireless(char *data, int len)
{
	struct iw_event iwe_buf, *iwe = &iwe_buf;
	char *pos, *end, *custom /*,*assoc_info_buf, *info_pos */;

	pos = data;
	end = data + len;

	while (pos + IW_EV_LCP_LEN <= end) {
		/*
		* Event data may be unaligned, so make a local, aligned copy
		* before processing.
		*/
		memcpy(&iwe_buf, pos, IW_EV_LCP_LEN);

		if (iwe->len <= IW_EV_LCP_LEN)
			return;

		custom = pos + IW_EV_POINT_LEN;

		//if (drv->we_version_compiled > 18 && iwe->cmd == IWEVCUSTOM) {
		/* WE-19 removed the pointer from struct iw_point */
		char *dpos = (char *) &iwe_buf.u.data.length;
		int dlen = dpos - (char *) &iwe_buf;

		memcpy(dpos, pos + IW_EV_LCP_LEN,
		sizeof(struct iw_event) - dlen);
		//} else {
		//os_memcpy(&iwe_buf, pos, sizeof(struct iw_event));
		//custom += IW_EV_POINT_OFF;
		//}

		switch (iwe->cmd) {
		case IWEVCUSTOM:

			if (custom + iwe->u.data.length > end)
				return;

			switch (iwe->u.data.flags) {

			case AFC_INQ_EVENT:

				if (afc_state == AFC_ASI_REQ_SEND) {
					DBGPRINT(DEBUG_ERROR, "ASI request to AFC system already in Process\n");
				}
				else {
					DBGPRINT(DEBUG_ERROR, "AFC_RECEIVED_INQ_EVENT received\n");
					afc_state = AFC_RECEIVED_INQ_EVENT;
				}
				break;

			case AFC_STOP_EVENT:
				afc_state = AFC_STOP;
				DBGPRINT(DEBUG_TRACE, "Stop AFC \n");

			default:
				break;
			}
			break;
		}
		pos += iwe->len;
	}

}

void netlink_cb(struct ifinfomsg *ifi, unsigned char *buf, size_t len)
{
	int attrlen, rta_len;
	struct rtattr *attr;

	attrlen = len;
	attr = (struct rtattr *) buf;
	rta_len = RTA_ALIGN(sizeof(struct rtattr));

	while (RTA_OK(attr, attrlen)) {
		if (attr->rta_type == IFLA_WIRELESS) {
			driver_wext_event_wireless(((char *) attr) + rta_len, attr->rta_len - rta_len);
		}
		attr = RTA_NEXT(attr, attrlen);
	}
}

int read_event (int sockint)
{
	int status;
	int ret = 0;
	char buf[2048];
	struct iovec iov = { buf, sizeof(buf) };
	struct msghdr msg = { (void *) &dest_addr, sizeof dest_addr, &iov, 1, 0, 0, 0};
	struct nlmsghdr *h;

	memset(buf, 0, sizeof(buf));
	h = (struct nlmsghdr *)buf;
	status = recvmsg (sockint, &msg, 0);

	if (status < 0) {
		if (errno == EWOULDBLOCK || errno == EAGAIN)
			return ret;

		DBGPRINT(DEBUG_TRACE, "read_netlink: Error recvmsg: %d\n", status);
		perror ("read_netlink: Error: ");
		return status;
	}

	if (status == 0)
	{
		DBGPRINT(DEBUG_TRACE, "read_netlink: EOF\n");
	}
	while (NLMSG_OK(h, status)) {
		switch (h->nlmsg_type) {
		case RTM_NEWLINK:
			netlink_cb(NLMSG_DATA(h),
			NLMSG_DATA(h) + NLMSG_ALIGN(sizeof(struct ifinfomsg)),
			NLMSG_PAYLOAD(h, sizeof(struct ifinfomsg)));
			break;

		case RTM_DELLINK:
			DBGPRINT(DEBUG_TRACE, "Delete Link\n");
			break;
		}
		h = NLMSG_NEXT(h, status);
	}

	return ret;
}

int open_netlink_socket (void)
{
	int nl_socket = socket (AF_NETLINK, SOCK_RAW, 0);

	if (nl_socket < 0)
	{
		DBGPRINT(DEBUG_ERROR, "Socket Open Error!");
		return -1;
	}

	memset ((void *) &src_addr, 0, sizeof (src_addr));
	src_addr.nl_family = AF_NETLINK;
	src_addr.nl_pid = 0;
	src_addr.nl_groups = RTMGRP_LINK;

	if (bind (nl_socket, (struct sockaddr *) &src_addr, sizeof (src_addr)) < 0)
	{
		DBGPRINT(DEBUG_ERROR, "Socket bind failed!");
		return -1;
	}

	return nl_socket;

}

/* Set the AFC parameters based on the server's response */
int set_afc_param(struct afc_app *afc, const char *iface, char *afc_resp, size_t len)
{
	int ret = 0;
	ret = afc->drv_ops->drv_set_afc_param(afc->drv_data, iface, afc_resp, len);
	return ret;
}

int get_afc_config_data(struct afc_app *afc, const char *iface, char *afc_data, size_t len)
{
	int ret;
	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __FUNCTION__);
	ret = afc->drv_ops->drv_wifi_afc_data(afc->drv_data, iface, afc_data, &len);
	return ret;
}

void get_device_data(const char *intf)
{
    int ret = 0;
    int index = 0, channel_index = 0;
    struct device_info deviceData;
    memset(&deviceData, 0, sizeof(struct device_info));
#ifdef SKU_BE19000
	int drv_mode = NL80211;// int drv_mode = AF_NETLINK
	int opmode = OPMODE_AP;
	struct afc_app *afc, afc_nl;
	char reply[50];
	size_t reply_len = 50;
	memset(reply, 0, 50);

	afc = &afc_nl;
	ret = afc_socket_and_ctrl_inf_init(afc, drv_mode, opmode);
	ret = get_afc_config_data(afc, intf, (char *)&deviceData, sizeof(struct device_info));
#else
    ret = trigger_ioctl(intf, OID_GET_AFC_CONFIG, (char *)&deviceData, 1024);
#endif

	if(ret < 0) {	
		DBGPRINT(DEBUG_ERROR, "\n%s, ret = %d \n\n", __FUNCTION__, ret);
		return;
	}
	DBGPRINT(DEBUG_TRACE, "regionCode is %s\n",
						deviceData.regionCode);
	DBGPRINT(DEBUG_TRACE, "glblOperClassNum is %d\n",
						deviceData.glblOperClassNum);
	for (index = 0; index < deviceData.glblOperClassNum; index++) {
		DBGPRINT(DEBUG_TRACE, "glblOperClass[%d] = %d\n",
							index, deviceData.glblOperClass[index].Opclass);
	}

//	memcpy((char *)glbl_afc_req_data.ASI_request.Descriptor.CertID.nra, deviceData.regionCode, 6);
	glbl_afc_req_data.ASI_request.NumOfOpClass = deviceData.glblOperClassNum;

	for (index =0; index < deviceData.glblOperClassNum; index++) {
		glbl_afc_req_data.ASI_request.Channels[index].globalOperatingClass =
						deviceData.glblOperClass[index].Opclass;
		glbl_afc_req_data.ASI_request.Channels[index].NumofChannels = deviceData.glblOperClass[index].NumofChannels;
		if (glbl_afc_req_data.ASI_request.Channels[index].NumofChannels)
			DBGPRINT(DEBUG_TRACE, "\n	Opclass %d Channel List[%d]:(",
						glbl_afc_req_data.ASI_request.Channels[index].globalOperatingClass,
						glbl_afc_req_data.ASI_request.Channels[index].NumofChannels);
		for (channel_index = 0; channel_index < deviceData.glblOperClass[index].NumofChannels; channel_index++) {
			glbl_afc_req_data.ASI_request.Channels[index].ChannelList[channel_index] =
						deviceData.glblOperClass[index].ChannelList[channel_index];
			DBGPRINT(DEBUG_TRACE, "%d, ", deviceData.glblOperClass[index].ChannelList[channel_index]);
		}
		DBGPRINT(DEBUG_TRACE, ")\n");
	}

	if (deviceData.InqfreqRange.NumOfOpFreqRange) {
		glbl_afc_req_data.ASI_request.NumOfOpFreqRange =
					deviceData.InqfreqRange.NumOfOpFreqRange;
		glbl_afc_req_data.ASI_request.freqRange =
					malloc(deviceData.InqfreqRange.NumOfOpFreqRange * sizeof(struct inquiredFrequencyRange));

		DBGPRINT(DEBUG_TRACE, "Number of freq range %u\n",
							deviceData.InqfreqRange.NumOfOpFreqRange);
		DBGPRINT(DEBUG_TRACE, "\n	frequency ranges\n");

		for (index = 0; index < deviceData.InqfreqRange.NumOfOpFreqRange; index++) {
			DBGPRINT(DEBUG_TRACE, "	(low : %u, high: %u)\n",
						deviceData.InqfreqRange.freqRange[index].lowFrequency, deviceData.InqfreqRange.freqRange[index].highFrequency);
			glbl_afc_req_data.ASI_request.freqRange[index].lowFrequency =
						deviceData.InqfreqRange.freqRange[index].lowFrequency;
			glbl_afc_req_data.ASI_request.freqRange[index].highFrequency =
						deviceData.InqfreqRange.freqRange[index].highFrequency;
		}
	}
	query_type = deviceData.SpectrumrInquiryType;
	afc_state = AFC_READY_REQ_DATA;

}

#ifdef SKU_BE19000
int afc_socket_and_ctrl_inf_init(struct afc_app *afc, int drv_mode, int opmode)
{
	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);
	/* Initialze event loop */
	//if (eloop_init() != 0)
		//return -1;
	afc->drv_ops = &afc_drv_nl80211_ops;
	//afc->event_ops = &afc_event_ops;
	afc->drv_data = afc->drv_ops->drv_inf_init(afc, opmode, drv_mode);
	if (!afc->drv_data) {
		/* deinit control interface */
		return -1;
	}
	//afc->drv_data = afc->drv_ops->drv_inf_exit(afc);
	//eloop_register_timeout(1, 0, afc_periodic_exec, NULL, afc);
	return 0;
}
#endif

int trigger_ioctl(const char *intf, int oid, char *pdata, int len)
{
	int socket_id;
	struct iwreq wrq;
	int ret;

	/* open socket based on address family: PF_NET */
	socket_id = socket(PF_INET, SOCK_DGRAM, 0);

	if(socket_id < 0)
	{
		DBGPRINT(DEBUG_ERROR, "\nrtuser::error::Open socket error!\n\n");
		return -1;
	}
	memset(&wrq, 0x00, sizeof(wrq));
	/* set interface name as "ra0" */
	DBGPRINT(DEBUG_TRACE, "intf %s, status = %d\n",intf, *(UINT16 *)pdata);
	if (intf != NULL) {
		if (strcmp("ra0", intf) == 0)
			strcpy(wrq.ifr_name, "ra0");
		else if (strcmp("rax0", intf) == 0)
			strcpy(wrq.ifr_name, "rax0");
		else if (strcmp("rai0", intf) == 0)
			strcpy(wrq.ifr_name, "rai0");
		else if (strcmp("raix0", intf) == 0)
			strcpy(wrq.ifr_name, "raix0");
		else
			strcpy(wrq.ifr_name, "rax0");
	} else {
		strcpy(wrq.ifr_name, "ra0");
	}
	wrq.u.data.length = len;
	wrq.u.data.pointer = pdata;
	wrq.u.data.flags = oid;
	ret = ioctl(socket_id, RT_PRIV_IOCTL, &wrq);

	if(ret < 0) {
		DBGPRINT(DEBUG_ERROR, "\nrtuser::error:: err=%i errno=%i %s\n\n", ret, errno, strerror(errno));
		return -1;
	}

	return 0;

}
