/* Copyright Statement:
*
* This software/firmware and related documentation ("MediaTek Software") are
* protected under relevant copyright laws. The information contained herein is
* confidential and proprietary to MediaTek Inc. and/or its licensors. Without
* the prior written permission of MediaTek inc. and/or its licensors, any
* reproduction, modification, use or disclosure of MediaTek Software, and
* information contained herein, in whole or in part, shall be strictly
* prohibited.
*
* Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
*
* BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
* THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
* RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
* ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
* WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
* WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
* NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
* RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
* INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
* TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
* RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
* OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
* SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
* RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
* STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
* ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
* RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
* MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
* CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
* The following software/firmware and/or related documentation ("MediaTek
* Software") have been modified by MediaTek Inc. All revisions are subject to
* any receiver's applicable license agreements with MediaTek Inc.
*/

#ifndef __AFC_DRIVER_INTF_H__
#define __AFC_DRIVER_INTF_H__
#define INTF "rax0" //TODO: need to add run time interface input from user.

#define RT_PRIV_IOCTL							0x8BE1
#define	OID_GET_SET_TOGGLE						0x8000

#define IWEVCUSTOM								0x8C02		/* Driver specific ascii string */

#ifdef SKU_BE19000
#define AFC_INQ_EVENT							0x09BB
#define AFC_STOP_EVENT							0x09BC
#else
#define AFC_INQ_EVENT							0x09C0
#define AFC_STOP_EVENT							0x09C1
#define OID_GET_AFC_CONFIG						0x09C2
#define OID_SET_AFC_CONFIG						(0x09C3 | OID_GET_SET_TOGGLE)
#endif



enum AFC_RESPONSE_TAG
{
	VERSION = 0,
	ASI_RESPONSE,
	FREQ_INFO,
	CHANNEL_INFO,
	OPER_CLASS,
	CHANNEL_LIST,
	EXPIRY_TIME,
	RESPONSE
};

struct channels
{
	UINT8 numOfChannel_OpClass131;
	UINT8 OpClass131_channel_list[59];
	UINT8 numOfChannel_OpClass132;
	UINT8 OpClass132_channel_list[29];
	UINT8 numOfChannel_OpClass133;
	UINT8 OpClass133_channel_list[14];
	UINT8 numOfChannel_OpClass134;
	UINT8 OpClass134_channel_list[7];
	UINT8 numOfChannel_OpClass135;
	UINT8 OpClass135_channel_list[14];
	UINT8 numOfChannel_OpClass136;
	UINT8 OpClass136_channel_list[3];
       UINT8 numOfChannel_OpClass137;
	UINT8 OpClass137_channel_list[2];
};

enum AFC_OP_CLASS_6G {
	AFC_OP_CLASS_131,
	AFC_OP_CLASS_132,
	AFC_OP_CLASS_133,
	AFC_OP_CLASS_134,
	AFC_OP_CLASS_135,
	AFC_OP_CLASS_136,
	AFC_OP_CLASS_137,
	AFC_OP_CLASS_NUM
};

enum AFC_OP_CLASS_CHANNEL_NUM {
	AFC_OP_CLASS_131_CHL_NUM = 59,
	AFC_OP_CLASS_132_CHL_NUM = 29,
	AFC_OP_CLASS_133_CHL_NUM = 14,
	AFC_OP_CLASS_134_CHL_NUM = 7,
	AFC_OP_CLASS_135_CHL_NUM = 14,
	AFC_OP_CLASS_136_CHL_NUM = 3,
	AFC_OP_CLASS_137_CHL_NUM = 2
};

enum AFC_SPECTRUM_TYPE {
	AFC_SPEC_OP_CLASS_AND_FREQ = 0,
	AFC_SPEC_OP_CLASS_ONLY,
	AFC_SPEC_FREQ_ONLY,
	AFC_SPEC_OP_CLASS_THEN_FREQ,
	AFC_SPEC_FREQ_THEN_OP_CLASS,
	AFC_MAX_SPECTRUM_TYPE
};

struct afc_frequency_range {
	UINT16 lowFrequency;
	UINT16 highFrequency;
};

struct afc_inquiredFrequencyRange {
	UINT8 NumOfOpFreqRange;
	struct afc_frequency_range freqRange[0];
};

struct afc_glblOperClass {
	UINT8 Opclass;
	UINT8 NumofChannels;
	UINT8 ChannelList[59];
};

struct afcSkipChannelOpClass {
	UINT8 OPClassEnable[AFC_OP_CLASS_NUM];
	UINT8 OPClassNumOfChannel[AFC_OP_CLASS_NUM];
	UINT8 OPClass131[AFC_OP_CLASS_131_CHL_NUM];
	UINT8 OPClass132[AFC_OP_CLASS_132_CHL_NUM];
	UINT8 OPClass133[AFC_OP_CLASS_133_CHL_NUM];
	UINT8 OPClass134[AFC_OP_CLASS_134_CHL_NUM];
	UINT8 OPClass135[AFC_OP_CLASS_135_CHL_NUM];
	UINT8 OPClass136[AFC_OP_CLASS_136_CHL_NUM];
       UINT8 OPClass137[AFC_OP_CLASS_137_CHL_NUM];
};
struct device_info {
	UINT8 regionCode[6];
	UINT8 SpectrumrInquiryType;
	UINT8 glblOperClassNum;
	struct afc_glblOperClass glblOperClass[6];
	struct afc_inquiredFrequencyRange InqfreqRange;
};
#endif /*__AFC_DRIVER_INTF_H__ */
