#ifndef _DOT11AI_FD_H_
#define _DOT11AI_FD_H_

#include "dot11_base.h"

/* FILS Discovery Frame Control (2 Octets) */
#define DOT11AI_FD_FRM_CTRL_SSID_LEN_MASK 0x1F
#define DOT11AI_FD_FRM_CTRL_CAP_PRESENCE (1 << 5)
#define DOT11AI_FD_FRM_CTRL_SHORT_SSID_INDC (1 << 6)
#define DOT11AI_FD_FRM_CTRL_AP_CSN_PRESENCE (1 << 7)
#define DOT11AI_FD_FRM_CTRL_ANO_PRESENCE (1 << 8)
#define DOT11AI_FD_FRM_CTRL_CCFS1_PRESENCE (1 << 9)
#define DOT11AI_FD_FRM_CTRL_PRIM_CH_PRESENCE (1 << 10)
#define DOT11AI_FD_FRM_CTRL_RSN_INFO_PRESENCE (1 << 11)
#define DOT11AI_FD_FRM_CTRL_LEN_PRESENCE (1 << 12)
#define DOT11AI_FD_FRM_CTRL_MD_PRESENCE (1 << 13)

/* FD Capability (2 Octets) */
#define DOT11AI_FD_CAP_ESS 0x1
#define DOT11AI_FD_CAP_PRIVACY (1 << 1)
#define DOT11AI_FD_CAP_BSS_OPERATING_CH_WIDTH_SHIFT 2
#define DOT11AI_FD_CAP_BSS_OPERATING_CH_WIDTH_MASK (0x7 << 2)
#define DOT11AI_FD_CAP_MAX_NUM_SS_SHIFT 5
#define DOT11AI_FD_CAP_MAX_NUM_SS_MASK (0x7 << 5)
#define DOT11AI_FD_CAP_MBSSID_PRESENCE (1 << 9)
#define DOT11AI_FD_CAP_PHY_INDEX_SHIFT 10
#define DOT11AI_FD_CAP_PHY_INDEX_MASK (0x7 << 10)
#define DOT11AI_FD_CAP_FILS_MIN_RATE_SHIFT 13
#define DOT11AI_FD_CAP_FILS_MIN_RATE_MASK (0x7 << 13)

#define DOT11AI_FD_CAP_SET_BSS_OP_CH_WIDTH(bw) \
	(((bw) << DOT11AI_FD_CAP_BSS_OPERATING_CH_WIDTH_SHIFT) & DOT11AI_FD_CAP_BSS_OPERATING_CH_WIDTH_MASK)
#define DOT11AI_FD_CAP_SET_MAX_NSS(nss) \
	(((nss) << DOT11AI_FD_CAP_MAX_NUM_SS_SHIFT) & DOT11AI_FD_CAP_MAX_NUM_SS_MASK)
#define DOT11AI_FD_CAP_SET_PHY_IDX(phy_idx) \
	(((phy_idx) << DOT11AI_FD_CAP_PHY_INDEX_SHIFT) & DOT11AI_FD_CAP_PHY_INDEX_MASK)
#define DOT11AI_FD_CAP_SET_MIN_RATE(rate) \
	(((rate) << DOT11AI_FD_CAP_FILS_MIN_RATE_SHIFT) & DOT11AI_FD_CAP_FILS_MIN_RATE_MASK)

enum fdcap_bss_op_ch_width {
	FD_CAP_BSS_OP_CH_BW20,
	FD_CAP_BSS_OP_CH_BW40,
	FD_CAP_BSS_OP_CH_BW80,
	FD_CAP_BSS_OP_CH_BW160,
	FD_CAP_BSS_OP_CH_BW8080 = FD_CAP_BSS_OP_CH_BW160,
};

enum fdcap_phy_idx {
	FD_CAP_PHY_IDX_HR_DSSS,
	FD_CAP_PHY_IDX_ERP_OFDM,
	FD_CAP_PHY_IDX_HT,
	FD_CAP_PHY_IDX_VHT,
	FD_CAP_PHY_IDX_HE
};

enum fdcap_fils_min_rate {
	FD_CAP_FILS_MIN_RATE_0,
	FD_CAP_FILS_MIN_RATE_1,
	FD_CAP_FILS_MIN_RATE_2,
	FD_CAP_FILS_MIN_RATE_3,
	FD_CAP_FILS_MIN_RATE_4
};

struct GNU_PACKED fils_discovery_info {
	UINT16 fils_disc_frm_ctrl;
	UINT8 time_stamp[8];
	UINT16 bcn_interval;
};

#endif /*_DOT11AI_FD_H_*/
