/*
 * Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws.
 * The information contained herein is confidential and proprietary to
 * MediaTek Inc. and/or its licensors.
 * Except as otherwise provided in the applicable licensing terms with
 * MediaTek Inc. and/or its licensors, any reproduction, modification, use or
 * disclosure of MediaTek Software, and information contained herein, in whole
 * or in part, shall be strictly prohibited.
*/
//[File]            : bn0_wf_rmac_top.h
//[Revision time]   : Wed Dec 26 19:16:25 2018
//[Description]     : This file is auto generated by CODA
//[Copyright]       : Copyright (C) 2018 Mediatek Incorportion. All rights reserved.

#ifndef __BN0_WF_RMAC_TOP_REGS_H__
#define __BN0_WF_RMAC_TOP_REGS_H__

#include "hal_common.h"

#ifdef __cplusplus
extern "C" {
#endif


//****************************************************************************
//
//                     BN0_WF_RMAC_TOP CR Definitions                     
//
//****************************************************************************

#define BN0_WF_RMAC_TOP_BASE                                   0x820E5000

#define BN0_WF_RMAC_TOP_RFCR_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0x0) // 5000
#define BN0_WF_RMAC_TOP_RFCR1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x4) // 5004
#define BN0_WF_RMAC_TOP_BCNF0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x8) // 5008
#define BN0_WF_RMAC_TOP_BCNF1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0xC) // 500C
#define BN0_WF_RMAC_TOP_BSCR0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x10) // 5010
#define BN0_WF_RMAC_TOP_BSCR1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x14) // 5014
#define BN0_WF_RMAC_TOP_RMACDR_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x18) // 5018
#define BN0_WF_RMAC_TOP_NSUR_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0x1C) // 501C
#define BN0_WF_RMAC_TOP_RMCR_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0x20) // 5020
#define BN0_WF_RMAC_TOP_MORE_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0x24) // 5024
#define BN0_WF_RMAC_TOP_LUNVR_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x28) // 5028
#define BN0_WF_RMAC_TOP_SCON_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0x2C) // 502C
#define BN0_WF_RMAC_TOP_CHFREQ_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x30) // 5030
#define BN0_WF_RMAC_TOP_MISC_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0x34) // 5034
#define BN0_WF_RMAC_TOP_MAXMINLEN_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x38) // 5038
#define BN0_WF_RMAC_TOP_TMR_PA_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x3C) // 503C
#define BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x40) // 5040
#define BN0_WF_RMAC_TOP_TXOPPS_PA_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x44) // 5044
#define BN0_WF_RMAC_TOP_SMESH_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x48) // 5048
#define BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_ADDR                (BN0_WF_RMAC_TOP_BASE + 0x4C) // 504C
#define BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_ADDR                (BN0_WF_RMAC_TOP_BASE + 0x50) // 5050
#define BN0_WF_RMAC_TOP_BTIM_BR_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x54) // 5054
#define BN0_WF_RMAC_TOP_MISC2_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x58) // 5058
#define BN0_WF_RMAC_TOP_S80CICR_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x5C) // 505C
#define BN0_WF_RMAC_TOP_PCICR_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x60) // 5060
#define BN0_WF_RMAC_TOP_SCICR_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x64) // 5064
#define BN0_WF_RMAC_TOP_S40CICR_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x68) // 5068
#define BN0_WF_RMAC_TOP_PHY_DELAY_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x6C) // 506C
#define BN0_WF_RMAC_TOP_PMSRC0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x70) // 5070
#define BN0_WF_RMAC_TOP_PMCTL0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x74) // 5074
#define BN0_WF_RMAC_TOP_BTENCR_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x78) // 5078
#define BN0_WF_RMAC_TOP_ACCACR_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x7C) // 507C
#define BN0_WF_RMAC_TOP_TFTACI0_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x80) // 5080
#define BN0_WF_RMAC_TOP_TFTACI1_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x84) // 5084
#define BN0_WF_RMAC_TOP_TFTACI2_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x88) // 5088
#define BN0_WF_RMAC_TOP_FTFACI3_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x8C) // 508C
#define BN0_WF_RMAC_TOP_FTFACI4_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x90) // 5090
#define BN0_WF_RMAC_TOP_DBGFX0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xA4) // 50A4
#define BN0_WF_RMAC_TOP_DBGFX1_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xA8) // 50A8
#define BN0_WF_RMAC_TOP_DBGFX2_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xAC) // 50AC
#define BN0_WF_RMAC_TOP_DBGFX3_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xB0) // 50B0
#define BN0_WF_RMAC_TOP_DBGFX4_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xB4) // 50B4
#define BN0_WF_RMAC_TOP_DBGFX5_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xB8) // 50B8
#define BN0_WF_RMAC_TOP_DBGFX6_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xBC) // 50BC
#define BN0_WF_RMAC_TOP_DBGFX7_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xC0) // 50C0
#define BN0_WF_RMAC_TOP_NAN0_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0xC4) // 50C4
#define BN0_WF_RMAC_TOP_NAN1_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0xC8) // 50C8
#define BN0_WF_RMAC_TOP_NAN2_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0xCC) // 50CC
#define BN0_WF_RMAC_TOP_NAN3_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0xD0) // 50D0
#define BN0_WF_RMAC_TOP_NAN4_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0xD4) // 50D4
#define BN0_WF_RMAC_TOP_NAN5_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0xD8) // 50D8
#define BN0_WF_RMAC_TOP_NANBR0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xDC) // 50DC
#define BN0_WF_RMAC_TOP_NANBR1_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xE0) // 50E0
#define BN0_WF_RMAC_TOP_NANBR2_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xE4) // 50E4
#define BN0_WF_RMAC_TOP_NANBR3_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xE8) // 50E8
#define BN0_WF_RMAC_TOP_NANBR4_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xEC) // 50EC
#define BN0_WF_RMAC_TOP_OPPOPS_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0xF0) // 50F0
#define BN0_WF_RMAC_TOP_TMR0_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0xF4) // 50F4
#define BN0_WF_RMAC_TOP_TMR1_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0xF8) // 50F8
#define BN0_WF_RMAC_TOP_MISC3_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0xFC) // 50FC
#define BN0_WF_RMAC_TOP_CB0R0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x200) // 5200
#define BN0_WF_RMAC_TOP_CB0R1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x204) // 5204
#define BN0_WF_RMAC_TOP_CB1R0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x208) // 5208
#define BN0_WF_RMAC_TOP_CB1R1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x20C) // 520C
#define BN0_WF_RMAC_TOP_CB2R0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x210) // 5210
#define BN0_WF_RMAC_TOP_CB2R1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x214) // 5214
#define BN0_WF_RMAC_TOP_CB3R0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x218) // 5218
#define BN0_WF_RMAC_TOP_CB3R1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x21C) // 521C
#define BN0_WF_RMAC_TOP_OMA0R0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x220) // 5220
#define BN0_WF_RMAC_TOP_OMA0R1_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x224) // 5224
#define BN0_WF_RMAC_TOP_OMA1R0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x228) // 5228
#define BN0_WF_RMAC_TOP_OMA1R1_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x22C) // 522C
#define BN0_WF_RMAC_TOP_OMA2R0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x230) // 5230
#define BN0_WF_RMAC_TOP_OMA2R1_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x234) // 5234
#define BN0_WF_RMAC_TOP_OMA3R0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x238) // 5238
#define BN0_WF_RMAC_TOP_OMA3R1_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x23C) // 523C
#define BN0_WF_RMAC_TOP_OMA4R0_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x240) // 5240
#define BN0_WF_RMAC_TOP_OMA4R1_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x244) // 5244
#define BN0_WF_RMAC_TOP_MBSSID_IDX_ADDR                        (BN0_WF_RMAC_TOP_BASE + 0x248) // 5248
#define BN0_WF_RMAC_TOP_B01AR_B1AR_ADDR                        (BN0_WF_RMAC_TOP_BASE + 0x250) // 5250
#define BN0_WF_RMAC_TOP_B23AR_B1AR_ADDR                        (BN0_WF_RMAC_TOP_BASE + 0x254) // 5254
#define BN0_WF_RMAC_TOP_ACBEN_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x258) // 5258
#define BN0_WF_RMAC_TOP_MAR0_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0x25C) // 525C
#define BN0_WF_RMAC_TOP_MAR1_ADDR                              (BN0_WF_RMAC_TOP_BASE + 0x260) // 5260
#define BN0_WF_RMAC_TOP_MBSSIDACT0_ADDR                        (BN0_WF_RMAC_TOP_BASE + 0x264) // 5264
#define BN0_WF_RMAC_TOP_MBSSIDACT1_ADDR                        (BN0_WF_RMAC_TOP_BASE + 0x268) // 5268
#define BN0_WF_RMAC_TOP_FS0CR_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x26C) // 526C
#define BN0_WF_RMAC_TOP_FS1CR_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x270) // 5270
#define BN0_WF_RMAC_TOP_FS2CR_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x274) // 5274
#define BN0_WF_RMAC_TOP_FS3CR_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x278) // 5278
#define BN0_WF_RMAC_TOP_MUARBR0_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x27C) // 527C
#define BN0_WF_RMAC_TOP_MUARBR1_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x280) // 5280
#define BN0_WF_RMAC_TOP_FSB0BR0_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x284) // 5284
#define BN0_WF_RMAC_TOP_FSB0BR1_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x288) // 5288
#define BN0_WF_RMAC_TOP_FSB1BR0_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x28C) // 528C
#define BN0_WF_RMAC_TOP_FSB1BR1_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x290) // 5290
#define BN0_WF_RMAC_TOP_FSB2BR0_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x294) // 5294
#define BN0_WF_RMAC_TOP_FSB2BR1_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x298) // 5298
#define BN0_WF_RMAC_TOP_FSB3BR0_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x29C) // 529C
#define BN0_WF_RMAC_TOP_FSB3BR1_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x2A0) // 52A0
#define BN0_WF_RMAC_TOP_RSVD0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x2E0) // 52E0
#define BN0_WF_RMAC_TOP_RSVD1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x2E4) // 52E4
#define BN0_WF_RMAC_TOP_AIRTIME17_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x2E8) // 52E8
#define BN0_WF_RMAC_TOP_MIBTIME18_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x2EC) // 52EC
#define BN0_WF_RMAC_TOP_AIRTIME19_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x2F0) // 52F0
#define BN0_WF_RMAC_TOP_MIBTIME20_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x2F4) // 52F4
#define BN0_WF_RMAC_TOP_MBSSIDEXT1_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x300) // 5300
#define BN0_WF_RMAC_TOP_MBSSIDEXT1_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x304) // 5304
#define BN0_WF_RMAC_TOP_MBSSIDEXT2_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x308) // 5308
#define BN0_WF_RMAC_TOP_MBSSIDEXT2_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x30C) // 530C
#define BN0_WF_RMAC_TOP_MBSSIDEXT3_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x310) // 5310
#define BN0_WF_RMAC_TOP_MBSSIDEXT3_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x314) // 5314
#define BN0_WF_RMAC_TOP_MBSSIDEXT4_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x318) // 5318
#define BN0_WF_RMAC_TOP_MBSSIDEXT4_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x31C) // 531C
#define BN0_WF_RMAC_TOP_MBSSIDEXT5_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x320) // 5320
#define BN0_WF_RMAC_TOP_MBSSIDEXT5_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x324) // 5324
#define BN0_WF_RMAC_TOP_MBSSIDEXT6_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x328) // 5328
#define BN0_WF_RMAC_TOP_MBSSIDEXT6_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x32C) // 532C
#define BN0_WF_RMAC_TOP_MBSSIDEXT7_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x330) // 5330
#define BN0_WF_RMAC_TOP_MBSSIDEXT7_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x334) // 5334
#define BN0_WF_RMAC_TOP_MBSSIDEXT8_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x338) // 5338
#define BN0_WF_RMAC_TOP_MBSSIDEXT8_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x33C) // 533C
#define BN0_WF_RMAC_TOP_MBSSIDEXT9_0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x340) // 5340
#define BN0_WF_RMAC_TOP_MBSSIDEXT9_1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x344) // 5344
#define BN0_WF_RMAC_TOP_MBSSIDEXT10_0_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x348) // 5348
#define BN0_WF_RMAC_TOP_MBSSIDEXT10_1_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x34C) // 534C
#define BN0_WF_RMAC_TOP_MBSSIDEXT11_0_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x350) // 5350
#define BN0_WF_RMAC_TOP_MBSSIDEXT11_1_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x354) // 5354
#define BN0_WF_RMAC_TOP_MBSSIDEXT12_0_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x358) // 5358
#define BN0_WF_RMAC_TOP_MBSSIDEXT12_1_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x35C) // 535C
#define BN0_WF_RMAC_TOP_MBSSIDEXT13_0_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x360) // 5360
#define BN0_WF_RMAC_TOP_MBSSIDEXT13_1_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x364) // 5364
#define BN0_WF_RMAC_TOP_MBSSIDEXT14_0_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x368) // 5368
#define BN0_WF_RMAC_TOP_MBSSIDEXT14_1_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x36C) // 536C
#define BN0_WF_RMAC_TOP_MBSSIDEXT15_0_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x370) // 5370
#define BN0_WF_RMAC_TOP_MBSSIDEXT15_1_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x374) // 5374
#define BN0_WF_RMAC_TOP_AIRTIME0_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x380) // 5380
#define BN0_WF_RMAC_TOP_AIRTIME1_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x384) // 5384
#define BN0_WF_RMAC_TOP_AIRTIME2_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x388) // 5388
#define BN0_WF_RMAC_TOP_AIRTIME3_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x38C) // 538C
#define BN0_WF_RMAC_TOP_AIRTIME4_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x390) // 5390
#define BN0_WF_RMAC_TOP_AIRTIME5_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x394) // 5394
#define BN0_WF_RMAC_TOP_AIRTIME6_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x398) // 5398
#define BN0_WF_RMAC_TOP_AIRTIME7_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x39C) // 539C
#define BN0_WF_RMAC_TOP_AIRTIME8_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3A0) // 53A0
#define BN0_WF_RMAC_TOP_AIRTIME9_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3A4) // 53A4
#define BN0_WF_RMAC_TOP_AIRTIME10_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x3A8) // 53A8
#define BN0_WF_RMAC_TOP_AIRTIME11_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x3AC) // 53AC
#define BN0_WF_RMAC_TOP_AIRTIME12_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x3B0) // 53B0
#define BN0_WF_RMAC_TOP_AIRTIME13_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x3B4) // 53B4
#define BN0_WF_RMAC_TOP_AIRTIME14_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x3B8) // 53B8
#define BN0_WF_RMAC_TOP_MIBTIME0_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3C4) // 53C4
#define BN0_WF_RMAC_TOP_MIBTIME1_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3C8) // 53C8
#define BN0_WF_RMAC_TOP_MIBTIME2_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3CC) // 53CC
#define BN0_WF_RMAC_TOP_MIBTIME3_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3D0) // 53D0
#define BN0_WF_RMAC_TOP_MIBTIME4_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3D4) // 53D4
#define BN0_WF_RMAC_TOP_MIBTIME5_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3D8) // 53D8
#define BN0_WF_RMAC_TOP_MIBTIME7_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3E0) // 53E0
#define BN0_WF_RMAC_TOP_MIBTIME8_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x3E4) // 53E4
#define BN0_WF_RMAC_TOP_CFOBSS0_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x3EC) // 53EC
#define BN0_WF_RMAC_TOP_CFOBSS1_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x3F0) // 53F0
#define BN0_WF_RMAC_TOP_CFOBSS2_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x3F4) // 53F4
#define BN0_WF_RMAC_TOP_CFOBSS3_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x3F8) // 53F8
#define BN0_WF_RMAC_TOP_RCPI0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x4A0) // 54A0
#define BN0_WF_RMAC_TOP_RCPI2_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x4A8) // 54A8
#define BN0_WF_RMAC_TOP_RCPI3_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x4AC) // 54AC
#define BN0_WF_RMAC_TOP_RCPI4_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x4B0) // 54B0
#define BN0_WF_RMAC_TOP_RCPI6_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x4B8) // 54B8
#define BN0_WF_RMAC_TOP_RCPI7_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x4BC) // 54BC
#define BN0_WF_RMAC_TOP_RCPI9_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0X4C4) // 54C4
#define BN0_WF_RMAC_TOP_RCPI11_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0X4CC) // 54CC
#define BN0_WF_RMAC_TOP_LRCPITMPCCK0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x588) // 5588
#define BN0_WF_RMAC_TOP_LRCPITMPCCK1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x58C) // 558C
#define BN0_WF_RMAC_TOP_LRCPITMPCCK2_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x590) // 5590
#define BN0_WF_RMAC_TOP_LRCPITMPCCK3_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x594) // 5594
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM0_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x598) // 5598
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM1_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x59C) // 559C
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM2_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x5A0) // 55A0
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM3_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x5A4) // 55A4
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x5A8) // 55A8
#define BN0_WF_RMAC_TOP_TFPARCR0_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x604) // 5604
#define BN0_WF_RMAC_TOP_RXRSPCR_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x608) // 5608
#define BN0_WF_RMAC_TOP_INSUR_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x60C) // 560C
#define BN0_WF_RMAC_TOP_LUINVR_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x610) // 5610
#define BN0_WF_RMAC_TOP_RXMBACR_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x614) // 5614
#define BN0_WF_RMAC_TOP_RXSR0_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x618) // 5618
#define BN0_WF_RMAC_TOP_RXSR1_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x61C) // 561C
#define BN0_WF_RMAC_TOP_RXSR2_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x620) // 5620
#define BN0_WF_RMAC_TOP_RXSR3_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x624) // 5624
#define BN0_WF_RMAC_TOP_RXSR4_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x628) // 5628
#define BN0_WF_RMAC_TOP_NONSRG_INFO0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x630) // 5630
#define BN0_WF_RMAC_TOP_NONSRG_INFO1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x634) // 5634
#define BN0_WF_RMAC_TOP_NONSRG_INFO2_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x638) // 5638
#define BN0_WF_RMAC_TOP_NONSRG_INFO3_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x63C) // 563C
#define BN0_WF_RMAC_TOP_SRG_INFO0_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x640) // 5640
#define BN0_WF_RMAC_TOP_SRG_INFO1_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x644) // 5644
#define BN0_WF_RMAC_TOP_SRG_INFO2_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x648) // 5648
#define BN0_WF_RMAC_TOP_SRG_INFO3_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x64C) // 564C
#define BN0_WF_RMAC_TOP_SRG_VLDCNT_ADDR                        (BN0_WF_RMAC_TOP_BASE + 0x650) // 5650
#define BN0_WF_RMAC_TOP_SR_PPDUCNT_ADDR                        (BN0_WF_RMAC_TOP_BASE + 0x654) // 5654
#define BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_ADDR                     (BN0_WF_RMAC_TOP_BASE + 0x658) // 5658
#define BN0_WF_RMAC_TOP_RXCOEX_ADDR                            (BN0_WF_RMAC_TOP_BASE + 0x670) // 5670
#define BN0_WF_RMAC_TOP_TFCSD_INFO0_ADDR                       (BN0_WF_RMAC_TOP_BASE + 0x680) // 5680
#define BN0_WF_RMAC_TOP_TFCSD_INFO1_ADDR                       (BN0_WF_RMAC_TOP_BASE + 0x684) // 5684
#define BN0_WF_RMAC_TOP_TFPUSR_INFO_ADDR                       (BN0_WF_RMAC_TOP_BASE + 0x688) // 5688
#define BN0_WF_RMAC_TOP_TFFILTER_ADDR                          (BN0_WF_RMAC_TOP_BASE + 0x690) // 5690
#define BN0_WF_RMAC_TOP_TFRXV_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x694) // 5694
#define BN0_WF_RMAC_TOP_DBGCTRL_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x6A0) // 56A0
#define BN0_WF_RMAC_TOP_RXV_DUMP0_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x6B0) // 56B0
#define BN0_WF_RMAC_TOP_RXV_DUMP1_ADDR                         (BN0_WF_RMAC_TOP_BASE + 0x6B4) // 56B4
#define BN0_WF_RMAC_TOP_RX_STS0_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x6C0) // 56C0
#define BN0_WF_RMAC_TOP_RX_STS2_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x6C4) // 56C4
#define BN0_WF_RMAC_TOP_RX_STS3_ADDR                           (BN0_WF_RMAC_TOP_BASE + 0x6C8) // 56C8
#define BN0_WF_RMAC_TOP_TF_USERTONE0_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x6D0) // 56D0
#define BN0_WF_RMAC_TOP_TF_USERTONE1_ADDR                      (BN0_WF_RMAC_TOP_BASE + 0x6D4) // 56D4
#define BN0_WF_RMAC_TOP_MISC4_ADDR                             (BN0_WF_RMAC_TOP_BASE + 0x6E0) // 56E0




/* =====================================================================================

  ---RFCR (0x820E5000 + 0x0)---

    DROP_STBC_BCN_BC_MC[0]       - (RW) Drop STBC beacon/BC/MC frames
                                     0: Bypass this check
                                     1: Discard STBC BC/MC/Beacon frames.
    DROP_FCS_ERROR_FRAME[1]      - (RW) Drop FCS error frames
                                     0: Bypass this check
                                     1: If the FCS check of the packet fails, drop the packet.
    RESERVED2[2]                 - (RO) Reserved bits
    DROP_VERSION_NO_0[3]         - (RW) Drop version field of Frame Control field is not 0
                                     0: Do not check the protocol version field of the 802.11 frame
                                     1: If the protocol version field of the 802.11 frame is not 0, drop it.
    DROP_PROBE_REQ[4]            - (RW) Drop probe request frame
                                     0: The Probe Request frames will pass this check
                                     1: The Probe Request frames will be dropped
    DROP_MC_FRAME[5]             - (RW) Drop multicast frame
                                     0: The multicast frame will pass the check.
                                     1: The multicast frame will be dropped.
    DROP_BC_FRAME[6]             - (RW) Drop broadcast frame
                                     0: The broadcast frame will pass the check.
                                     1: The broadcast frame will be dropped.
    DROP_NOT_IN_MC_TABLE_BSSID0[7] - (RW) For BSSID0 setting
                                     0: All multicast frames will pass the check.
                                     1: If the A1 of the multicast frame specified is not in the multicast-address table (MAR0, MAR1), drop it.
    DROP_ADDR3_OWN_MAC[8]        - (RW) Drop Addr3 is own MAC address
                                     0: Bypass this check
                                     1: If the broadcast/multicast data packet matches the following condition, drop it. Otherwise pass this check.
                                     ToDS = 0,
                                     FromDS = 1
                                     A3 = Own MACx
    DROP_DIFF_BSSID_A3[9]        - (RW) Drop Addr3 is different BSSID
                                     0: Bypass this check
                                     1: If the broadcast/multicast data packet matches the following condition, drop it. Otherwise pass the check.
                                     ToDS = 0,
                                     FromDS = 0,
                                     A3 != BSSIDx
    DROP_DIFF_BSSID_A2[10]       - (RW) Drop Addr2 is different BSSID
                                     0: Bypass this check
                                     1: If the broadcast/multicast data packet matches the following condition, drop it. Otherwise pass the check.
                                     ToDS = 0,
                                     FromDS = 1,
                                     A2 != BSSIDx
    DROP_DIFF_BSSID_BCN[11]      - (RW) Drop different BSSID beacon frames
                                     0: Bypass this check
                                     1: If received beacon frame matches following rule, drop it. Otherwise, pass this check.
                                     A3 != BSSID0 and A3!=BSSID1
    RM_FRAME_REPORT_EN[12]       - (RW) Frame report mode enable
                                     0: Bypass this check
                                     1: Receive all data/mgt frame for Frame Report function
                                     Otherwise, pass this check.
    DROP_CTRL_RSV[13]            - (RW) Drop reserved definition control frames
                                     0: Bypass this check
                                     1: Drop control frames with reserved type
    DROP_CTS[14]                 - (RW) Drop CTS frames
                                     0: Bypass this check
                                     1: Drop CTS frame
    DROP_RTS[15]                 - (RW) Drop RTS frames
                                     0: Bypass this check
                                     1: Drop RTS frame
    DROP_DUPLICATE[16]           - (RW) Drop duplicate frames
                                     0: Bypass this check 
                                     1: Drop duplicate packet. Only MPDU. No BA session frame
    DROP_NOT_MY_BSSID[17]        - (RW) Drop not my BSSID frames
                                     0: Bypass this check
                                     1: Drop not my BSSID0/1/2/3 if enable  each BSSID.
    DROP_NOT_UC2ME[18]           - (RW) Drop not unicast to me frames
                                     0: Bypass this check
                                     1: Drop not unicast to OWNMAC0/1/2/3/4 if enable each OWNMAC
    DROP_DIFF_BSSID_BTIM[19]     - (RW) Drop different BSSID TIM Broadcast frame
                                     0: Not drop diff bssid TIM broadcast
                                     1: Drop diff bssid TIM broadcast
    DROP_NDPA[20]                - (RW) Drop NDPA or not
                                     0: not drop NDPA control frame
                                     1: drop NDPA control frame
    RX_UNWANTED_CTL_FRM[21]      - (RW) Receive unwanted control frame
                                     0: Drop
                                     1: Receive
    IND_FILTER_EN_OF_31_23_BIT[22] - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RFCR 31-23 function
                                     1: Enable RFCR 31-23 function
    SECOND_BCN_EN[23]            - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RX second beacon packet
                                     0: Enable RX second beacon packet
    RX_MGMT_FRAME_CTRL[24]       - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RX all management packet
                                     1: Enable RX all management packet
    RX_DATA_FRAME_CTRL[25]       - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RX all data packet
                                     1: Enable RX all data packet
    RX_SAMEBSSIDPRORESP_CTRL[26] - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RX same BSSID probe response packet
                                     1: Enable RX same BSSID probe response packet
    RX_DIFFBSSIDPRORESP_CTRL[27] - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RX different BSSID probe response packet
                                     1: Enable RX same BSSID probe response packet
    RX_SAMEBSSIDBCN_CTRL[28]     - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RX same BSSID beacon packet
                                     1: Enable RX same BSSID beacon packet
    RX_SAMEBSSIDNULL_CTRL[29]    - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RX same BSSID null-data packet
                                     1: Enable RX same BSSID null-data packet
    RX_DIFFBSSIDNULL_CTRL[30]    - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable RX same BSSID null-data packet
                                     1: Enable RX same BSSID null-data packet
    DROP_DIFFBSSIDMGT_CTRL[31]   - (RW) For normal usage, SW does not need to configure this register
                                     0: Disable drop different BSSID management frame
                                     1: enable drop diffenent BSSID management frame

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFFBSSIDMGT_CTRL_ADDR       BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFFBSSIDMGT_CTRL_MASK       0x80000000                // DROP_DIFFBSSIDMGT_CTRL[31]
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFFBSSIDMGT_CTRL_SHFT       31
#define BN0_WF_RMAC_TOP_RFCR_RX_DIFFBSSIDNULL_CTRL_ADDR        BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RX_DIFFBSSIDNULL_CTRL_MASK        0x40000000                // RX_DIFFBSSIDNULL_CTRL[30]
#define BN0_WF_RMAC_TOP_RFCR_RX_DIFFBSSIDNULL_CTRL_SHFT        30
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDNULL_CTRL_ADDR        BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDNULL_CTRL_MASK        0x20000000                // RX_SAMEBSSIDNULL_CTRL[29]
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDNULL_CTRL_SHFT        29
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDBCN_CTRL_ADDR         BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDBCN_CTRL_MASK         0x10000000                // RX_SAMEBSSIDBCN_CTRL[28]
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDBCN_CTRL_SHFT         28
#define BN0_WF_RMAC_TOP_RFCR_RX_DIFFBSSIDPRORESP_CTRL_ADDR     BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RX_DIFFBSSIDPRORESP_CTRL_MASK     0x08000000                // RX_DIFFBSSIDPRORESP_CTRL[27]
#define BN0_WF_RMAC_TOP_RFCR_RX_DIFFBSSIDPRORESP_CTRL_SHFT     27
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDPRORESP_CTRL_ADDR     BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDPRORESP_CTRL_MASK     0x04000000                // RX_SAMEBSSIDPRORESP_CTRL[26]
#define BN0_WF_RMAC_TOP_RFCR_RX_SAMEBSSIDPRORESP_CTRL_SHFT     26
#define BN0_WF_RMAC_TOP_RFCR_RX_DATA_FRAME_CTRL_ADDR           BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RX_DATA_FRAME_CTRL_MASK           0x02000000                // RX_DATA_FRAME_CTRL[25]
#define BN0_WF_RMAC_TOP_RFCR_RX_DATA_FRAME_CTRL_SHFT           25
#define BN0_WF_RMAC_TOP_RFCR_RX_MGMT_FRAME_CTRL_ADDR           BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RX_MGMT_FRAME_CTRL_MASK           0x01000000                // RX_MGMT_FRAME_CTRL[24]
#define BN0_WF_RMAC_TOP_RFCR_RX_MGMT_FRAME_CTRL_SHFT           24
#define BN0_WF_RMAC_TOP_RFCR_SECOND_BCN_EN_ADDR                BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_SECOND_BCN_EN_MASK                0x00800000                // SECOND_BCN_EN[23]
#define BN0_WF_RMAC_TOP_RFCR_SECOND_BCN_EN_SHFT                23
#define BN0_WF_RMAC_TOP_RFCR_IND_FILTER_EN_OF_31_23_BIT_ADDR   BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_IND_FILTER_EN_OF_31_23_BIT_MASK   0x00400000                // IND_FILTER_EN_OF_31_23_BIT[22]
#define BN0_WF_RMAC_TOP_RFCR_IND_FILTER_EN_OF_31_23_BIT_SHFT   22
#define BN0_WF_RMAC_TOP_RFCR_RX_UNWANTED_CTL_FRM_ADDR          BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RX_UNWANTED_CTL_FRM_MASK          0x00200000                // RX_UNWANTED_CTL_FRM[21]
#define BN0_WF_RMAC_TOP_RFCR_RX_UNWANTED_CTL_FRM_SHFT          21
#define BN0_WF_RMAC_TOP_RFCR_DROP_NDPA_ADDR                    BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_NDPA_MASK                    0x00100000                // DROP_NDPA[20]
#define BN0_WF_RMAC_TOP_RFCR_DROP_NDPA_SHFT                    20
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_BTIM_ADDR         BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_BTIM_MASK         0x00080000                // DROP_DIFF_BSSID_BTIM[19]
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_BTIM_SHFT         19
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_UC2ME_ADDR               BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_UC2ME_MASK               0x00040000                // DROP_NOT_UC2ME[18]
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_UC2ME_SHFT               18
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_MY_BSSID_ADDR            BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_MY_BSSID_MASK            0x00020000                // DROP_NOT_MY_BSSID[17]
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_MY_BSSID_SHFT            17
#define BN0_WF_RMAC_TOP_RFCR_DROP_DUPLICATE_ADDR               BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_DUPLICATE_MASK               0x00010000                // DROP_DUPLICATE[16]
#define BN0_WF_RMAC_TOP_RFCR_DROP_DUPLICATE_SHFT               16
#define BN0_WF_RMAC_TOP_RFCR_DROP_RTS_ADDR                     BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_RTS_MASK                     0x00008000                // DROP_RTS[15]
#define BN0_WF_RMAC_TOP_RFCR_DROP_RTS_SHFT                     15
#define BN0_WF_RMAC_TOP_RFCR_DROP_CTS_ADDR                     BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_CTS_MASK                     0x00004000                // DROP_CTS[14]
#define BN0_WF_RMAC_TOP_RFCR_DROP_CTS_SHFT                     14
#define BN0_WF_RMAC_TOP_RFCR_DROP_CTRL_RSV_ADDR                BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_CTRL_RSV_MASK                0x00002000                // DROP_CTRL_RSV[13]
#define BN0_WF_RMAC_TOP_RFCR_DROP_CTRL_RSV_SHFT                13
#define BN0_WF_RMAC_TOP_RFCR_RM_FRAME_REPORT_EN_ADDR           BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_RM_FRAME_REPORT_EN_MASK           0x00001000                // RM_FRAME_REPORT_EN[12]
#define BN0_WF_RMAC_TOP_RFCR_RM_FRAME_REPORT_EN_SHFT           12
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_BCN_ADDR          BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_BCN_MASK          0x00000800                // DROP_DIFF_BSSID_BCN[11]
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_BCN_SHFT          11
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_A2_ADDR           BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_A2_MASK           0x00000400                // DROP_DIFF_BSSID_A2[10]
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_A2_SHFT           10
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_A3_ADDR           BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_A3_MASK           0x00000200                // DROP_DIFF_BSSID_A3[9]
#define BN0_WF_RMAC_TOP_RFCR_DROP_DIFF_BSSID_A3_SHFT           9
#define BN0_WF_RMAC_TOP_RFCR_DROP_ADDR3_OWN_MAC_ADDR           BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_ADDR3_OWN_MAC_MASK           0x00000100                // DROP_ADDR3_OWN_MAC[8]
#define BN0_WF_RMAC_TOP_RFCR_DROP_ADDR3_OWN_MAC_SHFT           8
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_IN_MC_TABLE_BSSID0_ADDR  BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_IN_MC_TABLE_BSSID0_MASK  0x00000080                // DROP_NOT_IN_MC_TABLE_BSSID0[7]
#define BN0_WF_RMAC_TOP_RFCR_DROP_NOT_IN_MC_TABLE_BSSID0_SHFT  7
#define BN0_WF_RMAC_TOP_RFCR_DROP_BC_FRAME_ADDR                BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_BC_FRAME_MASK                0x00000040                // DROP_BC_FRAME[6]
#define BN0_WF_RMAC_TOP_RFCR_DROP_BC_FRAME_SHFT                6
#define BN0_WF_RMAC_TOP_RFCR_DROP_MC_FRAME_ADDR                BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_MC_FRAME_MASK                0x00000020                // DROP_MC_FRAME[5]
#define BN0_WF_RMAC_TOP_RFCR_DROP_MC_FRAME_SHFT                5
#define BN0_WF_RMAC_TOP_RFCR_DROP_PROBE_REQ_ADDR               BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_PROBE_REQ_MASK               0x00000010                // DROP_PROBE_REQ[4]
#define BN0_WF_RMAC_TOP_RFCR_DROP_PROBE_REQ_SHFT               4
#define BN0_WF_RMAC_TOP_RFCR_DROP_VERSION_NO_0_ADDR            BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_VERSION_NO_0_MASK            0x00000008                // DROP_VERSION_NO_0[3]
#define BN0_WF_RMAC_TOP_RFCR_DROP_VERSION_NO_0_SHFT            3
#define BN0_WF_RMAC_TOP_RFCR_DROP_FCS_ERROR_FRAME_ADDR         BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_FCS_ERROR_FRAME_MASK         0x00000002                // DROP_FCS_ERROR_FRAME[1]
#define BN0_WF_RMAC_TOP_RFCR_DROP_FCS_ERROR_FRAME_SHFT         1
#define BN0_WF_RMAC_TOP_RFCR_DROP_STBC_BCN_BC_MC_ADDR          BN0_WF_RMAC_TOP_RFCR_ADDR
#define BN0_WF_RMAC_TOP_RFCR_DROP_STBC_BCN_BC_MC_MASK          0x00000001                // DROP_STBC_BCN_BC_MC[0]
#define BN0_WF_RMAC_TOP_RFCR_DROP_STBC_BCN_BC_MC_SHFT          0

/* =====================================================================================

  ---RFCR1 (0x820E5000 + 0x4)---

    DROP_NOT_IN_MC_TABLE_BSSID1[0] - (RW) For BSSID1 setting
                                     0: All multicast frames will pass the check.
                                     1: If the A1 of the multicast frame specified is not in the multicast-address table (MAR0, MAR1), drop it.
    DROP_NOT_IN_MC_TABLE_BSSID2[1] - (RW) For BSSID2 setting
                                     0: All multicast frames will pass the check.
                                     1: If the A1 of the multicast frame specified is not in the multicast-address table (MAR0, MAR1), drop it.
    DROP_NOT_IN_MC_TABLE_BSSID3[2] - (RW) For BSSID3 setting
                                     0: All multicast frames will pass the check.
                                     1: If the A1 of the multicast frame specified is not in the multicast-address table (MAR0, MAR1), drop it.
    DROP_NOT_IN_MC_TABLE_BSSIDX[3] - (RW) For un-matching any BSSID setting
                                     0: All multicast frames will pass the check.
                                     1: If the A1 of the multicast frame specified is not in the multicast-address table (MAR0, MAR1), drop it.
    DROP_ACK_FRAME[4]            - (RW) Drop ACK frame
                                     0: Bypass this check. For PS-bit update
                                     1: Discard ACK control frame
    DROP_BFR_POLL_FRAME[5]       - (RW) Drop BeamformReportPoll frame
                                     0: Bypass this check. For PS-bit update
                                     1: Discard Beamform Report Poll control frame
    DROP_BA_FRAME[6]             - (RW) Drop BA frame
                                     0: Bypass this check. For PS-bit update
                                     1: Discard BA control frame
    DROP_CFEND_FRAME[7]          - (RW) Drop CFEND frame
                                     0: Bypass this check. For PS-bit update
                                     1: Discard CFEND control frame
    DROP_CFEND_CFACK_FRAME[8]    - (RW) Drop CFEND_CFACK frame
                                     0: Bypass this check. For PS-bit update
                                     1: Discard CFEND_CFACK control frame
    RX_CTRL_FOR_PS_CFEND_CFACK[9] - (RW) CFEND-CFACK
                                     This bit only effect CFEND_CFACK frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive CFEND_CFACK to DMA, and drop by DMA
    RX_CTRL_FOR_PS_CFEND[10]     - (RW) CFEND frame to update PS bit
                                     This bit only effect CFEND frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive CFEND to DMA, and drop by DMA
    RX_CTRL_FOR_PS_BFRPOL[11]    - (RW) BeamformReportPoll frame to update PS bit
                                     This bit only effect BFRPOL frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive BFRPOL to DMA, and drop by DMA
    RX_CTRL_FOR_PS_NDPA[12]      - (RW) NDPA frame to update PS bit
                                     This bit only effect NDPA frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive NDPA to DMA, and drop by DMA
    RX_CTRL_FOR_PS_RSVD[13]      - (RW) Reserved control frames to update PS bit
                                     This bit only effect RSVD frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive RSVD to DMA, and drop by DMA
    RX_CTRL_FOR_PS_BA[14]        - (RW) BA frame to update PS bit
                                     This bit only effect BA frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive BA to DMA, and drop by DMA
    RX_CTRL_FOR_PS_ACK[15]       - (RW) ACK frame to update PS bit
                                     This bit only effect ACK frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive ACK to DMA, and drop by DMA
    RX_CTRL_FOR_PS_CTS[16]       - (RW) CTS frame to update PS bit
                                     This bit only effect CTS frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive CTS to DMA, and drop by DMA
    RX_CTRL_FOR_PS_RTS[17]       - (RW) RTS frame to update PS bit
                                     This bit only effect RTS frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive RTS to DMA, and drop by DMA
    RX_SMART_CONNECTION_EN[18]   - (RW) For smart connection 
                                     0: disable smart connection
                                     1: enable smart connection. When ToDS=1 and A3=multicast packet, receive it (bypass other RX filter setting except FCS)
    RX_SMART_CONN_NEW_MODE_EN[19] - (RW) Smart Connection New Mode. (Only valid when RX_SMART_CONNECTION_EN == 1)
                                     0 : Disable Smart Connection New Mode.
                                     1 : Enable smart Connection new mode. When Rx packet's destination addr[23:0] matches SCON.SCONN_DA_COMP_PAT, and Rx packet's Addr2 matches designated MAC address configured in MUAR table entry 32~47.(A2 compare is optional and enabled by RX_SMART_CONN_NEW_A2_COMP_EN) 
                                     Receive it. (bypass other RX filter setting except FCS)
    RX_SMART_CONN_NEW_A2_COMP_EN[20] - (RW) Smart Connection New Mode Addr2 Compare Enable (Only valid when RX_SMART_CONNECTION_EN and RX_SMART_CONN_NEW_A2_COMP_EN == 1)
                                     0 : Disable Smart Connection New Mode Addr2 comparison.
                                     1 : Only the Rx packet whose Addr2 matches designated MAC address configured in MUAR table entry 32~47 can further do destination addr compare with SCON.SCONN_DA_COMP_PAT and received by Smart Connection New Mode.
    DROP_RCPI_LT_THR[21]         - (RW) Drop Rx RCPI less the designate RCPI threshold.
                                     0 : Bypass this check.
                                     1 : Discard Rx packet whose RCPI is less than designated threshold configured in SCON.RCPI_DROP_THRESHOLD.
    DROP_NO2ME_TF[22]            - (RW) Drop trigger frame which is not intended to my OWNMAC address or AID.
    DROP_NON_MUBAR_TF[23]        - (RW) Drop trigger frame which is not MU-BAR
    RX_TF_FOR_RXS_BASIC[24]      - (RW) Rx Basic Trigger frame frame to update Rx status
                                     This bit only effect Basic Trigger frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive to DMA, and drop by DMA
    RX_TF_FOR_RXS_BRP[25]        - (RW) Rx BRP Trigger frame frame to update Rx status
                                     This bit only effect BRP Trigger frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive to DMA, and drop by DMA
    RX_TF_FOR_RXS_MURTS[26]      - (RW) Rx Basic Trigger frame frame to update Rx status
                                     This bit only effect Basic Trigger frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive to DMA, and drop by DMA
    RX_TF_FOR_RXS_BSRP[27]       - (RW) Rx BSRP Trigger frame frame to update Rx status
                                     This bit only effect BSRP Trigger frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive to DMA, and drop by DMA
    RX_TF_FOR_RXS_BQRP[28]       - (RW) Rx BQRP Trigger frame frame to update Rx status
                                     This bit only effect BQRP Trigger frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive to DMA, and drop by DMA
    RX_TF_FOR_RXS_NON_SUPPORT[29] - (RW) Rx non-supported Trigger frame frame to update Rx status
                                     This bit only effect non-supportedTrigger frame even if set DROP by RX filter
                                     0: Bypass this check.
                                     1: Receive to DMA, and drop by DMA
    RESERVED30[31..30]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_NON_SUPPORT_ADDR   BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_NON_SUPPORT_MASK   0x20000000                // RX_TF_FOR_RXS_NON_SUPPORT[29]
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_NON_SUPPORT_SHFT   29
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BQRP_ADDR          BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BQRP_MASK          0x10000000                // RX_TF_FOR_RXS_BQRP[28]
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BQRP_SHFT          28
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BSRP_ADDR          BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BSRP_MASK          0x08000000                // RX_TF_FOR_RXS_BSRP[27]
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BSRP_SHFT          27
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_MURTS_ADDR         BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_MURTS_MASK         0x04000000                // RX_TF_FOR_RXS_MURTS[26]
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_MURTS_SHFT         26
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BRP_ADDR           BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BRP_MASK           0x02000000                // RX_TF_FOR_RXS_BRP[25]
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BRP_SHFT           25
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BASIC_ADDR         BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BASIC_MASK         0x01000000                // RX_TF_FOR_RXS_BASIC[24]
#define BN0_WF_RMAC_TOP_RFCR1_RX_TF_FOR_RXS_BASIC_SHFT         24
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NON_MUBAR_TF_ADDR           BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NON_MUBAR_TF_MASK           0x00800000                // DROP_NON_MUBAR_TF[23]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NON_MUBAR_TF_SHFT           23
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NO2ME_TF_ADDR               BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NO2ME_TF_MASK               0x00400000                // DROP_NO2ME_TF[22]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NO2ME_TF_SHFT               22
#define BN0_WF_RMAC_TOP_RFCR1_DROP_RCPI_LT_THR_ADDR            BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_RCPI_LT_THR_MASK            0x00200000                // DROP_RCPI_LT_THR[21]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_RCPI_LT_THR_SHFT            21
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONN_NEW_A2_COMP_EN_ADDR BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONN_NEW_A2_COMP_EN_MASK 0x00100000                // RX_SMART_CONN_NEW_A2_COMP_EN[20]
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONN_NEW_A2_COMP_EN_SHFT 20
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONN_NEW_MODE_EN_ADDR   BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONN_NEW_MODE_EN_MASK   0x00080000                // RX_SMART_CONN_NEW_MODE_EN[19]
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONN_NEW_MODE_EN_SHFT   19
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONNECTION_EN_ADDR      BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONNECTION_EN_MASK      0x00040000                // RX_SMART_CONNECTION_EN[18]
#define BN0_WF_RMAC_TOP_RFCR1_RX_SMART_CONNECTION_EN_SHFT      18
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_RTS_ADDR          BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_RTS_MASK          0x00020000                // RX_CTRL_FOR_PS_RTS[17]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_RTS_SHFT          17
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CTS_ADDR          BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CTS_MASK          0x00010000                // RX_CTRL_FOR_PS_CTS[16]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CTS_SHFT          16
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_ACK_ADDR          BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_ACK_MASK          0x00008000                // RX_CTRL_FOR_PS_ACK[15]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_ACK_SHFT          15
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_BA_ADDR           BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_BA_MASK           0x00004000                // RX_CTRL_FOR_PS_BA[14]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_BA_SHFT           14
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_RSVD_ADDR         BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_RSVD_MASK         0x00002000                // RX_CTRL_FOR_PS_RSVD[13]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_RSVD_SHFT         13
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_NDPA_ADDR         BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_NDPA_MASK         0x00001000                // RX_CTRL_FOR_PS_NDPA[12]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_NDPA_SHFT         12
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_BFRPOL_ADDR       BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_BFRPOL_MASK       0x00000800                // RX_CTRL_FOR_PS_BFRPOL[11]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_BFRPOL_SHFT       11
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CFEND_ADDR        BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CFEND_MASK        0x00000400                // RX_CTRL_FOR_PS_CFEND[10]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CFEND_SHFT        10
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CFEND_CFACK_ADDR  BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CFEND_CFACK_MASK  0x00000200                // RX_CTRL_FOR_PS_CFEND_CFACK[9]
#define BN0_WF_RMAC_TOP_RFCR1_RX_CTRL_FOR_PS_CFEND_CFACK_SHFT  9
#define BN0_WF_RMAC_TOP_RFCR1_DROP_CFEND_CFACK_FRAME_ADDR      BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_CFEND_CFACK_FRAME_MASK      0x00000100                // DROP_CFEND_CFACK_FRAME[8]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_CFEND_CFACK_FRAME_SHFT      8
#define BN0_WF_RMAC_TOP_RFCR1_DROP_CFEND_FRAME_ADDR            BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_CFEND_FRAME_MASK            0x00000080                // DROP_CFEND_FRAME[7]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_CFEND_FRAME_SHFT            7
#define BN0_WF_RMAC_TOP_RFCR1_DROP_BA_FRAME_ADDR               BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_BA_FRAME_MASK               0x00000040                // DROP_BA_FRAME[6]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_BA_FRAME_SHFT               6
#define BN0_WF_RMAC_TOP_RFCR1_DROP_BFR_POLL_FRAME_ADDR         BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_BFR_POLL_FRAME_MASK         0x00000020                // DROP_BFR_POLL_FRAME[5]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_BFR_POLL_FRAME_SHFT         5
#define BN0_WF_RMAC_TOP_RFCR1_DROP_ACK_FRAME_ADDR              BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_ACK_FRAME_MASK              0x00000010                // DROP_ACK_FRAME[4]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_ACK_FRAME_SHFT              4
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSIDX_ADDR BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSIDX_MASK 0x00000008                // DROP_NOT_IN_MC_TABLE_BSSIDX[3]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSIDX_SHFT 3
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID3_ADDR BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID3_MASK 0x00000004                // DROP_NOT_IN_MC_TABLE_BSSID3[2]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID3_SHFT 2
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID2_ADDR BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID2_MASK 0x00000002                // DROP_NOT_IN_MC_TABLE_BSSID2[1]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID2_SHFT 1
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID1_ADDR BN0_WF_RMAC_TOP_RFCR1_ADDR
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID1_MASK 0x00000001                // DROP_NOT_IN_MC_TABLE_BSSID1[0]
#define BN0_WF_RMAC_TOP_RFCR1_DROP_NOT_IN_MC_TABLE_BSSID1_SHFT 0

/* =====================================================================================

  ---BCNF0 (0x820E5000 + 0x8)---

    BCNF0_NUM[7..0]              - (RW) Beacon filter0 IE number
                                     Will be hashed if match this IE number
    BCNF0_EN[8]                  - (RW) Beacon filter0 enable
                                     0: Disable
                                     1: Enable
    RESERVED9[15..9]             - (RO) Reserved bits
    BCNF1_NUM[23..16]            - (RW) Beacon filter1 IE number
                                     Will be hashed if match this IE number
    BCNF1_EN[24]                 - (RW) Beacon filter1 enable
                                     0: Disable
                                     1: Enable
    RESERVED25[31..25]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_BCNF0_BCNF1_EN_ADDR                    BN0_WF_RMAC_TOP_BCNF0_ADDR
#define BN0_WF_RMAC_TOP_BCNF0_BCNF1_EN_MASK                    0x01000000                // BCNF1_EN[24]
#define BN0_WF_RMAC_TOP_BCNF0_BCNF1_EN_SHFT                    24
#define BN0_WF_RMAC_TOP_BCNF0_BCNF1_NUM_ADDR                   BN0_WF_RMAC_TOP_BCNF0_ADDR
#define BN0_WF_RMAC_TOP_BCNF0_BCNF1_NUM_MASK                   0x00FF0000                // BCNF1_NUM[23..16]
#define BN0_WF_RMAC_TOP_BCNF0_BCNF1_NUM_SHFT                   16
#define BN0_WF_RMAC_TOP_BCNF0_BCNF0_EN_ADDR                    BN0_WF_RMAC_TOP_BCNF0_ADDR
#define BN0_WF_RMAC_TOP_BCNF0_BCNF0_EN_MASK                    0x00000100                // BCNF0_EN[8]
#define BN0_WF_RMAC_TOP_BCNF0_BCNF0_EN_SHFT                    8
#define BN0_WF_RMAC_TOP_BCNF0_BCNF0_NUM_ADDR                   BN0_WF_RMAC_TOP_BCNF0_ADDR
#define BN0_WF_RMAC_TOP_BCNF0_BCNF0_NUM_MASK                   0x000000FF                // BCNF0_NUM[7..0]
#define BN0_WF_RMAC_TOP_BCNF0_BCNF0_NUM_SHFT                   0

/* =====================================================================================

  ---BCNF1 (0x820E5000 + 0xC)---

    BCNF2_NUM[7..0]              - (RW) Beacon filter2 IE number
                                     Will be hashed if match this IE number
    BCNF2_EN[8]                  - (RW) Beacon filter2 enable
                                     0: Disable
                                     1: Enable
    RESERVED9[15..9]             - (RO) Reserved bits
    BCNF3_NUM[23..16]            - (RW) Beacon filter3 IE number
                                     Will be hashed if match this IE number
    BCNF3_EN[24]                 - (RW) Beacon filter3 enable
                                     0: Disable
                                     1: Enable
    RESERVED25[31..25]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_BCNF1_BCNF3_EN_ADDR                    BN0_WF_RMAC_TOP_BCNF1_ADDR
#define BN0_WF_RMAC_TOP_BCNF1_BCNF3_EN_MASK                    0x01000000                // BCNF3_EN[24]
#define BN0_WF_RMAC_TOP_BCNF1_BCNF3_EN_SHFT                    24
#define BN0_WF_RMAC_TOP_BCNF1_BCNF3_NUM_ADDR                   BN0_WF_RMAC_TOP_BCNF1_ADDR
#define BN0_WF_RMAC_TOP_BCNF1_BCNF3_NUM_MASK                   0x00FF0000                // BCNF3_NUM[23..16]
#define BN0_WF_RMAC_TOP_BCNF1_BCNF3_NUM_SHFT                   16
#define BN0_WF_RMAC_TOP_BCNF1_BCNF2_EN_ADDR                    BN0_WF_RMAC_TOP_BCNF1_ADDR
#define BN0_WF_RMAC_TOP_BCNF1_BCNF2_EN_MASK                    0x00000100                // BCNF2_EN[8]
#define BN0_WF_RMAC_TOP_BCNF1_BCNF2_EN_SHFT                    8
#define BN0_WF_RMAC_TOP_BCNF1_BCNF2_NUM_ADDR                   BN0_WF_RMAC_TOP_BCNF1_ADDR
#define BN0_WF_RMAC_TOP_BCNF1_BCNF2_NUM_MASK                   0x000000FF                // BCNF2_NUM[7..0]
#define BN0_WF_RMAC_TOP_BCNF1_BCNF2_NUM_SHFT                   0

/* =====================================================================================

  ---BSCR0 (0x820E5000 + 0x10)---

    BA_MAC_ADDR_31_0[31..0]      - (RW) Reset BA scoreboard Addr2 setting
                                     MAC address bits 31~0 for BA scoreboard reset.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_BSCR0_BA_MAC_ADDR_31_0_ADDR            BN0_WF_RMAC_TOP_BSCR0_ADDR
#define BN0_WF_RMAC_TOP_BSCR0_BA_MAC_ADDR_31_0_MASK            0xFFFFFFFF                // BA_MAC_ADDR_31_0[31..0]
#define BN0_WF_RMAC_TOP_BSCR0_BA_MAC_ADDR_31_0_SHFT            0

/* =====================================================================================

  ---BSCR1 (0x820E5000 + 0x14)---

    BA_MAC_ADDR_47_32[15..0]     - (RW) Reset BA scoreboard Addr2 setting
                                     MAC address bits 47~32 for BA scoreboard reset.
    RST_BA_TID[19..16]           - (RW) Reset BA scoreboard TID setting
                                     TID for BA scoreboard reset
    RST_BA_SEL[21..20]           - (RW) Reset BA scoreboard setting
                                     2'b11: Reserved.
                                     2'b10: Reset BA scoreboard without match condition.
                                     2'b01: Reset BA scoreboard if MAC address match.
                                     2'b00: Reset BA scoreboard if MAC address and TID match.
    START_RST_BA_SB[22]          - (WO) Start to reset BA scoreboard
                                     Write 1 to start BA scoreboard reset. Write 0 is meaningless. BA scoreboard includes SSN and bitmap. Read always return zero.
    RESERVED23[27..23]           - (RO) Reserved bits
    RST_BA_SCRBD_ID[31..28]      - (RW) Select the BA scoreboard ID to be reset.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_SCRBD_ID_ADDR             BN0_WF_RMAC_TOP_BSCR1_ADDR
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_SCRBD_ID_MASK             0xF0000000                // RST_BA_SCRBD_ID[31..28]
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_SCRBD_ID_SHFT             28
#define BN0_WF_RMAC_TOP_BSCR1_START_RST_BA_SB_ADDR             BN0_WF_RMAC_TOP_BSCR1_ADDR
#define BN0_WF_RMAC_TOP_BSCR1_START_RST_BA_SB_MASK             0x00400000                // START_RST_BA_SB[22]
#define BN0_WF_RMAC_TOP_BSCR1_START_RST_BA_SB_SHFT             22
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_SEL_ADDR                  BN0_WF_RMAC_TOP_BSCR1_ADDR
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_SEL_MASK                  0x00300000                // RST_BA_SEL[21..20]
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_SEL_SHFT                  20
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_TID_ADDR                  BN0_WF_RMAC_TOP_BSCR1_ADDR
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_TID_MASK                  0x000F0000                // RST_BA_TID[19..16]
#define BN0_WF_RMAC_TOP_BSCR1_RST_BA_TID_SHFT                  16
#define BN0_WF_RMAC_TOP_BSCR1_BA_MAC_ADDR_47_32_ADDR           BN0_WF_RMAC_TOP_BSCR1_ADDR
#define BN0_WF_RMAC_TOP_BSCR1_BA_MAC_ADDR_47_32_MASK           0x0000FFFF                // BA_MAC_ADDR_47_32[15..0]
#define BN0_WF_RMAC_TOP_BSCR1_BA_MAC_ADDR_47_32_SHFT           0

/* =====================================================================================

  ---RMACDR (0x820E5000 + 0x18)---

    RMAC_DMY_31_0[31..0]         - (RW) RMAC Dummy Register. Value should not change except
                                     bit0 is used for Disable TSF upadte when receiving probe response frame
                                     bit1 to bit2 is used for phy_delay offset
                                     bit3 is used for Mozart. 0: to match data packet with ToDS=1 and FrDS=0, BSSID=A3. 1: normal matching. For MT7636.
                                     bit4 is used for Enable TSF upadte when receiving TIM Broadcast frame
                                     bit5 is used for TMR packet drop option
                                     bit6 to bit8 is used for pure phy delay offset
                                     bit9 to use phy2mac_tmr_abort
                                     bit10 to use eco_tmr_rmac_trb_mpdu_drop
                                     bit11 to get_tod_out_pre
                                     bit12 to use toa_vld
                                     bit13 to sel rmac_mdrdy
                                     bit14 to sel 7636 eco
                                     bit15 to sel rxvector_dw1~9 read
                                     bit16 to bit23 is used for phy_delay offset too
                                     bit25 and bit24 is used to 16-BSSID extending option. 3 means 4-bit extend. 2 means 3-bit extend. 1 means 2-bit extend. 0 means 1-bit extend.
                                     bit26 is used to check HTC field by rate or not. 1 is not check by rate
                                     bit27 is used for receive BTIM or not when BTIM with critical beacon
                                     bit28 is used for rx early terminate with NAV comparison
                                     bit29 is used for rx early terminate with BSSID match or not
                                     bit30 is used to select rxv length is 16-bit or 20-bit
                                     bit31 is used for debug

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RMACDR_RMAC_DMY_31_0_ADDR              BN0_WF_RMAC_TOP_RMACDR_ADDR
#define BN0_WF_RMAC_TOP_RMACDR_RMAC_DMY_31_0_MASK              0xFFFFFFFF                // RMAC_DMY_31_0[31..0]
#define BN0_WF_RMAC_TOP_RMACDR_RMAC_DMY_31_0_SHFT              0

/* =====================================================================================

  ---NSUR (0x820E5000 + 0x1C)---

    NAVUPDATEVALUE_25_0[25..0]   - (RO) NAV update value bits 25~0. 
                                     This value is counted in unit of us. The read value is current NAV value
    RESERVED26[29..26]           - (RO) Reserved bits
    EDCA_CTS_RESP[30]            - (RW) This bit controls CTS responding or not when previous EDCA TXOP NAV is not zero. Ex: For some AP,  AP sends CTS2SELF to reserve TXOP and sends RTS to DUT, DUT will response CTS depend on this setting.
                                     1: CTS frame will be responded when RTS frame with A1 match unicast table is received.
                                     0: CTS frame will not be responded
    NAVUPDATE[31]                - (RW) NAV update command and status bit.
                                     When write, 1 indicates the new NAVUpdateValue is write to the NAV field of packet. 
                                     When read, 
                                     0: NAV value update completed
                                     1: NAV value update in progress

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NSUR_NAVUPDATE_ADDR                    BN0_WF_RMAC_TOP_NSUR_ADDR
#define BN0_WF_RMAC_TOP_NSUR_NAVUPDATE_MASK                    0x80000000                // NAVUPDATE[31]
#define BN0_WF_RMAC_TOP_NSUR_NAVUPDATE_SHFT                    31
#define BN0_WF_RMAC_TOP_NSUR_EDCA_CTS_RESP_ADDR                BN0_WF_RMAC_TOP_NSUR_ADDR
#define BN0_WF_RMAC_TOP_NSUR_EDCA_CTS_RESP_MASK                0x40000000                // EDCA_CTS_RESP[30]
#define BN0_WF_RMAC_TOP_NSUR_EDCA_CTS_RESP_SHFT                30
#define BN0_WF_RMAC_TOP_NSUR_NAVUPDATEVALUE_25_0_ADDR          BN0_WF_RMAC_TOP_NSUR_ADDR
#define BN0_WF_RMAC_TOP_NSUR_NAVUPDATEVALUE_25_0_MASK          0x03FFFFFF                // NAVUPDATEVALUE_25_0[25..0]
#define BN0_WF_RMAC_TOP_NSUR_NAVUPDATEVALUE_25_0_SHFT          0

/* =====================================================================================

  ---RMCR (0x820E5000 + 0x20)---

    RX_NOACK_CTRL[0]             - (RW) Setting for throughput debug
                                     0: Send Ack control frame no matter the Rx FIFO is disabled or full. Send BA control frame if there is at least one MPDU with FCS32 OK in AMPDU and it meet  the RX FIFO is disable or full condition
                                     1: Do not send the Ack control frame when the Rx FIFO is disabled or full. Do not send the BA control frame if no any MPDU with FCS32 OK in AMPDU can save in RX FIFO (Rx FIFO is disabled or full)
                                     Note : 
                                     When this field is de-asserted, the bitmap of BA will be set only by  FCS32 check. 
                                     When this field is asserted, the bitmap of BA will be set by FCS32 check and RX packet can be saved in RX FIFO
    RESERVED1[1]                 - (RO) Reserved bits
    BCN_CONTENT_CHK_EN_BSSID0[2] - (RW) Enable DUT checking below specified contents in BSSID0 beacon frame if changed. Refer Chapter Beacon content check for more details.
                                     If Disable, DUT will not check all BSSID0 beacons frame by this function.
                                     If Enable, chip will check the specified content in BSSID0 beacon frame and if the specified content changed, beacon frames will be received, or it will be dropped. It will apply in WLAN_ON state or ON state. 
                                     Write 0 to disable, and write 1 to Enable. 
                                     Read returns the configured value.
                                     0: Disable
                                     1: Enable
    HT_PCO_PHASE_SKIP_EN_BSSID0[3] - (RW) Control the function of HW to skip parsing PCO phase bit in HT operation IE of Beacon from BSSID0, if it is existed.
                                     Write 0 is disable, and write 1 to Enable.
                                     Read returns the configured value.
                                     0: Skip parsing
                                     1: Parsing
    BCN_CONTENT_CHK_EN_BSSID1[4] - (RW) Enable checking below specified contents in BSSID1 beacon frame if changed. Refer Chapter Beacon content check for more details.
                                     If Disable, chip will not check all BSSID1 beacons frame by this function.
                                     If Enable, will check the specified content in BSSID1 beacon frame and if the specified content changed, beacon frames will be received, or it will be dropped. It will apply in WLAN_ON state or ON state. 
                                     Write 0 is disable, and write 1 to Enable. 
                                     Read returns the configured value.
                                     0: Disable
                                     1: Enable
    HT_PCO_PHASE_SKIP_EN_BSSID1[5] - (RW) Control the function of HW to skip parsing PCO phase bit in HT operation IE of Beacon from BSSID1, if it is existed.
                                     Write 0 is disable, and write 1 to Enable.
                                     Read returns the configured value.
                                     0: Skip parsing
                                     1: Parsing
    RESP_BA_IF_RX_BAR_W_NOACK[6] - (RW) Setting for IOT case
                                     0: Not response BA if receiving a BAR with ACK Policy=NoACK
                                     1: Will response BA even the received BAR with ACK Policy=NoACK.
    BCN_WO_TIM_IE_SEL[7]         - (RW) Setting for beacon without TIM IE
                                     0: If received beacon without TIM IE, the signal from RMAC to LP rmac_bcn_w_tim_ie_flag will be 0; if received beacon with TIM IE, the signal rmac_bcn_w_tim_ie_flag wll be 1 to qualify rmac_bcn_w_bmc_flag signal.
                                     1: The signal from RMAC to LP rmac_bcn_w_tim_ie_flag wll be 1 regardless of beacon with/without TIM IE to qualify rmac_bcn_w_bmc_flag. And rmac_bcn_w_bmc_flag will be 0.
    P2P_OUI_TYPE_7_0[15..8]      - (RW) P2P OUI Type
                                     P2P OUI Type for Beacon content check used
    BCN_CONTENT_CHK_EN_BSSID2[16] - (RW) Enable checking below specified contents in BSSID2 beacon frame if changed. Refer Chapter Beacon content check for more details.
                                     If Disable, Chip will not check all BSSID2 beacons frame by this function.
                                     If Enable, Chip will check the specified content in BSSID2 beacon frame and if the specified content changed, beacon frames will be received, or it will be dropped. It will apply in WLAN_ON state or ON state. 
                                     Write 0 to disable, and write 1 to Enable. 
                                     Read returns the configured value.
                                     0: Disable
                                     1: Enable
    HT_PCO_PHASE_SKIP_EN_BSSID2[17] - (RW) Control the function of HW to skip parsing PCO phase bit in HT operation IE of Beacon from BSSID2, if it is existed.
                                     Write 0 to disable, and write 1 to Enable.
                                     Read returns the configured value.
                                     0: Skip parsing
                                     1: Parsing
    BCN_CONTENT_CHK_EN_BSSID3[18] - (RW) Enable checking below specified contents in BSSID3 beacon frame if changed. Refer Chapter Beacon content check for more details.
                                     If Disable, Chip will not check all BSSID3 beacons frame by this function.
                                     If Enable, Chip will check the specified content in BSSID3 beacon frame and if the specified content changed, beacon frames will be received, or it will be dropped. It will apply in WLAN_ON state or ON state. 
                                     Write 0 to disable, and write 1 to Enable. 
                                     Read returns the configured value.
                                     0: Disable
                                     1: Enable
    HT_PCO_PHASE_SKIP_EN_BSSID3[19] - (RW) Control the function of HW to skip parsing PCO phase bit in HT operation IE of Beacon from BSSID3, if it is existed.
                                     Write 0 to disable, and write 1 to Enable.
                                     Read returns the configured value.
                                     0: Skip parsing
                                     1: Parsing
    SMPS_MODE[21..20]            - (RW) SMPS mode control
                                     2'b00: Disable SM Power Saving function. HW automatic turn on all RX stream regardless of RMCR[25:22]
                                     2'b01: Static SM Power Saving mode. SW need to enable one of all RX stream bit (RMCR[25:22])
                                     2'b10: Dynamic SM Power Saving mode. SW need to enable one of all RX stream bit (RMCR[25:22]). HW turn on all RX streams when received a frame (RTS only when set RMCR[26]) addressed to me. HW turn off RX streams and only a single receive chain active when received: A frame not addressed to me
                                     ; A frame with TA not that TXOP owner; CS indicates channel is idle at TxPIFS slot boundary (CR program)
                                     2'b11: Disable SM Power Saving function. HW need turn on  RX stream bit according to (RMCR[25:22])
    RX_STREAM0[22]               - (RW) SMPS RX stream0 control
                                     0: disable RX stream 0
                                     1: enable RX stream 0
    RX_STREAM1[23]               - (RW) SMPS RX stream1 control
                                     0: disable RX stream 1
                                     1: enable RX stream 1
    RX_STREAM2[24]               - (RW) SMPS RX stream2 control
                                     0: disable RX stream 2
                                     1: enable RX stream 2
    RX_STREAM3[25]               - (RW) SMPS RX stream3 control
                                     0: disable RX stream 3
                                     1: enable RX stream 3
    SMPS_BY_RTS_ONLY[26]         - (RW) SMPS by RTS frame only
                                     0: SMPS according to all frame to me
                                     1: SMPS only according RTS frame to me
    RX_EARLY_TERMINATE_TIME_3_0[29..27] - (RW) For LP improve to early terminate RX refinement.
    RX_EARLY_TERMINATE_MODE[31..30] - (RW) For LP improve to early terminate RX.
                                     Mode0: Disable this function
                                     Mode1: Assert 1T mac2phy_disable_phy to implement this function
                                     Mode2: De-assert phy2mac_rx 100ns to implement this function
                                     Mode3: De-assert phy2mac_rx by RMAC calculation

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RMCR_RX_EARLY_TERMINATE_MODE_ADDR      BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_RX_EARLY_TERMINATE_MODE_MASK      0xC0000000                // RX_EARLY_TERMINATE_MODE[31..30]
#define BN0_WF_RMAC_TOP_RMCR_RX_EARLY_TERMINATE_MODE_SHFT      30
#define BN0_WF_RMAC_TOP_RMCR_RX_EARLY_TERMINATE_TIME_3_0_ADDR  BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_RX_EARLY_TERMINATE_TIME_3_0_MASK  0x38000000                // RX_EARLY_TERMINATE_TIME_3_0[29..27]
#define BN0_WF_RMAC_TOP_RMCR_RX_EARLY_TERMINATE_TIME_3_0_SHFT  27
#define BN0_WF_RMAC_TOP_RMCR_SMPS_BY_RTS_ONLY_ADDR             BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_SMPS_BY_RTS_ONLY_MASK             0x04000000                // SMPS_BY_RTS_ONLY[26]
#define BN0_WF_RMAC_TOP_RMCR_SMPS_BY_RTS_ONLY_SHFT             26
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM3_ADDR                   BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM3_MASK                   0x02000000                // RX_STREAM3[25]
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM3_SHFT                   25
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM2_ADDR                   BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM2_MASK                   0x01000000                // RX_STREAM2[24]
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM2_SHFT                   24
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM1_ADDR                   BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM1_MASK                   0x00800000                // RX_STREAM1[23]
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM1_SHFT                   23
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM0_ADDR                   BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM0_MASK                   0x00400000                // RX_STREAM0[22]
#define BN0_WF_RMAC_TOP_RMCR_RX_STREAM0_SHFT                   22
#define BN0_WF_RMAC_TOP_RMCR_SMPS_MODE_ADDR                    BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_SMPS_MODE_MASK                    0x00300000                // SMPS_MODE[21..20]
#define BN0_WF_RMAC_TOP_RMCR_SMPS_MODE_SHFT                    20
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID3_ADDR  BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID3_MASK  0x00080000                // HT_PCO_PHASE_SKIP_EN_BSSID3[19]
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID3_SHFT  19
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID3_ADDR    BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID3_MASK    0x00040000                // BCN_CONTENT_CHK_EN_BSSID3[18]
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID3_SHFT    18
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID2_ADDR  BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID2_MASK  0x00020000                // HT_PCO_PHASE_SKIP_EN_BSSID2[17]
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID2_SHFT  17
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID2_ADDR    BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID2_MASK    0x00010000                // BCN_CONTENT_CHK_EN_BSSID2[16]
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID2_SHFT    16
#define BN0_WF_RMAC_TOP_RMCR_P2P_OUI_TYPE_7_0_ADDR             BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_P2P_OUI_TYPE_7_0_MASK             0x0000FF00                // P2P_OUI_TYPE_7_0[15..8]
#define BN0_WF_RMAC_TOP_RMCR_P2P_OUI_TYPE_7_0_SHFT             8
#define BN0_WF_RMAC_TOP_RMCR_BCN_WO_TIM_IE_SEL_ADDR            BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_BCN_WO_TIM_IE_SEL_MASK            0x00000080                // BCN_WO_TIM_IE_SEL[7]
#define BN0_WF_RMAC_TOP_RMCR_BCN_WO_TIM_IE_SEL_SHFT            7
#define BN0_WF_RMAC_TOP_RMCR_RESP_BA_IF_RX_BAR_W_NOACK_ADDR    BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_RESP_BA_IF_RX_BAR_W_NOACK_MASK    0x00000040                // RESP_BA_IF_RX_BAR_W_NOACK[6]
#define BN0_WF_RMAC_TOP_RMCR_RESP_BA_IF_RX_BAR_W_NOACK_SHFT    6
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID1_ADDR  BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID1_MASK  0x00000020                // HT_PCO_PHASE_SKIP_EN_BSSID1[5]
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID1_SHFT  5
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID1_ADDR    BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID1_MASK    0x00000010                // BCN_CONTENT_CHK_EN_BSSID1[4]
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID1_SHFT    4
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID0_ADDR  BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID0_MASK  0x00000008                // HT_PCO_PHASE_SKIP_EN_BSSID0[3]
#define BN0_WF_RMAC_TOP_RMCR_HT_PCO_PHASE_SKIP_EN_BSSID0_SHFT  3
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID0_ADDR    BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID0_MASK    0x00000004                // BCN_CONTENT_CHK_EN_BSSID0[2]
#define BN0_WF_RMAC_TOP_RMCR_BCN_CONTENT_CHK_EN_BSSID0_SHFT    2
#define BN0_WF_RMAC_TOP_RMCR_RX_NOACK_CTRL_ADDR                BN0_WF_RMAC_TOP_RMCR_ADDR
#define BN0_WF_RMAC_TOP_RMCR_RX_NOACK_CTRL_MASK                0x00000001                // RX_NOACK_CTRL[0]
#define BN0_WF_RMAC_TOP_RMCR_RX_NOACK_CTRL_SHFT                0

/* =====================================================================================

  ---MORE (0x820E5000 + 0x24)---

    MPDU_LEN_COMPARE_13_0[13..0] - (RW) For MPDU length comparison for PHY MIB counter
                                     Debug only
    RX_OUTOFLEN_CNT_FIFOFULL_EN[14] - (RW) Count Rx out of length range case as Rx FIFO full
                                     0 : Rx out of length range packet will not increment RXFIFOFULL MIB counter
                                     1 : Rx out of length range packet will increment RXFIFOFULL MIB counter
    RX_NDP_CNT_OUTOFLEN_EN[15]   - (RW) Count Rx NDP(Null Data Packet) as out of length range.
                                     0 : Rx NDP will not increment RXOUTOFLEN MIB counter
                                     1 : Rx NDP will increment RXOUTOFLEN MIB counter
    RMAC_CR_SMPS_SLOT_IDLE_CNT[17..16] - (RW) SMPS slot idle counter control
                                     2'b00: PIFS
                                     2'b01: PIFS + 1*SLOT
                                     2'b10: PIFS + 2*SLOT
                                     2'b11: PIFS + 3*SLOT
    RMAC_CR_ICAP_CLR_SEL[18]     - (RW) For normal usage, SW does not need to configure this register
    RESERVED19[19]               - (RO) Reserved bits
    RMAC_CR_NO_VEC2[20]          - (RW) For normal usage, SW does not need to configure this register
    RMAC_BTEN_RESULT_SEL[21]     - (RW) For normal usage, SW does not need to configure this register
    DIS_RMAC_FAKE_MDRDY[22]      - (RW) For normal usage, SW does not need to configure this register
    MAC2PHY_RXD_ACK_BEHAVIOR[23] - (RW) For normal usage, SW does not need to configure this register
    Freerun_40MCK_en[24]         - (RW) For normal usage, SW does not need to configure this register
    DBG_CNT_EN[25]               - (RW) For normal usage, SW does not need to configure this register
    DROP_NDP[26]                 - (RW) Drop NPD frame
    DROP_UC2ME_BSSID_UNMATCH[27] - (RW) Drop UC2ME but corresponding BSSID is not matched
    RESERVED28[29..28]           - (RO) Reserved bits
    MUAR_MODE_SEL[31..30]        - (RW) MUAR table mode selection
                                     2'b00: normal mode
                                     2'b01: repeater mode
                                     2'b10: hash mode
                                     2'b11: reserved

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MORE_MUAR_MODE_SEL_ADDR                BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_MUAR_MODE_SEL_MASK                0xC0000000                // MUAR_MODE_SEL[31..30]
#define BN0_WF_RMAC_TOP_MORE_MUAR_MODE_SEL_SHFT                30
#define BN0_WF_RMAC_TOP_MORE_DROP_UC2ME_BSSID_UNMATCH_ADDR     BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_DROP_UC2ME_BSSID_UNMATCH_MASK     0x08000000                // DROP_UC2ME_BSSID_UNMATCH[27]
#define BN0_WF_RMAC_TOP_MORE_DROP_UC2ME_BSSID_UNMATCH_SHFT     27
#define BN0_WF_RMAC_TOP_MORE_DROP_NDP_ADDR                     BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_DROP_NDP_MASK                     0x04000000                // DROP_NDP[26]
#define BN0_WF_RMAC_TOP_MORE_DROP_NDP_SHFT                     26
#define BN0_WF_RMAC_TOP_MORE_DBG_CNT_EN_ADDR                   BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_DBG_CNT_EN_MASK                   0x02000000                // DBG_CNT_EN[25]
#define BN0_WF_RMAC_TOP_MORE_DBG_CNT_EN_SHFT                   25
#define BN0_WF_RMAC_TOP_MORE_Freerun_40MCK_en_ADDR             BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_Freerun_40MCK_en_MASK             0x01000000                // Freerun_40MCK_en[24]
#define BN0_WF_RMAC_TOP_MORE_Freerun_40MCK_en_SHFT             24
#define BN0_WF_RMAC_TOP_MORE_MAC2PHY_RXD_ACK_BEHAVIOR_ADDR     BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_MAC2PHY_RXD_ACK_BEHAVIOR_MASK     0x00800000                // MAC2PHY_RXD_ACK_BEHAVIOR[23]
#define BN0_WF_RMAC_TOP_MORE_MAC2PHY_RXD_ACK_BEHAVIOR_SHFT     23
#define BN0_WF_RMAC_TOP_MORE_DIS_RMAC_FAKE_MDRDY_ADDR          BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_DIS_RMAC_FAKE_MDRDY_MASK          0x00400000                // DIS_RMAC_FAKE_MDRDY[22]
#define BN0_WF_RMAC_TOP_MORE_DIS_RMAC_FAKE_MDRDY_SHFT          22
#define BN0_WF_RMAC_TOP_MORE_RMAC_BTEN_RESULT_SEL_ADDR         BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_RMAC_BTEN_RESULT_SEL_MASK         0x00200000                // RMAC_BTEN_RESULT_SEL[21]
#define BN0_WF_RMAC_TOP_MORE_RMAC_BTEN_RESULT_SEL_SHFT         21
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_NO_VEC2_ADDR              BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_NO_VEC2_MASK              0x00100000                // RMAC_CR_NO_VEC2[20]
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_NO_VEC2_SHFT              20
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_ICAP_CLR_SEL_ADDR         BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_ICAP_CLR_SEL_MASK         0x00040000                // RMAC_CR_ICAP_CLR_SEL[18]
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_ICAP_CLR_SEL_SHFT         18
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_SMPS_SLOT_IDLE_CNT_ADDR   BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_SMPS_SLOT_IDLE_CNT_MASK   0x00030000                // RMAC_CR_SMPS_SLOT_IDLE_CNT[17..16]
#define BN0_WF_RMAC_TOP_MORE_RMAC_CR_SMPS_SLOT_IDLE_CNT_SHFT   16
#define BN0_WF_RMAC_TOP_MORE_RX_NDP_CNT_OUTOFLEN_EN_ADDR       BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_RX_NDP_CNT_OUTOFLEN_EN_MASK       0x00008000                // RX_NDP_CNT_OUTOFLEN_EN[15]
#define BN0_WF_RMAC_TOP_MORE_RX_NDP_CNT_OUTOFLEN_EN_SHFT       15
#define BN0_WF_RMAC_TOP_MORE_RX_OUTOFLEN_CNT_FIFOFULL_EN_ADDR  BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_RX_OUTOFLEN_CNT_FIFOFULL_EN_MASK  0x00004000                // RX_OUTOFLEN_CNT_FIFOFULL_EN[14]
#define BN0_WF_RMAC_TOP_MORE_RX_OUTOFLEN_CNT_FIFOFULL_EN_SHFT  14
#define BN0_WF_RMAC_TOP_MORE_MPDU_LEN_COMPARE_13_0_ADDR        BN0_WF_RMAC_TOP_MORE_ADDR
#define BN0_WF_RMAC_TOP_MORE_MPDU_LEN_COMPARE_13_0_MASK        0x00003FFF                // MPDU_LEN_COMPARE_13_0[13..0]
#define BN0_WF_RMAC_TOP_MORE_MPDU_LEN_COMPARE_13_0_SHFT        0

/* =====================================================================================

  ---LUNVR (0x820E5000 + 0x28)---

    NAV_VALUE[25..0]             - (RO) Latest updated NAV value
                                     unit in us
    RESERVED26[30..26]           - (RO) Reserved bits
    RESET[31]                    - (WO) Reset NAV value for channel switching.
                                     Write 1 to reset and HW auto clear

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LUNVR_RESET_ADDR                       BN0_WF_RMAC_TOP_LUNVR_ADDR
#define BN0_WF_RMAC_TOP_LUNVR_RESET_MASK                       0x80000000                // RESET[31]
#define BN0_WF_RMAC_TOP_LUNVR_RESET_SHFT                       31
#define BN0_WF_RMAC_TOP_LUNVR_NAV_VALUE_ADDR                   BN0_WF_RMAC_TOP_LUNVR_ADDR
#define BN0_WF_RMAC_TOP_LUNVR_NAV_VALUE_MASK                   0x03FFFFFF                // NAV_VALUE[25..0]
#define BN0_WF_RMAC_TOP_LUNVR_NAV_VALUE_SHFT                   0

/* =====================================================================================

  ---SCON (0x820E5000 + 0x2C)---

    SCONN_DA_COMP_PAT[23..0]     - (RW) Smart Connection New Mode Destincation Address Compare Pattern.
                                     Use together with RFCR1.SCONN_NEW_MODE_EN. The Rx packet with destination addr (which is Addr3 when fc.tods = 1, and is Addr1 when fc.frds = 1) matches SCONN_DA_COMP_PAT will be received by MAC Rx and always pass Rx filter.
                                     This field is shared with DAWN trigger frame parsing funciton, when MISC3.A3_PAT_TRI_EN = 1. The Rx Data Frame packet with Addr3[23:0] matches SCONN_DA_COMP_PAT will trigger interrupt
    RCPI_DROP_THRESHOLD[31..24]  - (RW) Minimum Rx packet RCPI threshold.
                                     Use together with RFCR1.DROP_RCPI_LOW_THR. The Rx packet with RCPI less than the RCPI_DROP_THRESHOLD will be dropped.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SCON_RCPI_DROP_THRESHOLD_ADDR          BN0_WF_RMAC_TOP_SCON_ADDR
#define BN0_WF_RMAC_TOP_SCON_RCPI_DROP_THRESHOLD_MASK          0xFF000000                // RCPI_DROP_THRESHOLD[31..24]
#define BN0_WF_RMAC_TOP_SCON_RCPI_DROP_THRESHOLD_SHFT          24
#define BN0_WF_RMAC_TOP_SCON_SCONN_DA_COMP_PAT_ADDR            BN0_WF_RMAC_TOP_SCON_ADDR
#define BN0_WF_RMAC_TOP_SCON_SCONN_DA_COMP_PAT_MASK            0x00FFFFFF                // SCONN_DA_COMP_PAT[23..0]
#define BN0_WF_RMAC_TOP_SCON_SCONN_DA_COMP_PAT_SHFT            0

/* =====================================================================================

  ---CHFREQ (0x820E5000 + 0x30)---

    ChFREQ[7..0]                 - (RW) Channel Frequence
                                     RMAC will latch Channel frequency register value at the begin of per MPDU and send this information to descripters.
                                     Used for sync RF setting.
    A3_COMP_PAT_B47_24[31..8]    - (RW) DAWN Rx Data Frame Address 3 Compare Pattern bit[47:24] field. Only valid when both MISC3.A3_PAT_TRI_EN and MISC3.A3_PAT_CMP_B47_24_EN = 1.
                                     Use together with SCON.SCONN_DA_COMP_PAT. The Rx Data Frame packet with Addr3[47:0] matches{ A3_COMP_PAT_b47_24, SCONN_DA_COMP_PAT} will trigger interrupt.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CHFREQ_A3_COMP_PAT_B47_24_ADDR         BN0_WF_RMAC_TOP_CHFREQ_ADDR
#define BN0_WF_RMAC_TOP_CHFREQ_A3_COMP_PAT_B47_24_MASK         0xFFFFFF00                // A3_COMP_PAT_B47_24[31..8]
#define BN0_WF_RMAC_TOP_CHFREQ_A3_COMP_PAT_B47_24_SHFT         8
#define BN0_WF_RMAC_TOP_CHFREQ_ChFREQ_ADDR                     BN0_WF_RMAC_TOP_CHFREQ_ADDR
#define BN0_WF_RMAC_TOP_CHFREQ_ChFREQ_MASK                     0x000000FF                // ChFREQ[7..0]
#define BN0_WF_RMAC_TOP_CHFREQ_ChFREQ_SHFT                     0

/* =====================================================================================

  ---MISC (0x820E5000 + 0x34)---

    DROP_THRESHOLD[15..0]        - (RW) MPDU drop threshold
                                     RMAC will drop MPDU with length > DROP_THRESHOLD
    PSMP_DUR_SEL[16]             - (RW) PSMP duration control selection
                                     0: PSMP duration will be PSMP action frame header duration
                                     1: PSMP duration will be PSMP Sequence Duration Field (in us)
    BA_TMP_CREATE_DIS[17]        - (RW) BA scoreboard create control
                                     0: Temporary BA will create by AMPDU/BAR
                                     1: Temporary BA will create by AMPDU/BAR/MPDU
    TWOMAC_EN[18]                - (RW) FPGA: default is 1. softphy emulation should set to 0. M2M should set to 1.
                                     ASIC: default is 0.
                                     0: phy2mac_* interface signals will come from PHY
                                     1: phy2mac_* interface signals will come from TWOMAC model
    TSF_HDREND_TO_PLDEND_OFST_EN[19] - (RW) Fine tune of TSF value by SW
                                     0: Fine tune of TSF by HW tick
                                     1: Fine tune of TSF by SW setting
    TSF_HDREND_TO_PLDEND_OFST_SW[23..20] - (RW) Fine tune of TSF value by SW when TSF_HDREND_TO_PLDEND_OFST_EN = 1
    SIGNALING_TA0_SEL[24]        - (RW) Rule 0 for Rx signaling TA
                                     1 : Use original received Rx A2 bit[0]
                                     0 : If Rx frame type is control frame, treat Rx A2 bit [0] = 0.
    SIGNALING_TA1_SEL[25]        - (RW) Rule 1 for Rx signaling TA
                                     1 : Directly treat all Rx A2 bit [0] = 0
                                     0 : Use the rule of SIGNALING_TA0_SEL for Rx A2 bit[0] parsing.
    RESERVED26[27..26]           - (RO) Reserved bits
    RMAC_CR_RX_HOLD_VALUE[31..28] - (RW) For normal usage, SW does not need to configure this register

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MISC_RMAC_CR_RX_HOLD_VALUE_ADDR        BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_RMAC_CR_RX_HOLD_VALUE_MASK        0xF0000000                // RMAC_CR_RX_HOLD_VALUE[31..28]
#define BN0_WF_RMAC_TOP_MISC_RMAC_CR_RX_HOLD_VALUE_SHFT        28
#define BN0_WF_RMAC_TOP_MISC_SIGNALING_TA1_SEL_ADDR            BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_SIGNALING_TA1_SEL_MASK            0x02000000                // SIGNALING_TA1_SEL[25]
#define BN0_WF_RMAC_TOP_MISC_SIGNALING_TA1_SEL_SHFT            25
#define BN0_WF_RMAC_TOP_MISC_SIGNALING_TA0_SEL_ADDR            BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_SIGNALING_TA0_SEL_MASK            0x01000000                // SIGNALING_TA0_SEL[24]
#define BN0_WF_RMAC_TOP_MISC_SIGNALING_TA0_SEL_SHFT            24
#define BN0_WF_RMAC_TOP_MISC_TSF_HDREND_TO_PLDEND_OFST_SW_ADDR BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_TSF_HDREND_TO_PLDEND_OFST_SW_MASK 0x00F00000                // TSF_HDREND_TO_PLDEND_OFST_SW[23..20]
#define BN0_WF_RMAC_TOP_MISC_TSF_HDREND_TO_PLDEND_OFST_SW_SHFT 20
#define BN0_WF_RMAC_TOP_MISC_TSF_HDREND_TO_PLDEND_OFST_EN_ADDR BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_TSF_HDREND_TO_PLDEND_OFST_EN_MASK 0x00080000                // TSF_HDREND_TO_PLDEND_OFST_EN[19]
#define BN0_WF_RMAC_TOP_MISC_TSF_HDREND_TO_PLDEND_OFST_EN_SHFT 19
#define BN0_WF_RMAC_TOP_MISC_TWOMAC_EN_ADDR                    BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_TWOMAC_EN_MASK                    0x00040000                // TWOMAC_EN[18]
#define BN0_WF_RMAC_TOP_MISC_TWOMAC_EN_SHFT                    18
#define BN0_WF_RMAC_TOP_MISC_BA_TMP_CREATE_DIS_ADDR            BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_BA_TMP_CREATE_DIS_MASK            0x00020000                // BA_TMP_CREATE_DIS[17]
#define BN0_WF_RMAC_TOP_MISC_BA_TMP_CREATE_DIS_SHFT            17
#define BN0_WF_RMAC_TOP_MISC_PSMP_DUR_SEL_ADDR                 BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_PSMP_DUR_SEL_MASK                 0x00010000                // PSMP_DUR_SEL[16]
#define BN0_WF_RMAC_TOP_MISC_PSMP_DUR_SEL_SHFT                 16
#define BN0_WF_RMAC_TOP_MISC_DROP_THRESHOLD_ADDR               BN0_WF_RMAC_TOP_MISC_ADDR
#define BN0_WF_RMAC_TOP_MISC_DROP_THRESHOLD_MASK               0x0000FFFF                // DROP_THRESHOLD[15..0]
#define BN0_WF_RMAC_TOP_MISC_DROP_THRESHOLD_SHFT               0

/* =====================================================================================

  ---MAXMINLEN (0x820E5000 + 0x38)---

    MAXLEN[22..0]                - (RW) The length indicated in RXVECTOR1 more than MAXLEN will drop by RMAC.
    RESERVED23[23]               - (RO) Reserved bits
    MINLEN[31..24]               - (RW) The length indicated in RXVECTOR1 less than MINLEN will drop by RMAC.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MAXMINLEN_MINLEN_ADDR                  BN0_WF_RMAC_TOP_MAXMINLEN_ADDR
#define BN0_WF_RMAC_TOP_MAXMINLEN_MINLEN_MASK                  0xFF000000                // MINLEN[31..24]
#define BN0_WF_RMAC_TOP_MAXMINLEN_MINLEN_SHFT                  24
#define BN0_WF_RMAC_TOP_MAXMINLEN_MAXLEN_ADDR                  BN0_WF_RMAC_TOP_MAXMINLEN_ADDR
#define BN0_WF_RMAC_TOP_MAXMINLEN_MAXLEN_MASK                  0x007FFFFF                // MAXLEN[22..0]
#define BN0_WF_RMAC_TOP_MAXMINLEN_MAXLEN_SHFT                  0

/* =====================================================================================

  ---TMR_PA (0x820E5000 + 0x3C)---

    TMR_TYPE_SUBTYPE0[5..0]      - (RW) TMR packet 6 bit type_subtype Set 0
    TMR_TYPE_SUBTYPE1[11..6]     - (RW) TMR packet 6 bit type_subtype Set 1
    TMR_TYPE_SUBTYPE2[17..12]    - (RW) TMR packet 6 bit type_subtype Set 2
    TMR_TYPE_SUBTYPE3[23..18]    - (RW) TMR packet 6 bit type_subtype Set 3
    TMR_CATEGORY0_EN[24]         - (RW) TMR frames parsing to CATEGORY field control
                                     1 to enable TMR1_PA bit15-0 category_action_filed check; is 0 to only check TMR_PA bit5:0
    TMR_CATEGORY1_EN[25]         - (RW) TMR frames parsing to CATEGORY field control
                                     1 to enable TMR1_PA bit31-16 category_action_filed check; is 0 to only check TMR_PA bit11:6
    TMR_CATEGORY2_EN[26]         - (RW) TMR frames parsing to CATEGORY field control
                                     1 to enable TMR0_PA bit15-0 category_action_filed check; is 0 to only check TMR_PA bit17:12
    TMR_CATEGORY3_EN[27]         - (RW) TMR frames parsing to CATEGORY3 field control
                                     1 to enable TMR0_PA bit31-16 category_action_filed check; is 0 to only check TMR_PA bit23:18
    TMR_UNLOCK_CTL[28]           - (RW) TMR unlock
                                     Read is lock status
                                     Write 1 to unlock TMR lock flag
    TMR_LOCK_EN[29]              - (RW) TMR lock function enable
                                     0: disable
                                     1: enable
    TMR_ROLE[30]                 - (RW) TMR role control
                                     0: TX_TMR
                                     1: RX_TMR
    TMR_EN[31]                   - (RW) TMR function enable control
                                     0: disable TMR function
                                     1: enable TMR function

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_EN_ADDR                     BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_EN_MASK                     0x80000000                // TMR_EN[31]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_EN_SHFT                     31
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_ROLE_ADDR                   BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_ROLE_MASK                   0x40000000                // TMR_ROLE[30]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_ROLE_SHFT                   30
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_LOCK_EN_ADDR                BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_LOCK_EN_MASK                0x20000000                // TMR_LOCK_EN[29]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_LOCK_EN_SHFT                29
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_UNLOCK_CTL_ADDR             BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_UNLOCK_CTL_MASK             0x10000000                // TMR_UNLOCK_CTL[28]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_UNLOCK_CTL_SHFT             28
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY3_EN_ADDR           BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY3_EN_MASK           0x08000000                // TMR_CATEGORY3_EN[27]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY3_EN_SHFT           27
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY2_EN_ADDR           BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY2_EN_MASK           0x04000000                // TMR_CATEGORY2_EN[26]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY2_EN_SHFT           26
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY1_EN_ADDR           BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY1_EN_MASK           0x02000000                // TMR_CATEGORY1_EN[25]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY1_EN_SHFT           25
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY0_EN_ADDR           BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY0_EN_MASK           0x01000000                // TMR_CATEGORY0_EN[24]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_CATEGORY0_EN_SHFT           24
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE3_ADDR          BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE3_MASK          0x00FC0000                // TMR_TYPE_SUBTYPE3[23..18]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE3_SHFT          18
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE2_ADDR          BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE2_MASK          0x0003F000                // TMR_TYPE_SUBTYPE2[17..12]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE2_SHFT          12
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE1_ADDR          BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE1_MASK          0x00000FC0                // TMR_TYPE_SUBTYPE1[11..6]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE1_SHFT          6
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE0_ADDR          BN0_WF_RMAC_TOP_TMR_PA_ADDR
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE0_MASK          0x0000003F                // TMR_TYPE_SUBTYPE0[5..0]
#define BN0_WF_RMAC_TOP_TMR_PA_TMR_TYPE_SUBTYPE0_SHFT          0

/* =====================================================================================

  ---NAVOPT_PA (0x820E5000 + 0x40)---

    DAWN_VIOLATE_NAV_EN[0]       - (RW) Dawn violate NAV enable control
                                     0: Normal NAV mechanism.
                                     1: to ignore NAV. We can send packet without checking NAV. After we send packet successfully, we may want to clear xbox_dawn_violate_nav_en to resume original NAV mechanism.
    DAWN_IGNORE_NAV_EN[1]        - (RW) Enalbe/Disable  mechanism that HW ignore NAV value > xbox_dawn_ignore_nav_time_unit
                                     0: Disable
                                     1: Enable
    RESERVED2[7..2]              - (RO) Reserved bits
    DAWN_IGNORE_NAV_TIME_UNIT[15..8] - (RW) 8bit in unit of 100us.
                                     Set the time in unit of 100us to HW. HW will ignore all packets with the NAV when dwan_ignore_nav_en = 1.
    INTRA_NAV_TIMER_EN[16]       - (RW) Enable Intra NAV Timer 0 : Disable 1 : Enable.
    INTRA_BSS_UPD_BY_BSS_COLOR_EN[17] - (RW) Update Intra BSS Status when Rx HE PPDU with BSS_COLOR matches BSSID's BSS Color
                                     0 : Disable  1: Enable
    INTRA_BSS_UPD_BY_PAID_EN[18] - (RW) Update Intra BSS Status when Rx VHT PPDU with GID = 0 & Partial_AID[8:0] matches BSSID[47:39]
                                     0 : Disable  1: Enable
    INTRA_BSS_UPD_BY_PBSS_COLOR_EN[19] - (RW) Update Intra BSS Status when Rx VHT PPDU with GID = 63 & Partial_AID[8:5] matches Partial BSS Color[3:0]
                                     0 : Disable  1: Enable
    INTRA_BSS_UPD_BY_HDR_BSSID_EN[20] - (RW) Update Intra BSS Status when Rx header BSSID matches configured BSSID CRs.
                                     0 : Disable  1: Enable
    INTRA_BSS_UPD_BY_CTL_HOLDER_EN[21] - (RW) Update Intra BSS Status when Rx control frame A1 matches TXOP holder
                                     0 : Disable  1: Enable
    INTRA_BSS_UPD_BY_MBSS_EN[22] - (RW) Update Intra BSS Status when Rx header matches configured MBSSID.
                                     0 : Disable  1: Enable
    RESERVED23[28..23]           - (RO) Reserved bits
    NAV_HOLDER_SEL_BASIC[29]     - (RW) Always use  basic NAV for TXOP holder determination
                                     0 : Disable  1: Enable
    NAV_TXOPDUR_UPD_EN[30]       - (RW) Update Intra/Basic NAV with HE-SIG TXOP_DURATION field.
                                     0 : Disable  1: Enable
    INTRA_NAV_TIMER_RST[31]      - (WC) Reset Intra BSS NAV timer
                                     Write 1 to reset the Intra NAV timer, this bit will be auto cleared after write.
                                     Valid when INTRA_NAV_TIMER_EN = 1.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_NAV_TIMER_RST_ADDR     BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_NAV_TIMER_RST_MASK     0x80000000                // INTRA_NAV_TIMER_RST[31]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_NAV_TIMER_RST_SHFT     31
#define BN0_WF_RMAC_TOP_NAVOPT_PA_NAV_TXOPDUR_UPD_EN_ADDR      BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_NAV_TXOPDUR_UPD_EN_MASK      0x40000000                // NAV_TXOPDUR_UPD_EN[30]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_NAV_TXOPDUR_UPD_EN_SHFT      30
#define BN0_WF_RMAC_TOP_NAVOPT_PA_NAV_HOLDER_SEL_BASIC_ADDR    BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_NAV_HOLDER_SEL_BASIC_MASK    0x20000000                // NAV_HOLDER_SEL_BASIC[29]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_NAV_HOLDER_SEL_BASIC_SHFT    29
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_MBSS_EN_ADDR BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_MBSS_EN_MASK 0x00400000                // INTRA_BSS_UPD_BY_MBSS_EN[22]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_MBSS_EN_SHFT 22
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_CTL_HOLDER_EN_ADDR BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_CTL_HOLDER_EN_MASK 0x00200000                // INTRA_BSS_UPD_BY_CTL_HOLDER_EN[21]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_CTL_HOLDER_EN_SHFT 21
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_HDR_BSSID_EN_ADDR BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_HDR_BSSID_EN_MASK 0x00100000                // INTRA_BSS_UPD_BY_HDR_BSSID_EN[20]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_HDR_BSSID_EN_SHFT 20
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_PBSS_COLOR_EN_ADDR BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_PBSS_COLOR_EN_MASK 0x00080000                // INTRA_BSS_UPD_BY_PBSS_COLOR_EN[19]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_PBSS_COLOR_EN_SHFT 19
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_PAID_EN_ADDR BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_PAID_EN_MASK 0x00040000                // INTRA_BSS_UPD_BY_PAID_EN[18]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_PAID_EN_SHFT 18
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_BSS_COLOR_EN_ADDR BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_BSS_COLOR_EN_MASK 0x00020000                // INTRA_BSS_UPD_BY_BSS_COLOR_EN[17]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_BSS_UPD_BY_BSS_COLOR_EN_SHFT 17
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_NAV_TIMER_EN_ADDR      BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_NAV_TIMER_EN_MASK      0x00010000                // INTRA_NAV_TIMER_EN[16]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_INTRA_NAV_TIMER_EN_SHFT      16
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_IGNORE_NAV_TIME_UNIT_ADDR BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_IGNORE_NAV_TIME_UNIT_MASK 0x0000FF00                // DAWN_IGNORE_NAV_TIME_UNIT[15..8]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_IGNORE_NAV_TIME_UNIT_SHFT 8
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_IGNORE_NAV_EN_ADDR      BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_IGNORE_NAV_EN_MASK      0x00000002                // DAWN_IGNORE_NAV_EN[1]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_IGNORE_NAV_EN_SHFT      1
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_VIOLATE_NAV_EN_ADDR     BN0_WF_RMAC_TOP_NAVOPT_PA_ADDR
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_VIOLATE_NAV_EN_MASK     0x00000001                // DAWN_VIOLATE_NAV_EN[0]
#define BN0_WF_RMAC_TOP_NAVOPT_PA_DAWN_VIOLATE_NAV_EN_SHFT     0

/* =====================================================================================

  ---TXOPPS_PA (0x820E5000 + 0x44)---

    RMAC_CR_PARTIAL_AID[8..0]    - (RW) Partial AID for TXOP PS matching used
    RMAC_CR_TXOP_PS_RX_TIMEOUT[9] - (RW) TXOP Power Saving awake control
                                     0: awake condition do not consider dot11VHTPSProbeDelay (1000us)
                                     1: awake condition do consider the dot11VHTPSProbeDelay (1000us)
    RMAC_CR_TXOP_PS_LSIG_EN[10]  - (RW) TXOP Power Saving L-sig check
                                     0: disable TXOPPS L-sig check 
                                     1: enable TXOPPS L-sig check
    RMAC_CR_TXOP_PS_RX_EN[11]    - (RW) TXOP Power Saving enable
                                     0: disable TXOPPS 
                                     1: enable TXOPPS
    RMAC_BCN_CHK_EL_EN[27..12]   - (RW) Exclude IE comparison of following IE list. MAC won't compare the Information Element with corresponding bit set to 1.
                                     [12] : Exclude IE ID "7" comparison
                                     [13] : Exclude IE ID "12" comparison
                                     [14] : Exclude IE ID "32" comparison
                                     [15] : Exclude IE ID "37" comparison
                                     [16] : Exclude IE ID "40" comparison
                                     [17] : Exclude IE ID "42" comparison
                                     [18] : Exclude IE ID "46" comparison
                                     [19] : Exclude IE ID "61" comparison
                                     [20] : Exclude IE ID "74" comparison
                                     [21] : Exclude IE ID "127 comparison
                                     [22] : Exclude IE ID "191" comparison
                                     [23] : Exclude IE ID "192" comparison
                                     [24] : Exclude IE ID "195" comparison
                                     [25] : Exclude IE ID "196" comparison
                                     [26] : Exclude IE ID "198" comparison
                                     [27] : Exclude IE ID "221" comparison
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_BCN_CHK_EL_EN_ADDR      BN0_WF_RMAC_TOP_TXOPPS_PA_ADDR
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_BCN_CHK_EL_EN_MASK      0x0FFFF000                // RMAC_BCN_CHK_EL_EN[27..12]
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_BCN_CHK_EL_EN_SHFT      12
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_RX_EN_ADDR   BN0_WF_RMAC_TOP_TXOPPS_PA_ADDR
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_RX_EN_MASK   0x00000800                // RMAC_CR_TXOP_PS_RX_EN[11]
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_RX_EN_SHFT   11
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_LSIG_EN_ADDR BN0_WF_RMAC_TOP_TXOPPS_PA_ADDR
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_LSIG_EN_MASK 0x00000400                // RMAC_CR_TXOP_PS_LSIG_EN[10]
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_LSIG_EN_SHFT 10
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_RX_TIMEOUT_ADDR BN0_WF_RMAC_TOP_TXOPPS_PA_ADDR
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_RX_TIMEOUT_MASK 0x00000200                // RMAC_CR_TXOP_PS_RX_TIMEOUT[9]
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_TXOP_PS_RX_TIMEOUT_SHFT 9
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_PARTIAL_AID_ADDR     BN0_WF_RMAC_TOP_TXOPPS_PA_ADDR
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_PARTIAL_AID_MASK     0x000001FF                // RMAC_CR_PARTIAL_AID[8..0]
#define BN0_WF_RMAC_TOP_TXOPPS_PA_RMAC_CR_PARTIAL_AID_SHFT     0

/* =====================================================================================

  ---SMESH (0x820E5000 + 0x48)---

    SMESH_ADDR_EN[7..0]          - (RW) Smart MESH address entry enable control
                                     bit0 to enable entry-32 and entry-40 of MUAR table to SMESH function
                                     bit1 to enable entry-33 and entry-41 of MUAR table to SMESH function
                                     and etc
    RESERVED8[15..8]             - (RO) Reserved bits
    SMESH_RX_A2[16]              - (RW) Smart MESH RX check A2 control
                                     0: Bypass this check
                                     1: Check A2 equals 32~47 entries of MUAR table. If equal, than receive it if SMESH_RX_CTRL/SMESH_RX_MGT/SMESH_RX_DATA match
    SMESH_RX_A1[17]              - (RW) Smart MESH RX check A1 control
                                     0: Bypass this check
                                     1: Check A1 equals 32~47 entries of MUAR table. If equal, than receive it if SMESH_RX_CTRL/SMESH_RX_MGT/SMESH_RX_DATA match
    SMESH_RX_DATA[18]            - (RW) Smart MESH RX data frame control
                                     0: not receive data frame
                                     1: receive data frame when SMESH_RX_A1 or SMESH_RX_A2 match
    SMESH_RX_MGT[19]             - (RW) Smart MESH RX management frame control
                                     0: not receive management frame
                                     1: receive management frame when SMESH_RX_A1 or SMESH_RX_A2 match
    SMESH_RX_CTL[20]             - (RW) Smart MESH RX control
                                     0: not receive ctrl frame
                                     1: receive ctrl frame when SMESH_RX_A1 or SMESH_RX_A2 match
    RESERVED21[31..21]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_CTL_ADDR                BN0_WF_RMAC_TOP_SMESH_ADDR
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_CTL_MASK                0x00100000                // SMESH_RX_CTL[20]
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_CTL_SHFT                20
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_MGT_ADDR                BN0_WF_RMAC_TOP_SMESH_ADDR
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_MGT_MASK                0x00080000                // SMESH_RX_MGT[19]
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_MGT_SHFT                19
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_DATA_ADDR               BN0_WF_RMAC_TOP_SMESH_ADDR
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_DATA_MASK               0x00040000                // SMESH_RX_DATA[18]
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_DATA_SHFT               18
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_A1_ADDR                 BN0_WF_RMAC_TOP_SMESH_ADDR
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_A1_MASK                 0x00020000                // SMESH_RX_A1[17]
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_A1_SHFT                 17
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_A2_ADDR                 BN0_WF_RMAC_TOP_SMESH_ADDR
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_A2_MASK                 0x00010000                // SMESH_RX_A2[16]
#define BN0_WF_RMAC_TOP_SMESH_SMESH_RX_A2_SHFT                 16
#define BN0_WF_RMAC_TOP_SMESH_SMESH_ADDR_EN_ADDR               BN0_WF_RMAC_TOP_SMESH_ADDR
#define BN0_WF_RMAC_TOP_SMESH_SMESH_ADDR_EN_MASK               0x000000FF                // SMESH_ADDR_EN[7..0]
#define BN0_WF_RMAC_TOP_SMESH_SMESH_ADDR_EN_SHFT               0

/* =====================================================================================

  ---BCN01_HASH_BURS_PA (0x820E5000 + 0x4C)---

    HASH16_BSSID0[15..0]         - (RW) Backup/Restore beacon hash
                                     HASH16 result of previous received beacon of BSSID0.  For backup/restore hash16 value when power down
    HASH16_BSSID1[31..16]        - (RW) Backup/Restore beacon hash
                                     HASH16 result of previous received beacon of BSSID1. For backup/restore hash16 value when power down

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_HASH16_BSSID1_ADDR  BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_ADDR
#define BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_HASH16_BSSID1_MASK  0xFFFF0000                // HASH16_BSSID1[31..16]
#define BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_HASH16_BSSID1_SHFT  16
#define BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_HASH16_BSSID0_ADDR  BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_ADDR
#define BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_HASH16_BSSID0_MASK  0x0000FFFF                // HASH16_BSSID0[15..0]
#define BN0_WF_RMAC_TOP_BCN01_HASH_BURS_PA_HASH16_BSSID0_SHFT  0

/* =====================================================================================

  ---BCN23_HASH_BURS_PA (0x820E5000 + 0x50)---

    HASH16_BSSID2[15..0]         - (RW) Backup/Restore beacon hash
                                     HASH16 result of previous received beacon of BSSID2.  For backup/restore hash16 value when power down
    HASH16_BSSID3[31..16]        - (RW) Backup/Restore beacon hash
                                     HASH16 result of previous received beacon of BSSID3. For backup/restore hash16 value when power down

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_HASH16_BSSID3_ADDR  BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_ADDR
#define BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_HASH16_BSSID3_MASK  0xFFFF0000                // HASH16_BSSID3[31..16]
#define BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_HASH16_BSSID3_SHFT  16
#define BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_HASH16_BSSID2_ADDR  BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_ADDR
#define BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_HASH16_BSSID2_MASK  0x0000FFFF                // HASH16_BSSID2[15..0]
#define BN0_WF_RMAC_TOP_BCN23_HASH_BURS_PA_HASH16_BSSID2_SHFT  0

/* =====================================================================================

  ---BTIM_BR (0x820E5000 + 0x54)---

    BTIM_BR_VALUE_BSS3[7..0]     - (RW) Backup/restore BTIM Hash value of BSS3
                                     read to backup BTIM check beacon value
                                     restore to restore BTIM check beacon value
    BTIM_BR_VALUE_BSS2[15..8]    - (RW) Backup/restore BTIM Hash value of BSS2
                                     read to backup BTIM check beacon value
                                     restore to restore BTIM check beacon value
    BTIM_BR_VALUE_BSS1[23..16]   - (RW) Backup/restore BTIM Hash value of BSS1
                                     read to backup BTIM check beacon value
                                     restore to restore BTIM check beacon value
    BTIM_BR_VALUE_BSS0[31..24]   - (RW) Backup/restore BTIM Hash value of BSS0
                                     read to backup BTIM check beacon value
                                     restore to restore BTIM check beacon value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS0_ADDR        BN0_WF_RMAC_TOP_BTIM_BR_ADDR
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS0_MASK        0xFF000000                // BTIM_BR_VALUE_BSS0[31..24]
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS0_SHFT        24
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS1_ADDR        BN0_WF_RMAC_TOP_BTIM_BR_ADDR
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS1_MASK        0x00FF0000                // BTIM_BR_VALUE_BSS1[23..16]
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS1_SHFT        16
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS2_ADDR        BN0_WF_RMAC_TOP_BTIM_BR_ADDR
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS2_MASK        0x0000FF00                // BTIM_BR_VALUE_BSS2[15..8]
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS2_SHFT        8
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS3_ADDR        BN0_WF_RMAC_TOP_BTIM_BR_ADDR
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS3_MASK        0x000000FF                // BTIM_BR_VALUE_BSS3[7..0]
#define BN0_WF_RMAC_TOP_BTIM_BR_BTIM_BR_VALUE_BSS3_SHFT        0

/* =====================================================================================

  ---MISC2 (0x820E5000 + 0x58)---

    DOT11VHTPROBEDELAY[9..0]     - (RW) The definition of dot11VHTProbeDelay
    RESERVED10[13..10]           - (RO) Reserved bits
    ZHF_SUPPORT[14]              - (RW) Zero handoff support for NAV update or not
                                     0: update NAV for normal regular rule
                                     1: update NAV by wlan table decision
    RESERVED15[16..15]           - (RO) Reserved bits
    RXPHY_DLAY_FOR_TXOPPS_DIS[17] - (RW) TXOP Power Saving wakeup control
                                     0: Enable the RXPHY_DELAY compensation for TXOPPS
                                     1: Disable the RXPHY_DELAY compensation for TXOPPS
    RESERVED18[18]               - (RO) Reserved bits
    PARTIAL_BCN_RCPI_EN[19]      - (RW) Partial beacon RCPI update control
                                     0: Do not update RCPI if partial beacon meet
                                     1: Do update RCPI if partial beacon meet
    INDIUM_DATA_PKT_BSSID_SET[23..20] - (RW) INDIUM management frame control
                                     0: set more bit to 0
                                     1: set more bit to 1 if packet is data frame
                                     bit23 for BSSID3
                                     bit22 for BSSID2
                                     bit21 for BSSID1
                                     bit20 for BSSID0
    INDIUM_MGNT_PKT_BSSID_SET[27..24] - (RW) INDIUM management frame control
                                     0: set more bit to 0
                                     1: set more bit to 1 if packet is management frame
                                     bit27 for BSSID3
                                     bit26 for BSSID2
                                     bit25 for BSSID1
                                     bit24 for BSSID0
    INDIUM_MORE_BIT_BSSID_SET[31..28] - (RW) INDIUM more bit control
                                     0: use inverse of more_bit
                                     1: use more-bit
                                     bit31 for BSSID3
                                     bit30 for BSSID2
                                     bit29 for BSSID1
                                     bit28 for BSSID0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_MORE_BIT_BSSID_SET_ADDR   BN0_WF_RMAC_TOP_MISC2_ADDR
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_MORE_BIT_BSSID_SET_MASK   0xF0000000                // INDIUM_MORE_BIT_BSSID_SET[31..28]
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_MORE_BIT_BSSID_SET_SHFT   28
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_MGNT_PKT_BSSID_SET_ADDR   BN0_WF_RMAC_TOP_MISC2_ADDR
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_MGNT_PKT_BSSID_SET_MASK   0x0F000000                // INDIUM_MGNT_PKT_BSSID_SET[27..24]
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_MGNT_PKT_BSSID_SET_SHFT   24
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_DATA_PKT_BSSID_SET_ADDR   BN0_WF_RMAC_TOP_MISC2_ADDR
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_DATA_PKT_BSSID_SET_MASK   0x00F00000                // INDIUM_DATA_PKT_BSSID_SET[23..20]
#define BN0_WF_RMAC_TOP_MISC2_INDIUM_DATA_PKT_BSSID_SET_SHFT   20
#define BN0_WF_RMAC_TOP_MISC2_PARTIAL_BCN_RCPI_EN_ADDR         BN0_WF_RMAC_TOP_MISC2_ADDR
#define BN0_WF_RMAC_TOP_MISC2_PARTIAL_BCN_RCPI_EN_MASK         0x00080000                // PARTIAL_BCN_RCPI_EN[19]
#define BN0_WF_RMAC_TOP_MISC2_PARTIAL_BCN_RCPI_EN_SHFT         19
#define BN0_WF_RMAC_TOP_MISC2_RXPHY_DLAY_FOR_TXOPPS_DIS_ADDR   BN0_WF_RMAC_TOP_MISC2_ADDR
#define BN0_WF_RMAC_TOP_MISC2_RXPHY_DLAY_FOR_TXOPPS_DIS_MASK   0x00020000                // RXPHY_DLAY_FOR_TXOPPS_DIS[17]
#define BN0_WF_RMAC_TOP_MISC2_RXPHY_DLAY_FOR_TXOPPS_DIS_SHFT   17
#define BN0_WF_RMAC_TOP_MISC2_ZHF_SUPPORT_ADDR                 BN0_WF_RMAC_TOP_MISC2_ADDR
#define BN0_WF_RMAC_TOP_MISC2_ZHF_SUPPORT_MASK                 0x00004000                // ZHF_SUPPORT[14]
#define BN0_WF_RMAC_TOP_MISC2_ZHF_SUPPORT_SHFT                 14
#define BN0_WF_RMAC_TOP_MISC2_DOT11VHTPROBEDELAY_ADDR          BN0_WF_RMAC_TOP_MISC2_ADDR
#define BN0_WF_RMAC_TOP_MISC2_DOT11VHTPROBEDELAY_MASK          0x000003FF                // DOT11VHTPROBEDELAY[9..0]
#define BN0_WF_RMAC_TOP_MISC2_DOT11VHTPROBEDELAY_SHFT          0

/* =====================================================================================

  ---S80CICR (0x820E5000 + 0x5C)---

    ITFR_TOTAL_CNT[14..0]        - (RO) ITFR total count. Clear when SEC80_ITFR_EN from 0 to 1. Implemented as above
    RESERVED15[15]               - (RO) Reserved bits
    ITFR_ASSERT_CNT[30..16]      - (RO) ITFR assert count. Clear when SEC80_ITFR_EN from 0 to 1. Implemented as
                                     If(MODE==OFDM){
                                       If(RX_VECTOR==BW160) {
                                         if(SEC80_CH_ITFR_TOTAL!=0x7fff) {
                                           SEC80_CH_ITFR_TOTAL++
                                           If(Sec_ITFR_ENV) {
                                             SEC80_CH_ITFR_ASSERT_CNT++
                                           }
                                         }
                                       } // BW160
                                     }// OFDM//
    SEC80_ITFR_EN[31]            - (RW) Indicate the secondary80 channel interference to be true under OFDM and BW20.
                                     Note, sec_itfr is only valid when packet is OFDM and 40M BW but regardless of UC2MAC/FCS32_OK. Sec_infr_cnt will only be clear when OFDM and 40M BW but itfr_en=0.
                                     Once, the Sec_itfr_cnt is larger than or equal to BW40_TO_20_THRESHOLD, SEC_ITFR will be 1 until write/read clear by SW.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_S80CICR_SEC80_ITFR_EN_ADDR             BN0_WF_RMAC_TOP_S80CICR_ADDR
#define BN0_WF_RMAC_TOP_S80CICR_SEC80_ITFR_EN_MASK             0x80000000                // SEC80_ITFR_EN[31]
#define BN0_WF_RMAC_TOP_S80CICR_SEC80_ITFR_EN_SHFT             31
#define BN0_WF_RMAC_TOP_S80CICR_ITFR_ASSERT_CNT_ADDR           BN0_WF_RMAC_TOP_S80CICR_ADDR
#define BN0_WF_RMAC_TOP_S80CICR_ITFR_ASSERT_CNT_MASK           0x7FFF0000                // ITFR_ASSERT_CNT[30..16]
#define BN0_WF_RMAC_TOP_S80CICR_ITFR_ASSERT_CNT_SHFT           16
#define BN0_WF_RMAC_TOP_S80CICR_ITFR_TOTAL_CNT_ADDR            BN0_WF_RMAC_TOP_S80CICR_ADDR
#define BN0_WF_RMAC_TOP_S80CICR_ITFR_TOTAL_CNT_MASK            0x00007FFF                // ITFR_TOTAL_CNT[14..0]
#define BN0_WF_RMAC_TOP_S80CICR_ITFR_TOTAL_CNT_SHFT            0

/* =====================================================================================

  ---PCICR (0x820E5000 + 0x60)---

    ITFR_TOTAL_CNT[14..0]        - (RO) ITFR total count. Clear when PRIM_ITFR_EN from 0 to 1. implemented as above
    RESERVED15[15]               - (RO) Reserved bits
    ITFR_ASSERT_CNT[30..16]      - (RO) ITFR assert count. Clear when PRIM_ITFR_EN from 0 to 1. Implemented as
                                     If(MODE==OFDM){
                                       If(RX_VECTOR==BW20 | BW40 | BW80) {
                                         if(PRIM_CH_ITFR_TOTAL!=0x7fff) {
                                           PRIM_CH_ITFR_TOTAL++
                                           If(Prim_ITFR_ENV) {
                                             PRI_CH_ITFR_ASSERT_CNT++
                                           }
                                         }
                                       } // BW20 | BW40 | BW80
                                     }// OFDM//
    PRIM_ITFR_EN[31]             - (RW) Indicate the primary channel interference to be true under OFDM and BW20.
                                     Note, sec_itfr is only valid when packet is OFDM and 40M BW but regardless of UC2MAC/FCS32_OK. Sec_infr_cnt will only be clear when OFDM and 40M BW but itfr_en=0.
                                     Once, the Sec_itfr_cnt is larger than or equal to BW40_TO_20_THRESHOLD, SEC_ITFR will be 1 until write/read clear by SW.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_PCICR_PRIM_ITFR_EN_ADDR                BN0_WF_RMAC_TOP_PCICR_ADDR
#define BN0_WF_RMAC_TOP_PCICR_PRIM_ITFR_EN_MASK                0x80000000                // PRIM_ITFR_EN[31]
#define BN0_WF_RMAC_TOP_PCICR_PRIM_ITFR_EN_SHFT                31
#define BN0_WF_RMAC_TOP_PCICR_ITFR_ASSERT_CNT_ADDR             BN0_WF_RMAC_TOP_PCICR_ADDR
#define BN0_WF_RMAC_TOP_PCICR_ITFR_ASSERT_CNT_MASK             0x7FFF0000                // ITFR_ASSERT_CNT[30..16]
#define BN0_WF_RMAC_TOP_PCICR_ITFR_ASSERT_CNT_SHFT             16
#define BN0_WF_RMAC_TOP_PCICR_ITFR_TOTAL_CNT_ADDR              BN0_WF_RMAC_TOP_PCICR_ADDR
#define BN0_WF_RMAC_TOP_PCICR_ITFR_TOTAL_CNT_MASK              0x00007FFF                // ITFR_TOTAL_CNT[14..0]
#define BN0_WF_RMAC_TOP_PCICR_ITFR_TOTAL_CNT_SHFT              0

/* =====================================================================================

  ---SCICR (0x820E5000 + 0x64)---

    ITFR_TOTAL_CNT[14..0]        - (RO) ITFR total count. Clear when SEC_ITFR_EN from 0 to 1. Implemented as above
    RESERVED15[15]               - (RO) Reserved bits
    ITFR_ASSERT_CNT[30..16]      - (RO) ITFR assert count. Clear when SEC_ITFR_EN from 0 to 1. Implemented as
                                     If(MODE==OFDM){
                                       If(RX_VECTOR==BW40 | BW80) {
                                         if(SEC_CH_ITFR_TOTAL!=0x7fff) {
                                           SEC_CH_ITFR_TOTAL++
                                           If(Sec_ITFR_ENV) {
                                             SEC_CH_ITFR_ASSERT_CNT++
                                           }
                                         }
                                       } // BW40 | BW80
                                     }// OFDM//
    SEC_ITFR_EN[31]              - (RW) Indicate the secondary channel interference to be true under OFDM and BW20.
                                     Note, sec_itfr is only valid when packet is OFDM and 40M BW but regardless of UC2MAC/FCS32_OK. Sec_infr_cnt will only be clear when OFDM and 40M BW but itfr_en=0.
                                     Once, the Sec_itfr_cnt is larger than or equal to BW40_TO_20_THRESHOLD, SEC_ITFR will be 1 until write/read clear by SW.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SCICR_SEC_ITFR_EN_ADDR                 BN0_WF_RMAC_TOP_SCICR_ADDR
#define BN0_WF_RMAC_TOP_SCICR_SEC_ITFR_EN_MASK                 0x80000000                // SEC_ITFR_EN[31]
#define BN0_WF_RMAC_TOP_SCICR_SEC_ITFR_EN_SHFT                 31
#define BN0_WF_RMAC_TOP_SCICR_ITFR_ASSERT_CNT_ADDR             BN0_WF_RMAC_TOP_SCICR_ADDR
#define BN0_WF_RMAC_TOP_SCICR_ITFR_ASSERT_CNT_MASK             0x7FFF0000                // ITFR_ASSERT_CNT[30..16]
#define BN0_WF_RMAC_TOP_SCICR_ITFR_ASSERT_CNT_SHFT             16
#define BN0_WF_RMAC_TOP_SCICR_ITFR_TOTAL_CNT_ADDR              BN0_WF_RMAC_TOP_SCICR_ADDR
#define BN0_WF_RMAC_TOP_SCICR_ITFR_TOTAL_CNT_MASK              0x00007FFF                // ITFR_TOTAL_CNT[14..0]
#define BN0_WF_RMAC_TOP_SCICR_ITFR_TOTAL_CNT_SHFT              0

/* =====================================================================================

  ---S40CICR (0x820E5000 + 0x68)---

    ITFR_TOTAL_CNT[14..0]        - (RO) ITFR total count. Clear when SEC40_ITFR_EN from 0 to 1. Implemented as above
    RESERVED15[15]               - (RO) Reserved bits
    ITFR_ASSERT_CNT[30..16]      - (RO) ITFR assert count. Clear when SEC40_ITFR_EN from 0 to 1. Implemented as
                                     If(MODE==OFDM){
                                       If(RX_VECTOR==BW80) {
                                         if(SEC40_CH_ITFR_TOTAL!=0x7fff) {
                                           SEC40_CH_ITFR_TOTAL++
                                           If(Sec_ITFR_ENV) {
                                             SEC40_CH_ITFR_ASSERT_CNT++
                                           }
                                         }
                                       } // BW80
                                     }// OFDM//
    SEC40_ITFR_EN[31]            - (RW) Indicate the secondary40 channel interference to be true under OFDM and BW20.
                                     Note, sec_itfr is only valid when packet is OFDM and 40M BW but regardless of UC2MAC/FCS32_OK. Sec_infr_cnt will only be clear when OFDM and 40M BW but itfr_en=0.
                                     Once, the Sec_itfr_cnt is larger than or equal to BW40_TO_20_THRESHOLD, SEC_ITFR will be 1 until write/read clear by SW.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_S40CICR_SEC40_ITFR_EN_ADDR             BN0_WF_RMAC_TOP_S40CICR_ADDR
#define BN0_WF_RMAC_TOP_S40CICR_SEC40_ITFR_EN_MASK             0x80000000                // SEC40_ITFR_EN[31]
#define BN0_WF_RMAC_TOP_S40CICR_SEC40_ITFR_EN_SHFT             31
#define BN0_WF_RMAC_TOP_S40CICR_ITFR_ASSERT_CNT_ADDR           BN0_WF_RMAC_TOP_S40CICR_ADDR
#define BN0_WF_RMAC_TOP_S40CICR_ITFR_ASSERT_CNT_MASK           0x7FFF0000                // ITFR_ASSERT_CNT[30..16]
#define BN0_WF_RMAC_TOP_S40CICR_ITFR_ASSERT_CNT_SHFT           16
#define BN0_WF_RMAC_TOP_S40CICR_ITFR_TOTAL_CNT_ADDR            BN0_WF_RMAC_TOP_S40CICR_ADDR
#define BN0_WF_RMAC_TOP_S40CICR_ITFR_TOTAL_CNT_MASK            0x00007FFF                // ITFR_TOTAL_CNT[14..0]
#define BN0_WF_RMAC_TOP_S40CICR_ITFR_TOTAL_CNT_SHFT            0

/* =====================================================================================

  ---PHY_DELAY (0x820E5000 + 0x6C)---

    RMAC_CR_FAGC_NS[15..0]       - (RW) This CR is used to fine tune OFDM PHY delay
                                     Refer to BB MAC interface document.
    RMAC_CR_96US[23..16]         - (RW) This CR is used to fine tune CCK short preamble PHY delay
                                     Refer to BB_MAC_interface.doc
    RMAC_CR_192US[31..24]        - (RW) This CR is used to fine tune CCK long preamble PHY delay
                                     Refer to BB_MAC_interface.doc

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_192US_ADDR           BN0_WF_RMAC_TOP_PHY_DELAY_ADDR
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_192US_MASK           0xFF000000                // RMAC_CR_192US[31..24]
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_192US_SHFT           24
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_96US_ADDR            BN0_WF_RMAC_TOP_PHY_DELAY_ADDR
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_96US_MASK            0x00FF0000                // RMAC_CR_96US[23..16]
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_96US_SHFT            16
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_FAGC_NS_ADDR         BN0_WF_RMAC_TOP_PHY_DELAY_ADDR
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_FAGC_NS_MASK         0x0000FFFF                // RMAC_CR_FAGC_NS[15..0]
#define BN0_WF_RMAC_TOP_PHY_DELAY_RMAC_CR_FAGC_NS_SHFT         0

/* =====================================================================================

  ---PMSRC0 (0x820E5000 + 0x70)---

    LEN_COMPARE[15..0]           - (RW) LIG field matching control. For CSD debug used.
                                     PPDU Length compare for LARGER and EQUAL trigger condition
    RX_MODE[18..16]              - (RW) LIG field matching control. For CSD debug used.
                                     RX_MODE match
    RX_AGGREGATION[19]           - (RW) LIG field matching control. For CSD debug used.
                                     RX_AGGREGATION match
    RX_RXRATE[26..20]            - (RW) LIG field matching control. For CSD debug used.
                                     RX_RXRATE match
    RX_FRMODE[28..27]            - (RW) LIG field matching control. For CSD debug used.
                                     RX_FRMODE match
    PMSRC0_RSVD[29]              - (RW) LIG field matching control. For CSD debug used.
                                     Reserved register
    STBC[31..30]                 - (RW) LIG field matching control. For CSD debug used.
                                     STBC match

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_PMSRC0_STBC_ADDR                       BN0_WF_RMAC_TOP_PMSRC0_ADDR
#define BN0_WF_RMAC_TOP_PMSRC0_STBC_MASK                       0xC0000000                // STBC[31..30]
#define BN0_WF_RMAC_TOP_PMSRC0_STBC_SHFT                       30
#define BN0_WF_RMAC_TOP_PMSRC0_PMSRC0_RSVD_ADDR                BN0_WF_RMAC_TOP_PMSRC0_ADDR
#define BN0_WF_RMAC_TOP_PMSRC0_PMSRC0_RSVD_MASK                0x20000000                // PMSRC0_RSVD[29]
#define BN0_WF_RMAC_TOP_PMSRC0_PMSRC0_RSVD_SHFT                29
#define BN0_WF_RMAC_TOP_PMSRC0_RX_FRMODE_ADDR                  BN0_WF_RMAC_TOP_PMSRC0_ADDR
#define BN0_WF_RMAC_TOP_PMSRC0_RX_FRMODE_MASK                  0x18000000                // RX_FRMODE[28..27]
#define BN0_WF_RMAC_TOP_PMSRC0_RX_FRMODE_SHFT                  27
#define BN0_WF_RMAC_TOP_PMSRC0_RX_RXRATE_ADDR                  BN0_WF_RMAC_TOP_PMSRC0_ADDR
#define BN0_WF_RMAC_TOP_PMSRC0_RX_RXRATE_MASK                  0x07F00000                // RX_RXRATE[26..20]
#define BN0_WF_RMAC_TOP_PMSRC0_RX_RXRATE_SHFT                  20
#define BN0_WF_RMAC_TOP_PMSRC0_RX_AGGREGATION_ADDR             BN0_WF_RMAC_TOP_PMSRC0_ADDR
#define BN0_WF_RMAC_TOP_PMSRC0_RX_AGGREGATION_MASK             0x00080000                // RX_AGGREGATION[19]
#define BN0_WF_RMAC_TOP_PMSRC0_RX_AGGREGATION_SHFT             19
#define BN0_WF_RMAC_TOP_PMSRC0_RX_MODE_ADDR                    BN0_WF_RMAC_TOP_PMSRC0_ADDR
#define BN0_WF_RMAC_TOP_PMSRC0_RX_MODE_MASK                    0x00070000                // RX_MODE[18..16]
#define BN0_WF_RMAC_TOP_PMSRC0_RX_MODE_SHFT                    16
#define BN0_WF_RMAC_TOP_PMSRC0_LEN_COMPARE_ADDR                BN0_WF_RMAC_TOP_PMSRC0_ADDR
#define BN0_WF_RMAC_TOP_PMSRC0_LEN_COMPARE_MASK                0x0000FFFF                // LEN_COMPARE[15..0]
#define BN0_WF_RMAC_TOP_PMSRC0_LEN_COMPARE_SHFT                0

/* =====================================================================================

  ---PMCTL0 (0x820E5000 + 0x74)---

    PPDU_LEN_EQ_HIT[1..0]        - (RW) To control PPDU LEN hit event
                                     2'b00: Fixed at 0 (LEN_EQ always not Match)
                                     2'b01: Fixed at 1 (LEN_EQ always Match)
                                     2'b10: A
                                     2'b11: ~A
    PMCTL0_RSV[3..2]             - (RW) Reserved CR bit
    Mode_HIT[5..4]               - (RW) To control MODE hit event
                                     2'b00: Fixed at 0 (MODE always not Match)
                                     2'b01: Fixed at 1 (MODE C always Match)
                                     2'b10: A
                                     2'b11: ~A
    AGG_HIT[7..6]                - (RW) To control AGG hit event
                                     2'b00: Fixed at 0 (AGG always not Match)
                                     2'b01: Fixed at 1 (AGG always Match)
                                     2'b10: A
                                     2'b11: ~A
    RXRATE_HIT[9..8]             - (RW) To control RXRATE hit event
                                     2'b00: Fixed at 0 (RXRATE always not Match)
                                     2'b01: Fixed at 1 (RXRATE always Match)
                                     2'b10: A
                                     2'b11: ~A
    FRMODE_HIT[11..10]           - (RW) To control FRMODE hit event
                                     2'b00: Fixed at 0 (FRMODE always not Match)
                                     2'b01: Fixed at 1 (FRMODE always Match)
                                     2'b10: A
                                     2'b11: ~A
    STBC_HIT[13..12]             - (RW) To control STBC hit event
                                     2'b00: Fixed at 0 (STBC always not Match)
                                     2'b01: Fixed at 1 (STBC always Match)
                                     2'b10: A
                                     2'b11: ~A
    FCSOK_HIT[15..14]            - (RW) To control FCSOK hit event
                                     2'b00: Fixed at 0 (FCSOK always not Match)
                                     2'b01: Fixed at 1 (FCSOK always Match)
                                     2'b10: FCS OK
                                     2'b11: FCS ERROR
    UC2MAC_HIT[17..16]           - (RW) To control UC2MAC hit event
                                     2'b00: Fixed at 0 (UC2MAC always not Match)
                                     2'b01: Fixed at 1 (UC2MAC always Match)
                                     2'b10: A
                                     2'b11: ~A
    PPDU_LEN_LAR_HIT[19..18]     - (RW) To control PPDU LEN larger hit event
                                     2'b00: Fixed at 0 (LEN_LAR always not Match)
                                     2'b01: Fixed at 1 (LEN_LAR always Match)
                                     2'b10: A>CR
                                     2'b11: A<CR
    MPDU_LEN_EQ_HIT[21..20]      - (RW) To control MPDU LEN larger hit event
                                     2'b00: Fixed at 0 (LEN_LAR always not Match)
                                     2'b01: Fixed at 1 (LEN_LAR always Match)
                                     2'b10: A>CR
                                     2'b11: A<CR
    MPDU_LEN_LAR_HIT[23..22]     - (RW) To control MPDU LEN larger hit event
                                     2'b00: Fixed at 0 (LEN_LAR always not Match)
                                     2'b01: Fixed at 1 (LEN_LAR always Match)
                                     2'b10: A>CR
                                     2'b11: A<CR
    AND_OR[24]                   - (RW) For CSD debug used.
                                     0: OR all hit event
                                     1: AND all hit event
    PMCTL0_RSVD[31..25]          - (RW) LIG field matching control. For CSD debug used.
                                     Reserved register

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_PMCTL0_PMCTL0_RSVD_ADDR                BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_PMCTL0_RSVD_MASK                0xFE000000                // PMCTL0_RSVD[31..25]
#define BN0_WF_RMAC_TOP_PMCTL0_PMCTL0_RSVD_SHFT                25
#define BN0_WF_RMAC_TOP_PMCTL0_AND_OR_ADDR                     BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_AND_OR_MASK                     0x01000000                // AND_OR[24]
#define BN0_WF_RMAC_TOP_PMCTL0_AND_OR_SHFT                     24
#define BN0_WF_RMAC_TOP_PMCTL0_MPDU_LEN_LAR_HIT_ADDR           BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_MPDU_LEN_LAR_HIT_MASK           0x00C00000                // MPDU_LEN_LAR_HIT[23..22]
#define BN0_WF_RMAC_TOP_PMCTL0_MPDU_LEN_LAR_HIT_SHFT           22
#define BN0_WF_RMAC_TOP_PMCTL0_MPDU_LEN_EQ_HIT_ADDR            BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_MPDU_LEN_EQ_HIT_MASK            0x00300000                // MPDU_LEN_EQ_HIT[21..20]
#define BN0_WF_RMAC_TOP_PMCTL0_MPDU_LEN_EQ_HIT_SHFT            20
#define BN0_WF_RMAC_TOP_PMCTL0_PPDU_LEN_LAR_HIT_ADDR           BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_PPDU_LEN_LAR_HIT_MASK           0x000C0000                // PPDU_LEN_LAR_HIT[19..18]
#define BN0_WF_RMAC_TOP_PMCTL0_PPDU_LEN_LAR_HIT_SHFT           18
#define BN0_WF_RMAC_TOP_PMCTL0_UC2MAC_HIT_ADDR                 BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_UC2MAC_HIT_MASK                 0x00030000                // UC2MAC_HIT[17..16]
#define BN0_WF_RMAC_TOP_PMCTL0_UC2MAC_HIT_SHFT                 16
#define BN0_WF_RMAC_TOP_PMCTL0_FCSOK_HIT_ADDR                  BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_FCSOK_HIT_MASK                  0x0000C000                // FCSOK_HIT[15..14]
#define BN0_WF_RMAC_TOP_PMCTL0_FCSOK_HIT_SHFT                  14
#define BN0_WF_RMAC_TOP_PMCTL0_STBC_HIT_ADDR                   BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_STBC_HIT_MASK                   0x00003000                // STBC_HIT[13..12]
#define BN0_WF_RMAC_TOP_PMCTL0_STBC_HIT_SHFT                   12
#define BN0_WF_RMAC_TOP_PMCTL0_FRMODE_HIT_ADDR                 BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_FRMODE_HIT_MASK                 0x00000C00                // FRMODE_HIT[11..10]
#define BN0_WF_RMAC_TOP_PMCTL0_FRMODE_HIT_SHFT                 10
#define BN0_WF_RMAC_TOP_PMCTL0_RXRATE_HIT_ADDR                 BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_RXRATE_HIT_MASK                 0x00000300                // RXRATE_HIT[9..8]
#define BN0_WF_RMAC_TOP_PMCTL0_RXRATE_HIT_SHFT                 8
#define BN0_WF_RMAC_TOP_PMCTL0_AGG_HIT_ADDR                    BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_AGG_HIT_MASK                    0x000000C0                // AGG_HIT[7..6]
#define BN0_WF_RMAC_TOP_PMCTL0_AGG_HIT_SHFT                    6
#define BN0_WF_RMAC_TOP_PMCTL0_Mode_HIT_ADDR                   BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_Mode_HIT_MASK                   0x00000030                // Mode_HIT[5..4]
#define BN0_WF_RMAC_TOP_PMCTL0_Mode_HIT_SHFT                   4
#define BN0_WF_RMAC_TOP_PMCTL0_PMCTL0_RSV_ADDR                 BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_PMCTL0_RSV_MASK                 0x0000000C                // PMCTL0_RSV[3..2]
#define BN0_WF_RMAC_TOP_PMCTL0_PMCTL0_RSV_SHFT                 2
#define BN0_WF_RMAC_TOP_PMCTL0_PPDU_LEN_EQ_HIT_ADDR            BN0_WF_RMAC_TOP_PMCTL0_ADDR
#define BN0_WF_RMAC_TOP_PMCTL0_PPDU_LEN_EQ_HIT_MASK            0x00000003                // PPDU_LEN_EQ_HIT[1..0]
#define BN0_WF_RMAC_TOP_PMCTL0_PPDU_LEN_EQ_HIT_SHFT            0

/* =====================================================================================

  ---BTENCR (0x820E5000 + 0x78)---

    BT_COL_OBS_TIME[6..0]        - (RW) Observation times for BT_col from BB. BT_COL_OBS_TIME should be larger than BT_ENV_THRESHOLD.
                                     Note: write this register will reset this function
    RESERVED7[7]                 - (RO) Reserved bits
    BT_ENV_THRESHOLD[14..8]      - (RW) A threshold that is used to decide BT environment exist or not.
    RESERVED15[15]               - (RO) Reserved bits
    BT_env[16]                   - (RC) BT environment exist. While BT_col_cnt is equal or larger than BT_ENV_THRESHOLD, set BT_env to 1. Otherwise BT_env is 0.
                                     Note, BT_col is only valid when packet is OFDM but regardless of UC2MAC/FCS32_OK.
                                     Once BT_ENV is 1, it only could be clear by SW
    RESERVED17[23..17]           - (RO) Reserved bits
    PTYPE_HIT[25..24]            - (RW) To control Stype_type larger hit event
                                     2'b00: Fixed at 0 (STYPE_TYPE always not Match)
                                     2'b01: Fixed at 1 (STYPE_TYPE always Match)
                                     2'b10: A
                                     2'b11: ~A
    PTYPE_COMP[31..26]           - (RW) Frame control field matching control. For debugging
                                     FrameControl. Subtype_Type match

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_BTENCR_PTYPE_COMP_ADDR                 BN0_WF_RMAC_TOP_BTENCR_ADDR
#define BN0_WF_RMAC_TOP_BTENCR_PTYPE_COMP_MASK                 0xFC000000                // PTYPE_COMP[31..26]
#define BN0_WF_RMAC_TOP_BTENCR_PTYPE_COMP_SHFT                 26
#define BN0_WF_RMAC_TOP_BTENCR_PTYPE_HIT_ADDR                  BN0_WF_RMAC_TOP_BTENCR_ADDR
#define BN0_WF_RMAC_TOP_BTENCR_PTYPE_HIT_MASK                  0x03000000                // PTYPE_HIT[25..24]
#define BN0_WF_RMAC_TOP_BTENCR_PTYPE_HIT_SHFT                  24
#define BN0_WF_RMAC_TOP_BTENCR_BT_env_ADDR                     BN0_WF_RMAC_TOP_BTENCR_ADDR
#define BN0_WF_RMAC_TOP_BTENCR_BT_env_MASK                     0x00010000                // BT_env[16]
#define BN0_WF_RMAC_TOP_BTENCR_BT_env_SHFT                     16
#define BN0_WF_RMAC_TOP_BTENCR_BT_ENV_THRESHOLD_ADDR           BN0_WF_RMAC_TOP_BTENCR_ADDR
#define BN0_WF_RMAC_TOP_BTENCR_BT_ENV_THRESHOLD_MASK           0x00007F00                // BT_ENV_THRESHOLD[14..8]
#define BN0_WF_RMAC_TOP_BTENCR_BT_ENV_THRESHOLD_SHFT           8
#define BN0_WF_RMAC_TOP_BTENCR_BT_COL_OBS_TIME_ADDR            BN0_WF_RMAC_TOP_BTENCR_ADDR
#define BN0_WF_RMAC_TOP_BTENCR_BT_COL_OBS_TIME_MASK            0x0000007F                // BT_COL_OBS_TIME[6..0]
#define BN0_WF_RMAC_TOP_BTENCR_BT_COL_OBS_TIME_SHFT            0

/* =====================================================================================

  ---ACCACR (0x820E5000 + 0x7C)---

    ACCA_NUM[2..0]               - (RW) Abnormal CCA observe count. Times for Abnormal CCA indication  trigger count. When ACCA_obs_cnt equals to ACCA_NUM, compare (16 * ACCA_cnt (40/80/160) ) with (ACCA_TH (40/80/160) * ACCA_NUM). If (16 * ACCA_cnt (40/80/160) is larger, than set ACCA_40_BUSY, ACCA_80_BUSY , ACCA_160_BUSY  to be 1, respectively.
                                     Note: write this register with different ACCA_NUM or ACCA_TH will reset this function.
                                     3'b000: 2^7
                                     3'b001: 2^8
                                     3'b010: 2^9
                                     3'b011: 2^10
                                     3'b100: 2^11
                                     3'b101: 2^12
                                     3'b110: 2^13
                                     3'b111: 2^14-1
    RESERVED3[3]                 - (RO) Reserved bits
    ACCA_TH_40[6..4]             - (RW) Abnormal CCA threshold
                                     3'd0: map to 1
                                     3'd1: map to 3
                                     3'd2: map to 5
                                     3'd3: map to 7
                                     3'd4: map to 9
                                     3'd5: map to 11
                                     3'd6: map to 13 
                                     3'd7: map to 16
    RESERVED7[7]                 - (RO) Reserved bits
    ACCA_TH_80[10..8]            - (RW) Abnormal CCA threshold
                                     3'd0: map to 1
                                     3'd1: map to 3
                                     3'd2: map to 5
                                     3'd3: map to 7
                                     3'd4: map to 9
                                     3'd5: map to 11
                                     3'd6: map to 13 
                                     3'd7: map to 16
    RESERVED11[15..11]           - (RO) Reserved bits
    LT_ACCA_40_BUSY[16]          - (RO) Indicate the Abnormal CCA statistic result.
                                     Once LT_ACCA_BUSY is 1, it only could be clear by SW by disable ACCA_FUNCTION_ON
    LT_ACCA_80_BUSY[17]          - (RO) Indicate the Abnormal CCA statistic result.
                                     Once LT_ACCA_BUSY is 1, it only could be clear by SW by disable ACCA_FUNCTION_ON
    RESERVED18[30..18]           - (RO) Reserved bits
    ACCA_FUNCTION_ON[31]         - (RW) Abnormal CCA function enable
                                     0: Disable ACCA function. Disable ACCA function and ACCA_obs_cnt/ACCA_cnt/ ACCA_cnt_80 will be reset to 0.
                                     1: Enable ACCA function. 
                                     
                                     Note, the ACCA_obs_cnt is 32us base counter. During the 32us period, 
                                     Increase ACCA_cnt by 1if phy2mac_cca_sec assert without phy2mac_cca_prim assert
                                     Increase ACCA_cnt_80 by 1 if phy2mac_cca_sec40 assert without phy2mac_cca_prim assert
                                     Increase ACCA_cnt_160 by 1 if phy2mac_cca_sec80 assert without phy2mac_cca_prim assert

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_FUNCTION_ON_ADDR           BN0_WF_RMAC_TOP_ACCACR_ADDR
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_FUNCTION_ON_MASK           0x80000000                // ACCA_FUNCTION_ON[31]
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_FUNCTION_ON_SHFT           31
#define BN0_WF_RMAC_TOP_ACCACR_LT_ACCA_80_BUSY_ADDR            BN0_WF_RMAC_TOP_ACCACR_ADDR
#define BN0_WF_RMAC_TOP_ACCACR_LT_ACCA_80_BUSY_MASK            0x00020000                // LT_ACCA_80_BUSY[17]
#define BN0_WF_RMAC_TOP_ACCACR_LT_ACCA_80_BUSY_SHFT            17
#define BN0_WF_RMAC_TOP_ACCACR_LT_ACCA_40_BUSY_ADDR            BN0_WF_RMAC_TOP_ACCACR_ADDR
#define BN0_WF_RMAC_TOP_ACCACR_LT_ACCA_40_BUSY_MASK            0x00010000                // LT_ACCA_40_BUSY[16]
#define BN0_WF_RMAC_TOP_ACCACR_LT_ACCA_40_BUSY_SHFT            16
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_TH_80_ADDR                 BN0_WF_RMAC_TOP_ACCACR_ADDR
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_TH_80_MASK                 0x00000700                // ACCA_TH_80[10..8]
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_TH_80_SHFT                 8
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_TH_40_ADDR                 BN0_WF_RMAC_TOP_ACCACR_ADDR
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_TH_40_MASK                 0x00000070                // ACCA_TH_40[6..4]
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_TH_40_SHFT                 4
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_NUM_ADDR                   BN0_WF_RMAC_TOP_ACCACR_ADDR
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_NUM_MASK                   0x00000007                // ACCA_NUM[2..0]
#define BN0_WF_RMAC_TOP_ACCACR_ACCA_NUM_SHFT                   0

/* =====================================================================================

  ---TFTACI0 (0x820E5000 + 0x80)---

    TFT_ON[0]                    - (RW) Enable TFT statistic measurement 
                                     0: Disable
                                     1: Enable
    ADC_ON[1]                    - (RW) Enable ACI_LNA statistic measurement
                                     0: Disable
                                     1: Enable
    LNA_ON[2]                    - (RW) Enable LNA statistic measurement
                                     0: Disable
                                     1: Enable
    RX_FILTER_PASS[3]            - (RW) RX packet accumulated control
                                     0: packet pass FCS32 will be accumulated
                                     1: packet pass RX filter will be accumulated
    RESET_CNT[4]                 - (WO) Reset counter
                                     Write 1 to reset TST/ACI related counters for next statistic measurement.
    RESET_ALL[5]                 - (WO) Reset all
                                     Write 1 to reset TST/ACI related counters and results.
    TIMER_DISABLE[6]             - (RW) For FPGA module test only to disable timer
                                     0: timer enable
                                     1: timer disable
    RESERVED7[7]                 - (RO) Reserved bits
    TFT_RESULT[8]                - (RO) TFT result
    RESERVED9[9]                 - (RO) Reserved bits
    ACI_LNA_RESULT[10]           - (RO) ACI LNA result
    LNA_RESULT[13..11]           - (RO) LNA select result
                                     3'b000:NA
                                     3'b001: UL
                                     3'b010: L
                                     3'b100: M
                                     3'b110: H
                                     others: reserved
    RESERVED14[23..14]           - (RO) Reserved bits
    MIN_RSSI_WB[31..24]          - (RW) Minimum RSSI WideBand control
                                     Format is S8.0.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFTACI0_MIN_RSSI_WB_ADDR               BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_MIN_RSSI_WB_MASK               0xFF000000                // MIN_RSSI_WB[31..24]
#define BN0_WF_RMAC_TOP_TFTACI0_MIN_RSSI_WB_SHFT               24
#define BN0_WF_RMAC_TOP_TFTACI0_LNA_RESULT_ADDR                BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_LNA_RESULT_MASK                0x00003800                // LNA_RESULT[13..11]
#define BN0_WF_RMAC_TOP_TFTACI0_LNA_RESULT_SHFT                11
#define BN0_WF_RMAC_TOP_TFTACI0_ACI_LNA_RESULT_ADDR            BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_ACI_LNA_RESULT_MASK            0x00000400                // ACI_LNA_RESULT[10]
#define BN0_WF_RMAC_TOP_TFTACI0_ACI_LNA_RESULT_SHFT            10
#define BN0_WF_RMAC_TOP_TFTACI0_TFT_RESULT_ADDR                BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_TFT_RESULT_MASK                0x00000100                // TFT_RESULT[8]
#define BN0_WF_RMAC_TOP_TFTACI0_TFT_RESULT_SHFT                8
#define BN0_WF_RMAC_TOP_TFTACI0_TIMER_DISABLE_ADDR             BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_TIMER_DISABLE_MASK             0x00000040                // TIMER_DISABLE[6]
#define BN0_WF_RMAC_TOP_TFTACI0_TIMER_DISABLE_SHFT             6
#define BN0_WF_RMAC_TOP_TFTACI0_RESET_ALL_ADDR                 BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_RESET_ALL_MASK                 0x00000020                // RESET_ALL[5]
#define BN0_WF_RMAC_TOP_TFTACI0_RESET_ALL_SHFT                 5
#define BN0_WF_RMAC_TOP_TFTACI0_RESET_CNT_ADDR                 BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_RESET_CNT_MASK                 0x00000010                // RESET_CNT[4]
#define BN0_WF_RMAC_TOP_TFTACI0_RESET_CNT_SHFT                 4
#define BN0_WF_RMAC_TOP_TFTACI0_RX_FILTER_PASS_ADDR            BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_RX_FILTER_PASS_MASK            0x00000008                // RX_FILTER_PASS[3]
#define BN0_WF_RMAC_TOP_TFTACI0_RX_FILTER_PASS_SHFT            3
#define BN0_WF_RMAC_TOP_TFTACI0_LNA_ON_ADDR                    BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_LNA_ON_MASK                    0x00000004                // LNA_ON[2]
#define BN0_WF_RMAC_TOP_TFTACI0_LNA_ON_SHFT                    2
#define BN0_WF_RMAC_TOP_TFTACI0_ADC_ON_ADDR                    BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_ADC_ON_MASK                    0x00000002                // ADC_ON[1]
#define BN0_WF_RMAC_TOP_TFTACI0_ADC_ON_SHFT                    1
#define BN0_WF_RMAC_TOP_TFTACI0_TFT_ON_ADDR                    BN0_WF_RMAC_TOP_TFTACI0_ADDR
#define BN0_WF_RMAC_TOP_TFTACI0_TFT_ON_MASK                    0x00000001                // TFT_ON[0]
#define BN0_WF_RMAC_TOP_TFTACI0_TFT_ON_SHFT                    0

/* =====================================================================================

  ---TFTACI1 (0x820E5000 + 0x84)---

    TFT_THR[1..0]                - (RW) TFT threshold setting
                                     2'b00: 1/2
                                     2'b01: 1/4
                                     2'b10: 1/8
                                     2'b11: 1/16
    RESERVED2[3..2]              - (RO) Reserved bits
    ACI_LNA_THR[5..4]            - (RW) ACI_LNA threshold setting
                                     2'b00: 1/2
                                     2'b01: 1/4
                                     2'b10: 1/8
                                     2'b11: 1/16
    LNA_THR[7..6]                - (RW) LNA threshold setting
                                     2'b00: 1/2
                                     2'b01: 1/4
                                     2'b10: 1/8
                                     2'b11: 1/16
    TOTAL_PKT_NUM[15..8]         - (RW) Time to make decision when CNT_FILTER_PKT==TOTAL_PKT_NUM.
                                     Base on CSD's spec, TOTAL_PKT_NUM should be less or equal than 127, that is the MSB should not set to 1
    TIMEOUT_SEL[17..16]          - (RW) Timeout selection
                                     00: 1.024ms x 50
                                     01: 1.024ms x 100
                                     10: 1.024ms x 250
                                     11: 1.024ms x 500
    RESERVED18[23..18]           - (RO) Reserved bits
    WB_IB_THR[28..24]            - (RW) ACI_LNA=1 if (WB_RSSI-IBRSSI) > WB_IB_THR
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFTACI1_WB_IB_THR_ADDR                 BN0_WF_RMAC_TOP_TFTACI1_ADDR
#define BN0_WF_RMAC_TOP_TFTACI1_WB_IB_THR_MASK                 0x1F000000                // WB_IB_THR[28..24]
#define BN0_WF_RMAC_TOP_TFTACI1_WB_IB_THR_SHFT                 24
#define BN0_WF_RMAC_TOP_TFTACI1_TIMEOUT_SEL_ADDR               BN0_WF_RMAC_TOP_TFTACI1_ADDR
#define BN0_WF_RMAC_TOP_TFTACI1_TIMEOUT_SEL_MASK               0x00030000                // TIMEOUT_SEL[17..16]
#define BN0_WF_RMAC_TOP_TFTACI1_TIMEOUT_SEL_SHFT               16
#define BN0_WF_RMAC_TOP_TFTACI1_TOTAL_PKT_NUM_ADDR             BN0_WF_RMAC_TOP_TFTACI1_ADDR
#define BN0_WF_RMAC_TOP_TFTACI1_TOTAL_PKT_NUM_MASK             0x0000FF00                // TOTAL_PKT_NUM[15..8]
#define BN0_WF_RMAC_TOP_TFTACI1_TOTAL_PKT_NUM_SHFT             8
#define BN0_WF_RMAC_TOP_TFTACI1_LNA_THR_ADDR                   BN0_WF_RMAC_TOP_TFTACI1_ADDR
#define BN0_WF_RMAC_TOP_TFTACI1_LNA_THR_MASK                   0x000000C0                // LNA_THR[7..6]
#define BN0_WF_RMAC_TOP_TFTACI1_LNA_THR_SHFT                   6
#define BN0_WF_RMAC_TOP_TFTACI1_ACI_LNA_THR_ADDR               BN0_WF_RMAC_TOP_TFTACI1_ADDR
#define BN0_WF_RMAC_TOP_TFTACI1_ACI_LNA_THR_MASK               0x00000030                // ACI_LNA_THR[5..4]
#define BN0_WF_RMAC_TOP_TFTACI1_ACI_LNA_THR_SHFT               4
#define BN0_WF_RMAC_TOP_TFTACI1_TFT_THR_ADDR                   BN0_WF_RMAC_TOP_TFTACI1_ADDR
#define BN0_WF_RMAC_TOP_TFTACI1_TFT_THR_MASK                   0x00000003                // TFT_THR[1..0]
#define BN0_WF_RMAC_TOP_TFTACI1_TFT_THR_SHFT                   0

/* =====================================================================================

  ---TFTACI2 (0x820E5000 + 0x88)---

    CNT_FILTER_PKT[7..0]         - (RO) Counter Filter Packet counter statistic
                                     Time to make decision when CNT_FILTER_PKT==TOTAL_PKT_NUM
    TFT_CNT[15..8]               - (RO) TFT counter (drift counter) statistic
                                     For SW check value and debug
    RESERVED16[23..16]           - (RO) Reserved bits
    ACI_LNA_CNT[31..24]          - (RO) ACI LNA counter statistic
                                     For SW check value and debug

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFTACI2_ACI_LNA_CNT_ADDR               BN0_WF_RMAC_TOP_TFTACI2_ADDR
#define BN0_WF_RMAC_TOP_TFTACI2_ACI_LNA_CNT_MASK               0xFF000000                // ACI_LNA_CNT[31..24]
#define BN0_WF_RMAC_TOP_TFTACI2_ACI_LNA_CNT_SHFT               24
#define BN0_WF_RMAC_TOP_TFTACI2_TFT_CNT_ADDR                   BN0_WF_RMAC_TOP_TFTACI2_ADDR
#define BN0_WF_RMAC_TOP_TFTACI2_TFT_CNT_MASK                   0x0000FF00                // TFT_CNT[15..8]
#define BN0_WF_RMAC_TOP_TFTACI2_TFT_CNT_SHFT                   8
#define BN0_WF_RMAC_TOP_TFTACI2_CNT_FILTER_PKT_ADDR            BN0_WF_RMAC_TOP_TFTACI2_ADDR
#define BN0_WF_RMAC_TOP_TFTACI2_CNT_FILTER_PKT_MASK            0x000000FF                // CNT_FILTER_PKT[7..0]
#define BN0_WF_RMAC_TOP_TFTACI2_CNT_FILTER_PKT_SHFT            0

/* =====================================================================================

  ---FTFACI3 (0x820E5000 + 0x8C)---

    LNA_UL_CNT[7..0]             - (RO) LNA UL Counter statistic
                                     For SW check value and debug
    LNA_L_CNT[15..8]             - (RO) LNA L Counter statistic
                                     For SW check value and debug
    LNA_M_CNT[23..16]            - (RO) LNA M Counter statistic
                                     For SW check value and debug
    LNA_H_CNT[31..24]            - (RO) LNA H Counter statistic
                                     For SW check value and debug

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_H_CNT_ADDR                 BN0_WF_RMAC_TOP_FTFACI3_ADDR
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_H_CNT_MASK                 0xFF000000                // LNA_H_CNT[31..24]
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_H_CNT_SHFT                 24
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_M_CNT_ADDR                 BN0_WF_RMAC_TOP_FTFACI3_ADDR
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_M_CNT_MASK                 0x00FF0000                // LNA_M_CNT[23..16]
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_M_CNT_SHFT                 16
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_L_CNT_ADDR                 BN0_WF_RMAC_TOP_FTFACI3_ADDR
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_L_CNT_MASK                 0x0000FF00                // LNA_L_CNT[15..8]
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_L_CNT_SHFT                 8
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_UL_CNT_ADDR                BN0_WF_RMAC_TOP_FTFACI3_ADDR
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_UL_CNT_MASK                0x000000FF                // LNA_UL_CNT[7..0]
#define BN0_WF_RMAC_TOP_FTFACI3_LNA_UL_CNT_SHFT                0

/* =====================================================================================

  ---FTFACI4 (0x820E5000 + 0x90)---

    LNA_ULL_CNT[7..0]            - (RO) LNA ULL Counter statistic
                                     For SW check value and debug
    RESERVED8[31..8]             - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FTFACI4_LNA_ULL_CNT_ADDR               BN0_WF_RMAC_TOP_FTFACI4_ADDR
#define BN0_WF_RMAC_TOP_FTFACI4_LNA_ULL_CNT_MASK               0x000000FF                // LNA_ULL_CNT[7..0]
#define BN0_WF_RMAC_TOP_FTFACI4_LNA_ULL_CNT_SHFT               0

/* =====================================================================================

  ---DBGFX0 (0x820E5000 + 0xA4)---

    BT_OBS_CNT[6..0]             - (RO) BT_OBS_CNT for debug
    BT_COL_CNT[13..7]            - (RO) BT_COL_CNT for debug
    RSV_DBG0[25..14]             - (RO) Reserved
    TMR_MIB_WTDG_CNT[31..26]     - (RO) TMR MAC trigger watchdog event counter

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGFX0_TMR_MIB_WTDG_CNT_ADDR           BN0_WF_RMAC_TOP_DBGFX0_ADDR
#define BN0_WF_RMAC_TOP_DBGFX0_TMR_MIB_WTDG_CNT_MASK           0xFC000000                // TMR_MIB_WTDG_CNT[31..26]
#define BN0_WF_RMAC_TOP_DBGFX0_TMR_MIB_WTDG_CNT_SHFT           26
#define BN0_WF_RMAC_TOP_DBGFX0_RSV_DBG0_ADDR                   BN0_WF_RMAC_TOP_DBGFX0_ADDR
#define BN0_WF_RMAC_TOP_DBGFX0_RSV_DBG0_MASK                   0x03FFC000                // RSV_DBG0[25..14]
#define BN0_WF_RMAC_TOP_DBGFX0_RSV_DBG0_SHFT                   14
#define BN0_WF_RMAC_TOP_DBGFX0_BT_COL_CNT_ADDR                 BN0_WF_RMAC_TOP_DBGFX0_ADDR
#define BN0_WF_RMAC_TOP_DBGFX0_BT_COL_CNT_MASK                 0x00003F80                // BT_COL_CNT[13..7]
#define BN0_WF_RMAC_TOP_DBGFX0_BT_COL_CNT_SHFT                 7
#define BN0_WF_RMAC_TOP_DBGFX0_BT_OBS_CNT_ADDR                 BN0_WF_RMAC_TOP_DBGFX0_ADDR
#define BN0_WF_RMAC_TOP_DBGFX0_BT_OBS_CNT_MASK                 0x0000007F                // BT_OBS_CNT[6..0]
#define BN0_WF_RMAC_TOP_DBGFX0_BT_OBS_CNT_SHFT                 0

/* =====================================================================================

  ---DBGFX1 (0x820E5000 + 0xA8)---

    RSV_DBG1[31..0]              - (RO) Reserved

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGFX1_RSV_DBG1_ADDR                   BN0_WF_RMAC_TOP_DBGFX1_ADDR
#define BN0_WF_RMAC_TOP_DBGFX1_RSV_DBG1_MASK                   0xFFFFFFFF                // RSV_DBG1[31..0]
#define BN0_WF_RMAC_TOP_DBGFX1_RSV_DBG1_SHFT                   0

/* =====================================================================================

  ---DBGFX2 (0x820E5000 + 0xAC)---

    RSV_DBG2[31..0]              - (RO) Reserved

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGFX2_RSV_DBG2_ADDR                   BN0_WF_RMAC_TOP_DBGFX2_ADDR
#define BN0_WF_RMAC_TOP_DBGFX2_RSV_DBG2_MASK                   0xFFFFFFFF                // RSV_DBG2[31..0]
#define BN0_WF_RMAC_TOP_DBGFX2_RSV_DBG2_SHFT                   0

/* =====================================================================================

  ---DBGFX3 (0x820E5000 + 0xB0)---

    FULL_STATE_BITMAP0[31..0]    - (RW) This full-state bitmap0 is used for PSMP mode and used for backup/restore purpose

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGFX3_FULL_STATE_BITMAP0_ADDR         BN0_WF_RMAC_TOP_DBGFX3_ADDR
#define BN0_WF_RMAC_TOP_DBGFX3_FULL_STATE_BITMAP0_MASK         0xFFFFFFFF                // FULL_STATE_BITMAP0[31..0]
#define BN0_WF_RMAC_TOP_DBGFX3_FULL_STATE_BITMAP0_SHFT         0

/* =====================================================================================

  ---DBGFX4 (0x820E5000 + 0xB4)---

    ACCA_OBS_CNT[13..0]          - (RO) ACCA OBS cnt
    ACCA_CNT[27..14]             - (RO) ACCA CNT for debug
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGFX4_ACCA_CNT_ADDR                   BN0_WF_RMAC_TOP_DBGFX4_ADDR
#define BN0_WF_RMAC_TOP_DBGFX4_ACCA_CNT_MASK                   0x0FFFC000                // ACCA_CNT[27..14]
#define BN0_WF_RMAC_TOP_DBGFX4_ACCA_CNT_SHFT                   14
#define BN0_WF_RMAC_TOP_DBGFX4_ACCA_OBS_CNT_ADDR               BN0_WF_RMAC_TOP_DBGFX4_ADDR
#define BN0_WF_RMAC_TOP_DBGFX4_ACCA_OBS_CNT_MASK               0x00003FFF                // ACCA_OBS_CNT[13..0]
#define BN0_WF_RMAC_TOP_DBGFX4_ACCA_OBS_CNT_SHFT               0

/* =====================================================================================

  ---DBGFX5 (0x820E5000 + 0xB8)---

    CCK_PHY_DELAY_B[15..0]       - (RW) This is B value in CCK PHY Delay formula and is US base. B means time difference between phy2mac_mdrdy to TSF field.
                                     Refer to DUT_BB_MAC_interface.doc
                                     The value will be kept after header end and it will be clear when mdrdy falling.
    OFDM_PHY_DELAY_A[31..16]     - (RW) This is A value in OFMD PHY Delay formula and is US base. A means time difference between phy2mac_cca_cs to TSF field.
                                     Refer to DUT_BB_MAC_interface.doc
                                     The value will be kept after header end and it will be clear when mdrdy falling.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGFX5_OFDM_PHY_DELAY_A_ADDR           BN0_WF_RMAC_TOP_DBGFX5_ADDR
#define BN0_WF_RMAC_TOP_DBGFX5_OFDM_PHY_DELAY_A_MASK           0xFFFF0000                // OFDM_PHY_DELAY_A[31..16]
#define BN0_WF_RMAC_TOP_DBGFX5_OFDM_PHY_DELAY_A_SHFT           16
#define BN0_WF_RMAC_TOP_DBGFX5_CCK_PHY_DELAY_B_ADDR            BN0_WF_RMAC_TOP_DBGFX5_ADDR
#define BN0_WF_RMAC_TOP_DBGFX5_CCK_PHY_DELAY_B_MASK            0x0000FFFF                // CCK_PHY_DELAY_B[15..0]
#define BN0_WF_RMAC_TOP_DBGFX5_CCK_PHY_DELAY_B_SHFT            0

/* =====================================================================================

  ---DBGFX6 (0x820E5000 + 0xBC)---

    PHY2MAC_RX_D[31..0]          - (RO) Indicate the PHY2MAC_RX_D signal status

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGFX6_PHY2MAC_RX_D_ADDR               BN0_WF_RMAC_TOP_DBGFX6_ADDR
#define BN0_WF_RMAC_TOP_DBGFX6_PHY2MAC_RX_D_MASK               0xFFFFFFFF                // PHY2MAC_RX_D[31..0]
#define BN0_WF_RMAC_TOP_DBGFX6_PHY2MAC_RX_D_SHFT               0

/* =====================================================================================

  ---DBGFX7 (0x820E5000 + 0xC0)---

    ACC_OBS_CNT[13..0]           - (RO) ACCA_OBS_CNT for debug
    RESERVED14[30..14]           - (RO) Reserved bits
    FULL_STATE_BITMAP1[31]       - (RW) This full-state bitmap1 is used for PSMP mode and for backup/restore purpose

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGFX7_FULL_STATE_BITMAP1_ADDR         BN0_WF_RMAC_TOP_DBGFX7_ADDR
#define BN0_WF_RMAC_TOP_DBGFX7_FULL_STATE_BITMAP1_MASK         0x80000000                // FULL_STATE_BITMAP1[31]
#define BN0_WF_RMAC_TOP_DBGFX7_FULL_STATE_BITMAP1_SHFT         31
#define BN0_WF_RMAC_TOP_DBGFX7_ACC_OBS_CNT_ADDR                BN0_WF_RMAC_TOP_DBGFX7_ADDR
#define BN0_WF_RMAC_TOP_DBGFX7_ACC_OBS_CNT_MASK                0x00003FFF                // ACC_OBS_CNT[13..0]
#define BN0_WF_RMAC_TOP_DBGFX7_ACC_OBS_CNT_SHFT                0

/* =====================================================================================

  ---NAN0 (0x820E5000 + 0xC4)---

    NAN_ADDR2_47_32[15..0]       - (RW) NAN addr2 address
                                     NAN Addr2 47-32
    RESERVED16[19..16]           - (RO) Reserved bits
    NAN_TSF_CHECK_A2[20]         - (RW) NAN beacon TSF check Addr2 or not
                                     0: TSF update will not check Addr2 match or not
                                     1: TSF update will check Addr2 match
    NAN_TSF_COMP_SW[21]          - (RW) Optional for SW mode sync TSF timer.
                                     0: Latch TSF compensation value to SW to read after check NAN beacon FCS ok and no more count.
                                     1: Latch TSF compensation value to SW to read after check NAN beacon FCS ok and continue to count until SW clear this bit. (13-bit max ~8ms delay)
    NAN_BCN_RX_ALL[22]           - (RW) To receive all NAN beacon (Addr3 31-0 equals to NAN addr)
                                     0: Bypass this setting
                                     1: Enable to receive all NAN beacon (NAN_ADDR3 match)
    NAN_TSF_DROP_BCN_SEL[23]     - (RW) Optional for drop NAN beacon or not when violate AMBTT/HOT_CNT.
                                     0: Receive this NAN Beacon if NAN beacon violate AMBTT/HOT_CNT rule
                                     1: Drop this NAN beacon if NAN beacon violate AMBTT/HOT_CNT rule
    NAN_BSSID_SEL[27..24]        - (RW) Should set one-hot to select which BSSID use as NAN network
                                     4'b0001: for BSSID0
                                     4'b0010: for BSSID1
                                     4'b0100: for BSSID2
                                     4'b1000: for BSSID3
    NAN_AMBTT_ORDER_SEL[28]      - (RW) optional to re-order nan_ambtt_content.
                                     0: nan_ambtt_content[31:0]
                                     1: (nan_ambtt_content[7:0], nan_ambtt_content[15:8], nan_ambtt_content[23:16], nan_ambtt_content[31:24])
    NAN_AMBTT_33BIT_SEL[29]      - (RW) NAN beacon AMBTT 33-bit selection
                                     0: use formula violate AMBTT if [local_TSF[31:0] > (NAN_AMBTT_THR+NAN_AMBTT_CONTENT)]
                                     1: use formula violate AMBTT if [local_TSF[32:0] > (NAN_AMBTT_THR+NAN_AMBTT_CONTENT)]
    NAN_FILTER_EN[30]            - (RW) Enable to do NAN beacon filter
                                     0: Disable to drop this NAN beacon if NAN beacon 17-byte content is the same as previous one
                                     1: Enable to drop this NAN beacon if NAN beacon 17-byte content is the same as previous one when NAN_ADDR3 match and NAN_BSSID_SEL match
    NAN_TSF_EN[31]               - (RW) Enable to update TSF of NAN Beacon. 
                                     If NAN beacon with  NAN_BSSID_SEL match and NAN_ADDR2 match and not violate AMBTT/HOP_CNT rule.
                                     0: Disable
                                     1: Enable

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_EN_ADDR                   BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_EN_MASK                   0x80000000                // NAN_TSF_EN[31]
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_EN_SHFT                   31
#define BN0_WF_RMAC_TOP_NAN0_NAN_FILTER_EN_ADDR                BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_FILTER_EN_MASK                0x40000000                // NAN_FILTER_EN[30]
#define BN0_WF_RMAC_TOP_NAN0_NAN_FILTER_EN_SHFT                30
#define BN0_WF_RMAC_TOP_NAN0_NAN_AMBTT_33BIT_SEL_ADDR          BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_AMBTT_33BIT_SEL_MASK          0x20000000                // NAN_AMBTT_33BIT_SEL[29]
#define BN0_WF_RMAC_TOP_NAN0_NAN_AMBTT_33BIT_SEL_SHFT          29
#define BN0_WF_RMAC_TOP_NAN0_NAN_AMBTT_ORDER_SEL_ADDR          BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_AMBTT_ORDER_SEL_MASK          0x10000000                // NAN_AMBTT_ORDER_SEL[28]
#define BN0_WF_RMAC_TOP_NAN0_NAN_AMBTT_ORDER_SEL_SHFT          28
#define BN0_WF_RMAC_TOP_NAN0_NAN_BSSID_SEL_ADDR                BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_BSSID_SEL_MASK                0x0F000000                // NAN_BSSID_SEL[27..24]
#define BN0_WF_RMAC_TOP_NAN0_NAN_BSSID_SEL_SHFT                24
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_DROP_BCN_SEL_ADDR         BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_DROP_BCN_SEL_MASK         0x00800000                // NAN_TSF_DROP_BCN_SEL[23]
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_DROP_BCN_SEL_SHFT         23
#define BN0_WF_RMAC_TOP_NAN0_NAN_BCN_RX_ALL_ADDR               BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_BCN_RX_ALL_MASK               0x00400000                // NAN_BCN_RX_ALL[22]
#define BN0_WF_RMAC_TOP_NAN0_NAN_BCN_RX_ALL_SHFT               22
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_COMP_SW_ADDR              BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_COMP_SW_MASK              0x00200000                // NAN_TSF_COMP_SW[21]
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_COMP_SW_SHFT              21
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_CHECK_A2_ADDR             BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_CHECK_A2_MASK             0x00100000                // NAN_TSF_CHECK_A2[20]
#define BN0_WF_RMAC_TOP_NAN0_NAN_TSF_CHECK_A2_SHFT             20
#define BN0_WF_RMAC_TOP_NAN0_NAN_ADDR2_47_32_ADDR              BN0_WF_RMAC_TOP_NAN0_ADDR
#define BN0_WF_RMAC_TOP_NAN0_NAN_ADDR2_47_32_MASK              0x0000FFFF                // NAN_ADDR2_47_32[15..0]
#define BN0_WF_RMAC_TOP_NAN0_NAN_ADDR2_47_32_SHFT              0

/* =====================================================================================

  ---NAN1 (0x820E5000 + 0xC8)---

    NAN_ADDR2_31_0[31..0]        - (RW) NAN addr2 address
                                     NAN Addr2 31-0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NAN1_NAN_ADDR2_31_0_ADDR               BN0_WF_RMAC_TOP_NAN1_ADDR
#define BN0_WF_RMAC_TOP_NAN1_NAN_ADDR2_31_0_MASK               0xFFFFFFFF                // NAN_ADDR2_31_0[31..0]
#define BN0_WF_RMAC_TOP_NAN1_NAN_ADDR2_31_0_SHFT               0

/* =====================================================================================

  ---NAN2 (0x820E5000 + 0xCC)---

    NAN_AMBTT_THR[23..0]         - (RW) NAN AMBTT thteshold
                                     Setting NAN AMBTT threshold
    NAN_HOP_CNT_THR[31..24]      - (RW) NAN HOP count thershold
                                     Setting for NAN HOP count threshold

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NAN2_NAN_HOP_CNT_THR_ADDR              BN0_WF_RMAC_TOP_NAN2_ADDR
#define BN0_WF_RMAC_TOP_NAN2_NAN_HOP_CNT_THR_MASK              0xFF000000                // NAN_HOP_CNT_THR[31..24]
#define BN0_WF_RMAC_TOP_NAN2_NAN_HOP_CNT_THR_SHFT              24
#define BN0_WF_RMAC_TOP_NAN2_NAN_AMBTT_THR_ADDR                BN0_WF_RMAC_TOP_NAN2_ADDR
#define BN0_WF_RMAC_TOP_NAN2_NAN_AMBTT_THR_MASK                0x00FFFFFF                // NAN_AMBTT_THR[23..0]
#define BN0_WF_RMAC_TOP_NAN2_NAN_AMBTT_THR_SHFT                0

/* =====================================================================================

  ---NAN3 (0x820E5000 + 0xD0)---

    NAN_TSF_COMPENSATION[13..0]  - (RO) NAN TSF for SW
                                     NAN TSF compensation for SW to read
    RESERVED14[31..14]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NAN3_NAN_TSF_COMPENSATION_ADDR         BN0_WF_RMAC_TOP_NAN3_ADDR
#define BN0_WF_RMAC_TOP_NAN3_NAN_TSF_COMPENSATION_MASK         0x00003FFF                // NAN_TSF_COMPENSATION[13..0]
#define BN0_WF_RMAC_TOP_NAN3_NAN_TSF_COMPENSATION_SHFT         0

/* =====================================================================================

  ---NAN4 (0x820E5000 + 0xD4)---

    NAN_OUI[31..0]               - (RW) NAN_OUI for SW to configurable
                                     NAN_OUI for SW to configurable
                                     This setting is used to compare to Beacon IE - OUI value only.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NAN4_NAN_OUI_ADDR                      BN0_WF_RMAC_TOP_NAN4_ADDR
#define BN0_WF_RMAC_TOP_NAN4_NAN_OUI_MASK                      0xFFFFFFFF                // NAN_OUI[31..0]
#define BN0_WF_RMAC_TOP_NAN4_NAN_OUI_SHFT                      0

/* =====================================================================================

  ---NAN5 (0x820E5000 + 0xD8)---

    NAN_ADDR3_31_0[31..0]        - (RW) NAN addr3 address
                                     NAN Addr3 for SW to configurable

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NAN5_NAN_ADDR3_31_0_ADDR               BN0_WF_RMAC_TOP_NAN5_ADDR
#define BN0_WF_RMAC_TOP_NAN5_NAN_ADDR3_31_0_MASK               0xFFFFFFFF                // NAN_ADDR3_31_0[31..0]
#define BN0_WF_RMAC_TOP_NAN5_NAN_ADDR3_31_0_SHFT               0

/* =====================================================================================

  ---NANBR0 (0x820E5000 + 0xDC)---

    NAN_HASH_CONT_31_0[31..0]    - (RW) For Backup/Restore purpose.
                                     Read is NAN beacon 17-byte content 31-0 bit
                                     Write to restore CR

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NANBR0_NAN_HASH_CONT_31_0_ADDR         BN0_WF_RMAC_TOP_NANBR0_ADDR
#define BN0_WF_RMAC_TOP_NANBR0_NAN_HASH_CONT_31_0_MASK         0xFFFFFFFF                // NAN_HASH_CONT_31_0[31..0]
#define BN0_WF_RMAC_TOP_NANBR0_NAN_HASH_CONT_31_0_SHFT         0

/* =====================================================================================

  ---NANBR1 (0x820E5000 + 0xE0)---

    NAN_HASH_CONT_63_32[31..0]   - (RW) For Backup/Restore purpose.
                                     Read is NAN beacon 17-byte content 63-32 bit
                                     Write to restore CR

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NANBR1_NAN_HASH_CONT_63_32_ADDR        BN0_WF_RMAC_TOP_NANBR1_ADDR
#define BN0_WF_RMAC_TOP_NANBR1_NAN_HASH_CONT_63_32_MASK        0xFFFFFFFF                // NAN_HASH_CONT_63_32[31..0]
#define BN0_WF_RMAC_TOP_NANBR1_NAN_HASH_CONT_63_32_SHFT        0

/* =====================================================================================

  ---NANBR2 (0x820E5000 + 0xE4)---

    NAN_HASH_CONT_95_64[31..0]   - (RW) For Backup/Restore purpose.
                                     Read is NAN beacon 17-byte content 95-64 bit
                                     Write to restore CR

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NANBR2_NAN_HASH_CONT_95_64_ADDR        BN0_WF_RMAC_TOP_NANBR2_ADDR
#define BN0_WF_RMAC_TOP_NANBR2_NAN_HASH_CONT_95_64_MASK        0xFFFFFFFF                // NAN_HASH_CONT_95_64[31..0]
#define BN0_WF_RMAC_TOP_NANBR2_NAN_HASH_CONT_95_64_SHFT        0

/* =====================================================================================

  ---NANBR3 (0x820E5000 + 0xE8)---

    NAN_HASH_CONT_127_96[31..0]  - (RW) For Backup/Restore purpose.
                                     Read is NAN beacon 17-byte content 127-96 bit
                                     Write to restore CR

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NANBR3_NAN_HASH_CONT_127_96_ADDR       BN0_WF_RMAC_TOP_NANBR3_ADDR
#define BN0_WF_RMAC_TOP_NANBR3_NAN_HASH_CONT_127_96_MASK       0xFFFFFFFF                // NAN_HASH_CONT_127_96[31..0]
#define BN0_WF_RMAC_TOP_NANBR3_NAN_HASH_CONT_127_96_SHFT       0

/* =====================================================================================

  ---NANBR4 (0x820E5000 + 0xEC)---

    NAN_HASH_CONT_135_128[7..0]  - (RW) For Backup/Restore purpose.
                                     Read is NAN beacon 17-byte content 135-128 bit
                                     Write to restore CR. This should be last write for NANBRx
    RESERVED8[31..8]             - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NANBR4_NAN_HASH_CONT_135_128_ADDR      BN0_WF_RMAC_TOP_NANBR4_ADDR
#define BN0_WF_RMAC_TOP_NANBR4_NAN_HASH_CONT_135_128_MASK      0x000000FF                // NAN_HASH_CONT_135_128[7..0]
#define BN0_WF_RMAC_TOP_NANBR4_NAN_HASH_CONT_135_128_SHFT      0

/* =====================================================================================

  ---OPPOPS (0x820E5000 + 0xF0)---

    OPPOPS_RCPI_TH[7..0]         - (RW) OPPO Power Saving setting
                                     Set RCPI threshold
    RESERVED8[12..8]             - (RO) Reserved bits
    OPPOPS_VHT_NSTS[15..13]      - (RW) OPPO Power Saving setting
                                     0: Sleep when RX VHT packets with this Nsts
                                     1: Active when RX VHT packets with this Nsts
                                     B2: Nsts <= 2
                                     B1: Nsts <= 1
                                     B0: Nsts  = 0
    OPPOPS_VHT_PAID_EN[16]       - (RW) OPPO Power Saving setting
                                     0: Disable SU partial AID check
                                     1: Enable SU partial AID check. 
                                     If SU_PAID matched -> active
                                     If SU_PAID mismatched -> sleep
    OPPOPS_VHT_GID_EN[17]        - (RW) OPPO Power Saving setting
                                     0: Disable GID check
                                     1: Enable Group ID check. 
                                     If GID matched -> active
                                     If GID mismatched -> sleep
    OPPOPS_HT_RATE[19..18]       - (RW) OPPO Power Saving setting
                                     0: Sleep when RX HT packets with this MCS
                                     1: Active when RX HT packets with this MCS
                                     B1: MCS 8~15 (2SS)
                                     B0: MCS 0~7 + MCS 32 (1SS)
    OPPOPS_HT_VHT_LDPC[20]       - (RW) OPPO Power Saving setting
                                     0: Sleep when RX HT/VHT LDPC packets
                                     1: Active when RX HT/VHT LDPC packets
    OPPOPS_HT_VHT_STBC[21]       - (RW) OPPO Power Saving setting
                                     0: Sleep when RX HT/VHT STBC packets
                                     1: Active when RX HT/VHT STBC packets
    OPPOPS_HT_VHT_BW[25..22]     - (RW) OPPO Power Saving setting
                                     0: Sleep when RX HT/VHT packets with this BW
                                     1: Active when RX HT/VHT packets with this BW
                                     B3: BW <= BW160/(80+80)
                                     B2: BW <= BW80
                                     B1: BW <= BW40
                                     B0: BW  = BW20
    OPPOPS_OFDM_RATE[27..26]     - (RW) OPPO Power Saving setting
                                     0: Sleep when RX OFDM packets with this Rate
                                     1: Active when RX OFDM packets with this Rate
                                     B1:   9/18/36/54 Mb/s (Optional)
                                     B0:   6/12/24/48 Mb/s (Mandatory rate + 48 Mb/s)
    OPPOPS_VHT_VLD[28]           - (RW) OPPO Power Saving setting
                                     0: Sleep when RX VHT packets
                                     1: Active when RX VHT packets
    OPPOPS_HT_VLD[29]            - (RW) OPPO Power Saving setting
                                     0: Sleep when RX HT packets
                                     1: Active when RX HT packets
    OPPOPS_CCK_VLD[30]           - (RW) OPPO Power Saving setting
                                     0: Sleep when RX CCK packets
                                     1: Active when RX CCK packets
    OPPOPS_EN[31]                - (RW) OPPO Power Saving enable
                                     0: Disable
                                     1: Enable Opportunistic Power Save

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_EN_ADDR                  BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_EN_MASK                  0x80000000                // OPPOPS_EN[31]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_EN_SHFT                  31
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_CCK_VLD_ADDR             BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_CCK_VLD_MASK             0x40000000                // OPPOPS_CCK_VLD[30]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_CCK_VLD_SHFT             30
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VLD_ADDR              BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VLD_MASK              0x20000000                // OPPOPS_HT_VLD[29]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VLD_SHFT              29
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_VLD_ADDR             BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_VLD_MASK             0x10000000                // OPPOPS_VHT_VLD[28]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_VLD_SHFT             28
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_OFDM_RATE_ADDR           BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_OFDM_RATE_MASK           0x0C000000                // OPPOPS_OFDM_RATE[27..26]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_OFDM_RATE_SHFT           26
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_BW_ADDR           BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_BW_MASK           0x03C00000                // OPPOPS_HT_VHT_BW[25..22]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_BW_SHFT           22
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_STBC_ADDR         BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_STBC_MASK         0x00200000                // OPPOPS_HT_VHT_STBC[21]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_STBC_SHFT         21
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_LDPC_ADDR         BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_LDPC_MASK         0x00100000                // OPPOPS_HT_VHT_LDPC[20]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_VHT_LDPC_SHFT         20
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_RATE_ADDR             BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_RATE_MASK             0x000C0000                // OPPOPS_HT_RATE[19..18]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_HT_RATE_SHFT             18
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_GID_EN_ADDR          BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_GID_EN_MASK          0x00020000                // OPPOPS_VHT_GID_EN[17]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_GID_EN_SHFT          17
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_PAID_EN_ADDR         BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_PAID_EN_MASK         0x00010000                // OPPOPS_VHT_PAID_EN[16]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_PAID_EN_SHFT         16
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_NSTS_ADDR            BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_NSTS_MASK            0x0000E000                // OPPOPS_VHT_NSTS[15..13]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_VHT_NSTS_SHFT            13
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_RCPI_TH_ADDR             BN0_WF_RMAC_TOP_OPPOPS_ADDR
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_RCPI_TH_MASK             0x000000FF                // OPPOPS_RCPI_TH[7..0]
#define BN0_WF_RMAC_TOP_OPPOPS_OPPOPS_RCPI_TH_SHFT             0

/* =====================================================================================

  ---TMR0 (0x820E5000 + 0xF4)---

    TMR_CATEGORY2[15..0]         - (RW) TMR frame check category
                                     Used for TMR[26]=1 to check category_action_field of action field
    TMR_CATEGORY3[31..16]        - (RW) TMR frame check category
                                     Used for TMR[27]=1 to check category_action_field of action field

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TMR0_TMR_CATEGORY3_ADDR                BN0_WF_RMAC_TOP_TMR0_ADDR
#define BN0_WF_RMAC_TOP_TMR0_TMR_CATEGORY3_MASK                0xFFFF0000                // TMR_CATEGORY3[31..16]
#define BN0_WF_RMAC_TOP_TMR0_TMR_CATEGORY3_SHFT                16
#define BN0_WF_RMAC_TOP_TMR0_TMR_CATEGORY2_ADDR                BN0_WF_RMAC_TOP_TMR0_ADDR
#define BN0_WF_RMAC_TOP_TMR0_TMR_CATEGORY2_MASK                0x0000FFFF                // TMR_CATEGORY2[15..0]
#define BN0_WF_RMAC_TOP_TMR0_TMR_CATEGORY2_SHFT                0

/* =====================================================================================

  ---TMR1 (0x820E5000 + 0xF8)---

    TMR_CATEGORY0[15..0]         - (RW) TMR frame check category
                                     Used for TMR[24]=1 to check category_action_field of action field
    TMR_CATEGORY1[31..16]        - (RW) TMR frame check category
                                     Used for TMR[25]=1 to check category_action_field of action field

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TMR1_TMR_CATEGORY1_ADDR                BN0_WF_RMAC_TOP_TMR1_ADDR
#define BN0_WF_RMAC_TOP_TMR1_TMR_CATEGORY1_MASK                0xFFFF0000                // TMR_CATEGORY1[31..16]
#define BN0_WF_RMAC_TOP_TMR1_TMR_CATEGORY1_SHFT                16
#define BN0_WF_RMAC_TOP_TMR1_TMR_CATEGORY0_ADDR                BN0_WF_RMAC_TOP_TMR1_ADDR
#define BN0_WF_RMAC_TOP_TMR1_TMR_CATEGORY0_MASK                0x0000FFFF                // TMR_CATEGORY0[15..0]
#define BN0_WF_RMAC_TOP_TMR1_TMR_CATEGORY0_SHFT                0

/* =====================================================================================

  ---MISC3 (0x820E5000 + 0xFC)---

    DIS_RX_CTRL_CNT_FCS_OK[0]    - (RW) Count Control frame type into FCS OK MIB counter or not
                                     0 : If Rx a FCS OK MPDU with TYPE = Control, increment the MIB FCS OK count.
                                     1 : If Rx a FCS OK MPDU with TYPE = Control, DON'T increment the MIB FCS OK count.
    DIS_RX_MGMT_CNT_FCS_OK[1]    - (RW) Count Management frame type into FCS OK MIB counter or not
                                     0 : If Rx a FCS OK MPDU with TYPE = Management, increment the MIB FCS OK count.
                                     1 : If Rx a FCS OK MPDU with TYPE = Management, DON'T increment the MIB FCS OK count.
    DIS_RX_DATA_CNT_FCS_OK[2]    - (RW) Count Data frame type into FCS OK MIB counter or not
                                     0 : If Rx a FCS OK MPDU with TYPE = Data increment the MIB FCS OK count.
                                     1 : If Rx a FCS OK MPDU with TYPE = Data, DON'T increment the MIB FCS OK count.
    RXVEC1_SET_WIDX_EN[3]        - (RW) Rx Vector 1 Set Addr Index Control
                                     0 : Don't update the RxVector 1 Addr Index while Vector 1 Started.
                                     1 : Update the RxVector1 Addr Index while RxVector1 Started.
    RST_V1IDX_IF_NO_WAIT_RSP[4]  - (RW) Rx Vector 1 Addr Index Reset Control (Only active if RXVEC1_SET_WIDX_EN = 1)
                                     0 : Always use AGG previded Index as RxVector 1 Addr Index.
                                     1 : If TMAC is not wating for a response packet, reset the RxVector 1 Addr Index to 0xFF.
    RX_HOLD_FOR_BCN_BTIM_CHK[5]  - (RW) Hold Rx MAC-PHY ACK for Beacon/TIM Broadcast check. (Used for parsing high rate Beacon/TIM Broadcast)
                                     0 : Don't hold the rxd_ack for any Rx packets.
                                     1 : Hold the rxd_ack each PPDU to meet Beacon parser 4T timing until : 
                                       a. Rx packet is A-MPDU
                                       b. Rx packet is less than 32 byte.
                                       c. Rx packet is not My BSSID's Beacon/TIM Broadcast
    NDPA_UC_AID_MATCH_EN[6]      - (RW) Check for unicasted VHT NDPA's AID match
                                     0 : If the VHT NDPA is unicasted to me. Don't check the STA_INFO.AID and directly latch the STA_INFO.
                                     1 : If the VHT NDPA is unicasted to me. Still need to check the STA_INFO.AID.
    CTS_RESP_TXHOLDER_EN[7]      - (RW) Respond CTS when receive TXOP holder's RTS even when NAV is not zero.
                                     0 : When Rx RTS and NAV is not zero, don't respond CTS.
                                     1 : When Rx RTS and NAV is not zero, if the source is TXOP holder, respond CTS.
    VLD_DLMT_MPDULEN[14..8]      - (RW) Required MPDU Byte length for delimiter sub-field parsing. 
                                     Valid when VLD_DLMT_MPDULEN_EN = 1.
    VLD_DLMT_MPDULEN_EN[15]      - (RW) De-aggregate A-MPDU for reasonable delimiter's MPDU length.
                                     0 : Validate MPDU if the delimiter CRC is pass. Don't check the MPDU length.
                                     1 : Validate MPDU if delimiter CRC and the MPDU length sub-filed is greater than VLD_DLMT_MPDULEN. 
                                     Otherwise, treat as demiliter mismatch.
    TMR_PHY_ABORT_TOD_EN[16]     - (RW) TMR TOD calculation can be terminated by PHY tmr_abort signal.
                                     0 : PHY tmr_abort only terminate TOA calculation but won't terminate TOD calculation.
                                     1 : PHY tmr terminate TOA and TOD calculation.
    RCPI_CMP_SEL_MAX_EN[17]      - (RW) RCPI selection option for RCPI_THR_DROP filter.
                                     0 : Use RxV.RCPI ant0 for comparision.
                                     1 : Use max RCPI in the RxV for comparison
    A3_PAT_TRI_EN[18]            - (RW) DAWN Rx Addr3 comparison enable.
                                     0 : Disable 
                                     1 : Enable Rx Data frame Addr3 comparison with SCONN_DA_COMP_PAT(default compare bit[23:0]), if match and the WLAN IDX is within A3_PAT_CMP_WIDX_OFST to A3_PAT_CMP_WIDX_OFST + 15, trigger interrupt and set corresponding WLAN Index bitmap in RICMRx CR.
    A3_PAT_CMP_B47_24_EN[19]     - (RW) DAWN Rx Addr3 comparison enable. Only valid when A3_PAT_TRI_EN = 1.
                                     0 : Don't compare Addr3 [47:24]
                                     1 : Compare addr3[47:0]  with pattern {A3_COMP_PAT_b47_24, SCONN_DA_COMP_PAT}
    A3_PAT_CMP_WIDX_OFST[27..20] - (RW) The WTBL offset of continuous 16 entries to perform Trigger detection
                                     Note: valid range is from 0 to [Max number of WTBL - 16]
                                     For configuring starting WLAN index to compare Rx Addr3. Only the WLAN index which is >= A3_PAT_CMP_WIDX_OFST and <= (A3_PAT_CMP_WIDX_OFST+15) would trigger interrupt.
    RESERVED28[29..28]           - (RO) Reserved bits
    BSSID_FOR_UNWANTRD[30]       - (RW) BDDIS enable for unwanted packet
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MISC3_BSSID_FOR_UNWANTRD_ADDR          BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_BSSID_FOR_UNWANTRD_MASK          0x40000000                // BSSID_FOR_UNWANTRD[30]
#define BN0_WF_RMAC_TOP_MISC3_BSSID_FOR_UNWANTRD_SHFT          30
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_CMP_WIDX_OFST_ADDR        BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_CMP_WIDX_OFST_MASK        0x0FF00000                // A3_PAT_CMP_WIDX_OFST[27..20]
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_CMP_WIDX_OFST_SHFT        20
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_CMP_B47_24_EN_ADDR        BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_CMP_B47_24_EN_MASK        0x00080000                // A3_PAT_CMP_B47_24_EN[19]
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_CMP_B47_24_EN_SHFT        19
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_TRI_EN_ADDR               BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_TRI_EN_MASK               0x00040000                // A3_PAT_TRI_EN[18]
#define BN0_WF_RMAC_TOP_MISC3_A3_PAT_TRI_EN_SHFT               18
#define BN0_WF_RMAC_TOP_MISC3_RCPI_CMP_SEL_MAX_EN_ADDR         BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_RCPI_CMP_SEL_MAX_EN_MASK         0x00020000                // RCPI_CMP_SEL_MAX_EN[17]
#define BN0_WF_RMAC_TOP_MISC3_RCPI_CMP_SEL_MAX_EN_SHFT         17
#define BN0_WF_RMAC_TOP_MISC3_TMR_PHY_ABORT_TOD_EN_ADDR        BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_TMR_PHY_ABORT_TOD_EN_MASK        0x00010000                // TMR_PHY_ABORT_TOD_EN[16]
#define BN0_WF_RMAC_TOP_MISC3_TMR_PHY_ABORT_TOD_EN_SHFT        16
#define BN0_WF_RMAC_TOP_MISC3_VLD_DLMT_MPDULEN_EN_ADDR         BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_VLD_DLMT_MPDULEN_EN_MASK         0x00008000                // VLD_DLMT_MPDULEN_EN[15]
#define BN0_WF_RMAC_TOP_MISC3_VLD_DLMT_MPDULEN_EN_SHFT         15
#define BN0_WF_RMAC_TOP_MISC3_VLD_DLMT_MPDULEN_ADDR            BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_VLD_DLMT_MPDULEN_MASK            0x00007F00                // VLD_DLMT_MPDULEN[14..8]
#define BN0_WF_RMAC_TOP_MISC3_VLD_DLMT_MPDULEN_SHFT            8
#define BN0_WF_RMAC_TOP_MISC3_CTS_RESP_TXHOLDER_EN_ADDR        BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_CTS_RESP_TXHOLDER_EN_MASK        0x00000080                // CTS_RESP_TXHOLDER_EN[7]
#define BN0_WF_RMAC_TOP_MISC3_CTS_RESP_TXHOLDER_EN_SHFT        7
#define BN0_WF_RMAC_TOP_MISC3_NDPA_UC_AID_MATCH_EN_ADDR        BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_NDPA_UC_AID_MATCH_EN_MASK        0x00000040                // NDPA_UC_AID_MATCH_EN[6]
#define BN0_WF_RMAC_TOP_MISC3_NDPA_UC_AID_MATCH_EN_SHFT        6
#define BN0_WF_RMAC_TOP_MISC3_RX_HOLD_FOR_BCN_BTIM_CHK_ADDR    BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_RX_HOLD_FOR_BCN_BTIM_CHK_MASK    0x00000020                // RX_HOLD_FOR_BCN_BTIM_CHK[5]
#define BN0_WF_RMAC_TOP_MISC3_RX_HOLD_FOR_BCN_BTIM_CHK_SHFT    5
#define BN0_WF_RMAC_TOP_MISC3_RST_V1IDX_IF_NO_WAIT_RSP_ADDR    BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_RST_V1IDX_IF_NO_WAIT_RSP_MASK    0x00000010                // RST_V1IDX_IF_NO_WAIT_RSP[4]
#define BN0_WF_RMAC_TOP_MISC3_RST_V1IDX_IF_NO_WAIT_RSP_SHFT    4
#define BN0_WF_RMAC_TOP_MISC3_RXVEC1_SET_WIDX_EN_ADDR          BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_RXVEC1_SET_WIDX_EN_MASK          0x00000008                // RXVEC1_SET_WIDX_EN[3]
#define BN0_WF_RMAC_TOP_MISC3_RXVEC1_SET_WIDX_EN_SHFT          3
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_DATA_CNT_FCS_OK_ADDR      BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_DATA_CNT_FCS_OK_MASK      0x00000004                // DIS_RX_DATA_CNT_FCS_OK[2]
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_DATA_CNT_FCS_OK_SHFT      2
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_MGMT_CNT_FCS_OK_ADDR      BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_MGMT_CNT_FCS_OK_MASK      0x00000002                // DIS_RX_MGMT_CNT_FCS_OK[1]
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_MGMT_CNT_FCS_OK_SHFT      1
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_CTRL_CNT_FCS_OK_ADDR      BN0_WF_RMAC_TOP_MISC3_ADDR
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_CTRL_CNT_FCS_OK_MASK      0x00000001                // DIS_RX_CTRL_CNT_FCS_OK[0]
#define BN0_WF_RMAC_TOP_MISC3_DIS_RX_CTRL_CNT_FCS_OK_SHFT      0

/* =====================================================================================

  ---CB0R0 (0x820E5000 + 0x200)---

    CURRENTBSSID0_31_0[31..0]    - (RW) Current BSSID0 bits 31~0
                                     BSSID0 will extend another 15-BSSID with enable bit in ACBEN. BSSID0-15 will be OWN MAC address when infra-AP mode for rx filtering.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CB0R0_CURRENTBSSID0_31_0_ADDR          BN0_WF_RMAC_TOP_CB0R0_ADDR
#define BN0_WF_RMAC_TOP_CB0R0_CURRENTBSSID0_31_0_MASK          0xFFFFFFFF                // CURRENTBSSID0_31_0[31..0]
#define BN0_WF_RMAC_TOP_CB0R0_CURRENTBSSID0_31_0_SHFT          0

/* =====================================================================================

  ---CB0R1 (0x820E5000 + 0x204)---

    CURRENTBSSID0_47_32[15..0]   - (RW) Current BSSID0 bits 47~32
    CURRENTBSSID0_EN[16]         - (RW) Current BSSID0 enable. 
                                     0: Disable this BSSID
                                     1: Enable this BSSID
                                     Note: Do not enable ACBEN[0] and CB0R1[16] at the same time
    CURRENTBSSCOLOR0_EN[17]      - (RW) Current BSSID COLOR enable. 
                                     0: Disable this BSSID Color
                                     1: Enable this BSSID Color
    CURRENTBSSCOLOR0[23..18]     - (RW) Current BSSID COLOR
    MBSSID0_MASK_BITS[26..24]    - (RW) Multiple BSSID addr mask bits for MBSSID comparison.
                                     0: mask bit 0 (2-set MBSS)
                                     1: mask bit 0~1 (4-set MBSS)
                                     2: mask bit 0~2 (8-set MBSS)
                                     etc
    MBSSID0_EN[27]               - (RW) Multiple BSSID is enabled for this BSSID
    PBSSCOLOR_EN[28]             - (RW) Partial BSS color enable
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CB0R1_PBSSCOLOR_EN_ADDR                BN0_WF_RMAC_TOP_CB0R1_ADDR
#define BN0_WF_RMAC_TOP_CB0R1_PBSSCOLOR_EN_MASK                0x10000000                // PBSSCOLOR_EN[28]
#define BN0_WF_RMAC_TOP_CB0R1_PBSSCOLOR_EN_SHFT                28
#define BN0_WF_RMAC_TOP_CB0R1_MBSSID0_EN_ADDR                  BN0_WF_RMAC_TOP_CB0R1_ADDR
#define BN0_WF_RMAC_TOP_CB0R1_MBSSID0_EN_MASK                  0x08000000                // MBSSID0_EN[27]
#define BN0_WF_RMAC_TOP_CB0R1_MBSSID0_EN_SHFT                  27
#define BN0_WF_RMAC_TOP_CB0R1_MBSSID0_MASK_BITS_ADDR           BN0_WF_RMAC_TOP_CB0R1_ADDR
#define BN0_WF_RMAC_TOP_CB0R1_MBSSID0_MASK_BITS_MASK           0x07000000                // MBSSID0_MASK_BITS[26..24]
#define BN0_WF_RMAC_TOP_CB0R1_MBSSID0_MASK_BITS_SHFT           24
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSCOLOR0_ADDR            BN0_WF_RMAC_TOP_CB0R1_ADDR
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSCOLOR0_MASK            0x00FC0000                // CURRENTBSSCOLOR0[23..18]
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSCOLOR0_SHFT            18
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSCOLOR0_EN_ADDR         BN0_WF_RMAC_TOP_CB0R1_ADDR
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSCOLOR0_EN_MASK         0x00020000                // CURRENTBSSCOLOR0_EN[17]
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSCOLOR0_EN_SHFT         17
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSID0_EN_ADDR            BN0_WF_RMAC_TOP_CB0R1_ADDR
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSID0_EN_MASK            0x00010000                // CURRENTBSSID0_EN[16]
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSID0_EN_SHFT            16
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSID0_47_32_ADDR         BN0_WF_RMAC_TOP_CB0R1_ADDR
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSID0_47_32_MASK         0x0000FFFF                // CURRENTBSSID0_47_32[15..0]
#define BN0_WF_RMAC_TOP_CB0R1_CURRENTBSSID0_47_32_SHFT         0

/* =====================================================================================

  ---CB1R0 (0x820E5000 + 0x208)---

    CURRENTBSSID1_31_0[31..0]    - (RW) Current BSSID1 bits 31~0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CB1R0_CURRENTBSSID1_31_0_ADDR          BN0_WF_RMAC_TOP_CB1R0_ADDR
#define BN0_WF_RMAC_TOP_CB1R0_CURRENTBSSID1_31_0_MASK          0xFFFFFFFF                // CURRENTBSSID1_31_0[31..0]
#define BN0_WF_RMAC_TOP_CB1R0_CURRENTBSSID1_31_0_SHFT          0

/* =====================================================================================

  ---CB1R1 (0x820E5000 + 0x20C)---

    CURRENTBSSID1_47_32[15..0]   - (RW) Current BSSID1 bits 47~32
    CURRENTBSSID1_EN[16]         - (RW) Current BSSID1 enable
                                     0: Disable this BSSID
                                     1: Enable this BSSID
    CURRENTBSSCOLOR1_EN[17]      - (RW) Current BSSID COLOR enable. 
                                     0: Disable this BSSID Color
                                     1: Enable this BSSID Color
    CURRENTBSSCOLOR1[23..18]     - (RW) Current BSSID COLOR
    MBSSID1_MASK_BITS[26..24]    - (RW) Multiple BSSID addr mask bits for MBSSID comparison.
    MBSSID1_EN[27]               - (RW) Multiple BSSID is enabled for this BSSID
    PBSSCOLOR_EN[28]             - (RW) Partial BSS color enable
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CB1R1_PBSSCOLOR_EN_ADDR                BN0_WF_RMAC_TOP_CB1R1_ADDR
#define BN0_WF_RMAC_TOP_CB1R1_PBSSCOLOR_EN_MASK                0x10000000                // PBSSCOLOR_EN[28]
#define BN0_WF_RMAC_TOP_CB1R1_PBSSCOLOR_EN_SHFT                28
#define BN0_WF_RMAC_TOP_CB1R1_MBSSID1_EN_ADDR                  BN0_WF_RMAC_TOP_CB1R1_ADDR
#define BN0_WF_RMAC_TOP_CB1R1_MBSSID1_EN_MASK                  0x08000000                // MBSSID1_EN[27]
#define BN0_WF_RMAC_TOP_CB1R1_MBSSID1_EN_SHFT                  27
#define BN0_WF_RMAC_TOP_CB1R1_MBSSID1_MASK_BITS_ADDR           BN0_WF_RMAC_TOP_CB1R1_ADDR
#define BN0_WF_RMAC_TOP_CB1R1_MBSSID1_MASK_BITS_MASK           0x07000000                // MBSSID1_MASK_BITS[26..24]
#define BN0_WF_RMAC_TOP_CB1R1_MBSSID1_MASK_BITS_SHFT           24
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSCOLOR1_ADDR            BN0_WF_RMAC_TOP_CB1R1_ADDR
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSCOLOR1_MASK            0x00FC0000                // CURRENTBSSCOLOR1[23..18]
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSCOLOR1_SHFT            18
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSCOLOR1_EN_ADDR         BN0_WF_RMAC_TOP_CB1R1_ADDR
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSCOLOR1_EN_MASK         0x00020000                // CURRENTBSSCOLOR1_EN[17]
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSCOLOR1_EN_SHFT         17
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSID1_EN_ADDR            BN0_WF_RMAC_TOP_CB1R1_ADDR
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSID1_EN_MASK            0x00010000                // CURRENTBSSID1_EN[16]
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSID1_EN_SHFT            16
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSID1_47_32_ADDR         BN0_WF_RMAC_TOP_CB1R1_ADDR
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSID1_47_32_MASK         0x0000FFFF                // CURRENTBSSID1_47_32[15..0]
#define BN0_WF_RMAC_TOP_CB1R1_CURRENTBSSID1_47_32_SHFT         0

/* =====================================================================================

  ---CB2R0 (0x820E5000 + 0x210)---

    CURRENTBSSID2_31_0[31..0]    - (RW) Current BSSID2 bits 31~0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CB2R0_CURRENTBSSID2_31_0_ADDR          BN0_WF_RMAC_TOP_CB2R0_ADDR
#define BN0_WF_RMAC_TOP_CB2R0_CURRENTBSSID2_31_0_MASK          0xFFFFFFFF                // CURRENTBSSID2_31_0[31..0]
#define BN0_WF_RMAC_TOP_CB2R0_CURRENTBSSID2_31_0_SHFT          0

/* =====================================================================================

  ---CB2R1 (0x820E5000 + 0x214)---

    CURRENTBSSID2_47_32[15..0]   - (RW) Current BSSID2 bits 47~32
    CURRENTBSSID2_EN[16]         - (RW) Current BSSID2 enable
                                     0: Disable this BSSID
                                     1: Enable this BSSID
    CURRENTBSSCOLOR2_EN[17]      - (RW) Current BSSID COLOR enable. 
                                     0: Disable this BSSID Color
                                     1: Enable this BSSID Color
    CURRENTBSSCOLOR2[23..18]     - (RW) Current BSSID COLOR
    MBSSID2_MASK_BITS[26..24]    - (RW) Multiple BSSID addr mask bits for MBSSID comparison.
    MBSSID2_EN[27]               - (RW) Multiple BSSID is enabled for this BSSID
    PBSSCOLOR_EN[28]             - (RW) Partial BSS color enable
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CB2R1_PBSSCOLOR_EN_ADDR                BN0_WF_RMAC_TOP_CB2R1_ADDR
#define BN0_WF_RMAC_TOP_CB2R1_PBSSCOLOR_EN_MASK                0x10000000                // PBSSCOLOR_EN[28]
#define BN0_WF_RMAC_TOP_CB2R1_PBSSCOLOR_EN_SHFT                28
#define BN0_WF_RMAC_TOP_CB2R1_MBSSID2_EN_ADDR                  BN0_WF_RMAC_TOP_CB2R1_ADDR
#define BN0_WF_RMAC_TOP_CB2R1_MBSSID2_EN_MASK                  0x08000000                // MBSSID2_EN[27]
#define BN0_WF_RMAC_TOP_CB2R1_MBSSID2_EN_SHFT                  27
#define BN0_WF_RMAC_TOP_CB2R1_MBSSID2_MASK_BITS_ADDR           BN0_WF_RMAC_TOP_CB2R1_ADDR
#define BN0_WF_RMAC_TOP_CB2R1_MBSSID2_MASK_BITS_MASK           0x07000000                // MBSSID2_MASK_BITS[26..24]
#define BN0_WF_RMAC_TOP_CB2R1_MBSSID2_MASK_BITS_SHFT           24
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSCOLOR2_ADDR            BN0_WF_RMAC_TOP_CB2R1_ADDR
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSCOLOR2_MASK            0x00FC0000                // CURRENTBSSCOLOR2[23..18]
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSCOLOR2_SHFT            18
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSCOLOR2_EN_ADDR         BN0_WF_RMAC_TOP_CB2R1_ADDR
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSCOLOR2_EN_MASK         0x00020000                // CURRENTBSSCOLOR2_EN[17]
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSCOLOR2_EN_SHFT         17
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSID2_EN_ADDR            BN0_WF_RMAC_TOP_CB2R1_ADDR
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSID2_EN_MASK            0x00010000                // CURRENTBSSID2_EN[16]
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSID2_EN_SHFT            16
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSID2_47_32_ADDR         BN0_WF_RMAC_TOP_CB2R1_ADDR
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSID2_47_32_MASK         0x0000FFFF                // CURRENTBSSID2_47_32[15..0]
#define BN0_WF_RMAC_TOP_CB2R1_CURRENTBSSID2_47_32_SHFT         0

/* =====================================================================================

  ---CB3R0 (0x820E5000 + 0x218)---

    CURRENTBSSID3_31_0[31..0]    - (RW) Current BSSID3 bits 31~0
                                     Note: Not valid in MT7603/MT7628

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CB3R0_CURRENTBSSID3_31_0_ADDR          BN0_WF_RMAC_TOP_CB3R0_ADDR
#define BN0_WF_RMAC_TOP_CB3R0_CURRENTBSSID3_31_0_MASK          0xFFFFFFFF                // CURRENTBSSID3_31_0[31..0]
#define BN0_WF_RMAC_TOP_CB3R0_CURRENTBSSID3_31_0_SHFT          0

/* =====================================================================================

  ---CB3R1 (0x820E5000 + 0x21C)---

    CURRENTBSSID3_47_32[15..0]   - (RW) Current BSSID3 bits 47~32
    CURRENTBSSID3_EN[16]         - (RW) Current BSSID3 enable
                                     0: Disable this BSSID
                                     1: Enable this BSSID
                                     Note: Not valid in MT7603/MT7628
    CURRENTBSSCOLOR3_EN[17]      - (RW) Current BSSID COLOR enable. 
                                     0: Disable this BSSID Color
                                     1: Enable this BSSID Color
    CURRENTBSSCOLOR3[23..18]     - (RW) Current BSSID COLOR
    MBSSID3_MASK_BITS[26..24]    - (RW) Multiple BSSID addr mask bits for MBSSID comparison.
    MBSSID3_EN[27]               - (RW) Multiple BSSID is enabled for this BSSID
    PBSSCOLOR_EN[28]             - (RW) Partial BSS color enable
    RESERVED29[31..29]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CB3R1_PBSSCOLOR_EN_ADDR                BN0_WF_RMAC_TOP_CB3R1_ADDR
#define BN0_WF_RMAC_TOP_CB3R1_PBSSCOLOR_EN_MASK                0x10000000                // PBSSCOLOR_EN[28]
#define BN0_WF_RMAC_TOP_CB3R1_PBSSCOLOR_EN_SHFT                28
#define BN0_WF_RMAC_TOP_CB3R1_MBSSID3_EN_ADDR                  BN0_WF_RMAC_TOP_CB3R1_ADDR
#define BN0_WF_RMAC_TOP_CB3R1_MBSSID3_EN_MASK                  0x08000000                // MBSSID3_EN[27]
#define BN0_WF_RMAC_TOP_CB3R1_MBSSID3_EN_SHFT                  27
#define BN0_WF_RMAC_TOP_CB3R1_MBSSID3_MASK_BITS_ADDR           BN0_WF_RMAC_TOP_CB3R1_ADDR
#define BN0_WF_RMAC_TOP_CB3R1_MBSSID3_MASK_BITS_MASK           0x07000000                // MBSSID3_MASK_BITS[26..24]
#define BN0_WF_RMAC_TOP_CB3R1_MBSSID3_MASK_BITS_SHFT           24
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSCOLOR3_ADDR            BN0_WF_RMAC_TOP_CB3R1_ADDR
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSCOLOR3_MASK            0x00FC0000                // CURRENTBSSCOLOR3[23..18]
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSCOLOR3_SHFT            18
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSCOLOR3_EN_ADDR         BN0_WF_RMAC_TOP_CB3R1_ADDR
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSCOLOR3_EN_MASK         0x00020000                // CURRENTBSSCOLOR3_EN[17]
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSCOLOR3_EN_SHFT         17
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSID3_EN_ADDR            BN0_WF_RMAC_TOP_CB3R1_ADDR
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSID3_EN_MASK            0x00010000                // CURRENTBSSID3_EN[16]
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSID3_EN_SHFT            16
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSID3_47_32_ADDR         BN0_WF_RMAC_TOP_CB3R1_ADDR
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSID3_47_32_MASK         0x0000FFFF                // CURRENTBSSID3_47_32[15..0]
#define BN0_WF_RMAC_TOP_CB3R1_CURRENTBSSID3_47_32_SHFT         0

/* =====================================================================================

  ---OMA0R0 (0x820E5000 + 0x220)---

    OWNMACADDR0_31_0[31..0]      - (RW) OWN MAC address 0 bits 31~0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA0R0_OWNMACADDR0_31_0_ADDR           BN0_WF_RMAC_TOP_OMA0R0_ADDR
#define BN0_WF_RMAC_TOP_OMA0R0_OWNMACADDR0_31_0_MASK           0xFFFFFFFF                // OWNMACADDR0_31_0[31..0]
#define BN0_WF_RMAC_TOP_OMA0R0_OWNMACADDR0_31_0_SHFT           0

/* =====================================================================================

  ---OMA0R1 (0x820E5000 + 0x224)---

    OWNMACADDR0_47_32[15..0]     - (RW) OWN MAC address 0 bits 47~32
    OWNMACADDR0_EN[16]           - (RW) OWN MAC address 0 enable
                                     0: Disable this OWN MAC
                                     1: Enable this OWN MAC
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA0R1_OWNMACADDR0_EN_ADDR             BN0_WF_RMAC_TOP_OMA0R1_ADDR
#define BN0_WF_RMAC_TOP_OMA0R1_OWNMACADDR0_EN_MASK             0x00010000                // OWNMACADDR0_EN[16]
#define BN0_WF_RMAC_TOP_OMA0R1_OWNMACADDR0_EN_SHFT             16
#define BN0_WF_RMAC_TOP_OMA0R1_OWNMACADDR0_47_32_ADDR          BN0_WF_RMAC_TOP_OMA0R1_ADDR
#define BN0_WF_RMAC_TOP_OMA0R1_OWNMACADDR0_47_32_MASK          0x0000FFFF                // OWNMACADDR0_47_32[15..0]
#define BN0_WF_RMAC_TOP_OMA0R1_OWNMACADDR0_47_32_SHFT          0

/* =====================================================================================

  ---OMA1R0 (0x820E5000 + 0x228)---

    OWNMACADDR1_31_0[31..0]      - (RW) OWN MAC address 1 bits 31~0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA1R0_OWNMACADDR1_31_0_ADDR           BN0_WF_RMAC_TOP_OMA1R0_ADDR
#define BN0_WF_RMAC_TOP_OMA1R0_OWNMACADDR1_31_0_MASK           0xFFFFFFFF                // OWNMACADDR1_31_0[31..0]
#define BN0_WF_RMAC_TOP_OMA1R0_OWNMACADDR1_31_0_SHFT           0

/* =====================================================================================

  ---OMA1R1 (0x820E5000 + 0x22C)---

    OWNMACADDR1_47_32[15..0]     - (RW) OWN MAC address 1 bits 47~32
    OWNMACADDR1_EN[16]           - (RW) OWN MAC address 1 enable
                                     0: Disable this OWN MAC
                                     1: Enable this OWN MAC
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA1R1_OWNMACADDR1_EN_ADDR             BN0_WF_RMAC_TOP_OMA1R1_ADDR
#define BN0_WF_RMAC_TOP_OMA1R1_OWNMACADDR1_EN_MASK             0x00010000                // OWNMACADDR1_EN[16]
#define BN0_WF_RMAC_TOP_OMA1R1_OWNMACADDR1_EN_SHFT             16
#define BN0_WF_RMAC_TOP_OMA1R1_OWNMACADDR1_47_32_ADDR          BN0_WF_RMAC_TOP_OMA1R1_ADDR
#define BN0_WF_RMAC_TOP_OMA1R1_OWNMACADDR1_47_32_MASK          0x0000FFFF                // OWNMACADDR1_47_32[15..0]
#define BN0_WF_RMAC_TOP_OMA1R1_OWNMACADDR1_47_32_SHFT          0

/* =====================================================================================

  ---OMA2R0 (0x820E5000 + 0x230)---

    OWNMACADDR2_31_0[31..0]      - (RW) OWN MAC address 2 bits 31~0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA2R0_OWNMACADDR2_31_0_ADDR           BN0_WF_RMAC_TOP_OMA2R0_ADDR
#define BN0_WF_RMAC_TOP_OMA2R0_OWNMACADDR2_31_0_MASK           0xFFFFFFFF                // OWNMACADDR2_31_0[31..0]
#define BN0_WF_RMAC_TOP_OMA2R0_OWNMACADDR2_31_0_SHFT           0

/* =====================================================================================

  ---OMA2R1 (0x820E5000 + 0x234)---

    OWNMACADDR2_47_32[15..0]     - (RW) OWN MAC address 2 bits 47~32
    OWNMACADDR2_EN[16]           - (RW) OWN MAC address 2 enable
                                     0: Disable this OWN MAC
                                     1: Enable this OWN MAC
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA2R1_OWNMACADDR2_EN_ADDR             BN0_WF_RMAC_TOP_OMA2R1_ADDR
#define BN0_WF_RMAC_TOP_OMA2R1_OWNMACADDR2_EN_MASK             0x00010000                // OWNMACADDR2_EN[16]
#define BN0_WF_RMAC_TOP_OMA2R1_OWNMACADDR2_EN_SHFT             16
#define BN0_WF_RMAC_TOP_OMA2R1_OWNMACADDR2_47_32_ADDR          BN0_WF_RMAC_TOP_OMA2R1_ADDR
#define BN0_WF_RMAC_TOP_OMA2R1_OWNMACADDR2_47_32_MASK          0x0000FFFF                // OWNMACADDR2_47_32[15..0]
#define BN0_WF_RMAC_TOP_OMA2R1_OWNMACADDR2_47_32_SHFT          0

/* =====================================================================================

  ---OMA3R0 (0x820E5000 + 0x238)---

    OWNMACADDR3_31_0[31..0]      - (RW) OWN MAC address 3 bits 31~0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA3R0_OWNMACADDR3_31_0_ADDR           BN0_WF_RMAC_TOP_OMA3R0_ADDR
#define BN0_WF_RMAC_TOP_OMA3R0_OWNMACADDR3_31_0_MASK           0xFFFFFFFF                // OWNMACADDR3_31_0[31..0]
#define BN0_WF_RMAC_TOP_OMA3R0_OWNMACADDR3_31_0_SHFT           0

/* =====================================================================================

  ---OMA3R1 (0x820E5000 + 0x23C)---

    OWNMACADDR3_47_32[15..0]     - (RW) OWN MAC address 3 bits 47~32
    OWNMACADDR3_EN[16]           - (RW) OWN MAC address 3 enable
                                     0: Disable this OWN MAC
                                     1: Enable this OWN MAC
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA3R1_OWNMACADDR3_EN_ADDR             BN0_WF_RMAC_TOP_OMA3R1_ADDR
#define BN0_WF_RMAC_TOP_OMA3R1_OWNMACADDR3_EN_MASK             0x00010000                // OWNMACADDR3_EN[16]
#define BN0_WF_RMAC_TOP_OMA3R1_OWNMACADDR3_EN_SHFT             16
#define BN0_WF_RMAC_TOP_OMA3R1_OWNMACADDR3_47_32_ADDR          BN0_WF_RMAC_TOP_OMA3R1_ADDR
#define BN0_WF_RMAC_TOP_OMA3R1_OWNMACADDR3_47_32_MASK          0x0000FFFF                // OWNMACADDR3_47_32[15..0]
#define BN0_WF_RMAC_TOP_OMA3R1_OWNMACADDR3_47_32_SHFT          0

/* =====================================================================================

  ---OMA4R0 (0x820E5000 + 0x240)---

    OWNMACADDR4_31_0[31..0]      - (RW) OWN MAC address 4 bits 31~0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA4R0_OWNMACADDR4_31_0_ADDR           BN0_WF_RMAC_TOP_OMA4R0_ADDR
#define BN0_WF_RMAC_TOP_OMA4R0_OWNMACADDR4_31_0_MASK           0xFFFFFFFF                // OWNMACADDR4_31_0[31..0]
#define BN0_WF_RMAC_TOP_OMA4R0_OWNMACADDR4_31_0_SHFT           0

/* =====================================================================================

  ---OMA4R1 (0x820E5000 + 0x244)---

    OWNMACADDR4_47_32[15..0]     - (RW) OWN MAC address 4 bits 47~32
    OWNMACADDR4_EN[16]           - (RW) OWN MAC address 4 enable0: Disable this OWN MAC1: Enable this OWN MAC
    RESERVED17[31..17]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_OMA4R1_OWNMACADDR4_EN_ADDR             BN0_WF_RMAC_TOP_OMA4R1_ADDR
#define BN0_WF_RMAC_TOP_OMA4R1_OWNMACADDR4_EN_MASK             0x00010000                // OWNMACADDR4_EN[16]
#define BN0_WF_RMAC_TOP_OMA4R1_OWNMACADDR4_EN_SHFT             16
#define BN0_WF_RMAC_TOP_OMA4R1_OWNMACADDR4_47_32_ADDR          BN0_WF_RMAC_TOP_OMA4R1_ADDR
#define BN0_WF_RMAC_TOP_OMA4R1_OWNMACADDR4_47_32_MASK          0x0000FFFF                // OWNMACADDR4_47_32[15..0]
#define BN0_WF_RMAC_TOP_OMA4R1_OWNMACADDR4_47_32_SHFT          0

/* =====================================================================================

  ---MBSSID_IDX (0x820E5000 + 0x248)---

    MBSSID_IDX_BSSID0[7..0]      - (RW) MBSSID index which DUT connected for BSSID0
    MBSSID_IDX_BSSID1[15..8]     - (RW) MBSSID index which DUT connected for BSSID1
    MBSSID_IDX_BSSID2[23..16]    - (RW) MBSSID index which DUT connected for BSSID2
    MBSSID_IDX_BSSID3[31..24]    - (RW) MBSSID index which DUT connected for BSSID3

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID3_ADDR      BN0_WF_RMAC_TOP_MBSSID_IDX_ADDR
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID3_MASK      0xFF000000                // MBSSID_IDX_BSSID3[31..24]
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID3_SHFT      24
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID2_ADDR      BN0_WF_RMAC_TOP_MBSSID_IDX_ADDR
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID2_MASK      0x00FF0000                // MBSSID_IDX_BSSID2[23..16]
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID2_SHFT      16
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID1_ADDR      BN0_WF_RMAC_TOP_MBSSID_IDX_ADDR
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID1_MASK      0x0000FF00                // MBSSID_IDX_BSSID1[15..8]
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID1_SHFT      8
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID0_ADDR      BN0_WF_RMAC_TOP_MBSSID_IDX_ADDR
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID0_MASK      0x000000FF                // MBSSID_IDX_BSSID0[7..0]
#define BN0_WF_RMAC_TOP_MBSSID_IDX_MBSSID_IDX_BSSID0_SHFT      0

/* =====================================================================================

  ---B01AR_B1AR (0x820E5000 + 0x250)---

    AID_BSSID0[11..0]            - (RW) Beacon AID for DUT
                                     which is to match beacon match BSSID0
    RESERVED12[15..12]           - (RO) Reserved bits
    AID_BSSID1[27..16]           - (RW) Beacon AID for DUT
                                     which is to match beacon match BSSID1
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_B01AR_B1AR_AID_BSSID1_ADDR             BN0_WF_RMAC_TOP_B01AR_B1AR_ADDR
#define BN0_WF_RMAC_TOP_B01AR_B1AR_AID_BSSID1_MASK             0x0FFF0000                // AID_BSSID1[27..16]
#define BN0_WF_RMAC_TOP_B01AR_B1AR_AID_BSSID1_SHFT             16
#define BN0_WF_RMAC_TOP_B01AR_B1AR_AID_BSSID0_ADDR             BN0_WF_RMAC_TOP_B01AR_B1AR_ADDR
#define BN0_WF_RMAC_TOP_B01AR_B1AR_AID_BSSID0_MASK             0x00000FFF                // AID_BSSID0[11..0]
#define BN0_WF_RMAC_TOP_B01AR_B1AR_AID_BSSID0_SHFT             0

/* =====================================================================================

  ---B23AR_B1AR (0x820E5000 + 0x254)---

    AID_BSSID2[11..0]            - (RW) Beacon AID for DUT
                                     which is to match beacon match BSSID2
    RESERVED12[15..12]           - (RO) Reserved bits
    AID_BSSID3[27..16]           - (RW) Beacon AID for DUT
                                     which is to match beacon match BSSID3
                                     Note: Not valid in MT7603/MT7628
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_B23AR_B1AR_AID_BSSID3_ADDR             BN0_WF_RMAC_TOP_B23AR_B1AR_ADDR
#define BN0_WF_RMAC_TOP_B23AR_B1AR_AID_BSSID3_MASK             0x0FFF0000                // AID_BSSID3[27..16]
#define BN0_WF_RMAC_TOP_B23AR_B1AR_AID_BSSID3_SHFT             16
#define BN0_WF_RMAC_TOP_B23AR_B1AR_AID_BSSID2_ADDR             BN0_WF_RMAC_TOP_B23AR_B1AR_ADDR
#define BN0_WF_RMAC_TOP_B23AR_B1AR_AID_BSSID2_MASK             0x00000FFF                // AID_BSSID2[11..0]
#define BN0_WF_RMAC_TOP_B23AR_B1AR_AID_BSSID2_SHFT             0

/* =====================================================================================

  ---ACBEN (0x820E5000 + 0x258)---

    ACBEN[15..0]                 - (RW) All 16 Current BSSID enable for Infra-AP mode
                                     Note: Do not enable ACBEN[0] and CB0R1[16] at the same time
                                     (Note: not support in MT6632)
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_ACBEN_ACBEN_ADDR                       BN0_WF_RMAC_TOP_ACBEN_ADDR
#define BN0_WF_RMAC_TOP_ACBEN_ACBEN_MASK                       0x0000FFFF                // ACBEN[15..0]
#define BN0_WF_RMAC_TOP_ACBEN_ACBEN_SHFT                       0

/* =====================================================================================

  ---MAR0 (0x820E5000 + 0x25C)---

    MULTICAST_ADDR_31_0[31..0]   - (RW) Allowed multicast address bits 31~0.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MAR0_MULTICAST_ADDR_31_0_ADDR          BN0_WF_RMAC_TOP_MAR0_ADDR
#define BN0_WF_RMAC_TOP_MAR0_MULTICAST_ADDR_31_0_MASK          0xFFFFFFFF                // MULTICAST_ADDR_31_0[31..0]
#define BN0_WF_RMAC_TOP_MAR0_MULTICAST_ADDR_31_0_SHFT          0

/* =====================================================================================

  ---MAR1 (0x820E5000 + 0x260)---

    MULTICAST_ADDR_47_32[15..0]  - (RW) Allowed multicast address bits 47~32.
    ACCESS_START[16]             - (RW) Multicast address access command and status.
                                     When write, 1 indicates to start the address table command access.
                                     When read,1 indicates command is busy
    READWRITE[17]                - (RW) Access command of the address table
                                     0:Read
                                     1:Write
    RESERVED18[23..18]           - (RO) Reserved bits
    MUTICAST_ADDR_INDEX[29..24]  - (RW) Multicast address index. 
                                     Total 32 indexes (0~31, other values are invalid) for MT6630/MT7603/MT7637.
                                     Total 48 index (0~47, other values are invalid) for MT7628/MT7663
                                     Total 64 index for MT7615/MT6632/MT7668/MT7622
    MULTICAST_ADDR_GROUP[31..30] - (RW) The address group & mode for storing, 0 = normal mode access, 1~3=hash mode access
                                     2'd0: store entrie addr (normal mode)
                                     2'd1: store hashed addr in BSSID1 group(hash mode)
                                     2'd2: store hashed addr in BSSID2 group(hash mode)
                                     2'd3: store hashed addr in BSSID3 group(hash mode)

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MAR1_MULTICAST_ADDR_GROUP_ADDR         BN0_WF_RMAC_TOP_MAR1_ADDR
#define BN0_WF_RMAC_TOP_MAR1_MULTICAST_ADDR_GROUP_MASK         0xC0000000                // MULTICAST_ADDR_GROUP[31..30]
#define BN0_WF_RMAC_TOP_MAR1_MULTICAST_ADDR_GROUP_SHFT         30
#define BN0_WF_RMAC_TOP_MAR1_MUTICAST_ADDR_INDEX_ADDR          BN0_WF_RMAC_TOP_MAR1_ADDR
#define BN0_WF_RMAC_TOP_MAR1_MUTICAST_ADDR_INDEX_MASK          0x3F000000                // MUTICAST_ADDR_INDEX[29..24]
#define BN0_WF_RMAC_TOP_MAR1_MUTICAST_ADDR_INDEX_SHFT          24
#define BN0_WF_RMAC_TOP_MAR1_READWRITE_ADDR                    BN0_WF_RMAC_TOP_MAR1_ADDR
#define BN0_WF_RMAC_TOP_MAR1_READWRITE_MASK                    0x00020000                // READWRITE[17]
#define BN0_WF_RMAC_TOP_MAR1_READWRITE_SHFT                    17
#define BN0_WF_RMAC_TOP_MAR1_ACCESS_START_ADDR                 BN0_WF_RMAC_TOP_MAR1_ADDR
#define BN0_WF_RMAC_TOP_MAR1_ACCESS_START_MASK                 0x00010000                // ACCESS_START[16]
#define BN0_WF_RMAC_TOP_MAR1_ACCESS_START_SHFT                 16
#define BN0_WF_RMAC_TOP_MAR1_MULTICAST_ADDR_47_32_ADDR         BN0_WF_RMAC_TOP_MAR1_ADDR
#define BN0_WF_RMAC_TOP_MAR1_MULTICAST_ADDR_47_32_MASK         0x0000FFFF                // MULTICAST_ADDR_47_32[15..0]
#define BN0_WF_RMAC_TOP_MAR1_MULTICAST_ADDR_47_32_SHFT         0

/* =====================================================================================

  ---MBSSIDACT0 (0x820E5000 + 0x264)---

    TIM_METHOD_B_N0_BSSID0[7..0] - (RW) TIM parsing for BSSID0
                                     N0 is Max possible nontransmitted BSSID number, is integer power of 2
    TIM_METHOD_B_EN_BSSID0[8]    - (RW) Enable TIM element parsing by method B
                                     0: Disable
                                     1: Enable
    RESERVED9[15..9]             - (RO) Reserved bits
    TIM_METHOD_B_N0_BSSID1[23..16] - (RW) TIM parsing for BSSID1
                                     N0 is Max possible nontransmitted BSSID number, is integer power of 2
    TIM_METHOD_B_EN_BSSID1[24]   - (RW) Enable TIM element parsing by method B
                                     0: Disable
                                     1: Enable
    RESERVED25[31..25]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_EN_BSSID1_ADDR BN0_WF_RMAC_TOP_MBSSIDACT0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_EN_BSSID1_MASK 0x01000000                // TIM_METHOD_B_EN_BSSID1[24]
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_EN_BSSID1_SHFT 24
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_N0_BSSID1_ADDR BN0_WF_RMAC_TOP_MBSSIDACT0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_N0_BSSID1_MASK 0x00FF0000                // TIM_METHOD_B_N0_BSSID1[23..16]
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_N0_BSSID1_SHFT 16
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_EN_BSSID0_ADDR BN0_WF_RMAC_TOP_MBSSIDACT0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_EN_BSSID0_MASK 0x00000100                // TIM_METHOD_B_EN_BSSID0[8]
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_EN_BSSID0_SHFT 8
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_N0_BSSID0_ADDR BN0_WF_RMAC_TOP_MBSSIDACT0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_N0_BSSID0_MASK 0x000000FF                // TIM_METHOD_B_N0_BSSID0[7..0]
#define BN0_WF_RMAC_TOP_MBSSIDACT0_TIM_METHOD_B_N0_BSSID0_SHFT 0

/* =====================================================================================

  ---MBSSIDACT1 (0x820E5000 + 0x268)---

    TIM_METHOD_B_N0_BSSID2[7..0] - (RW) TIM parsing for BSSID2
                                     N0 is Max possible nontransmitted BSSID number, is integer power of 2
    TIM_METHOD_B_EN_BSSID2[8]    - (RW) Enable TIM element parsing by method B
                                     0: Disable
                                     1: Enable
    RESERVED9[15..9]             - (RO) Reserved bits
    TIM_METHOD_B_N0_BSSID3[23..16] - (RW) TIM parsing for BSSID3
                                     N0 is Max possible nontransmitted BSSID number, is integer power of 2
    TIM_METHOD_B_EN_BSSID3[24]   - (RW) Enable TIM element parsing by method B
                                     0: Disable
                                     1: Enable
    RESERVED25[31..25]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_EN_BSSID3_ADDR BN0_WF_RMAC_TOP_MBSSIDACT1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_EN_BSSID3_MASK 0x01000000                // TIM_METHOD_B_EN_BSSID3[24]
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_EN_BSSID3_SHFT 24
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_N0_BSSID3_ADDR BN0_WF_RMAC_TOP_MBSSIDACT1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_N0_BSSID3_MASK 0x00FF0000                // TIM_METHOD_B_N0_BSSID3[23..16]
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_N0_BSSID3_SHFT 16
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_EN_BSSID2_ADDR BN0_WF_RMAC_TOP_MBSSIDACT1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_EN_BSSID2_MASK 0x00000100                // TIM_METHOD_B_EN_BSSID2[8]
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_EN_BSSID2_SHFT 8
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_N0_BSSID2_ADDR BN0_WF_RMAC_TOP_MBSSIDACT1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_N0_BSSID2_MASK 0x000000FF                // TIM_METHOD_B_N0_BSSID2[7..0]
#define BN0_WF_RMAC_TOP_MBSSIDACT1_TIM_METHOD_B_N0_BSSID2_SHFT 0

/* =====================================================================================

  ---FS0CR (0x820E5000 + 0x26C)---

    MU_SC_0_SSN[11..0]           - (RW) Write : the SSN of the accepted ADDBA from AP(for RSVD1[11]=0)
                                     Read: the current Winstart value of this BA scoreboard
    MU_SC_0_TID[15..12]          - (RW) TID for the full state BA scoreboard 0(for RSVD1[11]=0)
                                     Write : the TID of the accepted ADDBA from AP
                                     Read : the written value
    MU_SC_0_EN[16]               - (RW) Enable this MU scoreboard
                                     0 to disable this MU BA scoreboard
                                     1 to enable this MU BA scoreboard
    MU_SC_0_TA_SEL[18..17]       - (RW) MU scoreboard BSSID selection
                                     2'b00: BSSID0
                                     2'b01: BSSID1
                                     2'b10: BSSID2
                                     2'b11: BSSID3
    RESERVED19[19]               - (RO) Reserved bits
    MU_SC_0_TYPE_SEL[21..20]     - (RW) MU Scoreboard Type Selection
                                     2'b00: Partial state scoreboard type (Bind with designated BSSID)
                                     2'b01: Full state scoreboard type (Bind with designated BSSID and TID)
                                     2'b10: Reserved
                                     2'b11: Reserved
    RESERVED22[26..22]           - (RO) Reserved bits
    SC_0_BA_SKIP_POLICY_CHK_EN[27] - (RW) BA skip ack policy value
    SC_0_BA_CLR_BY_A1_COMP_EN[28] - (RW) BA clear by addr1 compare enable
    SC_0_BA_CLR_BY_A1_RPTR_AUTO_DIS[29] - (RW) BA clear by addr1 repeater auto disable
    SC_0_AMPDU_GT_64_BLK_EN[30]  - (RW) Block AMPDU > 64 MPDU
                                     0: no block AMPDU>64 part MPDU in RMAC
                                     1: block AMPDU>64 part MPDU in RMAC
    SC_0_EN[31]                  - (RW) Scoreboard0 enable

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_EN_ADDR                     BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_EN_MASK                     0x80000000                // SC_0_EN[31]
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_EN_SHFT                     31
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_AMPDU_GT_64_BLK_EN_ADDR     BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_AMPDU_GT_64_BLK_EN_MASK     0x40000000                // SC_0_AMPDU_GT_64_BLK_EN[30]
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_AMPDU_GT_64_BLK_EN_SHFT     30
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_CLR_BY_A1_RPTR_AUTO_DIS_ADDR BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_CLR_BY_A1_RPTR_AUTO_DIS_MASK 0x20000000                // SC_0_BA_CLR_BY_A1_RPTR_AUTO_DIS[29]
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_CLR_BY_A1_RPTR_AUTO_DIS_SHFT 29
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_CLR_BY_A1_COMP_EN_ADDR   BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_CLR_BY_A1_COMP_EN_MASK   0x10000000                // SC_0_BA_CLR_BY_A1_COMP_EN[28]
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_CLR_BY_A1_COMP_EN_SHFT   28
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_SKIP_POLICY_CHK_EN_ADDR  BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_SKIP_POLICY_CHK_EN_MASK  0x08000000                // SC_0_BA_SKIP_POLICY_CHK_EN[27]
#define BN0_WF_RMAC_TOP_FS0CR_SC_0_BA_SKIP_POLICY_CHK_EN_SHFT  27
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TYPE_SEL_ADDR            BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TYPE_SEL_MASK            0x00300000                // MU_SC_0_TYPE_SEL[21..20]
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TYPE_SEL_SHFT            20
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TA_SEL_ADDR              BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TA_SEL_MASK              0x00060000                // MU_SC_0_TA_SEL[18..17]
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TA_SEL_SHFT              17
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_EN_ADDR                  BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_EN_MASK                  0x00010000                // MU_SC_0_EN[16]
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_EN_SHFT                  16
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TID_ADDR                 BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TID_MASK                 0x0000F000                // MU_SC_0_TID[15..12]
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_TID_SHFT                 12
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_SSN_ADDR                 BN0_WF_RMAC_TOP_FS0CR_ADDR
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_SSN_MASK                 0x00000FFF                // MU_SC_0_SSN[11..0]
#define BN0_WF_RMAC_TOP_FS0CR_MU_SC_0_SSN_SHFT                 0

/* =====================================================================================

  ---FS1CR (0x820E5000 + 0x270)---

    MU_SC_1_SSN[11..0]           - (RW) SSN for the full state BA scoreboard 1(for RSVD1[11]=0)
                                     Write : the SSN of the accepted ADDBA from AP(for RSVD1[11]=0)
                                     Read: the current Winstart value of this BA scoreboard
    MU_SC_1_TID[15..12]          - (RW) TID for the full state BA scoreboard 1(for RSVD1[11]=0)
                                     Write : the TID of the accepted ADDBA from AP
                                     Read : the written value
    MU_SC_1_EN[16]               - (RW) Enable this MU scoreboard
                                     0 to disable this MU BA scoreboard
                                     1 to enable this MU BA scoreboard
    MU_SC_1_TA_SEL[18..17]       - (RW) MU scoreboard BSSID selection
                                     2'b00: BSSID0
                                     2'b01: BSSID1
                                     2'b10: BSSID2
                                     2'b11: BSSID3
    RESERVED19[19]               - (RO) Reserved bits
    MU_SC_1_TYPE_SEL[21..20]     - (RW) MU Scoreboard Type Selection
                                     2'b00: Partial state scoreboard type (Bind with designated BSSID)
                                     2'b01: Full state scoreboard type (Bind with designated BSSID and TID)
                                     2'b10: Reserved
                                     2'b11: Reserved
    RESERVED22[26..22]           - (RO) Reserved bits
    SC_1_BA_SKIP_POLICY_CHK_EN[27] - (RW) BA skip ack policy value
    SC_1_BA_CLR_BY_A1_COMP_EN[28] - (RW) BA clear by addr1 compare enable
    SC_1_BA_CLR_BY_A1_RPTR_AUTO_DIS[29] - (RW) BA clear by addr1 repeater auto disable
    SC_1_AMPDU_GT_64_BLK_EN[30]  - (RW) Block AMPDU > 64 MPDU
                                     0: no block AMPDU>64 part MPDU in RMAC
                                     1: block AMPDU>64 part MPDU in RMAC
    SC_1_EN[31]                  - (RW) Scoreboard1 enable

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_EN_ADDR                     BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_EN_MASK                     0x80000000                // SC_1_EN[31]
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_EN_SHFT                     31
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_AMPDU_GT_64_BLK_EN_ADDR     BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_AMPDU_GT_64_BLK_EN_MASK     0x40000000                // SC_1_AMPDU_GT_64_BLK_EN[30]
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_AMPDU_GT_64_BLK_EN_SHFT     30
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_CLR_BY_A1_RPTR_AUTO_DIS_ADDR BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_CLR_BY_A1_RPTR_AUTO_DIS_MASK 0x20000000                // SC_1_BA_CLR_BY_A1_RPTR_AUTO_DIS[29]
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_CLR_BY_A1_RPTR_AUTO_DIS_SHFT 29
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_CLR_BY_A1_COMP_EN_ADDR   BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_CLR_BY_A1_COMP_EN_MASK   0x10000000                // SC_1_BA_CLR_BY_A1_COMP_EN[28]
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_CLR_BY_A1_COMP_EN_SHFT   28
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_SKIP_POLICY_CHK_EN_ADDR  BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_SKIP_POLICY_CHK_EN_MASK  0x08000000                // SC_1_BA_SKIP_POLICY_CHK_EN[27]
#define BN0_WF_RMAC_TOP_FS1CR_SC_1_BA_SKIP_POLICY_CHK_EN_SHFT  27
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TYPE_SEL_ADDR            BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TYPE_SEL_MASK            0x00300000                // MU_SC_1_TYPE_SEL[21..20]
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TYPE_SEL_SHFT            20
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TA_SEL_ADDR              BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TA_SEL_MASK              0x00060000                // MU_SC_1_TA_SEL[18..17]
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TA_SEL_SHFT              17
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_EN_ADDR                  BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_EN_MASK                  0x00010000                // MU_SC_1_EN[16]
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_EN_SHFT                  16
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TID_ADDR                 BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TID_MASK                 0x0000F000                // MU_SC_1_TID[15..12]
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_TID_SHFT                 12
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_SSN_ADDR                 BN0_WF_RMAC_TOP_FS1CR_ADDR
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_SSN_MASK                 0x00000FFF                // MU_SC_1_SSN[11..0]
#define BN0_WF_RMAC_TOP_FS1CR_MU_SC_1_SSN_SHFT                 0

/* =====================================================================================

  ---FS2CR (0x820E5000 + 0x274)---

    MU_SC_2_SSN[11..0]           - (RW) SSN for the full state BA scoreboard 1(for RSVD1[11]=0)
                                     Write : the SSN of the accepted ADDBA from AP(for RSVD1[11]=0)
                                     Read: the current Winstart value of this BA scoreboard
    MU_SC_2_TID[15..12]          - (RW) TID for the full state BA scoreboard 2(for RSVD1[11]=0)
                                     Write : the TID of the accepted ADDBA from AP
                                     Read : the written value
    MU_SC_2_EN[16]               - (RW) Enable this MU scoreboard
                                     0 to disable this MU BA scoreboard
                                     1 to enable this MU BA scoreboard
    MU_SC_2_TA_SEL[18..17]       - (RW) MU scoreboard BSSID selection
                                     2'b00: BSSID0
                                     2'b01: BSSID1
                                     2'b10: BSSID2
                                     2'b11: BSSID3
    RESERVED19[19]               - (RO) Reserved bits
    MU_SC_2_TYPE_SEL[21..20]     - (RW) MU Scoreboard Type Selection
                                     2'b00: Partial state scoreboard type (Bind with designated BSSID)
                                     2'b01: Full state scoreboard type (Bind with designated BSSID and TID)
                                     2'b10: Reserved
                                     2'b11: Reserved
    RESERVED22[26..22]           - (RO) Reserved bits
    SC_2_BA_SKIP_POLICY_CHK_EN[27] - (RW) BA skip ack policy value
    SC_2_BA_CLR_BY_A1_COMP_EN[28] - (RW) BA clear by addr1 compare enable
    SC_2_BA_CLR_BY_A1_RPTR_AUTO_DIS[29] - (RW) BA clear by addr1 repeater auto disable
    SC_2_AMPDU_GT_64_BLK_EN[30]  - (RW) Block AMPDU > 64 MPDU
                                     0: no block AMPDU>64 part MPDU in RMAC
                                     1: block AMPDU>64 part MPDU in RMAC
    SC_2_EN[31]                  - (RW) Scoreboard2 enable

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_EN_ADDR                     BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_EN_MASK                     0x80000000                // SC_2_EN[31]
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_EN_SHFT                     31
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_AMPDU_GT_64_BLK_EN_ADDR     BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_AMPDU_GT_64_BLK_EN_MASK     0x40000000                // SC_2_AMPDU_GT_64_BLK_EN[30]
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_AMPDU_GT_64_BLK_EN_SHFT     30
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_CLR_BY_A1_RPTR_AUTO_DIS_ADDR BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_CLR_BY_A1_RPTR_AUTO_DIS_MASK 0x20000000                // SC_2_BA_CLR_BY_A1_RPTR_AUTO_DIS[29]
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_CLR_BY_A1_RPTR_AUTO_DIS_SHFT 29
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_CLR_BY_A1_COMP_EN_ADDR   BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_CLR_BY_A1_COMP_EN_MASK   0x10000000                // SC_2_BA_CLR_BY_A1_COMP_EN[28]
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_CLR_BY_A1_COMP_EN_SHFT   28
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_SKIP_POLICY_CHK_EN_ADDR  BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_SKIP_POLICY_CHK_EN_MASK  0x08000000                // SC_2_BA_SKIP_POLICY_CHK_EN[27]
#define BN0_WF_RMAC_TOP_FS2CR_SC_2_BA_SKIP_POLICY_CHK_EN_SHFT  27
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TYPE_SEL_ADDR            BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TYPE_SEL_MASK            0x00300000                // MU_SC_2_TYPE_SEL[21..20]
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TYPE_SEL_SHFT            20
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TA_SEL_ADDR              BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TA_SEL_MASK              0x00060000                // MU_SC_2_TA_SEL[18..17]
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TA_SEL_SHFT              17
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_EN_ADDR                  BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_EN_MASK                  0x00010000                // MU_SC_2_EN[16]
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_EN_SHFT                  16
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TID_ADDR                 BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TID_MASK                 0x0000F000                // MU_SC_2_TID[15..12]
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_TID_SHFT                 12
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_SSN_ADDR                 BN0_WF_RMAC_TOP_FS2CR_ADDR
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_SSN_MASK                 0x00000FFF                // MU_SC_2_SSN[11..0]
#define BN0_WF_RMAC_TOP_FS2CR_MU_SC_2_SSN_SHFT                 0

/* =====================================================================================

  ---FS3CR (0x820E5000 + 0x278)---

    MU_SC_3_SSN[11..0]           - (RW) SSN for the full state BA scoreboard 1(for RSVD1[11]=0)
                                     Write : the SSN of the accepted ADDBA from AP(for RSVD1[11]=0)
                                     Read: the current Winstart value of this BA scoreboard
    MU_SC_3_TID[15..12]          - (RW) TID for the full state BA scoreboard 3(for RSVD1[11]=0)
                                     Write : the TID of the accepted ADDBA from AP
                                     Read : the written value
    MU_SC_3_EN[16]               - (RW) Enable this MU scoreboard
                                     0 to disable this MU BA scoreboard
                                     1 to enable this MU BA scoreboard
    MU_SC_3_TA_SEL[18..17]       - (RW) MU scoreboard BSSID selection
                                     2'b00: BSSID0
                                     2'b01: BSSID1
                                     2'b10: BSSID2
                                     2'b11: BSSID3
    RESERVED19[19]               - (RO) Reserved bits
    MU_SC_3_TYPE_SEL[21..20]     - (RW) MU Scoreboard Type Selection
                                     2'b00: Partial state scoreboard type (Bind with designated BSSID)
                                     2'b01: Full state scoreboard type (Bind with designated BSSID and TID)
                                     2'b10: Reserved
                                     2'b11: Reserved
    RESERVED22[26..22]           - (RO) Reserved bits
    SC_3_BA_SKIP_POLICY_CHK_EN[27] - (RW) BA skip ack policy value
    SC_3_BA_CLR_BY_A1_COMP_EN[28] - (RW) BA clear by addr1 compare enable
    SC_3_BA_CLR_BY_A1_RPTR_AUTO_DIS[29] - (RW) BA clear by addr1 repeater auto disable
    SC_3_AMPDU_GT_64_BLK_EN[30]  - (RW) Block AMPDU > 64 MPDU
                                     0: no block AMPDU>64 part MPDU in RMAC
                                     1: block AMPDU>64 part MPDU in RMAC
    SC_3_EN[31]                  - (RW) Scoreboard3 enable

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_EN_ADDR                     BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_EN_MASK                     0x80000000                // SC_3_EN[31]
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_EN_SHFT                     31
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_AMPDU_GT_64_BLK_EN_ADDR     BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_AMPDU_GT_64_BLK_EN_MASK     0x40000000                // SC_3_AMPDU_GT_64_BLK_EN[30]
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_AMPDU_GT_64_BLK_EN_SHFT     30
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_CLR_BY_A1_RPTR_AUTO_DIS_ADDR BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_CLR_BY_A1_RPTR_AUTO_DIS_MASK 0x20000000                // SC_3_BA_CLR_BY_A1_RPTR_AUTO_DIS[29]
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_CLR_BY_A1_RPTR_AUTO_DIS_SHFT 29
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_CLR_BY_A1_COMP_EN_ADDR   BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_CLR_BY_A1_COMP_EN_MASK   0x10000000                // SC_3_BA_CLR_BY_A1_COMP_EN[28]
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_CLR_BY_A1_COMP_EN_SHFT   28
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_SKIP_POLICY_CHK_EN_ADDR  BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_SKIP_POLICY_CHK_EN_MASK  0x08000000                // SC_3_BA_SKIP_POLICY_CHK_EN[27]
#define BN0_WF_RMAC_TOP_FS3CR_SC_3_BA_SKIP_POLICY_CHK_EN_SHFT  27
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TYPE_SEL_ADDR            BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TYPE_SEL_MASK            0x00300000                // MU_SC_3_TYPE_SEL[21..20]
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TYPE_SEL_SHFT            20
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TA_SEL_ADDR              BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TA_SEL_MASK              0x00060000                // MU_SC_3_TA_SEL[18..17]
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TA_SEL_SHFT              17
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_EN_ADDR                  BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_EN_MASK                  0x00010000                // MU_SC_3_EN[16]
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_EN_SHFT                  16
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TID_ADDR                 BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TID_MASK                 0x0000F000                // MU_SC_3_TID[15..12]
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_TID_SHFT                 12
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_SSN_ADDR                 BN0_WF_RMAC_TOP_FS3CR_ADDR
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_SSN_MASK                 0x00000FFF                // MU_SC_3_SSN[11..0]
#define BN0_WF_RMAC_TOP_FS3CR_MU_SC_3_SSN_SHFT                 0

/* =====================================================================================

  ---MUARBR0 (0x820E5000 + 0x27C)---

    MUARBR_31_0[31..0]           - (RW) Backup/Restore MUAR table
                                     For backup: this CR reture's MUAR table entry's 32-bit LSB content. Note, read this CR will not increase 1 for read entry index.
                                     For restore: write this CR, MUAR table entry's 32-bit LSB will be overwrite.  Note, write this CR will not increase 1 for write entry index.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MUARBR0_MUARBR_31_0_ADDR               BN0_WF_RMAC_TOP_MUARBR0_ADDR
#define BN0_WF_RMAC_TOP_MUARBR0_MUARBR_31_0_MASK               0xFFFFFFFF                // MUARBR_31_0[31..0]
#define BN0_WF_RMAC_TOP_MUARBR0_MUARBR_31_0_SHFT               0

/* =====================================================================================

  ---MUARBR1 (0x820E5000 + 0x280)---

    MUARBR_47_32[15..0]          - (RW) Backup/Restore MUAR table
                                     For backup: this CR reture's MUAR table entry's 16-bit MSB content. Note, read this CR will increase 1 for read entry index.
                                     For restore: write this CR, MUAR table entry's 16-bit MSB will be overwrite. Note, write this CR will increase 1 for write entry index (MUARBR_IDX_RST should be 0).
    RESERVED16[30..16]           - (RO) Reserved bits
    MUARBR_IDX_RST[31]           - (WO) Backup/Restore MUAR table Write 1 to clear MUAR table entry index value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MUARBR1_MUARBR_IDX_RST_ADDR            BN0_WF_RMAC_TOP_MUARBR1_ADDR
#define BN0_WF_RMAC_TOP_MUARBR1_MUARBR_IDX_RST_MASK            0x80000000                // MUARBR_IDX_RST[31]
#define BN0_WF_RMAC_TOP_MUARBR1_MUARBR_IDX_RST_SHFT            31
#define BN0_WF_RMAC_TOP_MUARBR1_MUARBR_47_32_ADDR              BN0_WF_RMAC_TOP_MUARBR1_ADDR
#define BN0_WF_RMAC_TOP_MUARBR1_MUARBR_47_32_MASK              0x0000FFFF                // MUARBR_47_32[15..0]
#define BN0_WF_RMAC_TOP_MUARBR1_MUARBR_47_32_SHFT              0

/* =====================================================================================

  ---FSB0BR0 (0x820E5000 + 0x284)---

    MU_SB0_31_0[31..0]           - (RW) Backup/Restore use
                                     read data is current bitmap
                                     write data will restore to current bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FSB0BR0_MU_SB0_31_0_ADDR               BN0_WF_RMAC_TOP_FSB0BR0_ADDR
#define BN0_WF_RMAC_TOP_FSB0BR0_MU_SB0_31_0_MASK               0xFFFFFFFF                // MU_SB0_31_0[31..0]
#define BN0_WF_RMAC_TOP_FSB0BR0_MU_SB0_31_0_SHFT               0

/* =====================================================================================

  ---FSB0BR1 (0x820E5000 + 0x288)---

    MU_SB0_64_32[31..0]          - (RW) Backup/Restore use
                                     read data is current bitmap
                                     write data will restore to current bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FSB0BR1_MU_SB0_64_32_ADDR              BN0_WF_RMAC_TOP_FSB0BR1_ADDR
#define BN0_WF_RMAC_TOP_FSB0BR1_MU_SB0_64_32_MASK              0xFFFFFFFF                // MU_SB0_64_32[31..0]
#define BN0_WF_RMAC_TOP_FSB0BR1_MU_SB0_64_32_SHFT              0

/* =====================================================================================

  ---FSB1BR0 (0x820E5000 + 0x28C)---

    MU_SB1_31_0[31..0]           - (RW) Backup/Restore use
                                     read data is current bitmap
                                     write data will restore to current bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FSB1BR0_MU_SB1_31_0_ADDR               BN0_WF_RMAC_TOP_FSB1BR0_ADDR
#define BN0_WF_RMAC_TOP_FSB1BR0_MU_SB1_31_0_MASK               0xFFFFFFFF                // MU_SB1_31_0[31..0]
#define BN0_WF_RMAC_TOP_FSB1BR0_MU_SB1_31_0_SHFT               0

/* =====================================================================================

  ---FSB1BR1 (0x820E5000 + 0x290)---

    MU_SB1_64_32[31..0]          - (RW) Backup/Restore use
                                     read data is current bitmap
                                     write data will restore to current bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FSB1BR1_MU_SB1_64_32_ADDR              BN0_WF_RMAC_TOP_FSB1BR1_ADDR
#define BN0_WF_RMAC_TOP_FSB1BR1_MU_SB1_64_32_MASK              0xFFFFFFFF                // MU_SB1_64_32[31..0]
#define BN0_WF_RMAC_TOP_FSB1BR1_MU_SB1_64_32_SHFT              0

/* =====================================================================================

  ---FSB2BR0 (0x820E5000 + 0x294)---

    MU_SB2_31_0[31..0]           - (RW) Backup/Restore use
                                     read data is current bitmap
                                     write data will restore to current bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FSB2BR0_MU_SB2_31_0_ADDR               BN0_WF_RMAC_TOP_FSB2BR0_ADDR
#define BN0_WF_RMAC_TOP_FSB2BR0_MU_SB2_31_0_MASK               0xFFFFFFFF                // MU_SB2_31_0[31..0]
#define BN0_WF_RMAC_TOP_FSB2BR0_MU_SB2_31_0_SHFT               0

/* =====================================================================================

  ---FSB2BR1 (0x820E5000 + 0x298)---

    MU_SB2_64_32[31..0]          - (RW) Backup/Restore use
                                     read data is current bitmap
                                     write data will restore to current bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FSB2BR1_MU_SB2_64_32_ADDR              BN0_WF_RMAC_TOP_FSB2BR1_ADDR
#define BN0_WF_RMAC_TOP_FSB2BR1_MU_SB2_64_32_MASK              0xFFFFFFFF                // MU_SB2_64_32[31..0]
#define BN0_WF_RMAC_TOP_FSB2BR1_MU_SB2_64_32_SHFT              0

/* =====================================================================================

  ---FSB3BR0 (0x820E5000 + 0x29C)---

    MU_SB3_31_0[31..0]           - (RW) Backup/Restore use
                                     read data is current bitmap
                                     write data will restore to current bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FSB3BR0_MU_SB3_31_0_ADDR               BN0_WF_RMAC_TOP_FSB3BR0_ADDR
#define BN0_WF_RMAC_TOP_FSB3BR0_MU_SB3_31_0_MASK               0xFFFFFFFF                // MU_SB3_31_0[31..0]
#define BN0_WF_RMAC_TOP_FSB3BR0_MU_SB3_31_0_SHFT               0

/* =====================================================================================

  ---FSB3BR1 (0x820E5000 + 0x2A0)---

    MU_SB3_64_32[31..0]          - (RW) Backup/Restore use
                                     read data is current bitmap
                                     write data will restore to current bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_FSB3BR1_MU_SB3_64_32_ADDR              BN0_WF_RMAC_TOP_FSB3BR1_ADDR
#define BN0_WF_RMAC_TOP_FSB3BR1_MU_SB3_64_32_MASK              0xFFFFFFFF                // MU_SB3_64_32[31..0]
#define BN0_WF_RMAC_TOP_FSB3BR1_MU_SB3_64_32_SHFT              0

/* =====================================================================================

  ---RSVD0 (0x820E5000 + 0x2E0)---

    RSVD0[31..0]                 - (RW) Reserved0
                                     Do not change this value
                                     [21]: optional for make EIFS=0 for VOW by setting this bit = 1
                                     [17]: optional for stop reload EIFS when FCS error for VOW by setting this bit = 1

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RSVD0_RSVD0_ADDR                       BN0_WF_RMAC_TOP_RSVD0_ADDR
#define BN0_WF_RMAC_TOP_RSVD0_RSVD0_MASK                       0xFFFFFFFF                // RSVD0[31..0]
#define BN0_WF_RMAC_TOP_RSVD0_RSVD0_SHFT                       0

/* =====================================================================================

  ---RSVD1 (0x820E5000 + 0x2E4)---

    RSVD1[31..0]                 - (RW) Reserved1
                                     [15]: Force VOA_VLD
                                     [7:0]: TMR watchdog timer
                                     [8]: TMR watchdog enable

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RSVD1_RSVD1_ADDR                       BN0_WF_RMAC_TOP_RSVD1_ADDR
#define BN0_WF_RMAC_TOP_RSVD1_RSVD1_MASK                       0xFFFFFFFF                // RSVD1[31..0]
#define BN0_WF_RMAC_TOP_RSVD1_RSVD1_SHFT                       0

/* =====================================================================================

  ---AIRTIME17 (0x820E5000 + 0x2E8)---

    WMM_RPTER_QID0_IFS[15..0]    - (RW) RX airtime CR
                                     WMM Repeater QID0 IFS time. 
                                     Unit is 1.024us
    WMM_RPTER_QID1_IFS[31..16]   - (RW) RX airtime CR
                                     WMM Repeater QID1 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME17_WMM_RPTER_QID1_IFS_ADDR      BN0_WF_RMAC_TOP_AIRTIME17_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME17_WMM_RPTER_QID1_IFS_MASK      0xFFFF0000                // WMM_RPTER_QID1_IFS[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME17_WMM_RPTER_QID1_IFS_SHFT      16
#define BN0_WF_RMAC_TOP_AIRTIME17_WMM_RPTER_QID0_IFS_ADDR      BN0_WF_RMAC_TOP_AIRTIME17_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME17_WMM_RPTER_QID0_IFS_MASK      0x0000FFFF                // WMM_RPTER_QID0_IFS[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME17_WMM_RPTER_QID0_IFS_SHFT      0

/* =====================================================================================

  ---MIBTIME18 (0x820E5000 + 0x2EC)---

    WMM_RPTER_QID2_IFS[15..0]    - (RW) RX airtime CR
                                     WMM Repeater QID2 IFS time. 
                                     Unit is 1.024us
    WMM_RPTER_QID3_IFS[31..16]   - (RW) RX airtime CR
                                     WMM Repeater QID3 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME18_WMM_RPTER_QID3_IFS_ADDR      BN0_WF_RMAC_TOP_MIBTIME18_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME18_WMM_RPTER_QID3_IFS_MASK      0xFFFF0000                // WMM_RPTER_QID3_IFS[31..16]
#define BN0_WF_RMAC_TOP_MIBTIME18_WMM_RPTER_QID3_IFS_SHFT      16
#define BN0_WF_RMAC_TOP_MIBTIME18_WMM_RPTER_QID2_IFS_ADDR      BN0_WF_RMAC_TOP_MIBTIME18_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME18_WMM_RPTER_QID2_IFS_MASK      0x0000FFFF                // WMM_RPTER_QID2_IFS[15..0]
#define BN0_WF_RMAC_TOP_MIBTIME18_WMM_RPTER_QID2_IFS_SHFT      0

/* =====================================================================================

  ---AIRTIME19 (0x820E5000 + 0x2F0)---

    WMM_STA00to03_QID0_IFS[15..0] - (RW) RX airtime CR
                                     WMM STA00to03 QID0 IFS time. 
                                     Unit is 1.024us
    WMM_STA00to03_QID1_IFS[31..16] - (RW) RX airtime CR
                                     WMM STA00to03 QID1 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME19_WMM_STA00to03_QID1_IFS_ADDR  BN0_WF_RMAC_TOP_AIRTIME19_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME19_WMM_STA00to03_QID1_IFS_MASK  0xFFFF0000                // WMM_STA00to03_QID1_IFS[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME19_WMM_STA00to03_QID1_IFS_SHFT  16
#define BN0_WF_RMAC_TOP_AIRTIME19_WMM_STA00to03_QID0_IFS_ADDR  BN0_WF_RMAC_TOP_AIRTIME19_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME19_WMM_STA00to03_QID0_IFS_MASK  0x0000FFFF                // WMM_STA00to03_QID0_IFS[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME19_WMM_STA00to03_QID0_IFS_SHFT  0

/* =====================================================================================

  ---MIBTIME20 (0x820E5000 + 0x2F4)---

    WMM_STA00to03_QID2_IFS[15..0] - (RW) RX airtime CR
                                     WMM STA00to03 QID2 IFS time. 
                                     Unit is 1.024us
    WMM_STA00to03_QID3_IFS[31..16] - (RW) RX airtime CR
                                     WMM STA00to03 QID3 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME20_WMM_STA00to03_QID3_IFS_ADDR  BN0_WF_RMAC_TOP_MIBTIME20_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME20_WMM_STA00to03_QID3_IFS_MASK  0xFFFF0000                // WMM_STA00to03_QID3_IFS[31..16]
#define BN0_WF_RMAC_TOP_MIBTIME20_WMM_STA00to03_QID3_IFS_SHFT  16
#define BN0_WF_RMAC_TOP_MIBTIME20_WMM_STA00to03_QID2_IFS_ADDR  BN0_WF_RMAC_TOP_MIBTIME20_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME20_WMM_STA00to03_QID2_IFS_MASK  0x0000FFFF                // WMM_STA00to03_QID2_IFS[15..0]
#define BN0_WF_RMAC_TOP_MIBTIME20_WMM_STA00to03_QID2_IFS_SHFT  0

/* =====================================================================================

  ---MBSSIDEXT1_0 (0x820E5000 + 0x300)---

    MBSSIDEXT1_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_1[31:0] 
                                     (Note: MBSSID not support in MT6632)

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT1_0_MBSSIDEXT1_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT1_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT1_0_MBSSIDEXT1_0_MASK         0xFFFFFFFF                // MBSSIDEXT1_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT1_0_MBSSIDEXT1_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT1_1 (0x820E5000 + 0x304)---

    MBSSIDEXT1_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_1[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT1_1_MBSSIDEXT1_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT1_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT1_1_MBSSIDEXT1_1_MASK         0x0000FFFF                // MBSSIDEXT1_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT1_1_MBSSIDEXT1_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT2_0 (0x820E5000 + 0x308)---

    MBSSIDEXT2_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_2[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT2_0_MBSSIDEXT2_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT2_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT2_0_MBSSIDEXT2_0_MASK         0xFFFFFFFF                // MBSSIDEXT2_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT2_0_MBSSIDEXT2_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT2_1 (0x820E5000 + 0x30C)---

    MBSSIDEXT2_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_2[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT2_1_MBSSIDEXT2_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT2_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT2_1_MBSSIDEXT2_1_MASK         0x0000FFFF                // MBSSIDEXT2_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT2_1_MBSSIDEXT2_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT3_0 (0x820E5000 + 0x310)---

    MBSSIDEXT3_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_3[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT3_0_MBSSIDEXT3_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT3_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT3_0_MBSSIDEXT3_0_MASK         0xFFFFFFFF                // MBSSIDEXT3_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT3_0_MBSSIDEXT3_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT3_1 (0x820E5000 + 0x314)---

    MBSSIDEXT3_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_3[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT3_1_MBSSIDEXT3_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT3_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT3_1_MBSSIDEXT3_1_MASK         0x0000FFFF                // MBSSIDEXT3_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT3_1_MBSSIDEXT3_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT4_0 (0x820E5000 + 0x318)---

    MBSSIDEXT4_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_4[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT4_0_MBSSIDEXT4_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT4_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT4_0_MBSSIDEXT4_0_MASK         0xFFFFFFFF                // MBSSIDEXT4_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT4_0_MBSSIDEXT4_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT4_1 (0x820E5000 + 0x31C)---

    MBSSIDEXT4_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_4[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT4_1_MBSSIDEXT4_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT4_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT4_1_MBSSIDEXT4_1_MASK         0x0000FFFF                // MBSSIDEXT4_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT4_1_MBSSIDEXT4_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT5_0 (0x820E5000 + 0x320)---

    MBSSIDEXT5_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_5[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT5_0_MBSSIDEXT5_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT5_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT5_0_MBSSIDEXT5_0_MASK         0xFFFFFFFF                // MBSSIDEXT5_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT5_0_MBSSIDEXT5_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT5_1 (0x820E5000 + 0x324)---

    MBSSIDEXT5_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_5[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT5_1_MBSSIDEXT5_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT5_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT5_1_MBSSIDEXT5_1_MASK         0x0000FFFF                // MBSSIDEXT5_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT5_1_MBSSIDEXT5_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT6_0 (0x820E5000 + 0x328)---

    MBSSIDEXT6_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_6[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT6_0_MBSSIDEXT6_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT6_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT6_0_MBSSIDEXT6_0_MASK         0xFFFFFFFF                // MBSSIDEXT6_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT6_0_MBSSIDEXT6_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT6_1 (0x820E5000 + 0x32C)---

    MBSSIDEXT6_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_6[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT6_1_MBSSIDEXT6_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT6_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT6_1_MBSSIDEXT6_1_MASK         0x0000FFFF                // MBSSIDEXT6_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT6_1_MBSSIDEXT6_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT7_0 (0x820E5000 + 0x330)---

    MBSSIDEXT7_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_7[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT7_0_MBSSIDEXT7_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT7_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT7_0_MBSSIDEXT7_0_MASK         0xFFFFFFFF                // MBSSIDEXT7_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT7_0_MBSSIDEXT7_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT7_1 (0x820E5000 + 0x334)---

    MBSSIDEXT7_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_7[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT7_1_MBSSIDEXT7_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT7_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT7_1_MBSSIDEXT7_1_MASK         0x0000FFFF                // MBSSIDEXT7_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT7_1_MBSSIDEXT7_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT8_0 (0x820E5000 + 0x338)---

    MBSSIDEXT8_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_8[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT8_0_MBSSIDEXT8_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT8_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT8_0_MBSSIDEXT8_0_MASK         0xFFFFFFFF                // MBSSIDEXT8_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT8_0_MBSSIDEXT8_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT8_1 (0x820E5000 + 0x33C)---

    MBSSIDEXT8_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_8[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT8_1_MBSSIDEXT8_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT8_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT8_1_MBSSIDEXT8_1_MASK         0x0000FFFF                // MBSSIDEXT8_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT8_1_MBSSIDEXT8_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT9_0 (0x820E5000 + 0x340)---

    MBSSIDEXT9_0[31..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_9[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT9_0_MBSSIDEXT9_0_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT9_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT9_0_MBSSIDEXT9_0_MASK         0xFFFFFFFF                // MBSSIDEXT9_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT9_0_MBSSIDEXT9_0_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT9_1 (0x820E5000 + 0x344)---

    MBSSIDEXT9_1[15..0]          - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_9[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT9_1_MBSSIDEXT9_1_ADDR         BN0_WF_RMAC_TOP_MBSSIDEXT9_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT9_1_MBSSIDEXT9_1_MASK         0x0000FFFF                // MBSSIDEXT9_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT9_1_MBSSIDEXT9_1_SHFT         0

/* =====================================================================================

  ---MBSSIDEXT10_0 (0x820E5000 + 0x348)---

    MBSSIDEXT10_0[31..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_10[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT10_0_MBSSIDEXT10_0_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT10_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT10_0_MBSSIDEXT10_0_MASK       0xFFFFFFFF                // MBSSIDEXT10_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT10_0_MBSSIDEXT10_0_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT10_1 (0x820E5000 + 0x34C)---

    MBSSIDEXT10_1[15..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_10[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT10_1_MBSSIDEXT10_1_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT10_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT10_1_MBSSIDEXT10_1_MASK       0x0000FFFF                // MBSSIDEXT10_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT10_1_MBSSIDEXT10_1_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT11_0 (0x820E5000 + 0x350)---

    MBSSIDEXT11_0[31..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_11[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT11_0_MBSSIDEXT11_0_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT11_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT11_0_MBSSIDEXT11_0_MASK       0xFFFFFFFF                // MBSSIDEXT11_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT11_0_MBSSIDEXT11_0_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT11_1 (0x820E5000 + 0x354)---

    MBSSIDEXT11_1[15..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_11[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT11_1_MBSSIDEXT11_1_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT11_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT11_1_MBSSIDEXT11_1_MASK       0x0000FFFF                // MBSSIDEXT11_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT11_1_MBSSIDEXT11_1_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT12_0 (0x820E5000 + 0x358)---

    MBSSIDEXT12_0[31..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_12[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT12_0_MBSSIDEXT12_0_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT12_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT12_0_MBSSIDEXT12_0_MASK       0xFFFFFFFF                // MBSSIDEXT12_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT12_0_MBSSIDEXT12_0_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT12_1 (0x820E5000 + 0x35C)---

    MBSSIDEXT12_1[15..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_12[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT12_1_MBSSIDEXT12_1_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT12_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT12_1_MBSSIDEXT12_1_MASK       0x0000FFFF                // MBSSIDEXT12_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT12_1_MBSSIDEXT12_1_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT13_0 (0x820E5000 + 0x360)---

    MBSSIDEXT13_0[31..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_13[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT13_0_MBSSIDEXT13_0_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT13_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT13_0_MBSSIDEXT13_0_MASK       0xFFFFFFFF                // MBSSIDEXT13_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT13_0_MBSSIDEXT13_0_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT13_1 (0x820E5000 + 0x364)---

    MBSSIDEXT13_1[15..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_13[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT13_1_MBSSIDEXT13_1_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT13_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT13_1_MBSSIDEXT13_1_MASK       0x0000FFFF                // MBSSIDEXT13_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT13_1_MBSSIDEXT13_1_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT14_0 (0x820E5000 + 0x368)---

    MBSSIDEXT14_0[31..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_14[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT14_0_MBSSIDEXT14_0_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT14_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT14_0_MBSSIDEXT14_0_MASK       0xFFFFFFFF                // MBSSIDEXT14_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT14_0_MBSSIDEXT14_0_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT14_1 (0x820E5000 + 0x36C)---

    MBSSIDEXT14_1[15..0]         - (RW) Multiple BSSID extension CR 
                                     MBSSID_EXT_14[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT14_1_MBSSIDEXT14_1_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT14_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT14_1_MBSSIDEXT14_1_MASK       0x0000FFFF                // MBSSIDEXT14_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT14_1_MBSSIDEXT14_1_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT15_0 (0x820E5000 + 0x370)---

    MBSSIDEXT15_0[31..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_15[31:0]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT15_0_MBSSIDEXT15_0_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT15_0_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT15_0_MBSSIDEXT15_0_MASK       0xFFFFFFFF                // MBSSIDEXT15_0[31..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT15_0_MBSSIDEXT15_0_SHFT       0

/* =====================================================================================

  ---MBSSIDEXT15_1 (0x820E5000 + 0x374)---

    MBSSIDEXT15_1[15..0]         - (RW) Multiple BSSID extension CR
                                     MBSSID_EXT_15[47:32]

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MBSSIDEXT15_1_MBSSIDEXT15_1_ADDR       BN0_WF_RMAC_TOP_MBSSIDEXT15_1_ADDR
#define BN0_WF_RMAC_TOP_MBSSIDEXT15_1_MBSSIDEXT15_1_MASK       0x0000FFFF                // MBSSIDEXT15_1[15..0]
#define BN0_WF_RMAC_TOP_MBSSIDEXT15_1_MBSSIDEXT15_1_SHFT       0

/* =====================================================================================

  ---AIRTIME0 (0x820E5000 + 0x380)---

    OBSS_BACKOFF[15..0]          - (RW) Backoff threshold for OBSS.
                                     If (HW count backoff timer > this threshold), backoff time will use this CR. Otherwise use HW count backoff counter. Unit is 1.024us
    ED_OFFSET[20..16]            - (RW) SW compensation used. 
                                     Normal WIFI packet's duration of ED to CS for both CCK and OFDM. Unit is 1.024us
    N2ME_CTS_RSV_OBSS_EN[21]     - (RW) Count Not to Me CTS's NAV into OBSS airtime
                                     0 : Disable. Only count Not to Me CTS's airtime into OBSS
                                     1 : Enable. Also count yhe Not to Me CTS's Duration (NAV) into OBSS. (Not suggested if CTS2Self exists in the air)
    RESERVED22[29..22]           - (RO) Reserved bits
    RX_AIRTIME_EN[30]            - (RW) RX airtime enable
                                     0: Disable RX airtime function
                                     1: Enable RX airtime function, include non-wifi, OBSS and Per-STA timer.
    RX_AIRTIME_CLR[31]           - (RW) RX airtime clear
                                     Write 1 will clear RX airtime related timer, including 
                                     non-wifi  and OBSS timer
                                     Read will always 0.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME0_RX_AIRTIME_CLR_ADDR           BN0_WF_RMAC_TOP_AIRTIME0_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME0_RX_AIRTIME_CLR_MASK           0x80000000                // RX_AIRTIME_CLR[31]
#define BN0_WF_RMAC_TOP_AIRTIME0_RX_AIRTIME_CLR_SHFT           31
#define BN0_WF_RMAC_TOP_AIRTIME0_RX_AIRTIME_EN_ADDR            BN0_WF_RMAC_TOP_AIRTIME0_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME0_RX_AIRTIME_EN_MASK            0x40000000                // RX_AIRTIME_EN[30]
#define BN0_WF_RMAC_TOP_AIRTIME0_RX_AIRTIME_EN_SHFT            30
#define BN0_WF_RMAC_TOP_AIRTIME0_N2ME_CTS_RSV_OBSS_EN_ADDR     BN0_WF_RMAC_TOP_AIRTIME0_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME0_N2ME_CTS_RSV_OBSS_EN_MASK     0x00200000                // N2ME_CTS_RSV_OBSS_EN[21]
#define BN0_WF_RMAC_TOP_AIRTIME0_N2ME_CTS_RSV_OBSS_EN_SHFT     21
#define BN0_WF_RMAC_TOP_AIRTIME0_ED_OFFSET_ADDR                BN0_WF_RMAC_TOP_AIRTIME0_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME0_ED_OFFSET_MASK                0x001F0000                // ED_OFFSET[20..16]
#define BN0_WF_RMAC_TOP_AIRTIME0_ED_OFFSET_SHFT                16
#define BN0_WF_RMAC_TOP_AIRTIME0_OBSS_BACKOFF_ADDR             BN0_WF_RMAC_TOP_AIRTIME0_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME0_OBSS_BACKOFF_MASK             0x0000FFFF                // OBSS_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME0_OBSS_BACKOFF_SHFT             0

/* =====================================================================================

  ---AIRTIME1 (0x820E5000 + 0x384)---

    SW_OBSS_BAND0[7..0]          - (RW) SW compensation used.
                                     Write this CR with bit[8]=1 will add this value to Band0-OBSS timer
                                     Read will previous value. Unit is 1.024us
    SW_OBSS_BAND0_EN[8]          - (RW) SW compensation used.
                                     Read always 0.
                                     Write 1 will add [7:0] value to Band0-OBSS timer
    RESERVED9[31..9]             - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME1_SW_OBSS_BAND0_EN_ADDR         BN0_WF_RMAC_TOP_AIRTIME1_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME1_SW_OBSS_BAND0_EN_MASK         0x00000100                // SW_OBSS_BAND0_EN[8]
#define BN0_WF_RMAC_TOP_AIRTIME1_SW_OBSS_BAND0_EN_SHFT         8
#define BN0_WF_RMAC_TOP_AIRTIME1_SW_OBSS_BAND0_ADDR            BN0_WF_RMAC_TOP_AIRTIME1_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME1_SW_OBSS_BAND0_MASK            0x000000FF                // SW_OBSS_BAND0[7..0]
#define BN0_WF_RMAC_TOP_AIRTIME1_SW_OBSS_BAND0_SHFT            0

/* =====================================================================================

  ---AIRTIME2 (0x820E5000 + 0x388)---

    SW_NONWIFI_BAND0[7..0]       - (RW) SW compensation used.
                                     Write this CR with bit[8]=1 will add this value to Band0-NONWIFI timer
                                     Read will previous value. Unit is 1.024us
    SW_NONWIFI_BAND0_EN[8]       - (RW) SW compensation used.
                                     Read always 0.
                                     Write 1 will add [7:0] value to Band0-NONWIFI timer
    RESERVED9[31..9]             - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME2_SW_NONWIFI_BAND0_EN_ADDR      BN0_WF_RMAC_TOP_AIRTIME2_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME2_SW_NONWIFI_BAND0_EN_MASK      0x00000100                // SW_NONWIFI_BAND0_EN[8]
#define BN0_WF_RMAC_TOP_AIRTIME2_SW_NONWIFI_BAND0_EN_SHFT      8
#define BN0_WF_RMAC_TOP_AIRTIME2_SW_NONWIFI_BAND0_ADDR         BN0_WF_RMAC_TOP_AIRTIME2_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME2_SW_NONWIFI_BAND0_MASK         0x000000FF                // SW_NONWIFI_BAND0[7..0]
#define BN0_WF_RMAC_TOP_AIRTIME2_SW_NONWIFI_BAND0_SHFT         0

/* =====================================================================================

  ---AIRTIME3 (0x820E5000 + 0x38C)---

    WMM0_QID0_BACKOFF[15..0]     - (RW) RX airtime CR
                                     WMM0 QID0 backoff time. 
                                     Unit is 1.024us
    WMM0_QID1_BACKOFF[31..16]    - (RW) RX airtime CR
                                     WMM0 QID1 backoff time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME3_WMM0_QID1_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME3_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME3_WMM0_QID1_BACKOFF_MASK        0xFFFF0000                // WMM0_QID1_BACKOFF[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME3_WMM0_QID1_BACKOFF_SHFT        16
#define BN0_WF_RMAC_TOP_AIRTIME3_WMM0_QID0_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME3_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME3_WMM0_QID0_BACKOFF_MASK        0x0000FFFF                // WMM0_QID0_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME3_WMM0_QID0_BACKOFF_SHFT        0

/* =====================================================================================

  ---AIRTIME4 (0x820E5000 + 0x390)---

    WMM0_QID2_BACKOFF[15..0]     - (RW) RX airtime CR
                                     WMM0 QID2 backoff time. 
                                     Unit is 1.024us
    WMM0_QID3_BACKOFF[31..16]    - (RW) RX airtime CR
                                     WMM0 QID3 backoff time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME4_WMM0_QID3_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME4_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME4_WMM0_QID3_BACKOFF_MASK        0xFFFF0000                // WMM0_QID3_BACKOFF[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME4_WMM0_QID3_BACKOFF_SHFT        16
#define BN0_WF_RMAC_TOP_AIRTIME4_WMM0_QID2_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME4_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME4_WMM0_QID2_BACKOFF_MASK        0x0000FFFF                // WMM0_QID2_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME4_WMM0_QID2_BACKOFF_SHFT        0

/* =====================================================================================

  ---AIRTIME5 (0x820E5000 + 0x394)---

    WMM1_QID0_BACKOFF[15..0]     - (RW) RX airtime CR
                                     WMM1 QID0 backoff time. 
                                     Unit is 1.024us
    WMM1_QID1_BACKOFF[31..16]    - (RW) RX airtime CR
                                     WMM1 QID1 backoff time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME5_WMM1_QID1_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME5_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME5_WMM1_QID1_BACKOFF_MASK        0xFFFF0000                // WMM1_QID1_BACKOFF[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME5_WMM1_QID1_BACKOFF_SHFT        16
#define BN0_WF_RMAC_TOP_AIRTIME5_WMM1_QID0_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME5_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME5_WMM1_QID0_BACKOFF_MASK        0x0000FFFF                // WMM1_QID0_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME5_WMM1_QID0_BACKOFF_SHFT        0

/* =====================================================================================

  ---AIRTIME6 (0x820E5000 + 0x398)---

    WMM1_QID2_BACKOFF[15..0]     - (RW) RX airtime CR
                                     WMM1 QID2 backoff time. 
                                     Unit is 1.024us
    WMM1_QID3_BACKOFF[31..16]    - (RW) RX airtime CR
                                     WMM1 QID3 backoff time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME6_WMM1_QID3_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME6_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME6_WMM1_QID3_BACKOFF_MASK        0xFFFF0000                // WMM1_QID3_BACKOFF[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME6_WMM1_QID3_BACKOFF_SHFT        16
#define BN0_WF_RMAC_TOP_AIRTIME6_WMM1_QID2_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME6_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME6_WMM1_QID2_BACKOFF_MASK        0x0000FFFF                // WMM1_QID2_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME6_WMM1_QID2_BACKOFF_SHFT        0

/* =====================================================================================

  ---AIRTIME7 (0x820E5000 + 0x39C)---

    WMM2_QID0_BACKOFF[15..0]     - (RW) RX airtime CR
                                     WMM2 QID0 backoff time. 
                                     Unit is 1.024us
    WMM2_QID1_BACKOFF[31..16]    - (RW) RX airtime CR
                                     WMM2 QID1 backoff time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME7_WMM2_QID1_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME7_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME7_WMM2_QID1_BACKOFF_MASK        0xFFFF0000                // WMM2_QID1_BACKOFF[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME7_WMM2_QID1_BACKOFF_SHFT        16
#define BN0_WF_RMAC_TOP_AIRTIME7_WMM2_QID0_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME7_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME7_WMM2_QID0_BACKOFF_MASK        0x0000FFFF                // WMM2_QID0_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME7_WMM2_QID0_BACKOFF_SHFT        0

/* =====================================================================================

  ---AIRTIME8 (0x820E5000 + 0x3A0)---

    WMM2_QID2_BACKOFF[15..0]     - (RW) RX airtime CR
                                     WMM2 QID2 backoff time. 
                                     Unit is 1.024us
    WMM2_QID3_BACKOFF[31..16]    - (RW) RX airtime CR
                                     WMM2 QID3 backoff time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME8_WMM2_QID3_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME8_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME8_WMM2_QID3_BACKOFF_MASK        0xFFFF0000                // WMM2_QID3_BACKOFF[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME8_WMM2_QID3_BACKOFF_SHFT        16
#define BN0_WF_RMAC_TOP_AIRTIME8_WMM2_QID2_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME8_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME8_WMM2_QID2_BACKOFF_MASK        0x0000FFFF                // WMM2_QID2_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME8_WMM2_QID2_BACKOFF_SHFT        0

/* =====================================================================================

  ---AIRTIME9 (0x820E5000 + 0x3A4)---

    WMM3_QID0_BACKOFF[15..0]     - (RW) RX airtime CR
                                     WMM3 QID0 backoff time. 
                                     Unit is 1.024us
    WMM3_QID1_BACKOFF[31..16]    - (RW) RX airtime CR
                                     WMM3 QID1 backoff time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME9_WMM3_QID1_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME9_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME9_WMM3_QID1_BACKOFF_MASK        0xFFFF0000                // WMM3_QID1_BACKOFF[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME9_WMM3_QID1_BACKOFF_SHFT        16
#define BN0_WF_RMAC_TOP_AIRTIME9_WMM3_QID0_BACKOFF_ADDR        BN0_WF_RMAC_TOP_AIRTIME9_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME9_WMM3_QID0_BACKOFF_MASK        0x0000FFFF                // WMM3_QID0_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME9_WMM3_QID0_BACKOFF_SHFT        0

/* =====================================================================================

  ---AIRTIME10 (0x820E5000 + 0x3A8)---

    WMM3_QID2_BACKOFF[15..0]     - (RW) RX airtime CR
                                     WMM3 QID2 backoff time. 
                                     Unit is 1.024us
    WMM3_QID3_BACKOFF[31..16]    - (RW) RX airtime CR
                                     WMM3 QID3 backoff time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME10_WMM3_QID3_BACKOFF_ADDR       BN0_WF_RMAC_TOP_AIRTIME10_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME10_WMM3_QID3_BACKOFF_MASK       0xFFFF0000                // WMM3_QID3_BACKOFF[31..16]
#define BN0_WF_RMAC_TOP_AIRTIME10_WMM3_QID3_BACKOFF_SHFT       16
#define BN0_WF_RMAC_TOP_AIRTIME10_WMM3_QID2_BACKOFF_ADDR       BN0_WF_RMAC_TOP_AIRTIME10_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME10_WMM3_QID2_BACKOFF_MASK       0x0000FFFF                // WMM3_QID2_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME10_WMM3_QID2_BACKOFF_SHFT       0

/* =====================================================================================

  ---AIRTIME11 (0x820E5000 + 0x3AC)---

    NONQOSD_BACKOFF[15..0]       - (RW) RX airtime CR
                                     Non-QoS data backoff time. 
                                     Unit is 1.024us
    STA00to03_WMM_SEL[19..16]    - (RW) For OMAC00to03 WMM selection
                                     bit0 is 0 to sel WMM_STA's parameter for OM0
                                     bit0 is 1 to sel WMM00to03 parameter for OM0
                                     bit1 is 0 to sel WMM_STA's parameter for OM1
                                     bit1 is 1 to sel WMM00to03 parameter for OM1
                                     bit2 is 0 to sel WMM_STA's parameter for OM2
                                     bit2 is 1 to sel WMM00to03 parameter for OM2
                                     bit3 is 0 to sel WMM_STA's parameter for OM3
                                     bit3 is 1 to sel WMM00to03 parameter for OM3
    RESERVED20[31..20]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME11_STA00to03_WMM_SEL_ADDR       BN0_WF_RMAC_TOP_AIRTIME11_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME11_STA00to03_WMM_SEL_MASK       0x000F0000                // STA00to03_WMM_SEL[19..16]
#define BN0_WF_RMAC_TOP_AIRTIME11_STA00to03_WMM_SEL_SHFT       16
#define BN0_WF_RMAC_TOP_AIRTIME11_NONQOSD_BACKOFF_ADDR         BN0_WF_RMAC_TOP_AIRTIME11_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME11_NONQOSD_BACKOFF_MASK         0x0000FFFF                // NONQOSD_BACKOFF[15..0]
#define BN0_WF_RMAC_TOP_AIRTIME11_NONQOSD_BACKOFF_SHFT         0

/* =====================================================================================

  ---AIRTIME12 (0x820E5000 + 0x3B0)---

    MBSSID_WMM_SEL[31..0]        - (RW) For MBSSID WMM selection
                                     bit1~bit0: for MBSSID0_0 WMM_QID selection
                                     2'd0 is select WMM0 QID parameter
                                     2'd1 is select WMM1 QID parameter
                                     2'd2 is select WMM2 QID parameter
                                     2'd3 is select WMM3 QID parameter
                                     bit3~bit2: for MBSSID0_1 WMM_QID selection
                                     2'd0 is select WMM0 QID parameter
                                     2'd1 is select WMM1 QID parameter
                                     2'd2 is select WMM2 QID parameter
                                     2'd3 is select WMM3 QID parameter
                                     etc.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME12_MBSSID_WMM_SEL_ADDR          BN0_WF_RMAC_TOP_AIRTIME12_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME12_MBSSID_WMM_SEL_MASK          0xFFFFFFFF                // MBSSID_WMM_SEL[31..0]
#define BN0_WF_RMAC_TOP_AIRTIME12_MBSSID_WMM_SEL_SHFT          0

/* =====================================================================================

  ---AIRTIME13 (0x820E5000 + 0x3B4)---

    RX0_AIRTIME_NONWIFI[20..0]   - (RO) Band0 RX airtime - nonwifi part.
                                     Will not increase when this timer larger than 21'hFFFFF.
                                     Read will clear this timer.
    RESERVED21[31..21]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME13_RX0_AIRTIME_NONWIFI_ADDR     BN0_WF_RMAC_TOP_AIRTIME13_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME13_RX0_AIRTIME_NONWIFI_MASK     0x001FFFFF                // RX0_AIRTIME_NONWIFI[20..0]
#define BN0_WF_RMAC_TOP_AIRTIME13_RX0_AIRTIME_NONWIFI_SHFT     0

/* =====================================================================================

  ---AIRTIME14 (0x820E5000 + 0x3B8)---

    RX0_AIRTIME_OBSS[20..0]      - (RO) Band0 RX airtime - OBSS part
                                     Will not increase when this timer larger than 21'hFFFFF.
                                     Read will clear this timer.
    RESERVED21[31..21]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_AIRTIME14_RX0_AIRTIME_OBSS_ADDR        BN0_WF_RMAC_TOP_AIRTIME14_ADDR
#define BN0_WF_RMAC_TOP_AIRTIME14_RX0_AIRTIME_OBSS_MASK        0x001FFFFF                // RX0_AIRTIME_OBSS[20..0]
#define BN0_WF_RMAC_TOP_AIRTIME14_RX0_AIRTIME_OBSS_SHFT        0

/* =====================================================================================

  ---MIBTIME0 (0x820E5000 + 0x3C4)---

    NONQOSD_IFS[7..0]            - (RW) RX mib time CR
                                     IFS for NONQOSD. 
                                     Unit is 1.024us
    OBSS_IFS[15..8]              - (RW) RX mib time CR
                                     IFS for OBSS. 
                                     Unit is 1.024us
    RESERVED16[29..16]           - (RO) Reserved bits
    RX_MIBTIME_EN[30]            - (RW) Enable RX airtime function, include OBSS and Per-STA timer.
                                     0: Disable
                                     1: Enable
    RX_MIBTIME_CLR[31]           - (RW) RX mib time clear
                                     Write 1 will clear OBSS airtime timer
                                     Read will always 0.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME0_RX_MIBTIME_CLR_ADDR           BN0_WF_RMAC_TOP_MIBTIME0_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME0_RX_MIBTIME_CLR_MASK           0x80000000                // RX_MIBTIME_CLR[31]
#define BN0_WF_RMAC_TOP_MIBTIME0_RX_MIBTIME_CLR_SHFT           31
#define BN0_WF_RMAC_TOP_MIBTIME0_RX_MIBTIME_EN_ADDR            BN0_WF_RMAC_TOP_MIBTIME0_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME0_RX_MIBTIME_EN_MASK            0x40000000                // RX_MIBTIME_EN[30]
#define BN0_WF_RMAC_TOP_MIBTIME0_RX_MIBTIME_EN_SHFT            30
#define BN0_WF_RMAC_TOP_MIBTIME0_OBSS_IFS_ADDR                 BN0_WF_RMAC_TOP_MIBTIME0_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME0_OBSS_IFS_MASK                 0x0000FF00                // OBSS_IFS[15..8]
#define BN0_WF_RMAC_TOP_MIBTIME0_OBSS_IFS_SHFT                 8
#define BN0_WF_RMAC_TOP_MIBTIME0_NONQOSD_IFS_ADDR              BN0_WF_RMAC_TOP_MIBTIME0_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME0_NONQOSD_IFS_MASK              0x000000FF                // NONQOSD_IFS[7..0]
#define BN0_WF_RMAC_TOP_MIBTIME0_NONQOSD_IFS_SHFT              0

/* =====================================================================================

  ---MIBTIME1 (0x820E5000 + 0x3C8)---

    WMM0_QID0_IFS[7..0]          - (RW) RX mib time CR
                                     WMM0 QID0 IFS time. 
                                     Unit is 1.024us
    WMM0_QID1_IFS[15..8]         - (RW) RX mib time CR
                                     WMM0 QID1 IFS time. 
                                     Unit is 1.024us
    WMM0_QID2_IFS[23..16]        - (RW) RX mib time CR
                                     WMM0 QID2 IFS time. 
                                     Unit is 1.024us
    WMM0_QID3_IFS[31..24]        - (RW) RX mib time CR
                                     WMM0 QID3 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID3_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME1_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID3_IFS_MASK            0xFF000000                // WMM0_QID3_IFS[31..24]
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID3_IFS_SHFT            24
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID2_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME1_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID2_IFS_MASK            0x00FF0000                // WMM0_QID2_IFS[23..16]
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID2_IFS_SHFT            16
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID1_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME1_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID1_IFS_MASK            0x0000FF00                // WMM0_QID1_IFS[15..8]
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID1_IFS_SHFT            8
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID0_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME1_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID0_IFS_MASK            0x000000FF                // WMM0_QID0_IFS[7..0]
#define BN0_WF_RMAC_TOP_MIBTIME1_WMM0_QID0_IFS_SHFT            0

/* =====================================================================================

  ---MIBTIME2 (0x820E5000 + 0x3CC)---

    WMM1_QID0_IFS[7..0]          - (RW) RX mib time CR
                                     WMM1 QID0 IFS time. 
                                     Unit is 1.024us
    WMM1_QID1_IFS[15..8]         - (RW) RX mib time CR
                                     WMM1 QID1 IFS time. 
                                     Unit is 1.024us
    WMM1_QID2_IFS[23..16]        - (RW) RX mib time CR
                                     WMM1 QID2 IFS time. 
                                     Unit is 1.024us
    WMM1_QID3_IFS[31..24]        - (RW) RX mib time CR
                                     WMM1 QID3 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID3_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME2_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID3_IFS_MASK            0xFF000000                // WMM1_QID3_IFS[31..24]
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID3_IFS_SHFT            24
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID2_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME2_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID2_IFS_MASK            0x00FF0000                // WMM1_QID2_IFS[23..16]
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID2_IFS_SHFT            16
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID1_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME2_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID1_IFS_MASK            0x0000FF00                // WMM1_QID1_IFS[15..8]
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID1_IFS_SHFT            8
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID0_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME2_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID0_IFS_MASK            0x000000FF                // WMM1_QID0_IFS[7..0]
#define BN0_WF_RMAC_TOP_MIBTIME2_WMM1_QID0_IFS_SHFT            0

/* =====================================================================================

  ---MIBTIME3 (0x820E5000 + 0x3D0)---

    WMM2_QID0_IFS[7..0]          - (RW) RX mib time CR
                                     WMM2 QID0 IFS time. 
                                     Unit is 1.024us
    WMM2_QID1_IFS[15..8]         - (RW) RX mib time CR
                                     WMM2 QID1 IFS time. 
                                     Unit is 1.024us
    WMM2_QID2_IFS[23..16]        - (RW) RX mib time CR
                                     WMM2 QID2 IFS time. 
                                     Unit is 1.024us
    WMM2_QID3_IFS[31..24]        - (RW) RX mib time CR
                                     WMM2 QID3 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID3_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME3_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID3_IFS_MASK            0xFF000000                // WMM2_QID3_IFS[31..24]
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID3_IFS_SHFT            24
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID2_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME3_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID2_IFS_MASK            0x00FF0000                // WMM2_QID2_IFS[23..16]
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID2_IFS_SHFT            16
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID1_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME3_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID1_IFS_MASK            0x0000FF00                // WMM2_QID1_IFS[15..8]
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID1_IFS_SHFT            8
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID0_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME3_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID0_IFS_MASK            0x000000FF                // WMM2_QID0_IFS[7..0]
#define BN0_WF_RMAC_TOP_MIBTIME3_WMM2_QID0_IFS_SHFT            0

/* =====================================================================================

  ---MIBTIME4 (0x820E5000 + 0x3D4)---

    WMM3_QID0_IFS[7..0]          - (RW) RX mib time CR
                                     WMM3 QID0 IFS time. 
                                     Unit is 1.024us
    WMM3_QID1_IFS[15..8]         - (RW) RX mib time CR
                                     WMM3 QID1 IFS time. 
                                     Unit is 1.024us
    WMM3_QID2_IFS[23..16]        - (RW) RX mib time CR
                                     WMM3 QID2 IFS time. 
                                     Unit is 1.024us
    WMM3_QID3_IFS[31..24]        - (RW) RX mib time CR
                                     WMM3 QID3 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID3_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME4_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID3_IFS_MASK            0xFF000000                // WMM3_QID3_IFS[31..24]
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID3_IFS_SHFT            24
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID2_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME4_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID2_IFS_MASK            0x00FF0000                // WMM3_QID2_IFS[23..16]
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID2_IFS_SHFT            16
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID1_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME4_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID1_IFS_MASK            0x0000FF00                // WMM3_QID1_IFS[15..8]
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID1_IFS_SHFT            8
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID0_IFS_ADDR            BN0_WF_RMAC_TOP_MIBTIME4_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID0_IFS_MASK            0x000000FF                // WMM3_QID0_IFS[7..0]
#define BN0_WF_RMAC_TOP_MIBTIME4_WMM3_QID0_IFS_SHFT            0

/* =====================================================================================

  ---MIBTIME5 (0x820E5000 + 0x3D8)---

    AIRTIME_OBSS_Band0[23..0]    - (RO) RX mib time CR
                                     OBSS airtime for Band0
    RESERVED24[31..24]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME5_AIRTIME_OBSS_Band0_ADDR       BN0_WF_RMAC_TOP_MIBTIME5_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME5_AIRTIME_OBSS_Band0_MASK       0x00FFFFFF                // AIRTIME_OBSS_Band0[23..0]
#define BN0_WF_RMAC_TOP_MIBTIME5_AIRTIME_OBSS_Band0_SHFT       0

/* =====================================================================================

  ---MIBTIME7 (0x820E5000 + 0x3E0)---

    WMM_RPTER_QID0_IFS[7..0]     - (RW) RX mib time CR
                                     WMM Repeater QID0 IFS time. 
                                     Unit is 1.024us
    WMM_RPTER_QID1_IFS[15..8]    - (RW) RX mib time CR
                                     WMM Repeater QID1 IFS time. 
                                     Unit is 1.024us
    WMM_RPTER_QID2_IFS[23..16]   - (RW) RX mib time CR
                                     WMM Repeater QID2 IFS time. 
                                     Unit is 1.024us
    WMM_RPTER_QID3_IFS[31..24]   - (RW) RX mib time CR
                                     WMM Repeater QID3 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID3_IFS_ADDR       BN0_WF_RMAC_TOP_MIBTIME7_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID3_IFS_MASK       0xFF000000                // WMM_RPTER_QID3_IFS[31..24]
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID3_IFS_SHFT       24
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID2_IFS_ADDR       BN0_WF_RMAC_TOP_MIBTIME7_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID2_IFS_MASK       0x00FF0000                // WMM_RPTER_QID2_IFS[23..16]
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID2_IFS_SHFT       16
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID1_IFS_ADDR       BN0_WF_RMAC_TOP_MIBTIME7_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID1_IFS_MASK       0x0000FF00                // WMM_RPTER_QID1_IFS[15..8]
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID1_IFS_SHFT       8
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID0_IFS_ADDR       BN0_WF_RMAC_TOP_MIBTIME7_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID0_IFS_MASK       0x000000FF                // WMM_RPTER_QID0_IFS[7..0]
#define BN0_WF_RMAC_TOP_MIBTIME7_WMM_RPTER_QID0_IFS_SHFT       0

/* =====================================================================================

  ---MIBTIME8 (0x820E5000 + 0x3E4)---

    WMM_STA00to03_QID0_IFS[7..0] - (RW) RX mib time CR
                                     WMM 00 to 03 QID0 IFS time. 
                                     Unit is 1.024us
    WMM_STA00to03_QID1_IFS[15..8] - (RW) RX mib time CR
                                     WMM 00 to 03 QID1 IFS time. 
                                     Unit is 1.024us
    WMM_STA00to03_QID2_IFS[23..16] - (RW) RX mib time CR
                                     WMM 00 to 03 QID2 IFS time. 
                                     Unit is 1.024us
    WMM_STA00to03_QID3_IFS[31..24] - (RW) RX mib time CR
                                     WMM 00 to 03 QID3 IFS time. 
                                     Unit is 1.024us

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID3_IFS_ADDR   BN0_WF_RMAC_TOP_MIBTIME8_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID3_IFS_MASK   0xFF000000                // WMM_STA00to03_QID3_IFS[31..24]
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID3_IFS_SHFT   24
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID2_IFS_ADDR   BN0_WF_RMAC_TOP_MIBTIME8_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID2_IFS_MASK   0x00FF0000                // WMM_STA00to03_QID2_IFS[23..16]
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID2_IFS_SHFT   16
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID1_IFS_ADDR   BN0_WF_RMAC_TOP_MIBTIME8_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID1_IFS_MASK   0x0000FF00                // WMM_STA00to03_QID1_IFS[15..8]
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID1_IFS_SHFT   8
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID0_IFS_ADDR   BN0_WF_RMAC_TOP_MIBTIME8_ADDR
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID0_IFS_MASK   0x000000FF                // WMM_STA00to03_QID0_IFS[7..0]
#define BN0_WF_RMAC_TOP_MIBTIME8_WMM_STA00to03_QID0_IFS_SHFT   0

/* =====================================================================================

  ---CFOBSS0 (0x820E5000 + 0x3EC)---

    CFO_VALUE_BSS0[19..0]        - (RO) CFO value
    RESERVED20[30..20]           - (RO) Reserved bits
    CFO_VLD_BSS0[31]             - (RO) CFO value is valid

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CFOBSS0_CFO_VLD_BSS0_ADDR              BN0_WF_RMAC_TOP_CFOBSS0_ADDR
#define BN0_WF_RMAC_TOP_CFOBSS0_CFO_VLD_BSS0_MASK              0x80000000                // CFO_VLD_BSS0[31]
#define BN0_WF_RMAC_TOP_CFOBSS0_CFO_VLD_BSS0_SHFT              31
#define BN0_WF_RMAC_TOP_CFOBSS0_CFO_VALUE_BSS0_ADDR            BN0_WF_RMAC_TOP_CFOBSS0_ADDR
#define BN0_WF_RMAC_TOP_CFOBSS0_CFO_VALUE_BSS0_MASK            0x000FFFFF                // CFO_VALUE_BSS0[19..0]
#define BN0_WF_RMAC_TOP_CFOBSS0_CFO_VALUE_BSS0_SHFT            0

/* =====================================================================================

  ---CFOBSS1 (0x820E5000 + 0x3F0)---

    CFO_VALUE_BSS1[19..0]        - (RO) CFO value
    RESERVED20[30..20]           - (RO) Reserved bits
    CFO_VLD_BSS1[31]             - (RO) CFO value is valid

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CFOBSS1_CFO_VLD_BSS1_ADDR              BN0_WF_RMAC_TOP_CFOBSS1_ADDR
#define BN0_WF_RMAC_TOP_CFOBSS1_CFO_VLD_BSS1_MASK              0x80000000                // CFO_VLD_BSS1[31]
#define BN0_WF_RMAC_TOP_CFOBSS1_CFO_VLD_BSS1_SHFT              31
#define BN0_WF_RMAC_TOP_CFOBSS1_CFO_VALUE_BSS1_ADDR            BN0_WF_RMAC_TOP_CFOBSS1_ADDR
#define BN0_WF_RMAC_TOP_CFOBSS1_CFO_VALUE_BSS1_MASK            0x000FFFFF                // CFO_VALUE_BSS1[19..0]
#define BN0_WF_RMAC_TOP_CFOBSS1_CFO_VALUE_BSS1_SHFT            0

/* =====================================================================================

  ---CFOBSS2 (0x820E5000 + 0x3F4)---

    CFO_VALUE_BSS2[19..0]        - (RO) CFO value
    RESERVED20[30..20]           - (RO) Reserved bits
    CFO_VLD_BSS2[31]             - (RO) CFO value is valid

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CFOBSS2_CFO_VLD_BSS2_ADDR              BN0_WF_RMAC_TOP_CFOBSS2_ADDR
#define BN0_WF_RMAC_TOP_CFOBSS2_CFO_VLD_BSS2_MASK              0x80000000                // CFO_VLD_BSS2[31]
#define BN0_WF_RMAC_TOP_CFOBSS2_CFO_VLD_BSS2_SHFT              31
#define BN0_WF_RMAC_TOP_CFOBSS2_CFO_VALUE_BSS2_ADDR            BN0_WF_RMAC_TOP_CFOBSS2_ADDR
#define BN0_WF_RMAC_TOP_CFOBSS2_CFO_VALUE_BSS2_MASK            0x000FFFFF                // CFO_VALUE_BSS2[19..0]
#define BN0_WF_RMAC_TOP_CFOBSS2_CFO_VALUE_BSS2_SHFT            0

/* =====================================================================================

  ---CFOBSS3 (0x820E5000 + 0x3F8)---

    CFO_VALUE_BSS3[19..0]        - (RO) CFO value
    RESERVED20[30..20]           - (RO) Reserved bits
    CFO_VLD_BSS3[31]             - (RO) CFO value is valid

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_CFOBSS3_CFO_VLD_BSS3_ADDR              BN0_WF_RMAC_TOP_CFOBSS3_ADDR
#define BN0_WF_RMAC_TOP_CFOBSS3_CFO_VLD_BSS3_MASK              0x80000000                // CFO_VLD_BSS3[31]
#define BN0_WF_RMAC_TOP_CFOBSS3_CFO_VLD_BSS3_SHFT              31
#define BN0_WF_RMAC_TOP_CFOBSS3_CFO_VALUE_BSS3_ADDR            BN0_WF_RMAC_TOP_CFOBSS3_ADDR
#define BN0_WF_RMAC_TOP_CFOBSS3_CFO_VALUE_BSS3_MASK            0x000FFFFF                // CFO_VALUE_BSS3[19..0]
#define BN0_WF_RMAC_TOP_CFOBSS3_CFO_VALUE_BSS3_SHFT            0

/* =====================================================================================

  ---RCPI0 (0x820E5000 + 0x4A0)---

    RCPI_CCK_LOW_THRESHOLD0[9..0] - (RW) This unsigned value is the low RCPI CCK threshold to generate interrupt, typically 0~255*3 of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
    RESERVED10[10]               - (RO) Reserved bits
    RCPI_MODE_BSS0[13..11]       - (RW) Indicates 4 antenna with 6 different Interrupt mode for BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     3'h0: ant0 only (source : RCPI0 in Rx vector)
                                     3'h1: ant1 only (source : RCPI1 in Rx vector)
                                     3'h2: ant2 only (source : RCPI2 in Rx vector)
                                     3'h3: ant3 only (source : RCPI3 in Rx vector)
                                     3'h4: ant0 + ant1 + ant2 + ant3
                                     3'h5: max (ant0, ant1, ant2, ant3)
    RCPI_MOVING_AVERAGE_PARAMETER0[15..14] - (RW) Sets up parameter for moving average RCPI of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     Formula: y(n)=(1-arfa)*y(n-1)+arfa*x(n), arfa<=1
                                     y(n): New moving average RCPI value
                                     y(n-1): Last moving average RCPI value
                                     x(n): RCPI value from BB when Beacon is received
                                     When the RCPI value from BB is 255, it means RCPI value is invalid and will not process RCPI moving average.
                                     2'b00: arfa = 1/16
                                     2'b01: arfa = 1/8
                                     2'b10: arfa = 1/4
                                     2'b11: arfa = 1
    RCPI_CCK_HIGH_THRESHOLD0[25..16] - (RW) This unsigned value is the high RCPI CCK threshold to generate interrupt, typically 0~255*3 of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
    RCPI_BSS_SOURCE0[27..26]     - (RW) Indicate the BSSID source of packet for RCPI moving average.
                                     2'd0: BSSID0
                                     2'd1: BSSID1
                                     2'd2: BSSID2
                                     2'd3: BSSID3
    RCPI_SOURCE0[30..28]         - (RW) Indicates frame type with correct FCS32 from BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     3'b001: All Unicast Data frames (A1 is equal to effective Own MAC 0 or 1 or 2) from BSSID 0 with correct FCS32
                                     3'b010: All Beacon frames from BSSIx 0 with correct FCS32
                                     3'b011: All Beacon frames and Unicast Data frames (A1 is equal to effective Own MAC 0 or 1 or 2) from BSSIDx with correct FCS32.
                                     3'b1XX: All Data frames or Beacon frames from BSSIDx with correct FCS32
    MOVING_AVERAGE_ENABLE0[31]   - (RW) Enables moving average calculation for received beacon RCPI of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     Note: When setting RR.Moving_average_enable from 0 to 1, the first Beacon RCPI value will be set for initial RCPI value and will not show in RR1 until 2nd Beacon RCPI value is received.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RCPI0_MOVING_AVERAGE_ENABLE0_ADDR      BN0_WF_RMAC_TOP_RCPI0_ADDR
#define BN0_WF_RMAC_TOP_RCPI0_MOVING_AVERAGE_ENABLE0_MASK      0x80000000                // MOVING_AVERAGE_ENABLE0[31]
#define BN0_WF_RMAC_TOP_RCPI0_MOVING_AVERAGE_ENABLE0_SHFT      31
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_SOURCE0_ADDR                BN0_WF_RMAC_TOP_RCPI0_ADDR
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_SOURCE0_MASK                0x70000000                // RCPI_SOURCE0[30..28]
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_SOURCE0_SHFT                28
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_BSS_SOURCE0_ADDR            BN0_WF_RMAC_TOP_RCPI0_ADDR
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_BSS_SOURCE0_MASK            0x0C000000                // RCPI_BSS_SOURCE0[27..26]
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_BSS_SOURCE0_SHFT            26
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_CCK_HIGH_THRESHOLD0_ADDR    BN0_WF_RMAC_TOP_RCPI0_ADDR
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_CCK_HIGH_THRESHOLD0_MASK    0x03FF0000                // RCPI_CCK_HIGH_THRESHOLD0[25..16]
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_CCK_HIGH_THRESHOLD0_SHFT    16
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_MOVING_AVERAGE_PARAMETER0_ADDR BN0_WF_RMAC_TOP_RCPI0_ADDR
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_MOVING_AVERAGE_PARAMETER0_MASK 0x0000C000                // RCPI_MOVING_AVERAGE_PARAMETER0[15..14]
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_MOVING_AVERAGE_PARAMETER0_SHFT 14
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_MODE_BSS0_ADDR              BN0_WF_RMAC_TOP_RCPI0_ADDR
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_MODE_BSS0_MASK              0x00003800                // RCPI_MODE_BSS0[13..11]
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_MODE_BSS0_SHFT              11
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_CCK_LOW_THRESHOLD0_ADDR     BN0_WF_RMAC_TOP_RCPI0_ADDR
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_CCK_LOW_THRESHOLD0_MASK     0x000003FF                // RCPI_CCK_LOW_THRESHOLD0[9..0]
#define BN0_WF_RMAC_TOP_RCPI0_RCPI_CCK_LOW_THRESHOLD0_SHFT     0

/* =====================================================================================

  ---RCPI2 (0x820E5000 + 0x4A8)---

    RCPI_CCK_LOW_THRESHOLD1[9..0] - (RW) This unsigned value is the low RCPI CCK threshold to generate interrupt, typically 0~255*3 of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
    RESERVED10[10]               - (RO) Reserved bits
    RCPI_MODE_BSS1[13..11]       - (RW) Indicates 4 antenna with 6 different Interrupt mode for BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     3'h0: ant0 only (source : RCPI0 in Rx vector)
                                     3'h1: ant1 only (source : RCPI1 in Rx vector)
                                     3'h2: ant2 only (source : RCPI2 in Rx vector)
                                     3'h3: ant3 only (source : RCPI3 in Rx vector)
                                     3'h4: ant0 + ant1 + ant2 + ant3
                                     3'h5: max (ant0, ant1, ant2, ant3)
    RCPI_MOVING_AVERAGE_PARAMETER1[15..14] - (RW) Sets up parameter for moving average RCPI of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     Formula: y(n)=(1-arfa)*y(n-1)+arfa*x(n), arfa<=1
                                     y(n): New moving average RCPI value
                                     y(n-1): Last moving average RCPI value
                                     x(n): RCPI value from BB when Beacon is received
                                     When the RCPI value from BB is 255, it means RCPI value is invalid and will not process RCPI moving average.
                                     2'b00: arfa = 1/16
                                     2'b01: arfa = 1/8
                                     2'b10: arfa = 1/4
                                     2'b11: arfa = 1
    RCPI_CCK_HIGH_THRESHOLD1[25..16] - (RW) This unsigned value is the high RCPI CCK threshold to generate interrupt, typically 0~255*3 of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
    RCPI_BSS_SOURCE1[27..26]     - (RW) Indicate the BSSID source of packet for RCPI moving average.
                                     2'd0: BSSID0
                                     2'd1: BSSID1
                                     2'd2: BSSID2
                                     2'd3: BSSID3
    RCPI_SOURCE1[30..28]         - (RW) Indicates frame type with correct FCS32 from BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     3'b001: All Unicast Data frames (A1 is equal to effective Own MAC 0 or 1 or 2) from BSSID 0 with correct FCS32
                                     3'b010: All Beacon frames from BSSIx 0 with correct FCS32
                                     3'b011: All Beacon frames and Unicast Data frames (A1 is equal to effective Own MAC 0 or 1 or 2) from BSSIDx with correct FCS32.
                                     3'b1XX: All Data frames or Beacon frames from BSSIDx with correct FCS32
    MOVING_AVERAGE_ENABLE1[31]   - (RW) Enables moving average calculation for received beacon RCPI of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     Note: When setting RR.Moving_average_enable from 0 to 1, the first Beacon RCPI value will be set for initial RCPI value and will not show in RR1 until 2nd Beacon RCPI value is received.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RCPI2_MOVING_AVERAGE_ENABLE1_ADDR      BN0_WF_RMAC_TOP_RCPI2_ADDR
#define BN0_WF_RMAC_TOP_RCPI2_MOVING_AVERAGE_ENABLE1_MASK      0x80000000                // MOVING_AVERAGE_ENABLE1[31]
#define BN0_WF_RMAC_TOP_RCPI2_MOVING_AVERAGE_ENABLE1_SHFT      31
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_SOURCE1_ADDR                BN0_WF_RMAC_TOP_RCPI2_ADDR
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_SOURCE1_MASK                0x70000000                // RCPI_SOURCE1[30..28]
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_SOURCE1_SHFT                28
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_BSS_SOURCE1_ADDR            BN0_WF_RMAC_TOP_RCPI2_ADDR
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_BSS_SOURCE1_MASK            0x0C000000                // RCPI_BSS_SOURCE1[27..26]
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_BSS_SOURCE1_SHFT            26
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_CCK_HIGH_THRESHOLD1_ADDR    BN0_WF_RMAC_TOP_RCPI2_ADDR
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_CCK_HIGH_THRESHOLD1_MASK    0x03FF0000                // RCPI_CCK_HIGH_THRESHOLD1[25..16]
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_CCK_HIGH_THRESHOLD1_SHFT    16
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_MOVING_AVERAGE_PARAMETER1_ADDR BN0_WF_RMAC_TOP_RCPI2_ADDR
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_MOVING_AVERAGE_PARAMETER1_MASK 0x0000C000                // RCPI_MOVING_AVERAGE_PARAMETER1[15..14]
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_MOVING_AVERAGE_PARAMETER1_SHFT 14
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_MODE_BSS1_ADDR              BN0_WF_RMAC_TOP_RCPI2_ADDR
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_MODE_BSS1_MASK              0x00003800                // RCPI_MODE_BSS1[13..11]
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_MODE_BSS1_SHFT              11
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_CCK_LOW_THRESHOLD1_ADDR     BN0_WF_RMAC_TOP_RCPI2_ADDR
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_CCK_LOW_THRESHOLD1_MASK     0x000003FF                // RCPI_CCK_LOW_THRESHOLD1[9..0]
#define BN0_WF_RMAC_TOP_RCPI2_RCPI_CCK_LOW_THRESHOLD1_SHFT     0

/* =====================================================================================

  ---RCPI3 (0x820E5000 + 0x4AC)---

    RCPI_LOW_THRESHOLD0_OFDM[9..0] - (RW) This unsigned value is the low RCPI threshold to generate interrupt, typically 0~255 of BSSID0 (for OFDM).
    RESERVED10[15..10]           - (RO) Reserved bits
    RCPI_HIGH_THRESHOLD0_OFDM[25..16] - (RW) This unsigned value is the high RCPI threshold to generate interrupt, typically 0~255 of BSSID0 (for OFDM).
    RESERVED26[31..26]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RCPI3_RCPI_HIGH_THRESHOLD0_OFDM_ADDR   BN0_WF_RMAC_TOP_RCPI3_ADDR
#define BN0_WF_RMAC_TOP_RCPI3_RCPI_HIGH_THRESHOLD0_OFDM_MASK   0x03FF0000                // RCPI_HIGH_THRESHOLD0_OFDM[25..16]
#define BN0_WF_RMAC_TOP_RCPI3_RCPI_HIGH_THRESHOLD0_OFDM_SHFT   16
#define BN0_WF_RMAC_TOP_RCPI3_RCPI_LOW_THRESHOLD0_OFDM_ADDR    BN0_WF_RMAC_TOP_RCPI3_ADDR
#define BN0_WF_RMAC_TOP_RCPI3_RCPI_LOW_THRESHOLD0_OFDM_MASK    0x000003FF                // RCPI_LOW_THRESHOLD0_OFDM[9..0]
#define BN0_WF_RMAC_TOP_RCPI3_RCPI_LOW_THRESHOLD0_OFDM_SHFT    0

/* =====================================================================================

  ---RCPI4 (0x820E5000 + 0x4B0)---

    RCPI_CCK_LOW_THRESHOLD2[9..0] - (RW) This unsigned value is the low RCPI CCK threshold to generate interrupt, typically 0~255*3 of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
    RESERVED10[10]               - (RO) Reserved bits
    RCPI_MODE_BSS2[13..11]       - (RW) Indicates 4 antenna with 6 different Interrupt mode for BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     3'h0: ant0 only (source : RCPI0 in Rx vector)
                                     3'h1: ant1 only (source : RCPI1 in Rx vector)
                                     3'h2: ant2 only (source : RCPI2 in Rx vector)
                                     3'h3: ant3 only (source : RCPI3 in Rx vector)
                                     3'h4: ant0 + ant1 + ant2 + ant3
                                     3'h5: max (ant0, ant1, ant2, ant3)
    RCPI_MOVING_AVERAGE_PARAMETER2[15..14] - (RW) Sets up parameter for moving average RCPI of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     Formula: y(n)=(1-arfa)*y(n-1)+arfa*x(n), arfa<=1
                                     y(n): New moving average RCPI value
                                     y(n-1): Last moving average RCPI value
                                     x(n): RCPI value from BB when Beacon is received
                                     When the RCPI value from BB is 255, it means RCPI value is invalid and will not process RCPI moving average.
                                     2'b00: arfa = 1/16
                                     2'b01: arfa = 1/8
                                     2'b10: arfa = 1/4
                                     2'b11: arfa = 1
    RCPI_CCK_HIGH_THRESHOLD2[25..16] - (RW) This unsigned value is the high RCPI CCK threshold to generate interrupt, typically 0~255*3 of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
    RCPI_BSS_SOURCE2[27..26]     - (RW) Indicate the BSSID source of packet for RCPI moving average.
                                     2'd0: BSSID0
                                     2'd1: BSSID1
                                     2'd2: BSSID2
                                     2'd3: BSSID3
    RCPI_SOURCE2[30..28]         - (RW) Indicates frame type with correct FCS32 from BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     3'b001: All Unicast Data frames (A1 is equal to effective Own MAC 0 or 1 or 2) from BSSID 0 with correct FCS32
                                     3'b010: All Beacon frames from BSSIx 0 with correct FCS32
                                     3'b011: All Beacon frames and Unicast Data frames (A1 is equal to effective Own MAC 0 or 1 or 2) from BSSIDx with correct FCS32.
                                     3'b1XX: All Data frames or Beacon frames from BSSIDx with correct FCS32
    MOVING_AVERAGE_ENABLE2[31]   - (RW) Enables moving average calculation for received beacon RCPI of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     Note: When setting RR.Moving_average_enable from 0 to 1, the first Beacon RCPI value will be set for initial RCPI value and will not show in RR1 until 2nd Beacon RCPI value is received.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RCPI4_MOVING_AVERAGE_ENABLE2_ADDR      BN0_WF_RMAC_TOP_RCPI4_ADDR
#define BN0_WF_RMAC_TOP_RCPI4_MOVING_AVERAGE_ENABLE2_MASK      0x80000000                // MOVING_AVERAGE_ENABLE2[31]
#define BN0_WF_RMAC_TOP_RCPI4_MOVING_AVERAGE_ENABLE2_SHFT      31
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_SOURCE2_ADDR                BN0_WF_RMAC_TOP_RCPI4_ADDR
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_SOURCE2_MASK                0x70000000                // RCPI_SOURCE2[30..28]
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_SOURCE2_SHFT                28
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_BSS_SOURCE2_ADDR            BN0_WF_RMAC_TOP_RCPI4_ADDR
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_BSS_SOURCE2_MASK            0x0C000000                // RCPI_BSS_SOURCE2[27..26]
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_BSS_SOURCE2_SHFT            26
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_CCK_HIGH_THRESHOLD2_ADDR    BN0_WF_RMAC_TOP_RCPI4_ADDR
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_CCK_HIGH_THRESHOLD2_MASK    0x03FF0000                // RCPI_CCK_HIGH_THRESHOLD2[25..16]
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_CCK_HIGH_THRESHOLD2_SHFT    16
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_MOVING_AVERAGE_PARAMETER2_ADDR BN0_WF_RMAC_TOP_RCPI4_ADDR
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_MOVING_AVERAGE_PARAMETER2_MASK 0x0000C000                // RCPI_MOVING_AVERAGE_PARAMETER2[15..14]
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_MOVING_AVERAGE_PARAMETER2_SHFT 14
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_MODE_BSS2_ADDR              BN0_WF_RMAC_TOP_RCPI4_ADDR
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_MODE_BSS2_MASK              0x00003800                // RCPI_MODE_BSS2[13..11]
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_MODE_BSS2_SHFT              11
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_CCK_LOW_THRESHOLD2_ADDR     BN0_WF_RMAC_TOP_RCPI4_ADDR
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_CCK_LOW_THRESHOLD2_MASK     0x000003FF                // RCPI_CCK_LOW_THRESHOLD2[9..0]
#define BN0_WF_RMAC_TOP_RCPI4_RCPI_CCK_LOW_THRESHOLD2_SHFT     0

/* =====================================================================================

  ---RCPI6 (0x820E5000 + 0x4B8)---

    RCPI_CCK_LOW_THRESHOLD3[9..0] - (RW) This unsigned value is the low RCPI CCK threshold to generate interrupt, typically 0~255*3 of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
    RESERVED10[10]               - (RO) Reserved bits
    RCPI_MODE_BSS3[13..11]       - (RW) Indicates 4 antenna with 6 different Interrupt mode for BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     3'h0: ant0 only (source : RCPI0 in Rx vector)
                                     3'h1: ant1 only (source : RCPI1 in Rx vector)
                                     3'h2: ant2 only (source : RCPI2 in Rx vector)
                                     3'h3: ant3 only (source : RCPI3 in Rx vector)
                                     3'h4: ant0 + ant1 + ant2 + ant3
                                     3'h5: max (ant0, ant1, ant2, ant3)
    RCPI_MOVING_AVERAGE_PARAMETER3[15..14] - (RW) Sets up parameter for moving average RCPI of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     Formula: y(n)=(1-arfa)*y(n-1)+arfa*x(n), arfa<=1
                                     y(n): New moving average RCPI value
                                     y(n-1): Last moving average RCPI value
                                     x(n): RCPI value from BB when Beacon is received
                                     When the RCPI value from BB is 255, it means RCPI value is invalid and will not process RCPI moving average.
                                     2'b00: arfa = 1/16
                                     2'b01: arfa = 1/8
                                     2'b10: arfa = 1/4
                                     2'b11: arfa = 1
    RCPI_CCK_HIGH_THRESHOLD3[25..16] - (RW) This unsigned value is the high RCPI CCK threshold to generate interrupt, typically 0~255*3 of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
    RCPI_BSS_SOURCE3[27..26]     - (RW) Indicate the BSSID source of packet for RCPI moving average.
                                     2'd0: BSSID0
                                     2'd1: BSSID1
                                     2'd2: BSSID2
                                     2'd3: BSSID3
    RCPI_SOURCE3[30..28]         - (RW) Indicates frame type with correct FCS32 from BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     3'b001: All Unicast Data frames (A1 is equal to effective Own MAC 0 or 1 or 2) from BSSID 0 with correct FCS32
                                     3'b010: All Beacon frames from BSSIx 0 with correct FCS32
                                     3'b011: All Beacon frames and Unicast Data frames (A1 is equal to effective Own MAC 0 or 1 or 2) from BSSIDx with correct FCS32.
                                     3'b1XX: All Data frames or Beacon frames from BSSIDx with correct FCS32
    MOVING_AVERAGE_ENABLE3[31]   - (RW) Enables moving average calculation for received beacon RCPI of BSSIDx (BSSIDx depends on RCPI_BSS_SOURCE)
                                     Note: When setting RR.Moving_average_enable from 0 to 1, the first Beacon RCPI value will be set for initial RCPI value and will not show in RR1 until 2nd Beacon RCPI value is received.

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RCPI6_MOVING_AVERAGE_ENABLE3_ADDR      BN0_WF_RMAC_TOP_RCPI6_ADDR
#define BN0_WF_RMAC_TOP_RCPI6_MOVING_AVERAGE_ENABLE3_MASK      0x80000000                // MOVING_AVERAGE_ENABLE3[31]
#define BN0_WF_RMAC_TOP_RCPI6_MOVING_AVERAGE_ENABLE3_SHFT      31
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_SOURCE3_ADDR                BN0_WF_RMAC_TOP_RCPI6_ADDR
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_SOURCE3_MASK                0x70000000                // RCPI_SOURCE3[30..28]
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_SOURCE3_SHFT                28
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_BSS_SOURCE3_ADDR            BN0_WF_RMAC_TOP_RCPI6_ADDR
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_BSS_SOURCE3_MASK            0x0C000000                // RCPI_BSS_SOURCE3[27..26]
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_BSS_SOURCE3_SHFT            26
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_CCK_HIGH_THRESHOLD3_ADDR    BN0_WF_RMAC_TOP_RCPI6_ADDR
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_CCK_HIGH_THRESHOLD3_MASK    0x03FF0000                // RCPI_CCK_HIGH_THRESHOLD3[25..16]
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_CCK_HIGH_THRESHOLD3_SHFT    16
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_MOVING_AVERAGE_PARAMETER3_ADDR BN0_WF_RMAC_TOP_RCPI6_ADDR
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_MOVING_AVERAGE_PARAMETER3_MASK 0x0000C000                // RCPI_MOVING_AVERAGE_PARAMETER3[15..14]
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_MOVING_AVERAGE_PARAMETER3_SHFT 14
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_MODE_BSS3_ADDR              BN0_WF_RMAC_TOP_RCPI6_ADDR
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_MODE_BSS3_MASK              0x00003800                // RCPI_MODE_BSS3[13..11]
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_MODE_BSS3_SHFT              11
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_CCK_LOW_THRESHOLD3_ADDR     BN0_WF_RMAC_TOP_RCPI6_ADDR
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_CCK_LOW_THRESHOLD3_MASK     0x000003FF                // RCPI_CCK_LOW_THRESHOLD3[9..0]
#define BN0_WF_RMAC_TOP_RCPI6_RCPI_CCK_LOW_THRESHOLD3_SHFT     0

/* =====================================================================================

  ---RCPI7 (0x820E5000 + 0x4BC)---

    RCPI_LOW_THRESHOLD2_OFDM[9..0] - (RW) This unsigned value is the low RCPI threshold to generate interrupt, typically 0~255 of BSSID2 (for OFDM).
    RESERVED10[15..10]           - (RO) Reserved bits
    RCPI_HIGH_THRESHOLD2_OFDM[25..16] - (RW) This unsigned value is the high RCPI threshold to generate interrupt, typically 0~255 of BSSID2 (for OFDM).
    RESERVED26[31..26]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RCPI7_RCPI_HIGH_THRESHOLD2_OFDM_ADDR   BN0_WF_RMAC_TOP_RCPI7_ADDR
#define BN0_WF_RMAC_TOP_RCPI7_RCPI_HIGH_THRESHOLD2_OFDM_MASK   0x03FF0000                // RCPI_HIGH_THRESHOLD2_OFDM[25..16]
#define BN0_WF_RMAC_TOP_RCPI7_RCPI_HIGH_THRESHOLD2_OFDM_SHFT   16
#define BN0_WF_RMAC_TOP_RCPI7_RCPI_LOW_THRESHOLD2_OFDM_ADDR    BN0_WF_RMAC_TOP_RCPI7_ADDR
#define BN0_WF_RMAC_TOP_RCPI7_RCPI_LOW_THRESHOLD2_OFDM_MASK    0x000003FF                // RCPI_LOW_THRESHOLD2_OFDM[9..0]
#define BN0_WF_RMAC_TOP_RCPI7_RCPI_LOW_THRESHOLD2_OFDM_SHFT    0

/* =====================================================================================

  ---RCPI9 (0x820E5000 + 0X4C4)---

    RCPI_LOW_THRESHOLD1_OFDM[9..0] - (RW) This unsigned value is the low RCPI threshold to generate interrupt, typically 0~255 of BSSID1 (for OFDM).
    RESERVED10[15..10]           - (RO) Reserved bits
    RCPI_HIGH_THRESHOLD1_OFDM[25..16] - (RW) This unsigned value is the high RCPI threshold to generate interrupt, typically 0~255 of BSSID1 (for OFDM).
    RESERVED26[31..26]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RCPI9_RCPI_HIGH_THRESHOLD1_OFDM_ADDR   BN0_WF_RMAC_TOP_RCPI9_ADDR
#define BN0_WF_RMAC_TOP_RCPI9_RCPI_HIGH_THRESHOLD1_OFDM_MASK   0x03FF0000                // RCPI_HIGH_THRESHOLD1_OFDM[25..16]
#define BN0_WF_RMAC_TOP_RCPI9_RCPI_HIGH_THRESHOLD1_OFDM_SHFT   16
#define BN0_WF_RMAC_TOP_RCPI9_RCPI_LOW_THRESHOLD1_OFDM_ADDR    BN0_WF_RMAC_TOP_RCPI9_ADDR
#define BN0_WF_RMAC_TOP_RCPI9_RCPI_LOW_THRESHOLD1_OFDM_MASK    0x000003FF                // RCPI_LOW_THRESHOLD1_OFDM[9..0]
#define BN0_WF_RMAC_TOP_RCPI9_RCPI_LOW_THRESHOLD1_OFDM_SHFT    0

/* =====================================================================================

  ---RCPI11 (0x820E5000 + 0X4CC)---

    RCPI_LOW_THRESHOLD3_OFDM[9..0] - (RW) This unsigned value is the low RCPI threshold to generate interrupt, typically 0~255 of BSSID3 (for OFDM).
    RESERVED10[15..10]           - (RO) Reserved bits
    RCPI_HIGH_THRESHOLD3_OFDM[25..16] - (RW) This unsigned value is the high RCPI threshold to generate interrupt, typically 0~255 of BSSID3 (for OFDM).
    RESERVED26[31..26]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RCPI11_RCPI_HIGH_THRESHOLD3_OFDM_ADDR  BN0_WF_RMAC_TOP_RCPI11_ADDR
#define BN0_WF_RMAC_TOP_RCPI11_RCPI_HIGH_THRESHOLD3_OFDM_MASK  0x03FF0000                // RCPI_HIGH_THRESHOLD3_OFDM[25..16]
#define BN0_WF_RMAC_TOP_RCPI11_RCPI_HIGH_THRESHOLD3_OFDM_SHFT  16
#define BN0_WF_RMAC_TOP_RCPI11_RCPI_LOW_THRESHOLD3_OFDM_ADDR   BN0_WF_RMAC_TOP_RCPI11_ADDR
#define BN0_WF_RMAC_TOP_RCPI11_RCPI_LOW_THRESHOLD3_OFDM_MASK   0x000003FF                // RCPI_LOW_THRESHOLD3_OFDM[9..0]
#define BN0_WF_RMAC_TOP_RCPI11_RCPI_LOW_THRESHOLD3_OFDM_SHFT   0

/* =====================================================================================

  ---LRCPITMPCCK0 (0x820E5000 + 0x588)---

    BSSID0_CCK_RCPI_VALUE[9..0]  - (RW) This unsigned value is the moving average BSSID 0 CCK RCPI value, ranging 0-254*3 when RR.Moving_average_enable is asserted.
                                     The value is meaningless when the first Beacon RCPI value is received and is meaningful after the 2nd beacon RCPI value is received.
                                     Write to this register will make HW initialize moving average circuit as feeding one beacon RCPI value. This is for power-on after power-off to make RCPI moving average not restart. SW needs to back up this register value twice and restore it after power-on.
    RESERVED10[15..10]           - (RO) Reserved bits
    BSSID0_CCK_RCPI_YN[30..16]   - (RW) This unsigned value is the moving average BSSID 0 CCK. RCPI YN value includes 10-bit integer in MSB and 5-bit decimal in LSB (BU/RS usage).
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPITMPCCK0_BSSID0_CCK_RCPI_YN_ADDR   BN0_WF_RMAC_TOP_LRCPITMPCCK0_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPCCK0_BSSID0_CCK_RCPI_YN_MASK   0x7FFF0000                // BSSID0_CCK_RCPI_YN[30..16]
#define BN0_WF_RMAC_TOP_LRCPITMPCCK0_BSSID0_CCK_RCPI_YN_SHFT   16
#define BN0_WF_RMAC_TOP_LRCPITMPCCK0_BSSID0_CCK_RCPI_VALUE_ADDR BN0_WF_RMAC_TOP_LRCPITMPCCK0_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPCCK0_BSSID0_CCK_RCPI_VALUE_MASK 0x000003FF                // BSSID0_CCK_RCPI_VALUE[9..0]
#define BN0_WF_RMAC_TOP_LRCPITMPCCK0_BSSID0_CCK_RCPI_VALUE_SHFT 0

/* =====================================================================================

  ---LRCPITMPCCK1 (0x820E5000 + 0x58C)---

    BSSID1_CCK_RCPI_VALUE[9..0]  - (RW) This unsigned value is the moving average BSSID 1 CCK RCPI value, ranging 0-254*3 when RR.Moving_average_enable is asserted.
                                     The value is meaningless when the first Beacon RCPI value is received and is meaningful after the 2nd beacon RCPI value is received.
                                     Write to this register will make HW initialize moving average circuit as feeding one beacon RCPI value. This is for power-on after power-off to make RCPI moving average not restart. SW needs to back up this register value twice and restore it after power-on.
    RESERVED10[15..10]           - (RO) Reserved bits
    BSSID1_CCK_RCPI_YN[30..16]   - (RW) This unsigned value is the moving average BSSID 1 CCK RCPI YN value includes 10-bit integer in MSB and 5-bit decimal in LSB (BU/RS usage).
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPITMPCCK1_BSSID1_CCK_RCPI_YN_ADDR   BN0_WF_RMAC_TOP_LRCPITMPCCK1_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPCCK1_BSSID1_CCK_RCPI_YN_MASK   0x7FFF0000                // BSSID1_CCK_RCPI_YN[30..16]
#define BN0_WF_RMAC_TOP_LRCPITMPCCK1_BSSID1_CCK_RCPI_YN_SHFT   16
#define BN0_WF_RMAC_TOP_LRCPITMPCCK1_BSSID1_CCK_RCPI_VALUE_ADDR BN0_WF_RMAC_TOP_LRCPITMPCCK1_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPCCK1_BSSID1_CCK_RCPI_VALUE_MASK 0x000003FF                // BSSID1_CCK_RCPI_VALUE[9..0]
#define BN0_WF_RMAC_TOP_LRCPITMPCCK1_BSSID1_CCK_RCPI_VALUE_SHFT 0

/* =====================================================================================

  ---LRCPITMPCCK2 (0x820E5000 + 0x590)---

    BSSID2_CCK_RCPI_VALUE[9..0]  - (RW) This unsigned value is the moving average BSSID 2 CCK RCPI value, ranging 0-254*3 when RR.Moving_average_enable is asserted.
                                     The value is meaningless when the first Beacon RCPI value is received and is meaningful after the 2nd beacon RCPI value is received.
                                     Write to this register will make HW initialize moving average circuit as feeding one beacon RCPI value. This is for power-on after power-off to make RCPI moving average not restart. SW needs to back up this register value twice and restore it after power-on.
    RESERVED10[15..10]           - (RO) Reserved bits
    BSSID2_CCK_RCPI_YN[30..16]   - (RW) This unsigned value is the moving average BSSID 2 CCK RCPI YN value includes 10-bit integer in MSB and 5-bit decimal in LSB (BU/RS usage).
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPITMPCCK2_BSSID2_CCK_RCPI_YN_ADDR   BN0_WF_RMAC_TOP_LRCPITMPCCK2_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPCCK2_BSSID2_CCK_RCPI_YN_MASK   0x7FFF0000                // BSSID2_CCK_RCPI_YN[30..16]
#define BN0_WF_RMAC_TOP_LRCPITMPCCK2_BSSID2_CCK_RCPI_YN_SHFT   16
#define BN0_WF_RMAC_TOP_LRCPITMPCCK2_BSSID2_CCK_RCPI_VALUE_ADDR BN0_WF_RMAC_TOP_LRCPITMPCCK2_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPCCK2_BSSID2_CCK_RCPI_VALUE_MASK 0x000003FF                // BSSID2_CCK_RCPI_VALUE[9..0]
#define BN0_WF_RMAC_TOP_LRCPITMPCCK2_BSSID2_CCK_RCPI_VALUE_SHFT 0

/* =====================================================================================

  ---LRCPITMPCCK3 (0x820E5000 + 0x594)---

    BSSID3_CCK_RCPI_VALUE[9..0]  - (RW) This unsigned value is the moving average BSSID 3 CCK RCPI value, ranging from 0-254*3 when RR.Moving_average_enable is asserted.
                                     The value is meaningless when the first Beacon RCPI value is received and is meaningful after the 2nd beacon RCPI value is received.
                                     Write to this register will make HW initialize moving average circuit as feeding one beacon RCPI value. This is for power-on after power-off to make RCPI moving average not restart. SW needs to back up this register value twice and restore it after power-on.
    RESERVED10[15..10]           - (RO) Reserved bits
    BSSID3_CCK_RCPI_YN[30..16]   - (RW) This unsigned value is the moving average BSSID 3 CCK RCPI YN value includes 10-bit integer in MSB and 5-bit decimal in LSB (BU/RS usage).
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPITMPCCK3_BSSID3_CCK_RCPI_YN_ADDR   BN0_WF_RMAC_TOP_LRCPITMPCCK3_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPCCK3_BSSID3_CCK_RCPI_YN_MASK   0x7FFF0000                // BSSID3_CCK_RCPI_YN[30..16]
#define BN0_WF_RMAC_TOP_LRCPITMPCCK3_BSSID3_CCK_RCPI_YN_SHFT   16
#define BN0_WF_RMAC_TOP_LRCPITMPCCK3_BSSID3_CCK_RCPI_VALUE_ADDR BN0_WF_RMAC_TOP_LRCPITMPCCK3_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPCCK3_BSSID3_CCK_RCPI_VALUE_MASK 0x000003FF                // BSSID3_CCK_RCPI_VALUE[9..0]
#define BN0_WF_RMAC_TOP_LRCPITMPCCK3_BSSID3_CCK_RCPI_VALUE_SHFT 0

/* =====================================================================================

  ---LRCPITMPOFDM0 (0x820E5000 + 0x598)---

    BSSID0_OFDM_RCPI_VALUE[9..0] - (RW) This unsigned value is the moving average BSSID 0 OFDM RCPI value, ranging 0-254*3 when RR.Moving_average_enable is asserted .
                                     The value is meaningless when the first Beacon RCPI value is received and is meaningful after the 2nd beacon RCPI value is received.
                                     Write to this register will make HW initialize moving average circuit as feeding one beacon RCPI value. This is for power-on after power-off to make RCPI moving average not restart. SW needs to back up this register value twice and restore it after power-on.
    RESERVED10[15..10]           - (RO) Reserved bits
    BSSID0_OFDM_RCPI_YN[30..16]  - (RW) This unsigned value is the moving average BSSID 0 OFDM RCPI YN value includes 10-bit integer in MSB and 5-bit decimal in LSB (BU/RS usage).
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM0_BSSID0_OFDM_RCPI_YN_ADDR BN0_WF_RMAC_TOP_LRCPITMPOFDM0_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM0_BSSID0_OFDM_RCPI_YN_MASK 0x7FFF0000                // BSSID0_OFDM_RCPI_YN[30..16]
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM0_BSSID0_OFDM_RCPI_YN_SHFT 16
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM0_BSSID0_OFDM_RCPI_VALUE_ADDR BN0_WF_RMAC_TOP_LRCPITMPOFDM0_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM0_BSSID0_OFDM_RCPI_VALUE_MASK 0x000003FF                // BSSID0_OFDM_RCPI_VALUE[9..0]
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM0_BSSID0_OFDM_RCPI_VALUE_SHFT 0

/* =====================================================================================

  ---LRCPITMPOFDM1 (0x820E5000 + 0x59C)---

    BSSID1_OFDM_RCPI_VALUE[9..0] - (RW) This unsigned value is the moving average BSSID 1 OFDM RCPI value, ranging from 0-254*3 when RR.Moving_average_enable is asserted .
                                     The value is meaningless when the first Beacon RCPI value is received and is meaningful after the 2nd beacon RCPI value is received.
                                     Write to this register will make HW initialize moving average circuit as feeding one beacon RCPI value. This is for power-on after power-off to make RCPI moving average not restart. SW needs to back up this register value twice and restore it after power-on.
    RESERVED10[15..10]           - (RO) Reserved bits
    BSSID1_OFDM_RCPI_YN[30..16]  - (RW) This unsigned value is the moving average BSSID 1 OFDM RCPI YN value includes 10-bit integer in MSB and 5-bit decimal in LSB (BU/RS usage).
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM1_BSSID1_OFDM_RCPI_YN_ADDR BN0_WF_RMAC_TOP_LRCPITMPOFDM1_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM1_BSSID1_OFDM_RCPI_YN_MASK 0x7FFF0000                // BSSID1_OFDM_RCPI_YN[30..16]
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM1_BSSID1_OFDM_RCPI_YN_SHFT 16
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM1_BSSID1_OFDM_RCPI_VALUE_ADDR BN0_WF_RMAC_TOP_LRCPITMPOFDM1_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM1_BSSID1_OFDM_RCPI_VALUE_MASK 0x000003FF                // BSSID1_OFDM_RCPI_VALUE[9..0]
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM1_BSSID1_OFDM_RCPI_VALUE_SHFT 0

/* =====================================================================================

  ---LRCPITMPOFDM2 (0x820E5000 + 0x5A0)---

    BSSID2_OFDM_RCPI_VALUE[9..0] - (RW) This unsigned value is the moving average BSSID 2 OFDM RCPI value, ranging from 0-254*3 when RR.Moving_average_enable is asserted .
                                     The value is meaningless when the first Beacon RCPI value is received and is meaningful after the 2nd beacon RCPI value is received.
                                     Write to this register will make HW initialize moving average circuit as feeding one beacon RCPI value. This is for power-on after power-off to make RCPI moving average not restart. SW needs to back up this register value twice and restore it after power-on.
    RESERVED10[15..10]           - (RO) Reserved bits
    BSSID2_OFDM_RCPI_YN[30..16]  - (RW) This unsigned value is the moving average BSSID 2 OFDM RCPI YN value includes 10-bit integer in MSB and 5-bit decimal in LSB (BU/RS usage).
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM2_BSSID2_OFDM_RCPI_YN_ADDR BN0_WF_RMAC_TOP_LRCPITMPOFDM2_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM2_BSSID2_OFDM_RCPI_YN_MASK 0x7FFF0000                // BSSID2_OFDM_RCPI_YN[30..16]
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM2_BSSID2_OFDM_RCPI_YN_SHFT 16
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM2_BSSID2_OFDM_RCPI_VALUE_ADDR BN0_WF_RMAC_TOP_LRCPITMPOFDM2_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM2_BSSID2_OFDM_RCPI_VALUE_MASK 0x000003FF                // BSSID2_OFDM_RCPI_VALUE[9..0]
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM2_BSSID2_OFDM_RCPI_VALUE_SHFT 0

/* =====================================================================================

  ---LRCPITMPOFDM3 (0x820E5000 + 0x5A4)---

    BSSID3_OFDM_RCPI_VALUE[9..0] - (RW) This unsigned value is the moving average BSSID 3 OFDM RCPI value, ranging 0-254*3 when RR.Moving_average_enable is asserted .
                                     The value is meaningless when the first Beacon RCPI value is received and is meaningful after the 2nd beacon RCPI value is received.
                                     Write to this register will make HW initialize moving average circuit as feeding one beacon RCPI value. This is for power-on after power-off to make RCPI moving average not restart. SW needs to back up this register value twice and restore it after power-on.
    RESERVED10[15..10]           - (RO) Reserved bits
    BSSID3_OFDM_RCPI_YN[30..16]  - (RW) This unsigned value is the moving average BSSID 3 OFDM RCPI YN value includes 10-bit integer in MSB and 5-bit decimal in LSB (BU/RS usage).
    RESERVED31[31]               - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM3_BSSID3_OFDM_RCPI_YN_ADDR BN0_WF_RMAC_TOP_LRCPITMPOFDM3_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM3_BSSID3_OFDM_RCPI_YN_MASK 0x7FFF0000                // BSSID3_OFDM_RCPI_YN[30..16]
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM3_BSSID3_OFDM_RCPI_YN_SHFT 16
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM3_BSSID3_OFDM_RCPI_VALUE_ADDR BN0_WF_RMAC_TOP_LRCPITMPOFDM3_ADDR
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM3_BSSID3_OFDM_RCPI_VALUE_MASK 0x000003FF                // BSSID3_OFDM_RCPI_VALUE[9..0]
#define BN0_WF_RMAC_TOP_LRCPITMPOFDM3_BSSID3_OFDM_RCPI_VALUE_SHFT 0

/* =====================================================================================

  ---LRCPI_MISC0R (0x820E5000 + 0x5A8)---

    BSSID3_CCK_IND_RCPI_MA_VLD[0] - (RW) Internal BSSID3 CCK IND RCPI MA VLD (BU/RS usage)
    BSSID3_OFDM_IND_RCPI_MA_VLD[1] - (RW) Internal BSSID3 OFDM IND RCPI MA VLD (BU/RS usage)
    BSSID2_CCK_IND_RCPI_MA_VLD[2] - (RW) Internal BSSID2 CCK IND RCPI MA VLD (BU/RS usage)
    BSSID2_OFDM_IND_RCPI_MA_VLD[3] - (RW) Internal BSSID2 OFDM IND RCPI MA VLD (BU/RS usage)
    BSSID1_CCK_IND_RCPI_MA_VLD[4] - (RW) Internal BSSID1 CCK IND RCPI MA VLD (BU/RS usage)
    BSSID1_OFDM_IND_RCPI_MA_VLD[5] - (RW) Internal BSSID1 OFDM IND RCPI MA VLD (BU/RS usage)
    BSSID0_CCK_IND_RCPI_MA_VLD[6] - (RW) Internal BSSID0 CCK IND RCPI MA VLD (BU/RS usage)
    BSSID0_OFDM_IND_RCPI_MA_VLD[7] - (RW) Internal BSSID0 OFDM IND RCPI MA VLD (BU/RS usage)
    BSSID3_CCK_IND_RCPI_REQ[8]   - (RW) Internal BSSID3 CCK IND RCPI REQ (BU/RS usage)
    BSSID3_OFDM_IND_RCPI_REQ[9]  - (RW) Internal BSSID3 OFDM IND RCPI REQ (BU/RS usage)
    BSSID2_CCK_IND_RCPI_REQ[10]  - (RW) Internal BSSID2 CCK IND RCPI REQ (BU/RS usage)
    BSSID2_OFDM_IND_RCPI_REQ[11] - (RW) Internal BSSID2 OFDM IND RCPI REQ (BU/RS usage)
    BSSID1_CCK_IND_RCPI_REQ[12]  - (RW) Internal BSSID1 CCK IND RCPI REQ (BU/RS usage)
    BSSID1_OFDM_IND_RCPI_REQ[13] - (RW) Internal BSSID1 OFDM IND RCPI REQ (BU/RS usage)
    BSSID0_CCK_IND_RCPI_REQ[14]  - (RW) Internal BSSID0 CCK IND RCPI REQ (BU/RS usage)
    BSSID0_OFDM_IND_RCPI_REQ[15] - (RW) Internal BSSID0 OFDM IND RCPI REQ (BU/RS usage)
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_OFDM_IND_RCPI_REQ_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_OFDM_IND_RCPI_REQ_MASK 0x00008000                // BSSID0_OFDM_IND_RCPI_REQ[15]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_OFDM_IND_RCPI_REQ_SHFT 15
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_CCK_IND_RCPI_REQ_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_CCK_IND_RCPI_REQ_MASK 0x00004000                // BSSID0_CCK_IND_RCPI_REQ[14]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_CCK_IND_RCPI_REQ_SHFT 14
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_OFDM_IND_RCPI_REQ_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_OFDM_IND_RCPI_REQ_MASK 0x00002000                // BSSID1_OFDM_IND_RCPI_REQ[13]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_OFDM_IND_RCPI_REQ_SHFT 13
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_CCK_IND_RCPI_REQ_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_CCK_IND_RCPI_REQ_MASK 0x00001000                // BSSID1_CCK_IND_RCPI_REQ[12]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_CCK_IND_RCPI_REQ_SHFT 12
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_OFDM_IND_RCPI_REQ_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_OFDM_IND_RCPI_REQ_MASK 0x00000800                // BSSID2_OFDM_IND_RCPI_REQ[11]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_OFDM_IND_RCPI_REQ_SHFT 11
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_CCK_IND_RCPI_REQ_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_CCK_IND_RCPI_REQ_MASK 0x00000400                // BSSID2_CCK_IND_RCPI_REQ[10]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_CCK_IND_RCPI_REQ_SHFT 10
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_OFDM_IND_RCPI_REQ_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_OFDM_IND_RCPI_REQ_MASK 0x00000200                // BSSID3_OFDM_IND_RCPI_REQ[9]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_OFDM_IND_RCPI_REQ_SHFT 9
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_CCK_IND_RCPI_REQ_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_CCK_IND_RCPI_REQ_MASK 0x00000100                // BSSID3_CCK_IND_RCPI_REQ[8]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_CCK_IND_RCPI_REQ_SHFT 8
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_OFDM_IND_RCPI_MA_VLD_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_OFDM_IND_RCPI_MA_VLD_MASK 0x00000080                // BSSID0_OFDM_IND_RCPI_MA_VLD[7]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_OFDM_IND_RCPI_MA_VLD_SHFT 7
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_CCK_IND_RCPI_MA_VLD_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_CCK_IND_RCPI_MA_VLD_MASK 0x00000040                // BSSID0_CCK_IND_RCPI_MA_VLD[6]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID0_CCK_IND_RCPI_MA_VLD_SHFT 6
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_OFDM_IND_RCPI_MA_VLD_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_OFDM_IND_RCPI_MA_VLD_MASK 0x00000020                // BSSID1_OFDM_IND_RCPI_MA_VLD[5]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_OFDM_IND_RCPI_MA_VLD_SHFT 5
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_CCK_IND_RCPI_MA_VLD_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_CCK_IND_RCPI_MA_VLD_MASK 0x00000010                // BSSID1_CCK_IND_RCPI_MA_VLD[4]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID1_CCK_IND_RCPI_MA_VLD_SHFT 4
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_OFDM_IND_RCPI_MA_VLD_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_OFDM_IND_RCPI_MA_VLD_MASK 0x00000008                // BSSID2_OFDM_IND_RCPI_MA_VLD[3]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_OFDM_IND_RCPI_MA_VLD_SHFT 3
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_CCK_IND_RCPI_MA_VLD_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_CCK_IND_RCPI_MA_VLD_MASK 0x00000004                // BSSID2_CCK_IND_RCPI_MA_VLD[2]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID2_CCK_IND_RCPI_MA_VLD_SHFT 2
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_OFDM_IND_RCPI_MA_VLD_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_OFDM_IND_RCPI_MA_VLD_MASK 0x00000002                // BSSID3_OFDM_IND_RCPI_MA_VLD[1]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_OFDM_IND_RCPI_MA_VLD_SHFT 1
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_CCK_IND_RCPI_MA_VLD_ADDR BN0_WF_RMAC_TOP_LRCPI_MISC0R_ADDR
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_CCK_IND_RCPI_MA_VLD_MASK 0x00000001                // BSSID3_CCK_IND_RCPI_MA_VLD[0]
#define BN0_WF_RMAC_TOP_LRCPI_MISC0R_BSSID3_CCK_IND_RCPI_MA_VLD_SHFT 0

/* =====================================================================================

  ---TFPARCR0 (0x820E5000 + 0x604)---

    RX_TF_UC2ME_AID_CHK_EN[0]    - (RW) Enable AID check when Rx unicast to ownmac trigger frame.
                                     0 : Don't check the AID for unicast to ownmac trigger frame
                                     1 : Check AID for unicast to ownmac trigger frame
    RX_TF_PAD_AID_CHK_EN[1]      - (RW) Stop search AID once hit AID=FFF
                                     0 : Don't check the AID=FFF and continue to search to packet end
                                     1 : Check AID=FFF and stop search next AID
    INTRA_PS_EN[2]               - (RW) Intra PPDU power saving enable
                                     0 : Disable intra PPDU power saving
                                     1 :Enable intra PPDU power saving
    INTRA_PS_DISCHK_OBSS[3]      - (RW) Intra PPDU power saving disable OBSS check
                                     0 : Chek OBSS
                                     1 : Disable check OBSS
    RESERVED4[7..4]              - (RO) Reserved bits
    TX_TF_PSR_EN[8]              - (RW) Enable Tx trigger frame parser (for AP mode)
    TX_TF_PSR_ERR_CNT_EN[9]      - (RW) Enable Tx trigger frame parser error counter
    RX_TF_PSR_ALL_INFO_EN[10]    - (RW) Enable Rx trigger frame parsing all info. (For sniffer mode usage)
    GEN_RX_RPT_EN[11]            - (RW) Generate RXRPT and CMDRPT-TRIG-Data
    TF_TRIG_SNIFFER_EN[12]       - (RW) RX Trigger Frame TRIG_INFO Select from CR or TXCMD
    NDP_RPT_EN[13]               - (RW) RX NDP RXRPT Enable
    RESERVED14[15..14]           - (RO) Reserved bits
    CTEN_RXV_EN[19..16]          - (RW) Contention RXRPT RXV block enable bit
                                     bit0: CRXV1
                                     bit1: PRXV1
                                     bit2: PRXV2
                                     bit3:CRXV2
    HETB_RXV_EN[23..20]          - (RW) HETB TRIG-DATA RXRPT RXV block enable bit
                                     bit0: CRXV1
                                     bit1: PRXV1
                                     bit2: PRXV2
                                     bit3:CRXV2
    DLON_RXV_EN[27..24]          - (RW) DL only TRIG-TX RXRPT RXV block enable bit
                                     bit0: CRXV1
                                     bit1: PRXV1
                                     bit2: PRXV2
                                     bit3:CRXV2
    No_RESP_TRIG_EN_BSSID0[28]   - (RW) Do not response trigger frame enable
                                     0: Response trigger frame
                                     1: No response trigger frame
    No_RESP_TRIG_EN_BSSID1[29]   - (RW) Do not response trigger frame enable
                                     0: Response trigger frame
                                     1: No response trigger frame
    No_RESP_TRIG_EN_BSSID2[30]   - (RW) Do not response trigger frame enable
                                     0: Response trigger frame
                                     1: No response trigger frame
    No_RESP_TRIG_EN_BSSID3[31]   - (RW) Do not response trigger frame enable
                                     0: Response trigger frame
                                     1: No response trigger frame

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID3_ADDR   BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID3_MASK   0x80000000                // No_RESP_TRIG_EN_BSSID3[31]
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID3_SHFT   31
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID2_ADDR   BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID2_MASK   0x40000000                // No_RESP_TRIG_EN_BSSID2[30]
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID2_SHFT   30
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID1_ADDR   BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID1_MASK   0x20000000                // No_RESP_TRIG_EN_BSSID1[29]
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID1_SHFT   29
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID0_ADDR   BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID0_MASK   0x10000000                // No_RESP_TRIG_EN_BSSID0[28]
#define BN0_WF_RMAC_TOP_TFPARCR0_No_RESP_TRIG_EN_BSSID0_SHFT   28
#define BN0_WF_RMAC_TOP_TFPARCR0_DLON_RXV_EN_ADDR              BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_DLON_RXV_EN_MASK              0x0F000000                // DLON_RXV_EN[27..24]
#define BN0_WF_RMAC_TOP_TFPARCR0_DLON_RXV_EN_SHFT              24
#define BN0_WF_RMAC_TOP_TFPARCR0_HETB_RXV_EN_ADDR              BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_HETB_RXV_EN_MASK              0x00F00000                // HETB_RXV_EN[23..20]
#define BN0_WF_RMAC_TOP_TFPARCR0_HETB_RXV_EN_SHFT              20
#define BN0_WF_RMAC_TOP_TFPARCR0_CTEN_RXV_EN_ADDR              BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_CTEN_RXV_EN_MASK              0x000F0000                // CTEN_RXV_EN[19..16]
#define BN0_WF_RMAC_TOP_TFPARCR0_CTEN_RXV_EN_SHFT              16
#define BN0_WF_RMAC_TOP_TFPARCR0_NDP_RPT_EN_ADDR               BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_NDP_RPT_EN_MASK               0x00002000                // NDP_RPT_EN[13]
#define BN0_WF_RMAC_TOP_TFPARCR0_NDP_RPT_EN_SHFT               13
#define BN0_WF_RMAC_TOP_TFPARCR0_TF_TRIG_SNIFFER_EN_ADDR       BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_TF_TRIG_SNIFFER_EN_MASK       0x00001000                // TF_TRIG_SNIFFER_EN[12]
#define BN0_WF_RMAC_TOP_TFPARCR0_TF_TRIG_SNIFFER_EN_SHFT       12
#define BN0_WF_RMAC_TOP_TFPARCR0_GEN_RX_RPT_EN_ADDR            BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_GEN_RX_RPT_EN_MASK            0x00000800                // GEN_RX_RPT_EN[11]
#define BN0_WF_RMAC_TOP_TFPARCR0_GEN_RX_RPT_EN_SHFT            11
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_PSR_ALL_INFO_EN_ADDR    BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_PSR_ALL_INFO_EN_MASK    0x00000400                // RX_TF_PSR_ALL_INFO_EN[10]
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_PSR_ALL_INFO_EN_SHFT    10
#define BN0_WF_RMAC_TOP_TFPARCR0_TX_TF_PSR_ERR_CNT_EN_ADDR     BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_TX_TF_PSR_ERR_CNT_EN_MASK     0x00000200                // TX_TF_PSR_ERR_CNT_EN[9]
#define BN0_WF_RMAC_TOP_TFPARCR0_TX_TF_PSR_ERR_CNT_EN_SHFT     9
#define BN0_WF_RMAC_TOP_TFPARCR0_TX_TF_PSR_EN_ADDR             BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_TX_TF_PSR_EN_MASK             0x00000100                // TX_TF_PSR_EN[8]
#define BN0_WF_RMAC_TOP_TFPARCR0_TX_TF_PSR_EN_SHFT             8
#define BN0_WF_RMAC_TOP_TFPARCR0_INTRA_PS_DISCHK_OBSS_ADDR     BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_INTRA_PS_DISCHK_OBSS_MASK     0x00000008                // INTRA_PS_DISCHK_OBSS[3]
#define BN0_WF_RMAC_TOP_TFPARCR0_INTRA_PS_DISCHK_OBSS_SHFT     3
#define BN0_WF_RMAC_TOP_TFPARCR0_INTRA_PS_EN_ADDR              BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_INTRA_PS_EN_MASK              0x00000004                // INTRA_PS_EN[2]
#define BN0_WF_RMAC_TOP_TFPARCR0_INTRA_PS_EN_SHFT              2
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_PAD_AID_CHK_EN_ADDR     BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_PAD_AID_CHK_EN_MASK     0x00000002                // RX_TF_PAD_AID_CHK_EN[1]
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_PAD_AID_CHK_EN_SHFT     1
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_UC2ME_AID_CHK_EN_ADDR   BN0_WF_RMAC_TOP_TFPARCR0_ADDR
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_UC2ME_AID_CHK_EN_MASK   0x00000001                // RX_TF_UC2ME_AID_CHK_EN[0]
#define BN0_WF_RMAC_TOP_TFPARCR0_RX_TF_UC2ME_AID_CHK_EN_SHFT   0

/* =====================================================================================

  ---RXRSPCR (0x820E5000 + 0x608)---

    RESP_ACKALL_EN[0]            - (RW) Enable all ack context indication while receiving PPDU
                                     0 : Don't indicate all ack context while receiving PPDU
                                     1: indicate all ack context while receiving PPDU
    RX_HETB_SMPDU_RSP_MSBA_EN[1] - (RW) Enable response MSBA frame indication while receive SMPDU, Pspoll or action, carried in HE TB PPDU
                                     0 : Don't indicate MSBA response while receiving SMPDU carried in HE TB PPDU
                                     1: indicate MSBA response while receiving SMPDU carried in HE TB PPDU
    RESERVED2[31..2]             - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXRSPCR_RX_HETB_SMPDU_RSP_MSBA_EN_ADDR BN0_WF_RMAC_TOP_RXRSPCR_ADDR
#define BN0_WF_RMAC_TOP_RXRSPCR_RX_HETB_SMPDU_RSP_MSBA_EN_MASK 0x00000002                // RX_HETB_SMPDU_RSP_MSBA_EN[1]
#define BN0_WF_RMAC_TOP_RXRSPCR_RX_HETB_SMPDU_RSP_MSBA_EN_SHFT 1
#define BN0_WF_RMAC_TOP_RXRSPCR_RESP_ACKALL_EN_ADDR            BN0_WF_RMAC_TOP_RXRSPCR_ADDR
#define BN0_WF_RMAC_TOP_RXRSPCR_RESP_ACKALL_EN_MASK            0x00000001                // RESP_ACKALL_EN[0]
#define BN0_WF_RMAC_TOP_RXRSPCR_RESP_ACKALL_EN_SHFT            0

/* =====================================================================================

  ---INSUR (0x820E5000 + 0x60C)---

    INAVUPDATEVALUE_25_0[25..0]  - (RO) Intra NAV update value bits 25~0. 
                                     This value is counted in unit of us. The read value is current Intra NAV value
    RESERVED26[31..26]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_INSUR_INAVUPDATEVALUE_25_0_ADDR        BN0_WF_RMAC_TOP_INSUR_ADDR
#define BN0_WF_RMAC_TOP_INSUR_INAVUPDATEVALUE_25_0_MASK        0x03FFFFFF                // INAVUPDATEVALUE_25_0[25..0]
#define BN0_WF_RMAC_TOP_INSUR_INAVUPDATEVALUE_25_0_SHFT        0

/* =====================================================================================

  ---LUINVR (0x820E5000 + 0x610)---

    INAV_VALUE[25..0]            - (RO) Latest updated Intra NAV value
                                     unit in us
    RESERVED26[31..26]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_LUINVR_INAV_VALUE_ADDR                 BN0_WF_RMAC_TOP_LUINVR_ADDR
#define BN0_WF_RMAC_TOP_LUINVR_INAV_VALUE_MASK                 0x03FFFFFF                // INAV_VALUE[25..0]
#define BN0_WF_RMAC_TOP_LUINVR_INAV_VALUE_SHFT                 0

/* =====================================================================================

  ---RXMBACR (0x820E5000 + 0x614)---

    MSBA_UC_AID_CHK_EN[0]        - (RW) Enable checking AID info while receiving unicasted to ownmac Multi-STA BA
                                     0 : Discard AID checking if Multi-STA BA is unicast to ownmac.
                                     1 : Enable AID checking even if Multi-STA BA is unicast to ownmac.
    RESERVED1[31..1]             - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXMBACR_MSBA_UC_AID_CHK_EN_ADDR        BN0_WF_RMAC_TOP_RXMBACR_ADDR
#define BN0_WF_RMAC_TOP_RXMBACR_MSBA_UC_AID_CHK_EN_MASK        0x00000001                // MSBA_UC_AID_CHK_EN[0]
#define BN0_WF_RMAC_TOP_RXMBACR_MSBA_UC_AID_CHK_EN_SHFT        0

/* =====================================================================================

  ---RXSR0 (0x820E5000 + 0x618)---

    SR_NONSRG_PD_THR[7..0]       - (RW) Spatial Reuse non-SRG PD threshold
                                     (RCPI-220)/2
    SR_SRG_PD_THR[15..8]         - (RW) Spatial Reuse SRG PD threshold
                                     (RCPI-220)/2
    SR_PERIOD_OFST[21..16]       - (RW) Spatial Reuse period offset
    SR_RCPI_SOURCE_SEL[23..22]   - (RW) RCPI source select
                                     0: from RCPI ANT0
                                     1: from RCPI ANT1
                                     2: from RCPI ANT2
                                     3: from RCPI ANT3
    SR_NONSRG_EN[24]             - (RW) Spatial Reuse non-SRGroup enable
    SR_SRG_EN[25]                - (RW) Spatial Reuse SRGroup enable
    SR_EN[26]                    - (RW) Spatial Reuse function enable
    SR_SINGLE_MDPU_RTSCTS_EN[27] - (RW) Spatial Reuse single MPDU RTS/CTS enable
    SR_HDR_DUR_EN[28]            - (RW) Spatial Reuse Check Header Durtion Enable
    SR_TXOP_DUR_EN[29]           - (RW) Spatial Reuse Check TXOP Durtion Enable
    SR_SRG_INTERPPDU_PRESV[30]   - (RW) Spatial Reuse SRG interPPDU counter preserve
    SR_NONSRG_INTERPPDU_PRESV[31] - (RW) Spatial Reuse NONSRG interPPDU counter preserve

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_INTERPPDU_PRESV_ADDR   BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_INTERPPDU_PRESV_MASK   0x80000000                // SR_NONSRG_INTERPPDU_PRESV[31]
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_INTERPPDU_PRESV_SHFT   31
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_INTERPPDU_PRESV_ADDR      BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_INTERPPDU_PRESV_MASK      0x40000000                // SR_SRG_INTERPPDU_PRESV[30]
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_INTERPPDU_PRESV_SHFT      30
#define BN0_WF_RMAC_TOP_RXSR0_SR_TXOP_DUR_EN_ADDR              BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_TXOP_DUR_EN_MASK              0x20000000                // SR_TXOP_DUR_EN[29]
#define BN0_WF_RMAC_TOP_RXSR0_SR_TXOP_DUR_EN_SHFT              29
#define BN0_WF_RMAC_TOP_RXSR0_SR_HDR_DUR_EN_ADDR               BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_HDR_DUR_EN_MASK               0x10000000                // SR_HDR_DUR_EN[28]
#define BN0_WF_RMAC_TOP_RXSR0_SR_HDR_DUR_EN_SHFT               28
#define BN0_WF_RMAC_TOP_RXSR0_SR_SINGLE_MDPU_RTSCTS_EN_ADDR    BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_SINGLE_MDPU_RTSCTS_EN_MASK    0x08000000                // SR_SINGLE_MDPU_RTSCTS_EN[27]
#define BN0_WF_RMAC_TOP_RXSR0_SR_SINGLE_MDPU_RTSCTS_EN_SHFT    27
#define BN0_WF_RMAC_TOP_RXSR0_SR_EN_ADDR                       BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_EN_MASK                       0x04000000                // SR_EN[26]
#define BN0_WF_RMAC_TOP_RXSR0_SR_EN_SHFT                       26
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_EN_ADDR                   BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_EN_MASK                   0x02000000                // SR_SRG_EN[25]
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_EN_SHFT                   25
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_EN_ADDR                BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_EN_MASK                0x01000000                // SR_NONSRG_EN[24]
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_EN_SHFT                24
#define BN0_WF_RMAC_TOP_RXSR0_SR_RCPI_SOURCE_SEL_ADDR          BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_RCPI_SOURCE_SEL_MASK          0x00C00000                // SR_RCPI_SOURCE_SEL[23..22]
#define BN0_WF_RMAC_TOP_RXSR0_SR_RCPI_SOURCE_SEL_SHFT          22
#define BN0_WF_RMAC_TOP_RXSR0_SR_PERIOD_OFST_ADDR              BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_PERIOD_OFST_MASK              0x003F0000                // SR_PERIOD_OFST[21..16]
#define BN0_WF_RMAC_TOP_RXSR0_SR_PERIOD_OFST_SHFT              16
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_PD_THR_ADDR               BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_PD_THR_MASK               0x0000FF00                // SR_SRG_PD_THR[15..8]
#define BN0_WF_RMAC_TOP_RXSR0_SR_SRG_PD_THR_SHFT               8
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_PD_THR_ADDR            BN0_WF_RMAC_TOP_RXSR0_ADDR
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_PD_THR_MASK            0x000000FF                // SR_NONSRG_PD_THR[7..0]
#define BN0_WF_RMAC_TOP_RXSR0_SR_NONSRG_PD_THR_SHFT            0

/* =====================================================================================

  ---RXSR1 (0x820E5000 + 0x61C)---

    PBSSID_BITMAP_31_0[31..0]    - (RW) Partial BSSID bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXSR1_PBSSID_BITMAP_31_0_ADDR          BN0_WF_RMAC_TOP_RXSR1_ADDR
#define BN0_WF_RMAC_TOP_RXSR1_PBSSID_BITMAP_31_0_MASK          0xFFFFFFFF                // PBSSID_BITMAP_31_0[31..0]
#define BN0_WF_RMAC_TOP_RXSR1_PBSSID_BITMAP_31_0_SHFT          0

/* =====================================================================================

  ---RXSR2 (0x820E5000 + 0x620)---

    PBSSID_BITMAP_63_32[31..0]   - (RW) Partial BSSID bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXSR2_PBSSID_BITMAP_63_32_ADDR         BN0_WF_RMAC_TOP_RXSR2_ADDR
#define BN0_WF_RMAC_TOP_RXSR2_PBSSID_BITMAP_63_32_MASK         0xFFFFFFFF                // PBSSID_BITMAP_63_32[31..0]
#define BN0_WF_RMAC_TOP_RXSR2_PBSSID_BITMAP_63_32_SHFT         0

/* =====================================================================================

  ---RXSR3 (0x820E5000 + 0x624)---

    PCOLOR_BITMAP_31_0[31..0]    - (RW) Partial BSS Color bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXSR3_PCOLOR_BITMAP_31_0_ADDR          BN0_WF_RMAC_TOP_RXSR3_ADDR
#define BN0_WF_RMAC_TOP_RXSR3_PCOLOR_BITMAP_31_0_MASK          0xFFFFFFFF                // PCOLOR_BITMAP_31_0[31..0]
#define BN0_WF_RMAC_TOP_RXSR3_PCOLOR_BITMAP_31_0_SHFT          0

/* =====================================================================================

  ---RXSR4 (0x820E5000 + 0x628)---

    PCOLOR_BITMAP_63_32[31..0]   - (RW) Partial BSS Color bitmap

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXSR4_PCOLOR_BITMAP_63_32_ADDR         BN0_WF_RMAC_TOP_RXSR4_ADDR
#define BN0_WF_RMAC_TOP_RXSR4_PCOLOR_BITMAP_63_32_MASK         0xFFFFFFFF                // PCOLOR_BITMAP_63_32[31..0]
#define BN0_WF_RMAC_TOP_RXSR4_PCOLOR_BITMAP_63_32_SHFT         0

/* =====================================================================================

  ---NONSRG_INFO0 (0x820E5000 + 0x630)---

    NONSRG_INTERPPDU_ADDR1_31_0[31..0] - (RO) NONSRG inter PPDU address 1 value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NONSRG_INFO0_NONSRG_INTERPPDU_ADDR1_31_0_ADDR BN0_WF_RMAC_TOP_NONSRG_INFO0_ADDR
#define BN0_WF_RMAC_TOP_NONSRG_INFO0_NONSRG_INTERPPDU_ADDR1_31_0_MASK 0xFFFFFFFF                // NONSRG_INTERPPDU_ADDR1_31_0[31..0]
#define BN0_WF_RMAC_TOP_NONSRG_INFO0_NONSRG_INTERPPDU_ADDR1_31_0_SHFT 0

/* =====================================================================================

  ---NONSRG_INFO1 (0x820E5000 + 0x634)---

    NONSRG_INTERPPDU_ADDR1_47_32[15..0] - (RO) NONSRG inter PPDU address 1 value
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NONSRG_INFO1_NONSRG_INTERPPDU_ADDR1_47_32_ADDR BN0_WF_RMAC_TOP_NONSRG_INFO1_ADDR
#define BN0_WF_RMAC_TOP_NONSRG_INFO1_NONSRG_INTERPPDU_ADDR1_47_32_MASK 0x0000FFFF                // NONSRG_INTERPPDU_ADDR1_47_32[15..0]
#define BN0_WF_RMAC_TOP_NONSRG_INFO1_NONSRG_INTERPPDU_ADDR1_47_32_SHFT 0

/* =====================================================================================

  ---NONSRG_INFO2 (0x820E5000 + 0x638)---

    NONSRG_INTERPPDU_ADDR2_31_0[31..0] - (RO) NONSRG inter PPDU address 2 value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NONSRG_INFO2_NONSRG_INTERPPDU_ADDR2_31_0_ADDR BN0_WF_RMAC_TOP_NONSRG_INFO2_ADDR
#define BN0_WF_RMAC_TOP_NONSRG_INFO2_NONSRG_INTERPPDU_ADDR2_31_0_MASK 0xFFFFFFFF                // NONSRG_INTERPPDU_ADDR2_31_0[31..0]
#define BN0_WF_RMAC_TOP_NONSRG_INFO2_NONSRG_INTERPPDU_ADDR2_31_0_SHFT 0

/* =====================================================================================

  ---NONSRG_INFO3 (0x820E5000 + 0x63C)---

    NONSRG_INTERPPDU_ADDR2_47_32[15..0] - (RO) NONSRG inter PPDU address 2 value
    RESERVED16[23..16]           - (RO) Reserved bits
    NONSRG_INTERPPDU_RCPI[31..24] - (RO) NONSRG inter PPDU MAX RCPI value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_NONSRG_INFO3_NONSRG_INTERPPDU_RCPI_ADDR BN0_WF_RMAC_TOP_NONSRG_INFO3_ADDR
#define BN0_WF_RMAC_TOP_NONSRG_INFO3_NONSRG_INTERPPDU_RCPI_MASK 0xFF000000                // NONSRG_INTERPPDU_RCPI[31..24]
#define BN0_WF_RMAC_TOP_NONSRG_INFO3_NONSRG_INTERPPDU_RCPI_SHFT 24
#define BN0_WF_RMAC_TOP_NONSRG_INFO3_NONSRG_INTERPPDU_ADDR2_47_32_ADDR BN0_WF_RMAC_TOP_NONSRG_INFO3_ADDR
#define BN0_WF_RMAC_TOP_NONSRG_INFO3_NONSRG_INTERPPDU_ADDR2_47_32_MASK 0x0000FFFF                // NONSRG_INTERPPDU_ADDR2_47_32[15..0]
#define BN0_WF_RMAC_TOP_NONSRG_INFO3_NONSRG_INTERPPDU_ADDR2_47_32_SHFT 0

/* =====================================================================================

  ---SRG_INFO0 (0x820E5000 + 0x640)---

    SRG_INTERPPDU_ADDR1_31_0[31..0] - (RO) SRG inter PPDU address 1 value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SRG_INFO0_SRG_INTERPPDU_ADDR1_31_0_ADDR BN0_WF_RMAC_TOP_SRG_INFO0_ADDR
#define BN0_WF_RMAC_TOP_SRG_INFO0_SRG_INTERPPDU_ADDR1_31_0_MASK 0xFFFFFFFF                // SRG_INTERPPDU_ADDR1_31_0[31..0]
#define BN0_WF_RMAC_TOP_SRG_INFO0_SRG_INTERPPDU_ADDR1_31_0_SHFT 0

/* =====================================================================================

  ---SRG_INFO1 (0x820E5000 + 0x644)---

    SRG_INTERPPDU_ADDR1_47_32[15..0] - (RO) SRG inter PPDU address 1 value
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SRG_INFO1_SRG_INTERPPDU_ADDR1_47_32_ADDR BN0_WF_RMAC_TOP_SRG_INFO1_ADDR
#define BN0_WF_RMAC_TOP_SRG_INFO1_SRG_INTERPPDU_ADDR1_47_32_MASK 0x0000FFFF                // SRG_INTERPPDU_ADDR1_47_32[15..0]
#define BN0_WF_RMAC_TOP_SRG_INFO1_SRG_INTERPPDU_ADDR1_47_32_SHFT 0

/* =====================================================================================

  ---SRG_INFO2 (0x820E5000 + 0x648)---

    SRG_INTERPPDU_ADDR2_31_0[31..0] - (RO) SRG inter PPDU address 2 value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SRG_INFO2_SRG_INTERPPDU_ADDR2_31_0_ADDR BN0_WF_RMAC_TOP_SRG_INFO2_ADDR
#define BN0_WF_RMAC_TOP_SRG_INFO2_SRG_INTERPPDU_ADDR2_31_0_MASK 0xFFFFFFFF                // SRG_INTERPPDU_ADDR2_31_0[31..0]
#define BN0_WF_RMAC_TOP_SRG_INFO2_SRG_INTERPPDU_ADDR2_31_0_SHFT 0

/* =====================================================================================

  ---SRG_INFO3 (0x820E5000 + 0x64C)---

    SRG_INTERPPDU_ADDR2_47_32[15..0] - (RO) SRG inter PPDU address 2 value
    RESERVED16[23..16]           - (RO) Reserved bits
    SRG_INTERPPDU_RCPI[31..24]   - (RO) SRG inter PPDU MAX RCPI value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SRG_INFO3_SRG_INTERPPDU_RCPI_ADDR      BN0_WF_RMAC_TOP_SRG_INFO3_ADDR
#define BN0_WF_RMAC_TOP_SRG_INFO3_SRG_INTERPPDU_RCPI_MASK      0xFF000000                // SRG_INTERPPDU_RCPI[31..24]
#define BN0_WF_RMAC_TOP_SRG_INFO3_SRG_INTERPPDU_RCPI_SHFT      24
#define BN0_WF_RMAC_TOP_SRG_INFO3_SRG_INTERPPDU_ADDR2_47_32_ADDR BN0_WF_RMAC_TOP_SRG_INFO3_ADDR
#define BN0_WF_RMAC_TOP_SRG_INFO3_SRG_INTERPPDU_ADDR2_47_32_MASK 0x0000FFFF                // SRG_INTERPPDU_ADDR2_47_32[15..0]
#define BN0_WF_RMAC_TOP_SRG_INFO3_SRG_INTERPPDU_ADDR2_47_32_SHFT 0

/* =====================================================================================

  ---SRG_VLDCNT (0x820E5000 + 0x650)---

    NONSRG_VLD_CNT[15..0]        - (RC) NONSRG condition check valid counter
    SRG_VLD_CNT[31..16]          - (RC) SRG condition check valid counter

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SRG_VLDCNT_SRG_VLD_CNT_ADDR            BN0_WF_RMAC_TOP_SRG_VLDCNT_ADDR
#define BN0_WF_RMAC_TOP_SRG_VLDCNT_SRG_VLD_CNT_MASK            0xFFFF0000                // SRG_VLD_CNT[31..16]
#define BN0_WF_RMAC_TOP_SRG_VLDCNT_SRG_VLD_CNT_SHFT            16
#define BN0_WF_RMAC_TOP_SRG_VLDCNT_NONSRG_VLD_CNT_ADDR         BN0_WF_RMAC_TOP_SRG_VLDCNT_ADDR
#define BN0_WF_RMAC_TOP_SRG_VLDCNT_NONSRG_VLD_CNT_MASK         0x0000FFFF                // NONSRG_VLD_CNT[15..0]
#define BN0_WF_RMAC_TOP_SRG_VLDCNT_NONSRG_VLD_CNT_SHFT         0

/* =====================================================================================

  ---SR_PPDUCNT (0x820E5000 + 0x654)---

    INTERBSS_PPDUCNT[15..0]      - (RC) Inter PPDU  counter
    INTRABSS_PPDUCNT[31..16]     - (RC) Intra PPDU  counter

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SR_PPDUCNT_INTRABSS_PPDUCNT_ADDR       BN0_WF_RMAC_TOP_SR_PPDUCNT_ADDR
#define BN0_WF_RMAC_TOP_SR_PPDUCNT_INTRABSS_PPDUCNT_MASK       0xFFFF0000                // INTRABSS_PPDUCNT[31..16]
#define BN0_WF_RMAC_TOP_SR_PPDUCNT_INTRABSS_PPDUCNT_SHFT       16
#define BN0_WF_RMAC_TOP_SR_PPDUCNT_INTERBSS_PPDUCNT_ADDR       BN0_WF_RMAC_TOP_SR_PPDUCNT_ADDR
#define BN0_WF_RMAC_TOP_SR_PPDUCNT_INTERBSS_PPDUCNT_MASK       0x0000FFFF                // INTERBSS_PPDUCNT[15..0]
#define BN0_WF_RMAC_TOP_SR_PPDUCNT_INTERBSS_PPDUCNT_SHFT       0

/* =====================================================================================

  ---SR_PPDUVLDCNT (0x820E5000 + 0x658)---

    NONSRG_PPDUVLDCNT[15..0]     - (RC) NONSRG PPDU valid but PD invlid counter
    SRG_PPDUVLDCNT[31..16]       - (RC) SRG PPDU valid but PD invlid counter

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_SRG_PPDUVLDCNT_ADDR      BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_ADDR
#define BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_SRG_PPDUVLDCNT_MASK      0xFFFF0000                // SRG_PPDUVLDCNT[31..16]
#define BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_SRG_PPDUVLDCNT_SHFT      16
#define BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_NONSRG_PPDUVLDCNT_ADDR   BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_ADDR
#define BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_NONSRG_PPDUVLDCNT_MASK   0x0000FFFF                // NONSRG_PPDUVLDCNT[15..0]
#define BN0_WF_RMAC_TOP_SR_PPDUVLDCNT_NONSRG_PPDUVLDCNT_SHFT   0

/* =====================================================================================

  ---RXCOEX (0x820E5000 + 0x670)---

    RX_DOZE_THR[7..0]            - (RW) NONSRG PPDU valid but PD invlid counter
    RESERVED8[11..8]             - (RO) Reserved bits
    RX_DOZE_RCPI_SEL[13..12]     - (RW) NONSRG PPDU valid but PD invlid counter
    RESERVED14[15..14]           - (RO) Reserved bits
    RX_DECODE_MASK_EN[16]        - (RW) wf2bt_rx_decode signal mask enable
                                     0 : Don't mask the wf2bt_rx_decode signal and the signal will assert at WIFI Rx detection and de-assert when Rx is not my packet.
                                     1 : Mask the wf2bt_rx_decode signal , the signal will always = 0.
    RX_DECODE_DEASRT_AT_A1[17]   - (RW) wf2bt_rx_decode signal behavior option for Rx PPDU
                                     0 : The wf2bt_rx_decode won't early de-assert until MPDU FCS check done
                                     1 : The wf2bt_rx_decode can early deassert when RMAC parsing Addr1 done and the A1 is neither BCMC nor unicasted to ownmac.
    RX_DECODE_CHK_BMC[18]        - (RW) RX decode deasert check BMC packet
    RX_DECODE_CHK_OBSS[19]       - (RW) RX decode deasert check HE OBSS match
    RX_DECODE_CHK_RXVALID[20]    - (RW) RX decode deasert check Pre-User RXV valid
    RESERVED21[31..21]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_RXVALID_ADDR      BN0_WF_RMAC_TOP_RXCOEX_ADDR
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_RXVALID_MASK      0x00100000                // RX_DECODE_CHK_RXVALID[20]
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_RXVALID_SHFT      20
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_OBSS_ADDR         BN0_WF_RMAC_TOP_RXCOEX_ADDR
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_OBSS_MASK         0x00080000                // RX_DECODE_CHK_OBSS[19]
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_OBSS_SHFT         19
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_BMC_ADDR          BN0_WF_RMAC_TOP_RXCOEX_ADDR
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_BMC_MASK          0x00040000                // RX_DECODE_CHK_BMC[18]
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_CHK_BMC_SHFT          18
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_DEASRT_AT_A1_ADDR     BN0_WF_RMAC_TOP_RXCOEX_ADDR
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_DEASRT_AT_A1_MASK     0x00020000                // RX_DECODE_DEASRT_AT_A1[17]
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_DEASRT_AT_A1_SHFT     17
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_MASK_EN_ADDR          BN0_WF_RMAC_TOP_RXCOEX_ADDR
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_MASK_EN_MASK          0x00010000                // RX_DECODE_MASK_EN[16]
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DECODE_MASK_EN_SHFT          16
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DOZE_RCPI_SEL_ADDR           BN0_WF_RMAC_TOP_RXCOEX_ADDR
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DOZE_RCPI_SEL_MASK           0x00003000                // RX_DOZE_RCPI_SEL[13..12]
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DOZE_RCPI_SEL_SHFT           12
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DOZE_THR_ADDR                BN0_WF_RMAC_TOP_RXCOEX_ADDR
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DOZE_THR_MASK                0x000000FF                // RX_DOZE_THR[7..0]
#define BN0_WF_RMAC_TOP_RXCOEX_RX_DOZE_THR_SHFT                0

/* =====================================================================================

  ---TFCSD_INFO0 (0x820E5000 + 0x680)---

    RX_TFCSD_INFO0[31..0]        - (RW) Trigger RX Trigger info CSD assignment, detail reference PHY2MAC spec

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFCSD_INFO0_RX_TFCSD_INFO0_ADDR        BN0_WF_RMAC_TOP_TFCSD_INFO0_ADDR
#define BN0_WF_RMAC_TOP_TFCSD_INFO0_RX_TFCSD_INFO0_MASK        0xFFFFFFFF                // RX_TFCSD_INFO0[31..0]
#define BN0_WF_RMAC_TOP_TFCSD_INFO0_RX_TFCSD_INFO0_SHFT        0

/* =====================================================================================

  ---TFCSD_INFO1 (0x820E5000 + 0x684)---

    RX_TFCSD_INFO1[31..0]        - (RW) Trigger RX Trigger info CSD assignment, detail reference PHY2MAC spec

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFCSD_INFO1_RX_TFCSD_INFO1_ADDR        BN0_WF_RMAC_TOP_TFCSD_INFO1_ADDR
#define BN0_WF_RMAC_TOP_TFCSD_INFO1_RX_TFCSD_INFO1_MASK        0xFFFFFFFF                // RX_TFCSD_INFO1[31..0]
#define BN0_WF_RMAC_TOP_TFCSD_INFO1_RX_TFCSD_INFO1_SHFT        0

/* =====================================================================================

  ---TFPUSR_INFO (0x820E5000 + 0x688)---

    PUSR_SF_ENB[15..0]           - (RW) Trigger RX Trigger info Pre-USER assignment, detail reference PHY2MAC spec
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFPUSR_INFO_PUSR_SF_ENB_ADDR           BN0_WF_RMAC_TOP_TFPUSR_INFO_ADDR
#define BN0_WF_RMAC_TOP_TFPUSR_INFO_PUSR_SF_ENB_MASK           0x0000FFFF                // PUSR_SF_ENB[15..0]
#define BN0_WF_RMAC_TOP_TFPUSR_INFO_PUSR_SF_ENB_SHFT           0

/* =====================================================================================

  ---TFFILTER (0x820E5000 + 0x690)---

    TF_SPRT_SSS[7..0]            - (RW) Trigger RX supported SSS value
    TF_SPRT_NSS[15..8]           - (RW) Trigger RX supported NSS value
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFFILTER_TF_SPRT_NSS_ADDR              BN0_WF_RMAC_TOP_TFFILTER_ADDR
#define BN0_WF_RMAC_TOP_TFFILTER_TF_SPRT_NSS_MASK              0x0000FF00                // TF_SPRT_NSS[15..8]
#define BN0_WF_RMAC_TOP_TFFILTER_TF_SPRT_NSS_SHFT              8
#define BN0_WF_RMAC_TOP_TFFILTER_TF_SPRT_SSS_ADDR              BN0_WF_RMAC_TOP_TFFILTER_ADDR
#define BN0_WF_RMAC_TOP_TFFILTER_TF_SPRT_SSS_MASK              0x000000FF                // TF_SPRT_SSS[7..0]
#define BN0_WF_RMAC_TOP_TFFILTER_TF_SPRT_SSS_SHFT              0

/* =====================================================================================

  ---TFRXV (0x820E5000 + 0x694)---

    RXV_BSS_COLOR[5..0]          - (RW) Force RXV BSS_COLOR value
    RESERVED6[7..6]              - (RO) Reserved bits
    RXV_TXOP_DUR[14..8]          - (RW) Force RXV TXOP_DUR value
    RESERVED15[30..15]           - (RO) Reserved bits
    RXV_BYPASS_EN[31]            - (RW) Trigger RX supported NSS value

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TFRXV_RXV_BYPASS_EN_ADDR               BN0_WF_RMAC_TOP_TFRXV_ADDR
#define BN0_WF_RMAC_TOP_TFRXV_RXV_BYPASS_EN_MASK               0x80000000                // RXV_BYPASS_EN[31]
#define BN0_WF_RMAC_TOP_TFRXV_RXV_BYPASS_EN_SHFT               31
#define BN0_WF_RMAC_TOP_TFRXV_RXV_TXOP_DUR_ADDR                BN0_WF_RMAC_TOP_TFRXV_ADDR
#define BN0_WF_RMAC_TOP_TFRXV_RXV_TXOP_DUR_MASK                0x00007F00                // RXV_TXOP_DUR[14..8]
#define BN0_WF_RMAC_TOP_TFRXV_RXV_TXOP_DUR_SHFT                8
#define BN0_WF_RMAC_TOP_TFRXV_RXV_BSS_COLOR_ADDR               BN0_WF_RMAC_TOP_TFRXV_ADDR
#define BN0_WF_RMAC_TOP_TFRXV_RXV_BSS_COLOR_MASK               0x0000003F                // RXV_BSS_COLOR[5..0]
#define BN0_WF_RMAC_TOP_TFRXV_RXV_BSS_COLOR_SHFT               0

/* =====================================================================================

  ---DBGCTRL (0x820E5000 + 0x6A0)---

    DBG_USR[3..0]                - (RW) Debug port user select
    RESERVED4[7..4]              - (RO) Reserved bits
    RXV_DUMP_SEL[15..8]          - (RW) RXV DDW dump select
    MIB_USR[19..16]              - (RW) RX MIB counter User select
    RESERVED20[23..20]           - (RO) Reserved bits
    RXD_PHYACK_TO[28..24]        - (RW) MAC2PHY RXD ACK timeout value 
                                     unit: u-sec
    RXD_PHYACK_TO_EN[29]         - (RW) MAC2PHY RXD ACK timeout enable
    DBG_STS_CTRL[31..30]         - (RW) RX Debug status control
                                     2'b00: Not reset
                                     2'b01: reset at MDRDY rising
                                     2'b10: Latch one when error
                                     2'b11: Reset Status

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_DBGCTRL_DBG_STS_CTRL_ADDR              BN0_WF_RMAC_TOP_DBGCTRL_ADDR
#define BN0_WF_RMAC_TOP_DBGCTRL_DBG_STS_CTRL_MASK              0xC0000000                // DBG_STS_CTRL[31..30]
#define BN0_WF_RMAC_TOP_DBGCTRL_DBG_STS_CTRL_SHFT              30
#define BN0_WF_RMAC_TOP_DBGCTRL_RXD_PHYACK_TO_EN_ADDR          BN0_WF_RMAC_TOP_DBGCTRL_ADDR
#define BN0_WF_RMAC_TOP_DBGCTRL_RXD_PHYACK_TO_EN_MASK          0x20000000                // RXD_PHYACK_TO_EN[29]
#define BN0_WF_RMAC_TOP_DBGCTRL_RXD_PHYACK_TO_EN_SHFT          29
#define BN0_WF_RMAC_TOP_DBGCTRL_RXD_PHYACK_TO_ADDR             BN0_WF_RMAC_TOP_DBGCTRL_ADDR
#define BN0_WF_RMAC_TOP_DBGCTRL_RXD_PHYACK_TO_MASK             0x1F000000                // RXD_PHYACK_TO[28..24]
#define BN0_WF_RMAC_TOP_DBGCTRL_RXD_PHYACK_TO_SHFT             24
#define BN0_WF_RMAC_TOP_DBGCTRL_MIB_USR_ADDR                   BN0_WF_RMAC_TOP_DBGCTRL_ADDR
#define BN0_WF_RMAC_TOP_DBGCTRL_MIB_USR_MASK                   0x000F0000                // MIB_USR[19..16]
#define BN0_WF_RMAC_TOP_DBGCTRL_MIB_USR_SHFT                   16
#define BN0_WF_RMAC_TOP_DBGCTRL_RXV_DUMP_SEL_ADDR              BN0_WF_RMAC_TOP_DBGCTRL_ADDR
#define BN0_WF_RMAC_TOP_DBGCTRL_RXV_DUMP_SEL_MASK              0x0000FF00                // RXV_DUMP_SEL[15..8]
#define BN0_WF_RMAC_TOP_DBGCTRL_RXV_DUMP_SEL_SHFT              8
#define BN0_WF_RMAC_TOP_DBGCTRL_DBG_USR_ADDR                   BN0_WF_RMAC_TOP_DBGCTRL_ADDR
#define BN0_WF_RMAC_TOP_DBGCTRL_DBG_USR_MASK                   0x0000000F                // DBG_USR[3..0]
#define BN0_WF_RMAC_TOP_DBGCTRL_DBG_USR_SHFT                   0

/* =====================================================================================

  ---RXV_DUMP0 (0x820E5000 + 0x6B0)---

    RXV_DW0[31..0]               - (RO) RXV Dump DW0

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXV_DUMP0_RXV_DW0_ADDR                 BN0_WF_RMAC_TOP_RXV_DUMP0_ADDR
#define BN0_WF_RMAC_TOP_RXV_DUMP0_RXV_DW0_MASK                 0xFFFFFFFF                // RXV_DW0[31..0]
#define BN0_WF_RMAC_TOP_RXV_DUMP0_RXV_DW0_SHFT                 0

/* =====================================================================================

  ---RXV_DUMP1 (0x820E5000 + 0x6B4)---

    RXV_DW1[31..0]               - (RO) RXV Dump DW1

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RXV_DUMP1_RXV_DW1_ADDR                 BN0_WF_RMAC_TOP_RXV_DUMP1_ADDR
#define BN0_WF_RMAC_TOP_RXV_DUMP1_RXV_DW1_MASK                 0xFFFFFFFF                // RXV_DW1[31..0]
#define BN0_WF_RMAC_TOP_RXV_DUMP1_RXV_DW1_SHFT                 0

/* =====================================================================================

  ---RX_STS0 (0x820E5000 + 0x6C0)---

    RXV_STS[15..0]               - (RO) RXV Status dump
    RXD_STS[27..16]              - (RO) RXD Status dump
    RESERVED28[31..28]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RX_STS0_RXD_STS_ADDR                   BN0_WF_RMAC_TOP_RX_STS0_ADDR
#define BN0_WF_RMAC_TOP_RX_STS0_RXD_STS_MASK                   0x0FFF0000                // RXD_STS[27..16]
#define BN0_WF_RMAC_TOP_RX_STS0_RXD_STS_SHFT                   16
#define BN0_WF_RMAC_TOP_RX_STS0_RXV_STS_ADDR                   BN0_WF_RMAC_TOP_RX_STS0_ADDR
#define BN0_WF_RMAC_TOP_RX_STS0_RXV_STS_MASK                   0x0000FFFF                // RXV_STS[15..0]
#define BN0_WF_RMAC_TOP_RX_STS0_RXV_STS_SHFT                   0

/* =====================================================================================

  ---RX_STS2 (0x820E5000 + 0x6C4)---

    TFP_STS[15..0]               - (RO) RX Trigger Frame Parser status Dump
    RESERVED16[31..16]           - (RO) Reserved bits

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RX_STS2_TFP_STS_ADDR                   BN0_WF_RMAC_TOP_RX_STS2_ADDR
#define BN0_WF_RMAC_TOP_RX_STS2_TFP_STS_MASK                   0x0000FFFF                // TFP_STS[15..0]
#define BN0_WF_RMAC_TOP_RX_STS2_TFP_STS_SHFT                   0

/* =====================================================================================

  ---RX_STS3 (0x820E5000 + 0x6C8)---

    RDP_STS[31..0]               - (RO) RX RDP status dump

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_RX_STS3_RDP_STS_ADDR                   BN0_WF_RMAC_TOP_RX_STS3_ADDR
#define BN0_WF_RMAC_TOP_RX_STS3_RDP_STS_MASK                   0xFFFFFFFF                // RDP_STS[31..0]
#define BN0_WF_RMAC_TOP_RX_STS3_RDP_STS_SHFT                   0

/* =====================================================================================

  ---TF_USERTONE0 (0x820E5000 + 0x6D0)---

    USR_TONE_31_0[31..0]         - (RW) Trigger RX User Tone vlaue

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TF_USERTONE0_USR_TONE_31_0_ADDR        BN0_WF_RMAC_TOP_TF_USERTONE0_ADDR
#define BN0_WF_RMAC_TOP_TF_USERTONE0_USR_TONE_31_0_MASK        0xFFFFFFFF                // USR_TONE_31_0[31..0]
#define BN0_WF_RMAC_TOP_TF_USERTONE0_USR_TONE_31_0_SHFT        0

/* =====================================================================================

  ---TF_USERTONE1 (0x820E5000 + 0x6D4)---

    USR_TONE_47_32[15..0]        - (RW) Trigger RX User Tone vlaue
    RESERVED16[30..16]           - (RO) Reserved bits
    USR_TONE_EN[31]              - (RW) Trigger RX User Tone Enable

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_TF_USERTONE1_USR_TONE_EN_ADDR          BN0_WF_RMAC_TOP_TF_USERTONE1_ADDR
#define BN0_WF_RMAC_TOP_TF_USERTONE1_USR_TONE_EN_MASK          0x80000000                // USR_TONE_EN[31]
#define BN0_WF_RMAC_TOP_TF_USERTONE1_USR_TONE_EN_SHFT          31
#define BN0_WF_RMAC_TOP_TF_USERTONE1_USR_TONE_47_32_ADDR       BN0_WF_RMAC_TOP_TF_USERTONE1_ADDR
#define BN0_WF_RMAC_TOP_TF_USERTONE1_USR_TONE_47_32_MASK       0x0000FFFF                // USR_TONE_47_32[15..0]
#define BN0_WF_RMAC_TOP_TF_USERTONE1_USR_TONE_47_32_SHFT       0

/* =====================================================================================

  ---MISC4 (0x820E5000 + 0x6E0)---

    MDP_MYADDR_SRCH_DLY[3..0]    - (RW) RX MDP MY address search delay
    RXB_ALLOC_USR_CHK_DIS[4]     - (RW) Bypass RX allocate buffer total  user check disable
                                     1'b0: check  
                                     1'b1: disable check
    PHY2MAC_RXFIFO_EN[5]         - (RW) RX PHY to MAC RXFIFO SRAM enable
    RESERVED6[7..6]              - (RO) Reserved bits
    RXV_NDP_IND_EN[8]            - (RW) RX NDP check RXV NDP_IND flag
                                     1'b0: Disable
                                     1'b1: Enable
    SR_RST_MAC2PHY_RX[9]         - (RW) Spitail Reuse reset PHY by diable mac2phy_rx
    FORCE_RXV_VLD[10]            - (RW) Force Pre-USER RXV_VLD valiad
                                     1'b0: Check RXV_VLD bit
                                     1'b1: Disable check RXV_VLD bit
    DIS_MEM_WEP[11]              - (RW) Disable Mamagement packet security payload skip
    TRBW_FIFO_WLEVEL[14..12]     - (RW) RX TRBW_FIFO water level, if FIFO FULL will stop PHY2MAC SRAM access
    RESERVED15[15]               - (RO) Reserved bits
    RXD_MDRDY_FALL_TO[20..16]    - (RW) RX PHY2MAC_MDRDY falling timeout, it will reset PHY2MAC SRAM to stop RX.
                                     Default 10usec.
    RESERVED21[30..21]           - (RO) Reserved bits
    PHY2MAC_RESET[31]            - (WC) Reset PHY2MAC RXD interface

 =====================================================================================*/
#define BN0_WF_RMAC_TOP_MISC4_PHY2MAC_RESET_ADDR               BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_PHY2MAC_RESET_MASK               0x80000000                // PHY2MAC_RESET[31]
#define BN0_WF_RMAC_TOP_MISC4_PHY2MAC_RESET_SHFT               31
#define BN0_WF_RMAC_TOP_MISC4_RXD_MDRDY_FALL_TO_ADDR           BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_RXD_MDRDY_FALL_TO_MASK           0x001F0000                // RXD_MDRDY_FALL_TO[20..16]
#define BN0_WF_RMAC_TOP_MISC4_RXD_MDRDY_FALL_TO_SHFT           16
#define BN0_WF_RMAC_TOP_MISC4_TRBW_FIFO_WLEVEL_ADDR            BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_TRBW_FIFO_WLEVEL_MASK            0x00007000                // TRBW_FIFO_WLEVEL[14..12]
#define BN0_WF_RMAC_TOP_MISC4_TRBW_FIFO_WLEVEL_SHFT            12
#define BN0_WF_RMAC_TOP_MISC4_DIS_MEM_WEP_ADDR                 BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_DIS_MEM_WEP_MASK                 0x00000800                // DIS_MEM_WEP[11]
#define BN0_WF_RMAC_TOP_MISC4_DIS_MEM_WEP_SHFT                 11
#define BN0_WF_RMAC_TOP_MISC4_FORCE_RXV_VLD_ADDR               BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_FORCE_RXV_VLD_MASK               0x00000400                // FORCE_RXV_VLD[10]
#define BN0_WF_RMAC_TOP_MISC4_FORCE_RXV_VLD_SHFT               10
#define BN0_WF_RMAC_TOP_MISC4_SR_RST_MAC2PHY_RX_ADDR           BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_SR_RST_MAC2PHY_RX_MASK           0x00000200                // SR_RST_MAC2PHY_RX[9]
#define BN0_WF_RMAC_TOP_MISC4_SR_RST_MAC2PHY_RX_SHFT           9
#define BN0_WF_RMAC_TOP_MISC4_RXV_NDP_IND_EN_ADDR              BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_RXV_NDP_IND_EN_MASK              0x00000100                // RXV_NDP_IND_EN[8]
#define BN0_WF_RMAC_TOP_MISC4_RXV_NDP_IND_EN_SHFT              8
#define BN0_WF_RMAC_TOP_MISC4_PHY2MAC_RXFIFO_EN_ADDR           BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_PHY2MAC_RXFIFO_EN_MASK           0x00000020                // PHY2MAC_RXFIFO_EN[5]
#define BN0_WF_RMAC_TOP_MISC4_PHY2MAC_RXFIFO_EN_SHFT           5
#define BN0_WF_RMAC_TOP_MISC4_RXB_ALLOC_USR_CHK_DIS_ADDR       BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_RXB_ALLOC_USR_CHK_DIS_MASK       0x00000010                // RXB_ALLOC_USR_CHK_DIS[4]
#define BN0_WF_RMAC_TOP_MISC4_RXB_ALLOC_USR_CHK_DIS_SHFT       4
#define BN0_WF_RMAC_TOP_MISC4_MDP_MYADDR_SRCH_DLY_ADDR         BN0_WF_RMAC_TOP_MISC4_ADDR
#define BN0_WF_RMAC_TOP_MISC4_MDP_MYADDR_SRCH_DLY_MASK         0x0000000F                // MDP_MYADDR_SRCH_DLY[3..0]
#define BN0_WF_RMAC_TOP_MISC4_MDP_MYADDR_SRCH_DLY_SHFT         0

#ifdef __cplusplus
}
#endif

#endif // __BN0_WF_RMAC_TOP_REGS_H__
