//
// Created by boalin on 7/25/17.
//

#ifndef MTK_DUT_MTK_AP_H
#define MTK_DUT_MTK_AP_H
#include "mtk_parse.h"
#include "mtk_dict.h"
#include <wfa_tlv.h>
#include "mtk_resp.h"
#include <ctype.h>

#define PROC_NET_WIRELESS "/proc/net/wireless"
#define PROFILE_INF	"/etc/wireless/l1profile.dat"
#define INTF_NUM	3
#define MAX_CARD_NUM	2
#define MAX_INTF_NUM	3
#define INTF_NAME_LEN	16
#define PROF_NAME_LEN	60
#define POST_CMD_NUM	32

extern char gIPaddr[20];
extern unsigned char l1_valid;

dict_t global_jedi_hostapd_interface1_dat_dict;
dict_t global_jedi_hostapd_interface2_dat_dict;
dict_t global_jedi_hostapd_key_dict;
#define OID_GET_WIRELESS_BAND 0x09B4

static str_to_str_tbl_t PunctChan_TonePlan_tbl[] = {
	{"40", "192:113:192:192:0"},
	{"44", "192:192:113:192:0"},
	{"48", "192:192:192:113:0"},
	{"33", "113:192:192:192:0"},
	{"41", "192:192:113:192:0"},
	{"45", "192:192:192:113:0"}
};

static str_to_str_tbl_t PunctChan_RuAlloc_tbl[] = {
	{"40", "0:61:0:63:0:64"},
	{"44", "0:61:0:62:0:64"},
	{"48", "0:61:0:62:0:63"},
	{"33", "0:62:0:63:0:64"},
	{"41", "0:61:0:62:0:64"},
	{"45", "0:61:0:62:0:63"}
};

typedef unsigned char uint8_t;

typedef enum wifi_mode { WIFI_UNKNOWN = 0, WIFI_2G, WIFI_5G, WIFI_6G, NORMAL} wifi_mode;

typedef enum device_type { DUT, TESTBED, UNKNOWN } device_type;

typedef enum wireless_band { W_BAND_2G = 0, W_BAND_5G, W_BAND_6G, W_BAND_INVALID = -1 } wireless_band;

typedef struct intf_profile {
	char name[INTF_NAME_LEN];		/* interface name ra0, rax0, etc */
	char profile[PROF_NAME_LEN];		/* profile directory and name */
	char profile_bak[PROF_NAME_LEN];	/* original profile */
	char profile_cmt[PROF_NAME_LEN];	/* profile for last committed */
	char sigma_dut_profile[PROF_NAME_LEN];
	char sigma_tb_profile[PROF_NAME_LEN];
	/********jedi_hostapd********/
	char jedi_hostapd_profile[PROF_NAME_LEN];
	char jedi_hostapd_mbss_profile[PROF_NAME_LEN];
	char jedi_hostapd_profile_bak[PROF_NAME_LEN];
	char jedi_hostapd_profile_cmt[PROF_NAME_LEN];
	char jedi_hostapd_sigma_profile[PROF_NAME_LEN];
	char jedi_hostapd_mbss_sigma_profile[PROF_NAME_LEN];
	char jedi_hostapd_owe_sigma_profile[PROF_NAME_LEN];
	char jedi_hostapd_wpa3r2_sigma_profile[PROF_NAME_LEN];
	/********jedi_hostapd********/
} intf_profile_t;

typedef struct hostapd_qos {
	char cwmin_VO;
	char cwmin_VI;
	char cwmin_BE;
	char cwmin_BK;
	char cwmax_VO;
	char cwmax_VI;
	char cwmax_BE;
	char cwmax_BK;
	char AIFS_VO;
	char AIFS_VI;
	char AIFS_BE;
	char AIFS_BK;
	char TXOP_VO;
	char TXOP_VI;
	char TXOP_BE;
	char TXOP_BK;
	char ACM_VO;
	char ACM_VI;
	char ACM_BE;
	char ACM_BK;
} hostapd_qos_t;

struct neighbor_s {
	char bssid[6];
	unsigned char op_class;
	unsigned char op_ch;
	unsigned char pref;
};

struct hostapd_ppr_t {
	/* mbss h220 */
	char hs20[2];
	char hs20_release;
	char manage_p2p;
	char ht_bw;
	char vht_bw;
	/* mbss interworking */
	char interworking[2];
	char access_network_type;
	char internet;
	char venue_group;
	char venue_type;
	char venue_name[2][120];
	char hessid[WFA_MAC_ADDR_STR_LEN];
	char roaming_consortium[2][20];
	char advertisement_proto_id;
	char domain_name[40];
	char network_auth_type[40];
	char operator_icon[20];
	char osu_ssid[20];
	/* char ipv4_type; */
	/* char ipv6_type; */
	char nai_realm[4][40];
	char hs20_oper_friendly_name[2][40];
	char hs20_conn_capab[11][12];
	char hs20_wan_metrics[40];
	int hs20_operating_class;
	char hs20_t_c_filename[40];
	char hs20_t_c_server_url[40];
	char hs20_t_c_timestamp[40];
	char ipaddr_type_availability[3];
	char disable_dgaf;
	char proxy_arp;
	char l2_filter;
	char icmpv4_deny;
	char mmpdu_size;
	char external_anqp_server_test;
	short gas_comeback_delay;
	char gas_frag_limit;
	char anqp_3gpp_cell_net[60];
	char anqp_domain_id;
	char venue_url[10][84];
	char hs2_openmode_test;
	char hs20_icon[2][68];
	char osu_server_uri[96];
	char osu_friendly_name[4][60];
	char osu_method_list[2];
	char osu_icon[2][20];
	char osu_nai[2][60];
	char osu_nai2[2][60];
	char osu_service_desc[2][60];
	char osu_nai2_configured;
	char legacy_osu;
	char qosmap;
	char qos_map_set[64];
	char dscp_range;
	char dscp_exception;
	char qload_test;
	char qload_cu;
	char qload_sta_cnt;
	char icon_tag;
	char advice_of_charge[3][60];
	int radius_das_port;
	int radius_das_time_window;
	char radius_das_require_event_timestamp[10];
	int radius_das_require_message_authenticator;
	char radius_das_client[25];
};

typedef struct intf_desc {
	char name[INTF_NAME_LEN];
	wifi_mode mode;
	dict_t dict_table;
	intf_profile_t *profile_names;
	int status;
	int mbss_en;
	int dot11vmbss_en;
	int bss_idx;
	int bss_num;
	int WLAN_TAG[5];
	int WLAN_TAG_bss_num;
	int security_set;
	int UL_MUMIMO;
	int DL;
	int SMPS;
	char phy_no;
	char PMF_MFPC[15];
	char PMF_MFPR[15];
	char PWDIDR[15];
	char AuthModeBSSID[5][20];
	char EncryptBSSID[5][10];
	char SSID[32];

	/*********hostapd begin***********/
	unsigned char channel;
	char band;
	char driver_conf[WFA_NAME_LEN];
	char inf_name[WFA_IF_NAME_LEN];
	char ctrl_inf[WFA_NAME_LEN];

	char ip_addr[WFA_IP_ADDR_STR_LEN];
	char ip_netmask[WFA_IP_MASK_STR_LEN];

	char ssid[2][WFA_SSID_NAME_LEN];
	enum ENUM_AP_MODE ap_mode;
	int rts;
	int frgmnt;
	int bcnint;
	int dtim_period;
	enum ENUM_CHANNEL_WIDTH ch_width;
	enum ENUM_CHANNEL_OFFSET ch_offset;
	enum wfa_state pmf;
	char passphrase[101];
	char wepkey[27];
	enum wfa_state wme;
	enum wfa_state wmmps;
	enum wfa_state p2p_mgmt;
	char country_code[3];
	enum wfa_state sgi20;
	enum wfa_state sgi40;
	enum wfa_state sgi80;
	enum wfa_state sgi160;
	enum wfa_state sig_rts;
	enum wfa_state dynamic_bw_signaling;
	enum wfa_state preauthentication;
	enum wfa_state sha256ad;
	enum ENUM_KEY_MGNT_TYPE keyMgmtType[2];
	enum ENUM_ENCP_TYPE encpType[2];
	char encpTypeM[64];
	enum ENUM_ENCP_TYPE GroupCipherType;
	enum ENUM_ENCP_TYPE GroupMgntCipherType;
	char trans_disable;
	char sae_pwe;
	char sae_pk;
	char sae_pk_keypair[500];
	char sae_pk_modifier[200];
	enum ENUM_PROGRAME_TYPE program;
	int intf_6G_only;
	enum wfa_state txbf;
	char stbc;
	char ht_coex;
	char ap_isolate;
	char ap_ecGroupID[64];
	char spatialTxStream;
	char spatialRxStream;
	char disassoc_low_ack;
	char skip_inactivity_poll;
	char preamble;
	char ignore_broadcast_ssid;
	char uapsd_advertisement_enabled;
	char utf8_ssid;
	char multi_ap;
	char auth_algs;
	char bss_color;
	int antiCloggingThreshold;
	int ap_reflection;
	char ap_sae_commit_override[1024];
	int bcc_mode;
	int mcs_fixedrate;
	int mcs_fixedrate_rate;
	int max_amsdu;
	int max_mpdu;
	int max_ampdu;
	int bss_load_update_period;
	int chan_util_avg_period;
	int mimo;
	int he_rts_threshold;
	char auth_server_addr[WFA_MAX_BSS_NUM * (WFA_IP_ADDR_STR_LEN + 1)];
	char auth_server_port[WFA_MAX_BSS_NUM * (WFA_RADIUS_PORT_LEN + 1)];
	char auth_server_shared_secret[128];
	char bssid[WFA_MAC_ADDR_STR_LEN];

	char cmd_name[64];
	char keymgnt[42];
	char ft_oa;
	char ft_ds;
	char mac_addr[WFA_MAC_ADDR_STR_LEN];
	char ft_bss_list[150];
	char KeyRotation;
	char KeyRotationInterval;
	char KeyRotation_BIGTK_STADisassoc;
	char unsol_bcast_probe_resp_interval;
	char rnr;

	struct hostapd_ppr_t ppr;

	/*********hostapd end***********/

	/* qos begin */
	hostapd_qos_t ap_qos;
	hostapd_qos_t sta_qos;
	/* qos end */
	/* mbo begin */
	unsigned char mbo;
	unsigned char oce;
	unsigned char frame_opclass;
	int BTMReq_Term_Bit;
	unsigned int BSS_Term_Duration;
	int BTMReq_DisAssoc_Imnt;
	int BTMReq_BSS_Term_TSF;
	struct neighbor_s neighbor[3];
	unsigned char nr_count;
	/* mbo end */
	/********jedi_hostapd begin********/
	dict_t jedi_hostapd_dict_table;
	dict_t jedi_hostapd_mbss_dict_table;
	char jedi_hostapd_osu_nai2_configured;
	char jedi_hostapd_l2_filter[5];
	char jedi_hostapd_osu_enable[5];
	char jedi_hostapd_icmpv4_deny[5];
	char jedi_hostapd_dgaf_disable[5];
	char jedi_hostapd_proxy_arp[5];
	/********jedi_hostapd end********/
} intf_desc_t;

typedef struct cmdline_cfg {
	char program[20];
	char mode[20];
	int intf_rst_delay;
	int post_intf_rst_delay;
} cmdline_cfg_t;

typedef struct internal_flag {
	int committed;
	int BW_5G_set;
	int vie_op;
	int capi_dual_pf;
	char eht_dual_pf;
	char cert_dat_copied;
	char wifi_restarted;
	int band_cnt;
} internal_flag_t;

typedef struct band_6G_only {
	int intf_6G_only;
	int intf_2G_orig_stat;
	int intf_5G_orig_stat;
} band_6G_only_t;

typedef struct WLAN_TAG {
	int TAG[3];
	int TxBSS;
} WLAN_TAG_t;

typedef struct mtk_ap_buf {
	cmdline_cfg_t cmd_cfg;
	internal_flag_t intern_flag;
	char lan_IPaddr[20];
	device_type dev_type;
	intf_profile_t profile_names[INTF_NUM];
	intf_profile_t *profile_names_list;
	int profile_num;
	enum ENUM_PROGRAME_TYPE program;
	int tb_profile_exist;
	int ioctl_sock; /* socket for ioctl() use */
	char updated_band[64];
	wifi_mode def_mode;
	capi_data_t *capi_data;
	dict_t commit_dict;
	dict_t key_translation_table;
	dict_t jedi_hostapd_commit_dict;
	dict_t jedi_hostapd_key_translation_table;
	int WLAN_TAG;
	intf_desc_t intf_2G, intf_5G, intf_6G;
	intf_desc_t *WLAN_TAG_inf[3];
	WLAN_TAG_t WLAN_TAG_2G, WLAN_TAG_5G, WLAN_TAG_6G;
	intf_desc_t *def_intf;
	int post_cmd_idx;
	char post_commit_cmd[POST_CMD_NUM][512];
	int WappEnable;
	char Reg_Domain[20];
	int DisAssoc_Imnt;
	band_6G_only_t Band6Gonly;
	int IsMethodSet;
	char osu_method[3];
	char osu_server_uri[100];
	int IsPlmnSet;
	char plm_mcc[50];
	int IsMediatekHS2NAISet;
	char *client_mac;
	char hostapd_bin[64];
	char application[20];
	get_cmd_tag_ptr get_cmd_tag;
	mtk_ap_exec_ptr mtk_ap_exec;
} mtk_ap_buf_t;

// define ap CAPI function
typedef int (*cmd_parse_ptr)(char *, uint8_t *, int *);
typedef int (*cmd_mtk_ptr)(int, uint8_t *, int *, uint8_t *);
typedef int (*cmd_resp_ptr)(uint8_t *, retType_t);

typedef struct type_dut_table {
	int type;
	char name[32];
	cmd_parse_ptr cmd_parse;
	cmd_mtk_ptr cmd_mtk;
	cmd_resp_ptr cmd_resp;
} typeDUT_t;

typedef struct capi_to_profile_table {
	char capi_name[64];
	char dat_name[64];
} capi_profile_t;

typedef int (*iw_enum_handler)(int, char *, void *, int);

int device_get_ver();
int init_profile_name(int, mtk_ap_buf_t *);
int is_wifi_interface_exist(int, const char *);
int is_interface_up(int, const char *);
int wifi_interface_chan(int, const char *);
void ifconfig_interface_down(const char *interface);
char *wifi_get_ifname(char *, int, char *);
char *wifi_interface_ssid(int, const char *);
void turn_all_interface_down_up(mtk_ap_buf_t *);
int check_turn_interface_down(int, char *, void *, int);
int fillup_intf(int, char *, void *, int);
int wifi_enum_devices(int, iw_enum_handler, void *, int);
int ap_init(mtk_ap_buf_t *);
int mtk_ap_exec(uint8_t *, uint8_t *, uint8_t *, int, int *, int);

// MTK DUT execution
int mtk_device_get_info(int, uint8_t *, int *, uint8_t *);
int mtk_ap_ca_version(int, uint8_t *, int *, uint8_t *);
int mtk_ap_config_commit(int, uint8_t *, int *, uint8_t *);
int mtk_ap_deauth_sta(int, uint8_t *, int *, uint8_t *);
int mtk_ap_get_mac_address(int, uint8_t *, int *, uint8_t *);
int mtk_ap_reset_default(int, uint8_t *, int *, uint8_t *);

int mtk_ap_send_addba_req(int, uint8_t *, int *, uint8_t *);
int mtk_ap_send_bcnrpt_req(int, uint8_t *, int *, uint8_t *);
int mtk_ap_send_bsstrans_mgmt_req(int, uint8_t *, int *, uint8_t *);
int mtk_ap_send_link_mea_req(int, uint8_t *, int *, uint8_t *);
int mtk_ap_send_tsmrpt_req(int, uint8_t *, int *, uint8_t *);

int mtk_ap_set_11d(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_11h(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_11n_wireless(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_apqos(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_hs2(int, uint8_t *, int *, uint8_t *);

int mtk_ap_set_pmf(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_radius(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_rfeature(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_rrm(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_security(int, uint8_t *, int *, uint8_t *);

int mtk_ap_set_staqos(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_wireless(int, uint8_t *, int *, uint8_t *);
int mtk_dev_configure_ie(int, uint8_t *, int *, uint8_t *);
int mtk_dev_exec_action(int, uint8_t *, int *, uint8_t *);
int mtk_dev_send_frame(int, uint8_t *, int *, uint8_t *);
int mtk_ap_get_parameter(int, uint8_t *, int *, uint8_t *);
int mtk_traffic_send_ping(int, uint8_t *, int *, uint8_t *);
int mtk_traffic_stop_ping(int, uint8_t *, int *, uint8_t *);
int mtk_traffic_agent_reset(int, uint8_t *, int *, uint8_t *);
int mtk_ignore_capi(int, uint8_t *, int *, uint8_t *);
int mtk_ap_set_qos(int, uint8_t *, int *, uint8_t *);
int mtk_send_qos_cmd_to_wapp(char *, char *, char *, char *);

void read_mac_address_file(char *mac_address_buf, char *interface, mtk_ap_buf_t *mtk_ap_buf);

#define RT_PRIV_IOCTL (SIOCIWFIRSTPRIV + 0x01)
#define OID_DUT_GET_REJECTED_GROUP 0x1100

extern typeDUT_t dut_tbl[];
extern str_to_str_tbl_t hostapd_AKM_keymgnt_tbl[];
extern str_to_str_tbl_t PweMethod_tbl[];
extern char Device_Ver[];
extern const char CA_Ver[];
extern str_to_str_tbl_t SAE_PK_Group_tbl[];

/*
 * about dictionary and IO for AP mode
 */
void backup_profile(mtk_ap_buf_t *);
void apply_sigma_profile(mtk_ap_buf_t *, device_type);
void restore_profile(mtk_ap_buf_t *);
dict_t init_capi_key_dict();
dict_t init_2g_dict(mtk_ap_buf_t *);
dict_t init_5g_dict(mtk_ap_buf_t *);
dict_t init_6g_dict(mtk_ap_buf_t *);

dict_t init_jedi_hostapd_capi_key_dict(void);
dict_t init_jedi_hostapd_2g_dict(mtk_ap_buf_t *);
dict_t init_jedi_hostapd_2g_mbss_dict(mtk_ap_buf_t *);
dict_t init_jedi_hostapd_5g_dict(mtk_ap_buf_t *);
dict_t init_jedi_hostapd_5g_mbss_dict(mtk_ap_buf_t *);

void add_post_cmd(mtk_ap_buf_t *mtk_ap_buf);
void remove_post_cmd(mtk_ap_buf_t *mtk_ap_buf, char *rm_str);
void handle_post_cmd(mtk_ap_buf_t *mtk_ap_buf);
void reassign_sigma_dut_profile(mtk_ap_buf_t *mtk_ap_buf);
void update_capi_dual_table(uint8_t *, char *, char *);

extern typeDUT_t hostapd_dut_tbl[];
extern int wifi_intf_fd;

#endif // MTK_DUT_MTK_AP_H
