#ifndef _WFA_PROFILE_H_
#define _WFA_PROFILE_H_

#if defined(MTK_FIRST_CARD_MT7615) && defined(MTK_SECOND_CARD_MT7615)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7615e.1.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7615e.2.dat"
#elif defined(MTK_SKU_AX4200)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7986-ax4200.dbdc.b0.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7986-ax4200.dbdc.b1.dat"
#elif defined(MTK_SKU_AX6000)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7986-ax6000.dbdc.b0.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7986-ax6000.dbdc.b1.dat"
#elif defined(MTK_SKU_AX7800)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7916-ax7800.dbdc.b0.dat"
#ifdef MTK_SKU_AX7800_255
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7916-ax7800-5G.dbdc.b1.dat"
#else
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7916-ax7800.dbdc.b1.dat"
#endif
#define WIFI_PROFILE_3 "/etc/wireless/mediatek/mt7986-ax7800.dbdc.b1.dat"
#elif defined(MTK_SKU_AX8400)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7986-ax8400.dbdc.b0.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7986-ax8400.dbdc.b1.dat"
#define WIFI_PROFILE_3 "/etc/wireless/mediatek/mt7915.ax8400.5g.dat"
#elif defined(MTK_FIRST_CARD_MT7902)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/bellwether.2.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/bellwether.1.dat"
#elif defined(MTK_FIRST_CARD_MT7990)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7990.b0.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7990.b1.dat"
#define WIFI_PROFILE_3 "/etc/wireless/mediatek/mt7990.b2.dat"
#elif defined(MTK_FIRST_CARD_MT7992)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7992.b0.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7992.b1.dat"
#elif defined(MTK_FIRST_CARD_MT7981)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7981.dbdc.b0.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7981.dbdc.b1.dat"
#elif defined(MTK_FIRST_CARD_MT7916)
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7916.dbdc.b0.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7916.dbdc.b1.dat"
#else
#define WIFI_PROFILE_1 "/etc/wireless/mediatek/mt7915.1.dat"
#define WIFI_PROFILE_2 "/etc/wireless/mediatek/mt7915.2.dat"
#endif

#if defined(MTK_DBDC_PROFILE) || defined(MTK_FIRST_CARD_MT7990) || defined(MTK_FIRST_CARD_MT7992)
#define WIFI_TEST_PROFILE_1 "/etc/wireless/sigma_test/wifi_cert_b0.dat"
#define WIFI_TEST_PROFILE_2 "/etc/wireless/sigma_test/wifi_cert_b1.dat"
#ifdef WIFI_PROFILE_3
#define WIFI_TEST_PROFILE_3 "/etc/wireless/sigma_test/wifi_cert_b2.dat"
#endif /* WIFI_PROFILE_3 */
#elif defined(MTK_FIRST_CARD_MT7615) && defined(MTK_SECOND_CARD_MT7615)
#define WIFI_TEST_PROFILE_1 "/etc/wireless/sigma_test/wifi_cert.1.dat"
#define WIFI_TEST_PROFILE_2 "/etc/wireless/sigma_test/wifi_cert.2.dat"
#else
#define WIFI_TEST_PROFILE_1 "/etc/wireless/mediatek/wifi_cert.1.dat"
#define WIFI_TEST_PROFILE_2 "/etc/wireless/mediatek/wifi_cert.2.dat"
#endif /* !MTK_DBDC_PROFILE */

#define PROFILE_NAME_LEN	64

typedef struct wfa_wifi_profile {
	char default_profile[PROFILE_NAME_LEN];
	char testing_profile[PROFILE_NAME_LEN];
} wfa_wifi_profile_t;

#endif /* _WFA_PROFILE_H_ */
