/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include "bss_mnger.h"
#include "interface.h"
#include "driver_wext.h"
#include "debug.h"

#define SYSNET_DIR "/sys/class/net"
#define WIFI_PREFIX "ra"

#ifdef BSSMNGER_SUPPORT

const struct bssmnger_drv_ops bssmnger_drv_wext_ops = {
	.drv_bssmnger_param_setting = driver_wext_bssmnger_param_setting,
	.drv_bssmnger_set_bmgentry = driver_wext_bssmnger_set_bmgentry,
	.drv_bssmnger_get_bmgentry = driver_wext_bssmnger_get_bmgentry,
};

int check_wdev_stat(const char *ifname)
{
	int err = -1;
	struct ifreq ifr;
	int sd = -1;
	int ret = 0;

	sd = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ARP));
	if (sd <= 0) {
		DBGPRINT(RT_DEBUG_ERROR, "%s() socket error\n", __func__);
		goto out;
	}

	if (strlen(ifname) > (IFNAMSIZ - 1)) {
		DBGPRINT(RT_DEBUG_ERROR, "%s() Too long interface name\n", __func__);
		goto out;
	}

	ret = os_snprintf(ifr.ifr_name, IFNAMSIZ, "%s", ifname);

	if (os_snprintf_error(sizeof(ifr.ifr_name), ret))
		goto out;

	if (ioctl(sd, SIOCGIFINDEX, &ifr) == -1) {
		DBGPRINT(RT_DEBUG_ERROR, "%s() Interface %s down\n", __func__, ifname);
		goto out;
	}

	if ((ioctl(sd, SIOCGIWNAME, &ifr)) >= 0)
		DBGPRINT(RT_DEBUG_ERROR, "%s() %s is Wireless Dev\n", __func__, ifname);

	err = 0;
out:
	if (sd >= 0)
		close(sd);

	return err;
}


int insert_bmg_entry(struct bssmnger_cfg *bss_mnger, const char *ifname)
{
	int ret = BSSMNGER_SUCCESS;
	struct bmg_entry *new;

	new = os_malloc(sizeof(struct bmg_entry));
	if (new == NULL) {
		DBGPRINT(RT_DEBUG_ERROR, "%s alloc memory failed\n", __func__);
		ret = BSSMNGER_UNEXP;
	}

	DBGPRINT(RT_DEBUG_ERROR, YLW("%s() add ifname %s\n"), __func__, ifname);
	os_memset(new, 0, sizeof(struct bmg_entry));
	strncpy((char *)(new->devinfo.ifname), ifname, IFNAMSIZ);
	bss_mnger->bssentry_db.dev_cnt++;
	dl_list_add_tail(&bss_mnger->bssentry_db.bssentry_list, &new->list);

	return ret;
}

int bssmnger_init(struct bssmnger_cfg *bss_mnger)
{
	DIR *dp;
	struct dirent *ep;
	int ret = BSSMNGER_SUCCESS;

	bss_mnger->drv_ops = &bssmnger_drv_wext_ops;
	os_memset(&(bss_mnger->bssentry_db), 0, sizeof(struct bss_mnger));
	dl_list_init(&(bss_mnger->bssentry_db.bssentry_list));

	DBGPRINT(RT_DEBUG_TRACE, BLUE("%s() enter\n"), __func__);

	dp = opendir(SYSNET_DIR);
	if (dp != NULL) {
		while ((ep = readdir(dp))) {

			if (strlen(ep->d_name) <= 2)
				continue;

			if (strncmp(ep->d_name, WIFI_PREFIX, 2))
				continue;

			/* check if the interface is a wireless interface */
			DBGPRINT(RT_DEBUG_TRACE, BLUE("%s() check ifname %s\n"), __func__, ep->d_name);
			if (check_wdev_stat(ep->d_name) == BSSMNGER_SUCCESS)
				insert_bmg_entry(bss_mnger, ep->d_name);
		}
		closedir(dp);
		bss_mnger->bssentry_db.inited = BSSMNGER_INITIALIZING;
	} else {
		DBGPRINT(RT_DEBUG_ERROR, "%s() Couldn't open the directory\n", __func__);
		bss_mnger->bssentry_db.inited = BSSMNGER_UNINITIALIZED;
		ret = BSSMNGER_UNEXP;
	}
	return ret;
}



int bssmnger_update_self_database(struct wifi_app *wapp, unsigned char type, struct bmg_entry *input)
{
	struct bssmnger_cfg *bss_mnger = wapp->bss_mnger;
	struct bmg_entry *new, *curr;
	u8 is_found = 0;

	/* skip incorrect bmg entry */
	if (input->devinfo.ifindex == 0 || input->modinfo.chip_id == 0)
		return is_found;

	dl_list_for_each(curr, &bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {
		DBGPRINT(RT_DEBUG_ERROR, "Current=> ifindex %d, ifname %s\n", curr->devinfo.ifindex, curr->devinfo.ifname);
		if (os_strcmp((const char *)curr->devinfo.ifname, (const char *)input->devinfo.ifname) == 0 &&
			curr->devinfo.ifindex == input->devinfo.ifindex){
			DBGPRINT(RT_DEBUG_ERROR, "Update=> ifindex %d, ifname %s\n", curr->devinfo.ifindex, curr->devinfo.ifname);
			if (type == BSSMNGER_MSG_REG_BMGENTRY) {
				curr->valid = input->valid;
				os_memcpy(&curr->reginfo, &input->reginfo, sizeof(struct bssmnger_reg_info));
			}
			os_memcpy(&curr->iobinfo, &input->iobinfo, sizeof(struct bssmnger_iob_info));
			os_memcpy(&curr->oobinfo, &input->oobinfo, sizeof(struct bssmnger_oob_info));
			is_found = 1;
			break;
		}
	}

	if (!is_found && (type == BSSMNGER_MSG_REG_BMGENTRY)) {
		new = os_malloc(sizeof(struct bmg_entry));
		if (new == NULL) {
			DBGPRINT(RT_DEBUG_ERROR, "%s alloc memory failed\n", __func__);
		} else {
			os_memset(new, 0, sizeof(struct bmg_entry));
			bssmnger_entry_cpy(new, input);
			bss_mnger->bssentry_db.dev_cnt++;
			dl_list_add_tail(&bss_mnger->bssentry_db.bssentry_list, &new->list);
			is_found = 1;
		}
	}

	return is_found;
}

int add_synced_modules(struct bssmnger_module_info *input, struct bssmnger_module_info mod_list[])
{
	int i = 0, ret = FALSE;

	for (i = 0 ; i < NUM_MODULES; i++) {
		if (mod_list[i].chip_id == 0) {
			mod_list[i].chip_id = input->chip_id;
			ret = TRUE;
			break;
		}
	}

	DBGPRINT(RT_DEBUG_ERROR, "%d\n", ret);
	return ret;
}

int is_synced_modules(struct bssmnger_module_info *input, struct bssmnger_module_info mod_list[])
{
	int i = 0, ret = FALSE;

	for (i = 0 ; i < NUM_MODULES; i++) {
		if (mod_list[i].chip_id == input->chip_id) {
			ret = TRUE;
			break;
		}
	}

	DBGPRINT(RT_DEBUG_ERROR, "%d\n", ret);
	return ret;
}

int bssmnger_sync_bmg_to_diff_module(struct wifi_app *wapp, struct bmg_entry *input)
{
	return bssmnger_sync_bmg_to_module(wapp, input, 1);
}

int bssmnger_sync_bmg_to_module(struct wifi_app *wapp, struct bmg_entry *input, int skip_same)
{
	int ret = 0;
	struct bssmnger_cfg *bss_mnger = wapp->bss_mnger;
	struct bmg_entry *curr;
	struct bssmnger_module_info mod_list[NUM_MODULES] = {0};

	if (input == NULL) {
		DBGPRINT(RT_DEBUG_ERROR, "%s bmg entry is NULL.\n", __func__);
		return BSSMNGER_INVALID_ARG;
	}

	if (input->modinfo.chip_id == 0 || input->devinfo.ifindex == 0) {
		DBGPRINT(RT_DEBUG_ERROR, "%s bmg entry check failed.\n", __func__);
		return BSSMNGER_INVALID_ARG;
	}

	dl_list_for_each(curr, &bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {

		if (skip_same && curr->modinfo.chip_id == input->modinfo.chip_id)
			continue;

		if (is_synced_modules(&curr->modinfo, mod_list)) {
			DBGPRINT(RT_DEBUG_ERROR, "SKIP => ifindex %d, ifname %s\n", curr->devinfo.ifindex, curr->devinfo.ifname);
			continue;
		}

		DBGPRINT(RT_DEBUG_ERROR, BLUE("SET => Data(%s) send to ifname %s\n"), input->devinfo.ifname, curr->devinfo.ifname);
		ret = bssmnger_set_bmgentry(wapp, (const char *)curr->devinfo.ifname, (char *)input, sizeof(struct bmg_entry));

		if (ret == BSSMNGER_SUCCESS)
			add_synced_modules(&curr->modinfo, mod_list);
	}

	return BSSMNGER_SUCCESS;
}

int bssmnger_sync_db_to_module(struct wifi_app *wapp)
{
	int ret = BSSMNGER_SUCCESS;
	struct bssmnger_cfg *bss_mnger = wapp->bss_mnger;
	struct bmg_entry *curr;

	dl_list_for_each(curr, &bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {

		if (curr->devinfo.ifindex == 0)
			continue;

		bssmnger_sync_bmg_to_diff_module(wapp, curr);
	}
	return ret;
}

void is_oob_discovery_required(
	unsigned char rule, unsigned int ifindex, unsigned long long *bmap_all, unsigned long long *bmap_main)
{
	if (rule == RNR_REPORTING_MAIN_BSS)
		*bmap_main |= (unsigned long long) (1 << ifindex);
	else if (rule == RNR_REPORTING_ALL_BSS)
		*bmap_all |= (unsigned long long) (1 << ifindex);
}

void bssmnger_trigger_oob_repting_bmap(struct wifi_app *wapp)
{
	struct bmg_entry *curr = NULL;
	struct bssmnger_cfg *bss_mnger = wapp->bss_mnger;

	dl_list_for_each(curr, &bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {

		if (curr->valid == 0 || curr->devinfo.ifindex == 0)
			continue;

		bssmnger_set_bmgentry(wapp, (const char *)curr->devinfo.ifname, (char *)curr, sizeof(struct bmg_entry));
	}
}

int bssmnger_update_oob_repting_bmap(struct wifi_app *wapp)
{
	int ret = BSSMNGER_SUCCESS;
	struct bssmnger_cfg *bss_mnger = wapp->bss_mnger;
	struct bmg_entry *curr = NULL;
	struct bssmnger_oob_info *oobinfo = NULL;
	struct bssmnger_radio_info *radioinfo = NULL;
	unsigned long long mainbss_2g_bmap = 0, mainbss_5g_bmap = 0, mainbss_6g_bmap = 0;
	unsigned long long allbss_2g_bmap = 0, allbss_5g_bmap = 0, allbss_6g_bmap = 0;

	dl_list_for_each(curr, &bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {
		if (curr->valid == 0 || curr->devinfo.ifindex == 0)
			continue;

		radioinfo = &curr->reginfo.radioinfo;
		oobinfo = &curr->oobinfo;

		if (WMODE_CAP_6G(radioinfo->phymode)) {
			/* is_oob_discovery_required(oobinfo->repting_rule_2g,
			 *	curr->devinfo.ifindex, &allbss_2g_bmap, &mainbss_2g_bmap);
			 */
			IS_OOB_REQ(oobinfo->repting_rule, 2g, curr->devinfo.ifindex);
			IS_OOB_REQ(oobinfo->repting_rule, 5g, curr->devinfo.ifindex);

		} else if (WMODE_CAP_2G(radioinfo->phymode)) {
			IS_OOB_REQ(oobinfo->repting_rule, 5g, curr->devinfo.ifindex);
			IS_OOB_REQ(oobinfo->repting_rule, 6g, curr->devinfo.ifindex);

		} else if (WMODE_CAP_5G(radioinfo->phymode)) {
			IS_OOB_REQ(oobinfo->repting_rule, 2g, curr->devinfo.ifindex);
			IS_OOB_REQ(oobinfo->repting_rule, 6g, curr->devinfo.ifindex);
		}
	}

	DBGPRINT(RT_DEBUG_ERROR, "2G Repting M %llx, A %llx\n", mainbss_2g_bmap, allbss_2g_bmap);
	DBGPRINT(RT_DEBUG_ERROR, "5G Repting M %llx, A %llx\n", mainbss_5g_bmap, allbss_5g_bmap);
	DBGPRINT(RT_DEBUG_ERROR, "6G Repting M %llx, A %llx\n", mainbss_6g_bmap, allbss_6g_bmap);

	dl_list_for_each(curr, &bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {

		if (curr->valid == 0 || curr->devinfo.ifindex == 0)
			continue;

		radioinfo = &curr->reginfo.radioinfo;
		oobinfo = &curr->oobinfo;

		if (WMODE_CAP_6G(radioinfo->phymode)) {
			if (curr->reginfo.bssinfo.mbss_grp_idx == MAIN_MBSSID) {
				oobinfo->repting_bmap = mainbss_6g_bmap;
				oobinfo->repting_bmap |= allbss_6g_bmap;
			} else
				oobinfo->repting_bmap = allbss_6g_bmap;

		} else if (WMODE_CAP_2G(radioinfo->phymode)) {
			if (curr->reginfo.bssinfo.mbss_grp_idx == MAIN_MBSSID) {
				oobinfo->repting_bmap = mainbss_2g_bmap;
				oobinfo->repting_bmap |= allbss_2g_bmap;
			} else
				oobinfo->repting_bmap = allbss_2g_bmap;

		} else if (WMODE_CAP_5G(radioinfo->phymode)) {
			if (curr->reginfo.bssinfo.mbss_grp_idx == MAIN_MBSSID) {
				oobinfo->repting_bmap = mainbss_5g_bmap;
				oobinfo->repting_bmap |= allbss_5g_bmap;
			} else
				oobinfo->repting_bmap = allbss_5g_bmap;
		}

		DBGPRINT(RT_DEBUG_ERROR, YLW("Set to ifname %s, bitmap %llx\n"), curr->devinfo.ifname, oobinfo->repting_bmap);
	}

	return ret;
}

#if 0
int bssmnger_update_oob_repting_bmap(struct wifi_app *wapp)
{
	int ret = BSSMNGER_SUCCESS;
	struct bmg_entry *curr;
	struct bssmnger_oob_info *curr_oobinfo = NULL;
	unsigned long long repting_bmap_6 = 0;

	/* HARDCODE , For CERT 4.72.1_RUN3 */
	dl_list_for_each(curr, &wapp->bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {

		DBGPRINT(RT_DEBUG_ERROR, " - [%02d] %s (%s)\n",
				curr->devinfo.ifindex, curr->devinfo.ifname,
				curr->valid ? YLW("Valid") : RED("Invalid"));

		if (strncmp("rax", (const char *)curr->devinfo.ifname, 3) == 0 && curr->valid)
			repting_bmap_6 |= (unsigned long long)(1 << curr->devinfo.ifindex);

	}

	DBGPRINT(RT_DEBUG_ERROR, "Repting Bmap:%llx\n", repting_bmap_6);

	dl_list_for_each(curr, &wapp->bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {

		if (strcmp("rai0", (const char *)curr->devinfo.ifname) == 0) {
			curr_oobinfo = &curr->oobinfo;
			curr_oobinfo->repting_bmap = repting_bmap_6;
			bssmnger_set_bmgentry(wapp, "rai0", (char *)curr, sizeof(struct bmg_entry));
		}
	}

	return ret;
}
#endif

void bssmnger_entry_dump(struct bmg_entry *pEntry)
{
	struct bssmnger_module_info *modinfo = NULL;
	struct bssmnger_netdev_info *devinfo = NULL;
	struct bssmnger_reg_info *reginfo = NULL;
	struct bssmnger_iob_info *iobinfo = NULL;
	struct bssmnger_oob_info *oobinfo = NULL;
	struct bssmnger_radio_info *radioinfo = NULL;
	struct bssmnger_bss_info *bssinfo = NULL;
	struct bssmnger_sec_info *secinfo = NULL;

	static const char * const iob_type_str[] = {"Off", "UnsolProbeRsp", "FilsDiscovery", "QosNull"};
	static const char * const iob_mode_str[] = {"Non-HT", "Non-HT-Dup", "HE-SU"};
	static const char * const oob_rule_str[] = {"Off", "MainBSS", "AllBSS"};

	if (pEntry == NULL) {
		DBGPRINT(RT_DEBUG_ERROR, "%s() NULL Data\n", __func__);
		return;
	}

	modinfo = &pEntry->modinfo;
	devinfo = &pEntry->devinfo;
	reginfo = &pEntry->reginfo;
	iobinfo = &pEntry->iobinfo;
	oobinfo = &pEntry->oobinfo;

	radioinfo = &reginfo->radioinfo;
	bssinfo = &reginfo->bssinfo;
	secinfo = &reginfo->secinfo;

	DBGPRINT(RT_DEBUG_ERROR, " - [%02d] %s [mt%x] (%s)\n",
			devinfo->ifindex, devinfo->ifname,
			modinfo->chip_id,
			pEntry->valid ? YLW("Valid") : RED("Invalid"));

	DBGPRINT(RT_DEBUG_ERROR, "\t\tGrpIdx:%d, BcnTx:%d, Mbss:%d\n",
			bssinfo->mbss_grp_idx, bssinfo->is_trans_bss, bssinfo->is_multi_bss);

	DBGPRINT(RT_DEBUG_ERROR, "\t\tSSID:%s "MACSTR"\n",
			bssinfo->ssid, MAC2STR(radioinfo->bssid));

	DBGPRINT(RT_DEBUG_ERROR, "\t\tPhymode: (0x%x), Ch=%3d, OpClass=%d\n",
			radioinfo->phymode, radioinfo->channel, radioinfo->opclass);

	DBGPRINT(RT_DEBUG_ERROR, "\t\tAuthMode:%04X, Cipher(P:%04X/G:%04X)\n",
			secinfo->auth_mode, secinfo->PairwiseCipher, secinfo->GroupCipher);

	DBGPRINT(RT_DEBUG_ERROR, "\t\tIoB Config:\n");
	DBGPRINT(RT_DEBUG_ERROR, "\t\t- Type: %s%s\n",
			iob_type_str[iobinfo->iob_dsc_type], iobinfo->iob_dsc_by_cfg ? "ByCfg" : "");

	if (iobinfo->iob_dsc_type) {
		DBGPRINT(RT_DEBUG_ERROR, "\t\t- (Interval:%dms, Mode:%s)\n",
				iobinfo->iob_dsc_interval, iob_mode_str[iobinfo->iob_dsc_txmode]);
	} else
		DBGPRINT(RT_DEBUG_ERROR, "\n");

	DBGPRINT(RT_DEBUG_ERROR, "\t\tOoB Config:\n");
	DBGPRINT(RT_DEBUG_ERROR, "\t\t- Reporting rule 2G:%s, 5G:%s, 6G:%s\n",
			oob_rule_str[oobinfo->repting_rule_2g],
			oob_rule_str[oobinfo->repting_rule_5g],
			oob_rule_str[oobinfo->repting_rule_6g]);
	DBGPRINT(RT_DEBUG_ERROR, "\t\t- Repting Bmap:%llx\n", oobinfo->repting_bmap);
}

int bssmnger_entry_cpy(struct bmg_entry *dst, struct bmg_entry *src)
{
	struct bssmnger_module_info *src_modinfo = NULL, *dst_modinfo = NULL;
	struct bssmnger_netdev_info *src_devinfo = NULL, *dst_devinfo = NULL;
	struct bssmnger_reg_info *src_reginfo, *dst_reginfo = NULL;
	struct bssmnger_iob_info *src_iobinfo = NULL, *dst_iobinfo = NULL;
	struct bssmnger_oob_info *src_oobinfo = NULL, *dst_oobinfo = NULL;

	if (dst == NULL || src == NULL)
		return BSSMNGER_INVALID_ARG;

	src_modinfo = &src->modinfo;
	src_devinfo = &src->devinfo;
	src_reginfo = &src->reginfo;
	src_iobinfo = &src->iobinfo;
	src_oobinfo = &src->oobinfo;

	dst_modinfo = &dst->modinfo;
	dst_devinfo = &dst->devinfo;
	dst_reginfo = &dst->reginfo;
	dst_iobinfo = &dst->iobinfo;
	dst_oobinfo = &dst->oobinfo;

	dst->valid = src->valid;
	os_memcpy(dst_modinfo, src_modinfo, sizeof(struct bssmnger_module_info));
	os_memcpy(dst_devinfo, src_devinfo, sizeof(struct bssmnger_netdev_info));
	os_memcpy(dst_reginfo, src_reginfo, sizeof(struct bssmnger_reg_info));
	os_memcpy(dst_iobinfo, src_iobinfo, sizeof(struct bssmnger_iob_info));
	os_memcpy(dst_oobinfo, src_oobinfo, sizeof(struct bssmnger_oob_info));

	return BSSMNGER_SUCCESS;
}

int wapp_bssmnger_init(struct wifi_app *wapp, struct bssmnger_cfg *bss_mnger)
{
	struct bmg_entry *curr, bmgentry;
	size_t len = sizeof(struct bmg_entry);
	char iface[IFNAMSIZ];

	DBGPRINT(RT_DEBUG_ERROR, BLUE("%s() enter\n"), __func__);

	if (wapp == NULL || bss_mnger == NULL)
		return BSSMNGER_UNEXP;

	wapp->bss_mnger = bss_mnger;
	bssmnger_init(bss_mnger);

	if (bss_mnger->bssentry_db.inited == BSSMNGER_UNINITIALIZED)
		return BSSMNGER_UNEXP;

	dl_list_for_each(curr, &bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {
		os_memset(iface, 0, IFNAMSIZ);
		os_memset(&bmgentry, 0, sizeof(struct bmg_entry));
		strncpy(iface, (char *)curr->devinfo.ifname, IFNAMSIZ);
		len = sizeof(struct bmg_entry);
		strncpy((char *)bmgentry.devinfo.ifname, (char *)curr->devinfo.ifname, IFNAMSIZ);

		DBGPRINT(RT_DEBUG_ERROR, YLW("%s() Update %s bmgentry\n"), __func__, iface);
		if (bssmnger_get_bmgentry(wapp, iface, (char *)&bmgentry, &len) == BSSMNGER_SUCCESS) {
			/*
			 * bssmnger_entry_dump(curr);
			 * bssmnger_entry_dump(&bmgentry);
			 */
			bssmnger_entry_cpy(curr, &bmgentry);
		}
	}

	bssmnger_update_oob_repting_bmap(wapp);
	bssmnger_sync_db_to_module(wapp);
	bssmnger_trigger_oob_repting_bmap(wapp);
	bss_mnger->bssentry_db.inited = BSSMNGER_INITIALIZED;
	return BSSMNGER_SUCCESS;
}



int bssmnger_set_bmgentry(
	struct wifi_app *wapp,
	const char *iface,
	char *bmgentry, size_t bmgentry_len)
{
	int ret = BSSMNGER_SUCCESS;

	DBGPRINT(RT_DEBUG_ERROR, "%s enter\n", __func__);

	if (wapp->bss_mnger->drv_ops->drv_bssmnger_set_bmgentry != NULL) {

		ret = wapp->bss_mnger->drv_ops->drv_bssmnger_set_bmgentry(wapp->drv_data,
			iface, bmgentry, bmgentry_len);

		DBGPRINT(RT_DEBUG_ERROR, "%s: bssmnger set !! (ret:%d)\n", __func__, ret);

		if (ret != 0) {
			ret = BSSMNGER_UNEXP;
			DBGPRINT(RT_DEBUG_ERROR, "%s: bssmnger set fail!! (ret:%d)\n", __func__, ret);
		}

	} else {
		ret = BSSMNGER_RESOURCE_ALLOC_FAIL;
		DBGPRINT(RT_DEBUG_ERROR, "%s: bss_mnger->drv_ops is NULL (ret:%d)\n", __func__, ret);
	}

	return ret;
}

int bssmnger_get_bmgentry(
	struct wifi_app *wapp,
	const char *iface,
	char *bmgentry, size_t *bmgentry_len)
{
	int ret = BSSMNGER_SUCCESS;

	DBGPRINT(RT_DEBUG_ERROR, "%s enter\n", __func__);

	if (wapp->bss_mnger->drv_ops->drv_bssmnger_get_bmgentry != NULL) {

		ret = wapp->bss_mnger->drv_ops->drv_bssmnger_get_bmgentry(wapp->drv_data,
			iface, bmgentry, bmgentry_len);

		if (ret != 0) {
			ret = BSSMNGER_UNEXP;
			DBGPRINT(RT_DEBUG_ERROR, "%s: bssmnger get fail!! (ret:%d)\n", __func__, ret);
		}
	} else {
		ret = BSSMNGER_RESOURCE_ALLOC_FAIL;
		DBGPRINT(RT_DEBUG_ERROR, "%s: bss_mnger->drv_ops is NULL (ret:%d)\n", __func__, ret);
	}

	return ret;
}

int bssmnger_param_setting(
	struct wifi_app *wapp,
	const char *iface,
	u32 param, u32 value)
{
	int ret = BSSMNGER_SUCCESS;

	if (wapp->bss_mnger->drv_ops->drv_bssmnger_param_setting != NULL) {
		ret = wapp->bss_mnger->drv_ops->drv_bssmnger_param_setting(wapp->drv_data,
			iface, param, value);
		if (ret != 0) {
			ret = BSSMNGER_UNEXP;
			DBGPRINT(RT_DEBUG_ERROR, "%s: bssmnger set fail!! (ret:%d)\n", __func__, ret);
		}
	} else {
		ret = BSSMNGER_RESOURCE_ALLOC_FAIL;
		DBGPRINT(RT_DEBUG_ERROR, "%s: bss_mnger->drv_ops is NULL (ret:%d)\n", __func__, ret);
		goto err;
	}

err:
	return ret;
}

int bssmnger_cmd_set(struct wifi_app *wapp, const char *iface, u8 argc, char **argv)
{
	int ret = BSSMNGER_SUCCESS;
	u32 val1 = 0;

	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);
	if (argv[1])
		val1 = atoi(argv[1]);
	else {
		ret = BSSMNGER_INVALID_ARG;
		DBGPRINT(RT_DEBUG_ERROR, "%s: arg is NULL (ret:%d)\n", __func__, ret);
		goto err;
	}
	bssmnger_param_setting(wapp, iface, BSSMNGER_SET_EVENT, val1);

err:
	return ret;
}

void bmgentry_set_fake_param(struct bmg_entry *bmgentry)
{
	bmgentry->devinfo.ifindex = 30;
	strncpy((char *)(bmgentry->devinfo.ifname), "rai0", IFNAMSIZ);
}

struct bmg_entry *bmgentry_find_by_ifname(struct wifi_app *wapp, const char *iface)
{
	struct bmg_entry *curr;

	dl_list_for_each(curr, &wapp->bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {
		DBGPRINT(RT_DEBUG_TRACE, "Current=> ifindex %d, ifname %s\n", curr->devinfo.ifindex, curr->devinfo.ifname);

		if (os_strcmp((const char *)curr->devinfo.ifname, iface) == 0)
			return curr;
	}
	return NULL;
}

int bssmnger_cmd_set_bitmap(struct wifi_app *wapp, const char *iface, u8 argc, char **argv)
{
	int ret = BSSMNGER_SUCCESS;
	int ifindex = 0;
	struct bmg_entry *pEntry;
	struct bssmnger_oob_info *curr_oobinfo = NULL;

	DBGPRINT(RT_DEBUG_ERROR, "%s() enter (%d)\n", __func__, argc);

	if (argc == 2) {

		DBGPRINT(RT_DEBUG_ERROR, "%s() set bitmap [ 1<< %s ] to %s\n", __func__, argv[1], iface);
		ifindex = atoi(argv[1]);

		if (ifindex > 64 || ifindex < 0) {
			DBGPRINT(RT_DEBUG_ERROR, "%s() %s should between 0 - 64\n", __func__, argv[1]);
			return ret;
		}

		pEntry = bmgentry_find_by_ifname(wapp, iface);

		if (pEntry) {
			curr_oobinfo = &pEntry->oobinfo;

			DBGPRINT(RT_DEBUG_ERROR, "BEFORE=> ifindex %d, ifname %s, bitmap:0x%llx\n",
					pEntry->devinfo.ifindex, pEntry->devinfo.ifname, curr_oobinfo->repting_bmap);

			if (ifindex == 0)
				curr_oobinfo->repting_bmap = 0;
			else
				curr_oobinfo->repting_bmap |= (unsigned long long)(1 << ifindex);


			DBGPRINT(RT_DEBUG_ERROR, "AFTER=> ifindex %d, ifname %s, bitmap:0x%llx\n",
					pEntry->devinfo.ifindex, pEntry->devinfo.ifname, curr_oobinfo->repting_bmap);

			bssmnger_set_bmgentry(wapp, iface, (char *)pEntry, sizeof(struct bmg_entry));

		} else {
			DBGPRINT(RT_DEBUG_ERROR, "%s() BMG Entry %s Not Found", __func__, iface);
		}
	}
	return ret;
}

int bssmnger_cmd_bitmap_calc(struct wifi_app *wapp, const char *iface, u8 argc, char **argv)
{
	DBGPRINT(RT_DEBUG_ERROR, "%s() enter (%d)\n", __func__, argc);

	bssmnger_update_oob_repting_bmap(wapp);

	return BSSMNGER_SUCCESS;
}

int bssmnger_cmd_addbmg(struct wifi_app *wapp, const char *iface, u8 argc, char **argv)
{
	int ret = BSSMNGER_SUCCESS;
	struct bmg_entry fake_bmgentry;

	DBGPRINT(RT_DEBUG_ERROR, "%s() enter\n", __func__);

	os_memset(&fake_bmgentry, 0, sizeof(struct bmg_entry));

	if (argc == 2) {
		DBGPRINT(RT_DEBUG_ERROR, "%s() set bssinfo to %s\n", __func__, iface);
		bmgentry_set_fake_param(&fake_bmgentry);
		bssmnger_set_bmgentry(wapp, iface, (char *)&fake_bmgentry, sizeof(struct bmg_entry));
	}
	return ret;
}

int bssmnger_cmd_bmg_get(struct wifi_app *wapp, const char *iface, u8 argc, char **argv)
{
	int ret = BSSMNGER_SUCCESS;
	struct bmg_entry bmgentry;
	int len = sizeof(struct bmg_entry);

	DBGPRINT(RT_DEBUG_ERROR, "%s() get bssinfo to %s\n", __func__, iface);

	if (argc == 2) {

		DBGPRINT(RT_DEBUG_ERROR, "%s() fetch %s bss entry\n", __func__, argv[1]);

		os_memset(&bmgentry, 0, sizeof(struct bmg_entry));
		strncpy((char *)bmgentry.devinfo.ifname, argv[1], IFNAMSIZ);
		bssmnger_get_bmgentry(wapp, iface, (char *)&bmgentry, (size_t *)&len);

		bssmnger_entry_dump(&bmgentry);
	}
	return ret;
}

int bssmnger_cmd_bmg_show(struct wifi_app *wapp, const char *iface, u8 argc, char **argv)
{
	int ret = BSSMNGER_SUCCESS;
	struct bmg_entry *curr;

	DBGPRINT(RT_DEBUG_ERROR, "%s() enter\n", __func__);
	DBGPRINT(RT_DEBUG_ERROR, "%s() status %d, list_len %d\n", __func__,
			wapp->bss_mnger->bssentry_db.inited, wapp->bss_mnger->bssentry_db.dev_cnt);

	dl_list_for_each(curr, &wapp->bss_mnger->bssentry_db.bssentry_list, struct bmg_entry, list) {
		bssmnger_entry_dump(curr);
	}

	return ret;

}

struct bssmnger_ctrl_cmd bssmnger_cmd[] = {
	{"set",               bssmnger_cmd_set,                            "set param to kernel(removed)"},
	{"addbmg",            bssmnger_cmd_addbmg,                         "add bmgentry to wifi module"},
	{"bitmap",            bssmnger_cmd_set_bitmap,                     "force set driver oob->repting_bmap [ifindex]"},
	{"bitmap_calc",       bssmnger_cmd_bitmap_calc,                    "calculate oob->repting_bmap"},
	{"bmg_get",           bssmnger_cmd_bmg_get,                        "get bmginfo from wifi module"},
	{"bmg_show",          bssmnger_cmd_bmg_show,                       "show bssmnger content"},
	{"help",              bssmnger_cmd_show_help,                      "show this help"},
	{NULL,                bssmnger_cmd_show_help}
};

int bssmnger_cmd_show_help(struct wifi_app *wapp, const char *iface, u8 argc, char **argv)
{
	u8 i = 0;

	printf("\033[1;36m available cmds: \033[0m\n");
	for (i = 0; (bssmnger_cmd[i].cmd != NULL); i++)
		printf("\033[1;36m %20s  \t -  %s\033[0m\n", bssmnger_cmd[i].cmd, bssmnger_cmd[i].help);

	return BSSMNGER_SUCCESS;
}


int bssmnger_ctrl_interface_cmd_handle(
	struct wifi_app *wapp,
	const char *iface,
	u8 argc,
	char **argv)
{
	int i, ret = BSSMNGER_SUCCESS;

	DBGPRINT(RT_DEBUG_WARN, "%s\n", __func__);
	for (i = 0; bssmnger_cmd[i].cmd != NULL; i++) {
		if (os_strncmp(bssmnger_cmd[i].cmd, argv[0], os_strlen(argv[0])) == 0) {
			ret = bssmnger_cmd[i].cmd_proc(wapp, iface, argc, argv);
			if (ret != BSSMNGER_SUCCESS) {
				DBGPRINT(RT_DEBUG_ERROR, "cmd [%s] failed!! (ret:%d)\n",
					bssmnger_cmd[i].cmd, ret);
				goto err;
			}
		}
	}
err:
	return ret;
}
#endif /* BSSMNGER_SUPPORT */
