/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * Copyright  (C) 2022-2023  MediaTek Inc. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#ifndef _BSS_MNGER_H_
#define _BSS_MNGER_H_

#include "wapp_cmm.h"
#include "list.h"

#define WMODE_CAP_6G(_x)	(((_x) & (WMODE_AX_6G)) != 0)
#define WMODE_CAP_5G(_x)	(((_x) & (WMODE_A | WMODE_AN | WMODE_AC | WMODE_AX_5G)) != 0)
#define WMODE_CAP_2G(_x)	(((_x) & (WMODE_B | WMODE_G | WMODE_GN | WMODE_AX_24G)) != 0)

#define MAIN_MBSSID	0
#define FIRST_MBSSID	1

#define NUM_MODULES	2

#define IS_OOB_REQ(rule, band, ifidx) \
	is_oob_discovery_required(rule##_##band, \
	ifidx, &allbss_##band##_bmap, &mainbss_##band##_bmap)

enum BSSMNGER_EVENT_TYPE {
	BSSMNGER_GET_EVENT = 0,
	BSSMNGER_SET_EVENT = 1,
	BSSMNGER_MAX_EVENT,
};

enum BSSMNGER_INIT_STAGE {
	BSSMNGER_UNINITIALIZED = 0,
	BSSMNGER_INITIALIZING = 1,
	BSSMNGER_INITIALIZED = 2,
};

enum BSSMNGER_RNR_REPORTING {
	RNR_REPORTING_NONE,
	RNR_REPORTING_MAIN_BSS,
	RNR_REPORTING_ALL_BSS
};

enum BSSMNGER_MSG_TYPE {
	BSSMNGER_MSG_OOB_DISCOVERY = 0,
	BSSMNGER_MSG_IOB_DISCOVERY,
	BSSMNGER_MSG_QOS_INJECTOR,
	BSSMNGER_MSG_REG_BMGENTRY,
	BSSMNGER_MSG_DEREG_BMGENTRY,
};

enum BSSMNGER_ERR_CODE {
	BSSMNGER_SUCCESS = 0,
	BSSMNGER_INVALID_ARG = 1,
	BSSMNGER_RESOURCE_ALLOC_FAIL = 2,
	BSSMNGER_NOT_INITIALIZED = 3,
	BSSMNGER_LOOKUP_ENTRY_NOT_FOUND = 4,
	BSSMNGER_UNEXP = 5,
};

struct bss_mnger {
	enum BSSMNGER_INIT_STAGE inited;
	unsigned char dev_cnt;
	struct dl_list bssentry_list;
};


struct bssmnger_cfg {
	/* TODO: call back function of mbo events */
	/* driver interface operation */
	const struct bssmnger_drv_ops *drv_ops;
	struct bss_mnger bssentry_db;
};

struct bssmnger_ctrl_cmd {
	char *cmd;
	int (*cmd_proc)(struct wifi_app *wapp, const char *iface, u8 argc, char **argv);
	char *help;
};

inline int bssmnger_param_setting(
	struct wifi_app *wapp,
	const char *iface,
	u32 param, u32 value
);

int bssmnger_cmd_show_help(
	struct wifi_app *wapp,
	const char *iface,
	u8 argc,
	char **argv
);

int bssmnger_ctrl_interface_cmd_handle(
	struct wifi_app *wapp,
	const char *iface,
	u8 argc,
	char **argv
);

struct bssmnger_sec_info {
	unsigned int auth_mode;
	unsigned int PairwiseCipher;
	unsigned int GroupCipher;
};

struct bssmnger_radio_info {
	unsigned char channel;
	unsigned char bssid[MAC_ADDR_LEN];
	unsigned char opclass;
	unsigned short phymode;
};

struct bssmnger_bss_info {
	unsigned char bandidx;
	unsigned char is_hide_ssid;
	unsigned char is_trans_bss;
	unsigned char is_multi_bss;
	unsigned short mbss_grp_idx;
	unsigned char ssid[MAX_LEN_OF_SSID+1];
	unsigned char ssid_len;
};

struct bssmnger_reg_info {
	struct bssmnger_radio_info radioinfo;
	struct bssmnger_bss_info bssinfo;
	struct bssmnger_sec_info secinfo;
};

struct bssmnger_netdev_info {
	unsigned char ifname[IFNAMSIZ];
	unsigned int ifindex;
};

struct bssmnger_iob_info {
	unsigned char iob_dsc_type;	/* type (0:Disalbe, 1:Probe.Rsp, 2:FD) */
	unsigned char iob_dsc_interval;	/* interval(ms) */
	unsigned char iob_dsc_txmode;	/* mode (0:Non-HT, 1:Non-HT-Dup, 2:HE-SU)*/
	unsigned char iob_dsc_by_cfg;	/* force setting by config */
};

struct bssmnger_oob_info {
	unsigned char repting_rule_2g;	/* rule to neighbor 2G bss */
	unsigned char repting_rule_5g;	/* rule to neighbor 5G bss */
	unsigned char repting_rule_6g;	/* rule to neighbor 6G bss */
	unsigned long long repting_bmap;	/* reporting netif index */
};

struct bssmnger_module_info {
	int chip_id;
};

struct bmg_entry {
	unsigned char valid;
	struct bssmnger_module_info modinfo;
	struct bssmnger_netdev_info devinfo;
	struct bssmnger_reg_info reginfo;
	struct bssmnger_iob_info iobinfo;
	struct bssmnger_oob_info oobinfo;
	struct dl_list list;
};

struct bssmnger_msg {
	unsigned int ifindex;
	unsigned char len;
	unsigned char type;
	struct bmg_entry MsgBody;
};

int wapp_bssmnger_init(struct wifi_app *wapp, struct bssmnger_cfg *bss_mnger);
int bssmnger_init(struct bssmnger_cfg *bss_mnger);
int bssmnger_update_self_database(struct wifi_app *wapp, unsigned char type, struct bmg_entry *input);
int bssmnger_sync_db_to_module(struct wifi_app *wapp);
int bssmnger_sync_bmg_to_diff_module(struct wifi_app *wapp, struct bmg_entry *input);
int bssmnger_sync_bmg_to_module(struct wifi_app *wapp, struct bmg_entry *input, int skip_same);
void bssmnger_trigger_oob_repting_bmap(struct wifi_app *wapp);
int bssmnger_update_oob_repting_bmap(struct wifi_app *wapp);
void bssmnger_entry_dump(struct bmg_entry *pEntry);
int bssmnger_entry_cpy(struct bmg_entry *dst, struct bmg_entry *src);
struct bmg_entry *bmgentry_find_by_ifname(struct wifi_app *wapp, const char *iface);

void is_oob_discovery_required(
	unsigned char rule,
	unsigned int ifindex,
	unsigned long long *bmap,
	unsigned long long *bmap_main);

int driver_wext_bssmnger_param_setting(void *drv_data, const char *ifname, u32 param, u32 value);
int driver_wext_bssmnger_get_bmgentry(void *drv_data, const char *ifname, char *bmgentry, size_t *bmgentry_len);
int driver_wext_bssmnger_set_bmgentry(void *drv_data, const char *ifname, char *bmgentry, size_t bmgentry_len);

int bssmnger_set_bmgentry(
	struct wifi_app *wapp,
	const char *iface,
	char *bmgentry, size_t bmgentry_len);

int bssmnger_get_bmgentry(
	struct wifi_app *wapp,
	const char *iface,
	char *bmgentry, size_t *bmgentry_len);
#endif /* #ifndef _BSS_MNGER_H_ */
