local utl = require "luci.util"
local sys = require "luci.sys"
local fs  = require "nixio.fs"
local ip  = require "luci.ip"
local nw  = require "luci.model.network"

local s, m, Protocol, selectroute, subnets, routes
local myvpn_version = luci.sys.exec("opkg list|grep luci-app-myvpnconfig|awk '{print $3}'")
m = Map("myvpn", translate("MyVPN - Configuration version: " .. myvpn_version),
	translate("Myvpn is a lightweight and efficient intelligent VPN management tool."))

s = m:section(TypedSection, "myvpn")
s.anonymous = true
s.addremove = false
s:tab("general", translate("General Settings"))
s:tab("advanced", translate("Advanced Settings"))
s:tab("route", translate("custom routes"),
	translate("Custom routing table. The following routing tables are automatically loaded into the VPN interface."))
--general

enable = s:taboption("general", Flag, "enable", translate("Bring up on boot"))
enable.default = enable.disabled

server = s:taboption("general", Value, "server", translate("VPN Server"))
server.placeholder = "Server Name or Server IP Address"

--port = s:taboption("general", Value, "port", translate("VPN Server port"))
--port.placeholder = "443"

username = s:taboption("general", Value, "username", translate("Username"))
username.placeholder = "username"

password = s:taboption("general", Value, "password", translate("Password"))
password.password=true;

-- advanced
subnets = s:taboption("advanced", DynamicList, "subnets", translate("Local subnets"),
	translate("Filter the intranet address. The address listed will not be forwarded by VPN server."))
subnets.datatype = "ipaddr"

--route
routes = s:taboption("route", TextValue, "_routes")
routes.rows = 50

routes.cfgvalue = function(self, cfg)
	return fs.readfile("/etc/chnroute_custom")
end

routes.write = function(self, cfg, value)
	fs.writefile("/etc/chnroute_custom", (value or ""):gsub("\r\n", "\n"))
end

routes.remove = routes.write

return m