/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _L2TP_RPC_H_RPCGEN
#define _L2TP_RPC_H_RPCGEN

#include <rpc/rpc.h>

#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

#define L2TP_APP_COPYRIGHT_INFO "(c) Copyright 2004-2010"
#define L2TP_APP_VENDOR_INFO "Katalix Systems Ltd."
#define L2TP_APP_MAJOR_VERSION 1
#define L2TP_APP_MINOR_VERSION 8
#define L2TP_DEBUG_PROTOCOL 1
#define L2TP_DEBUG_FSM 2
#define L2TP_DEBUG_API 4
#define L2TP_DEBUG_AVP 8
#define L2TP_DEBUG_AVP_HIDE 16
#define L2TP_DEBUG_AVP_DATA 32
#define L2TP_DEBUG_FUNC 64
#define L2TP_DEBUG_XPRT 128
#define L2TP_DEBUG_DATA 256
#define L2TP_DEBUG_SYSTEM 512
#define L2TP_DEBUG_PPP 1024
#define L2TP_ERR_BASE 500
#define L2TP_ERR_PARAM_NOT_MODIFIABLE 500
#define L2TP_ERR_PEER_ADDRESS_MISSING 501
#define L2TP_ERR_PEER_NOT_FOUND 502
#define L2TP_ERR_PEER_PROFILE_NOT_FOUND 503
#define L2TP_ERR_PPP_PROFILE_NOT_FOUND 504
#define L2TP_ERR_PROFILE_ALREADY_EXISTS 505
#define L2TP_ERR_PROFILE_NAME_ILLEGAL 506
#define L2TP_ERR_PROFILE_NAME_MISSING 507
#define L2TP_ERR_SESSION_ALREADY_EXISTS 508
#define L2TP_ERR_SESSION_ID_ALLOC_FAILURE 509
#define L2TP_ERR_SESSION_LIMIT_EXCEEDED 510
#define L2TP_ERR_SESSION_NOT_FOUND 511
#define L2TP_ERR_SESSION_PROFILE_NOT_FOUND 512
#define L2TP_ERR_SESSION_SPEC_MISSING 513
#define L2TP_ERR_SESSION_TYPE_BAD 514
#define L2TP_ERR_SESSION_TYPE_ILLEGAL_FOR_TUNNEL 515
#define L2TP_ERR_TUNNEL_ADD_ADMIN_DISABLED 516
#define L2TP_ERR_TUNNEL_CREATE_ADMIN_DISABLED 517
#define L2TP_ERR_TUNNEL_ALREADY_EXISTS 518
#define L2TP_ERR_TUNNEL_ID_ALLOC_FAILURE 519
#define L2TP_ERR_TUNNEL_NOT_FOUND 520
#define L2TP_ERR_TUNNEL_PROFILE_NOT_FOUND 521
#define L2TP_ERR_TUNNEL_SPEC_MISSING 522
#define L2TP_ERR_TUNNEL_TOO_MANY_SESSIONS 523
#define L2TP_ERR_TUNNEL_TOO_MANY_SAME_IP 524
#define L2TP_ERR_TUNNEL_LIMIT_EXCEEDED 525
#define L2TP_ERR_SESSION_TYPE_NOT_SUPPORTED 526
#define L2TP_ERR_TUNNEL_HIDE_AVPS_NEEDS_SECRET 527
#define L2TP_ERR_MAX 528

struct optstring {
	int valid;
	union {
		char *value;
	} optstring_u;
};
typedef struct optstring optstring;
#define OPTSTRING(_var) _var.optstring_u.value
#define OPTSTRING_PTR(_var) ((_var.valid == 1) ? _var.optstring_u.value : NULL)

enum l2tp_api_tunnel_auth_mode {
	L2TP_API_TUNNEL_AUTH_MODE_NONE = 0,
	L2TP_API_TUNNEL_AUTH_MODE_SIMPLE = 1,
	L2TP_API_TUNNEL_AUTH_MODE_CHALLENGE = 2,
};
typedef enum l2tp_api_tunnel_auth_mode l2tp_api_tunnel_auth_mode;

enum l2tp_api_tunnel_mode {
	L2TP_API_TUNNEL_MODE_LACLNS = 0,
	L2TP_API_TUNNEL_MODE_LAC = 1,
	L2TP_API_TUNNEL_MODE_LNS = 2,
};
typedef enum l2tp_api_tunnel_mode l2tp_api_tunnel_mode;

struct l2tp_api_ip_addr {
	uint32_t s_addr;
};
typedef struct l2tp_api_ip_addr l2tp_api_ip_addr;
#define L2TP_API_APP_FEATURE_LOCAL_CONF_FILE 1
#define L2TP_API_APP_FEATURE_LAC_SUPPORT 2
#define L2TP_API_APP_FEATURE_LNS_SUPPORT 4
#define L2TP_API_APP_FEATURE_RPC_MANAGEMENT 8
#define L2TP_API_APP_FEATURE_LAIC_SUPPORT 16
#define L2TP_API_APP_FEATURE_LAOC_SUPPORT 32
#define L2TP_API_APP_FEATURE_LNIC_SUPPORT 64
#define L2TP_API_APP_FEATURE_LNOC_SUPPORT 128
#define L2TP_API_APP_FEATURE_LOCAL_STAT_FILE 256

struct l2tp_api_app_msg_data {
	char *build_date;
	char *build_time;
	int major;
	int minor;
	uint32_t cookie;
	struct {
		u_int patches_len;
		int *patches_val;
	} patches;
	uint32_t features;
};
typedef struct l2tp_api_app_msg_data l2tp_api_app_msg_data;
#define L2TP_API_CONFIG_FLAG_TRACE_FLAGS 1
#define L2TP_API_CONFIG_FLAG_MAX_TUNNELS 2
#define L2TP_API_CONFIG_FLAG_DRAIN_TUNNELS 4
#define L2TP_API_CONFIG_FLAG_MAX_SESSIONS 8
#define L2TP_API_CONFIG_FLAG_TUNNEL_ESTABLISH_TIMEOUT 16
#define L2TP_API_CONFIG_FLAG_SESSION_ESTABLISH_TIMEOUT 32
#define L2TP_API_CONFIG_FLAG_DENY_LOCAL_TUNNEL_CREATES 64
#define L2TP_API_CONFIG_FLAG_DENY_REMOTE_TUNNEL_CREATES 128
#define L2TP_API_CONFIG_FLAG_RESET_STATISTICS 256
#define L2TP_API_CONFIG_FLAG_TUNNEL_PERSIST_PEND_TIMEOUT 512
#define L2TP_API_CONFIG_FLAG_SESSION_PERSIST_PEND_TIMEOUT 1024

struct l2tp_api_system_config {
	uint32_t flags;
	int udp_port;
	uint32_t trace_flags;
	uint32_t trace_flags_mask;
	int max_tunnels;
	int max_sessions;
	int drain_tunnels;
	int tunnel_establish_timeout;
	int session_establish_timeout;
	int tunnel_persist_pend_timeout;
	int session_persist_pend_timeout;
	bool_t deny_local_tunnel_creates;
	bool_t deny_remote_tunnel_creates;
};
typedef struct l2tp_api_system_config l2tp_api_system_config;

struct l2tp_api_system_msg_stats {
	uint32_t rx;
	uint32_t tx;
	uint32_t rx_bad;
};
typedef struct l2tp_api_system_msg_stats l2tp_api_system_msg_stats;
#define L2TP_API_MSG_TYPE_COUNT 17

struct l2tp_api_system_stats {
	uint32_t short_frames;
	uint32_t wrong_version_frames;
	uint32_t unexpected_data_frames;
	uint32_t bad_rcvd_frames;
	uint32_t total_rcvd_control_frames;
	uint32_t total_sent_control_frames;
	uint32_t total_control_frame_send_fails;
	uint32_t total_retransmitted_control_frames;
	uint32_t no_control_frame_resources;
	uint32_t no_peer_resources;
	uint32_t no_tunnel_resources;
	uint32_t no_session_resources;
	uint32_t no_ppp_resources;
	uint32_t too_many_tunnels;
	uint32_t too_many_sessions;
	uint32_t auth_fails;
	uint32_t no_matching_tunnel_id_discards;
	uint32_t no_matching_session_id_discards;
	uint32_t mismatched_tunnel_ids;
	uint32_t mismatched_session_ids;
	uint32_t encode_message_fails;
	uint32_t tunnel_setup_failures;
	uint32_t session_setup_failures;
	uint32_t event_queue_full_errors;
	uint32_t ignored_avps;
	uint32_t vendor_avps;
	uint32_t illegal_messages;
	uint32_t unsupported_messages;
	struct {
		u_int messages_len;
		struct l2tp_api_system_msg_stats *messages_val;
	} messages;
};
typedef struct l2tp_api_system_stats l2tp_api_system_stats;

struct l2tp_api_system_status {
	struct l2tp_api_system_stats stats;
	uint32_t num_tunnels;
	uint32_t num_sessions;
};
typedef struct l2tp_api_system_status l2tp_api_system_status;

struct l2tp_api_system_msg_data {
	struct l2tp_api_system_config config;
	struct l2tp_api_system_status status;
};
typedef struct l2tp_api_system_msg_data l2tp_api_system_msg_data;

struct l2tp_api_peer_msg_data {
	int result_code;
	struct l2tp_api_ip_addr peer_addr;
	struct l2tp_api_ip_addr local_addr;
	int num_tunnels;
};
typedef struct l2tp_api_peer_msg_data l2tp_api_peer_msg_data;

struct l2tp_api_peer_list_entry {
	struct l2tp_api_ip_addr peer_addr;
	struct l2tp_api_ip_addr local_addr;
	struct l2tp_api_peer_list_entry *next;
};
typedef struct l2tp_api_peer_list_entry l2tp_api_peer_list_entry;

struct l2tp_api_peer_list_msg_data {
	int result;
	struct l2tp_api_peer_list_entry *peers;
};
typedef struct l2tp_api_peer_list_msg_data l2tp_api_peer_list_msg_data;
#define L2TP_API_PEER_PROFILE_DEFAULT_PROFILE_NAME "default"
#define L2TP_API_PEER_PROFILE_FLAG_LACLNS 1
#define L2TP_API_PEER_PROFILE_FLAG_TUNNEL_PROFILE_NAME 2
#define L2TP_API_PEER_PROFILE_FLAG_SESSION_PROFILE_NAME 4
#define L2TP_API_PEER_PROFILE_FLAG_PPP_PROFILE_NAME 8
#define L2TP_API_PEER_PROFILE_FLAG_PEER_IPADDR 16
#define L2TP_API_PEER_PROFILE_FLAG_PEER_PORT 32
#define L2TP_API_PEER_PROFILE_FLAG_NETMASK 64

struct l2tp_api_peer_profile_msg_data {
	uint32_t flags;
	int result_code;
	struct l2tp_api_ip_addr peer_addr;
	uint16_t peer_port;
	bool_t we_can_be_lac;
	bool_t we_can_be_lns;
	char *profile_name;
	optstring default_tunnel_profile_name;
	optstring default_session_profile_name;
	optstring default_ppp_profile_name;
	struct l2tp_api_ip_addr netmask;
	int use_count;
};
typedef struct l2tp_api_peer_profile_msg_data l2tp_api_peer_profile_msg_data;

struct l2tp_api_peer_profile_list_entry {
	char *profile_name;
	struct l2tp_api_peer_profile_list_entry *next;
};
typedef struct l2tp_api_peer_profile_list_entry l2tp_api_peer_profile_list_entry;

struct l2tp_api_peer_profile_list_msg_data {
	int result;
	int num_profiles;
	struct l2tp_api_peer_profile_list_entry *profiles;
};
typedef struct l2tp_api_peer_profile_list_msg_data l2tp_api_peer_profile_list_msg_data;

struct l2tp_api_peer_profile_unset_msg_data {
	uint32_t flags;
	int result_code;
	char *profile_name;
};
typedef struct l2tp_api_peer_profile_unset_msg_data l2tp_api_peer_profile_unset_msg_data;

struct l2tp_api_tunnel_peer {
	bool_t framing_cap_sync;
	bool_t framing_cap_async;
	bool_t bearer_cap_digital;
	bool_t bearer_cap_analog;
	uint8_t protocol_version_ver;
	uint8_t protocol_version_rev;
	uint16_t rx_window_size;
	uint16_t firmware_revision;
	optstring host_name;
	optstring vendor_name;
	struct {
		u_int tiebreaker_len;
		uint8_t *tiebreaker_val;
	} tiebreaker;
	uint16_t result_code_result;
	uint16_t result_code_error;
	optstring result_code_message;
};
typedef struct l2tp_api_tunnel_peer l2tp_api_tunnel_peer;

struct l2tp_api_tunnel_stats {
	uint32_t retransmits;
	uint32_t tx_zlbs;
	uint32_t tx_zlb_fails;
	uint32_t rx_zlbs;
	uint32_t data_pkt_discards;
	uint32_t duplicate_pkt_discards;
	uint32_t rx_hellos;
	uint32_t tx_hellos;
	uint32_t tx_hello_fails;
	uint16_t ns;
	uint16_t nr;
	uint16_t peer_ns;
	uint16_t peer_nr;
	uint16_t cwnd;
	uint16_t ssthresh;
	uint16_t congpkt_acc;
	uint64_t control_rx_packets;
	uint64_t control_rx_bytes;
	uint64_t control_rx_oos_packets;
	uint64_t control_rx_oos_discards;
	uint64_t control_tx_packets;
	uint64_t control_tx_bytes;
	uint64_t data_rx_packets;
	uint64_t data_rx_bytes;
	uint64_t data_rx_errors;
	uint64_t data_rx_oos_packets;
	uint64_t data_rx_oos_discards;
	uint64_t data_tx_packets;
	uint64_t data_tx_bytes;
	uint64_t data_tx_errors;
	bool_t using_ipsec;
};
typedef struct l2tp_api_tunnel_stats l2tp_api_tunnel_stats;
#define L2TP_API_TUNNEL_FLAG_HIDE_AVPS 1
#define L2TP_API_TUNNEL_FLAG_OUR_ADDR 2
#define L2TP_API_TUNNEL_FLAG_PEER_ADDR 4
#define L2TP_API_TUNNEL_FLAG_CONFIG_ID 8
#define L2TP_API_TUNNEL_FLAG_OUR_UDP_PORT 16
#define L2TP_API_TUNNEL_FLAG_AUTH_MODE 32
#define L2TP_API_TUNNEL_FLAG_FRAMING_CAP 64
#define L2TP_API_TUNNEL_FLAG_BEARER_CAP 128
#define L2TP_API_TUNNEL_FLAG_USE_TIEBREAKER 256
#define L2TP_API_TUNNEL_FLAG_PERSIST 512
#define L2TP_API_TUNNEL_FLAG_HELLO_TIMEOUT 1024
#define L2TP_API_TUNNEL_FLAG_MAX_RETRIES 2048
#define L2TP_API_TUNNEL_FLAG_RX_WINDOW_SIZE 4096
#define L2TP_API_TUNNEL_FLAG_TX_WINDOW_SIZE 8192
#define L2TP_API_TUNNEL_FLAG_RETRY_TIMEOUT 16384
#define L2TP_API_TUNNEL_FLAG_IDLE_TIMEOUT 32768
#define L2TP_API_TUNNEL_FLAG_PEER_UDP_PORT 65536
#define L2TP_API_TUNNEL_FLAG_SECRET 131072
#define L2TP_API_TUNNEL_FLAG_ALLOW_PPP_PROXY 262144
#define L2TP_API_TUNNEL_FLAG_TRACE_FLAGS 524288
#define L2TP_API_TUNNEL_FLAG_USE_UDP_CHECKSUMS 1048576
#define L2TP_API_TUNNEL_FLAG_HOST_NAME 2097152
#define L2TP_API_TUNNEL_FLAG_TUNNEL_ID 4194304
#define L2TP_API_TUNNEL_FLAG_PROFILE_NAME 8388608
#define L2TP_API_TUNNEL_FLAG_MAX_SESSIONS 16777216
#define L2TP_API_TUNNEL_FLAG_TUNNEL_NAME 33554432
#define L2TP_API_TUNNEL_FLAG_UNUSED_2 67108864
#define L2TP_API_TUNNEL_FLAG_PEER_PROFILE_NAME 134217728
#define L2TP_API_TUNNEL_FLAG_SESSION_PROFILE_NAME 268435456
#define L2TP_API_TUNNEL_FLAG_PPP_PROFILE_NAME 536870912
#define L2TP_API_TUNNEL_FLAG_DO_PMTU_DISCOVERY 1073741824
#define L2TP_API_TUNNEL_FLAG_MTU 2147483648
#define L2TP_API_TUNNEL_FLAG_INTERFACE_NAME 1

struct l2tp_api_tunnel_msg_data {
	uint32_t flags;
	uint32_t flags2;
	uint16_t tunnel_id;
	uint16_t peer_tunnel_id;
	int result_code;
	int hide_avps;
	optstring tunnel_name;
	struct l2tp_api_ip_addr our_addr;
	struct l2tp_api_ip_addr peer_addr;
	uint16_t our_udp_port;
	uint16_t peer_udp_port;
	int config_id;
	enum l2tp_api_tunnel_auth_mode auth_mode;
	bool_t framing_cap_sync;
	bool_t framing_cap_async;
	bool_t bearer_cap_digital;
	bool_t bearer_cap_analog;
	bool_t use_tiebreaker;
	bool_t allow_ppp_proxy;
	bool_t use_udp_checksums;
	bool_t created_by_admin;
	optstring create_time;
	int max_sessions;
	int num_sessions;
	int use_count;
	int num_establish_retries;
	enum l2tp_api_tunnel_mode mode;
	int hello_timeout;
	int max_retries;
	uint16_t rx_window_size;
	uint16_t tx_window_size;
	uint16_t actual_tx_window_size;
	int retry_timeout;
	int idle_timeout;
	uint32_t trace_flags;
	uint32_t trace_flags_mask;
	bool_t do_pmtu_discovery;
	bool_t persist;
	int mtu;
	optstring state;
	optstring secret;
	optstring host_name;
	optstring tunnel_profile_name;
	optstring peer_profile_name;
	optstring session_profile_name;
	optstring ppp_profile_name;
	optstring interface_name;
	struct {
		u_int tiebreaker_len;
		uint8_t *tiebreaker_val;
	} tiebreaker;
	uint16_t result_code_result;
	uint16_t result_code_error;
	optstring result_code_message;
	struct l2tp_api_tunnel_peer peer;
	struct l2tp_api_tunnel_stats stats;
};
typedef struct l2tp_api_tunnel_msg_data l2tp_api_tunnel_msg_data;

struct l2tp_api_tunnel_list_msg_data {
	int result;
	struct {
		u_int tunnel_ids_len;
		uint16_t *tunnel_ids_val;
	} tunnel_ids;
};
typedef struct l2tp_api_tunnel_list_msg_data l2tp_api_tunnel_list_msg_data;
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_PROFILE_NAME "default"
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_AUTH_MODE L2TP_API_TUNNEL_AUTH_MODE_NONE
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_FRAMING_CAP_SYNC 1
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_FRAMING_CAP_ASYNC 1
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_BEARER_CAP_DIGITAL 1
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_BEARER_CAP_ANALOG 1
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_USE_TIEBREAKER 0
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_HELLO_TIMEOUT 60
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_MAX_RETRIES 5
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_RX_WINDOW_SIZE 10
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_TX_WINDOW_SIZE 10
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_RETRY_TIMEOUT 1
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_IDLE_TIMEOUT 0
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_ZLB_TIMEOUT 5
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_TRACE_FLAGS 0
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_ALLOW_PPP_PROXY 0
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_USE_UDP_CHECKSUMS 1
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_DO_PMTU_DISCOVERY 0
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_MTU 1460
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_HIDE_AVPS 0
#define L2TP_API_TUNNEL_PROFILE_DEFAULT_MAX_SESSIONS 0
#define L2TP_API_TUNNEL_PROFILE_FLAG_HIDE_AVPS 1
#define L2TP_API_TUNNEL_PROFILE_FLAG_AUTH_MODE 2
#define L2TP_API_TUNNEL_PROFILE_FLAG_FRAMING_CAP 4
#define L2TP_API_TUNNEL_PROFILE_FLAG_BEARER_CAP 8
#define L2TP_API_TUNNEL_PROFILE_FLAG_USE_TIEBREAKER 16
#define L2TP_API_TUNNEL_PROFILE_FLAG_UNUSED_1 32
#define L2TP_API_TUNNEL_PROFILE_FLAG_HELLO_TIMEOUT 64
#define L2TP_API_TUNNEL_PROFILE_FLAG_MAX_RETRIES 128
#define L2TP_API_TUNNEL_PROFILE_FLAG_RX_WINDOW_SIZE 256
#define L2TP_API_TUNNEL_PROFILE_FLAG_TX_WINDOW_SIZE 512
#define L2TP_API_TUNNEL_PROFILE_FLAG_RETRY_TIMEOUT 1024
#define L2TP_API_TUNNEL_PROFILE_FLAG_IDLE_TIMEOUT 2048
#define L2TP_API_TUNNEL_PROFILE_FLAG_SECRET 4096
#define L2TP_API_TUNNEL_PROFILE_FLAG_ALLOW_PPP_PROXY 8192
#define L2TP_API_TUNNEL_PROFILE_FLAG_TRACE_FLAGS 16384
#define L2TP_API_TUNNEL_PROFILE_FLAG_USE_UDP_CHECKSUMS 32768
#define L2TP_API_TUNNEL_PROFILE_FLAG_HOST_NAME 65536
#define L2TP_API_TUNNEL_PROFILE_FLAG_MAX_SESSIONS 131072
#define L2TP_API_TUNNEL_PROFILE_FLAG_OUR_ADDR 262144
#define L2TP_API_TUNNEL_PROFILE_FLAG_PEER_ADDR 524288
#define L2TP_API_TUNNEL_PROFILE_FLAG_OUR_UDP_PORT 1048576
#define L2TP_API_TUNNEL_PROFILE_FLAG_PEER_UDP_PORT 2097152
#define L2TP_API_TUNNEL_PROFILE_FLAG_UNUSED_2 4194304
#define L2TP_API_TUNNEL_PROFILE_FLAG_PEER_PROFILE_NAME 8388608
#define L2TP_API_TUNNEL_PROFILE_FLAG_SESSION_PROFILE_NAME 16777216
#define L2TP_API_TUNNEL_PROFILE_FLAG_PPP_PROFILE_NAME 33554432
#define L2TP_API_TUNNEL_PROFILE_FLAG_DO_PMTU_DISCOVERY 67108864
#define L2TP_API_TUNNEL_PROFILE_FLAG_MTU 134217728

struct l2tp_api_tunnel_profile_msg_data {
	uint32_t flags;
	char *profile_name;
	int result_code;
	int hide_avps;
	enum l2tp_api_tunnel_auth_mode auth_mode;
	bool_t framing_cap_sync;
	bool_t framing_cap_async;
	bool_t bearer_cap_digital;
	bool_t bearer_cap_analog;
	bool_t use_tiebreaker;
	bool_t allow_ppp_proxy;
	bool_t use_udp_checksums;
	int hello_timeout;
	int max_retries;
	uint16_t rx_window_size;
	uint16_t tx_window_size;
	int retry_timeout;
	int idle_timeout;
	uint32_t trace_flags;
	uint32_t trace_flags_mask;
	int max_sessions;
	struct l2tp_api_ip_addr our_addr;
	struct l2tp_api_ip_addr peer_addr;
	uint16_t our_udp_port;
	uint16_t peer_udp_port;
	bool_t do_pmtu_discovery;
	int mtu;
	optstring peer_profile_name;
	optstring session_profile_name;
	optstring ppp_profile_name;
	optstring secret;
	optstring host_name;
};
typedef struct l2tp_api_tunnel_profile_msg_data l2tp_api_tunnel_profile_msg_data;

struct l2tp_api_tunnel_profile_list_entry {
	char *profile_name;
	struct l2tp_api_tunnel_profile_list_entry *next;
};
typedef struct l2tp_api_tunnel_profile_list_entry l2tp_api_tunnel_profile_list_entry;

struct l2tp_api_tunnel_profile_list_msg_data {
	int result;
	int num_profiles;
	struct l2tp_api_tunnel_profile_list_entry *profiles;
};
typedef struct l2tp_api_tunnel_profile_list_msg_data l2tp_api_tunnel_profile_list_msg_data;

struct l2tp_api_tunnel_profile_unset_msg_data {
	uint32_t flags;
	int result_code;
	char *profile_name;
};
typedef struct l2tp_api_tunnel_profile_unset_msg_data l2tp_api_tunnel_profile_unset_msg_data;
#define L2TP_API_SESSION_DEFAULT_SESSION_TYPE L2TP_API_SESSION_TYPE_UNSPECIFIED
#define L2TP_API_SESSION_FLAG_TRACE_FLAGS 1
#define L2TP_API_SESSION_FLAG_SEQUENCING_REQUIRED 2
#define L2TP_API_SESSION_FLAG_PPP_PROFILE_NAME 4
#define L2TP_API_SESSION_FLAG_SESSION_TYPE 8
#define L2TP_API_SESSION_FLAG_PRIV_GROUP_ID 16
#define L2TP_API_SESSION_FLAG_FRAMING_TYPE 32
#define L2TP_API_SESSION_FLAG_BEARER_TYPE 64
#define L2TP_API_SESSION_FLAG_MINIMUM_BPS 128
#define L2TP_API_SESSION_FLAG_MAXIMUM_BPS 256
#define L2TP_API_SESSION_FLAG_CONNECT_SPEED 512
#define L2TP_API_SESSION_FLAG_USE_PPP_PROXY 1024
#define L2TP_API_SESSION_FLAG_PROXY_AUTH_TYPE 8192
#define L2TP_API_SESSION_FLAG_PROXY_AUTH_NAME 16384
#define L2TP_API_SESSION_FLAG_PROXY_AUTH_CHALLENGE 32768
#define L2TP_API_SESSION_FLAG_PROXY_AUTH_RESPONSE 65536
#define L2TP_API_SESSION_FLAG_CALLING_NUMBER 131072
#define L2TP_API_SESSION_FLAG_CALLED_NUMBER 262144
#define L2TP_API_SESSION_FLAG_SUB_ADDRESS 524288
#define L2TP_API_SESSION_FLAG_INITIAL_RCVD_LCP_CONFREQ 1048576
#define L2TP_API_SESSION_FLAG_LAST_SENT_LCP_CONFREQ 2097152
#define L2TP_API_SESSION_FLAG_LAST_RCVD_LCP_CONFREQ 4194304
#define L2TP_API_SESSION_FLAG_USER_NAME 8388608
#define L2TP_API_SESSION_FLAG_USER_PASSWORD 16777216
#define L2TP_API_SESSION_FLAG_USE_SEQUENCE_NUMBERS 33554432
#define L2TP_API_SESSION_FLAG_REORDER_TIMEOUT 67108864
#define L2TP_API_SESSION_FLAG_TUNNEL_NAME 134217728
#define L2TP_API_SESSION_FLAG_SESSION_NAME 268435456
#define L2TP_API_SESSION_FLAG_INTERFACE_NAME 536870912
#define L2TP_API_SESSION_FLAG_PROFILE_NAME 1073741824
#define L2TP_API_SESSION_FLAG_NO_PPP 2147483648

enum l2tp_api_session_proxy_auth_type {
	L2TP_API_SESSION_PROXY_AUTH_TYPE_RESERVED = 0,
	L2TP_API_SESSION_PROXY_AUTH_TYPE_PLAIN_TEXT = 1,
	L2TP_API_SESSION_PROXY_AUTH_TYPE_PPP_CHAP = 2,
	L2TP_API_SESSION_PROXY_AUTH_TYPE_PPP_PAP = 3,
	L2TP_API_SESSION_PROXY_AUTH_TYPE_NO_AUTH = 4,
	L2TP_API_SESSION_PROXY_AUTH_TYPE_PPP_MSCHAPV1 = 5,
};
typedef enum l2tp_api_session_proxy_auth_type l2tp_api_session_proxy_auth_type;

struct l2tp_api_session_call_errors {
	uint32_t crc_errors;
	uint32_t framing_errors;
	uint32_t hardware_overruns;
	uint32_t buffer_overruns;
	uint32_t timeout_errors;
	uint32_t alignment_errors;
};
typedef struct l2tp_api_session_call_errors l2tp_api_session_call_errors;

struct l2tp_api_session_stats {
	uint64_t data_rx_packets;
	uint64_t data_rx_bytes;
	uint64_t data_rx_errors;
	uint64_t data_rx_oos_packets;
	uint64_t data_rx_oos_discards;
	uint64_t data_tx_packets;
	uint64_t data_tx_bytes;
	uint64_t data_tx_errors;
};
typedef struct l2tp_api_session_stats l2tp_api_session_stats;

struct l2tp_api_session_peer_info {
	uint16_t result_code;
	uint16_t error_code;
	optstring error_message;
	uint32_t minimum_bps;
	uint32_t maximum_bps;
	uint32_t connect_speed;
	uint32_t rx_connect_speed;
	enum l2tp_api_session_proxy_auth_type proxy_auth_type;
	uint8_t proxy_auth_id;
	optstring proxy_auth_name;
	struct {
		u_int proxy_auth_challenge_len;
		uint8_t *proxy_auth_challenge_val;
	} proxy_auth_challenge;
	struct {
		u_int proxy_auth_response_len;
		uint8_t *proxy_auth_response_val;
	} proxy_auth_response;
	optstring private_group_id;
	bool_t framing_type_sync;
	bool_t framing_type_async;
	bool_t bearer_type_digital;
	bool_t bearer_type_analog;
	bool_t sequencing_required;
	uint32_t call_serial_number;
	uint32_t physical_channel_id;
	struct {
		u_int initial_rcvd_lcp_confreq_len;
		uint8_t *initial_rcvd_lcp_confreq_val;
	} initial_rcvd_lcp_confreq;
	struct {
		u_int last_sent_lcp_confreq_len;
		uint8_t *last_sent_lcp_confreq_val;
	} last_sent_lcp_confreq;
	struct {
		u_int last_rcvd_lcp_confreq_len;
		uint8_t *last_rcvd_lcp_confreq_val;
	} last_rcvd_lcp_confreq;
	optstring calling_number;
	optstring called_number;
	optstring sub_address;
	uint16_t q931_cause_code;
	uint16_t q931_cause_msg;
	optstring q931_advisory_msg;
	struct l2tp_api_session_call_errors call_errors;
	uint32_t send_accm;
	uint32_t recv_accm;
};
typedef struct l2tp_api_session_peer_info l2tp_api_session_peer_info;

enum l2tp_api_session_type {
	L2TP_API_SESSION_TYPE_UNSPECIFIED = 0,
	L2TP_API_SESSION_TYPE_LAIC = 1,
	L2TP_API_SESSION_TYPE_LAOC = 2,
	L2TP_API_SESSION_TYPE_LNIC = 3,
	L2TP_API_SESSION_TYPE_LNOC = 4,
};
typedef enum l2tp_api_session_type l2tp_api_session_type;

struct l2tp_api_session_msg_data {
	uint32_t flags;
	uint16_t tunnel_id;
	uint16_t session_id;
	int result_code;
	optstring tunnel_name;
	uint16_t peer_session_id;
	optstring state;
	optstring session_name;
	optstring interface_name;
	enum l2tp_api_session_type session_type;
	optstring user_name;
	optstring user_password;
	optstring priv_group_id;
	optstring profile_name;
	bool_t created_by_admin;
	optstring create_time;
	bool_t no_ppp;
	bool_t sequencing_required;
	bool_t use_sequence_numbers;
	int reorder_timeout;
	bool_t framing_type_sync;
	bool_t framing_type_async;
	bool_t bearer_type_digital;
	bool_t bearer_type_analog;
	uint32_t call_serial_number;
	uint32_t physical_channel_id;
	uint32_t trace_flags;
	uint32_t trace_flags_mask;
	int minimum_bps;
	int maximum_bps;
	int tx_connect_speed;
	int rx_connect_speed;
	struct l2tp_api_session_peer_info peer;
	optstring ppp_profile_name;
	struct l2tp_api_session_stats stats;
	bool_t use_ppp_proxy;
	enum l2tp_api_session_proxy_auth_type proxy_auth_type;
	optstring proxy_auth_name;
	struct {
		u_int proxy_auth_challenge_len;
		uint8_t *proxy_auth_challenge_val;
	} proxy_auth_challenge;
	struct {
		u_int proxy_auth_response_len;
		uint8_t *proxy_auth_response_val;
	} proxy_auth_response;
	optstring calling_number;
	optstring called_number;
	optstring sub_address;
	struct {
		u_int initial_rcvd_lcp_confreq_len;
		uint8_t *initial_rcvd_lcp_confreq_val;
	} initial_rcvd_lcp_confreq;
	struct {
		u_int last_sent_lcp_confreq_len;
		uint8_t *last_sent_lcp_confreq_val;
	} last_sent_lcp_confreq;
	struct {
		u_int last_rcvd_lcp_confreq_len;
		uint8_t *last_rcvd_lcp_confreq_val;
	} last_rcvd_lcp_confreq;
};
typedef struct l2tp_api_session_msg_data l2tp_api_session_msg_data;

struct l2tp_api_session_list_msg_data {
	int result;
	struct {
		u_int session_ids_len;
		uint16_t *session_ids_val;
	} session_ids;
};
typedef struct l2tp_api_session_list_msg_data l2tp_api_session_list_msg_data;

struct l2tp_api_session_incall_msg_data {
	int ppp_unit;
	char *tunnel_profile_name;
	struct l2tp_api_session_msg_data session;
};
typedef struct l2tp_api_session_incall_msg_data l2tp_api_session_incall_msg_data;
#define L2TP_API_SESSION_PROFILE_DEFAULT_PROFILE_NAME "default"
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_TRACE_FLAGS 0
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_SEQUENCING_REQUIRED 0
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_TYPE L2TP_API_SESSION_TYPE_UNSPECIFIED
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_FRAMING_TYPE_SYNC 1
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_FRAMING_TYPE_ASYNC 1
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_BEARER_TYPE_ANALOG 1
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_BEARER_TYPE_DIGITAL 1
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_MINIMUM_BPS 0
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_MAXIMUM_BPS 0
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_TX_CONNECT_SPEED 1000000
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_RX_CONNECT_SPEED 0
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_USE_PPP_PROXY FALSE
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_USE_SEQUENCE_NUMBERS FALSE
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_REORDER_TIMEOUT 0
#define L2TP_API_SESSION_PROFILE_DEFAULT_SESSION_NO_PPP FALSE
#define L2TP_API_SESSION_PROFILE_FLAG_TRACE_FLAGS 1
#define L2TP_API_SESSION_PROFILE_FLAG_SEQUENCING_REQUIRED 2
#define L2TP_API_SESSION_PROFILE_FLAG_PPP_PROFILE_NAME 4
#define L2TP_API_SESSION_PROFILE_FLAG_SESSION_TYPE 8
#define L2TP_API_SESSION_PROFILE_FLAG_PRIV_GROUP_ID 16
#define L2TP_API_SESSION_PROFILE_FLAG_FRAMING_TYPE 32
#define L2TP_API_SESSION_PROFILE_FLAG_BEARER_TYPE 64
#define L2TP_API_SESSION_PROFILE_FLAG_MINIMUM_BPS 128
#define L2TP_API_SESSION_PROFILE_FLAG_MAXIMUM_BPS 256
#define L2TP_API_SESSION_PROFILE_FLAG_CONNECT_SPEED 512
#define L2TP_API_SESSION_PROFILE_FLAG_USE_PPP_PROXY 1024
#define L2TP_API_SESSION_PROFILE_FLAG_USE_SEQUENCE_NUMBERS 2048
#define L2TP_API_SESSION_PROFILE_FLAG_REORDER_TIMEOUT 4096
#define L2TP_API_SESSION_PROFILE_FLAG_NO_PPP 8192

struct l2tp_api_session_profile_msg_data {
	uint32_t flags;
	int result_code;
	char *profile_name;
	bool_t sequencing_required;
	bool_t use_sequence_numbers;
	bool_t no_ppp;
	int reorder_timeout;
	bool_t do_pmtu_discovery;
	int mtu;
	int mru;
	uint32_t trace_flags;
	uint32_t trace_flags_mask;
	optstring ppp_profile_name;
	enum l2tp_api_session_type session_type;
	optstring priv_group_id;
	bool_t framing_type_sync;
	bool_t framing_type_async;
	bool_t bearer_type_digital;
	bool_t bearer_type_analog;
	int minimum_bps;
	int maximum_bps;
	int tx_connect_speed;
	int rx_connect_speed;
	bool_t use_ppp_proxy;
};
typedef struct l2tp_api_session_profile_msg_data l2tp_api_session_profile_msg_data;

struct l2tp_api_session_profile_list_entry {
	char *profile_name;
	struct l2tp_api_session_profile_list_entry *next;
};
typedef struct l2tp_api_session_profile_list_entry l2tp_api_session_profile_list_entry;

struct l2tp_api_session_profile_list_msg_data {
	int result;
	int num_profiles;
	struct l2tp_api_session_profile_list_entry *profiles;
};
typedef struct l2tp_api_session_profile_list_msg_data l2tp_api_session_profile_list_msg_data;

struct l2tp_api_session_profile_unset_msg_data {
	uint32_t flags;
	int result_code;
	char *profile_name;
};
typedef struct l2tp_api_session_profile_unset_msg_data l2tp_api_session_profile_unset_msg_data;
#define L2TP_API_PPP_PROFILE_FLAG_TRACE_FLAGS 1
#define L2TP_API_PPP_PROFILE_FLAG_ASYNCMAP 2
#define L2TP_API_PPP_PROFILE_FLAG_MRU 4
#define L2TP_API_PPP_PROFILE_FLAG_MTU 8
#define L2TP_API_PPP_PROFILE_FLAG_USE_RADIUS 32
#define L2TP_API_PPP_PROFILE_FLAG_RADIUS_HINT 64
#define L2TP_API_PPP_PROFILE_FLAG_SYNC_MODE 256
#define L2TP_API_PPP_PROFILE_FLAG_CHAP_INTERVAL 512
#define L2TP_API_PPP_PROFILE_FLAG_CHAP_MAX_CHALLENGE 1024
#define L2TP_API_PPP_PROFILE_FLAG_CHAP_RESTART 2048
#define L2TP_API_PPP_PROFILE_FLAG_PAP_MAX_AUTH_REQUESTS 4096
#define L2TP_API_PPP_PROFILE_FLAG_PAP_RESTART_INTERVAL 8192
#define L2TP_API_PPP_PROFILE_FLAG_PAP_TIMEOUT 16384
#define L2TP_API_PPP_PROFILE_FLAG_IDLE_TIMEOUT 32768
#define L2TP_API_PPP_PROFILE_FLAG_IPCP_MAX_CONFIG_REQUESTS 65536
#define L2TP_API_PPP_PROFILE_FLAG_IPCP_MAX_CONFIG_NAKS 131072
#define L2TP_API_PPP_PROFILE_FLAG_IPCP_MAX_TERMINATE_REQUESTS 262144
#define L2TP_API_PPP_PROFILE_FLAG_IPCP_RETRANSMIT_INTERVAL 524288
#define L2TP_API_PPP_PROFILE_FLAG_LCP_ECHO_FAILURE_COUNT 1048576
#define L2TP_API_PPP_PROFILE_FLAG_LCP_ECHO_INTERVAL 2097152
#define L2TP_API_PPP_PROFILE_FLAG_LCP_MAX_CONFIG_REQUESTS 4194304
#define L2TP_API_PPP_PROFILE_FLAG_LCP_MAX_CONFIG_NAKS 8388608
#define L2TP_API_PPP_PROFILE_FLAG_LCP_MAX_TERMINATE_REQUESTS 16777216
#define L2TP_API_PPP_PROFILE_FLAG_LCP_RETRANSMIT_INTERVAL 33554432
#define L2TP_API_PPP_PROFILE_FLAG_MAX_CONNECT_TIME 67108864
#define L2TP_API_PPP_PROFILE_FLAG_MAX_FAILURE_COUNT 134217728
#define L2TP_API_PPP_PROFILE_FLAG_DNS_ADDR_1 1
#define L2TP_API_PPP_PROFILE_FLAG_DNS_ADDR_2 2
#define L2TP_API_PPP_PROFILE_FLAG_WINS_ADDR_1 4
#define L2TP_API_PPP_PROFILE_FLAG_WINS_ADDR_2 8
#define L2TP_API_PPP_PROFILE_FLAG_LOCAL_IP_ADDR 16
#define L2TP_API_PPP_PROFILE_FLAG_PEER_IP_ADDR 32
#define L2TP_API_PPP_PROFILE_FLAG_IP_POOL_NAME 64
#define L2TP_API_PPP_PROFILE_FLAG_USE_AS_DEFAULT_ROUTE 128
#define L2TP_API_PPP_PROFILE_FLAG_MULTILINK 256
#define L2TP_API_PPP_PROFILE_FLAG_LOCAL_NAME 512
#define L2TP_API_PPP_PROFILE_FLAG_REMOTE_NAME 1024
#define L2TP_API_PPP_PROFILE_FLAG_PROXY_ARP 2048
#define L2TP_API_PPP_PROFILE_FLAG_AUTH_NONE 4096
#define L2TP_API_PPP_PROFILE_FLAG_AUTH_REFUSE_EAP 8192
#define L2TP_API_PPP_PROFILE_FLAG_AUTH_REFUSE_MSCHAPV2 16384
#define L2TP_API_PPP_PROFILE_FLAG_AUTH_REFUSE_MSCHAP 32768
#define L2TP_API_PPP_PROFILE_FLAG_AUTH_REFUSE_CHAP 65536
#define L2TP_API_PPP_PROFILE_FLAG_AUTH_REFUSE_PAP 131072
#define L2TP_API_PPP_PROFILE_FLAG_AUTH_PEER 262144
#define L2TP_API_PPP_PROFILE_DEFAULT_PROFILE_NAME "default"
#define L2TP_API_PPP_PROFILE_DEFAULT_TRACE_FLAGS 0
#define L2TP_API_PPP_PROFILE_DEFAULT_ASYNCMAP 0
#define L2TP_API_PPP_PROFILE_DEFAULT_MRU 1500
#define L2TP_API_PPP_PROFILE_DEFAULT_MTU 1500
#define L2TP_API_PPP_PROFILE_DEFAULT_AUTH_NONE 0
#define L2TP_API_PPP_PROFILE_DEFAULT_AUTH_PEER 0
#define L2TP_API_PPP_PROFILE_DEFAULT_AUTH_REFUSE_PAP 0
#define L2TP_API_PPP_PROFILE_DEFAULT_AUTH_REFUSE_CHAP 0
#define L2TP_API_PPP_PROFILE_DEFAULT_AUTH_REFUSE_MSCHAP 0
#define L2TP_API_PPP_PROFILE_DEFAULT_AUTH_REFUSE_MSCHAPV2 0
#define L2TP_API_PPP_PROFILE_DEFAULT_AUTH_REFUSE_EAP 0
#define L2TP_API_PPP_PROFILE_DEFAULT_SYNC_MODE L2TP_API_PPP_SYNCMODE_SYNC_ASYNC
#define L2TP_API_PPP_PROFILE_DEFAULT_CHAP_INTERVAL 10
#define L2TP_API_PPP_PROFILE_DEFAULT_CHAP_MAX_CHALLENGE 10
#define L2TP_API_PPP_PROFILE_DEFAULT_CHAP_RESTART 3
#define L2TP_API_PPP_PROFILE_DEFAULT_PAP_MAX_AUTH_REQUESTS 10
#define L2TP_API_PPP_PROFILE_DEFAULT_PAP_RESTART_INTERVAL 3
#define L2TP_API_PPP_PROFILE_DEFAULT_PAP_TIMEOUT 0
#define L2TP_API_PPP_PROFILE_DEFAULT_IDLE_TIMEOUT 0
#define L2TP_API_PPP_PROFILE_DEFAULT_IPCP_MAX_CONFIG_REQUESTS 10
#define L2TP_API_PPP_PROFILE_DEFAULT_IPCP_MAX_CONFIG_NAKS 10
#define L2TP_API_PPP_PROFILE_DEFAULT_IPCP_MAX_TERMINATE_REQUESTS 3
#define L2TP_API_PPP_PROFILE_DEFAULT_IPCP_RETRANSMIT_INTERVAL 3
#define L2TP_API_PPP_PROFILE_DEFAULT_LCP_ECHO_FAILURE_COUNT 0
#define L2TP_API_PPP_PROFILE_DEFAULT_LCP_ECHO_INTERVAL 0
#define L2TP_API_PPP_PROFILE_DEFAULT_LCP_MAX_CONFIG_REQUESTS 10
#define L2TP_API_PPP_PROFILE_DEFAULT_LCP_MAX_CONFIG_NAKS 10
#define L2TP_API_PPP_PROFILE_DEFAULT_LCP_MAX_TERMINATE_REQUESTS 3
#define L2TP_API_PPP_PROFILE_DEFAULT_LCP_RETRANSMIT_INTERVAL 3
#define L2TP_API_PPP_PROFILE_DEFAULT_MAX_CONNECT_TIME 0
#define L2TP_API_PPP_PROFILE_DEFAULT_MAX_FAILURE_COUNT 10
#define L2TP_API_PPP_PROFILE_DEFAULT_LOCAL_IP_ADDR 0
#define L2TP_API_PPP_PROFILE_DEFAULT_PEER_IP_ADDR 0
#define L2TP_API_PPP_PROFILE_DEFAULT_DNS_ADDR_1 0
#define L2TP_API_PPP_PROFILE_DEFAULT_DNS_ADDR_2 0
#define L2TP_API_PPP_PROFILE_DEFAULT_WINS_ADDR_1 0
#define L2TP_API_PPP_PROFILE_DEFAULT_WINS_ADDR_2 0
#define L2TP_API_PPP_PROFILE_DEFAULT_USE_RADIUS 0
#define L2TP_API_PPP_PROFILE_DEFAULT_RADIUS_HINT ""
#define L2TP_API_PPP_PROFILE_DEFAULT_USE_AS_DEFAULT_ROUTE 0
#define L2TP_API_PPP_PROFILE_DEFAULT_MULTILINK 0
#define L2TP_API_PPP_PROFILE_DEFAULT_PROXY_ARP 0

enum l2tp_api_ppp_sync_mode {
	L2TP_API_PPP_SYNCMODE_SYNC_ASYNC = 0,
	L2TP_API_PPP_SYNCMODE_SYNC = 1,
	L2TP_API_PPP_SYNCMODE_ASYNC = 2,
};
typedef enum l2tp_api_ppp_sync_mode l2tp_api_ppp_sync_mode;

struct l2tp_api_ppp_profile_msg_data {
	uint32_t flags;
	uint32_t flags2;
	int result_code;
	uint32_t trace_flags;
	uint32_t trace_flags_mask;
	char *profile_name;
	uint32_t asyncmap;
	uint16_t mru;
	uint16_t mtu;
	bool_t auth_none;
	bool_t auth_peer;
	bool_t auth_refuse_pap;
	bool_t auth_refuse_chap;
	bool_t auth_refuse_mschap;
	bool_t auth_refuse_mschapv2;
	bool_t auth_refuse_eap;
	enum l2tp_api_ppp_sync_mode sync_mode;
	int chap_interval;
	int chap_max_challenge;
	int chap_restart;
	int pap_max_auth_requests;
	int pap_restart_interval;
	int pap_timeout;
	int idle_timeout;
	int ipcp_max_config_requests;
	int ipcp_max_config_naks;
	int ipcp_max_terminate_requests;
	int ipcp_retransmit_interval;
	int lcp_echo_failure_count;
	int lcp_echo_interval;
	int lcp_max_config_requests;
	int lcp_max_config_naks;
	int lcp_max_terminate_requests;
	int lcp_retransmit_interval;
	int max_connect_time;
	int max_failure_count;
	struct l2tp_api_ip_addr local_ip_addr;
	struct l2tp_api_ip_addr peer_ip_addr;
	struct l2tp_api_ip_addr dns_addr_1;
	struct l2tp_api_ip_addr dns_addr_2;
	struct l2tp_api_ip_addr wins_addr_1;
	struct l2tp_api_ip_addr wins_addr_2;
	optstring ip_pool_name;
	bool_t use_radius;
	optstring radius_hint;
	bool_t use_as_default_route;
	bool_t multilink;
	optstring local_name;
	optstring remote_name;
	bool_t proxy_arp;
};
typedef struct l2tp_api_ppp_profile_msg_data l2tp_api_ppp_profile_msg_data;

struct l2tp_api_ppp_profile_list_entry {
	char *profile_name;
	struct l2tp_api_ppp_profile_list_entry *next;
};
typedef struct l2tp_api_ppp_profile_list_entry l2tp_api_ppp_profile_list_entry;

struct l2tp_api_ppp_profile_list_msg_data {
	int result;
	int num_profiles;
	struct l2tp_api_ppp_profile_list_entry *profiles;
};
typedef struct l2tp_api_ppp_profile_list_msg_data l2tp_api_ppp_profile_list_msg_data;

struct l2tp_api_ppp_profile_unset_msg_data {
	uint32_t flags;
	uint32_t flags2;
	int result_code;
	char *profile_name;
};
typedef struct l2tp_api_ppp_profile_unset_msg_data l2tp_api_ppp_profile_unset_msg_data;

struct l2tp_api_user_list_entry {
	char *user_name;
	char *create_time;
	bool_t created_by_admin;
	uint16_t tunnel_id;
	uint16_t session_id;
	struct l2tp_api_user_list_entry *next;
};
typedef struct l2tp_api_user_list_entry l2tp_api_user_list_entry;

struct l2tp_api_user_list_msg_data {
	int result;
	int num_users;
	struct l2tp_api_user_list_entry *users;
};
typedef struct l2tp_api_user_list_msg_data l2tp_api_user_list_msg_data;
#define L2TP_API_TEST_FLAG_FAKE_RX_DROP 1
#define L2TP_API_TEST_FLAG_FAKE_TX_DROP 2
#define L2TP_API_TEST_FLAG_FAKE_TRIGGER_TYPE 4
#define L2TP_API_TEST_FLAG_CLEAR_FAKE_TRIGGER 8
#define L2TP_API_TEST_FLAG_HOLD_TUNNELS 16
#define L2TP_API_TEST_FLAG_HOLD_SESSIONS 32
#define L2TP_API_TEST_FLAG_NO_RANDOM_IDS 64
#define L2TP_API_TEST_FLAG_RESET_IDS 128
#define L2TP_API_TEST_FLAG_DO_TRANSPORT_TEST 256
#define L2TP_API_TEST_FLAG_TUNNEL_ID 512
#define L2TP_API_TEST_FLAG_SESSION_ID 1024
#define L2TP_API_TEST_FLAG_DEFAULT_CONFIG 2048
#define L2TP_API_TEST_FLAG_SHOW_PROFILE_USAGE 4096

enum l2tp_api_test_trigger_type {
	L2TP_API_TEST_FAKE_TRIGGER_OFF = 0,
	L2TP_API_TEST_FAKE_TRIGGER_ON = 1,
	L2TP_API_TEST_FAKE_TRIGGER_ONCE = 2,
	L2TP_API_TEST_FAKE_TRIGGER_LOW = 3,
	L2TP_API_TEST_FAKE_TRIGGER_MEDIUM = 4,
	L2TP_API_TEST_FAKE_TRIGGER_HIGH = 5,
};
typedef enum l2tp_api_test_trigger_type l2tp_api_test_trigger_type;

struct l2tp_api_test_msg_data {
	uint32_t flags;
	bool_t fake_rx_drop;
	bool_t fake_tx_drop;
	bool_t fake_trigger_fired;
	bool_t hold_tunnels;
	bool_t hold_sessions;
	bool_t no_random_ids;
	bool_t show_profile_usage;
	int num_rx_drops;
	int num_tx_drops;
	enum l2tp_api_test_trigger_type fake_trigger_type;
	uint16_t tunnel_id;
	uint16_t session_id;
	int num_tunnel_id_hash_hits;
	int num_tunnel_id_hash_misses;
	int num_tunnel_name_hash_hits;
	int num_tunnel_name_hash_misses;
	int num_session_id_hash_hits;
	int num_session_id_hash_misses;
};
typedef struct l2tp_api_test_msg_data l2tp_api_test_msg_data;

struct l2tp_tunnel_delete_1_argument {
	uint16_t tunnel_id;
	optstring tunnel_name;
	optstring reason;
};
typedef struct l2tp_tunnel_delete_1_argument l2tp_tunnel_delete_1_argument;

struct l2tp_tunnel_get_1_argument {
	uint16_t tunnel_id;
	optstring tunnel_name;
};
typedef struct l2tp_tunnel_get_1_argument l2tp_tunnel_get_1_argument;

struct l2tp_session_delete_1_argument {
	uint16_t tunnel_id;
	optstring tunnel_name;
	uint16_t session_id;
	optstring session_name;
	optstring reason;
};
typedef struct l2tp_session_delete_1_argument l2tp_session_delete_1_argument;

struct l2tp_session_get_1_argument {
	uint16_t tunnel_id;
	optstring tunnel_name;
	uint16_t session_id;
	optstring session_name;
};
typedef struct l2tp_session_get_1_argument l2tp_session_get_1_argument;

struct l2tp_session_list_1_argument {
	uint16_t tunnel_id;
	optstring tunnel_name;
};
typedef struct l2tp_session_list_1_argument l2tp_session_list_1_argument;

struct l2tp_peer_get_1_argument {
	struct l2tp_api_ip_addr local_addr;
	struct l2tp_api_ip_addr peer_addr;
};
typedef struct l2tp_peer_get_1_argument l2tp_peer_get_1_argument;

#define L2TP_PROG 300773
#define L2TP_VERSION 1

#if defined(__STDC__) || defined(__cplusplus)
#define L2TP_APP_INFO_GET 1
extern  enum clnt_stat l2tp_app_info_get_1(struct l2tp_api_app_msg_data *, CLIENT *);
extern  bool_t l2tp_app_info_get_1_svc(struct l2tp_api_app_msg_data *, struct svc_req *);
#define L2TP_SYSTEM_MODIFY 2
extern  enum clnt_stat l2tp_system_modify_1(struct l2tp_api_system_msg_data , int *, CLIENT *);
extern  bool_t l2tp_system_modify_1_svc(struct l2tp_api_system_msg_data , int *, struct svc_req *);
#define L2TP_SYSTEM_GET 3
extern  enum clnt_stat l2tp_system_get_1(struct l2tp_api_system_msg_data *, CLIENT *);
extern  bool_t l2tp_system_get_1_svc(struct l2tp_api_system_msg_data *, struct svc_req *);
#define L2TP_PEER_PROFILE_CREATE 4
extern  enum clnt_stat l2tp_peer_profile_create_1(struct l2tp_api_peer_profile_msg_data , int *, CLIENT *);
extern  bool_t l2tp_peer_profile_create_1_svc(struct l2tp_api_peer_profile_msg_data , int *, struct svc_req *);
#define L2TP_PEER_PROFILE_DELETE 5
extern  enum clnt_stat l2tp_peer_profile_delete_1(char *, int *, CLIENT *);
extern  bool_t l2tp_peer_profile_delete_1_svc(char *, int *, struct svc_req *);
#define L2TP_PEER_PROFILE_MODIFY 6
extern  enum clnt_stat l2tp_peer_profile_modify_1(struct l2tp_api_peer_profile_msg_data , int *, CLIENT *);
extern  bool_t l2tp_peer_profile_modify_1_svc(struct l2tp_api_peer_profile_msg_data , int *, struct svc_req *);
#define L2TP_PEER_PROFILE_GET 7
extern  enum clnt_stat l2tp_peer_profile_get_1(char *, struct l2tp_api_peer_profile_msg_data *, CLIENT *);
extern  bool_t l2tp_peer_profile_get_1_svc(char *, struct l2tp_api_peer_profile_msg_data *, struct svc_req *);
#define L2TP_PEER_PROFILE_LIST 8
extern  enum clnt_stat l2tp_peer_profile_list_1(struct l2tp_api_peer_profile_list_msg_data *, CLIENT *);
extern  bool_t l2tp_peer_profile_list_1_svc(struct l2tp_api_peer_profile_list_msg_data *, struct svc_req *);
#define L2TP_TUNNEL_CREATE 9
extern  enum clnt_stat l2tp_tunnel_create_1(struct l2tp_api_tunnel_msg_data , int *, CLIENT *);
extern  bool_t l2tp_tunnel_create_1_svc(struct l2tp_api_tunnel_msg_data , int *, struct svc_req *);
#define L2TP_TUNNEL_DELETE 10
extern  enum clnt_stat l2tp_tunnel_delete_1(uint16_t , optstring , optstring , int *, CLIENT *);
extern  bool_t l2tp_tunnel_delete_1_svc(uint16_t , optstring , optstring , int *, struct svc_req *);
#define L2TP_TUNNEL_MODIFY 11
extern  enum clnt_stat l2tp_tunnel_modify_1(struct l2tp_api_tunnel_msg_data , int *, CLIENT *);
extern  bool_t l2tp_tunnel_modify_1_svc(struct l2tp_api_tunnel_msg_data , int *, struct svc_req *);
#define L2TP_TUNNEL_GET 12
extern  enum clnt_stat l2tp_tunnel_get_1(uint16_t , optstring , struct l2tp_api_tunnel_msg_data *, CLIENT *);
extern  bool_t l2tp_tunnel_get_1_svc(uint16_t , optstring , struct l2tp_api_tunnel_msg_data *, struct svc_req *);
#define L2TP_TUNNEL_LIST 13
extern  enum clnt_stat l2tp_tunnel_list_1(struct l2tp_api_tunnel_list_msg_data *, CLIENT *);
extern  bool_t l2tp_tunnel_list_1_svc(struct l2tp_api_tunnel_list_msg_data *, struct svc_req *);
#define L2TP_TUNNEL_PROFILE_CREATE 14
extern  enum clnt_stat l2tp_tunnel_profile_create_1(struct l2tp_api_tunnel_profile_msg_data , int *, CLIENT *);
extern  bool_t l2tp_tunnel_profile_create_1_svc(struct l2tp_api_tunnel_profile_msg_data , int *, struct svc_req *);
#define L2TP_TUNNEL_PROFILE_DELETE 15
extern  enum clnt_stat l2tp_tunnel_profile_delete_1(char *, int *, CLIENT *);
extern  bool_t l2tp_tunnel_profile_delete_1_svc(char *, int *, struct svc_req *);
#define L2TP_TUNNEL_PROFILE_MODIFY 16
extern  enum clnt_stat l2tp_tunnel_profile_modify_1(struct l2tp_api_tunnel_profile_msg_data , int *, CLIENT *);
extern  bool_t l2tp_tunnel_profile_modify_1_svc(struct l2tp_api_tunnel_profile_msg_data , int *, struct svc_req *);
#define L2TP_TUNNEL_PROFILE_GET 17
extern  enum clnt_stat l2tp_tunnel_profile_get_1(char *, struct l2tp_api_tunnel_profile_msg_data *, CLIENT *);
extern  bool_t l2tp_tunnel_profile_get_1_svc(char *, struct l2tp_api_tunnel_profile_msg_data *, struct svc_req *);
#define L2TP_TUNNEL_PROFILE_LIST 18
extern  enum clnt_stat l2tp_tunnel_profile_list_1(struct l2tp_api_tunnel_profile_list_msg_data *, CLIENT *);
extern  bool_t l2tp_tunnel_profile_list_1_svc(struct l2tp_api_tunnel_profile_list_msg_data *, struct svc_req *);
#define L2TP_SESSION_CREATE 19
extern  enum clnt_stat l2tp_session_create_1(struct l2tp_api_session_msg_data , int *, CLIENT *);
extern  bool_t l2tp_session_create_1_svc(struct l2tp_api_session_msg_data , int *, struct svc_req *);
#define L2TP_SESSION_DELETE 20
extern  enum clnt_stat l2tp_session_delete_1(uint16_t , optstring , uint16_t , optstring , optstring , int *, CLIENT *);
extern  bool_t l2tp_session_delete_1_svc(uint16_t , optstring , uint16_t , optstring , optstring , int *, struct svc_req *);
#define L2TP_SESSION_MODIFY 21
extern  enum clnt_stat l2tp_session_modify_1(struct l2tp_api_session_msg_data , int *, CLIENT *);
extern  bool_t l2tp_session_modify_1_svc(struct l2tp_api_session_msg_data , int *, struct svc_req *);
#define L2TP_SESSION_GET 22
extern  enum clnt_stat l2tp_session_get_1(uint16_t , optstring , uint16_t , optstring , struct l2tp_api_session_msg_data *, CLIENT *);
extern  bool_t l2tp_session_get_1_svc(uint16_t , optstring , uint16_t , optstring , struct l2tp_api_session_msg_data *, struct svc_req *);
#define L2TP_SESSION_LIST 23
extern  enum clnt_stat l2tp_session_list_1(uint16_t , optstring , struct l2tp_api_session_list_msg_data *, CLIENT *);
extern  bool_t l2tp_session_list_1_svc(uint16_t , optstring , struct l2tp_api_session_list_msg_data *, struct svc_req *);
#define L2TP_SESSION_INCALL_IND 24
extern  enum clnt_stat l2tp_session_incall_ind_1(struct l2tp_api_session_incall_msg_data , int *, CLIENT *);
extern  bool_t l2tp_session_incall_ind_1_svc(struct l2tp_api_session_incall_msg_data , int *, struct svc_req *);
#define L2TP_SESSION_PROFILE_CREATE 25
extern  enum clnt_stat l2tp_session_profile_create_1(struct l2tp_api_session_profile_msg_data , int *, CLIENT *);
extern  bool_t l2tp_session_profile_create_1_svc(struct l2tp_api_session_profile_msg_data , int *, struct svc_req *);
#define L2TP_SESSION_PROFILE_DELETE 26
extern  enum clnt_stat l2tp_session_profile_delete_1(char *, int *, CLIENT *);
extern  bool_t l2tp_session_profile_delete_1_svc(char *, int *, struct svc_req *);
#define L2TP_SESSION_PROFILE_MODIFY 27
extern  enum clnt_stat l2tp_session_profile_modify_1(struct l2tp_api_session_profile_msg_data , int *, CLIENT *);
extern  bool_t l2tp_session_profile_modify_1_svc(struct l2tp_api_session_profile_msg_data , int *, struct svc_req *);
#define L2TP_SESSION_PROFILE_GET 28
extern  enum clnt_stat l2tp_session_profile_get_1(char *, struct l2tp_api_session_profile_msg_data *, CLIENT *);
extern  bool_t l2tp_session_profile_get_1_svc(char *, struct l2tp_api_session_profile_msg_data *, struct svc_req *);
#define L2TP_SESSION_PROFILE_LIST 29
extern  enum clnt_stat l2tp_session_profile_list_1(struct l2tp_api_session_profile_list_msg_data *, CLIENT *);
extern  bool_t l2tp_session_profile_list_1_svc(struct l2tp_api_session_profile_list_msg_data *, struct svc_req *);
#define L2TP_PPP_PROFILE_CREATE 30
extern  enum clnt_stat l2tp_ppp_profile_create_1(struct l2tp_api_ppp_profile_msg_data , int *, CLIENT *);
extern  bool_t l2tp_ppp_profile_create_1_svc(struct l2tp_api_ppp_profile_msg_data , int *, struct svc_req *);
#define L2TP_PPP_PROFILE_DELETE 31
extern  enum clnt_stat l2tp_ppp_profile_delete_1(char *, int *, CLIENT *);
extern  bool_t l2tp_ppp_profile_delete_1_svc(char *, int *, struct svc_req *);
#define L2TP_PPP_PROFILE_MODIFY 32
extern  enum clnt_stat l2tp_ppp_profile_modify_1(struct l2tp_api_ppp_profile_msg_data , int *, CLIENT *);
extern  bool_t l2tp_ppp_profile_modify_1_svc(struct l2tp_api_ppp_profile_msg_data , int *, struct svc_req *);
#define L2TP_PPP_PROFILE_GET 33
extern  enum clnt_stat l2tp_ppp_profile_get_1(char *, struct l2tp_api_ppp_profile_msg_data *, CLIENT *);
extern  bool_t l2tp_ppp_profile_get_1_svc(char *, struct l2tp_api_ppp_profile_msg_data *, struct svc_req *);
#define L2TP_PPP_PROFILE_LIST 34
extern  enum clnt_stat l2tp_ppp_profile_list_1(struct l2tp_api_ppp_profile_list_msg_data *, CLIENT *);
extern  bool_t l2tp_ppp_profile_list_1_svc(struct l2tp_api_ppp_profile_list_msg_data *, struct svc_req *);
#define L2TP_PEER_GET 35
extern  enum clnt_stat l2tp_peer_get_1(struct l2tp_api_ip_addr , struct l2tp_api_ip_addr , struct l2tp_api_peer_msg_data *, CLIENT *);
extern  bool_t l2tp_peer_get_1_svc(struct l2tp_api_ip_addr , struct l2tp_api_ip_addr , struct l2tp_api_peer_msg_data *, struct svc_req *);
#define L2TP_PEER_LIST 36
extern  enum clnt_stat l2tp_peer_list_1(struct l2tp_api_peer_list_msg_data *, CLIENT *);
extern  bool_t l2tp_peer_list_1_svc(struct l2tp_api_peer_list_msg_data *, struct svc_req *);
#define L2TP_USER_LIST 37
extern  enum clnt_stat l2tp_user_list_1(struct l2tp_api_user_list_msg_data *, CLIENT *);
extern  bool_t l2tp_user_list_1_svc(struct l2tp_api_user_list_msg_data *, struct svc_req *);
#define L2TP_PEER_PROFILE_UNSET 38
extern  enum clnt_stat l2tp_peer_profile_unset_1(struct l2tp_api_peer_profile_unset_msg_data , int *, CLIENT *);
extern  bool_t l2tp_peer_profile_unset_1_svc(struct l2tp_api_peer_profile_unset_msg_data , int *, struct svc_req *);
#define L2TP_TUNNEL_PROFILE_UNSET 39
extern  enum clnt_stat l2tp_tunnel_profile_unset_1(struct l2tp_api_tunnel_profile_unset_msg_data , int *, CLIENT *);
extern  bool_t l2tp_tunnel_profile_unset_1_svc(struct l2tp_api_tunnel_profile_unset_msg_data , int *, struct svc_req *);
#define L2TP_SESSION_PROFILE_UNSET 40
extern  enum clnt_stat l2tp_session_profile_unset_1(struct l2tp_api_session_profile_unset_msg_data , int *, CLIENT *);
extern  bool_t l2tp_session_profile_unset_1_svc(struct l2tp_api_session_profile_unset_msg_data , int *, struct svc_req *);
#define L2TP_PPP_PROFILE_UNSET 41
extern  enum clnt_stat l2tp_ppp_profile_unset_1(struct l2tp_api_ppp_profile_unset_msg_data , int *, CLIENT *);
extern  bool_t l2tp_ppp_profile_unset_1_svc(struct l2tp_api_ppp_profile_unset_msg_data , int *, struct svc_req *);
#define L2TP_TEST_LOG 97
extern  enum clnt_stat l2tp_test_log_1(char *, int *, CLIENT *);
extern  bool_t l2tp_test_log_1_svc(char *, int *, struct svc_req *);
#define L2TP_TEST_MODIFY 98
extern  enum clnt_stat l2tp_test_modify_1(struct l2tp_api_test_msg_data , int *, CLIENT *);
extern  bool_t l2tp_test_modify_1_svc(struct l2tp_api_test_msg_data , int *, struct svc_req *);
#define L2TP_TEST_GET 99
extern  enum clnt_stat l2tp_test_get_1(struct l2tp_api_test_msg_data *, CLIENT *);
extern  bool_t l2tp_test_get_1_svc(struct l2tp_api_test_msg_data *, struct svc_req *);
extern int l2tp_prog_1_freeresult (SVCXPRT *, xdrproc_t, caddr_t);

#else /* K&R C */
#define L2TP_APP_INFO_GET 1
extern  enum clnt_stat l2tp_app_info_get_1();
extern  bool_t l2tp_app_info_get_1_svc();
#define L2TP_SYSTEM_MODIFY 2
extern  enum clnt_stat l2tp_system_modify_1();
extern  bool_t l2tp_system_modify_1_svc();
#define L2TP_SYSTEM_GET 3
extern  enum clnt_stat l2tp_system_get_1();
extern  bool_t l2tp_system_get_1_svc();
#define L2TP_PEER_PROFILE_CREATE 4
extern  enum clnt_stat l2tp_peer_profile_create_1();
extern  bool_t l2tp_peer_profile_create_1_svc();
#define L2TP_PEER_PROFILE_DELETE 5
extern  enum clnt_stat l2tp_peer_profile_delete_1();
extern  bool_t l2tp_peer_profile_delete_1_svc();
#define L2TP_PEER_PROFILE_MODIFY 6
extern  enum clnt_stat l2tp_peer_profile_modify_1();
extern  bool_t l2tp_peer_profile_modify_1_svc();
#define L2TP_PEER_PROFILE_GET 7
extern  enum clnt_stat l2tp_peer_profile_get_1();
extern  bool_t l2tp_peer_profile_get_1_svc();
#define L2TP_PEER_PROFILE_LIST 8
extern  enum clnt_stat l2tp_peer_profile_list_1();
extern  bool_t l2tp_peer_profile_list_1_svc();
#define L2TP_TUNNEL_CREATE 9
extern  enum clnt_stat l2tp_tunnel_create_1();
extern  bool_t l2tp_tunnel_create_1_svc();
#define L2TP_TUNNEL_DELETE 10
extern  enum clnt_stat l2tp_tunnel_delete_1();
extern  bool_t l2tp_tunnel_delete_1_svc();
#define L2TP_TUNNEL_MODIFY 11
extern  enum clnt_stat l2tp_tunnel_modify_1();
extern  bool_t l2tp_tunnel_modify_1_svc();
#define L2TP_TUNNEL_GET 12
extern  enum clnt_stat l2tp_tunnel_get_1();
extern  bool_t l2tp_tunnel_get_1_svc();
#define L2TP_TUNNEL_LIST 13
extern  enum clnt_stat l2tp_tunnel_list_1();
extern  bool_t l2tp_tunnel_list_1_svc();
#define L2TP_TUNNEL_PROFILE_CREATE 14
extern  enum clnt_stat l2tp_tunnel_profile_create_1();
extern  bool_t l2tp_tunnel_profile_create_1_svc();
#define L2TP_TUNNEL_PROFILE_DELETE 15
extern  enum clnt_stat l2tp_tunnel_profile_delete_1();
extern  bool_t l2tp_tunnel_profile_delete_1_svc();
#define L2TP_TUNNEL_PROFILE_MODIFY 16
extern  enum clnt_stat l2tp_tunnel_profile_modify_1();
extern  bool_t l2tp_tunnel_profile_modify_1_svc();
#define L2TP_TUNNEL_PROFILE_GET 17
extern  enum clnt_stat l2tp_tunnel_profile_get_1();
extern  bool_t l2tp_tunnel_profile_get_1_svc();
#define L2TP_TUNNEL_PROFILE_LIST 18
extern  enum clnt_stat l2tp_tunnel_profile_list_1();
extern  bool_t l2tp_tunnel_profile_list_1_svc();
#define L2TP_SESSION_CREATE 19
extern  enum clnt_stat l2tp_session_create_1();
extern  bool_t l2tp_session_create_1_svc();
#define L2TP_SESSION_DELETE 20
extern  enum clnt_stat l2tp_session_delete_1();
extern  bool_t l2tp_session_delete_1_svc();
#define L2TP_SESSION_MODIFY 21
extern  enum clnt_stat l2tp_session_modify_1();
extern  bool_t l2tp_session_modify_1_svc();
#define L2TP_SESSION_GET 22
extern  enum clnt_stat l2tp_session_get_1();
extern  bool_t l2tp_session_get_1_svc();
#define L2TP_SESSION_LIST 23
extern  enum clnt_stat l2tp_session_list_1();
extern  bool_t l2tp_session_list_1_svc();
#define L2TP_SESSION_INCALL_IND 24
extern  enum clnt_stat l2tp_session_incall_ind_1();
extern  bool_t l2tp_session_incall_ind_1_svc();
#define L2TP_SESSION_PROFILE_CREATE 25
extern  enum clnt_stat l2tp_session_profile_create_1();
extern  bool_t l2tp_session_profile_create_1_svc();
#define L2TP_SESSION_PROFILE_DELETE 26
extern  enum clnt_stat l2tp_session_profile_delete_1();
extern  bool_t l2tp_session_profile_delete_1_svc();
#define L2TP_SESSION_PROFILE_MODIFY 27
extern  enum clnt_stat l2tp_session_profile_modify_1();
extern  bool_t l2tp_session_profile_modify_1_svc();
#define L2TP_SESSION_PROFILE_GET 28
extern  enum clnt_stat l2tp_session_profile_get_1();
extern  bool_t l2tp_session_profile_get_1_svc();
#define L2TP_SESSION_PROFILE_LIST 29
extern  enum clnt_stat l2tp_session_profile_list_1();
extern  bool_t l2tp_session_profile_list_1_svc();
#define L2TP_PPP_PROFILE_CREATE 30
extern  enum clnt_stat l2tp_ppp_profile_create_1();
extern  bool_t l2tp_ppp_profile_create_1_svc();
#define L2TP_PPP_PROFILE_DELETE 31
extern  enum clnt_stat l2tp_ppp_profile_delete_1();
extern  bool_t l2tp_ppp_profile_delete_1_svc();
#define L2TP_PPP_PROFILE_MODIFY 32
extern  enum clnt_stat l2tp_ppp_profile_modify_1();
extern  bool_t l2tp_ppp_profile_modify_1_svc();
#define L2TP_PPP_PROFILE_GET 33
extern  enum clnt_stat l2tp_ppp_profile_get_1();
extern  bool_t l2tp_ppp_profile_get_1_svc();
#define L2TP_PPP_PROFILE_LIST 34
extern  enum clnt_stat l2tp_ppp_profile_list_1();
extern  bool_t l2tp_ppp_profile_list_1_svc();
#define L2TP_PEER_GET 35
extern  enum clnt_stat l2tp_peer_get_1();
extern  bool_t l2tp_peer_get_1_svc();
#define L2TP_PEER_LIST 36
extern  enum clnt_stat l2tp_peer_list_1();
extern  bool_t l2tp_peer_list_1_svc();
#define L2TP_USER_LIST 37
extern  enum clnt_stat l2tp_user_list_1();
extern  bool_t l2tp_user_list_1_svc();
#define L2TP_PEER_PROFILE_UNSET 38
extern  enum clnt_stat l2tp_peer_profile_unset_1();
extern  bool_t l2tp_peer_profile_unset_1_svc();
#define L2TP_TUNNEL_PROFILE_UNSET 39
extern  enum clnt_stat l2tp_tunnel_profile_unset_1();
extern  bool_t l2tp_tunnel_profile_unset_1_svc();
#define L2TP_SESSION_PROFILE_UNSET 40
extern  enum clnt_stat l2tp_session_profile_unset_1();
extern  bool_t l2tp_session_profile_unset_1_svc();
#define L2TP_PPP_PROFILE_UNSET 41
extern  enum clnt_stat l2tp_ppp_profile_unset_1();
extern  bool_t l2tp_ppp_profile_unset_1_svc();
#define L2TP_TEST_LOG 97
extern  enum clnt_stat l2tp_test_log_1();
extern  bool_t l2tp_test_log_1_svc();
#define L2TP_TEST_MODIFY 98
extern  enum clnt_stat l2tp_test_modify_1();
extern  bool_t l2tp_test_modify_1_svc();
#define L2TP_TEST_GET 99
extern  enum clnt_stat l2tp_test_get_1();
extern  bool_t l2tp_test_get_1_svc();
extern int l2tp_prog_1_freeresult ();
#endif /* K&R C */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_optstring (XDR *, optstring*);
extern  bool_t xdr_l2tp_api_tunnel_auth_mode (XDR *, l2tp_api_tunnel_auth_mode*);
extern  bool_t xdr_l2tp_api_tunnel_mode (XDR *, l2tp_api_tunnel_mode*);
extern  bool_t xdr_l2tp_api_ip_addr (XDR *, l2tp_api_ip_addr*);
extern  bool_t xdr_l2tp_api_app_msg_data (XDR *, l2tp_api_app_msg_data*);
extern  bool_t xdr_l2tp_api_system_config (XDR *, l2tp_api_system_config*);
extern  bool_t xdr_l2tp_api_system_msg_stats (XDR *, l2tp_api_system_msg_stats*);
extern  bool_t xdr_l2tp_api_system_stats (XDR *, l2tp_api_system_stats*);
extern  bool_t xdr_l2tp_api_system_status (XDR *, l2tp_api_system_status*);
extern  bool_t xdr_l2tp_api_system_msg_data (XDR *, l2tp_api_system_msg_data*);
extern  bool_t xdr_l2tp_api_peer_msg_data (XDR *, l2tp_api_peer_msg_data*);
extern  bool_t xdr_l2tp_api_peer_list_entry (XDR *, l2tp_api_peer_list_entry*);
extern  bool_t xdr_l2tp_api_peer_list_msg_data (XDR *, l2tp_api_peer_list_msg_data*);
extern  bool_t xdr_l2tp_api_peer_profile_msg_data (XDR *, l2tp_api_peer_profile_msg_data*);
extern  bool_t xdr_l2tp_api_peer_profile_list_entry (XDR *, l2tp_api_peer_profile_list_entry*);
extern  bool_t xdr_l2tp_api_peer_profile_list_msg_data (XDR *, l2tp_api_peer_profile_list_msg_data*);
extern  bool_t xdr_l2tp_api_peer_profile_unset_msg_data (XDR *, l2tp_api_peer_profile_unset_msg_data*);
extern  bool_t xdr_l2tp_api_tunnel_peer (XDR *, l2tp_api_tunnel_peer*);
extern  bool_t xdr_l2tp_api_tunnel_stats (XDR *, l2tp_api_tunnel_stats*);
extern  bool_t xdr_l2tp_api_tunnel_msg_data (XDR *, l2tp_api_tunnel_msg_data*);
extern  bool_t xdr_l2tp_api_tunnel_list_msg_data (XDR *, l2tp_api_tunnel_list_msg_data*);
extern  bool_t xdr_l2tp_api_tunnel_profile_msg_data (XDR *, l2tp_api_tunnel_profile_msg_data*);
extern  bool_t xdr_l2tp_api_tunnel_profile_list_entry (XDR *, l2tp_api_tunnel_profile_list_entry*);
extern  bool_t xdr_l2tp_api_tunnel_profile_list_msg_data (XDR *, l2tp_api_tunnel_profile_list_msg_data*);
extern  bool_t xdr_l2tp_api_tunnel_profile_unset_msg_data (XDR *, l2tp_api_tunnel_profile_unset_msg_data*);
extern  bool_t xdr_l2tp_api_session_proxy_auth_type (XDR *, l2tp_api_session_proxy_auth_type*);
extern  bool_t xdr_l2tp_api_session_call_errors (XDR *, l2tp_api_session_call_errors*);
extern  bool_t xdr_l2tp_api_session_stats (XDR *, l2tp_api_session_stats*);
extern  bool_t xdr_l2tp_api_session_peer_info (XDR *, l2tp_api_session_peer_info*);
extern  bool_t xdr_l2tp_api_session_type (XDR *, l2tp_api_session_type*);
extern  bool_t xdr_l2tp_api_session_msg_data (XDR *, l2tp_api_session_msg_data*);
extern  bool_t xdr_l2tp_api_session_list_msg_data (XDR *, l2tp_api_session_list_msg_data*);
extern  bool_t xdr_l2tp_api_session_incall_msg_data (XDR *, l2tp_api_session_incall_msg_data*);
extern  bool_t xdr_l2tp_api_session_profile_msg_data (XDR *, l2tp_api_session_profile_msg_data*);
extern  bool_t xdr_l2tp_api_session_profile_list_entry (XDR *, l2tp_api_session_profile_list_entry*);
extern  bool_t xdr_l2tp_api_session_profile_list_msg_data (XDR *, l2tp_api_session_profile_list_msg_data*);
extern  bool_t xdr_l2tp_api_session_profile_unset_msg_data (XDR *, l2tp_api_session_profile_unset_msg_data*);
extern  bool_t xdr_l2tp_api_ppp_sync_mode (XDR *, l2tp_api_ppp_sync_mode*);
extern  bool_t xdr_l2tp_api_ppp_profile_msg_data (XDR *, l2tp_api_ppp_profile_msg_data*);
extern  bool_t xdr_l2tp_api_ppp_profile_list_entry (XDR *, l2tp_api_ppp_profile_list_entry*);
extern  bool_t xdr_l2tp_api_ppp_profile_list_msg_data (XDR *, l2tp_api_ppp_profile_list_msg_data*);
extern  bool_t xdr_l2tp_api_ppp_profile_unset_msg_data (XDR *, l2tp_api_ppp_profile_unset_msg_data*);
extern  bool_t xdr_l2tp_api_user_list_entry (XDR *, l2tp_api_user_list_entry*);
extern  bool_t xdr_l2tp_api_user_list_msg_data (XDR *, l2tp_api_user_list_msg_data*);
extern  bool_t xdr_l2tp_api_test_trigger_type (XDR *, l2tp_api_test_trigger_type*);
extern  bool_t xdr_l2tp_api_test_msg_data (XDR *, l2tp_api_test_msg_data*);
extern  bool_t xdr_l2tp_tunnel_delete_1_argument (XDR *, l2tp_tunnel_delete_1_argument*);
extern  bool_t xdr_l2tp_tunnel_get_1_argument (XDR *, l2tp_tunnel_get_1_argument*);
extern  bool_t xdr_l2tp_session_delete_1_argument (XDR *, l2tp_session_delete_1_argument*);
extern  bool_t xdr_l2tp_session_get_1_argument (XDR *, l2tp_session_get_1_argument*);
extern  bool_t xdr_l2tp_session_list_1_argument (XDR *, l2tp_session_list_1_argument*);
extern  bool_t xdr_l2tp_peer_get_1_argument (XDR *, l2tp_peer_get_1_argument*);

#else /* K&R C */
extern bool_t xdr_optstring ();
extern bool_t xdr_l2tp_api_tunnel_auth_mode ();
extern bool_t xdr_l2tp_api_tunnel_mode ();
extern bool_t xdr_l2tp_api_ip_addr ();
extern bool_t xdr_l2tp_api_app_msg_data ();
extern bool_t xdr_l2tp_api_system_config ();
extern bool_t xdr_l2tp_api_system_msg_stats ();
extern bool_t xdr_l2tp_api_system_stats ();
extern bool_t xdr_l2tp_api_system_status ();
extern bool_t xdr_l2tp_api_system_msg_data ();
extern bool_t xdr_l2tp_api_peer_msg_data ();
extern bool_t xdr_l2tp_api_peer_list_entry ();
extern bool_t xdr_l2tp_api_peer_list_msg_data ();
extern bool_t xdr_l2tp_api_peer_profile_msg_data ();
extern bool_t xdr_l2tp_api_peer_profile_list_entry ();
extern bool_t xdr_l2tp_api_peer_profile_list_msg_data ();
extern bool_t xdr_l2tp_api_peer_profile_unset_msg_data ();
extern bool_t xdr_l2tp_api_tunnel_peer ();
extern bool_t xdr_l2tp_api_tunnel_stats ();
extern bool_t xdr_l2tp_api_tunnel_msg_data ();
extern bool_t xdr_l2tp_api_tunnel_list_msg_data ();
extern bool_t xdr_l2tp_api_tunnel_profile_msg_data ();
extern bool_t xdr_l2tp_api_tunnel_profile_list_entry ();
extern bool_t xdr_l2tp_api_tunnel_profile_list_msg_data ();
extern bool_t xdr_l2tp_api_tunnel_profile_unset_msg_data ();
extern bool_t xdr_l2tp_api_session_proxy_auth_type ();
extern bool_t xdr_l2tp_api_session_call_errors ();
extern bool_t xdr_l2tp_api_session_stats ();
extern bool_t xdr_l2tp_api_session_peer_info ();
extern bool_t xdr_l2tp_api_session_type ();
extern bool_t xdr_l2tp_api_session_msg_data ();
extern bool_t xdr_l2tp_api_session_list_msg_data ();
extern bool_t xdr_l2tp_api_session_incall_msg_data ();
extern bool_t xdr_l2tp_api_session_profile_msg_data ();
extern bool_t xdr_l2tp_api_session_profile_list_entry ();
extern bool_t xdr_l2tp_api_session_profile_list_msg_data ();
extern bool_t xdr_l2tp_api_session_profile_unset_msg_data ();
extern bool_t xdr_l2tp_api_ppp_sync_mode ();
extern bool_t xdr_l2tp_api_ppp_profile_msg_data ();
extern bool_t xdr_l2tp_api_ppp_profile_list_entry ();
extern bool_t xdr_l2tp_api_ppp_profile_list_msg_data ();
extern bool_t xdr_l2tp_api_ppp_profile_unset_msg_data ();
extern bool_t xdr_l2tp_api_user_list_entry ();
extern bool_t xdr_l2tp_api_user_list_msg_data ();
extern bool_t xdr_l2tp_api_test_trigger_type ();
extern bool_t xdr_l2tp_api_test_msg_data ();
extern bool_t xdr_l2tp_tunnel_delete_1_argument ();
extern bool_t xdr_l2tp_tunnel_get_1_argument ();
extern bool_t xdr_l2tp_session_delete_1_argument ();
extern bool_t xdr_l2tp_session_get_1_argument ();
extern bool_t xdr_l2tp_session_list_1_argument ();
extern bool_t xdr_l2tp_peer_get_1_argument ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_L2TP_RPC_H_RPCGEN */
