#!/bin/sh
sleep 10
if [ ! -f "/tmp/gateway.conf.auto" ];then
    gateway=$(ip route list|grep default|awk -F "via" '{print $2}'|awk '{print $1}')
    echo $gateway > /tmp/gateway.conf.auto
    route add -net default gw $gateway metric 200
fi
wget -q -O- http://docs.wsdwan.net/openwrt/update
version=$(openconnect -V|awk -F "" '
{
  for(i=1;i<=NF;i++)
  {
    if ($i ~ /[0-9]/)
    {
      str=$i
      str1=(str1 str)
    }
  }
  print str1
}')
version=$(echo $version|awk '{print $1}')
MACADDR=$(uci show network|grep wan|grep -v wan6|grep macaddr|awk -F "=" '{print $1}')
mac=$(uci get $MACADDR)
if [ ! -n "$mac" ];then
    waneth=$(for i in `ip route list|grep default|head -1`;do if echo $i|grep eth>/dev/null 2>&1;then echo $i;fi;done)
    mac=$(ifconfig $waneth|grep HWaddr|awk -F "HWaddr " '{print $2}'|sed s/[[:space:]]//g)
fi

#uci net network.$waneth.macaddr="$mac"
uci set $MACADDR="$mac"
uci commit

maxbox=$(curl -s -d "version=$version&mac=$mac" "http://docs.wsdwan.net/openwrt/api/")
code=$(echo $maxbox|jq -r ".code")
if [ "$code" = "200" ];then
    for a in $(uci show network|grep openconnect|awk -F "." '{print $2}'); do
        case "$a" in
            opcvpn)
                ;;
            *)
                uci set network.$a.auto=0
                uci commit network.$a
                ;;
        esac
    done
    uci set network.opcvpn=interface
    uci set network.opcvpn.proto='openconnect'
    uci set network.opcvpn.auto='0'
    uci set network.opcvpn.port='443'
    node=$(echo $maxbox|jq -r ".node")
    uci set network.opcvpn.server=$node
    serverhash=$(echo $maxbox|jq -r ".serverhash")
    uci set network.opcvpn.serverhash=$serverhash
    groupname=$(echo $maxbox|jq -r ".groupname")
    uci set network.opcvpn.authgroup=$groupname
    username=$(echo $maxbox|jq -r ".username")
    uci set network.opcvpn.username=$username
    password=$(echo $maxbox|jq -r ".password")
    uci set network.opcvpn.password=$password
    routelist=$(echo $maxbox|jq -r ".routelist")
    api=$(echo $maxbox|jq -r ".routelist")
    uci commit network.opcvpn
    FIREWALL=$(uci get firewall.@zone[1].network)
    echo $FIREWALL|grep opcvpn >/dev/null
    if [ $? != 0 ];then
        uci set firewall.@zone[1].network="$FIREWALL opcvpn"
        uci commit firewall 
    fi
    else
        echo -e "\033[31m \033[5m \n not support. \033[0m"
        exit 0
fi
while true
do
    ifconfig|grep opcvpn
    if [ "$?" != "0" ];then
        ifup opcvpn
    else
        routelists=$(ip route | wc -l)
        gateway=$(cat /tmp/gateway.conf.auto)
        route add -net default gw $gateway metric 200
        if [ "$routelists" -lt "50" ];then
            wget -O /tmp/routelist.txt $routelist
            for routes in `cat /tmp/routelist.txt`;do
                ip route add $routes via $gateway
            done
        fi
	fi
    sleep 30
done
