
#include <stdio.h>
#include <fcntl.h>
#include <linux/reboot.h>
#include <sys/ioctl.h>

/*
 * structure used at regsitration
 */
typedef struct {
	unsigned int irq;	//request irq pin number
	pid_t pid;	//process id to notify
} ralink_gpio_reg_info;

#define RALINK_GPIO_SET_DIR_IN          0x11
#define RALINK_GPIO_SET_DIR_OUT         0x12
#define RALINK_GPIO_READ                0x02
#define RALINK_GPIO_WRITE               0x03
#define RALINK_GPIO_REG_IRQ             0x0A

#define RALINK_GPIO6332_SET_DIR         0x51
#define RALINK_GPIO6332_SET_DIR_IN      0x13
#define RALINK_GPIO6332_SET_DIR_OUT     0x14
#define RALINK_GPIO6332_READ            0x52
#define RALINK_GPIO6332_WRITE           0x53
#define RALINK_GPIO6332_SET             0x22
#define RALINK_GPIO6332_CLEAR           0x32

#define RESET_BIT (6)
#define RESET_CNT (5)

int main(int argc, char *argv[])
{
	int fd;
	unsigned int gpioState;
	int press_cnt;

	fd = open("/dev/gpio", O_RDWR);
	if (fd < 0) 
	{
		perror("Open Error!\n");
		return -1;
	}

	if (ioctl(fd, RALINK_GPIO6332_SET_DIR_IN, (0x1 << RESET_BIT)) == -1)
	{
		printf("set direction of reset failed\n");
		return -1;
	}

	press_cnt = 0;
	while (1)
	{
		if (ioctl(fd, RALINK_GPIO6332_READ, &gpioState) == -1)
		{
			perror("Read reset state failed\n");
		}
		else
		{
			if (gpioState & (0x1 << RESET_BIT))
			{
				if (press_cnt >= RESET_CNT)
				{
					system("rm /overlay/* -rf");
					reboot(LINUX_REBOOT_CMD_RESTART);
				}
				press_cnt = 0;
			}
			else
			{
				press_cnt++;
			}
		}
		sleep(1);
	}

	return 0;
}

