local utl = require "luci.util"
local sys = require "luci.sys"
local fs  = require "nixio.fs"
local ip  = require "luci.ip"
local nw  = require "luci.model.network"

local s, n, m, Node, selectroute, subnets, routes
luci.sys.call("/etc/init.d/wsdwan start > /dev/null")
m = Map("wsdwan", translate("wsdwan - Configuration"),
	translate("wsdwan is a lightweight and efficient intelligent CPE management tool."))

n = m:section(TypedSection, "config")
n.anonymous = true
n.addremove = false
n:tab("general", translate("General Settings"))
license = n:taboption("general", Value, "license", translate("License"))
license.placeholder = "license..."

apitoken = n:taboption("general", Value, "apitoken", translate("APItoken"), translate("Get License & APItoken from :   <a href=https://www.wsdwan.com target=_blank>http://www.wsdwan.com</a>"))
apitoken.placeholder = "apitoken..."

if luci.sys.call("/usr/sbin/wsdwan checkexp > /dev/null ") == 0 then
expirationtime = n:taboption("general", DummyValue, "expirationtime", translate("Expiration Time"), translate("CPE network will not work normally after expiration."))
end

enable = n:taboption("general", Flag, "enable", translate("Enable"))
enable.default = enable.disabled


s = m:section(TypedSection, "config")
s.anonymous = true
s.addremove = false

s:tab("advanced", translate("Advanced Settings"))



Node = s:taboption("advanced", ListValue, "_Node", translate("Select node"))
Node:depends("enable", "1")
Node:value("auto", translate("Auto"))
Node:value("china", translate("China"))
Node:value("hongkong", translate("HongKong"))

Node.cfgvalue = function(self, cfg)
	local val = m:get(cfg, "node") or ""
	if val:match("hongkong") then
		return "hongkong"
	end
	if val:match("china") then
		return "china"
	end
	return "auto"
end

Node.write = function(self, cfg, val)
	if Node:formvalue(cfg) == "china" then
		m:set(cfg, "node", "china")
	elseif Node:formvalue(cfg) == "hongkong" then
		m:set(cfg, "node", "hongkong")
	else
		m:set(cfg, "node", "auto")
	end
end




selectroute = s:taboption("advanced", ListValue, "selectroute", translate("Select Route"))
selectroute:depends("enable", "1")
selectroute:value("1", translate("Auto"))
selectroute:value("2", translate("To Global"))
selectroute:value("3", translate("To China"))
selectroute:value("4", translate("Custom"))
selectroute.write = function(self, cfg, val)
	if selectroute:formvalue(cfg) == "1" then
		m:set(cfg, "selectroute", "1")
	else
		m:set(cfg, "selectroute", "2")
	end
end
selectroute.cfgvalue = function(self, cfg)
	local val = m:get(cfg, "selectroute") or ""
	if val:match("2") then
		return "2"
	end
	return "1"
end

subnets = s:taboption("advanced", DynamicList, "subnets", translate("Local subnets"),
	translate("Filter the intranet address. The address listed will not be forwarded by VPN server."))
subnets.datatype = "ipaddr"
subnets:depends("enable", "1")

--route
s:tab("route", translate("Custom Routing Table"), translate("The following routing tables are automatically loaded."))
routes = s:taboption("route", TextValue, "_routes")
routes:depends("enable", "1")
routes.rows = 30

routes.cfgvalue = function(self, cfg)
	return fs.readfile("/etc/chnroute_custom")
end

routes.write = function(self, cfg, value)
	fs.writefile("/etc/chnroute_custom", (value or ""):gsub("\r\n", "\n"))
end

routes.remove = routes.write
-- update
if luci.sys.call("/usr/sbin/wsdwan checkupdate > /dev/null ") == 1 then
	s:tab("update", translate("CPE Update"))
	version = s:taboption("update", DummyValue, "update", translate("New Version:"), translate("<font color=#378a00>New version detected.</font>"))
	checkupdate = s:taboption("update", Button, "checkupdate", translate("Version upgrade")) 
	checkupdate.inputtitle = translate("Start upgrade")
	checkupdate.inputstyle = "apply"
		
	checkupdate.write = function(self, section)
		if luci.sys.call("/usr/sbin/wsdwan upgrade > /dev/null ") == 0 then
			updatend = s:taboption("update", DummyValue, "version", translate("Update complete:"), translate("<font color=#378a00>Suggestion: restart CPE device after the update is completed. ..</font>"))
		else
			updatend = s:taboption("update", DummyValue, "version", translate("Update failed:"), translate("<font color=#378a00>Please try to update again later.</font>"))
		end
	end
end

return m