local utl = require "luci.util"
local sys = require "luci.sys"
local fs  = require "nixio.fs"
local ip  = require "luci.ip"
local nw  = require "luci.model.network"

local s, n, m, role, selectroute, subnets, routes

luci.sys.call("/usr/sbin/wsdwan checkneighbor > /dev/null")
m = Map("wsdwan", translate("wsdwan - Configuration"),
	translate("wsdwan is a lightweight and efficient intelligent CPE management tool."))
	
n = m:section(TypedSection, "config")
n.anonymous = true
n.addremove = false
n:tab("config", translate("config"))

role = n:taboption("config", ListValue, "_role", translate("Select role"))
role:value("master", translate("Master"))
role:value("slave", translate("Slave"))

role.cfgvalue = function(self, cfg)
	local val = m:get(cfg, "role") or ""
	if val:match("master") then
		return "master"
	end
	if val:match("slave") then
		return "slave"
	end
	return "master"
end

role.write = function(self, cfg, val)
	if role:formvalue(cfg) == "master" then
		m:set(cfg, "role", "master")
	elseif role:formvalue(cfg) == "slave" then
		m:set(cfg, "role", "slave")
	else
		m:set(cfg, "role", "master")
	end
end

-- neighbor
button = n:taboption("config",Button, "_button", "New Neighbor")                         
button.inputtitle = translate("Add Neighbor")                       
button.inputstyle = "apply"
function button.write(self, section, value)
	local http = require "luci.http"
	local disp = require "luci.dispatcher"
    luci.sys.call("/sbin/uci add wsdwan neighbor > /dev/null")
	luci.sys.call("/sbin/uci commit wsdwan > /dev/null")
	http.redirect(disp.build_url("admin/wsdwan/wsdwan_neighbor"))
end

s = m:section(TypedSection, "neighbor")
s.anonymous = true
s.addremove = false

s:tab("neighbor", translate("neighbor"))
neighbor = s:taboption("neighbor", Value, "license", translate("neighbor License"))

subnets = s:taboption("neighbor", DynamicList, "subnets", translate("neighbor subnets"))
subnets.datatype = "ipaddr"

enable = s:taboption("neighbor", Flag, "remove", translate("remove neighbor"))
enable.default = enable.disabled




s.optional=false;
s.rmempty = false;
return m