#!/bin/sh
iptables -F wlist_DROP
iptables -F wlist_forward
iptables -F wlist_ACCEPT

iptables -N wlist_DROP -m comment --comment wlist
iptables -A wlist_DROP -m comment --comment wlist -o eth0.2 -j DROP


iptables -N wlist_ACCEPT -m comment --comment wlist
iptables -A wlist_ACCEPT -m comment --comment wlist -o eth0.2 -j ACCEPT


iptables -N wlist_forward -m comment --comment wlist
i=0
for oldmac in `cat /etc/wlistd.user`;do
	iptables -D wlist_forward -m comment --comment wlist -m mac --mac-source $oldmac -j wlist_ACCEPT
done
	
for mac in `cat /etc/wlist.user`;do
	i=1
	iptables -I wlist_forward -m comment --comment wlist -m mac --mac-source $mac -j wlist_ACCEPT
done

if [ "$i" = "0" ];then
	echo no wlist mac add.
else
	cp /etc/wlist.user /etc/wlistd.user
	iptables -A wlist_forward -m comment --comment wlist -j wlist_DROP
	iptables -D delegate_forward -j wlist_forward
	iptables -I delegate_forward -j wlist_forward
	echo wlist add complete.
fi



