local fs = require "nixio.fs"
local f = SimpleForm("firewall",
	translate("访问控制 - MAC白名单"),
	translate("请输入允许使用公网服务的终端MAC地址。例：30:9c:23:16:03:58 <br> \
	每行一个mac地址。<br>\
	留空则为不使用白名单机制。全部放行。<br>\
	留空时请输入几个回车再保存。"))

local o = f:field(Value, "_custom")

o.template = "cbi/tvalue"
o.rows = 20

function o.cfgvalue(self, section)
	return fs.readfile("/etc/wlist.user")
end

function o.write(self, section, value)
	value = value:gsub("\r\n?", "\n")
	fs.writefile("/etc/wlist.user", value)
	luci.sys.call("sh /etc/wlist.sh > /dev/null")
end


return f
